﻿<%@ Page Title="Servers" Language="C#" MasterPageFile="../WebAppPanel.master" EnableSessionState="false" 
    AutoEventWireup="true" CodeBehind="AddServer.aspx.cs" Inherits="GladinetPayFlow.AddServer" Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">

        

    
    </style>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocYouDoNotHavThePerToBroShaOnThiSer" meta:resourcekey="str_youDoNotHavThePerToBroShaOnThiSer" Visible="false">You do not have the permission to browse shares on this server</asp:Localize>
<asp:Localize runat="server" ID="LocMisSerNam" meta:resourcekey="str_misSerNam" Visible="false">missing server name</asp:Localize>
    
    <div class="wrapper" id="DashboardView" style="overflow: auto; width: 100%; padding:20px;">
      
    <table width="100%">
        <tr>
            <td align="center">
                <asp:Panel ID="ScanResultPanle" Visible="false" runat="server">
                <div id="SLDiv" style="width:100%; max-width:800px; overflow:auto; padding:10px; border-radius:3px; border:0px solid #f0f0f0;">
                <%if (LocalSvrs.Items.Count != 0){ %>
                <table style="width:100%;">
                     <asp:Repeater ID="LocalSvrs" runat="server">
                        <ItemTemplate>
                            <tr class="filerow" style="border-bottom:1px solid #f0f0f0;">
                                <td width="32px" style="padding:4px; font-size:16px; color:#202020; font-weight:200;">
                                    <input type="checkbox" name="uu_<%# DataBinder.Eval(Container.DataItem,"Name") %>" value="<%# DataBinder.Eval(Container.DataItem,"EncodedValue") %>" />
                                </td>
                                <td style="padding:4px; font-size:14px; color:#404040; font-weight:100;" valign="middle">
                                    <%# DataBinder.Eval(Container.DataItem,"Name") %>
                                    <p style="font-size:12px; color:#565656; font-weight:100;">
                                        <%# DataBinder.Eval(Container.DataItem,"DisplayNote") %> 
                                    </p>

                                </td>
                            </tr>
                        </ItemTemplate>
                    </asp:Repeater>
                </table>
                    <%}else { %>
                    <table style="width:100%;">
                        <tr>
                            <td style="font-size:20px; color:#404040; font-weight:100;padding-top:90px;" align="center"><asp:Localize runat="server" meta:resourcekey="str_noSerFou">No Servers Found.</asp:Localize></td>
                        </tr>
                        <tr>
                            <td align="center" style="padding-top:20px;font-size:16px; color:#565656; font-weight:100;">
                                <asp:Panel ID="ADPanel" runat="server">
                                <asp:Localize runat="server" meta:resourcekey="str_weCanRetFroAD">We can retrieve the servers list from your Active Directory, please click</asp:Localize> <asp:LinkButton ID="EnableADBtn" runat="server" OnClientClick="OnEnableAD();return false;" meta:resourcekey="str_her">here</asp:LinkButton> to enable Active Directory integration.
                                    </asp:Panel>
                            </td>
                        </tr>
                        <tr>
                            <td align="center" style="padding-top:40px;">
                                <asp:LinkButton CssClass="btn btn-primary gladmbtn" ID="LinkButton6" runat="server" OnClick="ManulAddSvr_Click" meta:resourcekey="str_addSerMan">Add Server Manually</asp:LinkButton>
                                <asp:LinkButton CssClass="btn btn-primary gladmbtn" ID="LinkButton5" runat="server" OnClick="Rescan_Click" OnClientClick="Wait('...');" meta:resourcekey="str_res">Re-Scan</asp:LinkButton>
                                <asp:LinkButton CssClass="btn btn-primary gladmbtn" ID="LinkButton4" runat="server"  OnClientClick="OnCancel();return false;" meta:resourcekey="str_can">Cancel</asp:LinkButton>
                            </td>
                        </tr>
                    </table>
                    <%} %>
                    </div>
                    <%if (LocalSvrs.Items.Count != 0){ %>
                    <table style="width:100%; position:absolute; bottom:30px; ">
                        <tr>
                            <td align="center">
                                <table style="width:100%; max-width:800px">
                                    <tr>
                            <td style="height:64px;padding-right:10px;" valign="middle">
                                <%if(!IsMobile()){ %>
                                <table >
                                                    <tr>
                                                        <td>
                                                            <a class="btn btn-primary gladmbtn" href="#" onclick="SelectAll();return false;" style="padding-left: 10px; padding-right: 10px;"
                                                                >
                                                                <asp:Localize ID="Localize2" meta:resourcekey="str_selall" runat="server">Select All</asp:Localize>
                                                            </a>
                                                        </td>
                                                        <td>
                                                            <a class="btn btn-primary gladmbtn" href="#" onclick="DeSelectAll();return false;" style="padding-right: 10px; ">
                                                                <asp:Localize ID="Localize3" meta:resourcekey="str_desel" runat="server">Deselect All</asp:Localize>
                                                            </a>
                                                        </td>
                                                        <td>
                                                            <a class="btn btn-primary gladmbtn" href="#" onclick="ReSelectAll();return false;" style="padding-right: 10px; ">
                                                                <asp:Localize ID="Localize4" meta:resourcekey="str_undosel" runat="server">Undo Selection</asp:Localize>
                                                            </a>
                                                        </td>
                                                      
                                                        <td >
                                                            <asp:LinkButton CssClass="btn btn-primary gladmbtn" ID="LinkButton2" runat="server" OnClick="Rescan_Click" OnClientClick="Wait('...');" meta:resourcekey="str_res">Re-Scan</asp:LinkButton>
                                                        </td>
                                                    </tr>
                                                </table>
                                <%} %>
                                
                            </td>
                            <td style="height:64px;padding-right:10px;" align="right" valign="middle">
                                <asp:LinkButton CssClass="btn btn-primary gladmbtn" ID="AddSelected" runat="server" OnClick="AddSelected_Click" OnClientClick="Wait('...');" meta:resourcekey="str_add">Add</asp:LinkButton>
                                <asp:LinkButton CssClass="btn btn-default gladmbtn" ID="LinkButton10" runat="server" OnClick="CancelAddBtn_Click" meta:resourcekey="str_bac">Back</asp:LinkButton>
                                <asp:LinkButton CssClass="btn btn-primary gladmbtn" ID="LinkButton3" runat="server"  OnClientClick="OnCancel();return false;" meta:resourcekey="str_can">Cancel</asp:LinkButton>
                                
                            </td>
                        </tr>
                                </table>
                            </td>
                        </tr>
                        
                    </table>
                     <%} %>
                </asp:Panel>
               <asp:Panel ID="InitialPanel"  runat="server">
                <table style="width:100%; max-width:800px; ">
                    <tr>
                        <td height="10px">&nbsp;</td>
                    </tr>
                    <tr >
                        <td style="padding:5px; padding-top:40px;" align="center">
                            <asp:LinkButton CssClass="btn btn-primary gladmbtn" ID="ManulAddSvr" runat="server" OnClick="ManulAddSvr_Click" meta:resourcekey="str_addSerMan">Add Server Manually</asp:LinkButton>
                            <p class="hintlabel"><asp:Localize runat="server" meta:resourcekey="str_addSerManEntSer">Add the server manually by entering the server name and related server information.</asp:Localize></p>

                        </td>
                    </tr>
                    <tr>
                        <td style="padding:5px; padding-top:20px;" align="center">
                            <asp:LinkButton CssClass="btn btn-primary gladmbtn" ID="LinkButton1" runat="server" OnClick="LinkButton1_Click" OnClientClick="Wait('...');" meta:resourcekey="str_scaFilSer">Scan File Servers</asp:LinkButton>
                            <p class="hintlabel"><asp:Localize runat="server" meta:resourcekey="str_scaAndDisFilSer">Scan and discover file servers nearby for easy selection later.</asp:Localize></p>

                        </td>
                    </tr>
                     <tr>
                            <td align="center" style="padding-top:20px;font-size:16px; color:#565656; font-weight:100;">
                                
                                <asp:Panel ID="ADInitPanel" runat="server">
								<asp:Localize runat="server" meta:resourcekey="str_canRetSerLisFro">We can retrieve the servers list from your Active Directory, please</asp:Localize>
                                 <asp:LinkButton ID="LinkButton7" runat="server" OnClientClick="OnEnableAD();return false;" meta:resourcekey="str_cliHer">click here</asp:LinkButton> <asp:Localize runat="server" meta:resourcekey="str_enaActDirInt">to enable Active Directory integration.</asp:Localize></asp:Panel>
                                
                            </td>
                        </tr>
                    <tr>
                            <td align="center" style="padding-top:20px;font-size:16px; color:#565656; font-weight:100;">
                                
                                <asp:LinkButton CssClass="btn btn-primary gladmbtn" ID="LinkButton8" runat="server" OnClientClick="OnCancel();return false;" meta:resourcekey="str_retSer">Return to Servers</asp:LinkButton>
                                
                            </td>
                        </tr>
                </table>
                
                </asp:Panel>
                <asp:Panel ID="ManualAddPanel"  runat="server" Visible="false" DefaultButton="AddSvrBtn">
                    <table style="width:100%; max-width:600px; ">
                    <tr>
                        <td  style="padding:10px; padding-left:0px; font-size:18px; color:#404040; font-weight:100;"><asp:Localize runat="server" meta:resourcekey="str_entFilSerInf">Enter the file server information</asp:Localize></td>
                    </tr>
                        <tr><td height="20px">&nbsp;</td></tr>
                        <tr>
                                <td style="padding:5px; font-size:16px; font-weight:200; color:#565656"><asp:Localize runat="server" meta:resourcekey="str_serNam">Server Name</asp:Localize></td>
                            </tr>
                                                        <tr>
                                <td style="padding:5px;  font-size:16px; font-weight:100; color:#565656">
                                    <asp:TextBox ID="SvrName" runat="server" CssClass="form-control"></asp:TextBox>
                                    <asp:RegularExpressionValidator ID="rxvSvrName" ControlToValidate="SvrName" runat="server" ValidationExpression="[A-Za-z0-9\.\:\-_ ]+" Display="Dynamic" ErrorMessage="Invalid server name (must be a valid BIOS or DNS name)" meta:resourcekey="rxvSvrName_msg" ForeColor="Red"></asp:RegularExpressionValidator>
                                </td>
                            </tr>
                            <tr>
                                <td style="padding:5px; font-size:16px; font-weight:100; color:#565656"><asp:Localize runat="server" meta:resourcekey="str_useNam">User Name</asp:Localize></td>
                            </tr>
                                                        <tr>
                                <td style="padding:5px;  font-size:16px; font-weight:100; color:#565656">
                                    <asp:TextBox ID="SvrUserName" runat="server" CssClass="form-control"></asp:TextBox>
                                </td>
                            </tr>
                            <tr><td height="10px">&nbsp;</td></tr>
                            <tr>
                                <td style="padding:5px; font-size:16px; font-weight:100; color:#565656"><asp:Localize runat="server" meta:resourcekey="str_pas">Password</asp:Localize></td>
                            </tr>
                                                        <tr>
                                <td style="padding:5px; font-size:16px; font-weight:100; color:#565656">
                                    <asp:TextBox ID="SvrPassword" TextMode="Password" runat="server" CssClass="form-control"></asp:TextBox>
                                </td>
                            
                            </tr>
                            <tr><td height="10px">&nbsp;</td></tr>
                            <tr><td>
                                <asp:Label ID="ErrorMsg" runat="server" Text="" ForeColor="Red"></asp:Label>
                                </td></tr>
                            <tr>
                                <td align="right" style="padding:10px">
                                    <asp:LinkButton CssClass="btn btn-primary gladmbtn" ID="AddSvrBtn" runat="server" OnClick="AddSvrBtn_Click" meta:resourcekey="str_app">Apply</asp:LinkButton>
                                    <asp:LinkButton CssClass="btn btn-default gladmbtn" ID="LinkButton9" runat="server" OnClick="CancelAddBtn_Click" meta:resourcekey="str_bac">Back</asp:LinkButton>
                                    <asp:LinkButton CssClass="btn btn-default gladmbtn" ID="CancelAddBtn" runat="server" OnClientClick="OnCancel(); return false;" meta:resourcekey="str_can">Cancel</asp:LinkButton>
                                    
                                </td>
                            </tr>

                  </table>
                </asp:Panel>

            </td>
        </tr>
    </table>
            
    </div>
    <script type="text/javascript">

        function OnEnableAD() {
            window.location = "ServoLDAPEnable.aspx?child=1&bk=fs";
        }
        function adjust() {

            var f = document.getElementById('DashboardView');
            f.style.height = (document.documentElement.clientHeight -10) + "px";
       
            f = document.getElementById('SLDiv');
            f.style.height = (document.documentElement.clientHeight - 144) + "px";
            

        }
        adjust();

        function SelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].name.indexOf("uu_") == -1)
                    continue;
                if (Users[i].style.display == 'none') {
                    continue;
                }
                if (Users[i].type == "checkbox") {
                    Users[i].checked = true;
                }
            }
        }

        function DeSelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].name.indexOf("uu_") == -1)
                    continue;
                if (Users[i].style.display == 'none')
                    continue;

                if (Users[i].type == "checkbox") {
                    Users[i].checked = false;
                }
            }
        }
        function OnAddCloudFileServer() {
            window.location = "AddCloudFileServer.aspx";
        }

        function OnCancel() {
            
            window.location = "ServersMgr.aspx";
        }
        function ReSelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox") {
                    if (Users[i].name.indexOf("uu_") == -1)
                        continue;
                    if (Users[i].style.display == 'none')
                        continue;
                    Users[i].checked = !Users[i].checked;
                }
            }
        }


</script>
</asp:Content>
