﻿<%@ Page Title="Gladinet Cloud Cluster" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="SelectStoragePage.aspx.cs" Inherits="GladinetPayFlow.SelectStoragePage" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">

    <style type="text/css">
        td {
            font-size: 15px;
            font-weight: 100;
        }

        b {
            font-weight: 500;
        }

        .badgefont {
            font-size: 15px;
        }

        .light {
            font-weight: 100;
            padding: 0px !important;
        }
    </style>
    <style type="text/css">
        .pricetable {
            border: 1px solid #cccccc;
        }

        .plain9BlackOnNone {
            border-bottom: 1px solid #cccccc;
            border-right: 1px solid #cccccc;
        }

        .offer_flex {
            background: #FFFFE0 url('images/giftbox.png') no-repeat 8px center;
            border: 1px solid #E6DB55;
            border-radius: 4px 4px 4px 4px;
            color: #000000;
            height: 54px;
            line-height: 18px;
            padding: 2px;
            padding-left: 16px;
            width: 868px;
            vertical-align: middle;
            text-align: center;
            margin: auto;
            margin-bottom: 16px;
        }

        .offertitle {
            line-height: 24px;
        }

        .offertext {
            line-height: 20px;
        }

        .offer_flex1 {
            border: 1px solid #E6DB55;
            border-radius: 4px 4px 4px 4px;
            margin: auto;
        }

        * {
            margin: 0;
            padding: 0;
        }

        html, body {
            height: 100%;
        }

        .main, #aspnetForm {
            height: 100%;
        }

        .wrapper {
            padding: 0px;
            background-color: white;
        }

        .footer, .push {
            height: 68px; /* .push must be the same height as .footer */
        }

        .light {
            font-weight: 100 !important;
        }

        .whitehead {
            background-color: white !important;
        }

        .panel-heading .gladinet-icons {
            margin-left: 5px;
        }

            .panel-heading .gladinet-icons.exp {
                margin-left: 0px;
                margin-right: 5px;
            }

        .panel-heading .tooltip {
            margin: 10px 0px 0px 0px;
            background-color: white;
        }
    </style>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocFaiToLoa" meta:resourcekey="str_faiToLoa" Visible="false">Failed to load</asp:Localize>
     <asp:Localize id="LocFldLodShr" meta:resourcekey="str_fldLodShr" runat="server" Visible="false">Failed to load shares</asp:Localize>
     <asp:Localize id="LocFldPrsShrLst" meta:resourcekey="str_fldPrsShrLst" runat="server" Visible="false">Failed to parse share list</asp:Localize>
     <asp:Localize id="LocUsrNmeMsg" meta:resourcekey="str_usrNmeMsg" runat="server" Visible="false">User name is missing</asp:Localize>
     <asp:Localize id="LocPwdMsg" meta:resourcekey="str_pwdMsg" runat="server" Visible="false">Password is missing</asp:Localize>
     <asp:Localize id="LocAcsDnd" meta:resourcekey="str_acsDnd" runat="server" Visible="false">Access is denied</asp:Localize>
     <asp:Localize id="LocMsgSrvNme" meta:resourcekey="str_msgSrvNme" runat="server" Visible="false">Missing server name</asp:Localize>


    <script type="text/javascript">
        showLoader();


        function ClickSvr(name, hid, fqdn) {
            var b = document.getElementById("ctl00_MainContent_QueryShares");
            var n = document.getElementById("ctl00_MainContent_ServerName");
            var f = document.getElementById("ctl00_MainContent_ServerFQDN");
            var i = document.getElementById("ctl00_MainContent_ServerInstanceId");

            n.value = name;
            f.value = fqdn;
            i.value = hid;
            Wait('Loading...');
            b.click();
        }

        function DeleteOwnSvr(name) {
            var b = document.getElementById("ctl00_MainContent_RemoveOwnSvr");
            var n = document.getElementById("ctl00_MainContent_ServerName");
            n.value = name;
            Wait('Loading...');
            b.click();
        }

        function ClickCloud(name) {
            var b = document.getElementById("ctl00_MainContent_SelectCloud");
            var n = document.getElementById("ctl00_MainContent_ShareName");

            n.value = name;

            Wait('Loading...');
            b.click();

        }
        function ClickShare(name, path, fqdn) {
            var b = document.getElementById("ctl00_MainContent_SelectShare");
            var n = document.getElementById("ctl00_MainContent_ShareName");
            var p = document.getElementById("ctl00_MainContent_SharePath");
            var f = document.getElementById("ctl00_MainContent_CurrentFQDN");

            f.value = fqdn;
            n.value = name;
            p.value = path;

            Wait('Loading...');
            b.click();
        }

        function DownloadSA() {

            var win = new Ext.Window({
                id: 'download_win',
                title: "<asp:Localize meta:resourcekey="js_string2" runat="server">Download Native Clients</asp:Localize>",
                width: 1000,
                height: maxh(686),
            plain: true,
            modal: true,
            maximizable: true,
            constrain: true,
            resizable: true,
            bodyPadding: 5,
            html: "<iframe id='openwin' src='/portal/downloadpage.aspx?serveronly=1&vdid=<%=SessionDomainId%>' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0;border:0;'></iframe>",
                defaults: {
                    border: false
                }
            }).show();
            }

            function OnImportShareName() {
                var r = "ImportShareName.aspx?c=1&vdid=<%= SessionDomainId %>";
            <%if (SessionUnifiedWizAttachStorage) {%>
            r = "AddLocalStorage.aspx?vdid=<%= SessionDomainId %>";
            <%} %>
            window.location = r;
        }
    </script>
    
 <div class="wrapper" id="maindiv" style="overflow: auto; ">
    <asp:Panel ID="NamePanel" runat="server" meta:resourcekey="NamePanelResource1">
        <table width="100%"  style="background-color: white;"
            align="center">
                <tr>
                <td  style="height: 48px;color: #808080;border-bottom: 1px solid #c0c0c0;
                    border-top: 0; border-left: 0; border-right: 0;  padding:0;padding-left: 16px; vertical-align: middle;
                    text-align: left; font-size: 16px;;margin:0">
                    <table width="100%">
                        <tr>
                            <td style="font-size: 16px;">
                                <% if (SharesPanel.Visible)
                                { %>
                                <table>
                                    <tr>
                                        <td>
                                            <a href="SelectStoragePage.aspx?vdid=<%= SessionDomainId %>" style="color: #565656">
                                                <h1 style="font-size: 24px; font-weight: 100;">
                                                    <asp:Localize ID="Localize3" meta:resourcekey="str_filevsrs" runat="server">File Servers</asp:Localize></h1>
                                            </a>
                                        </td>
                                        <td>
                                            <h1 style="font-size: 24px; font-weight: 100;">
                                                <asp:Label ID="FileSvrName" runat="server" meta:resourcekey="FileSvrNameResource1"></asp:Label>
                                            </h1>
                                        </td>
                                    </tr>
                                </table>


                                <% }
                                else
                                { %>
                                <table>
                                    <tr>
                                        <td>
                                            <asp:Label ID="FileSvrLable" runat="server" Text="Storage Locations" Visible="False" meta:resourcekey="FileSvrLableResource1"></asp:Label>
                                            <h1 class="glabel2">
                                                <%if (!WizardImportShareNow)
                                                { %>
                                                <% if (!SessionUnifiedWizAttachStorage)
                                                { %>
                                                <asp:Localize meta:resourcekey="str_tfn" runat="server">Team Folder </asp:Localize>
                                                <% } %>
                                                <%=FileSvrLable.Text%>
                                                <%}
                                                else
                                                { %>
                                                <%=Localize3.Text%>
                                                <% } %>
                                            </h1>
                                            <span style="color: #808080; display: none; font-size: small">
                                                <asp:Localize meta:resourcekey="str_clkToSel" runat="server">(Click to select)</asp:Localize></span>
                                        </td>
                                        <td align="5px" style="font-size: small; padding-bottom: 6px; padding-left: 5px;">
                                            <% if (!SessionUnifiedWizAttachStorage && !WizardImportShareNow)
                                                { %>
                                            <a href="javascript:;" data-toggle="modal" data-target="#StorageHelp">
                                                <asp:Localize meta:resourcekey="str_whatisthis" runat="server">(What is this?)</asp:Localize></a>
                                            <% } %>
                                        </td>
                                    </tr>
                                </table>


                                <% } %>
                            </td>
                            <td align="right" style="padding-right: 10px; width: 40px;" valign="middle">


                                <% if (SharesPanel.Visible)
                                { %>
                                <table>
                                    <tr>
                                        <td style="padding-right: 5px;">

                                            <asp:LinkButton ID="IconModeBtn" runat="server" Visible="false"
                                                OnClick="IcontMode_Click" OnClientClick="Wait('Loading...');return true;"
                                                meta:resourcekey="LinkButton6Resource1">
                                                    <span class="glyphicon glyphicon glyphicon-th-large"></span>
                                            </asp:LinkButton>
                                        </td>
                                        <td style="padding-right: 5px;">

                                            <asp:LinkButton ID="ListModeBtn" runat="server"
                                                OnClick="ListMode_Click" OnClientClick="Wait('Loading...');return true;"
                                                meta:resourcekey="LinkButton6Resource1">
                                                    <span class="glyphicon glyphicon-th-list"></span>
                                            </asp:LinkButton>
                                        </td>
                                        <td>
                                            <asp:LinkButton ID="LinkButton6" runat="server"
                                                OnClick="QueryShares_Click" OnClientClick="Wait('Loading...');return true;"
                                                meta:resourcekey="LinkButton6Resource1">
                                                    <span class="glyphicon glyphicon-refresh"></span>
                                            </asp:LinkButton>
                                        </td>
                                    </tr>
                                </table>

                                <% } %>
                                               
                                                
                            </td>
                            <td align="right" style="padding-right: 10px; width: 60px;">


                                <asp:LinkButton ID="Button3" runat="server"
                                    OnClientClick="showLoader(this.parentNode)" TabIndex="7" CssClass="btn btn-primary gladbtn"
                                    CausesValidation="False" OnClick="ButtonBack_Click"><span style="font-size:32px; font-weight:100">&times;</span></asp:LinkButton>

                            </td>
                        </tr>
                    </table>

                    
                </td>
            </tr>
            <tr>
                <td>
                    <div id="SettingsDlg" class="modal fade" role="dialog">
                        <div class="modal-dialog">

                            <!-- Modal content-->
                            <div class="modal-content" style="width: 100%;">
                                <div class="modal-header" style="background-color: #e0e0e0">
                                    <h4 class="modal-title">
                                        <asp:Localize meta:resourcekey="str_settings" runat="server" Visible="false">Settings</asp:Localize></h4>
                                    <button type="button" class="close" data-dismiss="modal">&times;</button>

                                </div>
                                <div class="modal-body">
                                    <table width="100%">
                                        <tr>
                                            <td style="padding: 5px;">
                                                <asp:CheckBox ID="DiscoverNet" runat="server"
                                                    Text="Discover network neighborhood (could be slow)"
                                                    meta:resourcekey="DiscoverNetResource1" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px;">
                                                <asp:CheckBox ID="IncludeWS" runat="server" Text="Include workstation(s)"
                                                    meta:resourcekey="IncludeWSResource1" />
                                            </td>
                                        </tr>

                                    </table>
                                </div>
                                <div class="modal-footer">
                                    <asp:Button ID="ApplySettings" runat="server" Text="Apply"
                                        OnClick="ApplySetting_Click" CssClass="btn btn-primary gladbtn"
                                        OnClientClick="Wait('Applying settings...');return true;"
                                        meta:resourcekey="ApplySettingsResource1" />
                                    <button type="button" class="btn btn-default" data-dismiss="modal">
                                        <asp:Localize meta:resourcekey="str_close" runat="server">Close</asp:Localize></button>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div id="myModal" class="modal fade" role="dialog">
                        <div class="modal-dialog">

                            <!-- Modal content-->
                            <div class="modal-content" style="width: 100%;">
                                <div class="modal-header" style="background-color: #e0e0e0">
                                    <h4 class="modal-title">
                                        <asp:Localize meta:resourcekey="str_help" runat="server">Help</asp:Localize></h4>
                                    <button type="button" class="close" data-dismiss="modal">&times;</button>

                                </div>
                                <div class="modal-body">
                                    <% if (ServersPanel.Visible)
                                    { %>
                                    <div style="padding: 10px; width: 100%;" align="left">
                                        <strong></strong>
                                        <asp:Localize meta:resourcekey="str_exp" runat="server">Click server to explore shares hosted by the server. </asp:Localize>
                                        <% if (SessionIsInstalledApp && !IsHosted)
                                            { %>
                                        <asp:Localize meta:resourcekey="str_dont" runat="server"> Don't see your server? 
                                    Click </asp:Localize>
                                        <asp:LinkButton ID="LinkButton4" runat="server" ForeColor="Green"
                                            OnClick="LinkButton4_Click" meta:resourcekey="LinkButton4Resource1"><asp:Localize meta:resourcekey="str_here" runat="server">here</asp:Localize></asp:LinkButton>
                                        <asp:Localize meta:resourcekey="str_11" runat="server">to add it manually, or  click</asp:Localize>
                                        <a style="color: #008000"
                                            onclick="OnImportShareName();return false;" href="#">
                                            <asp:Localize ID="Localize1" meta:resourcekey="str_here" runat="server">here</asp:Localize></a>
                                        <asp:Localize meta:resourcekey="str_manu" runat="server">to manually enter the share UNC.</asp:Localize>
                                        <% } %>
                                    </div>
                                    <% } %>
                                    <% if (SharesPanel.Visible)
                                    { %>
                                    <div style="padding: 10px; width: 100%; padding-bottom: 20px;" align="left">
                                        <strong></strong>
                                        <asp:Localize meta:resourcekey="str_share" runat="server">Click share to continue.</asp:Localize>
                                        <% if (SessionIsInstalledApp && !IsHosted)
                                            { %>
                                        <asp:Localize meta:resourcekey="str_12" runat="server">If your share is not listed here, you can manually enter the share UNC by clicking</asp:Localize>
                                        <a style="color: #008000"
                                            onclick="OnImportShareName();return false;" href="#">
                                            <asp:Localize ID="Localize2" meta:resourcekey="str_here" runat="server">here</asp:Localize></a>.
                                    <% } %>
                                    </div>
                                    <% } %>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default" data-dismiss="modal">
                                        <asp:Localize meta:resourcekey="str_close" runat="server">Close</asp:Localize></button>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div id="StorageHelp" class="modal fade" role="dialog">
                        <div class="modal-dialog">

                            <!-- Modal content-->
                            <div class="modal-content" style="width: 100%;">
                                <div class="modal-header" style="background-color: #e0e0e0">
                                    <h4 class="modal-title">
                                        <asp:Localize meta:resourcekey="str_sl" runat="server">Storage Location</asp:Localize></h4>
                                    <button type="button" class="close" data-dismiss="modal">&times;</button>

                                </div>
                                <div class="modal-body">
                                    <asp:Localize meta:resourcekey="str_existhint" runat="server">Pick a storage for your team folder which can be an existing network share directly accessible in your local area network. It can also be a share on a remote file server connected indirectly via CentreStack's Server Agent software or a storage location from a cloud storage service provider.</asp:Localize>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default" data-dismiss="modal">
                                        <asp:Localize ID="Localize4" meta:resourcekey="str_close" runat="server">Close</asp:Localize></button>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div>
                        <%if (!string.IsNullOrEmpty(ErrorMsg.Text))
                            { %>
                        <br />
                        <asp:Label ID="ErrorMsg" runat="server" CssClass="errmsg"
                            meta:resourcekey="ErrorMsgResource1"></asp:Label>
                        <%} %>
                    </div>
                </td>
            </tr>
            
            <tr>
                <td>
                    <asp:Panel ID="ServersPanel" runat="server" 
                        meta:resourcekey="ServersPanelResource1">
                 <div style="height: 10px;"></div>
                        <%if (!SessionUnifiedWizAttachStorage && !WizardImportShareNow){ %>
                        <div class="panel-group" style="padding: 10px; padding-bottom: 25px;">
                            <div class="panel whitehead" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                <div class="panel-heading whitehead">
                                    <a data-toggle="collapse" href="#ExTen">

                                        <table>
                                            <tr>
                                                <td width="20px" valign="middle" style="padding-top: 3px;">
                                                    <i id="ExTenIco" class="gladinet-icons md-24 md-dark hand exp">Ù</i>
                                                </td>
                                                <td valign="middle" title="<%=str_existh.Text %>">
                                                    <asp:Localize meta:resourcekey="str_exist" runat="server">Existing Tenant Storage</asp:Localize>
                                                    <asp:Localize meta:resourcekey="str_existh" runat="server" ID="str_existh" Visible="False">Create a team folder from default tenant storage or tenant home storage</asp:Localize>
                                                </td>
                                            </tr>
                                        </table>
                                    </a>
                                </div>
                                <div id="ExTen" class="panel-collapse collapse fade" style="padding-bottom: 10px;">
                                    <div class="text-center topbuffer" style="padding-left: 15px; padding-top: 20px;">

                                        <table>
                                            <tr>
                                                <td align="center" height="24px">
                                                    <i class="gladinet-icons md-53 md-dark hand">+</i>
                                                </td>

                                                <td align="left" height="24px" style="padding-left: 10px;">

                                                    <a href="/management/CreateTeamFolder.aspx?vdid=<%=SessionDomainId %>" title="<%=def_help.Text %>">
                                                        <asp:Localize ID="Localize8" meta:resourcekey="str_defts" runat="server">Default Tenant Storage</asp:Localize>
                                                    </a>
                                                    <p style="color: #565656; font-size: 12px">
                                                        <asp:Localize meta:resourcekey="str_defhelp" ID="def_help" runat="server">Create a new team folder from scratch using default storage. It will be empty to start with and you can put files and folders inside later.</asp:Localize></p>
                                                    <asp:Localize meta:resourcekey="str_ces" Visible="False" ID="str_ces" runat="server">Convert Existing File Share as Team Folder</asp:Localize>
                                                    <asp:Localize meta:resourcekey="str_csa" Visible="False" ID="str_csa" runat="server">Migrate Existing Network Share as Team Folder via Server Agent</asp:Localize>

                                                </td>
                                            </tr>
                                        </table>

                                    </div>
                                    <div class="text-center topbuffer" style="padding-left: 15px; padding-top: 20px;">

                                        <table>
                                            <tr>
                                                <td align="center" height="24px">
                                                    <i class="gladinet-icons md-53 md-dark hand">&#xAB;</i>
                                                </td>

                                                <td align="left" height="24px" style="padding-left: 10px;">

                                                    <a href="/management/CreateTeamFolder.aspx?vdid=<%=SessionDomainId %>&wp=1" title="<%=def_help.Text %>">
                                                        <asp:Localize meta:resourcekey="str_wspace" runat="server" Visible="False">Work Space</asp:Localize>
                                                        <asp:Localize meta:resourcekey="str_extFld" runat="server">Existing Folder(s)</asp:Localize>

                                                    </a>
                                                    <p style="color: #565656; font-size: 12px">
                                                        <asp:Localize meta:resourcekey="str_cnewwok" runat="server">Create a new team folder by selecting one or more existing folders. Those selected folders will show up inside the team folder.</asp:Localize>

                                                    </p>

                                                </td>
                                            </tr>
                                        </table>

                                    </div>
                                    <%if (m_ShowPublishStorageAsTeamFolder && !m_NoTentantTF){ %>
                                    <div class="text-center topbuffer" style="padding-left: 15px; padding-top: 20px;">

                                        <table>
                                            <tr>
                                                <td align="center" height="24px">
                                                    <i class="gladinet-icons md-53 md-dark hand">^</i>
                                                </td>

                                                <td align="left" height="24px" style="padding-left: 10px;">

                                                    <a href="/management/CreateTeamFolder.aspx?vdid=<%=SessionDomainId %>&location=/73659E5F-F5F0-4D49-A637-B47A73515D72">
                                                        <asp:Localize meta:resourcekey="str_pht" runat="server">Publish Tenant Home Storage As a Team Folder</asp:Localize>
                                                    </a>
                                                    <p style="color: #565656; font-size: 12px">
                                                        <asp:Localize meta:resourcekey="str_tennatroot" runat="server">The tenant's home storage will be published to users you chose in the same tenant so they can see file and folder contents from the home storage. Some specialized folder such as folders from remote file servers or remote cloud storage services are not included in this scope.</asp:Localize>
                                                    </p>
                                                    <asp:Localize meta:resourcekey="str_thome" ID="str_thome" runat="server" Visible="False">Tenant Home Storage</asp:Localize>
                                                </td>
                                            </tr>
                                        </table>

                                    </div>
                                    <%} %>
                                </div>
                            </div>
                        </div>

                        <%} %>

                
                        
                        <div class="panel-group" style="padding: 10px; padding-top: 3px;"> 
                            
                            <% if (SessionIsInstalledApp && !IsHostedFarm && m_AllowLocalFileServer && (SessionIsClusterAdmin || SessionIsDelegateClusterAdmin || SessionIsAdmin) && !string.IsNullOrEmpty(ViewSessionDomainId)){ %>
                                <div class="panel whitehead" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                <div class="panel-heading whitehead" >
                                    
                                    
                                    <table width="100%">
                                        <tr>
                                                
                                            <td>
                                                <h4 class="panel-title" >
                                        <a data-toggle="collapse" href="#Local">
                                             <table>
                                                            <tr>
                                                                <td width="20px" valign="middle" style="padding-top: 3px;"> 
                                                                  <i id="LocalIco" class="gladinet-icons md-24 md-dark hand exp">Ù</i>      
                                                                </td  >
                                                                <td valign="middle" title="<%=str_cshare.Text %>">
                                                                    <asp:Localize meta:resourcekey="str_cshare" Visible="False" ID="str_cshare" runat="server">Convert Existing File Share to Team Folder</asp:Localize>
                                                                    <asp:Localize ID="Localize6" meta:resourcekey="str_localsv" runat="server">File Servers in Local Area Network</asp:Localize>          
                                                                </td>
                                                            </tr>
                                                        </table>
                                                        
                                            
                                        </a>

                                    </h4>
                                            </td>
                                            <% if (SessionIsClusterAdmin){ %>
                                            <td width="24px">
                                                
                                                <div data-toggle="modal" data-target="#AddServerModal" >          
                                                    
                                                        <i class="gladinet-icons md-24 md-dark hand" 
                                                         data-toggle="tooltip" data-placement="bottom" data-original-title="<asp:Localize meta:resourcekey="str_add" runat="server">Add</asp:Localize>">±</i>
                                                
                                                </div>     
                                            </td>
                                            <% } %>
                                            <td width="20px" style="display: none;">
                                                
                                                                    <asp:LinkButton ID="LinkButton9"  ForeColor="#565656" 
                                    runat="server" onclick="LinkButton4_Click" 
                                    OnClientClick="Wait('Loading...');return true;" 
                                    meta:resourcekey="LinkButton5Resource1">
                                                    <span class="glyphicon glyphicon-plus" ></span></asp:LinkButton>
                                                    
                                                
                                            </td>
                                            <td width="24px" >
                                                
                                                    <asp:LinkButton ID="LinkButton21" runat="server" onclientclick="return false;">
                                                    <div aria-hidden="true" style="color:#565656;" data-toggle="modal" data-target="#SettingsDlg">
                                                    <i class="gladinet-icons md-24 md-dark hand" 
                                                     data-toggle="tooltip" data-placement="bottom" data-original-title="<asp:Localize meta:resourcekey="str_settings" runat="server">Settings</asp:Localize>">g</i>     
                                                    </div>
                                                        
                                                    </asp:LinkButton>
                                                
                                            </td>
                                            <td width="24px" >
                                                <asp:LinkButton ID="LinkButton8" runat="server" onclientclick="return false;">
                                                    <div aria-hidden="true" data-toggle="modal" data-target="#myModal">
                                                        <i class="gladinet-icons md-24 md-dark hand" 
                                                         data-toggle="tooltip" data-placement="bottom" data-original-title="<%=Str_Help.Text %>">?</i>   
                                                    </div>
                                                    <asp:Localize meta:resourcekey="str_help" ID="Str_Help" Visible="False" runat="server">Help</asp:Localize>
                                                 </asp:LinkButton>
                                            </td>
                                            <td align="right" width="20px">
                                                <asp:LinkButton ID="LinkButton2" runat="server" onclick="LinkButton2_Click" 
                                                    OnClientClick="Wait('Loading...');return true;" 
                                                    meta:resourcekey="LinkButton2Resource1" ForeColor="#565656">

                                                    <i class="gladinet-icons md-24 md-dark hand" 
                                                         data-toggle="tooltip" data-placement="bottom" data-original-title="<asp:Localize meta:resourcekey="str_rfs" runat="server">Reload</asp:Localize>">µ</i>

                                                </asp:LinkButton>
                                                
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                                <div id="Local" class="panel-collapse collapse fade">
                                    <div class="panel-body">
                                        <asp:Panel ID="LocalNetWork" runat="server" 
                                            meta:resourcekey="LocalNetWorkResource1">
                                            <asp:Panel ID="NoLocalSvr" runat="server" 
                                                meta:resourcekey="NoLocalSvrResource1">
                                                <div style="padding-top: 20px; padding-left: 30px;">
                                                    <asp:Localize meta:resourcekey="str_nosvr" runat="server">No server found in the local area network.</asp:Localize>
                                                </div>
                                            </asp:Panel>
                                            <asp:Panel ID="HasLocalSvr" runat="server" 
                                                meta:resourcekey="HasLocalSvrResource1">
                                                <div style=" max-height: 240px; overflow:auto!important;">
                                                <div class="row " style="width: 100%; align-content: center; margin: 0;" align="center">
                                                    <div class="col-xs-3 col-sm-3 col-md-2 col-lg-2 text-center topbuffer">
                                                                
                                                                    <table width="95%">
                                                                        <tr>
                                                                            <td align="center" height="96px">
                                                                                <a onclick="OnImportShareName();return false;" href="#"  title="<%=ma_add.Text %>">
                                                                                
                                                                                <i class="gladinet-icons md-53 md-dark hand">/</i> 
                                                                                    </a>
                                                                            </td>
                                                                        </tr>

                                                                        <tr>
                                                                            <td align="center" height="24px">
                                                                                <a onclick="OnImportShareName();return false;" href="#"  title="<%=ma_add.Text %>">
                                                                                <asp:Localize meta:resourcekey="str_maddhelp" ID="ma_add" runat="server" Visible="False">manually enter the share UNC to add</asp:Localize>
                                                                                 <%=LinkButton3.Text%>
                                                                        </a>
                                                                    <asp:Button ID="LinkButton3" runat="server" Text="Manual Configuration" Visible="False"
                                                                        CausesValidation="False" OnClick="OnContinueClick" OnClientClick="Wait('Save settings')"
                                                                        CssClass="btn btn-primary gladbtn light" meta:resourcekey="LinkButton3Resource1"></asp:Button>
                    
                                                                            </td>
                                                                        </tr>
                                                                      
                                                                    </table>
                                                                
                                                            </div>
                                                    <asp:Repeater ID="LocalSvrs" runat="server">
                                                        <ItemTemplate>
                                                            <div class="col-xs-3 col-sm-3 col-md-2 col-lg-2 text-center topbuffer" style="border: 0px solid red;" >
                                                                
                                                                    <table width="95%">
                                                                        <tr>
                                                                            <td align="center" height="96px" valign="bottom">
                                                                                <a href="javascript:;" title="<%=str_ces.Text %>"
                                                                    onclick='ClickSvr(&#039;<%# DataBinder.Eval(Container.DataItem,"Name") %>&#039;,&#039;<%# DataBinder.Eval(Container.DataItem,"InstanceId") %>&#039;,&#039;<%# DataBinder.Eval(Container.DataItem,"FQDN") %>&#039;);'>
                                                                    <i class="gladinet-icons md-63 md-dark hand">W</i> 
                                                                                <!--img src="<%#DataBinder.Eval(Container.DataItem,"SvrIcon") %>" width="96px" /-->
                                                                                    </a>
                                                                            </td>
                                                                        </tr>
                                                                        
                                                                        <tr>
                                                                            <td align="center" height="24px">
                                                                                <a href="javascript:;" title="<%=str_ces.Text %>"
                                                                    onclick='ClickSvr(&#039;<%# DataBinder.Eval(Container.DataItem,"Name") %>&#039;,&#039;<%# DataBinder.Eval(Container.DataItem,"InstanceId") %>&#039;,&#039;<%# DataBinder.Eval(Container.DataItem,"FQDN") %>&#039;);'>
                                                                                <%#DataBinder.Eval(Container.DataItem,"Name") %>
                                                                                    </a>
                                                                                <button type="button" class="btn btn-info " onclick='DeleteOwnSvr("<%#DataBinder.Eval(Container.DataItem,"Name") %>");'  style="<%# DataBinder.Eval(Container.DataItem,"EditStyle") %> padding: 0px!important; padding-left: 5px; color: #565656; margin: 0px;" ><span class="glyphicon glyphicon-trash" ></span></button>
                                                                            </td>
                                                                        </tr>
                                                                    </table>
                                                                
                                                            </div>
                                                        </ItemTemplate>
                                                    </asp:Repeater>
                                                </div>
                                                </div>
                                            </asp:Panel>
                                        </asp:Panel>
                                    </div>
                                </div>
                            </div>
                            <% } %>
                            
                            <% if (!SessionUnifiedWizAttachStorage)
                                { %>
                            <br/>
                            <div class="panel whitehead" style="box-shadow: 0px 0px 1px #a0a0a0!important">
                                <div class="panel-heading whitehead">
                                    <table width="100%">
                                        <tr>
                                                
                                            <td>
                                                <h4 class="panel-title">
                                                    <a data-toggle="collapse" href="#SAS" title="<%=str_mshare.Text %>">
                                                         <table>
                                                            <tr>
                                                                <td width="20px" valign="middle" style="padding-top: 3px;">
                                                                    <i id="SASIco" class="gladinet-icons md-24 md-dark hand exp">Ù</i>
                                                                </td  >
                                                                <td valign="middle">
                                                                    <asp:Localize meta:resourcekey="str_mshare"  ID="str_mshare" Visible="False" runat="server">Migrate Existing Network Share as Team Folder via Server Agent</asp:Localize>
                                                                    <asp:Localize ID="Localize7" meta:resourcekey="str_rsvrs" runat="server">Remote File Servers</asp:Localize>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                        
                                                        
                                                    </a>
                                                </h4>
                                            </td>
                                            <td width="20px">
                                                
                                                                    <asp:LinkButton ID="LinkButton7"  ForeColor="#565656" Visible="False"
                                    runat="server" onclick="LinkButton4_Click" 
                                    OnClientClick="Wait('Loading...');return true;" 
                                    meta:resourcekey="LinkButton5Resource1">
                                                    <span class="glyphicon glyphicon-plus" ></span></asp:LinkButton>
                                                    
                                                   <div data-toggle="modal" data-target="#AddServerModal">
                                                   <i class="gladinet-icons md-24 md-dark hand" 
                                                         data-toggle="tooltip" data-placement="bottom" data-original-title="<asp:Localize meta:resourcekey="str_add" runat="server">Add</asp:Localize>">±</i>
                                                   </div>        
                                                    
                                            </td>
                                            <td align="right" width="20px">
                                                <asp:LinkButton ID="LinkButton1" runat="server" onclick="LinkButton1_Click" 
                                                    OnClientClick="Wait('Loading...');return true;" 
                                                    meta:resourcekey="LinkButton1Resource1" ForeColor="#565656">
                                                    
                                                    <i class="gladinet-icons md-24 md-dark hand" 
                                                         data-toggle="tooltip" data-placement="bottom" data-original-title="<asp:Localize meta:resourcekey="str_rfs" runat="server">Refresh</asp:Localize>">µ</i>
                                                    
                                                    
                                                </asp:LinkButton>
                                                
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                                <div id="SAS" class="panel-collapse collapse fade">
                                    <div class="panel-body">
                                        <asp:Panel ID="SeverAgents" runat="server" 
                                            meta:resourcekey="SeverAgentsResource1">
                                            <asp:Panel ID="NoServerAgents" runat="server" 
                                                meta:resourcekey="NoServerAgentsResource1">
                                                <div style="padding-top: 20px; padding-left: 30px; ">
                                                    <asp:Localize meta:resourcekey="str_norsvrs" runat="server">No remote server found. You need to install the 'server agent' on the file server first 
                                                        for it to show here.</asp:Localize>
                                                    <br/>
                                                    <iframe src='/portal/downloadpage.aspx?serveronly=1&vdid=<%=SessionDomainId%>' style='width:100%; max-width: 900px; height: 220px;margin:0;padding:0;border:0; overflow:hidden;'></iframe>
                                                </div>
                                            </asp:Panel>
                                            <asp:Panel ID="HasSvrAgent" runat="server" 
                                                meta:resourcekey="HasSvrAgentResource1">
                                                 <div style=" max-height: 240px; overflow:auto!important;">
                                                <div class="row " style="width: 100%; align-content: center; margin: 0; " align="center">
                                                    <asp:Repeater ID="SvrAgents" runat="server">
                                                        <ItemTemplate>
                                                            <div class="col-xs-3 col-sm-3 col-md-2 col-lg-2 text-center topbuffer">
                                                                <a href="javascript:;" title="<%=str_csa.Text %>"
                                                                    onclick='ClickSvr(&#039;<%# DataBinder.Eval(Container.DataItem,"Name") %>&#039;,&#039;<%# DataBinder.Eval(Container.DataItem,"InstanceId") %>&#039;,&#039;<%# DataBinder.Eval(Container.DataItem,"FQDN") %>&#039;);'>
                                                                    <table width="95%">
                                                                        <tr>
                                                                            <td align="center">
                                                                    <i class="gladinet-icons md-63 md-dark hand" style="margin-top:10px;">W</i> 
                                                                            </td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td align="center">
                                                                                <%#DataBinder.Eval(Container.DataItem,"Name") %>
                                                                            </td>
                                                                        </tr>
                                                                    </table>
                                                                </a>
                                                            </div>
                                                        </ItemTemplate>
                                                    </asp:Repeater>
                                                </div>
                                                </div>
                                            </asp:Panel>
                                        </asp:Panel>
                                    </div>
                                </div>
                            </div>
                            <% } %>
                            <br/>
                            <asp:Panel ID="CloudStoragePanel" runat="server">
                            
                            <div class="panel" style="box-shadow: 0px 0px 1px #a0a0a0!important">
                                
                                <div class="panel-heading whitehead" >
                                    <table width="100%">
                                        <tr>
                                                
                                            <td>
                                                <h4 class="panel-title">
                                                    <a data-toggle="collapse" href="#PublicCloud">
                                                        <table>
                                                            <tr>
                                                                
                                                                <td width="20px" valign="middle" style="padding-top: 3px;">
                                                                    <i id="PublicCloudIco" class="gladinet-icons md-24 md-dark hand exp">Ù</i>
                                                                </td  >
                                                                
                                                                <td valign="middle">
                                                                    <asp:Localize ID="Localize5" meta:resourcekey="str_cstorage" runat="server">Cloud Storage</asp:Localize>            
                                                                </td>
                                                            </tr>
                                                        </table>
                                                        
                                                        
                                                    </a>
                                                </h4>
                                            </td>
                                            <td width="20px"></td>
                                            <td align="right" width="20px"></td>
                                        </tr>
                                    </table>
                                </div>
                                
                                <div id="PublicCloud" class="panel-collapse collapse 
                                    <%if (!SessionIsAdmin && string.IsNullOrEmpty(ViewSessionDomainId))
                                    { %>
                                    in
                                    <%} %>
                                    ">
                                    <div class="panel-body">
                                        <asp:Panel ID="Panel1" runat="server" 
                                            meta:resourcekey="SeverAgentsResource1">
                                            
                                            <asp:Panel ID="Panel3" runat="server" 
                                                meta:resourcekey="HasSvrAgentResource1">
                                                <div class="row " style="width: 100%; align-content: center; margin: 0;" align="center">
                                                    <asp:Repeater ID="CloudRepeater" runat="server">
                                                        <ItemTemplate>
                                                            <div class="col-xs-3 col-sm-3 col-md-2 col-lg-2 text-center topbuffer">
                                                                <a href="javascript:;" title="<%#DataBinder.Eval(Container.DataItem,"Name") %> "
                                                                    onclick='ClickCloud("<%#DataBinder.Eval(Container.DataItem,"Provider") %>");return false;'>
                                                                    <table width="95%">
                                                                        <tr>
                                                                            <td align="center" height="92px" valign="middle">
                                                                            <i class="gladinet-icons md-63 md-dark hand"><%#GetImage(DataBinder.Eval(Container.DataItem,"Name"))%></i> 
                                                                            </td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td align="center">
                                                                                <%#GetShortStringEx(DataBinder.Eval(Container.DataItem,"Name").ToString(), 24) %>                                                                                
                                                                            </td>
                                                                        </tr>
                                                                    </table>
                                                                </a>
                                                            </div>
                                                        </ItemTemplate>
                                                    </asp:Repeater>
                                                </div>
                                            </asp:Panel>
                                        </asp:Panel>
                                    </div>
                                </div>
                            </div>
                                </asp:Panel>
                            
                        </div>
                    </asp:Panel>
                    
                    <asp:Panel ID="RPCPanel1" runat="server" Visible="False" 
                        meta:resourcekey="RPCPanel1Resource1">
                        <div id="AddSvrFailedModal" class="modal fade" role="dialog">
                          <div class="modal-dialog">

                            <!-- Modal content-->
                            <div class="modal-content">
                              <div class="modal-header">
                                  <h4 class="modal-title"><asp:Localize meta:resourcekey="str_noreach" runat="server">Server can not be reached</asp:Localize></h3></h4>
                                <button type="button" class="close" data-dismiss="modal">&times;</button>
                                
                              </div>
                              <div class="modal-body">
                                <div width="100%" align="center" style=" overflow: auto;">
                         <table width="90%" align="center">
                             <tr>
                                 <td style="padding: 5px;">
                                     <asp:Localize meta:resourcekey="str_nohelp" runat="server">If this server is not in the local network, download and install a server agent on the server. If you are sure it is located in the local network, follow instructions to enable RPC server.</asp:Localize>
                                 </td>
                             </tr>
                              <tr>
                                 <td style="padding: 5px;padding-top: 20px;" align="left">
                                     <asp:Button ID="Button2" runat="server" Width="128px" Text="Ok, I got it" CssClass="btn btn-primary gladbtn" Visible="False"
                                         onclick="CancelRPC_Click" meta:resourcekey="Button2Resource2" />
                                            
                                     
                                 </td>
                             </tr>

                            
                         </table>
                         </div>
                              </div>
                              <div class="modal-footer">
                                  <button type="button" class="btn btn-info " onclick="ShowInstr();" ><asp:Localize meta:resourcekey="str_instr" runat="server">Instructions</asp:Localize></button>
                                <button type="button" class="btn btn-default" data-dismiss="modal"><%=Button2.Text %></button>
                              </div>
                            </div>

                          </div>
                        </div>
                            
                         </asp:Panel>
                    <asp:Panel ID="AddServerPanel" runat="server" Visible="False" 
                        meta:resourcekey="AddServerPanelResource1">
                        
                    </asp:Panel>
                    
                    <asp:Panel ID="SharesPanel" runat="server" Visible="False" 
                        meta:resourcekey="SharesPanelResource1">
                        <div style="height: 20px;"></div>
                        <asp:Panel ID="NoShares" runat="server" meta:resourcekey="NoSharesResource1">
                            <div style="padding-left: 20px;padding-top: 30px;">
                                <asp:Localize meta:resourcekey="str_20" runat="server">No share found on this server. you can manually enter the share UNC path by clicking </asp:Localize><a style="color: #008000"
                                    onclick="OnImportShareName();return false;" href="#"><asp:Localize meta:resourcekey="str_21" runat="server">here</asp:Localize></a>.
                                    </div>
                        </asp:Panel>
                        <asp:Panel ID="HasShares" runat="server" meta:resourcekey="HasSharesResource1">
                            <%if (ListModeBtn.Visible){ %>
                            <div class="row " style="width: 100%; align-content: center; margin: 0;padding-top:20px;" align="center">
                                <%}else{ %>
                                <table width="100%" border="0" style="cursor:pointer;" class="table-striped">
                                <%} %>
                                                    <asp:Repeater ID="SharesRepeater" runat="server">
                                                        <ItemTemplate>
                                                            <%if (ListModeBtn.Visible)
                                                            { %>
                                                            <div class="col-xs-3 col-sm-3 col-md-2 col-lg-2 text-center topbuffer" style="padding:10px;">
                                                                <a href="javascript:;" 
                                                                    onclick='ClickShare("<%# DataBinder.Eval(Container.DataItem,"Name").ToString().Replace("'","|") %>","<%# DataBinder.Eval(Container.DataItem,"Path").ToString().Replace("'","|")  %>","<%# DataBinder.Eval(Container.DataItem,"FQDN").ToString().Replace("'","|")  %>");'>
                                                                    <table width="95%">
                                                                        <tr>
                                                                            <td align="center">
                                                                                <i class="gladinet-icons md-48 md-dark hand" style="font-size:48px!important;">v</i>
                                                                            </td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td align="center" style="padding-bottom: 20px;">
                                                                                <%#DataBinder.Eval(Container.DataItem,"Name") %>
                                                                            </td>
                                                                        </tr>
                                                                    </table>
                                                                </a>
                                                            </div>
                                                            <%}
                                                            else
                                                            { %>
                                                            
                                                                    
                                                                        <tr onclick='ClickShare("<%# DataBinder.Eval(Container.DataItem,"Name").ToString().Replace("'","|")  %>","<%# DataBinder.Eval(Container.DataItem,"Path").ToString().Replace("'","|")  %>","<%# DataBinder.Eval(Container.DataItem,"FQDN").ToString().Replace("'","|")  %>");'
                                                                            onmouseover="this.style.borderBottom='2px solid #008000';"  onmouseout="this.style.borderBottom='0px solid #008000';"
                                                                            >
                                                                            <td align="center" width="48px" style="padding:10px;">
                                                                                <span class="glyphicon glyphicon-folder-open" style="font-size:24px; color:#565656;"></span>
                                                                            </td>
                                                                            <td align="left" style="padding:10px;">
                                                                                <%#DataBinder.Eval(Container.DataItem,"Name") %>
                                                                            </td>
                                                                        </tr>
                                                                    

                                                            
                                                            <%} %>
                                                        </ItemTemplate>
                                                    </asp:Repeater>
                                    <%if (ListModeBtn.Visible)
                                    { %>
                                                </div>
                                <%}
                            else
                            { %>
                                </table>
                                    <%} %>
                        </asp:Panel>
                        
                        <asp:Panel ID="AuthPanel" runat="server" Visible="False" 
                            meta:resourcekey="AuthPanelResource1">
                            <div width="100%" align="center" style="padding-top:40px;">
                         <table style="width:100%;max-width:800px;" align="center">
                             <tr>
                                 <td style="padding: 5px;"><h3 style="font-size:24px; color:#404040; font-weight:100;"><asp:Localize meta:resourcekey="str_22" runat="server">Access Denied. Please specify an user account to continue</asp:Localize></h3></td>
                             </tr>
                             <tr>
                                 <td style="padding: 5px;">
                                     <asp:Localize meta:resourcekey="str_23" runat="server">User Name</asp:Localize>
                                 </td>
                             </tr>
                             <tr>
                                 <td style="padding: 5px;">
                                     <asp:TextBox ID="UserName" runat="server" CssClass="form-control" 
                                         meta:resourcekey="UserNameResource2"></asp:TextBox>
                                 </td>
                             </tr>
                             <tr>
                                 <td style="padding: 5px; padding-top:40px;">
                                     <asp:Localize meta:resourcekey="str_24" runat="server">Password</asp:Localize>
                                 </td>
                             </tr>
                             <tr>
                                 <td style="padding: 5px;">
                                     <asp:TextBox ID="Password" TextMode="Password" runat="server" 
                                         CssClass="form-control" meta:resourcekey="PasswordResource2"></asp:TextBox>
                                 </td>
                             </tr>
                             <tr>
                                 <td height="10px">&nbsp;</td>
                             </tr>
                             <tr>
                                 <td style="padding: 5px;" align="right">
                                     <asp:Button ID="AuthSvr" runat="server" Text="Continue" CssClass="btn btn-primary gladbtn"
                                         onclick="AuthSvr_Click" meta:resourcekey="AuthSvrResource1" />
                                 </td>
                             </tr>

                         </table>
                         </div>
                         </asp:Panel>
                         
                         <asp:Panel ID="RPCPanel" runat="server" Visible="False" 
                            meta:resourcekey="RPCPanelResource1">
                            <div width="100%" style="height:500px;overflow: auto;"align="center">
                         <table width="90%" align="center">
                             <tr>
                                 <td style="padding: 5px; color:#565656;"><h1><asp:Localize meta:resourcekey="str_25" runat="server">Server can not be reached</asp:Localize></h1></td>
                             </tr>
                             <tr>
                                 <td style="padding: 5px;">
                                     <li><a href="javascript:;" onclick="DownloadSA();return false;"><asp:Localize meta:resourcekey="str_dow" runat="server">Download </asp:Localize></a> <asp:Localize meta:resourcekey="str_downsa" runat="server">the server agent and install it on the file server, the file server will show up in the 'remote file server' list.</asp:Localize></li>
                                     <li><asp:Localize meta:resourcekey="str_26" runat="server">If you are sure the server is in the local network, follow instructions to change the configuration and try again.</asp:Localize></li>
                                 </td>
                             </tr>
                             <tr>
                                 <td height="10px">&nbsp;</td>
                             </tr>
                             <tr>
                                 <td style="padding: 5px;padding-left: 10px;" align="left">
                                     <table>
                                         <tr>
                                             <td>
                                     <asp:Button ID="Button1" runat="server" Text="Refresh Share List" 
                                         CssClass="btn btn-primary gladbtn" OnClientClick="Wait('Loading...');return true;"
                                         onclick="Refresh_Click" meta:resourcekey="Button1Resource2" />            
                                             </td>
                                             <td>
                                                <button type="button" class="btn btn-default " data-toggle="modal" data-target="#Instr" ><asp:Localize ID="Localize9" meta:resourcekey="str_27" runat="server">Instructions</asp:Localize></button>            
                                             </td>
                                             <td>
                                                 
                                     <a href="SelectStoragePage.aspx?vdid=<%= SessionDomainId %>" style="color:#565656;">
                                    <h3><asp:Localize meta:resourcekey="str_retsvrsa" runat="server">RETURN TO SERVER LIST</asp:Localize></h3></a>            
                                             </td>
                                         </tr>
                                     </table>
                                     
                                     
                                   
                                 </td>
                             </tr>
                             <tr>
                                 <td style="padding: 5px; height:300px; overflow: auto;"></td>
                             
                             </tr>
                             

                         </table>
                         </div>
                         </asp:Panel>
                    
                    </asp:Panel>
                </td>
            </tr>
        </table>
    </asp:Panel>
    <div id="Instr" class="modal fade" role="dialog" >
                    <div class="modal-dialog" style="width:90%;">

    <!-- Modal content-->
    <div class="modal-content" >
      <div class="modal-header" style="background-color: #e0e0e0">
          <h4 class="modal-title"><asp:Localize runat="server" meta:resourcekey="str_Hel">Help</asp:Localize></h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        
      </div>
      <div class="modal-body" >
       <p><asp:Localize meta:resourcekey="str_win2003" runat="server">Windows 2003</asp:Localize> <asp:Localize runat="server" meta:resourcekey="str_and">and</asp:Localize> <asp:Localize meta:resourcekey="str_win2003R2" runat="server">Windows 2003 R2</asp:Localize></p>
                                    <p class="text-muted">
                                        <asp:Localize runat="server" meta:resourcekey="str_win03Hlp">The following needs to be run at the command prompt:</asp:Localize><br/>
                                        <asp:Localize meta:resourcekey="str_netFirSetSerTypRemMod" runat="server">netsh firewall set service type = remoteadmin mode = enable</asp:Localize>
                                            </p>

                                    <p><asp:Localize runat="server" meta:resourcekey="str_Win200">Windows 2008</asp:Localize></p>
                                    <p class="text-muted">
                                        <asp:Localize runat="server" meta:resourcekey="str_win08Hlp">Start | Control Panel | Windows Firewall then select “Allow a program through Windows Firewall”.  Select the Exceptions tab.  Scroll down and click on check box next to “Windows Management Instrumentation (WMI)” then click OK.</asp:Localize>
                                    </p>

                                    <p><asp:Localize runat="server" meta:resourcekey="str_Win200R2">Windows 2008 R2</asp:Localize></p>
                                    <p class="text-muted">
                                        <asp:Localize runat="server" meta:resourcekey="str_win08R2Hlp">Start | Control Panel | System and Security | Windows Firewall then select “Allow a program or feature through Windows Firewall”.  Scroll down and click on check box next to “Windows Management Instrumentation (WMI)” which should automatically select the check box in the Domain column.  Click OK.</asp:Localize>
                                    </p>

                                    <p><asp:Localize meta:resourcekey="str_win2012" runat="server">Windows 2012</asp:Localize> <asp:Localize runat="server" meta:resourcekey="str_and">and</asp:Localize> <asp:Localize meta:resourcekey="str_win2012R2" runat="server">Windows 2012 R2</asp:Localize></p>
                                    <p class="text-muted">
                                        <asp:Localize runat="server" meta:resourcekey="str_win12HlpA">Open Server manager (open by default) and click on Local Server on the left side of the screen.  In the Properties box, click on setting to the right of the label Windows Firewall (Domain: On). You can also get to the Windows Firewall setting by selecting Control Panel | System and Security | Windows Firewall</asp:Localize>

                                        <asp:Localize runat="server" meta:resourcekey="str_win12HlpB">Select “Allow an app or feature through Windows Firewall”.  Scroll down and click on check box next to “Windows Management Instrumentation (WMI)” which should automatically select the check box in the Domain column.  Click OK.</asp:Localize>
                                 </p>

                                    <p><asp:Localize runat="server" meta:resourcekey="str_Win7">Windows 7</asp:Localize></p>
                                    <p class="text-muted">
                                        <asp:Localize runat="server" meta:resourcekey="str_win7HlpA">Start | Control Panel | System and Security | Windows Firewall then select “Allow a program or feature through Windows Firewall”.  Scroll down and click on check box next to “File and Printer Sharing” and “Windows Management Instrumentation (WMI)” which should automatically select the check box in the Domain column.  Click OK. </asp:Localize>
                                        <br /><asp:Localize runat="server" meta:resourcekey="str_win7HlpB">Next start the Remote Registry service which is set to Manual by default (set to Automatic).  If not data such as installed software, event logs, security policies, etc. will not be retrieved.</asp:Localize>
                                    </p>
                                    <p><asp:Localize runat="server" meta:resourcekey="str_Win8Win81AndWin10">Windows 8, Windows 8.1, and Windows 10</asp:Localize></p>
                                    <p class="text-muted">
                                        <asp:Localize runat="server" meta:resourcekey="str_win8HlpA">In the lower left hand corned of the screen right click and select Control Panel.  Then select System and Security | Windows Firewall then select “Allow an app or feature through Windows Firewall”.  Scroll down and click on check box next to “File and Printer Sharing” and “Windows Management Instrumentation (WMI)” which should automatically select the check box in the Domain column.  Click OK.</asp:Localize> 
                                        <br /><asp:Localize runat="server" meta:resourcekey="str_win8HlpB">Next start the Remote Registry service which is set to Disabled by default (set to Automatic).  If not data such as installed software, event logs, security policies, etc. will not be retrieved.</asp:Localize>
                                    </p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal"><asp:Localize meta:resourcekey="str_cls" runat="server">Close</asp:Localize></button>
      </div>
    </div>

  </div>
                    </div>
     <div id="AddServerModal" class="modal fade" role="dialog">
  <div class="modal-dialog modal-lg">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        
      </div>
      <div class="modal-body">
        <table width="100%">
                            <tr>
                                <td></td>
                            </tr>
                            <tr>
                                <td align="center">
                                    <table width="90%">
                                        <tr>
                                            <td style="padding: 5px;padding-bottom: 10px;padding-top: 20px;">
                                                <li>
                                             <% if (SessionIsInstalledApp && !IsHosted && SessionIsClusterAdmin)
                                                 { %>
                                                 <asp:Localize meta:resourcekey="str_nodir" runat="server">If the server cannot be accessed directly from the web server, you can</asp:Localize> 
                                             <%} %>     
                                             <a href="javascript:;" onclick="DownloadSA();return false;"><asp:Localize meta:resourcekey="str_dld" runat="server">Download</asp:Localize></a> <asp:Localize meta:resourcekey="str_13" runat="server">the server agent and install it on the file server. The file server will show up in the 'remote file server' list.</asp:Localize>
                                             </li>
                                            </td>
                                        </tr>
                                        <% if (SessionIsInstalledApp && !IsHosted)
                                            { %>
                                        <tr>
                                            <td style="padding: 5px;padding-bottom: 10px;">
                                                <asp:Panel ID="ADConfigPanel" runat="server" 
                                                    meta:resourcekey="ADConfigPanelResource1">
                                                    <li>
                                                        <asp:Localize meta:resourcekey="str_14" runat="server">We can discover the available file server(s) from your Active Directory,</asp:Localize> <a href="LDAPCfgPage.aspx?vdid=<%=SessionDomainId %>"><asp:Localize meta:resourcekey="str_15" runat="server">Configure Active Directory Now!</asp:Localize></a>
                                                    </li>
                                                </asp:Panel>
                                            </td>
                                        </tr>

                                         <%if (SessionIsClusterAdmin)
                                             { %>
                                        <tr>
                                            <td style="padding: 5px;padding-bottom: 10px;">
                                            <li><asp:Localize meta:resourcekey="str_16" runat="server">If the file server you are looking for is located in the local network, please enter the info below to add it.</asp:Localize></li></td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px"><asp:Localize meta:resourcekey="str_17" runat="server">Server Name</asp:Localize></td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px">
                                                <asp:TextBox ID="NewServerName" runat="server" CssClass="form-control" 
                                                    meta:resourcekey="NewServerNameResource1"></asp:TextBox>
                                             </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px"><asp:Localize meta:resourcekey="str_18" runat="server">User Name</asp:Localize></td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px">
                                                <asp:TextBox ID="NewUserName" runat="server" CssClass="form-control" 
                                                    meta:resourcekey="NewUserNameResource1"></asp:TextBox>
                                             </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px"><asp:Localize meta:resourcekey="str_19" runat="server">Password</asp:Localize></td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px">
                                                <asp:TextBox ID="NewPassword" TextMode="Password" runat="server" 
                                                    CssClass="form-control" meta:resourcekey="NewPasswordResource1"></asp:TextBox>
                                             </td>
                                        </tr>
                                                                                <tr>
                                            <td style="padding: 10px">&nbsp;</td>
                                        </tr>

                                        
                                        <%} %>
                                        <%} %>
                                        <tr>
                                            <td style="padding: 5px; padding-top: 10px;border-top:1px solid #f0f0f0; " align="right">
                                                <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize> 
                                                <asp:Button ID="CancelAdd" runat="server" Text="Cancel" Visible="False"
                                                    CssClass="btn btn-default" OnClientClick="Wait('Wait');return true;" 
                                                    onclick="CancelAdd_Click" meta:resourcekey="CancelAddResource1"/>
                                                <%
                                                    CancelAdd.OnClientClick = String.Format("Wait('{0}')", LocPlsWat.Text);
                                                %>
                                            </td>
                                        </tr>
                                    </table>
                                    
                                </td>
                            </tr>
                        </table>
      </div>
      <div class="modal-footer">
          <% if (SessionIsInstalledApp && !IsHosted && SessionIsClusterAdmin)
              { %>
                                                <asp:Button ID="AddServer" runat="server" Text="Add" CssClass="btn btn-primary gladbtn" OnClientClick="Wait('Wait');return true;" onclick="AddServer_Click" meta:resourcekey="AddServerResource1" />
              <%
                      AddServer.OnClientClick = String.Format("Wait('{0}')", LocPlsWat.Text);
                  } %>
        <button type="button" class="btn btn-default" data-dismiss="modal"><%=CancelAdd.Text %></button>
      </div>
    </div>

  </div>
</div>
    <div style="display: none;">
         <asp:LinkButton ID="LinkButton5"  ForeColor="White" Visible="False"
                                    runat="server" onclick="LinkButton4_Click" 
                                    OnClientClick="Wait('Loading...');return true;" 
                                    meta:resourcekey="LinkButton5Resource1"></asp:LinkButton>
        <asp:Button ID="QueryShares" runat="server" Text="Button" 
            onclick="QueryShares_Click" meta:resourcekey="QuerySharesResource1" />
        <asp:Button ID="SelectShare" runat="server" Text="Button" 
            onclick="SelectShare_Click" meta:resourcekey="SelectShareResource1" />
        <asp:HiddenField ID="ServerName" runat="server" />
        <asp:HiddenField ID="ServerFQDN" runat="server" />
        <asp:HiddenField ID="ServerInstanceId" runat="server" />
        <asp:HiddenField ID="ShareName" runat="server" />
        <asp:HiddenField ID="SharePath" runat="server" />
        <asp:HiddenField ID="CurrentFQDN" runat="server" />
             <asp:Button ID="SelectCloud" runat="server" Text="Button" 
         onclick="SelectCloud_Click" />
        <asp:Button ID="RemoveOwnSvr" runat="server" Text="Button" 
            onclick="RemoveOwnSvr_Click" meta:resourcekey="QuerySharesResource1" />
    </div>
  </div>
    <div class="footer x-panel-header-light" style="border-left: 0; border-right: 0; display: none;
        border-bottom: 0; vertical-align: middle; margin: 0;">
        <table width="100%" style="height: 64px; text-align: right; padding-right: 64px;"
            align="right">
            <tr>
                
                <td align="right" style="padding-right: 10px;">
                   
                    
                        <asp:Button ID="ButtonBack" runat="server" 
                            OnClientClick="showLoader(this.parentNode)" TabIndex="7" CssClass="btn btn-default light" Text="Cancel" 
                            CausesValidation="False" OnClick="ButtonBack_Click" meta:resourcekey="ButtonBackResource1"></asp:Button>
                    
                </td>
            </tr>
        </table>
    </div>
    <script type="text/javascript">
        function AdjustMainDiv() {

            var h = 400;

            try {



                h = document.body.offsetHeight - 5;
                if (h < 108) {
                    h = 108;
                }
                var e = document.getElementById("maindiv");
                e.style.height = h + "px";

            } catch (err) {
            }

        }
        Ext.EventManager.onWindowResize(function () {
            AdjustMainDiv();
        });

        AdjustMainDiv();
        <%if (RPCPanel1.Visible)
        {%>
        $('#AddSvrFailedModal').modal({ backdrop: 'static', keyboard: false });
        <%}%>

        function ShowInstr() {
            $('#AddSvrFailedModal').modal('hide');
            $('#Instr').modal({ backdrop: 'static', keyboard: false });
        }
        
         
        var oldOnload = window.onload;
        window.onload = function () {
            if (oldOnload) oldOnload();

            $('#ExTen').on('shown.bs.collapse', function () {
                $("#ExTenIco").html("Ú");//show expanded icon
            });
            $('#ExTen').on('hidden.bs.collapse', function () {
                $("#ExTenIco").html("Ù");//show collapsed icon
            });
            $('#Local').on('shown.bs.collapse', function () {
                $("#LocalIco").html("Ú");//show expanded icon
            });
            $('#Local').on('hidden.bs.collapse', function () {
                $("#LocalIco").html("Ù");//show collapsed icon
            });  
            $('#SAS').on('shown.bs.collapse', function () {
                $("#SASIco").html("Ú");//show expanded icon
            });
            $('#SAS').on('hidden.bs.collapse', function () {
                $("#SASIco").html("Ù");//show collapsed icon
            });  
            $('#PublicCloud').on('shown.bs.collapse', function () {
                $("#PublicCloudIco").html("Ú");//show expanded icon
            });
            $('#PublicCloud').on('hidden.bs.collapse', function () {
                $("#PublicCloudIco").html("Ù");//show collapsed icon
            });
        }
    </script>
</asp:Content>
