﻿<%@ Page Title="Gladinet Cloud Cluster" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="SelectSharePage.aspx.cs" Inherits="GladinetPayFlow.SelectSharePage" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">

    <style type="text/css">
        td {
            font-size: 15px;
            
            font-weight: 100;
        }
        
        b {
            font-weight: 500;
        }
        
        .badgefont {
            font-size: 15px;
            
        }

    </style>
    <style type="text/css">
        .pricetable
        {
            border: 1px solid #cccccc;
        }
        
        .plain9BlackOnNone
        {
            border-bottom: 1px solid #cccccc;
            border-right: 1px solid #cccccc;
        }
        .offer_flex
        {
            background: #FFFFE0 url('images/giftbox.png') no-repeat 8px center;
            border: 1px solid #E6DB55;
            border-radius: 4px 4px 4px 4px;
            color: #000000;
            height: 54px;
            line-height: 18px;
            padding: 2px;
            padding-left: 16px;
            width: 868px;
            vertical-align: middle;
            text-align: center;
            margin: auto;
            margin-bottom: 16px;
        }
        
        .offertitle
        {
            line-height: 24px;
        }
        .offertext
        {
            line-height: 20px;
        }
        
        .offer_flex1
        {
            border: 1px solid #E6DB55;
            border-radius: 4px 4px 4px 4px;
            margin: auto;
        }
        
        *
        {
            margin: 0;
            padding:0;
        }
        html, body
        {
            height: 100%;
        }
        .main, #aspnetForm
         {
             height: 100%;
         }

        .wrapper
        {
            padding: 0px;
            background-color: white;
            
        }
        .footer, .push
        {
            height: 68px; /* .push must be the same height as .footer */
        }
    </style>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocMisPas" meta:resourcekey="str_misPas" Visible="false">Missing password</asp:Localize>
<asp:Localize runat="server" ID="LocMisUseNam" meta:resourcekey="str_misUseNam" Visible="false">Missing user name</asp:Localize>
<asp:Localize runat="server" ID="LocMisSerNam" meta:resourcekey="str_misSerNam" Visible="false">Missing server name</asp:Localize>
<asp:Localize runat="server" ID="LocAccIsDen" meta:resourcekey="str_accIsDen" Visible="false">Access is denied</asp:Localize>
<asp:Localize runat="server" ID="LocPasIsMis" meta:resourcekey="str_pasIsMis" Visible="false">Password is missing</asp:Localize>
<asp:Localize runat="server" ID="LocUseNamIsMis" meta:resourcekey="str_useNamIsMis" Visible="false">User name is missing</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToLoaSha" meta:resourcekey="str_faiToLoaSha" Visible="false">Failed to load shares</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToLoa" meta:resourcekey="str_faiToLoa" Visible="false">Failed to load</asp:Localize>
    <script type="text/javascript">
        showLoader();


        function ClickSvr(name, hid, fqdn) {
            var b = document.getElementById("ctl00_MainContent_QueryShares");
            var n = document.getElementById("ctl00_MainContent_ServerName");
            var f = document.getElementById("ctl00_MainContent_ServerFQDN");
            var i = document.getElementById("ctl00_MainContent_ServerInstanceId");

            n.value = name;
            f.value = fqdn;
            i.value = hid;
            Wait('Loading...');
            b.click();
        }

        function ClickShare(name, path) {
            var b = document.getElementById("ctl00_MainContent_SelectShare");
            var n = document.getElementById("ctl00_MainContent_ShareName");
            var p = document.getElementById("ctl00_MainContent_SharePath");

            n.value = name;
            p.value = path;

            Wait('Loading...');
            b.click();
        }

        function DownloadSA() {

            var win = new Ext.Window({
                id: 'download_win',
                title: "<asp:Localize meta:resourcekey="js_string2" runat="server">Download Native Clients</asp:Localize>",
                width: 1000,
                height: maxh(686),
                plain: true,
                modal: true,
                maximizable: true,
                constrain: true,
                resizable: true,
                bodyPadding: 5,
                html: "<iframe id='openwin' src=/portal/downloadpage.aspx?serveronly=1' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0;border:0;'></iframe>",
                defaults: {
                    border: false
                }
            }).show();
        }
    </script>
    
 <div class="wrapper" id="maindiv" style="overflow: auto; ">
    <asp:Panel ID="NamePanel" runat="server" meta:resourcekey="NamePanelResource1">
        <table width="100%"  style="background-color: white;"
            align="center">
                <tr>
                <td  style="height: 68px;color: #808080;border-bottom: 1px solid #c0c0c0;
                    border-top: 0; border-left: 0; border-right: 0;  padding:0;padding-left: 16px; vertical-align: middle;
                    text-align: left; font-size: 16px;;margin:0">
                    <table width="100%">
                        <tr>
                            <td style="font-size: 16px;">
                                <a href="SelectSharePage.aspx?vdid=<%=SessionDomainId %>" style="color:#565656;">
                                <h1><asp:Label ID="FileSvrLable" runat="server" Text="File Servers" 
                                    meta:resourcekey="FileSvrLableResource1"></asp:Label></h1></a>
                    <asp:Label ID="FileSvrName" runat="server" meta:resourcekey="FileSvrNameResource1"></asp:Label>
                            </td>
                            <td align="right" style="padding-right: 10px;">
                            <% if (ServersPanel.Visible){ %>
                                                                    <asp:LinkButton ID="LinkButton5" 
                                    runat="server" onclick="LinkButton4_Click" 
                                    OnClientClick="Wait('Loading...');return true;" 
                                    meta:resourcekey="LinkButton5Resource1">
                                                    <span class="fa fa-plus" style="font-size: 16px;"></span></asp:LinkButton>&nbsp;&nbsp;
                                                    <button type="button" class="btn btn-default " data-toggle="modal" data-target="#SettingsDlg" title="Settings"><span class="fa fa-cog" aria-hidden="true" style="font-size: 14px;"></span>
                                                                            </button>
                                                <% } %>
                                                
                                                 <% if (SharesPanel.Visible){ %>           
                                                 <asp:LinkButton ID="LinkButton6" runat="server" 
                                    onclick="QueryShares_Click" OnClientClick="Wait('Loading...');return true;" 
                                    meta:resourcekey="LinkButton6Resource1">
                                                    <span class="fa fa-refresh"></span>
                                                </asp:LinkButton>
                                                <% } %>&nbsp;&nbsp;
                                                <button type="button" class="btn btn-default " data-toggle="modal" data-target="#myModal" ><span class="fa fa-question-sign" aria-hidden="true" style="font-size: 14px;"></span>
                                                                            </button>
                                                
                            </td>
                        </tr>                        
                    </table>

                    
                </td>
            </tr>
            <tr>
              <td>
                  <div id="SettingsDlg" class="modal fade" role="dialog">
                    <div class="modal-dialog">

    <!-- Modal content-->
    <div class="modal-content" style="width:100%;">
      <div class="modal-header" style="background-color: #e0e0e0">
          <h4 class="modal-title"><asp:Localize meta:resourcekey="str_settings" runat="server">Settings</asp:Localize></h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        
      </div>
      <div class="modal-body">
       <table width="100%">
           <tr>
               <td style="padding: 5px;">
                   <asp:CheckBox ID="DiscoverNet" runat="server" 
                       Text="Discover network neighborhood (could be slow)" 
                       meta:resourcekey="DiscoverNetResource1" />
               </td>
           </tr>
           <tr>
               <td style="padding: 5px;">
                   <asp:CheckBox ID="IncludeWS" runat="server" Text="Include workstation(s)" 
                       meta:resourcekey="IncludeWSResource1" />
               </td>
           </tr>

       </table>
      </div>
      <div class="modal-footer">
          <asp:Button ID="ApplySettings" runat="server" Text="Apply" 
              OnClick="ApplySetting_Click" CssClass="btn btn-primary gladbtn" 
              OnClientClick="Wait('Applying settings...');return true;" 
              meta:resourcekey="ApplySettingsResource1"/>
        <button type="button" class="btn btn-default" data-dismiss="modal"><asp:Localize meta:resourcekey="str_close" runat="server">Close</asp:Localize></button>
      </div>
    </div>

  </div>
                    </div>
                  <div id="myModal" class="modal fade" role="dialog">
                    <div class="modal-dialog">

    <!-- Modal content-->
    <div class="modal-content" style="width:100%;">
      <div class="modal-header" style="background-color: #e0e0e0">
          <h4 class="modal-title"><asp:Localize meta:resourcekey="str_help" runat="server">Help</asp:Localize></h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        
      </div>
      <div class="modal-body">
        <% if (ServersPanel.Visible){ %>
                    <div style="padding: 10px;width: 100%; "  align="left">
                            <strong></strong><asp:Localize meta:resourcekey="str_exp" runat="server">Click server to explore shares hosted by the server. </asp:Localize>
                            <% if (SessionIsInstalledApp && !IsHosted)
                               { %>
                                <asp:Localize meta:resourcekey="str_dont" runat="server"> Don't see your server? 
                                    Click </asp:Localize>
                            <asp:LinkButton ID="LinkButton4" runat="server" ForeColor="Green" 
                                onclick="LinkButton4_Click" meta:resourcekey="LinkButton4Resource1"><asp:Localize meta:resourcekey="str_here" runat="server">here</asp:Localize></asp:LinkButton> <asp:Localize meta:resourcekey="str_11" runat="server">to add it manually, or  click</asp:Localize> <a style="color: #008000"
                                href="ImportShareName.aspx?vdid=<%= SessionDomainId %>"><asp:Localize ID="Localize1" meta:resourcekey="str_here" runat="server">here</asp:Localize></a> <asp:Localize meta:resourcekey="str_manu" runat="server">to manually enter the share UNC.</asp:Localize>
                            <% } %>
                        </div>
                    <% } %>
                    <% if (SharesPanel.Visible){ %>
                    <div style="padding: 10px;width: 100%;  padding-bottom: 20px;"  align="left">
                        <strong></strong><asp:Localize meta:resourcekey="str_share" runat="server">Click share to continue.</asp:Localize> 
                        <% if (SessionIsInstalledApp && !IsHosted)
                           { %>
                            <asp:Localize meta:resourcekey="str_12" runat="server">If your share is not listed here, you can manually enter the share UNC by clicking</asp:Localize> <a style="color: #008000"
                                href="ImportShareName.aspx?vdid=<%= SessionDomainId %>"><asp:Localize ID="Localize2" meta:resourcekey="str_here" runat="server">here</asp:Localize></a>.
                                    <% } %>
                        </div>
                        <% } %>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal"><asp:Localize meta:resourcekey="str_close" runat="server">Close</asp:Localize></button>
      </div>
    </div>

  </div>
                    </div>
                    <div>
        <%if (!string.IsNullOrEmpty(ErrorMsg.Text))
          { %>
        <br />
        <asp:Label ID="ErrorMsg" runat="server" CssClass="errmsg" 
            meta:resourcekey="ErrorMsgResource1"></asp:Label>
        <%} %>
    </div>
              </td>
            </tr>
            <tr>
                <td></td>
            </tr>
            <tr>
                <td>
                    <asp:Panel ID="ServersPanel" runat="server" 
                        meta:resourcekey="ServersPanelResource1">
                        <div style="height: 20px;"></div>
                        <div class="panel-group" style="padding: 10px;">
                            
                            <% if (SessionIsInstalledApp && !IsHosted){ %>
                                <div class="panel panel-info2" style="background-color: white;">
                                <div class="panel-heading" >
                                    
                                    
                                    <table width="100%">
                                        <tr>
                                                
                                            <td>
                                                <h4 class="panel-title" >
                                        <a data-toggle="collapse" href="#Local"><asp:Localize meta:resourcekey="str_localsv" runat="server">File Servers in Local Area Network</asp:Localize></a>
                                    </h4>
                                            </td>
                                            
                                            <td align="right">
                                                <asp:LinkButton ID="LinkButton2" runat="server" onclick="LinkButton2_Click" 
                                                    OnClientClick="Wait('Loading...');return true;" 
                                                    meta:resourcekey="LinkButton2Resource1" ForeColor="White">
                                                    <span class="fa fa-refresh"></span>
                                                </asp:LinkButton>
                                                
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                                <div id="Local" class="panel-collapse collapse in">
                                    <div class="panel-body">
                                        <asp:Panel ID="LocalNetWork" runat="server" 
                                            meta:resourcekey="LocalNetWorkResource1">
                                            <asp:Panel ID="NoLocalSvr" runat="server" 
                                                meta:resourcekey="NoLocalSvrResource1">
                                                <div style="padding-top: 20px; padding-left: 30px;">
                                                    <asp:Localize meta:resourcekey="str_nosvr" runat="server">No server found in the local area network.</asp:Localize>
                                                </div>
                                            </asp:Panel>
                                            <asp:Panel ID="HasLocalSvr" runat="server" 
                                                meta:resourcekey="HasLocalSvrResource1">
                                                <div class="row " style="width: 100%; align-content: center; margin: 0;" align="center">
                                                    <asp:Repeater ID="LocalSvrs" runat="server">
                                                        <ItemTemplate>
                                                            <div class="col-xs-3 col-sm-3 col-md-2 col-lg-2 text-center topbuffer">
                                                                <a href="javascript:;" 
                                                                    onclick='ClickSvr(&#039;<%# DataBinder.Eval(Container.DataItem,"Name") %>&#039;,&#039;<%# DataBinder.Eval(Container.DataItem,"InstanceId") %>&#039;,&#039;<%# DataBinder.Eval(Container.DataItem,"FQDN") %>&#039;);'>
                                                                    <table width="95%">
                                                                        <tr>
                                                                            <td align="center">
                                                                                <img src="/portal/images/fileserverex.png" />
                                                                            </td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td align="center">
                                                                                <%#DataBinder.Eval(Container.DataItem,"Name") %>
                                                                            </td>
                                                                        </tr>
                                                                    </table>
                                                                </a>
                                                            </div>
                                                        </ItemTemplate>
                                                    </asp:Repeater>
                                                </div>
                                            </asp:Panel>
                                        </asp:Panel>
                                    </div>
                                </div>
                            </div>
                            <% } %>
                            
                            
                            <br/>
                            <div class="panel panel-info3">
                                <div class="panel-heading">
                                    <table width="100%">
                                        <tr>
                                                
                                            <td>
                                                <h4 class="panel-title">
                                                    <a data-toggle="collapse" href="#SAS"><asp:Localize meta:resourcekey="str_rsvrs" runat="server">Remote File Servers</asp:Localize></a>
                                                </h4>
                                            </td>
                                            
                                            <td align="right">
                                                <asp:LinkButton ID="LinkButton1" runat="server" onclick="LinkButton1_Click" 
                                                    OnClientClick="Wait('Loading...');return true;" 
                                                    meta:resourcekey="LinkButton1Resource1" ForeColor="White">
                                                    <span class="fa fa-refresh"></span>
                                                </asp:LinkButton>
                                                
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                                <div id="SAS" class="panel-collapse collapse in">
                                    <div class="panel-body">
                                        <asp:Panel ID="SeverAgents" runat="server" 
                                            meta:resourcekey="SeverAgentsResource1">
                                            <asp:Panel ID="NoServerAgents" runat="server" 
                                                meta:resourcekey="NoServerAgentsResource1">
                                                <div style="padding-top: 20px; padding-left: 30px;">
                                                    <asp:Localize meta:resourcekey="str_norsvrs" runat="server">No remote server found. You need to install the 'server agent' on the file server first 
                                                        for it to show here.</asp:Localize>
                                                </div>
                                            </asp:Panel>
                                            <asp:Panel ID="HasSvrAgent" runat="server" 
                                                meta:resourcekey="HasSvrAgentResource1">
                                                <div class="row " style="width: 100%; align-content: center; margin: 0;" align="center">
                                                    <asp:Repeater ID="SvrAgents" runat="server">
                                                        <ItemTemplate>
                                                            <div class="col-xs-3 col-sm-3 col-md-2 col-lg-2 text-center topbuffer">
                                                                <a href="javascript:;" 
                                                                    onclick='ClickSvr(&#039;<%# DataBinder.Eval(Container.DataItem,"Name") %>&#039;,&#039;<%# DataBinder.Eval(Container.DataItem,"InstanceId") %>&#039;,&#039;<%# DataBinder.Eval(Container.DataItem,"FQDN") %>&#039;);'>
                                                                    <table width="95%">
                                                                        <tr>
                                                                            <td align="center">
                                                                                <img src="/portal/images/fileserverex.png" />
                                                                            </td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td align="center">
                                                                                <%#DataBinder.Eval(Container.DataItem,"Name") %>
                                                                            </td>
                                                                        </tr>
                                                                    </table>
                                                                </a>
                                                            </div>
                                                        </ItemTemplate>
                                                    </asp:Repeater>
                                                </div>
                                            </asp:Panel>
                                        </asp:Panel>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </asp:Panel>
                    
                    <asp:Panel ID="RPCPanel1" runat="server" Visible="False" 
                        meta:resourcekey="RPCPanel1Resource1">
                            <div width="100%" align="center" style="height:400px; overflow: auto;">
                         <table width="90%" align="center">
                             <tr>
                                 <td style="padding: 5px;"><h3><asp:Localize meta:resourcekey="str_noreach" runat="server">Server can not be reached</asp:Localize></h3></td>
                             </tr>
                             <tr>
                                 <td style="padding: 5px;">
                                     <asp:Localize meta:resourcekey="str_nohelp" runat="server">If this server is not in the local network, download and install a server agent on the server. If you are sure it is located in the local network, follow instructions to enable RPC server.</asp:Localize>
                                 </td>
                             </tr>
                              <tr>
                                 <td style="padding: 5px;padding-top: 20px;" align="left">
                                     <asp:Button ID="Button2" runat="server" Width="128px" Text="Ok, I got it" CssClass="btn btn-primary gladbtn"
                                         onclick="CancelRPC_Click" meta:resourcekey="Button2Resource2" />
                                            <button type="button" class="btn btn-default " data-toggle="modal" data-target="#Instr" ><asp:Localize meta:resourcekey="str_instr" runat="server">Instructions</asp:Localize></button>
                                     
                                 </td>
                             </tr>

                            
                         </table>
                         </div>
                         </asp:Panel>
                    <asp:Panel ID="AddServerPanel" runat="server" Visible="False" 
                        meta:resourcekey="AddServerPanelResource1">
                        <table width="100%">
                            <tr>
                                <td></td>
                            </tr>
                            <tr>
                                <td align="center">
                                    <table width="90%">
                                        <tr>
                                            <td style="padding: 5px;padding-bottom: 10px;padding-top: 20px;">
                                                <li>
                                             <% if (SessionIsInstalledApp && !IsHosted && SessionIsClusterAdmin){ %>
                                                 <asp:Localize meta:resourcekey="str_nodir" runat="server">If the server can not be accessed directly from the web server, you can </asp:Localize>
                                             <%} %>     
                                             <a href="javascript:;" onclick="DownloadSA();return false;"><asp:Localize meta:resourcekey="str_dow" runat="server">Download </asp:Localize></a> <asp:Localize meta:resourcekey="str_13" runat="server">the server agent and install it on the file server, the file server will show up in the 'remote file server' list.</asp:Localize>
                                             </li>
                                            </td>
                                        </tr>
                                        <% if (SessionIsInstalledApp && !IsHosted ){ %>
                                        <tr>
                                            <td style="padding: 5px;padding-bottom: 10px;">
                                                <asp:Panel ID="ADConfigPanel" runat="server" 
                                                    meta:resourcekey="ADConfigPanelResource1">
                                                    <li>
                                                        <asp:Localize meta:resourcekey="str_14" runat="server">We can discover the available file server(s) from your Active Directory,</asp:Localize> <a href="LDAPCfgPage.aspx?vdid=<%=SessionDomainId %>"><asp:Localize meta:resourcekey="str_15" runat="server">Configure Active Directory Now!</asp:Localize></a>
                                                    </li>
                                                </asp:Panel>
                                            </td>
                                        </tr>

                                         <%if(SessionIsClusterAdmin){ %>
                                        <tr>
                                            <td style="padding: 5px;padding-bottom: 10px;">
                                            <li><asp:Localize meta:resourcekey="str_16" runat="server">If the file server you are looking for is located in the local network, please enter the info below to add it.</asp:Localize></li></td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px"><asp:Localize meta:resourcekey="str_17" runat="server">Server Name</asp:Localize></td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px">
                                                <asp:TextBox ID="NewServerName" runat="server" CssClass="form-control" 
                                                    meta:resourcekey="NewServerNameResource1"></asp:TextBox>
                                             </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px"><asp:Localize meta:resourcekey="str_18" runat="server">User Name</asp:Localize></td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px">
                                                <asp:TextBox ID="NewUserName" runat="server" CssClass="form-control" 
                                                    meta:resourcekey="NewUserNameResource1"></asp:TextBox>
                                             </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px"><asp:Localize meta:resourcekey="str_19" runat="server">Password</asp:Localize></td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px">
                                                <asp:TextBox ID="NewPassword" TextMode="Password" runat="server" 
                                                    CssClass="form-control" meta:resourcekey="NewPasswordResource1"></asp:TextBox>
                                             </td>
                                        </tr>
                                                                                <tr>
                                            <td style="padding: 10px">&nbsp;</td>
                                        </tr>

                                        
                                        <%} %>
                                        <%} %>
                                        <tr>
                                            <td style="padding: 5px; padding-top: 10px;border-top:1px solid #f0f0f0; " align="right">
                                                <% if (SessionIsInstalledApp && !IsHosted && SessionIsClusterAdmin ){ %>
                                                <asp:Button ID="AddServer" runat="server" Text="Add" CssClass="btn btn-primary gladbtn" OnClientClick="Wait('Wait');return true;"
                                                    onclick="AddServer_Click" meta:resourcekey="AddServerResource1" />
                                                <%} %>
                                                <asp:Button ID="CancelAdd" runat="server" Text="Cancel" 
                                                    CssClass="btn btn-default" OnClientClick="Wait('Wait');return true;" 
                                                    onclick="CancelAdd_Click" meta:resourcekey="CancelAddResource1"/>
                                            </td>
                                        </tr>
                                    </table>
                                    
                                </td>
                            </tr>
                        </table>
                    </asp:Panel>
                    
                    <asp:Panel ID="SharesPanel" runat="server" Visible="False" 
                        meta:resourcekey="SharesPanelResource1">
                        <div style="height: 20px;"></div>
                        <asp:Panel ID="NoShares" runat="server" meta:resourcekey="NoSharesResource1">
                            <div style="padding-left: 20px;padding-top: 30px;">
                                <asp:Localize meta:resourcekey="str_20" runat="server">No share found on this server. you can manually enter the share UNC path by clicking </asp:Localize><a style="color: #008000"
                                    href="ImportShareName.aspx?vdid=<%=SessionDomainId %>"><asp:Localize meta:resourcekey="str_21" runat="server">here</asp:Localize></a>.
                                    </div>
                        </asp:Panel>
                        <asp:Panel ID="HasShares" runat="server" meta:resourcekey="HasSharesResource1">
                            <div class="row " style="width: 100%; align-content: center; margin: 0;" align="center">
                                                    <asp:Repeater ID="SharesRepeater" runat="server">
                                                        <ItemTemplate>
                                                            <div class="col-xs-3 col-sm-3 col-md-2 col-lg-2 text-center topbuffer">
                                                                <a href="javascript:;" 
                                                                    onclick='ClickShare(&#039;<%# DataBinder.Eval(Container.DataItem,"Name") %>&#039;,&#039;<%# DataBinder.Eval(Container.DataItem,"Path") %>&#039;);'>
                                                                    <table width="95%">
                                                                        <tr>
                                                                            <td align="center">
                                                                                <img src="/portal/images/folder_network.png" />
                                                                            </td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td align="center" style="padding-bottom: 20px;">
                                                                                <%#DataBinder.Eval(Container.DataItem,"Name") %>
                                                                            </td>
                                                                        </tr>
                                                                    </table>
                                                                </a>
                                                            </div>
                                                        </ItemTemplate>
                                                    </asp:Repeater>
                                                </div>
                        </asp:Panel>
                        
                        <asp:Panel ID="AuthPanel" runat="server" Visible="False" 
                            meta:resourcekey="AuthPanelResource1">
                            <div width="100%" align="center">
                         <table width="90%" align="center">
                             <tr>
                                 <td style="padding: 5px;"><h3><asp:Localize meta:resourcekey="str_22" runat="server">Access Denied. Please specify an user account to continue</asp:Localize></h3></td>
                             </tr>
                             <tr>
                                 <td style="padding: 5px;">
                                     <asp:Localize meta:resourcekey="str_23" runat="server">User Name</asp:Localize>
                                 </td>
                             </tr>
                             <tr>
                                 <td style="padding: 5px;">
                                     <asp:TextBox ID="UserName" runat="server" CssClass="form-control" 
                                         meta:resourcekey="UserNameResource2"></asp:TextBox>
                                 </td>
                             </tr>
                             <tr>
                                 <td style="padding: 5px;">
                                     <asp:Localize meta:resourcekey="str_24" runat="server">Password</asp:Localize>
                                 </td>
                             </tr>
                             <tr>
                                 <td style="padding: 5px;">
                                     <asp:TextBox ID="Password" TextMode="Password" runat="server" 
                                         CssClass="form-control" meta:resourcekey="PasswordResource2"></asp:TextBox>
                                 </td>
                             </tr>
                             <tr>
                                 <td height="10px">&nbsp;</td>
                             </tr>
                             <tr>
                                 <td style="padding: 5px;" align="right">
                                     <asp:Button ID="AuthSvr" runat="server" Text="Refresh" CssClass="btn btn-primary gladbtn"
                                         onclick="AuthSvr_Click" meta:resourcekey="AuthSvrResource1" />
                                 </td>
                             </tr>

                         </table>
                         </div>
                         </asp:Panel>
                         
                         <asp:Panel ID="RPCPanel" runat="server" Visible="False" 
                            meta:resourcekey="RPCPanelResource1">
                            <div width="100%" style="height:500px;overflow: auto;"align="center">
                         <table width="90%" align="center">
                             <tr>
                                 <td style="padding: 5px;"><h3><asp:Localize meta:resourcekey="str_25" runat="server">Server can not be reached</asp:Localize></h3></td>
                             </tr>
                             <tr>
                                 <td style="padding: 5px;">
                                     <asp:Localize meta:resourcekey="str_26" runat="server">If you are sure the server is in the local network, follow instructions to change the configuration and try again.</asp:Localize>
                                 </td>
                             </tr>
                             <tr>
                                 <td height="10px">&nbsp;</td>
                             </tr>
                             <tr>
                                 <td style="padding: 5px;padding-left: 10px;" align="left">
                                     <asp:Button ID="Button1" runat="server" Text="Refresh Share List" 
                                         CssClass="btn btn-primary gladbtn" OnClientClick="Wait('Loading...');return true;"
                                         onclick="Refresh_Click" meta:resourcekey="Button1Resource2" />
                                     <button type="button" class="btn btn-default " data-toggle="modal" data-target="#Instr" ><asp:Localize meta:resourcekey="str_27" runat="server">Instructions</asp:Localize></button>
                                     
                                   
                                 </td>
                             </tr>
                             <tr>
                                 <td style="padding: 5px; height:300px; overflow: auto;"></td>
                             
                             </tr>
                             

                         </table>
                         </div>
                         </asp:Panel>
                    
                    </asp:Panel>
                </td>
            </tr>
        </table>
    </asp:Panel>
    <div id="Instr" class="modal fade" role="dialog" >
                    <div class="modal-dialog" style="width:90%;">

    <!-- Modal content-->
    <div class="modal-content" >
      <div class="modal-header" style="background-color: #e0e0e0">
          <h4 class="modal-title"><asp:Localize runat="server" meta:resourcekey="str_hlp">Help</asp:Localize></h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        
      </div>
      <div class="modal-body" >
       <p>Windows 2003 <asp:Localize runat="server" meta:resourcekey="str_and">and</asp:Localize> <asp:Localize meta:resourcekey="str_win200R2" runat="server">Windows 2003 R2</asp:Localize></p>
                                    <p class="text-muted">
                                        <asp:Localize runat="server" meta:resourcekey="str_win03Hlp">The following needs to be run at the command prompt:</asp:Localize><br/>
                                        <asp:Localize meta:resourcekey="str_netFirSetSerTypRemMod" runat="server">netsh firewall set service type = remoteadmin mode = enable</asp:Localize>
                                            </p>

                                    <p><asp:Localize runat="server" meta:resourcekey="str_Win200">Windows 2008</asp:Localize></p>
                                    <p class="text-muted">
                                        <asp:Localize runat="server" meta:resourcekey="str_win08Hlp">Start | Control Panel | Windows Firewall then select “Allow a program through Windows Firewall”.  Select the Exceptions tab.  Scroll down and click on check box next to “Windows Management Instrumentation (WMI)” then click OK.</asp:Localize>
                                    </p>

                                    <p><asp:Localize runat="server" meta:resourcekey="str_Win200R2">Windows 2008 R2</asp:Localize></p>
                                    <p class="text-muted">
                                        <asp:Localize runat="server" meta:resourcekey="str_win08R2Hlp">Start | Control Panel | System and Security | Windows Firewall then select “Allow a program or feature through Windows Firewall”.  Scroll down and click on check box next to “Windows Management Instrumentation (WMI)” which should automatically select the check box in the Domain column.  Click OK.</asp:Localize>
                                    </p>

                                    <p><asp:Localize meta:resourcekey="str_win201" runat="server">Windows 2012</asp:Localize> <asp:Localize runat="server" meta:resourcekey="str_and">and</asp:Localize> <asp:Localize meta:resourcekey="str_win201R2" runat="server">Windows 2012 R2</asp:Localize></p>
                                    <p class="text-muted">
                                        <asp:Localize runat="server" meta:resourcekey="str_win12HlpA">Open Server manager (open by default) and click on Local Server on the left side of the screen.  In the Properties box, click on setting to the right of the label Windows Firewall (Domain: On). You can also get to the Windows Firewall setting by selecting Control Panel | System and Security | Windows Firewall</asp:Localize>

                                        <asp:Localize runat="server" meta:resourcekey="str_win12HlpB">Select “Allow an app or feature through Windows Firewall”.  Scroll down and click on check box next to “Windows Management Instrumentation (WMI)” which should automatically select the check box in the Domain column.  Click OK.</asp:Localize>
                                 </p>

                                    <p><asp:Localize runat="server" meta:resourcekey="str_Win7">Windows 7</asp:Localize></p>
                                    <p class="text-muted">
                                        <asp:Localize meta:resourcekey="str_staConPanSysAndSec" runat="server">Start | Control Panel | System and Security | Windows Firewall then select “Allow a program or feature through Windows Firewall”. Scroll down and click on check box next to “File and Printer Sharing” and “Windows Management Instrumentation (WMI)” which should automatically select the check box in the Domain column. Click OK.</asp:Localize><br/>
<asp:Localize meta:resourcekey="str_nexStaTheRemRegSerWhiIs" runat="server">Next start the Remote Registry service which is set to Manual by default (set to Automatic). If not data such as installed software, event logs, security policies, etc. will not be retrieved.</asp:Localize>
                                    </p>
                                    <p><asp:Localize runat="server" meta:resourcekey="str_Win8Win81AndWin10">Windows 8, Windows 8.1, and Windows 10</asp:Localize></p>
                                    <p class="text-muted">
                                        <asp:Localize runat="server" meta:resourcekey="str_win8HlpA">In the lower left-hand corner of the screen right click and select Control Panel.  Then select System and Security | Windows Firewall then select “Allow an app or feature through Windows Firewall”.  Scroll down and click on check box next to “File and Printer Sharing” and “Windows Management Instrumentation (WMI)” which should automatically select the check box in the Domain column.  Click OK.</asp:Localize> 
                                        <br /><asp:Localize runat="server" meta:resourcekey="str_win8HlpB">Next start the Remote Registry service which is set to Disabled by default (set to Automatic).  If not data such as installed software, event logs, security policies, etc. will not be retrieved.</asp:Localize>
                                    </p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal"><asp:Localize meta:resourcekey="str_cls" runat="server">Close</asp:Localize></button>
      </div>
    </div>

  </div>
                    </div>
    <div style="display: none;">
        <asp:Button ID="QueryShares" runat="server" Text="Button" 
            onclick="QueryShares_Click" meta:resourcekey="QuerySharesResource1" />
        <asp:Button ID="SelectShare" runat="server" Text="Button" 
            onclick="SelectShare_Click" meta:resourcekey="SelectShareResource1" />
        <asp:HiddenField ID="ServerName" runat="server" />
        <asp:HiddenField ID="ServerFQDN" runat="server" />
        <asp:HiddenField ID="ServerInstanceId" runat="server" />
        <asp:HiddenField ID="ShareName" runat="server" />
        <asp:HiddenField ID="SharePath" runat="server" />
    </div>
  </div>
    <div class="footer x-panel-header-light" style="border-left: 0; border-right: 0;
        border-bottom: 0; vertical-align: middle; margin: 0;">
        <table width="100%" style="height: 64px; text-align: right; padding-right: 64px;"
            align="right">
            <tr>
                
                <td align="right" style="padding-right: 10px;">
                    <% if (SessionIsInstalledApp && !IsHosted)
                       { %>
                        <asp:Button ID="LinkButton3" runat="server" Text="Manual Configuration"
                            CausesValidation="False" OnClick="OnContinueClick" OnClientClick="Wait('Save settings')"
                            CssClass="btn btn-primary gladbtn" meta:resourcekey="LinkButton3Resource1"></asp:Button>
                    <% } %>
                    
                        <asp:Button ID="ButtonBack" runat="server" 
                            OnClientClick="showLoader(this.parentNode)" TabIndex="7" CssClass="btn btn-default" Text="Cancel"
                            CausesValidation="False" OnClick="ButtonBack_Click" meta:resourcekey="ButtonBackResource1"></asp:Button>
                    
                </td>
            </tr>
        </table>
    </div>
    <script type="text/javascript">
        function AdjustMainDiv() {
            
            var h = 400;

            try {

               

                h = document.body.offsetHeight - 70;
                if (h < 108) {
                    h = 108;
                }
                var e = document.getElementById("maindiv");
                e.style.height = h + "px";

            } catch (err) {
            }
            
        }
        Ext.EventManager.onWindowResize(function () {
            AdjustMainDiv();
        });

        AdjustMainDiv();
    </script>
</asp:Content>
