﻿<%@ Page Title="Gladinet Cloud - Role Manager" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="RoleMgrPage.aspx.cs" Inherits="GladinetPayFlow.RoleMgrPage"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">

    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        .actiontbl{
        display: table;
        }
        .actioncol{
        display: table-cell;margin-top:5px;
        }
        .actioncol .gladinet-icons {
        padding-left:10px;
        }
		.actioncol .tooltip{
            margin:20px 0px 0px 5px !important;  /*tooltip positioning*/ 
		}
        
        .securityicon
        {
            background-image: url(/portal/images/security2.png);
        }
        .groupicon
        {
            background-image: url(/portal/images/group.png);
        }
        textarea {color:rgba(90,90,90,0.8) !important;border-top:1px solid rgb(204, 204, 204);border-left:1px solid rgb(204, 204, 204);border-right:1px solid rgb(204, 204, 204);}
        .errorMsg{color:#D00000 !important;font-weight:100!important;}
        .successMsg{font-weight:100!important;color:#0b6e02 !important;}
        .pnlLayer {margin-top:20px;margin-bottom:40px;padding-left:10px;padding-right:10px;}
        .pnlLayer label,.pnlLayer span {font-size:14px !important;}
    </style>
    <script type="text/javascript">
        var ActiveWin;
        var MainWnd;

        function OpenHtmlWindow(id, title, Html) {

            ActiveWin = new Ext.Window({
                id: id,
                title: title,
                width: 728,
                height: maxh(676),
                plain: true,
                modal: true,
                maximizable: true,
                maximized: false,
                constrain: true,
                bodyPadding: 5,
                resizable: true,
                shadow: 'drop',
                iconCls: 'publish',
                bodyStyle: 'background:#dfe8f6;border:0px; ',
                shadowOffset: 10,
                html: Html,
                defaults: {
                    border: false
                }
            });
            ActiveWin.show();

        }


        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //parent.setActivePanel("PubMgr");

        function Unpublish(id, name) {
            var h = "GroupMgrPage.aspx?op=delete&id=" + id;

            if (confirm("<asp:Localize meta:resourcekey="string1" runat="server">Do you really want to delete (</asp:Localize>" + unescape(name) + ")?"))
            window.location = h;
        }




        function closeActiveWin() {


            window.location = window.location;

        }

        function closeCancelActiveWin() {
            ActiveWin.close();
        }

        function AddRole() {
            parent.SetRelativePageTitle("<asp:Localize meta:resourcekey="string3" runat="server">Add User</asp:Localize>", '/management/EditRole.aspx?src=mgr&vdid=<%=SessionDomainId %>');
            window.location = '/management/EditRole.aspx?src=mgr&vdid=<%=SessionDomainId %>';
            //parent.parent.AddRoleWithDomain('<%=SessionDomainId %>');
        }
        function ExportRoles() {
            try{
                $("#<%=pnlImpRoles.ClientID%>").hide();
            }catch(ex){}
            var panelObj = $("#<%=pnlExpRoles.ClientID%>");
            var panelIsVisible = (panelObj.length>0 && panelObj.is(":visible"));
            if(panelIsVisible) panelObj.hide();
            else setTimeout(function(){document.getElementById("<%=btnExpRoles.ClientID%>").click();},200);
        }
        function OpenImportRoles() {
            try{
                $("#<%=pnlExpRoles.ClientID%>").hide();
            }catch(ex){}
            var panelObj = $("#<%=pnlImpRoles.ClientID%>");
            var panelIsVisible = (panelObj.length>0 && panelObj.is(":visible"));
            if(panelIsVisible) panelObj.hide();
           setTimeout(function(){document.getElementById("<%=btnOpenImpRoles.ClientID%>").click();},200);
        }
        function CopyCode(){
            var obj = document.getElementById('<%=txtExpRoles.ClientID %>');
            var txt = obj.value;

            if (window.clipboardData && window.clipboardData.setData) {
                // IE specific code path to prevent textarea being shown while dialog is visible.
                clipboardData.setData("Text", txt);
                $("#<%=lblExpMsg.ClientID%>").html("<%=LocCpdCpb.Text %>"); //Copied to clipboard
                $("#<%=lblExpMsg.ClientID%>").removeClass("errorMsg");
                $("#<%=lblExpMsg.ClientID%>").addClass("successMsg");
                setTimeout(function(){$("#<%=pnlExpRoles.ClientID%>").hide();},3000);

            } else if (document.queryCommandSupported && document.queryCommandSupported("copy")) {
                obj.select();
                try {
                    document.execCommand("copy"); // Security exception may be thrown by some browsers.
                    $("#<%=lblExpMsg.ClientID%>").html("<%=LocCpdCpb.Text %>"); //Copied to clipboard
                    $("#<%=lblExpMsg.ClientID%>").removeClass("errorMsg");
                    $("#<%=lblExpMsg.ClientID%>").addClass("successMsg");
                    setTimeout(function(){$("#<%=pnlExpRoles.ClientID%>").hide();},3000);
                } catch (ex) {
                    console.warn("Copy to clipboard failed.", ex);
                    return false;
                }
            }
        }
        function ImportRoles() {
           setTimeout(function(){document.getElementById("<%=btnImportRoles.ClientID%>").click();},200);
        }

        function EditRole(groupid) {
            parent.SetRelativePageTitle("<asp:Localize meta:resourcekey="js_edit_group" runat="server">Add User</asp:Localize>", '/management/EditRole.aspx?src=mgr&vdid=<%=SessionDomainId %>&RoleId=' + groupid);
            window.location = '/management/EditRole.aspx?src=mgr&vdid=<%=SessionDomainId %>&RoleId='+groupid;
            
            //parent.parent.EditRoleWithDomain(groupid, '<%=SessionDomainId %>');
            //var uri = "<iframe id='add_role_window' src='/management/EditRole.aspx?src=mgr&RoleId=" + groupid;
            //uri += "' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0;border:0;'></iframe>";            
            //OpenHtmlWindow('add_group', "Edit Role", uri);

        }


        function DeleteRole(rid) {
            

            gConfirm("<asp:Localize meta:resourcekey="str_confirm" runat="server">Do you really want to delete the role</asp:Localize>?", "", function (btn1) {

                    if (btn1 != 'ok')
                        return;
                    var e = document.getElementById("ctl00_MainContent_RoleId");
                    var b = document.getElementById("ctl00_MainContent_DeleteRole");

                    e.value = rid;
                    b.click();
                });
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocBadRolId" meta:resourcekey="str_badRolId" Visible="false">Bad Role Id</asp:Localize>    
     <div style="width: 100%; padding: 5px; border-bottom: 1px solid #cccccc ;" class="meubardrop1">
                <table style="width: 100%" border="0">
                    <tr>
                        <td>
                            <span class="gladbtn" style="font-weight: 400!important; font-size: 20px!important; text-transform: uppercase; color:#808080!important;"><asp:Localize meta:resourcekey="str_roles" runat="server">Roles</asp:Localize></span>
                        </td>
                        <td>
                               <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                        </td>
                        <td height="48px"><asp:Label ID="PubFolderCount" runat="server" meta:resourcekey="PubFolderCountResource1" CssClass="badge hollowbadge"></asp:Label></td>
                        <td align="right" style=" height: 48px" valign="middle">
                            
                             <%if (m_CanAdd)
                                                  { %>
 
              
                            <a href="javascript:;" onclick="AddRole();return false;" style="font-size: 12px;" >
                                 <button type="button" class="btn btn-primary gladbtn navbar-btn navbar-right" style="margin-right:8px;" title="<%=Localize2.Text %>">   <span class="fa fa-plus sectextcolor" aria-hidden="true" style="font-size: 14px; margin-left: 11px; margin-top: 14px; cursor: pointer; display: inline-block; position: absolute;" ></span>

                                                                                    <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 0px;" >6</i>
                                    <asp:Localize ID="Localize2" meta:resourcekey="string3" runat="server" Visible="false">Create New Role</asp:Localize>
                                 </button>
                                </a>
                                             
                                                <%} %>
                        </td>
                        <td>
                             <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 0px;margin-bottom: 5px;line-height:24px;" onclick="ExportRoles()" title="<%=LocExpRls.Text %>">&#xB2;</i>
                        <asp:Localize ID="LocExpRls" meta:resourcekey="strExpRls" runat="server" Visible="false">Export Roles</asp:Localize>
                        <div style="display:none;"><asp:Button ID="btnExpRoles" runat="server" onclick="OnExportClick" /></div>

                        <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 0px;margin-bottom: 5px;margin-left: 20px;line-height:24px;" onclick="OpenImportRoles()" title="<%=LocImpRls.Text %>">&#x14E;</i>
                        <asp:Localize ID="LocImpRls" meta:resourcekey="strImpRls" runat="server" Visible="false">Import Roles</asp:Localize>
                        <div style="display:none;"><asp:Button ID="btnOpenImpRoles" runat="server" onclick="OpenImportClick" /></div>
                        </td>
                        <td align="right" style="width: 40px; padding-right: 10px; height: 48px;">
                            <%if (m_CanSetPerm)
                                                  { %>
                                        <div type="button" class="btn btn-default navbar-btn navbar-right" style="margin-right: 8px; display:none;">
                 <span class="fa fa-wrench" aria-hidden="true"></span>
                                                    <asp:LinkButton ID="LinkButton1" runat="server"
                                                        OnClientClick="parent.SetAcls('/RoleManager');return false;" 
                                                        meta:resourcekey="LinkButton1Resource1">
                          
                <asp:Localize ID="Localize3" meta:resourcekey="string2" runat="server">Security</asp:Localize>
                                                    </asp:LinkButton>
                                                </div>
                                                <%} %>
             <div class="navbar-right sectextcolor" style="width:40px; font-size:32px;  font-weight:100; cursor:pointer;padding-top:5px;" onclick="ReturnLast();">&times;</div>
                        </td>
                    </tr>
                 
                </table>
            </div>

     

    <asp:Panel ID="pnlExpRoles" runat="server" Visible="false" CssClass="pnlLayer">
        <label for="<%=txtExpRoles.ClientID %>"><asp:Localize ID="LocExpDsc" meta:resourcekey="strExpDsc" runat="server">Copy the code below to export your roles:</asp:Localize></label>
        <asp:TextBox ID="txtExpRoles" runat="server" TextMode="MultiLine" Rows="10" Width="100%" style="border-color:#cecece;padding:10px;"></asp:TextBox>
        <script type="text/javascript">
        document.getElementById('<%=txtExpRoles.ClientID %>').focus();
        document.getElementById('<%=txtExpRoles.ClientID %>').select();
        </script>
        <asp:Localize ID="LocCpyCde" meta:resourcekey="strCpyCde" runat="server" Visible="false">Copy Code to Clipboard</asp:Localize>
        <asp:Localize ID="LocCpdCpb" meta:resourcekey="strCpdCpb" runat="server" Visible="false">Copied to Clipboard</asp:Localize>
        <div class="btn btn-default" style="display:inline-block; margin-top: 0px;margin-bottom: 5px;line-height:24px;" onclick="CopyCode()"><%=LocCpyCde.Text %></div> 
        <asp:Label id="lblExpMsg" runat="server" style="color:#D00000;font-weight:100!important;"></asp:Label>            
        <asp:Localize ID="LocNthExp" meta:resourcekey="strNthExp" runat="server" Visible="false">Nothing to export</asp:Localize>
        <asp:Localize ID="LocFldExpRls" meta:resourcekey="strFldExpRls" runat="server" Visible="false">Failed to Export Roles</asp:Localize>                        
    </asp:Panel>

    <asp:Panel ID="pnlImpRoles" runat="server" Visible="false" CssClass="pnlLayer">
        <label id="lbl<%=txtImpRoles.ClientID %>" for="<%=txtImpRoles.ClientID %>"><asp:Localize ID="LocImpDsc" meta:resourcekey="strImpDsc" runat="server">To import roles, paste the code from previously exported roles below:</asp:Localize></label>
        <asp:TextBox ID="txtImpRoles" runat="server" TextMode="MultiLine" Rows="10" Width="100%" style="border-color:#cecece;padding:10px;"></asp:TextBox>
        <div id="btnImportRolesClnt" class="btn btn-default" style="display:inline-block; margin-top: 0px;margin-bottom: 5px;line-height:24px;" onclick="ImportRoles()"><%=LocImpRls.Text %></div> 
        <div style="display:none;"><asp:Button ID="btnImportRoles" runat="server" onclick="OnImportClick" /></div>
        <asp:Label id="lblImpMsg" runat="server"></asp:Label> 
        <asp:Localize ID="LocFldImpRls" meta:resourcekey="strFldImpRls" runat="server" Visible="false">Failed to Import Roles</asp:Localize>
        <asp:Localize ID="LocRlsImpScs" meta:resourcekey="strRlsImpScs" runat="server" Visible="false">Roles imported successfully</asp:Localize>
        <asp:Localize ID="LocIncImpStr" meta:resourcekey="strIncImpStr" runat="server" Visible="false">Incorrect import string</asp:Localize>
        <asp:Localize ID="LocEmtImpStr" meta:resourcekey="strEmtImpStr" runat="server" Visible="false">Missing import string</asp:Localize>
        <script type="text/javascript">
            function hideObj(id){
                document.getElementById(id).style.display="none";
            }
            var successFromServer = document.getElementById('<%=lblImpMsg.ClientID %>').innerText=="<%=LocRlsImpScs.Text%>";
            if(successFromServer){
                hideObj("lbl<%=txtImpRoles.ClientID %>");
                hideObj("<%=txtImpRoles.ClientID %>");
                hideObj("btnImportRolesClnt");
                setTimeout(function(){
                    $("#<%=pnlImpRoles.ClientID %>").hide();
                },3000);
            }
        </script>              
    </asp:Panel>

    <table id="grid-table" width="100%" align="center" border="0" cellspacing="0" cellpadding="0" style="
        <% if (!ZeroPubFolder)
           { %>
        background-color: white; 
        <% }%>
           padding: 2px; margin-top: 20px;">
        <tr>
            <td colspan="3" style="padding-top: 0px; vertical-align: top;">
                <% if (!ZeroPubFolder)
                   { %>
                <div id="grid-example"></div>
                <%} %>
            </td>
        </tr>
        <tr>
            <td colspan="3" valign="top">
                <% if (ZeroPubFolder)
                   { %>
                <div style="margin: 36px; margin-left: 66px; margin-right: 66px; vertical-align: top; padding-top: 8px; padding-bottom: 8px; 
                    height: auto; width: 600px; font-size:32px; font-weight:100; color:#808080;">
                    <asp:Localize ID="Localize1" meta:resourcekey="string4" runat="server">"No roles have been created</asp:Localize>&nbsp;
                </div>
                <%} %>
            </td>
        </tr>
    </table>
               
    <div style="display: none;">
    <asp:HiddenField ID="RoleId" runat="server"></asp:HiddenField>
    <asp:Button ID="DeleteRole" runat="server" Text="Button" 
        onclick="DeleteRole_Click" />
        </div>
    <script type="text/javascript">
  var myData = [
 <asp:Repeater ID="PubsRepeater" runat="server" >
        <ItemTemplate>
       <%#(Container.ItemIndex == 0)? "": "," %>     ['<%#(((RepeaterItem)Container).ItemIndex+1) %>','<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "RoleName").ToString().Replace("'","%27"))%>', '<%#DataBinder.Eval(Container.DataItem,"RoleId") %>']
        
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
    <script type="text/javascript">
        var grid;
        function ReturnLast() {
            parent.ReturnLast();
      }
        function AdjustGridTable() {
            isMobileBrowserOrNarrow();
            var h = 400;

            try {

                var myTable = Ext.get('grid-table');
                var tableY = myTable.getY();

                //var mySetting = Ext.get('farm-setting');
                var settingH = 0; // mySetting.getHeight();

                h = document.body.offsetHeight - tableY - 8 - settingH;
                //var ee = document.getElementById('tinfo');
                //ee.style.height = h + "px";
                if (h < 108) {
                    h = 108;
                }

                grid.setWidth(document.documentElement.clientWidth - 4);
                grid.setHeight(h);
                grid.doComponentLayout();

            } catch (err) {
            }


        }
      Ext.require([
          'Ext.grid.*',
          'Ext.data.*',
          'Ext.util.*',
          'Ext.state.*'
      ]);
      Ext.onReady(function () {

          Ext.QuickTips.init();


          var store = Ext.create('Ext.data.ArrayStore', {
              fields: [
                  { name: 'index' },
                  { name: 'rolename' },
                  { name: 'gid' }
              ],
              data: myData
          });

           var d = document.getElementById("grid-example");
          var h = 400;
          
          try {
            h = d.offsetHeight-10;  // in IE8, this is very narrow like = 1
            h1 = document.body.offsetHeight;
            if (h1 > 300) {
                h1 = h1 - 36; // paddings , margins, whatever
            }
            if (h<50) {
                // this shall only happen for IE8
                gridY = Ext.get("grid-example").getY();
                h = h1 - gridY;
                if (h<218) {
                  h=218;
                }
            }
           } catch (err) {
           }

          grid = Ext.create('Ext.grid.Panel', {              
              frame: false,
              border:1,
              store: store,
              stripeRows: true,
              columnLines: false,
              minHeight : 218,
              height:h, 
              columns: [
                  {
                      text: '',
                      width: 50,
                      sortable: false,
                      dataIndex: 'index',
                      getClass: function (v, meta, rec) {
                          return 'x-col-hdide';
                      }
                  },
                  {
                      text: "<span style='color:#565656; font-weight:100'><asp:Localize meta:resourcekey="js_group_name" runat="server">Role Name</asp:Localize></span>",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'rolename',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<span style='color:#808080; font-weight:100'>" + unescape(value) + "</span>";
                      }

      }, {
          sortable: false,
          width:100,
          renderer: function (value, metaData, record, rowIndex) {
              var rec = grid.getStore().getAt(rowIndex);
              var d = rec.data;
              var ndeNme = d.nodename; 
              var edtTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="js_edit_group" runat="server">Edit Role</asp:Localize>\"";
              var delTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="js_string10" runat="server">Delete Role</asp:Localize>\""; 
              var resPwTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="str_storagedetail" runat="server">Storage Usage Detail</asp:Localize>\""; 
              //==================================================================
              var edtBtn = "<div class=\"actioncol\"><i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"EditRole('"+d.gid+"')\" "+edtTTip+">/</i></div>";
              <%if(!m_CanEdit){ %>
              edtBtn = "";
              <%} %>
              //==================================================================
              var delBtn = "<div class=\"actioncol\"><i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"DeleteRole('"+d.gid+"',&quot;"+d.rolename+"&quot;)\" "+delTTip+">n</i></div>";
              <%if(!m_CanDelete){ %>
              delBtn = "";
              <%} %>
              //==================================================================
              return "<div class=\"actiontbl\">"+edtBtn+delBtn+"</div>";
          }
      }
     ],
              renderTo: 'grid-example'
          });

          try {
            parent.ClearRelativePageTitle();
        } catch (e) {
            
        }

          Ext.EventManager.onWindowResize(AdjustGridTable);
          AdjustGridTable();

        });
        
        //after a wizard is complete, such as role creation, this page will reload.
        //if we don't reset the breadcrum, then the wizard will be complete, but the breadcrum will still say role manager > create new role
        setTimeout(function(){
            try {     
                <% if (IsServo) { %>   
                    if(parent.parent.SetSubSubTitle)  parent.parent.SetSubSubTitle("");
                <% } else { %>
                    if(parent.SetSubTitle)  parent.SetSubTitle("");     
                <% } %>
            } catch (e) {}
        },100);
    </script>
</asp:Content>
