﻿<%@ Page Title="Reset Password" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="ResetUserPassword.aspx.cs" Inherits="GladinetPayFlow.ResetUserPassword"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
        <link rel="stylesheet" type="text/css" href="/webui/ext4/resources/css/ext-all.css" />
    <style type="text/css">
        td
        {
            font-size: 15px;
            
            font-weight: 100;
        }
        
        b
        {
            font-weight: 500;
        }
        
        .badgefont
        {
            font-size: 15px;
            
        }
    </style>

    <script type="text/javascript">

        var Base64 = {

            // private property
            _keyStr: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",

            // public method for encoding
            encode: function (input) {
                var output = "";
                var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
                var i = 0;

                input = Base64._utf8_encode(input);

                while (i < input.length) {

                    chr1 = input.charCodeAt(i++);
                    chr2 = input.charCodeAt(i++);
                    chr3 = input.charCodeAt(i++);

                    enc1 = chr1 >> 2;
                    enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
                    enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
                    enc4 = chr3 & 63;

                    if (isNaN(chr2)) {
                        enc3 = enc4 = 64;
                    } else if (isNaN(chr3)) {
                        enc4 = 64;
                    }

                    output = output +
        this._keyStr.charAt(enc1) + this._keyStr.charAt(enc2) +
        this._keyStr.charAt(enc3) + this._keyStr.charAt(enc4);

                }

                return output;
            },

            // public method for decoding
            decode: function (input) {
                var output = "";
                var chr1, chr2, chr3;
                var enc1, enc2, enc3, enc4;
                var i = 0;

                input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");

                while (i < input.length) {

                    enc1 = this._keyStr.indexOf(input.charAt(i++));
                    enc2 = this._keyStr.indexOf(input.charAt(i++));
                    enc3 = this._keyStr.indexOf(input.charAt(i++));
                    enc4 = this._keyStr.indexOf(input.charAt(i++));

                    chr1 = (enc1 << 2) | (enc2 >> 4);
                    chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
                    chr3 = ((enc3 & 3) << 6) | enc4;

                    output = output + String.fromCharCode(chr1);

                    if (enc3 != 64) {
                        output = output + String.fromCharCode(chr2);
                    }
                    if (enc4 != 64) {
                        output = output + String.fromCharCode(chr3);
                    }

                }

                output = Base64._utf8_decode(output);

                return output;

            },

            // private method for UTF-8 encoding
            _utf8_encode: function (string) {
                string = string.replace(/\r\n/g, "\n");
                var utftext = "";

                for (var n = 0; n < string.length; n++) {

                    var c = string.charCodeAt(n);

                    if (c < 128) {
                        utftext += String.fromCharCode(c);
                    }
                    else if ((c > 127) && (c < 2048)) {
                        utftext += String.fromCharCode((c >> 6) | 192);
                        utftext += String.fromCharCode((c & 63) | 128);
                    }
                    else {
                        utftext += String.fromCharCode((c >> 12) | 224);
                        utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                        utftext += String.fromCharCode((c & 63) | 128);
                    }

                }

                return utftext;
            },

            // private method for UTF-8 decoding
            _utf8_decode: function (utftext) {
                var string = "";
                var i = 0;
                var c = c1 = c2 = 0;

                while (i < utftext.length) {

                    c = utftext.charCodeAt(i);

                    if (c < 128) {
                        string += String.fromCharCode(c);
                        i++;
                    }
                    else if ((c > 191) && (c < 224)) {
                        c2 = utftext.charCodeAt(i + 1);
                        string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                        i += 2;
                    }
                    else {
                        c2 = utftext.charCodeAt(i + 1);
                        c3 = utftext.charCodeAt(i + 2);
                        string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                        i += 3;
                    }

                }

                return string;
            }

        }

        function BeforeSubmit() {
            var e = document.getElementById("MainContent_txtPassword1");
            e.value = "!0!0!" + Base64.encode(e.value);
            e = document.getElementById("MainContent_txtPassword2");
            e.value = "!0!0!" + Base64.encode(e.value);
            Wait('One minute...');
        }

        function CloseWin() {
            try {
                parent.closeCancelActiveWin();
            } catch (e) {

            }

            try {
                if (parent.activewin)
                    parent.activewin.close();
            } catch (e1) {

            }
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Localize ID="LocFaiToChaPas" meta:resourcekey="str_faiToChaPas" Visible="false" runat="server">Failed to change password</asp:Localize>

<asp:Localize runat="server" ID="LocFaiToResPas" meta:resourcekey="str_faiToResPas" Visible="false">Failed to reset password</asp:Localize>
<asp:Localize runat="server" ID="LocPasDoeMat" meta:resourcekey="str_pasDoeMat" Visible="false">Password doesn't match</asp:Localize>
<asp:Localize runat="server" ID="LocInvPas" meta:resourcekey="str_invPas" Visible="false">Invalid Password</asp:Localize>
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        
        html, body
        {
            height: 100%;
        }
        .main, #aspnetForm
        {
            height: 100%;
        }
        .wrapper
        {
            min-height: 100%;
            height: auto !important;
            height: 100%;
            padding: 0px;
            background-color: white;
            margin: 0 auto -69px; /* the bottom margin is the negative value of the footer's height */
        }
        .footer, .push
        {
            height: 68px; /* .push must be the same height as .footer */
        }
        .body2
        {
            background: #f0f0f0 url('images/signupbg.jpg');
            background-size: 100%;
        }
    </style>
    <div class="x-panel-header-light body2" style="width: 100%; height: 100%; margin: 0;
        padding: 0; border: 0px; align-content: center;">
        <table width="100%" height="100%" style="opacity: 0.85">
            <tr>
                <td align="center" valign="middle">
                    <table width="600px" align="center" style="padding: 10px; background-color: white;">
                        <tr>
                            <td colspan="2" 
                                style="height: 48px; border-top: 0; border-left: 0; border-right: 0; padding-left: 16px; border-bottom: 0; background-color: #f0f0f0;
                                vertical-align: middle; text-align: left; font-size: 16px;">
                                <asp:Localize ID="Localize1" meta:resourcekey="asp_string4" runat="server" Text="User"></asp:Localize>
                                :
                                <asp:Label ID="LabelEmail" runat="server" meta:resourcekey="LabelEmailResource1"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td style="padding-top: 0px;">
                                <div style="background-color: white; : 0px solid white; padding: 16px; padding-top: 2px;">
                                    <% if (!string.IsNullOrEmpty(ErrorMsg.Text))
                                       { %>
                                    <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" CssClass="errmsg" meta:resourcekey="ErrorMsgResource1"></asp:Label>
                                    <%} %>
                                    <span style="color: #008000">
                                        <asp:Localize ID="Localize2" meta:resourcekey="asp_string1" runat="server" Text="You must change your password to continue"></asp:Localize></span>
                                    <br />
                                    <br/>
                                    <table width="96%" align="center">
                                        <tr>
                                            <td valign="top">
                                                <asp:Localize ID="Localize3" meta:resourcekey="asp_string2" runat="server" Text="Password :"></asp:Localize>
                                            </td>
                                            <td>
                                                <asp:TextBox ID="txtPassword1" runat="server" Width="362px" TextMode="Password" CssClass="form-control"
                                                     meta:resourcekey="txtPassword1Resource1"></asp:TextBox><br />
                                                <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ErrorMessage="Password is required"
                                                    ControlToValidate="txtPassword1" ValidationGroup="RPWD" CssClass="errmsg" meta:resourcekey="RequiredFieldValidator1Resource1"></asp:RequiredFieldValidator>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td valign="top">
                                                <asp:Localize ID="Localize4" meta:resourcekey="asp_string3" runat="server" Text="Confirm Password:"></asp:Localize>
                                            </td>
                                            <td>
                                                <asp:TextBox ID="txtPassword2" runat="server" Width="362px" TextMode="Password" CssClass="form-control"
                                                     meta:resourcekey="txtPassword2Resource1"></asp:TextBox><br />
                                                <asp:CompareValidator ID="CompareValidator1" runat="server" ErrorMessage="Passwords are not identical"
                                                    ControlToCompare="txtPassword1" ValidationGroup="RPWD" ControlToValidate="txtPassword2"
                                                    CssClass="errmsg" meta:resourcekey="CompareValidator1Resource1"></asp:CompareValidator>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td style="background-color: #f0f0f0;padding: 10px;" align="right">
                                <asp:Button ID="btnSubmit" runat="server" Text="Submit" OnClientClick="BeforeSubmit();" CssClass="btn btn-primary gladbtn"
                                    CausesValidation="False" OnClick="btnSubmit_Click" Width="128px" meta:resourcekey="btnSubmitResource1" />
                                
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
        <table style="position: absolute; left: 0px; top: 10px;">
            <tr>
                <td style="padding-left: 10px;">
                    <asp:Image ID="WebAppIcon" runat="server" Height="48px" meta:resourcekey="WebAppIconResource1" />
                </td>
                <td style="color: white; padding-left: 10px;">
                    <h1>
                        <asp:Label ID="ProductLable" runat="server" meta:resourcekey="ProductLableResource1"></asp:Label>
                    </h1>
                </td>
            </tr>
        </table>
    </div>
</asp:Content>
