﻿<%@ Page Title="Gladinet Cloud - User Manager" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="PolicyMgrPage.aspx.cs" Inherits="GladinetPayFlow.PolicyMgrPage"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        
        
        .securityicon
        {
            background-image: url(/portal/images/security2.png);
        }
    </style>
    <script type="text/javascript">
        function getScrollXY() {
            var scrOfX = 0, scrOfY = 0;
            if (typeof (window.pageYOffset) == 'number') {
                //Netscape compliant
                scrOfY = window.pageYOffset;
                scrOfX = window.pageXOffset;
            } else if (document.body && (document.body.scrollLeft || document.body.scrollTop)) {
                //DOM compliant
                scrOfY = document.body.scrollTop;
                scrOfX = document.body.scrollLeft;
            } else if (document.documentElement && (document.documentElement.scrollLeft || document.documentElement.scrollTop)) {
                //IE6 standards compliant mode
                scrOfY = document.documentElement.scrollTop;
                scrOfX = document.documentElement.scrollLeft;
            }
            //return [scrOfX, scrOfY];
            return scrOfY;
        }



        var activewin;
        function onHelp() {
            var d = document.getElementById("help_text");
            activewin = new Ext.Window({
                id: 'quota_win',
                title: 'What is guest user',
                width: 680,
                height: 540,
                plain: true,
                modal: true,
                maximizable: false,
                maximized: false,
                layout: 'fit',
                bodyPadding: 3,
                html: d.innerHTML,
                defaults: {
                    border: false
                }
            });
            activewin.show();
        }
        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
       // parent.setActivePanel("UserMgr");

        function onDelPolicya(id, name) {
            

            if (confirm("Do you really want to delete (" + unescape(name) + ")?")) {
                Wait('Deleting');
                var e = document.getElementById('ctl00_MainContent_PolicyName');
                e.value = name;
                
                var b = document.getElementById('ctl00_MainContent_DeletePolicy');
                b.click();
            }

        }


        function closeCancelActiveWin() {
            activewin.close();
        }

        function closeActiveWin() {
            window.location = "/management/PolicyMgrPage.aspx";
        }

        function ResetPassword(t) {

            var uri = "/portal/ResetUserPassword.aspx?t=";

            uri += t;

            activewin = new Ext.Window({
                id: 'resetpwd_win',
                title: "<asp:Localize meta:resourcekey="js_string2" runat="server">Reset Password</asp:Localize>",
                width: 650,
                height: 438,
                layout: 'fit',
                plain: true,
                modal: true,
                maximizable: true,
                resizable: true,
                layout: 'fit',
                bodyPadding: 5,
                bodyStyle: 'background:#dfe8f6;border:0px; ',
                items: [{
                    xtype: "component",
                    autoEl: {
                        tag: "iframe",
                        src: uri
                    }
                }]
            });
            activewin.show();
        }
        function OnAddPolicy() {
    
    activewin = new Ext.Window({
        id: 'newpolicy_win',
        title: "Add New Policy",
        width: 880,
        height: maxh(560),
        plain: true,
        modal: true,
        maximizable: false,
        maximized: false,
        constrainHeader: true,
        layout: 'fit',
        bodyPadding: 3,
        html: "<iframe id='openwin_policy' src='/management/adduserwizard/PolicyType.aspx' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0;border:0;'></iframe>",
        defaults: {
            border: false
        }
    });
    activewin.show();
}

        
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <table width="100%" style="margin: 0px; padding: 8px; height: 100%; vertical-align: top;"
        cellspacing="0" cellpadding="0" align="center">
        <tr>
            <td valign="top" class="checkout3" style="background-color: white;">
                <table width="100%" style="height: 98%; padding: 8px;" cellspacing="0" cellpadding="0">
                    <tr>
                        <td colspan="5" valign="bottom" height="15px" style="padding: 5px; border-top: 1px solid #c0c0c0;
                            border-left: 1px solid #c0c0c0;">
                            <table width="99%" align="center" border="0" cellspacing="0" cellpadding="0">
                                <tr>
                                    <td>
                                        <div id="errmsgdiv">
                                            <b>
                                                <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                                        </div>
                                    </td>
                                </tr>
                            </table>

                        </td>
                       <td width="100px" align=right style="padding-right:3px; border-top: 1px solid #c0c0c0;border-right: 1px solid #c0c0c0;">
                           <% if (m_CanAdd)
                              { %>
                           <asp:LinkButton ID="LinkButton1" runat="server" ForeColor="#008000" OnClientClick="OnAddPolicy();return false;">Add</asp:LinkButton>
                           <% } %>
                       </td>
                    </tr>
                    <tr>
                        <td colspan="6" id="grid-example" style="padding: 5px; border-bottom: 1px solid #c0c0c0;
                            border-left: 1px solid #c0c0c0; border-right: 1px solid #c0c0c0;">
                        </td>
                    </tr>
                </table>
            </td>
            
        </tr>
    </table>
    <div style="display:none;">
    <asp:Button ID="DeletePolicy" runat="server" Text="Button" 
        onclick="DeletePolicy_Click"></asp:Button>
        <asp:HiddenField ID="PolicyName" runat="server" />
        </div>
    <script type="text/javascript">
  var myData = [
 <asp:Repeater ID="UsersRepeater" runat="server" OnItemCommand="UsersRepeater_ItemCommand"
        OnItemDataBound="OnUserItemBound">
        <ItemTemplate>         
        <%#(Container.ItemIndex == 0)? "": "," %>     
         ['<%#(((RepeaterItem)Container).ItemIndex+1) %>',
          '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"PolicyName").ToString().Replace("'","%27") )%>',
          '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"PolicyType").ToString().Replace("'","%27") )%>',
          '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"PolicyDescription").ToString().Replace("'","%27") )%>' 
           ] 
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
    <script type="text/javascript">

      Ext.require([
          'Ext.grid.*',
          'Ext.data.*',
          'Ext.util.*',
          'Ext.state.*'
      ]);
      Ext.onReady(function () {

          Ext.QuickTips.init();

          var store = Ext.create('Ext.data.ArrayStore', {
              fields: [
                  { name: 'index' },
                  { name: 'name' },
                  { name: 'type' },           
                  { name: 'desc' }
              ],
              data: myData
          });


          var d = document.getElementById("grid-example");
          var h = 400;
          
          try {
            h = d.offsetHeight-10;  // in IE8, this is very narrow like = 1
            h1 = document.body.offsetHeight;
            if (h1 > 300) {
                h1 = h1 - 36; // paddings , margins, whatever
            }
            if (h<50) {
                // this shall only happen for IE8
                gridY = Ext.get("grid-example").getY();
                h = h1 - gridY;
                if (h<218) {
                  h=218;
                }
            }
           } catch (err) {
           }


          var grid = Ext.create('Ext.grid.Panel', {
              title:"Policies",
              frame: false,
              border:1,
              store: store,
              stripeRows: true,
              columnLines: true,
              minHeight : 218,
              height:h, 
              columns: [
                  {
                      text: '',
                      width: 50,
                      sortable: false,
                      hideable: false,
                      dataIndex: 'index',
                      getClass: function (v, meta, rec) {
                          return 'x-col-hdide';
                      }
                  },
                  {
                      text: "Policy Name",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'name',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<b>" + unescape(value) + "</b>";
                      }

                  },
                  {
                      text: "Type",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'type',
                      renderer: function (value, metaData, record, rowIndex) {
                          return unescape(value) ;
                      }

                  },
                  {
                      text: "Description",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'desc',
                      renderer: function (value, metaData, record, rowIndex) {
                          return unescape(value) ;
                      }

                  }, {
                      xtype: 'actioncolumn',
                      width: 40,
                      hideable: false,
                      items:
                      [
                          {
                              icon: 'images/trash.png',  // Use a URL in the icon config
                              tooltip: "Delete Policy",
                        width: 30,
                        handler: function (grid, rowIndex, colIndex) {
                            var rec = grid.getStore().getAt(rowIndex);
                            var d = rec.data;

                            onDelPolicya(d.name, d.name);                            
                        },
                        getClass: function (v, meta, rec) {
                            <% if (!m_CanDelete)
                               { %>
                               return 'x-col-hdide';
                            <% } %>
                        }
                          }
                    
                      
                 ]
            }
        ],
              renderTo: 'grid-example'
          });

          Ext.EventManager.onWindowResize(grid.doLayout, grid);
      });
    </script>
</asp:Content>
