﻿<%@ Page Title="Gladinet Cloud - Publish Folder" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="PerfCounterMonitor.aspx.cs" Inherits="GladinetPayFlow.PerfCounterMonitor"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <script src="bootstrap4/js/Chart.bundle.min.js"></script>

    <style type="text/css">
      .requesttr{
          border-bottom:2px solid #eeeeee;
      }

      .requesttd{
          padding:5px;
          color:#565656;
      }
    </style>
    <script type="text/javascript">

  function SetPage(p) {
            var e = document.getElementById("page_1");            
            e.className = "gladtab_inactive";

            e = document.getElementById("page_2");
            e.className = "gladtab_inactive";

            e = document.getElementById("page_3");
            e.className = "gladtab_inactive";


            e = document.getElementById("page_1_div");
            e.style.display = "none";
            e = document.getElementById("page_2_div");
            e.style.display = "none";
            e = document.getElementById("page_3_div");
            e.style.display = "none";

            e = document.getElementById("page_" + p);
            e.className = "gladtab_active";
            e = document.getElementById("page_" + p + "_div");
            e.style.display = "";
            
        }
        
      function TrySetLastBreadCrum(str) {
          try {
              parent.parent.SetSubSubTitle(str);
          } catch (ex) {
              console.log("parent.parent.SetSubSubTitle is not defined. ex: " + ex);
          }
      }
      function ReturnToSysDiagRep()
      {
        //handle close button
        TrySetLastBreadCrum("");
        location.href = "/management/ClusterSysInfo.aspx";
      }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    
    <div width="100%" style="background-color: white;  border: 0px; padding-bottom:0px; align-content: right; " >
        <table width="100%" style="border-collapse:collapse;" cellpadding="0" cellspacing="0" >
            <tr>
                
                <td style="width:10px; border-bottom: 1px solid #cccccc;">&nbsp;</td>
                
                </td>
                <td align="left" style="padding:0px; width:100px; ">
                    <table style="border-collapse:collapse;" cellpadding="0" cellspacing="0">
                        <tr>
                            <td style="  padding-top:10px;" valign="bottom">
                    <div class="gladtab_active" id="page_1" onclick="SetPage(1);return false;"><asp:Localize runat="server" meta:resourcekey="str_Das">Dashboard</asp:Localize></div>
                            <td style="  padding-top:10px; " valign="bottom" >
                    <div  class="gladtab_inactive " id="page_2" onclick="SetPage(2);return false;" ><asp:Localize runat="server" meta:resourcekey="str_ReqSta">Request Statistics</asp:Localize></div>
                </td>
                <td style="  padding-top:10px;" valign="bottom">
                    <div class="gladtab_inactive" id="page_3" onclick="SetPage(3);return false;" ><asp:Localize runat="server" meta:resourcekey="str_LivReq">Live Requests</asp:Localize></div>
                </td>
                
               
                
                
            </tr>
        </table>
    </td>
                <td style="border-bottom: 1px solid #cccccc;padding-right:10px;" align="right">
                    <div style="float:right; font-size:32px;  font-weight:100; cursor:pointer;" class="sectextcolor" onclick="ReturnToSysDiagRep();">×</div>
                </td>
                </tr>
            </table>
        </div>

    <div style="width: 100%; overflow: auto; " id="rowcontainer">
    <div id="PollRes" class="sectextcolor" style="padding:10px;"></div>
        <table width="100%">
            <tr>
                <td align="center" style="padding-top:30px;">
                      <div style="width: 100%; height: 800px; max-width:800px; border: 0px solid #cccccc; border-radius: 5px;" id="page_1_div">
                    <table width="100%" >
                        <tr>
                            <td style="padding: 5px; padding-left: 15px; padding-top: 10px; font-size: 18px; font-weight: 400; color: #404040;" id="nodename"></td>
                            <td width="60px"></td>
                        </tr>
                        <tr>
                            <td colspan="2" style="padding: 5px; padding-left: 15px; padding-top: 10px; font-size: 16px; font-weight: 300; color: #404040;" align="center">
                                <div style="width: 180px; height: 200px; border: 1px solid #cccccc; border-radius: 3px; padding: 5px;" class=" viewcard trbordercolor">
                                    <table width="100%">
                                        <tr>
                                            <td><asp:Localize runat="server" meta:resourcekey="str_req">Request</asp:Localize></td>
                                        </tr>
                                        <tr>
                                            <td align="center" style="font-size: 64px;font-weight:600" id="currentRequests">0</td>
                                        </tr>
                                        <tr>
                                            <td><asp:Localize runat="server" meta:resourcekey="str_totReq">Total Request:</asp:Localize> &nbsp;<span id="totalrequest" style="font-weight:600"></span><br />
                                                <asp:Localize runat="server" meta:resourcekey="str_reqTme">Request Time(ms):</asp:Localize> <span id="requesttime" ></span>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </td>
                        </tr>

                        <tr>
                            <td colspan="2" style="padding: 5px; padding-left: 15px; padding-top: 40px; font-size: 16px; font-weight: 300; color: #404040;" align="center">
                                <table width="100%">
                                    <tr>
                                        <td align="center">
                                            <div style="width: 180px; height: 200px; border: 1px solid #cccccc; border-radius: 3px; padding: 5px;" class=" viewcard trbordercolor">
                                                <table width="100%">
                                                    <tr>
                                                        <td><asp:Localize runat="server" meta:resourcekey="str_dirQue">Dir Queue(High)</asp:Localize></td>
                                                    </tr>
                                                    <tr>
                                                        <td align="center" style="font-size: 64px;font-weight:600" id="highdir">0</td>
                                                    </tr>
                                                    <tr>
                                                        <td><asp:Localize runat="server" meta:resourcekey="str_queLnt">Queue Length:</asp:Localize>&nbsp;<span id="highq" style="font-weight:600;"></span><br />
                                                            <asp:Localize runat="server" meta:resourcekey="str_drpRte">Drop Rate:</asp:Localize> <span style="font-weight:600;" id="highqd"></span>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </td>
                                        <td align="center">
                                            <div style="width: 180px; height: 200px; border: 1px solid #cccccc; border-radius: 3px; padding: 5px;" class=" viewcard trbordercolor">
                                               
                                                <table width="100%">
                                                    <tr>
                                                        <td><asp:Localize runat="server" meta:resourcekey="str_dirQueLow">Dir Queue(Low)</asp:Localize></td>
                                                    </tr>
                                                    <tr>
                                                        <td align="center" style="font-size: 64px;font-weight:600;" id="lowdir">0</td>
                                                    </tr>
                                                    <tr>
                                                        <td><asp:Localize runat="server" meta:resourcekey="str_queLnt">Queue Length:</asp:Localize><span id="lowq" style="font-weight:600;"></span><br />
                                                            <asp:Localize runat="server" meta:resourcekey="str_drpRte">Drop Rate:</asp:Localize> <span style="font-weight:600;" id="lowqd"></span>
                                                    </tr>
                                                </table>
                                            
                                            </div>
                                        </td>
                                        <td align="center">
                                            <div style="width: 180px; height: 200px; border: 1px solid #cccccc; border-radius: 3px; padding: 5px;" class=" viewcard trbordercolor">
                                                 <table width="100%">
                                                    <tr>
                                                        <td><asp:Localize runat="server" meta:resourcekey="str_cltPol">Client Poll</asp:Localize></td>
                                                    </tr>
                                                    <tr>
                                                        <td align="center" style="font-size: 64px; font-weight:600;" id="clientpoll">0</td>
                                                    </tr>
                                                    <tr>
                                                        <td></td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </td>
                                    </tr>

                                </table>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2" style="padding: 5px; padding-left: 15px; padding-top: 40px; font-size: 16px; font-weight: 300; color: #404040;">
                                <table width="100%">
                                    <tr>
                                        <td align="center">
                                            <div style="width: 180px; height: 200px; border: 1px solid #cccccc; border-radius: 3px; padding: 5px;" class=" viewcard trbordercolor">
                                                <table width="100%">
                                                    <tr>
                                                        <td><asp:Localize runat="server" meta:resourcekey="str_pndNdeReq">Pending Node Request</asp:Localize></td>
                                                    </tr>
                                                    <tr>
                                                        <td align="center" style="font-size: 64px; font-weight:600;" id="noderequest">0</td>
                                                    </tr>
                                                    <tr>
                                                        <td></td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </td>
                                        <td align="center">
                                            <div style="width: 180px; height: 200px; border: 1px solid #cccccc; border-radius: 3px; padding: 5px;" class=" viewcard trbordercolor">
                                               
                                                <table width="100%">
                                                    <tr>
                                                        <td><asp:Localize runat="server" meta:resourcekey="str_updSesRqt">Upload Session Request</asp:Localize></td>
                                                    </tr>
                                                    <tr>
                                                        <td align="center" style="font-size: 64px; font-weight:600;" id="uploadrequests">0</td>
                                                    </tr>
                                                    <tr>
                                                        <td
                                                        </td>
                                                    </tr>
                                                </table>
                                            
                                            </div>
                                        </td>
                                        <td align="center">
                                            <div style="width: 180px; height: 200px; border: 1px solid #cccccc; border-radius: 3px; padding: 5px;" class=" viewcard trbordercolor">
                                                 <table width="100%">
                                                    <tr>
                                                        <td><asp:Localize runat="server" meta:resourcekey="str_pndChgNtf">Pending Change Notification</asp:Localize></td>
                                                    </tr>
                                                    <tr>
                                                        <td align="center" style="font-size: 64px; font-weight:600;" id="changesq">0</td>
                                                    </tr>
                                                    <tr>
                                                        <td></td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </td>
                                    </tr>

                                </table>
                            </td>
                        </tr>

                    </table>
                </div>
                    <div style="width: 100%; height: 800px; max-width:800px; border: 0px solid #cccccc; border-radius: 5px; overflow:auto; display:none;" id="page_2_div">
                      <table width="100%">
                        <tr>
                            <td style="padding: 5px; padding-left: 15px; padding-top: 10px; font-size: 18px; font-weight: 400; color: #404040;" >
                                <asp:Localize runat="server" meta:resourcekey="str_ovl">Overall</asp:Localize>
                            </td>
                            <td width="60px"></td>
                        </tr>
                          <tr>
                              <td colspan="2" style="padding:10px;">
                                  <table width="100%">
                                      <tbody id="oc" style="background-color:white; padding:5px; border-radius:5px;">

                                      </tbody>
                                  </table>
                              </td>
                          </tr>
                        </table>
                </div>
                    <div style="width: 100%; height: 800px; max-width:800px; border: 0px solid #cccccc; border-radius: 5px; display:none;" id="page_3_div">
                                          <table width="100%">
                        <tr>
                            <td style="padding: 5px; padding-left: 15px; padding-top: 10px; font-size: 18px; font-weight: 400; color: #404040;" >
                                <asp:Localize runat="server" meta:resourcekey="str_lveRqt">Live Requests</asp:Localize>
                            </td>
                            <td width="60px"></td>
                        </tr>
                                               <tr>
                              <td colspan="2" style="padding:10px;">
                                  <div class="row " style="width: 100%; align-content: center; margin: 0; margin-top: 20px; padding-bottom: 10px;" align="center" id="lc"></div>
            
                              </td>
                          </tr>
                        </table>

                </div>
                </td>
            </tr>
        </table>
        
              
            </div>
            
    



    <script type="text/javascript">

        function stringStartsWith(s, p) {
            return (s.indexOf(p) == 0);
        }

        var lastHigh = 0;
        var lastHighDrop = 0;
        var highcount = 0;
        var lastHigh1 = 0;
        

        function ShowHighDrop(x) {
            if (lastHigh1 == 0 || lastHigh1 > x.HighPriorityDirCount) {
                lastHigh1 = x.HighPriorityDirCount;
                lastHighDrop = x.HighPriorityQueueDropCount;
                return;
            }

            var e = document.getElementById("highqd");
            var d = 0;
            var c = x.HighPriorityDirCount - lastHigh1;
            if (c != 0) {
                d = Math.floor(100 * (x.HighPriorityQueueDropCount - lastHighDrop) / c);
            }

            e.innerHTML = d + "%";
            if (d <= 5)
                e.style.color = "#008000";
            else if (d <= 10)
                e.style.color = "#00f0f0";
            else
                e.style.color = "#f00000";

            lastHigh1 = x.HighPriorityDirCount;
            lastHighDrop = x.HighPriorityQueueDropCount;
        }

        function ShowHighDir(x) {
            if (lastHigh == 0 || lastHigh > x.HighPriorityDirCount) {
                lastHigh = x.HighPriorityDirCount;                
                return;
            }

            var e = document.getElementById("highdir");
            e.innerHTML = x.HighPriorityDirCount - lastHigh;
            lastHigh = x.HighPriorityDirCount;


            
            e = document.getElementById("highq");
            e.innerHTML = x.PendingHighPriorityDirRequest;
            if (x.PendingHighPriorityDirRequest <= 3)
                e.style.color = "#008000";
            else if (x.PendingHighPriorityDirRequest <= 5)
                e.style.color = "#00f0f0";
            else
                e.style.color = "#f00000";

            ++highcount;
            if (highcount >= 10) {
                highcount = 0;
                ShowHighDrop(x);
            }
        }


        var lastLow = 0;
        var lastLowhDrop = 0;
        var lowcount = 0;
        var lastLow1 = 0;


        function ShowLowDrop(x) {
            if (lastLow1 == 0 || lastLow1 > x.LowPriorityDirCount) {
                lastLow1 = x.LowPriorityDirCount;
                lastLowhDrop = x.LowPriorityQueueDropCount;
                return;
            }

            var e = document.getElementById("lowqd");
            var d = 0;
            var c = x.LowPriorityDirCount - lastLow1;
            if (c != 0) {
                d = Math.floor(100 * (x.LowPriorityQueueDropCount - lastLowhDrop) / c);
            }
            
            e.innerHTML = d + "%";
            if (d <= 5)
                e.style.color = "#008000";
            else if (d <= 10)
                e.style.color = "#00f0f0";
            else
                e.style.color = "#f00000";

            lastLow1 = x.LowPriorityDirCount;
            lastLowhDrop = x.LowPriorityQueueDropCount;
        }

        function ShowLowDir(x) {
            if (lastLow == 0 || lastLow > x.LowPriorityDirCount) {
                lastLow = x.LowPriorityDirCount;
                lastLowhDrop = x.LowPriorityQueueDropCount;
                return;
            }

            var e = document.getElementById("lowdir");
            e.innerHTML = x.LowPriorityDirCount - lastLow;
            lastLow = x.LowPriorityDirCount;



            e = document.getElementById("lowq");
            e.innerHTML = x.PendingLowPriorityDirRequest;
            if (x.PendingLowPriorityDirRequest <= 3)
                e.style.color = "#008000";
            else if (x.PendingLowPriorityDirRequest <= 5)
                e.style.color = "#00f0f0";
            else
                e.style.color = "#f00000";

            ++lowcount;
            if (lowcount >= 10) {
                lowcount = 0;
                ShowLowDrop(x);
            }
        }

        function ShowCore(x) {

            try{
                ShowHighDir(x);
            } catch (e) {
                
            }

            try{
                ShowLowDir(x);
            } catch (e) {

            }

            try{
                var e = document.getElementById("nodename");
                e.innerHTML = x.NodeName;

                //request count
                e = document.getElementById("currentRequests");
                e.innerHTML = x.RequestCount;
                if (x.RequestCount <= 8)
                    e.style.color = "#008000";
                else if (x.RequestCount <= 12)
                    e.style.color = "#00f0f0";
                else
                    e.style.color = "#f00000";
                e = document.getElementById("totalrequest");
                e.innerHTML = x.TotalRequestCount;

                e = document.getElementById("requesttime");
                e.innerHTML = x.RequestTime;
                if (x.RequestTime <= 500)
                    e.style.color = "#008000";
                else if (x.RequestTime <= 5000)
                    e.style.color = "#00f0f0";
                else
                    e.style.color = "#f00000";

                e = document.getElementById("clientpoll");
                e.innerHTML = x.PollStatusQueueLength;
                if (x.PollStatusQueueLength <= 5)
                    e.style.color = "#008000";
                else if (x.PollStatusQueueLength <= 10)
                    e.style.color = "#00f0f0";
                else
                    e.style.color = "#f00000";

                e = document.getElementById("noderequest");
                e.innerHTML = x.PendingNodeRequests;

                e = document.getElementById("uploadrequests");
                e.innerHTML = x.UploadQueueLength;
                if (x.UploadQueueLength <= 5)
                    e.style.color = "#008000";
                else if (x.UploadQueueLength <= 10)
                    e.style.color = "#00f0f0";
                else
                    e.style.color = "#f00000";

                e = document.getElementById("changesq");
                e.innerHTML = x.FireChangesQueueLength;
                if (x.FireChangesQueueLength <= 5)
                    e.style.color = "#008000";
                else if (x.FireChangesQueueLength <= 10)
                    e.style.color = "#00f0f0";
                else
                    e.style.color = "#f00000";
            } catch (e) {

            }
        }

        function ShowOverall(x) {
            var e;

            var tb = document.getElementById("oc");
            if (x.Overall.Counters.length <= 0) {
                tb.innerHTML = "";
                return;
            }

            
            tb.innerHTML = "<tr style='background-color:#f0f0f0;color:#808080;'><td><asp:Localize runat="server" meta:resourcekey="str_rqt">Request</asp:Localize></td><td><asp:Localize runat="server" meta:resourcekey="str_lveRqt">Live Request</asp:Localize></td><td><asp:Localize runat="server" meta:resourcekey="str_totRqt">Total Requests</asp:Localize></td><td><asp:Localize runat="server" meta:resourcekey="str_rqtTme">Request Time</asp:Localize></td></tr>";

            for (var i = 0; i < x.Overall.Counters.length; ++i) {
                var counter = x.Overall.Counters[i];

                var trm = document.createElement("tr");
                tb.appendChild(trm);
                trm.className = "requesttr";

                var tdn = document.createElement("td");
                tdn.className = "requesttd";
                trm.appendChild(tdn);
                tdn.innerHTML = counter.Name;

                var tdl = document.createElement("td");
                trm.appendChild(tdl);
                tdl.innerHTML = counter.CurrentRequest;
                tdl.className = "requesttd";

                var tdt = document.createElement("td");
                trm.appendChild(tdt);
                tdt.innerHTML = counter.TotalRequest;
                tdt.className = "requesttd";

                var tdr = document.createElement("td");
                trm.appendChild(tdr);
                tdr.innerHTML = counter.RequestTime;
                tdr.className = "requesttd";
            }
        }

        function ShowLive(x) {
            var e;
            var tb = document.getElementById("lc");

            if (x.LiveRequest.length <= 0) {
                tb.innerHTML = "";
                return;
            }

            
            
            tb.innerHTML = "";
            for (var i = 0; i < x.LiveRequest.length; ++i) {
                var counter = x.LiveRequest[i];

                var trm = document.createElement("div");
                tb.appendChild(trm);
                trm.className = "gridobject col-6 ";
                
                
                trm.style.padding = "5px";
                

                trm.innerHTML = "<div style='border:1px solid #cccccc; background-color:white; font-size:18px!important; width:100%;padding:3px; border-radius:3px;'><table width='100%'><tr><td  style='font-size:14px; font-weight:100;'>" + counter.FuncName + "</td><td style='font-size:14px; font-weight:100;' width='100px'>" + counter.Elapsed + "</td></tr><tr><td colspan='2' style='font-size:14px; font-weight:100;' align='left'>" + counter.UserName + "</td></tr></table></div>";


              
            }
        }


        function OnPollRes(m) {
            try {
                
                
                var e = document.getElementById("PollRes");
                if (stringStartsWith(m, "bad^")) {
                    e.innerHTML = m.substring(4);
                    setTimeout("Poll()", 3000);
                    return;
                }

                e.innerHTML = "";
                x = Ext.decode(m); // TODO: can we use json reader?
                
                if (x !== null && x !== undefined) {
                    if (x.Success) {
                    } else {
                        e.innerHTML = "bad result:"+x.Reason;
                    }
                } else {
                    e.innerHTML = "empty result";
                }

                ShowCore(x);
                ShowOverall(x);
                ShowLive(x);
                
            } catch (ee) {
                var e = document.getElementById("PollRes");
                e.innerHTML = ee.message;
            }
            setTimeout("Poll()", 1000);
        }
        function Poll() {


            try {
                Ext.Ajax.request({
                    url: '/management/PerfCounterMonitor.aspx?poll=1&h=<%=ViewHostname%>&p=<%=ViewHostProtocol%>&a=<%=ViewApiName%>',
                    success: function (response) {

                        OnPollRes(response.responseText);
                    },
                    failure: function () {
                        OnPollRes('bad^unknown');
                    },
                    method: 'GET'
                });

            } catch (e) {
                alert(e);
            }


        }



        function adjust() {
            var e = document.getElementById("rowcontainer");
            e.style.height = (document.documentElement.clientHeight - 45) + "px";

        }

        Ext.onReady(function () {

            adjust();
            setTimeout("Poll()", 2000);

        });

    </script>
</asp:Content>
