﻿<%@ Page Title="Notifications" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="NotificationTeamFolder.aspx.cs" Inherits="GladinetPayFlow.NotificationTeamFolder"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        
        
        .securityicon
        {
            background-image: url(images/security2.png);
        }
        .groupicon
        {
            background-image: url(images/group.png);
        }
        

    </style>
    <script type="text/javascript">




        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //parent.setActivePanel("PubMgr");




        function gEncodeUri(str) {
            var s = encodeURI(str).replace(/&/g, '%26').replace(/#/g, '|').replace('+', ':');
            while (true) {
                var i = s.indexOf('+');
                if (i == -1)
                    break;
                s = s.replace('+', ':');
            }

            return s;

        }



        var ActiveWin;
        function OnEdit(ShareId, isDir) {

            var uri = "<iframe id='openwin' src=\"/portal/AddSharePage.aspx?src=filebrowser&folder=";
            uri += isDir;
            uri += "&location=/";


            uri += encodeURIComponent(ShareId.replace("%27", "'"));
            uri += "&vdid=<%=SessionDomainId %>";
            uri += "\" scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>";

            ActiveWin = new Ext.Window({
                id: 'pubs_win',
                title: "<asp:Localize meta:resourcekey="str_sendshare" runat="server">Create link and send</asp:Localize>",
                width: 820,
                height: 640,
                plain: true,
                modal: true,
                maximizable: true,
                maximized: false,
                constrainHeader: true,
                bodyPadding: 5,
                resizable: false,
                html: uri,
                defaults: {
                    border: false
                }
            });
            ActiveWin.show();

        }



        function ViewShare(oid, id) {
            id = gEncodeUri(unescape(id));
            var uri = "<iframe id='openwin' src=\"/management/ViewSharePage.aspx?u=";
            uri += oid;
            uri += "&location=" + id;
            uri += "&vdid=<%=SessionDomainId %>";

            uri += "\" scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>";

            ActiveWin = new Ext.Window({
                id: 'pubs_win',
                title: "<asp:Localize meta:resourcekey="str_viwShr" runat="server">View Share</asp:Localize>",
                width: 720,
                height: maxh(540),
                plain: true,
                modal: true,
                maximizable: true,
                maximized: false,
                constrainHeader: true,
                bodyPadding: 5,
                resizable: false,
                html: uri,
                defaults: {
                    border: false
                }
            });
            ActiveWin.show();
        }

        function UnpublishUrl(id) {
            id = gEncodeUri(unescape(id));
            var h = "TenantShareMgrPage.aspx?op=delpub&id=" + id+"&oid=1&vdid=<%=SessionDomainId %>";

            if (confirm("<asp:Localize meta:resourcekey="js_string7" runat="server">Are you sure you want to delete?</asp:Localize>"))
                window.location = h;
        }

        function Unpublish(oid, id) {
            id = gEncodeUri(unescape(id));
            var h = "TenantShareMgrPage.aspx?op=delete&id=" + id + "&oid=" + oid+"&vdid=<%=SessionDomainId %>";

            if (confirm("<asp:Localize meta:resourcekey="js_string7" runat="server">Are you sure you want to delete?</asp:Localize>"))
                window.location = h;
        }

        //parent.HelpSrc = "PubMgrHelp.htm";


        function closeActiveWin() {


            window.location = window.location;

        }

        function closeCancelActiveWin() {
            ActiveWin.close();
        }

        function OnClickTeam() {
            window.location = "/portal/PubMgrPage.aspx";
        }

        function OnClickStorage() {
            window.location = "/management/StorageMgr.aspx";
        }

        function Unsubscribe(o, shareid, sharename, name) {
            var b = document.getElementById("ctl00_MainContent_Unsub");
            var s = document.getElementById("ctl00_MainContent_ShareId");
            var n = document.getElementById("ctl00_MainContent_ShareName");
            var p = document.getElementById("ctl00_MainContent_PathLoc");

            s.value = shareid;
            n.value = sharename;
            p.value = name;
            Wait("Apply Settings");
            b.click();
        }

        function Subscribe(o, shareid, sharename, name) {
            var b = document.getElementById("ctl00_MainContent_Sub");
            var s = document.getElementById("ctl00_MainContent_ShareId");
            var n = document.getElementById("ctl00_MainContent_ShareName");
            var p = document.getElementById("ctl00_MainContent_PathLoc");

            s.value = shareid;
            n.value = sharename;
            p.value = name;
            Wait("Apply Settings");
            b.click();
        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocFaiToGetShaObjLis" meta:resourcekey="str_faiToGetShaObjLis" Visible="false">Failed to get shared object list.</asp:Localize>
    <asp:Localize meta:resourcekey="str_temFld" ID="LocTemFld" runat="server" Visible="false">Team Folder(s)</asp:Localize>
    
   <nav class="navbar navbar-default" role="navigation" style="padding:0px!important; box-shadow: 3px 3px 3px white;">
       <div class="container-fluid">
           <p class="navbar-text">
               <asp:Label ID="PubFolderCount" runat="server" meta:resourcekey="PubFolderCountResource1" CssClass="badge"></asp:Label>
           </p>
           <p class="navbar-text">
               <b>
                   <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
           </p>
           <div class="navbar-form navbar-right" style="display: none;">
               <asp:LinkButton ID="AllUsers" runat="server" Font-Size="Larger" ForeColor="Green" OnClick="AllUsers_Click" meta:resourcekey="AllUsersResource1">All Shares</asp:LinkButton>
               &nbsp;&nbsp;&nbsp;
               <asp:TextBox ID="Contains" runat="server" Width="228px" CssClass="form-control" meta:resourcekey="ContainsResource1"></asp:TextBox>
               <asp:Button ID="Serach" runat="server" Text="Search" Width="128px" OnClick="Serach_Click" CssClass="btn btn-default" meta:resourcekey="SerachResource1" />
           </div>
       </div>
    </nav>
    <table width="100%" style="padding: 2px; background-color: white; margin-top: 13px" cellspacing="0" cellpadding="0" id="grid-table">
        <tr style="background-color: #f0f0f0; display: none;">
            <td valign="top" style="height: 32px; padding: 2px; border: 0px solid #c0c0c0; border-bottom: 3px solid #e0e0e0;">
                <table width="96%" cellspacing="0" cellpadding="0" style="height: 32px;">
                    <tr>
                        <td align="left" style="height: 32px">
                        </td>
                        <td>
                            <div id="errmsgdiv">
                            </div>
                        </td>
                        <td align="right">
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td style="padding:0px;padding-top: 0px; border-bottom: 0px solid #c0c0c0; border-left: 0px solid #c0c0c0; border-right: 0px solid #c0c0c0;"
                id="grid-example">
            </td>
        </tr>
        
    </table>
    <input type="hidden" id="current_share" name="current_share" />
    
    <div style="display: none">
        <asp:Button ID="Unsub" runat="server" Text="Button" onclick="Unsub_Click" />
        <asp:Button ID="Sub" runat="server" Text="Button" onclick="Sub_Click" />
        <asp:HiddenField ID="ShareId" runat="server" />
        <asp:HiddenField ID="ShareName" runat="server" />
        <asp:HiddenField ID="PathLoc" runat="server" />
    </div>
    <script type="text/javascript">
  var myData = [
 <asp:Repeater ID="PubsRepeater" runat="server" >
        <ItemTemplate>
       <%#(Container.ItemIndex == 0)? "": "," %>     
       ['<%#(((RepeaterItem)Container).ItemIndex+1) %>',
       '<%#DataBinder.Eval(Container.DataItem, "PathLocation").ToString().Replace("'","%27")%>',        
       '<%#DataBinder.Eval(Container.DataItem,"ShareId") %>',
       '<%#DataBinder.Eval(Container.DataItem,"Subscribed") %>',
       '<%#DataBinder.Eval(Container.DataItem, "ShareName").ToString().Replace("'","%27")%>'
       ]
        
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
    <script type="text/javascript">

        Ext.require([
            'Ext.grid.*',
            'Ext.data.*',
            'Ext.util.*',
            'Ext.state.*'
        ]);
        var grid;
        function AdjustGridTable () {
           
            var h = 400;
          
            try {

                var myTable = Ext.get('grid-table');
           
                var tableY = myTable.getY();
           
                h = document.documentElement.clientHeight-68;
           
                var ee = document.getElementById('tinfo');
                ee.style.height = h + "px";

            } catch (err) {
            }
            grid.setWidth(document.documentElement.clientWidth - 8);
            grid.setHeight(h-70);
            grid.doComponentLayout();

            var e = document.getElementById("grid-example");
            //e.style.height = h + "px";

        }

        Ext.onReady(function () {

            Ext.QuickTips.init();


            var store = Ext.create('Ext.data.ArrayStore', {
                fields: [
                    { name: 'index' },
                    { name: 'path' },
                    { name: 'shareid' },
                    { name: 'subscribed' },
                    { name: 'sharename' }
                ],
                data: myData
            });

            var d = document.documentElement.clientHeight - 5;
            var h = 370;
            //if (d.offsetHeight > h)
            h = d - 60;

            grid = Ext.create('Ext.grid.Panel', {                
                frame: false,
                border: false,
                store: store,
                stripeRows: true,
                columnLines: false,
                height: h,
                columns: [
                    {
                        text: '',
                        width: 50,
                        sortable: false,
                        dataIndex: 'index',
                        getClass: function (v, meta, rec) {
                            return 'x-col-hdide';
                        }
                    },
                    {
                        text: "<asp:Localize meta:resourcekey="str_teamname" runat="server">Team Folder Name</asp:Localize>",
                        flex: 1,
                        sortable: false,
                        dataIndex: 'sharename'

                    },{
                        text: "<asp:Localize meta:resourcekey="str_sud" runat="server">Subscribed</asp:Localize>",
                        width: 150,
                        sortable: false,
                        dataIndex: 'subscribed',
                        renderer: function (value, metaData, record, rowIndex) {
                            var d = record.data;

                            if (value == "True") {
                                return '<input  type="checkbox" checked value="1" onclick=\'Unsubscribe(this, \"' + d.shareid + '\",\"' + d.sharename + '\",\"' + d.path + '\");\'>';


                            } else {
                                return '<input  type="checkbox" value="1" onclick=\'Subscribe(this, \"' + d.shareid + '\",\"' + d.sharename + '\",\"' + d.path + '\");\'>';
                            }
                        }

                    }
        ],
                renderTo: 'grid-example'
            });
              AdjustGridTable ();
             //Ext.EventManager.onWindowResize(grid.doLayout, grid);
             Ext.EventManager.onWindowResize(AdjustGridTable);

        });
    </script>
</asp:Content>
