﻿<%@ Page Title="Gladinet Cloud - Access Manager" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="NoCacheList.aspx.cs" Inherits="GladinetPayFlow.NoCacheList" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <link rel="stylesheet" href="css/css.css" type="text/css" />
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }

    </style>
    <script type="text/javascript">
        

        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 8000);

        var activewin;

        function closeCancelActiveWin() {
            activewin.close();
        }

        function closeActiveWin() {
            window.location = "EditAcl.aspx";
        }

        function OnCancelAddUser() {
            parent.closeCancelActiveWin();
        }

       
        function OnUserSelected(UserList) {
            var ng = document.getElementById("ctl00_MainContent_NewUsers");
            var btn = document.getElementById("ctl00_MainContent_AddNewUsers");
            
            ng.value = UserList;
            btn.click();
        }

        function DeleteUser(name, UserId) {
            var ng = document.getElementById("ctl00_MainContent_UserId");
            var btn = document.getElementById("ctl00_MainContent_DeleteUser");

            if (confirm("Do you really want to delete (" + unescape(name) + ")?")) {
                ng.value = UserId;
                btn.click();
            }
        }

        function SetPerm(userid) {
            var read = document.getElementById("read_" + userid);
            var write = document.getElementById("write_" + userid);
            var del = document.getElementById("delete_" + userid);
            var edit = document.getElementById("edit_" + userid);            
            var ng = document.getElementById("ctl00_MainContent_NewUsers");
            var btn = document.getElementById("ctl00_MainContent_SetUser");
            var ng1 = document.getElementById("ctl00_MainContent_UserId");
            
            ng1.value = userid;
            ng.value = read.checked + "," + write.checked + "," + del.checked + "," + edit.checked + ",false" ;

            btn.click();

        }

        function SelectUser() {
            
            
            if (parent.parent.OnSelectUser) {
                parent.parent.OnSelectUserWithDomain('<%=SessionDomainId %>');
            } else {
                parent.OnSelectUserWithDomain('<%=SessionDomainId %>');
            }

        }

        function SelectLDAPUser() {
            

            if (parent.parent.OnLDAPSelectUserWithDomain) {
                parent.parent.OnLDAPSelectUserWithDomain('<%=SessionDomainId %>');
            } else {
                parent.OnLDAPSelectUserWithDomain('<%=SessionDomainId %>');
            }

        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Label ID="ErrorMsg" runat="server" ForeColor="Red" 
        meta:resourcekey="ErrorMsgResource1"></asp:Label>
    <div style="padding:5px;">
         <table width="99%" class="checkout3" style="background-color: white;margin-top: 8px;" align="center">
            <% if (m_CanEdit)
               { %>
            <tr>
                <td align="right">
                    <table>
                        <tr>
                            <td width="32px">
                                <img width="24px" src="/portal/images/activedir.png" />
                            </td>
                            <td>
                                <a href="javascript:;" onclick="SelectLDAPUser();return false;" style="font-size: 12px;">
                                    <asp:Localize meta:resourcekey="asp_string1" runat="server">Add AD User Or Groups</asp:Localize></a>
                            </td>
                            <td width="32px">
                                <img width="24px" src="images/adduser.png" />
                            </td>
                            <td>
                                <a href="javascript:;" onclick="SelectUser();return false;" style="font-size: 12px;">
                                    <asp:Localize meta:resourcekey="asp_string2" runat="server">Add Users or Groups</asp:Localize></a>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <% } %>
            <tr>
                <td colspan="3" style="padding-top: 3px">
                    <div id="grid-example">
                    </div>
                </td>
            </tr>
            <tr>
                <td class='idea_flex' colspan="3" align="center" style="padding: 5px; vertical-align: middle;">
                   
                        <asp:Localize meta:resourcekey="asp_string3" runat="server">Offline Access and client side cache is disabled for above users.</asp:Localize>
                </td>
            </tr>
        </table>
    </div>
    <asp:HiddenField ID="ObjectName" runat="server" />
    <asp:HiddenField ID="NewUsers" runat="server" />
    <asp:HiddenField ID="UserId" runat="server" />
    <div style="display:none;">
    <asp:Button ID="AddNewUsers" runat="server" 
        onclick="AddNewUsers_Click" meta:resourcekey="AddNewUsersResource1" />
    <asp:Button ID="DeleteUser" runat="server" 
        onclick="DeleteUser_Click" meta:resourcekey="DeleteUserResource1" />
    <asp:Button ID="SetUser" runat="server" 
        onclick="SetUser_Click" meta:resourcekey="SetUserResource1" />

        </div>

<script type="text/javascript">
  var myData = [
 <asp:Repeater ID="PubsRepeater" runat="server" >
        <ItemTemplate>
       <%#(Container.ItemIndex == 0)? "": "," %>     
       [
       '<%#(((RepeaterItem)Container).ItemIndex+1) %>',
       '<%#DataBinder.Eval(Container.DataItem, "Name")%>', 
       '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"Value").ToString())%>'
       ]        
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
  <script type="text/javascript">

      Ext.require([
          'Ext.grid.*',
          'Ext.data.*',
          'Ext.util.*',
          'Ext.state.*'
      ]);
      Ext.onReady(function () {

          Ext.QuickTips.init();


          var store = Ext.create('Ext.data.ArrayStore', {
              fields: [
                  { name: 'index' },
                  { name: 'guid' },
                  { name: 'name' }
              ],
              data: myData
          });



          var grid = Ext.create('Ext.grid.Panel', {
              store: store,
              title: "<asp:Localize meta:resourcekey="js_string3" runat="server">Users</asp:Localize>",
              border: true,
              stripeRows: true,
              columnLines: true,
              height: "400px",
              columns: [
                  {
                      text: '',
                      width: 50,
                      sortable: false,
                      dataIndex: 'index',
                      getClass: function (v, meta, rec) {
                          return 'x-col-hdide';
                      }
                  },
                  {
                      text: "<asp:Localize meta:resourcekey="js_string1" runat="server">User/Group Name</asp:Localize>",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'name',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<b>" + value + "</b>";
                      }

                  },{
                      xtype: 'actioncolumn',
                      width: 30,
                      items:
                      [

                   
                          {
                              icon: 'images/trash.png',  // Use a URL in the icon config
                              tooltip: "<asp:Localize meta:resourcekey="js_string2" runat="server">Delete</asp:Localize>",
                        handler: function (grid, rowIndex, colIndex) {
                            var rec = grid.getStore().getAt(rowIndex);
                            var d = rec.data;

                            DeleteUser(d.name,d.guid);
                        }
                        ,
                        getClass: function (v, meta, rec) {
                            <% if (!m_CanEdit)
                               { %>
                               return 'x-col-hdide';
                            <% } %>
                        }
                    }
                 ]
            }
        ],
              renderTo: 'grid-example'
          });

          Ext.EventManager.onWindowResize(grid.doLayout, grid);
      });
  </script>
</asp:Content>
