﻿<%@ Page Title="Gladinet Cloud - Guest User Manager" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="MyGuestUserMgrPage.aspx.cs" Inherits="GladinetPayFlow.MyGuestUserMgrPage"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        .actiontbl{
        display: table;
        }
        .actioncol{
        display: table-cell;margin-top:5px;
        }
        .actioncol .gladinet-icons {
        padding-left:10px;
        }
		.actioncol .tooltip{
            margin:20px 0px 0px 5px !important;  /*tooltip positioning*/ 
		}
        
        
        .securityicon
        {
            background-image: url(/portal/images/security2.png);
        }
        
        .dark {
            color: #565656!important;
        }
        .tooltip.bs-tooltip-bottom{
            margin:15px 10px 0px 10px !important;  /*tooltip positioning*/ 
		}  
        .tooltip.bs-tooltip-bottom .arrow { 
             margin-left:13px;   /*tooltip arrow positioning*/ 
        }
    </style>
    <script type="text/javascript">
        
        function getScrollXY() {
            var scrOfX = 0, scrOfY = 0;
            if (typeof (window.pageYOffset) == 'number') {
                //Netscape compliant
                scrOfY = window.pageYOffset;
                scrOfX = window.pageXOffset;
            } else if (document.body && (document.body.scrollLeft || document.body.scrollTop)) {
                //DOM compliant
                scrOfY = document.body.scrollTop;
                scrOfX = document.body.scrollLeft;
            } else if (document.documentElement && (document.documentElement.scrollLeft || document.documentElement.scrollTop)) {
                //IE6 standards compliant mode
                scrOfY = document.documentElement.scrollTop;
                scrOfX = document.documentElement.scrollLeft;
            }
            //return [scrOfX, scrOfY];
            return scrOfY;
        }



        var activewin;
        function onHelp() {
            var d = document.getElementById("help_text");
            activewin = new Ext.Window({
                id: 'quota_win',
                title: "<asp:Localize meta:resourcekey="str_whatisguest" runat="server">What is a guest user</asp:Localize>",
                width: 680,
                height: 540,
                plain: true,
                modal: true,
                maximizable: false,
                maximized: false,
                layout: 'fit',
                bodyPadding: 3,
                html: d.innerHTML,
                defaults: {
                    border: false
                }
            });
            activewin.show();
        }
        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        // parent.setActivePanel("UserMgr");

        function onDelUser(id, name) {
            var h = "/management/MyGuestUserMgrPage.aspx?op=delete&id=" + id.replace('+', ':')+"&vdid=<%=SessionDomainId %>";

             gConfirm("<asp:Localize meta:resourcekey="str_confirm" runat="server">Do you really want to delete (</asp:Localize>" + unescape(name) + ")?", "", function(btn1) {

                    if (btn1 != 'ok')
                        return;
            Wait("<asp:Localize meta:resourcekey="str_deleting" runat="server">Deleting</asp:Localize>");
            window.location = h;
                });
           

        }


        function closeCancelActiveWin() {
            activewin.close();
        }

        function closeActiveWin() {
            window.location = "/management/GuestUserMgrPage.aspx?vdid=<%=SessionDomainId %>";
        }

        function ResetPassword(t) {

            

            var uri = "/portal/ResetUserPassword.aspx?t=";

            uri += t;

            var Html = "<iframe id='openwin' src='" + uri;
            Html += "' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0;border:0;'></iframe>";

            activewin = new Ext.Window({
                id: 'resetpwd_win',
                title: "<asp:Localize meta:resourcekey="js_string2" runat="server">Reset Password</asp:Localize>",
                width: 650,
                height: 570,
                plain: true,
                modal: true,
                constrain: true,
                maximizable: true,
                maximized: false,
                bodyPadding: 0,
                resizable: true,
                shadow: 'drop',
                iconCls: 'publish',
                bodyStyle: 'background:#f0f0f0;border:0px; ',
                shadowOffset: 10,
                html: Html,
                defaults: {
                    border: false
                }
            });



            activewin.show();
        }
        function OnAddUser() {
            parent.SetRelativePageTitle("<asp:Localize meta:resourcekey="str_adduser" runat="server">Add User</asp:Localize>",'AddGuestUserPage.aspx?vdid=<%=SessionDomainId %>');
            window.location = 'AddGuestUserPage.aspx?vdid=<%=SessionDomainId %>';
            return;
            activewin = new Ext.Window({
                id: 'On_Add_User',
                title: "<asp:Localize meta:resourcekey="js_string3" runat="server">Create New User</asp:Localize>",
                width: 680,
                height: maxh(576),
                plain: true,
                modal: true,
                maximizable: true,
                resizable: false,
                maximized: false,
                shadow: 'drop',
                shadowOffset: 20,
                layout: 'fit',
                bodyPadding: 3,
                html: "<iframe id='openwin' src='AddGuestUserPage.aspx?vdid=<%=SessionDomainId %>' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>",
                defaults: {
                    border: false
                }
            });
            activewin.show();



        }
        function OnLDAPAddUser() {
            var closeAction = new Ext.Action({
                text: "<asp:Localize meta:resourcekey="js_string4" runat="server">Close</asp:Localize>",
                width: 108
            });

            activewin = new Ext.Window({
                id: 'On_Ads_AddUser',
                title: "<asp:Localize meta:resourcekey="js_string5" runat="server">Add Active Directory User(s)</asp:Localize>",
                width: 680,
                height: 650,
                plain: true,
                modal: true,
                maximizable: true,
                constrain: true,
                maximized: false,
                layout: 'fit',
                bodyPadding: 3,
                html: "<iframe id='openwin' src='LDAPUserPage.aspx' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>",
                defaults: {
                    border: false
                },
                buttons: [closeAction],
                listeners: {
                    "close": function () {
                        window.location = window.location;
                    }
                }
            });
            closeAction.setHandler(function () { activewin.close(); });

            activewin.show();



        }
        function OnBatchAddUser() {

            activewin = new Ext.Window({
                id: 'pubs_win',
                title: "<asp:Localize meta:resourcekey="js_string8" runat="server">Batch Create New User</asp:Localize>",
                width: 680,
                height: 550,
                plain: true,
                modal: true,
                maximizable: true,
                constrain: true,
                maximized: false,
                layout: 'fit',
                bodyPadding: 3,
                html: "<iframe id='openwin' src='BatchAddUserPage.aspx' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>",
                defaults: {
                    border: false
                }
            });
            activewin.show();



        }

        function OnManageAdmin() {
            if (parent.OnManageAdmin)
                parent.OnManageAdmin();
            else
                parent.parent.OnManageAdmin();
        }
        function OnEditGroup(t, f, l, e) {

            parent.OnEditGroup(t, f, l, e);

        }

        function OnChangeName(t, f, l) {

            var uri = "EditUserPage.aspx?uid=";

            uri += t;
            uri += "&firstname=";
            uri += f;
            uri += "&lastname=";
            uri += l;



            activewin = new Ext.Window({
                id: 'resetuname_win',
                title: "<asp:Localize meta:resourcekey="js_string9" runat="server">Change User Name</asp:Localize>",
                width: 550,
                height: 250,
                layout: 'fit',
                plain: true,
                modal: true,
                maximizable: true,
                resizable: true,
                layout: 'fit',
                bodyPadding: 5,
                bodyStyle: 'background:#dfe8f6;border:0px; ',
                items: [{
                    xtype: "component",
                    autoEl: {
                        tag: "iframe",
                        src: uri
                    }
                }],
                listeners: {
                    "close": function () {
                        window.location = window.location;
                    }
                }
            });
            activewin.show();
        }
        function OnChangeEmail(t) {

            var uri = "ChangeEmailPage.aspx?uid=";

            uri += t;



            activewin = new Ext.Window({
                id: 'resetacct_win',
                title: "<asp:Localize meta:resourcekey="js_string10" runat="server">Change Email</asp:Localize>",
                width: 550,
                height: 310,
                plain: true,
                modal: true,
                maximizable: true,
                resizable: true,
                layout: 'fit',
                bodyPadding: 5,
                bodyStyle: 'background:#dfe8f6;border:0px; ',
                items: [{
                    xtype: "component",
                    autoEl: {
                        tag: "iframe",
                        src: uri
                    }
                }],
                listeners: {
                    "close": function () {
                        window.location = window.location;
                    }
                }
            });
            activewin.show();
        }

        function OnClickUser() {
            window.location = "/portal/UserMgrPage.aspx";
        }
        function OnClickGroup() {
            window.location = "/portal/GroupMgrPage.aspx";
        }
        <asp:Localize ID="LocPlsWat" meta:resourcekey="js_plsWat" runat="server" Visible="False">Please wait</asp:Localize>
        function OnSuspend(did) {
            var domainid = document.getElementById('ctl00_MainContent_HiddenUserId');
            var btn = document.getElementById('ctl00_MainContent_SuspendUser');
            domainid.value = did;
                    Wait("<%=LocPlsWat.Text %>");
            btn.click();
        }
        function OnResume(did) {
            var domainid = document.getElementById('ctl00_MainContent_HiddenUserId');
            var btn = document.getElementById('ctl00_MainContent_ResumeUser');
            domainid.value = did;
            Wait("<%=LocPlsWat.Text %>");
            btn.click();
        }
        
        function onViewShares(uid){
            
            window.location = "UserShareMgrPage.aspx?uid="+uid;
        }
        
        var gSelUser = "";
        function DelSelUsers() {
            var domainid = document.getElementById('<%=HiddenSelectedGuestUsersId.ClientID%>');
            var btn = document.getElementById('<%=DelUsers.ClientID%>');
            domainid.value = gSelUser;
            if (confirm("<asp:Localize meta:resourcekey="str_delselusers" runat="server">Do you really want to delete selected guest users</asp:Localize>")) {
                btn.click();
            }
        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <nav class="navbar navbar-default " role="navigation" style=" border-bottom:none;box-shadow:none;">
      <div class="container-fluid">
          <p class="navbar-text">
              <asp:Label ID="UserCount" runat="server" Text="0 User" meta:resourcekey="UserCountResource1" CssClass="badge"></asp:Label>
          </p>
          <div style="height:40px;">
          <p class="navbar-text" id="DelSelDiv" style="display: none;">
            <asp:LinkButton ID="LnkBtnDelSel" runat="server" ForeColor="#008000" Font-Size="12px" OnClientClick="DelSelUsers();return false;">
                <asp:Localize meta:resourcekey="str_delGstUsr" runat="server">Delete Selected Guest User(s)</asp:Localize>
            </asp:LinkButton>      
          </p> 
          </div>
          <div style="display: none;">  
              <asp:HiddenField ID="HiddenSelectedGuestUsersId" runat="server" />
              <asp:Button ID="DelUsers" runat="server" Text="Button" OnClick="DelSelUsers_Click" /> 
          </div>
      </div>
    </nav>
    <table width="100%" style=" padding: 0px; background-color: white; margin-top: -13px;" cellspacing="0" cellpadding="0" id="grid-table">
                    <tr style="background-color: #f0f0f0; display: none;">
                        <td  valign="middle" style="padding: 2px; border-top: 0px solid #c0c0c0;border-bottom: 3px solid #e0e0e0;
                            border-left: 0px solid #c0c0c0;">
                            
                            <asp:Label ID="GuestQuota" runat="server" Visible="False" Text="0 available guest users in quota"
                                meta:resourcekey="GuestQuotaResource1"></asp:Label>
                        </td>
                        <td height="60px" colspan="3" valign="middle" style="padding: 2px; border-top: 0px solid #c0c0c0;border-bottom: 3px solid #e0e0e0
                           " align="right">
                            
                        </td>
                        <td style="width: 100px;  border-right: 0px solid #c0c0c0;border-top: 0px solid #c0c0c0; padding-top:10px;border-bottom: 3px solid #e0e0e0">
                            <table>
                                <tr>
                                    <td colspan="6" style="padding: 0px; vertical-align: top; height: 32px;" id="input_panel"
                                        valign="middle">
                                        <table cellspacing="0" cellpadding="0" width="100%" align="left" style="height: 43px;">
                                            <tr>
                                                <asp:Panel ID="Panel1" runat="server" Visible="false">
                                                   
                                                    
                                                </asp:Panel>
                                                <td>
                                                    &nbsp;
                                                </td>
                                                <td width="20px" style="border-left:0px solid #c0c0c0;">
                                                    &nbsp;
                                                </td>
                                                <td valign="top" style="text-align: left;" align="left">
                                                    <table width="99%" align="center" border="0" cellspacing="0" cellpadding="0">
                                                        <tr>
                                                            <td>
                                                                <div id="errmsgdiv">
                                                                    <b>
                                                                        <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </td>
                                                
                                              
                                                <td align="right" width="42px">
                                                    <a href="javascript:;" onclick="onHelp();return false;">
                                                        <img src="images/help.png" width="32" alt="" /></a>
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="6" id="grid-example" style="padding: 5px; border-bottom: 0px solid #c0c0c0;
                            border-left: 0px solid #c0c0c0; border-right: 0px solid #c0c0c0;">
                        </td>
                    </tr>
                </table>
    <div id="help_text" style="display: none; position: absolute;">
        <table>
            <tr>
                <td style="background-color: white; border: 1px solid #c0c0c0;" class="checkout3"
                    valign="top">
                    <table width="96%" align="center" style="height: 100%">
                        <tr>
                            <td colspan="6" height="100px">
                                <div width="90%" style="padding: 10px;">
                                    <div class='idea_flex' style="height: auto;">
                                        <asp:Localize meta:resourcekey="asp_string2" runat="server">Guest User</asp:Localize>
                                        <ul>
                                            <li><b>
                                                <asp:Localize meta:resourcekey="asp_string3" runat="server">What is a guest user?</asp:Localize></b>
                                                <p>
                                                    <asp:Localize meta:resourcekey="asp_string4" runat="server">A guest user is a user who you can invite to collaborate on a shared folder and assign full-control permission.</asp:Localize></p>
                                            </li>
                                            <li><b>
                                                <asp:Localize meta:resourcekey="asp_string5" runat="server">What can a guest user do?</asp:Localize></b>
                                                <p>
                                                    <asp:Localize meta:resourcekey="asp_string6" runat="server">A guest user can use all the access clients such as the web browser, desktop client, and mobile application to collaborate on the shared folder.</asp:Localize></p>
                                            </li>
                                            <li><b>
                                                <asp:Localize meta:resourcekey="asp_string7" runat="server">What limitations does a guest user have?</asp:Localize></b>
                                                <p>
                                                    <asp:Localize meta:resourcekey="asp_string8" runat="server">Guest users only get to see the shared folders that are assigned to them. Guest users don't have a home directory and have less functionality compared to  regular users. However, they can have full control of the shared folders when permissions are given.</asp:Localize></p>
                                            </li>
                                            <li><b>
                                                <asp:Localize meta:resourcekey="asp_string9" runat="server">Charge</asp:Localize></b>
                                                <p>
                                                    <asp:Localize meta:resourcekey="asp_string10" runat="server">Your account includes a quota of guest users. When the quota is exceeded, guest users will be charged a fraction of the regular user costs.</asp:Localize>
                                                    (<%= user.GladinetCloud.IsInstalledApp() ? "50%" : "67%" %>)
                                                </p>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
            <div style="display:none;">
    <asp:HiddenField ID="HiddenUserId" runat="server" />
    
<asp:Button ID="SuspendUser" runat="server" Text="Button" 
        onclick="SuspendUser_Click" />
<asp:Button ID="ResumeUser" runat="server" Text="Button" 
        onclick="ResumeUser_Click" />
        


        </div>

    </div>

    <script type="text/javascript">
        var myData = [
            <asp:Repeater ID="UsersRepeater" runat="server" OnItemCommand="UsersRepeater_ItemCommand" EnableViewState="False"
        OnItemDataBound="OnUserItemBound">
        <ItemTemplate>         
        <%#(Container.ItemIndex == 0)? "": "," %>     
         ['<%#(((RepeaterItem)Container).ItemIndex+1) %>',
         '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "FirstName").ToString().Replace("'","%27"))%>&nbsp;<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "LastName").ToString().Replace("'","%27"))%>',
          '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"Email").ToString().Replace("'","%27") )%>', 
           '','<%#DataBinder.Eval(Container.DataItem,"IsAdmin") %>',
           '<%#DataBinder.Eval(Container.DataItem,"UserGuid") %>',
           '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"FirstName").ToString().Replace("'","%27") )%>','<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"LastName").ToString().Replace("'","%27") )%>','<%#DataBinder.Eval(Container.DataItem,"LastVisit").ToString().Replace("'","%27") %>',
           '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"CreateByEmail").ToString().Replace("'","%27") )%>'
           ,'<%#DataBinder.Eval(Container.DataItem,"IsActivated") %>'
           ,'<%#DataBinder.Eval(Container.DataItem,"EncId") %>'
           ] 
        </ItemTemplate>
    </asp:Repeater>      
        ];
    </script>
    <script type="text/javascript">
        function checkSelections(){
            <% if (!m_CanDelete) { %>
            return;
            <% } %>
            if($(".chkbx:checked").length>0){             
                gSelUser = "";
                $(".chkbx:checked").each(function(index){
                    gSelUser += $(this).data("email") + ";";
                 });
                $("#DelSelDiv").show();
            } else {                  
                gSelUser = "";
                $("#DelSelDiv").hide();
            }
        }
        Ext.require([
            'Ext.grid.*',
            'Ext.data.*',
            'Ext.util.*',
            'Ext.state.*'
        ]);
        Ext.onReady(function () {

            Ext.QuickTips.init();

            var store = Ext.create('Ext.data.ArrayStore', {
                fields: [
                    { name: 'index' },
                    { name: 'fullname' },
                    { name: 'email' },           
                    { name: 'action' },
                    { name: 'isadmin' },
                    {name: 'userguid'},
                    {name: 'firstname'},
                    {name: 'lastname'},
                    {name: 'lastvisit'},
                    {name: 'createby'},
                    {name: 'isactive'},
                    {name: 'encid'}
                ],
                data: myData
            });


            var d = document.getElementById("grid-example");
            var h = 400;
          
            try {
                h = d.offsetHeight-10;  // in IE8, this is very narrow like = 1
                h1 = document.body.offsetHeight;
                if (h1 > 300) {
                    h1 = h1 - 36; // paddings , margins, whatever
                }
                if (h<50) {
                    // this shall only happen for IE8
                    gridY = Ext.get("grid-example").getY();
                    h = h1 - gridY;
                    if (h<218) {
                        h=218;
                    }
                }
            } catch (err) {
            }


            var grid = Ext.create('Ext.grid.Panel', {
                frame: false,
                border:1,
                store: store,
                stripeRows: true,
                columnLines: false,
                minHeight : 218,
                height:h, 
                multiSelect: false,  
                disableSelection: true,
                columns: [
                    {
                        text: '',
                        width: 50,
                        sortable: false,
                        hideable: false,
                        dataIndex: 'index',
                        getClass: function (v, meta, rec) {
                            return 'x-col-hdide';
                        }
                    },   
                    <% if (m_CanDelete) { %>      {
                        text: '',
                        width: 50,
                        sortable: false,
                        hideable: false,
                        dataIndex: 'index',
                        renderer: function (value, metaData, record, rowIndex) {  
                            return '<input type="checkbox" class="chkbx" value="chk_' + unescape(value) + '" data-email="' + unescape(record.data.email) + '" onclick="checkSelections()" />';
                        }
                    },
                    <% } %>
                    {
                        text: "<asp:Localize meta:resourcekey="js_string12" runat="server">Full Name</asp:Localize>",
                        flex: 1,
                        sortable: true,
                        dataIndex: 'fullname',
                        renderer: function (value, metaData, record, rowIndex) {
                            return "<span style='color:#404040; font-weight:100;'>" + unescape(value) + "</span>";
                        }

                    },
                    {
                        text: "<asp:Localize meta:resourcekey="js_string13" runat="server">Email</asp:Localize>",
                        flex: 1,
                        sortable: true,
                        dataIndex: 'email',
                        renderer: function (value, metaData, record, rowIndex) {  
                            return "<span style='color:#404040; font-weight:100;'>" + unescape(value) + "</span>";
                        }

                    },
                    {
                        text: "<asp:Localize meta:resourcekey="js_string14" runat="server">Last Login</asp:Localize>",
                        width: 175,
                        sortable: true,
                        dataIndex: 'lastvisit',
                        renderer: function (value, metaData, record, rowIndex) {
                            return "<span style='color:#404040; font-weight:100;'>" + unescape(value) + "</span>";
                        }
                    },
                    {
                        text: "<asp:Localize meta:resourcekey="str_createby" runat="server">Created By</asp:Localize>",
                        width: 175,
                        sortable: true,
                        dataIndex: 'createby',
                        renderer: function (value, metaData, record, rowIndex) {
                            return "<span style='color:#404040; font-weight:100;'>" + unescape(value) + "</span>";
                        }
                    }, {
                    sortable: false,
                    width:120,
                    renderer: function (value, metaData, record, rowIndex) {
                        var rec = grid.getStore().getAt(rowIndex);
                        var d = rec.data;
                        var ndeNme = d.nodename; 
                        var delTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="js_string15" runat="server">Delete User</asp:Localize>\"";
                        var shrTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="str_filFldShrWthThsUsr" runat="server">File(s)/folder(s) shared with this user</asp:Localize>\""; 
                        var resPwTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="str_resetpwd" runat="server">Reset Password</asp:Localize>\""; 
                        //==================================================================
                        var delBtn = "<div class=\"actioncol\"><i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"onDelUser(&quot;"+d.email+"&quot;,&quot;"+d.email+"&quot;)\" "+delTTip+">n</i></div>";
                        if (d.isadmin == 'True') delBtn = ""; 
                        <% if (!m_CanDelete) { %>
                        delBtn = ""; 
                        <% } %>
                        //==================================================================
                        var shrBtn = "<div class=\"actioncol\"><i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"onViewShares('"+d.userguid+"')\" "+shrTTip+">k</i></div>";
                        //==================================================================   
                        var resPwBtn = "<div class=\"actioncol\"><i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"ResetPassword('"+d.encid+"')\" "+resPwTTip+">r</i></div>";
                        if (d.isadmin == 'True') resPwBtn = "";
                        <% if (!m_CanEdit) { %>
                        resPwBtn = ""; 
                        <% } %>
                        //==================================================================
                        return "<div class=\"actiontbl\">"+delBtn+shrBtn+resPwBtn+"</div>";
                    }
                }
                ],
                renderTo: 'grid-example'
            });

            try {
                parent.ClearRelativePageTitle();
            } catch (e) {
            
            }

            Ext.EventManager.onWindowResize(function () {
                grid.setWidth(document.documentElement.clientWidth-15  );
                grid.doComponentLayout();
            });
        });
    </script>
</asp:Content>
