﻿<%@ Page Title="Gladinet Cloud - Search" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="MyDevicesPage.aspx.cs" Inherits="GladinetPayFlow.MyDevicesPage"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        
        .dark {
            color: #565656 !important;
        }
        
    </style>
    <script type="text/javascript">

        function  OnDeleteToken(id, name) 
        {
            var ng = document.getElementById("ctl00_MainContent_DeviceId");
            var btn = document.getElementById("ctl00_MainContent_DeleteToken");

            if (confirm("<asp:Localize meta:resourcekey="str_cfmDelTkn" runat="server">Do you really want to delete the token: (</asp:Localize>" + unescape(name) + ")?")) {
                Wait("<asp:Localize meta:resourcekey="str_delentry" runat="server">Wiping...</asp:Localize>");
            ng.value = id;
            btn.click();
        }
        }



        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);



        var ActiveWin;
        var MainWnd;
        function closeActiveWin() {


            window.location = window.location;

        }

        function OnViewDevice(id, name) {
            window.location = "/management/DeviceDashboard.aspx?id=" + id;
        }

        function closeCancelActiveWin() {
            ActiveWin.close();
        }

        function gEncodeUri(str) {
            var s = encodeURI(str).replace(/&/g, '%26').replace(/#/g, '|').replace('+', ':');
            while (true) {
                var i = s.indexOf('+');
                if (i == -1)
                    break;
                s = s.replace('+', ':');
            }

            return s;

        }

        function OpenFile(file) {
            var f = document.getElementById('rightpanel');
            f.src = "File.aspx?f=" + gEncodeUri(unescape(file));

        }

        function OnWipeDevice(id, name) {
            var ng = document.getElementById("ctl00_MainContent_DeviceId");
            var btn = document.getElementById("ctl00_MainContent_WipeDevice");

            if (confirm("<asp:Localize meta:resourcekey="str_wipe" runat="server">Do you really want to wipe the device (</asp:Localize>" + unescape(name) + ")?")) {
                Wait("<asp:Localize meta:resourcekey="str_wiping" runat="server">wiping...</asp:Localize>");
            ng.value = id;
            btn.click();
        }
        }

        function OnDeleteDevice(id, name) {
            var ng = document.getElementById("ctl00_MainContent_DeviceId");
            var btn = document.getElementById("ctl00_MainContent_DeleteDevice");

            if (confirm("<asp:Localize meta:resourcekey="str_deldev" runat="server">Do you really want to delete the device entry</asp:Localize> (" + unescape(name) + ")?")) {
                Wait("<asp:Localize meta:resourcekey="str_delentry" runat="server">wiping...</asp:Localize>");
                ng.value = id;
                btn.click();
            }
        }

        
    function OnAgentAttachedFolders(id, name) {
        Wait("Please wait");
        window.location = "/management/DeviceAttachedFolders.aspx?f=c&id=" + id + "&name=" + name;
    }

    function OnAgentTasks(id, name) {
        Wait("Please wait");
        window.location = "/management/DeviceTasks.aspx?f=c&id=" + id + "&name=" + name;
    }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocNotFou" meta:resourcekey="str_notFou" Visible="false">not found</asp:Localize>
    <asp:Localize ID="LocDvcFnd" meta:resourcekey="str_dvcFnd" runat="server" Visible="false">Device(s) found</asp:Localize>
   <nav class="navbar navbar-default" role="navigation">
      <div class="container-fluid" style="border-bottom: 0px solid #c0c0c0; box-shadow: 0px 3px 3px white !important;">
          <p class="navbar-text">
              <asp:Label ID="ResultCount" runat="server" meta:resourcekey="ResultCountResource1" CssClass="badge"></asp:Label>
          </p>
          <p class="navbar-text">
           <asp:LinkButton ID="exportcsv" runat="server" ForeColor="Green" Visible="False" OnClick="exportcsv_Click"
                                ><asp:Localize meta:resourcekey="str_dcsv" runat="server">Download as CSV file</asp:Localize></asp:LinkButton>
          </p>
          <p class="navbar-text">
                <b>
                                    <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
          </p>
          
                
          
      </div>
    </nav>
    <table width="100%" style="padding: 2px; background-color: white; margin: 0px; margin-top: 13px" cellspacing="0" id="grid-table"
                    cellpadding="0">
                   
                    
                    <tr>
                        <td colspan="3" style="vertical-align: top;" id="result_div">
                                                <div class="row" style="width: 100%; align-content: center; margin: 0;" align="center">
                       <asp:Repeater ID="PubsRepeater" runat="server"  >
                            <ItemTemplate>
                                <div class="col-xs-12 col-sm-6 col-md-4 col-lg-3 text-center topbuffer" style="padding-bottom:10px;">
                                    <div class="viewcard" >
                                        <div style="padding: 10px; border-bottom: 1px solid #f0f0f0;" class="boxbordercolor secsubcolor" >
                                            <table width="100%">
                                                <tr>
                                                    <td>
                                            <span style="font-size: 18px; font-weight: 100;"><%#DataBinder.Eval(Container.DataItem, "HostName")%></span>             
                                                    </td>
                                                    <td width="144px" align="right" style="font-size: 16px;">
                                                        <span class="fa fa-wrench sectextcolor toolbtn" style="cursor: pointer;" title="<%=str_mgrdev.Text %>" onclick='OnViewDevice("<%#DataBinder.Eval(Container.DataItem, "InstanceId")%>","<%#DataBinder.Eval(Container.DataItem, "HostName")%>");'></span>&nbsp;&nbsp;
                                                        <span class="fa fa-eraser sectextcolor toolbtn" style="cursor: pointer;" title="<%=str_wipedev.Text %>" onclick='OnWipeDevice("<%#DataBinder.Eval(Container.DataItem, "InstanceId")%>","<%#DataBinder.Eval(Container.DataItem, "HostName")%>");'></span>&nbsp;&nbsp;
                                                        <span class="fa fa-remove sectextcolor toolbtn" style="cursor: pointer; " title="<%=str_deldev.Text %>" onclick='OnDeleteDevice("<%#DataBinder.Eval(Container.DataItem, "InstanceId")%>","<%#DataBinder.Eval(Container.DataItem, "HostName")%>");'></span>
                                                    </td>
                                                </tr>
                                            </table>
                                            
                                            </div>
                                    <div class="panel-body">
                                <table width="100%">
                                    <tr>
                                       <td  style="height: 280px!important;color: #404040; font-size: 16px; font-weight: 100;" align="center" valign="middle">
                                           
                                         <table width="100%" class="table-striped">
                                             <tr>
                                                 <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100">
                                                     <asp:Localize meta:resourcekey="str_devtype" runat="server">Type</asp:Localize>
                                                 </td>
                                                 <td width="220px">
                                                     <%#DataBinder.Eval(Container.DataItem,"DeviceType") %>
                                                 </td>
                                            </tr>
                                                 <tr>
                                                 <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100">
                                                     <asp:Localize meta:resourcekey="str_osver" runat="server">OS Version</asp:Localize>
                                                 </td>
                                                 <td >
                                                     <%#DataBinder.Eval(Container.DataItem,"OsVer") %>
                                                     
                                                 </td>
                                             </tr>
                                                 <tr>
                                                 <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100">
                                                     <asp:Localize meta:resourcekey="str_clientver" runat="server">Client Version</asp:Localize>
                                                 </td>
                                                 <td width="120px">
                                                     <%#DataBinder.Eval(Container.DataItem,"ClientVer") %>
                                                 </td>
                                             </tr>
                                                 
                                                 <tr>
                                                 <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100">
                                                     <asp:Localize meta:resourcekey="str_lastlogintime" runat="server">Last Login Time</asp:Localize>
                                                 </td>
                                                 <td >
                                                     <%#DataBinder.Eval(Container.DataItem,"LastLogin") %>
                                                 </td>
                                             </tr>
                                                 <tr>
                                                 <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100">
                                                     <asp:Localize meta:resourcekey="str_syncstatus" runat="server">Sync Status</asp:Localize>
                                                 </td>
                                                 <td >

                                                     <span class="fa <%#DataBinder.Eval(Container.DataItem, "SyncStatusIcon")%>  " title="<%#DataBinder.Eval(Container.DataItem, "SyncStatusString")%>" style="color:<%#DataBinder.Eval(Container.DataItem, "SyncStatusColor")%>!important; font-size: 24px;"></span>
                                                 </td>
                                             </tr>
                                                 <tr>
                                                 <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100">
                                                     <asp:Localize meta:resourcekey="str_reporttime" runat="server">Sync Status Report Time</asp:Localize>
                                                 </td>
                                                 <td >
                                                     <%#DataBinder.Eval(Container.DataItem,"LastReport") %>
                                                 </td>
                                             </tr>
                                             <tr>
                                                 <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100"><asp:Localize meta:resourcekey="str_ipAdr" runat="server">IP Address</asp:Localize>
                                                 </td>
                                                 <td >
                                                     <%#DataBinder.Eval(Container.DataItem,"IPAdress") %>
                                                 </td>
                                             </tr>
                                             <tr>
                                                 <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100"><asp:Localize meta:resourcekey="str_tknExpTme" runat="server">Token Expiration Time</asp:Localize>
                                                     
                                                 </td>
                                                 <td >
                                                     <table width="100%">
                                                         <tr>
                                                             <td><%#DataBinder.Eval(Container.DataItem,"TokenExpirationTime") %></td>
                                                             <td width="32px">
                                                                 
                                                                 <span class="fa fa-remove sectextcolor" style="font-size: 14px;  cursor: pointer;padding-left: 3px; padding-right: 3px; <%#DataBinder.Eval(Container.DataItem,"TokenRemoveDisplay") %>" onclick="OnDeleteToken('<%# Convert.ToString(DataBinder.Eval(Container.DataItem, "Token")).Replace("'", "\\'") %>','<%# Convert.ToString(DataBinder.Eval(Container.DataItem, "HostName")).Replace("'", "\\'") %>')" title="<%=str_delTkn.Text %>"></span>
                                                                 
                                                             </td>
                                                         </tr>
                                                     </table>
                                                     
                                                 </td>
                                             </tr>
                                             
                                         </table>
                                           
                                       </td> 
                                    </tr>
                                </table>
                                 
                            </div>
                           
                        </div>

                                </div>
                           </ItemTemplate>
                       </asp:Repeater>

                    </div>
                        </td>
                    </tr>
                   
                </table>
    
    <div style="display: none;">
        <asp:HiddenField ID="InstanceId" runat="server" />
                                <asp:Localize meta:resourcekey="str_deldev" ID="str_deldev" Visible="False" runat="server">Delete</asp:Localize>
                        <asp:Localize meta:resourcekey="str_wipe" ID="str_wipedev" runat="server" Visible="False">Wipe Device</asp:Localize>
                        <asp:Localize meta:resourcekey="str_mgrdev" ID="str_mgrdev" Visible="False" runat="server">View Details</asp:Localize>
                        <asp:Localize meta:resourcekey="str_delTkn" ID="str_delTkn" Visible="False" runat="server">Delete the Token</asp:Localize>

    </div>
    
    <div style="display: none;">
                <asp:Localize meta:resourcekey="str_daysgao" ID="StrDaysAgo" runat="server" Text=" Days ago"></asp:Localize>
        <asp:Localize meta:resourcekey="str_hoursago" ID="StrHoursAgo" runat="server" Text=" Hours ago"></asp:Localize>
        <asp:Localize meta:resourcekey="str_minsago" ID="StrMinsAgo" runat="server" Text=" Minutes ago"></asp:Localize>
        <asp:Localize meta:resourcekey="str_lessmin" ID="StrLessMin" runat="server" Text="Less than 1 minute ago"></asp:Localize>
        <asp:Localize meta:resourcekey="str_never" ID="StrNever" runat="server"
            Text="Never"></asp:Localize>

        <asp:Button ID="DeleteToken" runat="server" OnClick="DeleteToken_Click" />
        <asp:HiddenField ID="DeviceId" runat="server" />
        <asp:Button ID="DeleteDevice" runat="server" OnClick="DeleteDevice_Click" />
    </div>
   
    <script type="text/javascript">

      function OnChange(id) {
          
          var idc = document.getElementById("ctl00_MainContent_InstanceId");
          var db = document.getElementById("ctl00_MainContent_DenyBtn");
          var ab = document.getElementById("ctl00_MainContent_AllowBtn");
          idc.value = id;

          var e = document.getElementById(id);
          if (e.checked) {
              
              ab.click();
          } else {
          
              db.click();
          }

      }

        function MgrDevice(id) {
            window.location = "DeviceDashboard.aspx?id=" + id;
        }

    var grid;
      
       function AdjustGridTable () {
           
        var h = 400;
          
        try {

            var myTable = Ext.get('grid-table');
           
            var tableY = myTable.getY();
           
            h = document.body.offsetHeight-tableY-60;
           
              var ee = document.getElementById('tinfo');
              ee.style.height = h + "px";

          } catch (err) {
          }
              

          var e = document.getElementById("result_div");
          e.style.height = h + "px";

      }

      Ext.onReady(function () {


          //Ext.EventManager.onWindowResize(grid.doLayout, grid);
           AdjustGridTable ();
             
             Ext.EventManager.onWindowResize(AdjustGridTable);     
      });
    </script>
</asp:Content>
