﻿<%@ Page Title="CentreStack - Cluster Remote Manage Console" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="MigrateTenant.aspx.cs" Inherits="GladinetPayFlow.MigrateTenant"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <link rel="stylesheet" type="text/css" href="/webui/ext4/resources/css/ext-all.css" />

    <style type="text/css">
        td {
            font-size: 15px;
            font-weight: 100;
        }

        b {
            font-weight: 500;
        }

        .badgefont {
            font-size: 15px;
        }
    </style>
    <style type="text/css">
        .titlecol {
            background-color: #e0e0e0;
            font-size: 14px;
        }

        * {
            margin: 0;
        }

        html, body {
            height: 100%;
        }

        .main, #aspnetForm {
            height: 100%;
        }

        .wrapper {
            min-height: 100%;
            height: auto !important;
            height: 100%;
            padding: 0px;
            background-color: white;
            margin: 0 auto -69px; /* the bottom margin is the negative value of the footer's height */
        }

        .footer, .push {
            height: 68px; /* .push must be the same height as .footer */
        }
    </style>
    <style type="text/css">
        .titlecol {
            background-color: #e0e0e0;
            font-size: 14px;
        }
    </style>
    <script type="text/javascript">

        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 8000);

        function OnCancelUpgrade() {
            window.location = "PartnerGCEMgrPage.aspx";
        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Localize ID="LocTeaFolMig" meta:resourcekey="str_teaFolMig" Visible="false" runat="server">team folders migrated</asp:Localize>
    <asp:Localize ID="LocFavMig" meta:resourcekey="str_favMig" Visible="false" runat="server">favorites migrated</asp:Localize>
<asp:Localize ID="LocSetMig" meta:resourcekey="str_setMig" Visible="false" runat="server">settings migrated</asp:Localize>
<asp:Localize ID="LocFaiToEnuTen" meta:resourcekey="str_faiToEnuTen" runat="server" Visible="False">Failed to enumerate tenants</asp:Localize>
<asp:Localize ID="LocDon" meta:resourcekey="str_don" runat="server" Visible="False">done</asp:Localize>
<asp:Localize ID="LocFaiToEnuDev" meta:resourcekey="str_faiToEnuDev" runat="server" Visible="False">Failed to enumerate devices</asp:Localize>
<asp:Localize ID="LocFaiToMigPeeShaAcl" meta:resourcekey="str_faiToMigPeeShaAcl" runat="server" Visible="False">Failed to migrate peer share acl:</asp:Localize>
<asp:Localize ID="LocFaiToEnuNamVal" meta:resourcekey="str_faiToEnuNamVal" runat="server" Visible="False">Failed to enumerate named values:</asp:Localize>
<asp:Localize ID="LocNoTenLevNamValThiIsNot" meta:resourcekey="str_noTenLevNamValThiIsNot" runat="server" Visible="False">no tenant level named values, this is not normal</asp:Localize>
<asp:Localize ID="LocFaiToMigTenSet" meta:resourcekey="str_faiToMigTenSet" runat="server" Visible="False">failed to migrate tenant setting:</asp:Localize>
<asp:Localize ID="LocFaiToEnuFav" meta:resourcekey="str_faiToEnuFav" runat="server" Visible="False">Failed to enumerate favs:</asp:Localize>
<asp:Localize ID="LocNoFavLisThiIsNotNor" meta:resourcekey="str_noFavLisThiIsNotNor" runat="server" Visible="False">no favs list, this is not normal</asp:Localize>
<asp:Localize ID="LocFaiToMigFav" meta:resourcekey="str_faiToMigFav" runat="server" Visible="False">failed to migrate fav:</asp:Localize>
<asp:Localize ID="LocFaiToEnuTeaFolAcl" meta:resourcekey="str_faiToEnuTeaFolAcl" runat="server" Visible="False">Failed to enumerate team folder acls</asp:Localize>
<asp:Localize ID="LocFaiToEnuTenTeaFol" meta:resourcekey="str_faiToEnuTenTeaFol" runat="server" Visible="False">Failed to enumerate tenant team folders:</asp:Localize>
<asp:Localize ID="LocFaiToMigTeaFolAcl" meta:resourcekey="str_faiToMigTeaFolAcl" runat="server" Visible="False">Failed to migrate team folder acl:</asp:Localize>
<asp:Localize ID="LocFaiToMigTeaFol" meta:resourcekey="str_faiToMigTeaFol" runat="server" Visible="False">Failed to migrate team folder:</asp:Localize>
<asp:Localize ID="LocFaiToEnuTenTeaFolNulLis" meta:resourcekey="str_faiToEnuTenTeaFolNulLis" runat="server" Visible="False">Failed to enumerate tenant team folders: null list</asp:Localize>
    <div class="wrapper" style="padding: 10px; width: 100%; margin-left: 0px; align-content: center;">
        <table width="100%">
             <tr>
                <td colspan="4" align="right" style="padding-right:10px;">
                    <asp:LinkButton ID="MigrateNow" runat="server" OnClick="MigrateNow_Click" OnClientClick="Wait('...');" meta:resourcekey="str_mgtNow">Migrate Now</asp:LinkButton>
                </td>
            </tr>

            <tr>
                <td colspan="4">
                    <asp:Label ID="ErrorMsg" runat="server" Text="" ForeColor="red"></asp:Label>
                </td>
            </tr>
            <tr>
                <td colspan="4" style="padding: 10px;">
                    <a href="#users" data-toggle="collapse"><asp:Localize runat="server" meta:resourcekey="str_lstUsr">List Of Users</asp:Localize> (<asp:Label ID="UserCount" runat="server" Text=""></asp:Label>):</a>

                    <div id="users" class="collapse">
                        <table>
                            <tr class="menubox">
                                <td style="padding: 10px; border-bottom: 1px solid #e0e0e0;" class="sectextcolor"><asp:Localize runat="server" meta:resourcekey="str_usrNme">User Name</asp:Localize></td>
                                <td style="padding: 10px; border-bottom: 1px solid #e0e0e0;" class="sectextcolor"><asp:Localize runat="server" meta:resourcekey="str_eml">Email</asp:Localize></td>

                            </tr>
                            <asp:Repeater ID="UserRepeater" runat="server">
                                <ItemTemplate>

                                    <tr class="x-grid-tr" style="cursor: pointer;">
                                        <td style="padding: 2px; border-bottom: 1px solid #f8f8f8;">
                                            <%# DataBinder.Eval(Container.DataItem, "FirstName")%> <%# DataBinder.Eval(Container.DataItem, "LastName")%>
                                        </td>
                                        <td style="padding: 2px; border-bottom: 1px solid #f8f8f8;">
                                            <%# DataBinder.Eval(Container.DataItem, "Email")%>
                                        </td>
                                    </tr>
                                </ItemTemplate>
                            </asp:Repeater>

                        </table>
                    </div>

                </td>
            </tr>


            <tr>
                <td colspan="4" style="padding: 10px;">
                    <a href="#tfs" data-toggle="collapse">List Of Team Folders (<asp:Label ID="TeamFolderCount" runat="server" Text=""></asp:Label>):</a>
                    <div id="tfs" class="collapse">
                        <table>
                            <tr class="menubox">
                                <td style="padding: 10px; border-bottom: 1px solid #e0e0e0;" class="sectextcolor"><asp:Localize runat="server" meta:resourcekey="str_nme">Name</asp:Localize></td>
                                <td style="padding: 10px; border-bottom: 1px solid #e0e0e0;" class="sectextcolor"><asp:Localize runat="server" meta:resourcekey="str_loc">Location</asp:Localize></td>

                            </tr>
                            <asp:Repeater ID="TeamFolderRepeater" runat="server">
                                <ItemTemplate>

                                    <tr class="x-grid-tr" style="cursor: pointer;">
                                        <td style="padding: 2px; border-bottom: 1px solid #f8f8f8;">
                                            <%# DataBinder.Eval(Container.DataItem, "ShareName")%> 
                                        </td>
                                        <td style="padding: 2px; border-bottom: 1px solid #f8f8f8;">
                                            <%# DataBinder.Eval(Container.DataItem, "DirLocation")%>
                                        </td>
                                    </tr>
                                </ItemTemplate>
                            </asp:Repeater>

                        </table>
                    </div>
                </td>
            </tr>

            <tr>
                <td colspan="4" style="padding: 10px;">
                    <a href="#devs" data-toggle="collapse"><asp:Localize runat="server" meta:resourcekey="str_lstOfDvc">List Of Devices</asp:Localize> (<asp:Label ID="DeviceCount" runat="server" Text=""></asp:Label>):</a>
                    <div id="devs" class="collapse">
                        <table>
                            <tr class="menubox">
                                <td style="padding: 10px; border-bottom: 1px solid #e0e0e0;" class="sectextcolor"><asp:Localize runat="server" meta:resourcekey="str_nme">Name</asp:Localize></td>
                                <td style="padding: 10px; border-bottom: 1px solid #e0e0e0;" class="sectextcolor"><asp:Localize runat="server" meta:resourcekey="str_inf">Info</asp:Localize></td>
                                <td style="padding: 10px; border-bottom: 1px solid #e0e0e0;" class="sectextcolor"><asp:Localize runat="server" meta:resourcekey="str_owr">Owner</asp:Localize></td>

                            </tr>
                            <asp:Repeater ID="DeviceRepeater" runat="server">
                                <ItemTemplate>

                                    <tr class="x-grid-tr" style="cursor: pointer;">
                                        <td style="padding: 2px; border-bottom: 1px solid #f8f8f8;">
                                            <%# DataBinder.Eval(Container.DataItem, "HostName")%> 
                                        </td>
                                        <td style="padding: 2px; border-bottom: 1px solid #f8f8f8;">
                                            <%# DataBinder.Eval(Container.DataItem, "DeviceType")%>/<%# DataBinder.Eval(Container.DataItem, "OsVer")%>/<%# DataBinder.Eval(Container.DataItem, "ClientVer")%></td>
                                                                                <td style="padding: 2px; border-bottom: 1px solid #f8f8f8;">
                                            <%# DataBinder.Eval(Container.DataItem, "UserEmail")%> 
                                        </td>

                                    </tr>
                                </ItemTemplate>
                            </asp:Repeater>

                        </table>
                    </div>
                </td>
            </tr>


        </table>

    </div>
    <div class="footer x-panel-header-light" style="margin-left: 0px; border-left: 0; border-right: 0; width: 100%; border-bottom: 0; vertical-align: middle;">
        <asp:HiddenField ID="TenantId" runat="server" />
    </div>
    <asp:HiddenField ID="AdminUserId" runat="server" />
    <asp:HiddenField ID="OrigUserCount" runat="server" />
</asp:Content>
