﻿<%@ Page Title="Database Migration" Language="C#" MasterPageFile="~/Site.master"
    AutoEventWireup="true" CodeBehind="MigrateDatabase.aspx.cs" Inherits="GladinetPayFlow.MigrateDatabase"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <script type="text/javascript" src="<%=this.ExtJS %>"></script>
    <link rel="stylesheet" href="/portal/gladtheme.aspx?<%Response.Write("");%><%=ThemeVer%>"  type="text/css"  />

    <style type="text/css">
        .style1
        {
            width: 388px;
        }
        
        .style2
        {
            min-width: 16px;
            text-align: center;
        }
        
        .pricetable
        {
            border: 1px solid #cccccc;
        }
        
        .plain9BlackOnNone
        {
            border-bottom: 1px solid #cccccc;
            border-right: 1px solid #cccccc;
        }
        .style3
        {
            border-bottom: 1px solid #cccccc;
            border-right: 1px solid #cccccc;
            width: 121px;
        }
        .offer_flex
        {
            background: #FFFFE0 url('images/giftbox.png') no-repeat 8px center;
            border: 1px solid #E6DB55;
            border-radius: 4px 4px 4px 4px;
            color: #000000;
            height: 54px;
            line-height: 18px;
            padding: 2px;
            padding-left: 16px;
            width: 868px;
            vertical-align: middle;
            text-align: center;
            margin: auto;
            margin-bottom: 16px;
        }
        
        label {
            padding-left: 5px;
            font-weight: 100 !important;
        }
        .thintext {
            font-weight: 100 !important;
        }
        .offertitle
        {
            line-height: 24px;
        }
        .offertext
        {
            line-height: 20px;
        }
        
        .offer_flex1
        {
            border: 1px solid #E6DB55;
            border-radius: 4px 4px 4px 4px;
            margin: auto;
        }
        .btndlg
        {
            min-width:128px;
        }
    </style>
    
    <script type="text/javascript">
        function stringStartsWith(s, p) {
            return (s.indexOf(p) == 0);
        }
        function OnPollRes(m) {
            
            if (stringStartsWith(m, "[bad]")) {
                var e = document.getElementById("MigError");
                e.innerHTML = m.substring(5);
                return;
            } else {
                var parts = m.split('^');
                var e = document.getElementById("OverStatus");

                e.innerHTML = parts[3] + "/" + parts[2];
                
                e = document.getElementById("OverallProgress");
                if (parts[2] == "0") {
                    e.style.width = "0%";
                } else {
                    var per = Math.floor(parts[3] * 100 / parts[2]);
                    e.style.width = per+"%";
                }
                

                e = document.getElementById("CurrentTask");
                e.innerHTML = parts[4] + " - " + parts[6] + "/" + parts[5];

                e = document.getElementById("CurrentProgress");
                if (parts[5] == "0") {
                    e.style.width = "0%";
                } else {
                    var per = Math.floor(parts[6] * 100 / parts[5]);
                    e.style.width = per + "%";
                }

                if (parts[0] == "failed") {
                    e = document.getElementById("MigError");
                    e.innerHTML = parts[0]+":"+parts[1];
                }

                else if (parts[0] == "succeed") {
                    e = document.getElementById("sucdiv");
                    e.style.display = "";

                    e = document.getElementById("migstatus");
                    e.style.display = "none";

                } else {
                    e = document.getElementById("MigError");
                    e.innerHTML = "";
                }

                
            }
            setTimeout("Poll()", 1000);
        }


        function Poll() {
            
            Ext.Ajax.request({
                url: '/management/MigrateDatabase.aspx?op=poll',
                success: function (response) {
                    OnPollRes(response.responseText);
                },
                failure: function () {
                
                    OnPollRes('[bad]unknown');
                },
                method: 'GET'
            });
        
            
        }
        <%if(MigratePanel.Visible){%>
            setTimeout("Poll()", 1000);
        <%}%>
    </script>
</asp:Content>
<asp:Content ID="Content2" runat="server" ContentPlaceHolderID="CreateTitle">
    
    <span style="color: #565656; font-weight: 100;"><asp:Localize runat="server" meta:resourcekey="str_mngDbs">Manage Database</asp:Localize></span>
</asp:Content>
<asp:Content ID="Content1" runat="server" ContentPlaceHolderID="StepIndicator">
</asp:Content>
<asp:Content ID="Content3" runat="server" ContentPlaceHolderID="LeftLogImage">
    <img src="images/gcestep1.jpg" width="339px" />
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Localize ID="LocFaiToIniDefDat" meta:resourcekey="str_faiToIniDefDat" Visible="false" runat="server">Failed to initialize default database:</asp:Localize>
<asp:Localize runat="server" ID="LocMisPas" meta:resourcekey="str_misPas" Visible="false">Missing password</asp:Localize>
<asp:Localize runat="server" ID="LocMisUseNam" meta:resourcekey="str_misUseNam" Visible="false">Missing user name</asp:Localize>
<asp:Localize runat="server" ID="LocMisDatNam" meta:resourcekey="str_misDatNam" Visible="false">Missing database name</asp:Localize>
<asp:Localize runat="server" ID="LocMisSqlSer" meta:resourcekey="str_misSqlSer" Visible="false">Missing SQL server</asp:Localize>
<asp:Localize runat="server" ID="LocMisPor" meta:resourcekey="str_misPor" Visible="false">Missing port</asp:Localize>
<asp:Localize runat="server" ID="LocMisHosNam" meta:resourcekey="str_misHosNam" Visible="false">Missing host name</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToIniDefDb" meta:resourcekey="str_faiToIniDefDb" Visible="false">Failed to initialize default db</asp:Localize>
    <div style="display: none;"></div>

    <table align="center" style="padding: 3px; padding-top: 0px; padding-bottom: 0px;
        width: 100%;" cellspacing="0">
        <tr>
            <td valign="top" colspan="4" style="height: 450px;">
                <asp:Panel ID="ConfigPanel" runat="server" Visible="true">
                    <table width="100%" align="center">
                        <tr>
                            <td class="aa" valign="top" style="padding-bottom: 5px; border-bottom: 1px solid #e0e0e0"
                                align="left">
                                <h1 style="font-size: 24px; font-weight: 100; color: #565656;">
                                    <asp:Localize runat="server" meta:resourcekey="str_cfgTgtDbs">Configure Target Database</asp:Localize></h1>
                            </td>
                        </tr>
                        
                        <tr>
                            <td style="padding-top: 15px; padding-left: 20px;">
                                <asp:Label ID="ErrorMsg" runat="server" CssClass="errmsg1" ForeColor="red" meta:resourcekey="ErrorMsgResource1"></asp:Label>
                            </td>
                        </tr>
                        
                        <tr>
                            <td style="padding-top: 10px;padding-left: 20px; " align="left">
                                <asp:DropDownList ID="DatabaseType" runat="server" CssClass="browser-default custom-select secsubbordercolor" OnSelectedIndexChanged="DatabaseType_SelectedIndexChanged" AutoPostBack="True"></asp:DropDownList>
                            </td>
                        </tr>
                        
                        <tr>
                            <td height="250px" valign="top" style="padding-top: 10px;" align="center">
                                <asp:Panel ID="DefaultPanel" runat="server">
                                    <div style="font-size:18px; font-weight:100; color:#565656; padding:20px">
                                        <asp:Localize runat="server" meta:resourcekey="str_UserPostgreSQL">Local installed PostgreSQL server will be used as the database service.</asp:Localize>
                                    </div>
                                </asp:Panel>
                                <asp:Panel ID="DefaultMySqlPanel" runat="server" Visible="false">
                                    <div style="font-size:18px; font-weight:100; color:#565656; padding:20px">
                                    <asp:Localize runat="server" meta:resourcekey="str_mySqlCmmEdtSvrWilBeUsd">Mysql Community Edition server will be used as the database service.</asp:Localize>
                                        <div style="padding-top:60px;">
                                            <button type="button" class="btn btn-info btn-lg" data-toggle="modal" data-target="#myModal"><asp:Localize runat="server" meta:resourcekey="str_abtMySqlCmmEdt">About MySql Community Edition</asp:Localize></button>

<!-- Modal -->
<div id="myModal" class="modal fade" role="dialog">
  <div class="modal-dialog">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
          <h4 class="modal-title"><asp:Localize runat="server" meta:resourcekey="str_mySqlCmmEdt">MySql Community Edition</asp:Localize></h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        
      </div>
      <div class="modal-body">
        <p><asp:Localize runat="server" meta:resourcekey="str_mySqlCmmEdtHlp">MySQL Community Edition is the freely downloadable version of the world's most popular open source database. It is available under the GPL license and is supported by a huge and active community of open source developers.</asp:Localize></p>
          <br />
          <a href="https://dev.mysql.com/downloads/" target="_blank"><asp:Localize runat="server" meta:resourcekey="str_mySqlCmmDwd">MySQL Community Downloads</asp:Localize></a><br />
           <a href="https://github.com/mysql/mysql-server" target="_blank"><asp:Localize runat="server" meta:resourcekey="str_mySqlSrcCdeDpt">MySQL Community Source Code Depot</asp:Localize></a><br />
          <a href="/portal/COPYING.txt"  target="_blank"><asp:Localize runat="server" meta:resourcekey="str_glpLic">GPL License</asp:Localize></a>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal"><asp:Localize meta:resourcekey="str_cls" runat="server">Close</asp:Localize></button>
      </div>
    </div>

  </div>
</div>
                                        </div>
                                        </div>
                                </asp:Panel>
                                <asp:Panel ID="MySqlPanel" runat="server" Visible="true">
                                    <table >
                                        <tr>
                                            <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100; "  ><asp:Localize runat="server" meta:resourcekey="str_hstNme">Host Name</asp:Localize></td>
                                            <td align="left" width="440px">
                                                <asp:TextBox ID="MySQLHostName" runat="server" CssClass="form-control"></asp:TextBox></td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100; "  ><asp:Localize runat="server" meta:resourcekey="str_prt">Port</asp:Localize></td>
                                            <td align="left" >
                                                <asp:TextBox ID="MySQLPort" runat="server"  CssClass="form-control" Text="3306"></asp:TextBox></td>
                                        </tr>
                                          <tr>
                                            <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100; "  ><asp:Localize runat="server" meta:resourcekey="str_dbsNme">Database Name</asp:Localize></td>
                                            <td align="left" >
                                                <asp:TextBox ID="MySQLDatabaseName" runat="server" CssClass="form-control"></asp:TextBox></td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100; "  ><asp:Localize runat="server" meta:resourcekey="str_usrNme">User Name</asp:Localize></td>
                                            <td align="left" >
                                                <asp:TextBox ID="MySQLUserName" runat="server" CssClass="form-control"></asp:TextBox></td>
                                        </tr>
                                         <tr>
                                            <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100; "  ><asp:Localize runat="server" meta:resourcekey="str_pwd">Password</asp:Localize></td>
                                            <td align="left" >
                                                <asp:TextBox ID="MySQLPassword" TextMode="Password" runat="server" CssClass="form-control"></asp:TextBox></td>
                                        </tr>

                                    </table>
                                </asp:Panel>
                                <asp:Panel ID="SqlPanel" runat="server" Visible="False">
                                    <table >
                                        <tr>
                                            <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100; "  ><asp:Localize runat="server" meta:resourcekey="str_dbsSvr">Database Server</asp:Localize></td>
                                            <td align="left" width="440px">
                                                <asp:TextBox ID="SQLDBSvr" runat="server" CssClass="form-control"></asp:TextBox></td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100; "  ><asp:Localize runat="server" meta:resourcekey="str_dbsNme">Database Name</asp:Localize></td>
                                            <td align="left" >
                                                <asp:TextBox ID="SQLDBName" runat="server" CssClass="form-control"></asp:TextBox></td>
                                        </tr>

                                        <tr>
                                            <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100; "  ><asp:Localize runat="server" meta:resourcekey="str_usrNme">User Name</asp:Localize></td>
                                            <td align="left" >
                                                <asp:TextBox ID="SQLUserName" runat="server" CssClass="form-control"></asp:TextBox></td>
                                        </tr>
                                         <tr>
                                            <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100; "  ><asp:Localize runat="server" meta:resourcekey="str_pwd">Password</asp:Localize></td>
                                            <td align="left" >
                                                <asp:TextBox ID="SQLPassword" runat="server" TextMode="Password"  CssClass="form-control"></asp:TextBox></td>
                                        </tr>

                                    </table>
                                </asp:Panel>
                                <asp:Panel ID="PSqlPanel" runat="server" Visible="false">
                                    <table >
                                        <tr>
                                            <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100; "  ><asp:Localize runat="server" meta:resourcekey="str_hstNme">Host Name</asp:Localize></td>
                                            <td align="left" width="280px">
                                                <asp:TextBox ID="PSQLHostName" runat="server" CssClass="form-control"></asp:TextBox></td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100; "  ><asp:Localize runat="server" meta:resourcekey="str_prt">Port</asp:Localize></td>
                                            <td align="left" width="280px">
                                                <asp:TextBox ID="PSQLPort" runat="server"  CssClass="form-control" Text="5432"></asp:TextBox></td>
                                        </tr>
                                          <tr>
                                            <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100; "  ><asp:Localize runat="server" meta:resourcekey="str_dbsNme">Database Name</asp:Localize></td>
                                            <td align="left" width="280px">
                                                <asp:TextBox ID="PSQLDatabaseName" runat="server" CssClass="form-control"></asp:TextBox></td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100; "  ><asp:Localize runat="server" meta:resourcekey="str_usrNme">User Name</asp:Localize></td>
                                            <td align="left" width="280px">
                                                <asp:TextBox ID="PSQLUserName" runat="server" CssClass="form-control"></asp:TextBox></td>
                                        </tr>
                                         <tr>
                                            <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100; "  ><asp:Localize runat="server" meta:resourcekey="str_pwd">Password</asp:Localize></td>
                                            <td align="left" width="280px">
                                                <asp:TextBox ID="PSQLPassword" TextMode="Password" runat="server" CssClass="form-control"></asp:TextBox></td>
                                        </tr>

                                    </table>
                                </asp:Panel>
                            </td>
                        </tr>
                        <tr>
                            <td style="padding-top: 5px; padding-left: 20px; " align="left">
                      
                    <asp:CheckBox ID="NoLogging" runat="server" Text="Don't migrate logging database" meta:resourcekey="str_dntMgtLogDbs" />
                
                            </td>
                        </tr>
                         <tr>
                            <td style="padding-top: 40px;padding-left: 20px; " align="right">
                                <asp:LinkButton ID="ApplyBtn" runat="server" CssClass="btn btn-primary gladbtn" OnClick="ApplyBtn_Click" OnClientClick="Wait('...');" meta:resourcekey="str_mgt">Migrate</asp:LinkButton>
                                
                            </td>
                        </tr>
                    </table>
                    </asp:Panel>
                <asp:Panel ID="MigratePanel" runat="server" Visible="false">
                     <table width="100%" align="center">
                        <tr>
                            <td class="aa" valign="top" style="padding-bottom: 5px; border-bottom: 1px solid #e0e0e0"
                                align="left">
                                <table style="width:100%;">
                                    <tr>
                                        <td>
                                <h1 style="font-size: 24px; font-weight: 100; color: #565656;">
                                    <asp:Localize runat="server" meta:resourcekey="str_mgg">Migrating</asp:Localize></h1>

                                        </td>
                                                                    <td style="padding-top: 15px; padding-right: 20px; color:red; font-size:18px;" id="MigError"></td>

                                    </tr>
                                </table>
                            </td>
                        </tr>
                        
                         <tr>
                             <td style="padding-top:20px;">
                                 <table width="100%" id="migstatus">
                                     <tr>
                                         <td width="200px" style="font-size:20px; font-weight:100; color:#565656; padding:10px;"><asp:Localize runat="server" meta:resourcekey="str_ovlPrg">Overall Progress</asp:Localize></td>
                                         <td id="OverStatus" style="font-size:20px; font-weight:100; color:#565656; padding:10px;"></td>
                                     </tr>
                                     <tr>
                                         <td colspan="2" style="font-size:20px; font-weight:100; color:#565656; padding:10px;">
                                             <div class="progress">
                                              <div class="progress-bar" role="progressbar" aria-valuenow="70" id="OverallProgress"
                                              aria-valuemin="0" aria-valuemax="100" style="width:0%"><asp:Localize meta:resourcekey="str_70" runat="server">70%</asp:Localize></div>
                                            </div>
                                         </td>
                                     </tr>
                                     <tr>
                                         <td height="40px">&nbsp;</td>
                                     </tr>
                                                                          <tr>
                                         <td width="200px" style="font-size:20px; font-weight:100; color:#565656; padding:10px;"><asp:Localize runat="server" meta:resourcekey="str_curTsk">Current Task</asp:Localize></td>
                                         <td id="CurrentTask" style="font-size:20px; font-weight:100; color:#565656; padding:10px;"></td>
                                     </tr>
                                     <tr>
                                         <td colspan="2" style="font-size:20px; font-weight:100; color:#565656; padding:10px;">
                                             <div class="progress">
                                              <div class="progress-bar" role="progressbar" aria-valuenow="70" id="CurrentProgress"
                                              aria-valuemin="0" aria-valuemax="100" style="width:0%"><asp:Localize meta:resourcekey="str_70" runat="server">70%</asp:Localize></div>
                                            </div>
                                         </td>
                                     </tr>
                                     <tr>
                                         <td height="40px">&nbsp;</td>
                                     </tr>
                                     
                                     <tr>
                                         <td colspan="2" align="right">
                                             <asp:LinkButton ID="CanelTask" runat="server" OnClick="CanelTask_Click" CssClass="btn btn-default" meta:resourcekey="str_cnl">Cancel</asp:LinkButton>
                                         </td>
                                     </tr>
                                 </table>
                                 <div id="sucdiv" style="padding:20px; font-size:24px; font-weight:100; color:#565656; display:none;">
                                     <asp:Localize runat="server" meta:resourcekey="str_cptScs">Completed successfully!</asp:Localize>
                                 </div>
                             </td>
                         </tr>
                         </table>
                </asp:Panel>
                <asp:Panel ID="DatabaseExistsPanel" runat="server" Visible="false">
                    <table width="100%">
                        <tr>
                            <td style="padding-top:100px;font-size:24px; font-weight:100; color:#565656; ">
                                <asp:Localize runat="server" meta:resourcekey="str_dbsArdExt">Database already exists, continue migration will wipe out all existing data, continue?</asp:Localize>
                            </td>
                        </tr>
                        <tr>
                            <td style="padding-top:60px; padding-right:20px;font-size:24px; font-weight:100;" align="right">
                                <asp:LinkButton ID="ContinueRec" runat="server" OnClick="ContinueRec_Click" CssClass="btn btn-warning" meta:resourcekey="str_cnt">Continue</asp:LinkButton>
                                <asp:LinkButton ID="CancelContinue" runat="server" OnClick="CancelContinue_Click" CssClass="btn btn-default" meta:resourcekey="str_cnl">Cancel</asp:LinkButton>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
               
            </td>
        </tr>
    </table>
    <asp:HiddenField ID="CurrentSessionId" runat="server" />
    <asp:HiddenField ID="SavedPwd" runat="server" />
        
    
    
    
</asp:Content>
