﻿<%@ Page Title="HIPAA" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="HIPPA.aspx.cs" Inherits="GladinetPayFlow.HIPPA" Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .style1 {
            width: 388px;
        }

        .style2 {
            min-width: 16px;
            text-align: center;
        }

        .pricetable {
            border: 1px solid #cccccc;
        }

        .plain9BlackOnNone {
            border-bottom: 1px solid #cccccc;
            border-right: 1px solid #cccccc;
        }

        .style3 {
            border-bottom: 1px solid #cccccc;
            border-right: 1px solid #cccccc;
            width: 121px;
        }
        .panel-heading{
            height:48px;
            vertical-align:middle;
            padding:10px;
        }
    </style>
</asp:Content>

<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">

    <div id="main_body" style="width: 100%;">
        <table width="100%">
            <tr>
                <td align="right"> 
                    
                        <asp:LinkButton ID="LinkButton1" runat="server" CssClass="btn btn-primary gladbtn" OnClick="LinkButton1_Click">
                       <i class="gladinet-icons md-32 md-dark hand" style="display:table-cell;" >µ</i>              
                            </asp:LinkButton>
                    

                </td>
            </tr>
            <tr>
                <td style="font-size: 24px; font-weight: 100; padding: 10px; padding-top:0px; color: #565656;">
                    <asp:Localize meta:resourcekey="str_hpaRqAreHstEnv" runat="server">Most of the HIPAA compliance requirements are about the hosting environment and are related to the hosting provider. Here is a list of action items you can take to better prepare for the HIPAA requirements in regards to your use of the product. It does not replace your own due diligence to be HIPAA compliant.</asp:Localize> 
                </td>
            </tr>
            <tr>
                <td style="padding:20px;">

                    <div class="card">
                        <div class="panel-heading toolnavbtn selbox" data-toggle="collapse" data-target="#genrule" style="cursor: pointer; font-size:20px; font-weight: 100; ">
                            <asp:Localize meta:resourcekey="str_genRls" runat="server">General Rules</asp:Localize>
                        </div>
                        <div id="genrule" class="collapse" style="background-color:white; padding:10px;">
                            <table width="100%">
                                <tr>
                                    <td style="font-size:18px; font-weight:100; color:#404040; border-bottom:1px solid #d0d0d0;" class="btniconcolor">
                                        <asp:Localize meta:resourcekey="str_esrCfyItyAvyPhi" runat="server">Ensure the confidentiality, integrity, and availability of all Electronic protected health information (ePHI) they create, receive, maintain or transmit.</asp:Localize>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding:10px; padding-bottom:20px; font-weight:100; font-size:16px;">
                                        <table width="100%" class="table">
                                            <tr>
                                                <td class="btniconcolor" width="150px" style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_gce" runat="server">CentreStack</asp:Localize>
                                                </td>
                                                <td style="font-size:16px;">
                                                    <table width="100%">
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px; padding:3px; width:600px;"><asp:Localize meta:resourcekey="str_enbDARE" runat="server">Enable Data-At-Rest Encryption</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                                

                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                                
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlHtpTrs" runat="server">Enable HTTPS transmission</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 <%if (m_SSL){ %>
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                <%}else{ %>
                                                                <span class="	fa fa-question" style="color:#800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <%if (!m_SSL){ %>
                                                                    <asp:Localize meta:resourcekey="str_extUrlOrFrcSSLNotEnl" runat="server">External URL is not configured with HTTPS, or the Force SSL setting is not enabled.</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlTfrThrWkrNde" runat="server">Enable Upload/Download must be via worker node</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlVsnCtl" runat="server">Enable Version Control</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>

                                                            </td>
                                                        </tr>
                                                          <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlAntVrsItg" runat="server">Enable Anti-virus integration</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 <%if (m_AV){ %>
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                <%}else{ %>
                                                                <span class="	fa fa-question" style="color:#800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <%if (!m_AV){ %>
                                                                    <asp:Localize meta:resourcekey="str_antVrsNotEnl" runat="server">Anti-virus is not enabled</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                        </tr>
                                                         <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlRswPrt" runat="server">Enable Ransomware protection</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlcheEcr" runat="server">Enable local cache encryption</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>

                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlEdpPrt" runat="server">Enable "Endpoint Protection"</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </td>
                                            </tr>

                                             <tr style="padding-top:10px;">
                                                <td class="btniconcolor" style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_hstPvr" runat="server">Hosting Provider</asp:Localize>
                                                </td>
                                                 <td style="font-size:16px; padding:3px;">
                                                     <asp:Localize meta:resourcekey="str_bkpDtaStgCs" runat="server">Backup your data storage and backup CentreStack database</asp:Localize>
                                                 </td>
                                            </tr>

                                        </table>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="font-size:18px; font-weight:100; color:#404040; border-bottom:1px solid #d0d0d0;" class="btniconcolor">
                                        <asp:Localize meta:resourcekey="str_idyPrtAgtTht" runat="server">Identify and protect against reasonably anticipated threats to the security or integrity of the information</asp:Localize>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding:10px; padding-bottom:20px; font-weight:100; font-size:16px;">
                                        <table width="100%" class="table">
                                            <tr>
                                                <td class="btniconcolor" width="150px" style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_gce" runat="server">CentreStack</asp:Localize>
                                                </td>
                                                <td style="font-size:16px;">
                                                    <table width="100%">
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px; padding:3px; width:600px;"><asp:Localize meta:resourcekey="str_PutCsDmz" runat="server">Put CentreStack in the DMZ, behind a firewall</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 <%if (m_DMZ){ %>
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                <%}else{ %>
                                                                <span class="	fa fa-question" style="color:#800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <%if (!m_EPProtect){ %>
                                                                    <asp:Localize meta:resourcekey="str_cntVryDmz" runat="server">We cannot verify if the server is in the DMZ.</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlPwdPlc" runat="server">Enable password policy</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_efcTwoStpVfn" runat="server">Enforce 2-Step Verification</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                               
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                               <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlItrDtcAlt" runat="server">Enable intrusion detection and alerting</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 <%if (m_Intru){ %>
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                <%}else{ %>
                                                                <span class="	fa fa-question" style="color:#800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <%if (!m_Intru){ %>
                                                                    <asp:Localize meta:resourcekey="str_itrDtcAltNotEnl" runat="server">"Intrusion detection and alerting" is not enabled</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px; padding:3px; width:600px;"><asp:Localize meta:resourcekey="str_enbDARE" runat="server">Enable Data-At-Rest Encryption</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                

                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlHtpTrs" runat="server">Enable HTTPS transmission</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 <%if (m_SSL){ %>
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                <%}else{ %>
                                                                <span class="	fa fa-question" style="color:#800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <%if (!m_SSL){ %>
                                                                    <asp:Localize meta:resourcekey="str_extUrlOrFrcSSLNotEnl" runat="server">External URL is not configured with HTTPS, or the Force SSL setting is not enabled.</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                        </tr>
                                                          <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlAntVrsItg" runat="server">Enable Anti-virus integration</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 <%if (m_AV){ %>
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                <%}else{ %>
                                                                <span class="	fa fa-question" style="color:#800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <%if (!m_AV){ %>
                                                                    <asp:Localize meta:resourcekey="str_antVrsNotEnl" runat="server">Anti-virus is not enabled</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                        </tr>
                                                         <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlRswPrt" runat="server">Enable Ransomware protection</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlcheEcr" runat="server">Enable local cache encryption</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">

                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlEdpPrt" runat="server">Enable "Endpoint Protection"</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>

                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_rlebsdAcs" runat="server">Enable "Role-based access"</asp:Localize></td>
                                                         <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </td>
                                            </tr>

                                             <tr style="padding-top:10px;">
                                                <td class="btniconcolor" style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_hstPvr" runat="server">Hosting Provider</asp:Localize>
                                                </td>
                                                 <td style="font-size:16px; padding:3px;">
                                                      <asp:Localize meta:resourcekey="str_secNwkSvr" runat="server">Secure the network that the CentreStack server is in and secure the related perimeter.</asp:Localize>
                                                 </td>
                                            </tr>

                                        </table>
                                    </td>
                                </tr>
                                
                                <tr>
                                    <td style="font-size:18px; font-weight:100; color:#404040; border-bottom:1px solid #d0d0d0;" class="btniconcolor">
                                        <asp:Localize meta:resourcekey="str_prtAgtRsbAtp" runat="server">Protect against reasonably anticipated, impermissible uses or disclosures</asp:Localize>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding:10px; padding-bottom:20px; font-weight:100; font-size:16px;">
                                        <table width="100%" class="table">
                                            <tr>
                                                <td class="btniconcolor" width="150px" style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_gce" runat="server">CentreStack</asp:Localize>
                                                </td>
                                                <td style="font-size:16px;">
                                                    <table width="100%">
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px; padding:3px; width:600px;"><asp:Localize meta:resourcekey="str_enlPlcSndEmlNtfWhnLgnIn" runat="server">Enable Policy "Send email notification when logging in from a new location/device"</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlActLgnPrtPlc" runat="server">Enable account login protection policy</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_efcTwoStpVfn" runat="server">Enforce 2-Step Verification</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlStgShrPlc" runat="server">Enable strong sharing policy</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlMinSetOfFldPrm" runat="server">Enable minimal set of folder permissions</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlItrDtcAlt" runat="server">Enable intrusion detection and alerting</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 <%if (m_Intru){ %>
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                <%}else{ %>
                                                                <span class="	fa fa-question" style="color:#800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <%if (!m_Intru){ %>
                                                                    <asp:Localize meta:resourcekey="str_itrDtcAltNotEnl" runat="server">"Intrusion detection and alerting" is not enabled</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                        </tr>
                                                         <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_hdeFldUsrDntHvePrm" runat="server">Hide the folder that user doesn't have permissions for</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_ltdAcsCrtInf" runat="server">Limited access of critical information based on location</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_lvgSecDtaRom" runat="server">Leverage secure data room feature</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>

                                                    </table>
                                                </td>
                                            </tr>

                                             <tr style="padding-top:10px;">
                                                <td class="btniconcolor" style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_hstPvr" runat="server">Hosting Provider</asp:Localize>
                                                </td>
                                                 <td style="font-size:16px; padding:3px;">
                                                     
                                                 </td>
                                            </tr>

                                        </table>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="font-size:18px; font-weight:100; color:#404040; border-bottom:1px solid #d0d0d0;" class="btniconcolor">
                                        <asp:Localize meta:resourcekey="str_esrCpcWkf" runat="server">Ensure compliance by their workforce</asp:Localize>
                                    </td>
                                </tr>

                                <tr>
                                    <td style="padding:10px; padding-bottom:20px; font-weight:100; font-size:16px;">
                                        <table width="100%" class="table">
                                            <tr>
                                                <td class="btniconcolor" width="150px" style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_gce" runat="server">CentreStack</asp:Localize>
                                                </td>
                                                <td style="font-size:16px;">
                                                    <table width="100%">
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px; padding:3px; width:600px;"><asp:Localize meta:resourcekey="str_crtDdtCsAdm" runat="server">Create Dedicated CentreStack administrator</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;"><span class="fa fa-check" style="color:#008000;"></span></td>
                                                            <td style="font-size:16px; padding:3px;"></td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_crtDdtTntAdm" runat="server">Create Dedicated Tenant Administrator</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;"><span class="fa fa-check" style="color:#008000;"></span></td>
                                                            <td style="font-size:16px; padding:3px;"></td>
                                                        </tr>
                                                    </table>
                                                </td>
                                            </tr>

                                             <tr style="padding-top:10px;">
                                                <td class="btniconcolor" style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_hstPvr" runat="server">Hosting Provider</asp:Localize>
                                                </td>
                                                 <td style="font-size:16px; padding:3px;">
                                                     <asp:Localize meta:resourcekey="str_trnStfHpaReq" runat="server">Train staff on HIPAA related requirements and CentreStack related features</asp:Localize>
                                                 </td>
                                            </tr>

                                        </table>
                                    </td>
                                </tr>
                            </table>
                                
                            
                        </div>
                    </div>
                    <div style="height: 10px"></div>
                    <div class="card">
                        <div class="panel-heading toolnavbtn selbox" data-toggle="collapse" data-target="#adminguard" style="cursor: pointer; font-size:18px;font-weight: 100; ">
                            <asp:Localize meta:resourcekey="str_admSfg" runat="server">Administrative Safeguards</asp:Localize>
                        </div>
                        <div id="adminguard" class="collapse" style="background-color:white; padding:10px;">
                            <table width="100%">
                                <tr>
                                    <td style="font-size:18px; font-weight:100; color:#404040; border-bottom:1px solid #d0d0d0;" class="btniconcolor">
                                        <asp:Localize meta:resourcekey="str_secMgtPrs" runat="server">Security Management Process. As explained in the previous section, a covered entity must identify and analyze potential risks to ePHI, and it must implement security measures that reduce risks and vulnerabilities to a reasonable and appropriate level</asp:Localize>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding:10px; padding-bottom:20px; font-weight:100; font-size:16px;">
                                        <table width="100%" class="table">
                                            <tr>
                                                <td class="btniconcolor" width="150px" style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_gce" runat="server">CentreStack</asp:Localize>
                                                </td>
                                                <td style="font-size:16px;">
                                                    <table width="100%">
                                                       <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px; padding:3px; width:600px;"><asp:Localize meta:resourcekey="str_acsMgtRltPgsItr" runat="server">Access management related pages from Intranet Only</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 <%if (m_LocalMMC){ %>
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                <%}else{ %>
                                                                <span class="	fa fa-question" style="color:#800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <%if (!m_LocalMMC){ %>
                                                                    <asp:Localize meta:resourcekey="str_plcNotEnl" runat="server">Policy is not enabled</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                        </tr>

                                                    </table>
                                                </td>
                                            </tr>

                                             <tr style="padding-top:10px;">
                                                <td class="btniconcolor" style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_hstPvr" runat="server">Hosting Provider</asp:Localize>
                                                </td>
                                                 <td style="font-size:16px; padding:3px;">
                                                     <asp:Localize meta:resourcekey="str_pprNwkDgmDoc" runat="server">Prepare network diagram documentation and analysis</asp:Localize>
                                                 </td>
                                            </tr>

                                        </table>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="font-size:18px; font-weight:100; color:#404040; border-bottom:1px solid #d0d0d0;" class="btniconcolor">
                                        <asp:Localize meta:resourcekey="str_secPrlSecOfl" runat="server">Security Personnel. A covered entity must designate a security official who is responsible for developing and implementing its security policies and procedures</asp:Localize>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding:10px; padding-bottom:20px; font-weight:100; font-size:16px;">
                                        <table width="100%" class="table">
                                            <tr>
                                                <td class="btniconcolor" width="150px" style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_gce" runat="server">CentreStack</asp:Localize>
                                                </td>
                                                <td style="font-size:16px;">
                                                    
                                                </td>
                                            </tr>

                                             <tr style="padding-top:10px;">
                                                <td class="btniconcolor" style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_hstPvr" runat="server">Hosting Provider</asp:Localize>
                                                </td>
                                                 <td style="font-size:16px; padding:3px;">
                                                     <asp:Localize meta:resourcekey="str_hveSneSpcSec" runat="server">Have someone specialized in security</asp:Localize>
                                                 </td>
                                            </tr>

                                        </table>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="font-size:18px; font-weight:100; color:#404040; border-bottom:1px solid #d0d0d0;" class="btniconcolor">
                                         <asp:Localize meta:resourcekey="str_infAcsMgt" runat="server">Information Access Management. Consistent with the Privacy Rule standard limiting uses and disclosures of PHI to the "minimum necessary," the Security Rule requires a covered entity to implement policies and procedures for authorizing access to ePHI only when such access is appropriate based on the user or recipient's role (role-based access).</asp:Localize>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding:10px; padding-bottom:20px; font-weight:100; font-size:16px;">
                                        <table width="100%" class="table">
                                            <tr>
                                                <td class="btniconcolor" width="150px" style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_gce" runat="server">CentreStack</asp:Localize>
                                                </td>
                                                <td style="font-size:16px;">
                                                    <table width="100%">
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px; padding:3px; width:600px;"><asp:Localize meta:resourcekey="str_tntAdmMinAcs" runat="server">Tenant administrator - minimum access - only assign to those who need it.</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;"><span class="fa fa-check" style="color:#008000;"></span></td>
                                                            <td style="font-size:16px; padding:3px;"></td>
                                                        </tr>
                                                                                                               <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_rlebsdAcs" runat="server">Enable "Role-based access"</asp:Localize></td>
                                                         <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>

                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlItrDtcAlt" runat="server">Enable intrusion detection and alerting</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 <%if (m_Intru){ %>
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                <%}else{ %>
                                                                <span class="	fa fa-question" style="color:#800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <%if (!m_Intru){ %>
                                                                    <asp:Localize meta:resourcekey="str_itrDtcAltNotEnl" runat="server">"Intrusion detection and alerting" is not enabled</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                        </tr>
                                                         <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_ltdAcsCrtInf" runat="server">Limited access of critical information based on location</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_lvgSecDtaRom" runat="server">Leverage secure data room feature</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlMinSetOfFldPrm" runat="server">Enable minimal set of folder permissions</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                         <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_hdeFldUsrDntHvePrm" runat="server">Hide the folder that user doesn't have permissions for</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                         <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlStgShrPlc" runat="server">Enable strong sharing policy</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>

                                                    </table>
                                                </td>
                                            </tr>

                                             <tr style="padding-top:10px;">
                                                <td class="btniconcolor" style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_hstPvr" runat="server">Hosting Provider</asp:Localize>
                                                </td>
                                                 <td style="font-size:16px; padding:3px;"><asp:Localize runat="server" meta:resourcekey="str_CenAdmMinNec">CentreStack administrator - minimum necessary</asp:Localize></td>
                                            </tr>

                                        </table>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="font-size:18px; font-weight:100; color:#404040; border-bottom:1px solid #d0d0d0;" class="btniconcolor">
                                        <p><asp:Localize meta:resourcekey="str_wkfTrgMgt" runat="server">Workforce Training and Management. A covered entity must provide for appropriate authorization and supervision of workforce members who work with ePHI.</asp:Localize></p>
                                        <p><asp:Localize meta:resourcekey="str_cvdEtyTrn" runat="server">A covered entity must train all workforce members regarding its security policies and procedures, and must have and apply appropriate sanctions against workforce members who violate its policies and procedures.</asp:Localize></p>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding:10px; padding-bottom:20px; font-weight:100; font-size:16px;">
                                        <table width="100%" class="table">
                                            
                                                                                        <tr>
                                                <td class="btniconcolor" width="150px" style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_gce" runat="server">CentreStack</asp:Localize>
                                                </td>
                                                <td style="font-size:16px;">
                                                    
                                                </td>
                                            </tr>

                                             <tr style="padding-top:10px;">
                                                <td class="btniconcolor" style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_hstPvr" runat="server">Hosting Provider</asp:Localize>
                                                </td>
                                                 <td style="font-size:16px; padding:3px;">
                                                     <asp:Localize meta:resourcekey="str_trnHpa" runat="server">Training in HIPAA related requirement and CentreStack related administration.</asp:Localize>
                                                 </td>
                                            </tr>

                                        </table>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="font-size:18px; font-weight:100; color:#404040; border-bottom:1px solid #d0d0d0;" class="btniconcolor">
                                        <asp:Localize meta:resourcekey="str_evl" runat="server">Evaluation. A covered entity must perform a periodic assessment of how well its security policies and procedures meet the requirements of the Security Rule.</asp:Localize>
                                    </td>
                                </tr>
                                  <tr>
                                    <td style="padding:10px; padding-bottom:20px; font-weight:100; font-size:16px;">
                                        <table width="100%" class="table">
                                            <tr>
                                                <td class="btniconcolor" width="150px" style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_gce" runat="server">CentreStack</asp:Localize>
                                                </td>
                                                <td style="font-size:16px;">
                                                    
                                                </td>
                                            </tr>

                                             <tr style="padding-top:10px;">
                                                <td class="btniconcolor" style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_hstPvr" runat="server">Hosting Provider</asp:Localize>
                                                </td>
                                                 <td style="font-size:16px; padding:3px;">
                                                     <asp:Localize meta:resourcekey="str_mtlQtlRvwPrc" runat="server">Monthly or quarterly review process</asp:Localize>
                                                 </td>
                                            </tr>

                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                    <div style="height: 10px"></div>

                    <div class="card">
                        <div class="panel-heading toolnavbtn selbox" data-toggle="collapse" data-target="#phyguards" style="cursor: pointer; font-weight: 100;font-size:18px; ">
                            <asp:Localize meta:resourcekey="str_phlSfg" runat="server">Physical Safeguards</asp:Localize>
                        </div>
                        <div id="phyguards" class="collapse" style="background-color:white; padding:10px;">
                            <table width="100%">
                                <tr>
                                    <td style="font-size:18px; font-weight:100; color:#404040; border-bottom:1px solid #d0d0d0;" class="btniconcolor">
                                        <asp:Localize meta:resourcekey="str_fclAcsCtl" runat="server">Facility Access and Control. A covered entity must limit physical access to its facilities while ensuring that authorized access is allowed.</asp:Localize>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding:10px; padding-bottom:20px; font-weight:100; font-size:16px;">
                                        <table width="100%" class="table">
                                            <tr>
                                                <td class="btniconcolor" width="150px" style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_gce" runat="server">CentreStack</asp:Localize>
                                                </td>
                                                <td style="font-size:16px;">
                                                    
                                                </td>
                                            </tr>

                                             <tr style="padding-top:10px;">
                                                <td class="btniconcolor" style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_hstPvr" runat="server">Hosting Provider</asp:Localize>
                                                </td>
                                                 <td style="font-size:16px; padding:3px;">
                                                     <asp:Localize meta:resourcekey="str_secPhsAcs" runat="server">Secure the physical access to servers and workstations and secure the related physical perimeter.</asp:Localize>
                                                 </td>
                                            </tr>

                                        </table>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="font-size:18px; font-weight:100; color:#404040; border-bottom:1px solid #d0d0d0;" class="btniconcolor">
                                        <asp:Localize meta:resourcekey="str_wksDvcSec" runat="server">Workstation and Device Security. A covered entity must implement policies and procedures to specify proper use of and access to workstations and electronic media. A covered entity also must have in place policies and procedures regarding the transfer, removal, disposal, and re-use of electronic media, to ensure appropriate protection of electronic protected health information (ePHI).</asp:Localize>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding:10px; padding-bottom:20px; font-weight:100; font-size:16px;">
                                        <table width="100%" class="table">
                                            <tr>
                                                <td class="btniconcolor" width="150px" style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_gce" runat="server">CentreStack</asp:Localize>
                                                </td>
                                                <td style="font-size:16px;">
                                                    <table width="100%">
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlReqApvDvcAcs" runat="server">Enable "Require approval for device access"</asp:Localize></td>
                                                               <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>

                                                         <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlItrDtcAlt" runat="server">Enable intrusion detection and alerting</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 <%if (m_Intru){ %>
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                <%}else{ %>
                                                                <span class="	fa fa-question" style="color:#800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <%if (!m_Intru){ %>
                                                                    <asp:Localize meta:resourcekey="str_itrDtcAltNotEnl" runat="server">"Intrusion detection and alerting" is not enabled</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                        </tr>

                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_ltdAcsCrtInf" runat="server">Limited access of critical information based on location</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>                                                        
                                                        
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_lvgSecDtaRom" runat="server">Leverage secure data room feature</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px; padding:3px; width:600px;"><asp:Localize meta:resourcekey="str_enlPlcSndEmlNtfWhnLgnIn" runat="server">Enable Policy "Send email notification when logging in from a new location/device"</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                          <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlAntVrsItg" runat="server">Enable Anti-virus integration</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                         <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlRswPrt" runat="server">Enable Ransomware protection</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlcheEcr" runat="server">Enable local cache encryption</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlEdpPrt" runat="server">Enable "Endpoint Protection"</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>

                                                    </table>
                                                </td>
                                            </tr>

                                             <tr style="padding-top:10px;">
                                                <td class="btniconcolor" style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_hstPvr" runat="server">Hosting Provider</asp:Localize>
                                                </td>
                                                 <td style="font-size:16px; padding:3px;">
                                                     <asp:Localize meta:resourcekey="str_secPhsAcs" runat="server">Secure the physical access to servers and workstations and secure the related physical perimeter.</asp:Localize>
                                                 </td>
                                            </tr>

                                        </table>
                                    </td>
                                </tr>
                                
                            </table>
                        </div>
                    </div>
                    <div style="height: 10px"></div>

                    <div class="card">
                        <div class="panel-heading toolnavbtn selbox" data-toggle="collapse" data-target="#tecguards" style="cursor: pointer; font-weight: 100;font-size:18px; ">
                            <asp:Localize meta:resourcekey="str_tchSfg" runat="server">Technical Safeguards</asp:Localize>
                        </div>
                        <div id="tecguards" class="collapse" style="background-color:white; padding:10px;">
                            <table width="100%">
                                <tr>
                                    <td style="font-size:18px; font-weight:100; color:#404040; border-bottom:1px solid #d0d0d0;" class="btniconcolor">
                                        <asp:Localize meta:resourcekey="str_acsCtlPhi" runat="server">Access Control. A covered entity must implement technical policies and procedures that allow only authorized persons to access electronic protected health information (ePHI)</asp:Localize>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding:10px; padding-bottom:20px; font-weight:100; font-size:16px;">
                                        <table width="100%" class="table">
                                            <tr>
                                                <td class="btniconcolor" width="150px" style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_gce" runat="server">CentreStack</asp:Localize>
                                                </td>
                                                <td style="font-size:16px;">
                                                    <table width="100%">
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlReqApvDvcAcs" runat="server">Enable "Require approval for device access"</asp:Localize></td>
                                                               <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_crtDdtTntAdm" runat="server">Create Dedicated Tenant Administrator</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;"><span class="fa fa-check" style="color:#008000;"></span></td>
                                                            <td style="font-size:16px; padding:3px;"></td>
                                                        </tr>

                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlItrDtcAlt" runat="server">Enable intrusion detection and alerting</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 <%if (m_Intru){ %>
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                <%}else{ %>
                                                                <span class="	fa fa-question" style="color:#800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <%if (!m_Intru){ %>
                                                                    <asp:Localize meta:resourcekey="str_itrDtcAltNotEnl" runat="server">"Intrusion detection and alerting" is not enabled</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlMinSetOfFldPrm" runat="server">Enable minimal set of folder permissions</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                         <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_hdeFldUsrDntHvePrm" runat="server">Hide the folder that user doesn't have permissions for</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_rlebsdAcs" runat="server">Enable "Role-based access"</asp:Localize></td>
                                                         <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                       <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px; padding:3px; width:600px;"><asp:Localize meta:resourcekey="str_acsMgtRltPgsItr" runat="server">Access management related pages from Intranet Only</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 <%if (m_LocalMMC){ %>
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                <%}else{ %>
                                                                <span class="	fa fa-question" style="color:#800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <%if (!m_LocalMMC){ %>
                                                                    <asp:Localize meta:resourcekey="str_plcNotEnl" runat="server">Policy is not enabled</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                        </tr>

                                                    </table>
                                                </td>
                                            </tr>

                                             <tr style="padding-top:10px;">
                                                <td class="btniconcolor" style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_hstPvr" runat="server">Hosting Provider</asp:Localize>
                                                </td>
                                                 <td style="font-size:16px; padding:3px;">
                                                     <asp:Localize meta:resourcekey="str_hstPvrStmAdm" runat="server">Hosting provider system administrator - assigned and minimum access</asp:Localize>
                                                 </td>
                                            </tr>

                                        </table>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="font-size:18px; font-weight:100; color:#404040; border-bottom:1px solid #d0d0d0;" class="btniconcolor">
                                        <asp:Localize meta:resourcekey="str_adtCtls" runat="server">Audit Controls. A covered entity must implement hardware, software, and/or procedural mechanisms to record and examine access and other activity in information systems that contain or use ePHI</asp:Localize>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding:10px; padding-bottom:20px; font-weight:100; font-size:16px;">
                                        <table width="100%" class="table">
                                            <tr>
                                                <td class="btniconcolor" width="150px" style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_gce" runat="server">CentreStack</asp:Localize>
                                                </td>
                                                <td style="font-size:16px;">
                                                    <table width="100%">
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px; padding:3px; width:600px;"><asp:Localize meta:resourcekey="str_stpAdtRetPlc" runat="server">Setup audit retention policy that meets the policy</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 <%if (m_AuditRet){ %>
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                <%}else{ %>
                                                                <span class="	fa fa-question" style="color:#800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <%if (!m_AuditRet){ %>
                                                                    <asp:Localize meta:resourcekey="str_retTmeCldBeTooSht" runat="server">Retention time could be too short for one or more tenants</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px; padding:3px; width:600px;"><asp:Localize meta:resourcekey="str_stpFilChgLogRetPlc" runat="server">Setup file change log retention policy that meets the policy</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 <%if (m_ChangeRet){ %>
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                <%}else{ %>
                                                                <span class="	fa fa-question" style="color:#800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <%if (!m_ChangeRet){ %>
                                                                    <asp:Localize meta:resourcekey="str_retTmeCldBeTooSht" runat="server">Retention time could be too short for one or more tenants</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                        </tr>

                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_splDbAdtChgLog" runat="server">Split database for audit and change logs</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 <%if (m_SplitDB){ %>
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                <%}else{ %>
                                                                <span class="	fa fa-question" style="color:#800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <%if (!m_SplitDB){ %>
                                                                    <asp:Localize meta:resourcekey="str_lgnDbNotIst" runat="server">Logging database is not isolated and SQL Express is used.</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </td>
                                            </tr>

                                             <tr style="padding-top:10px;">
                                                <td class="btniconcolor" style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_hstPvr" runat="server">Hosting Provider</asp:Localize>
                                                </td>
                                                 <td style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_hstPvrNtwAcsAdt" runat="server">Hosting provider has network access related audit</asp:Localize>
                                                 </td>
                                            </tr>

                                        </table>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="font-size:18px; font-weight:100; color:#404040; border-bottom:1px solid #d0d0d0;" class="btniconcolor">
                                        <asp:Localize meta:resourcekey="str_itgCtl" runat="server">Integrity Controls. A covered entity must implement policies and procedures to ensure that ePHI is not improperly altered or destroyed. Electronic measures must be put in place to confirm that ePHI has not been improperly altered or destroyed.</asp:Localize>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding:10px; padding-bottom:20px; font-weight:100; font-size:16px;">
                                        <table width="100%" class="table">
                                            <tr>
                                                <td class="btniconcolor" width="150px" style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_gce" runat="server">CentreStack</asp:Localize>
                                                </td>
                                                <td style="font-size:16px;">
                                                    <table width="100%">
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;width:600px;" ><asp:Localize meta:resourcekey="str_enlVsnCtl" runat="server">Enable Version Control</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                          <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlAntVrsItg" runat="server">Enable Antivirus integration</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 <%if (m_AV){ %>
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                <%}else{ %>
                                                                <span class="	fa fa-question" style="color:#800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <%if (!m_AV){ %>
                                                                    <asp:Localize meta:resourcekey="str_antVrsNotEnl" runat="server">Antivirus is not enabled</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                        </tr>
                                                         <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlRswPrt" runat="server">Enable Ransomware protection</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlcheEcr" runat="server">Enable local cache encryption</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlEdpPrt" runat="server">Enable "Endpoint Protection"</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_stpRetPlcMtsReq" runat="server">Setup a retention policy that meets the requirement.</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlItrDtcAlt" runat="server">Enable intrusion detection and alerting</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 <%if (m_Intru){ %>
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                <%}else{ %>
                                                                <span class="	fa fa-question" style="color:#800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <%if (!m_Intru){ %>
                                                                    <asp:Localize meta:resourcekey="str_itrDtcAltNotEnl" runat="server">"Intrusion detection and alerting" is not enabled</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                        </tr>

                                                    </table>
                                                </td>
                                            </tr>

                                             <tr style="padding-top:10px;">
                                                <td class="btniconcolor" style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_hstPvr" runat="server">Hosting Provider</asp:Localize>
                                                </td>
                                                 <td style="font-size:16px; padding:3px;">
                                                     <asp:Localize meta:resourcekey="str_hstPvrBkp" runat="server">Hosting provider has backup for data storage and audit network access</asp:Localize>
                                                 </td>
                                            </tr>

                                        </table>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="font-size:18px; font-weight:100; color:#404040; border-bottom:1px solid #d0d0d0;" class="btniconcolor">
                                        <asp:Localize meta:resourcekey="str_trnSec" runat="server">Transmission Security. A covered entity must implement technical security measures that guard against unauthorized access to ePHI that is being transmitted over an electronic network.</asp:Localize>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding:10px; padding-bottom:20px; font-weight:100; font-size:16px;">
                                        <table width="100%" class="table">
                                            <tr>
                                                <td class="btniconcolor" width="150px" style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_gce" runat="server">CentreStack</asp:Localize>
                                                </td>
                                                <td style="font-size:16px;">
                                                    <table width="100%">
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px; padding:3px; width:600px;"><asp:Localize meta:resourcekey="str_enbDARE" runat="server">Enable Data-At-Rest Encryption</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                

                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlHtpTrs" runat="server">Enable HTTPS transmission</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 <%if (m_SSL){ %>
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                <%}else{ %>
                                                                <span class="	fa fa-question" style="color:#800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <%if (!m_SSL){ %>
                                                                    <asp:Localize meta:resourcekey="str_extUrlOrFrcSSLNotEnl" runat="server">External URL is not configured with HTTPS, or the Force SSL setting is not enabled.</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size:16px;padding:3px;"><asp:Localize meta:resourcekey="str_enlTfrThrWkrNde" runat="server">Enable Upload/Download must be via worker node</asp:Localize></td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                 
                                                                <span class="fa fa-check" style="color:#008000;"></span>
                                                                
                                                            </td>
                                                            <td style="font-size:16px; padding:3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </td>
                                            </tr>

                                             <tr style="padding-top:10px;">
                                                <td class="btniconcolor" style="font-size:16px; padding:3px;">
                                                    <asp:Localize meta:resourcekey="str_hstPvr" runat="server">Hosting Provider</asp:Localize>
                                                </td>
                                                 <td style="font-size:16px; padding:3px;">
                                                     <asp:Localize meta:resourcekey="str_useSsl" runat="server">Use SSL/HTTPS for data transmission and secure the related ports and access policy via firewall and related network devices.</asp:Localize>
                                                 </td>
                                            </tr>

                                        </table>
                                    </td>
                                </tr>
                            </table>
                                
                        </div>
                    </div>
                    <div style="height: 10px"></div>
                </td>
            </tr>
        </table>
    </div>

    <script type="text/javascript">
        function ReturnLast() {
            window.location = "<%=PageReturnUrl %>";
             }

             function AdjustSize() {

                 var f = document.getElementById('main_body');
                 f.style.height = (document.documentElement.clientHeight - 42) + "px";
                 f.style.marginTop = "8px";
             }


             Ext.onReady(function () {
                 AdjustSize();

             });

             Ext.EventManager.onWindowResize(function () {
                 AdjustSize();
             });




    </script>

</asp:Content>
