﻿<%@ Page Title="Gladinet Cloud - Publish Folder" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="GroupPolicySecStorage.aspx.cs" Inherits="GladinetPayFlow.GroupPolicySecStorage"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    

    <style type="text/css">
        td {
            font-size: 15px;            
            font-weight: 100;
        }
        
        b {
            font-weight: 500;
        }
        
        .badgefont {
            font-size: 15px;
            
        }

    </style>
    <script type="text/javascript">

        function OnSaveChanges() {
            Wait("Please wait...");
            var btn = document.getElementById('ctl00_MainContent_ApplyBtn');
            btn.click();

        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <nav class="navbar navbar-default navbar-fixed-top" role="navigation" style="display: none;">
        <div class="navbar-left">
            <asp:Label ID="ErrorMsg" runat="server" ForeColor="Red" meta:resourcekey="ErrorMsgResource1"></asp:Label>
        </div>
            <div class="container-fluid" style="padding-right: 30px;">
                 <% if (m_CanEdit){ %>
                        <asp:Button ID="EditBtn" runat="server" 
                            CausesValidation="False" OnClientClick="Wait('Apply Change')"
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" 
                            Text="Edit" onclick="EditBtn_Click" 
                     meta:resourcekey="EditBtnResource1" ></asp:Button>                                                        
                            
                        <asp:Button ID="CancelBtn" runat="server" Visible="False"
                            CausesValidation="False" OnClientClick="Wait('Please wait')"
                            CssClass="btn  navbar-btn navbar-right btndlg" 
                            Text="Cancel" onclick="CancelBtn_Click" Width="108px" 
                     meta:resourcekey="CancelBtnResource1"></asp:Button>    
                            &nbsp;&nbsp;&nbsp;&nbsp; 
                        <asp:Button ID="ApplyBtn" runat="server" Visible="False"
                            CausesValidation="False" OnClick="ApplylNow_Click" OnClientClick="Wait('Apply Change')"
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" meta:resourcekey="ApplylNowResource1" 
                            Text="Apply" Width="108px"></asp:Button>       
                            &nbsp;&nbsp;&nbsp;&nbsp;                                                 
                <% } %>
            </div>
            </nav>
    
    <div class="wrapper" style="background-color: white; width:100%;margin-top: 10px;font-size: 16px;">
     <table width="100%" class="table-striped" style="margin-bottom: 100px;">
         <%if(Attach.Visible && !IsServo){ %>
         <tr>
             <td width="500px" style="padding: 15px;">
                <asp:Label ID="Label1" runat="server" Text="Allow users to attach external cloud storage"
                            meta:resourcekey="AllowAttachResource1"></asp:Label>        
                            <p class="text-muted" style="font-size: smaller">
                                        <asp:Localize ID="Localize1" meta:resourcekey="asp_string1" runat="server" Text="This setting will not take effect until your user login next time."></asp:Localize></p>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox ID="AllowAttach" runat="server" onclick="ShowSavePanel();"  />
             </td>
         </tr>
         <%} %>
                  <tr>
             <td width="500px" style="padding: 15px;">
                 <asp:Label ID="Label3" runat="server" Text="Don't show folder that user doesn't have read permission"
                        meta:resourcekey="HideDeniedFolderResource1"></asp:Label>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox ID="HideDeniedFolder" runat="server" onclick="ShowSavePanel();"  />
             </td>
         </tr>
         <%if(!IsServo) { %>
         <tr>
             <td style="padding: 15px;">
                 <asp:Label ID="Label2" runat="server" Text="Disable versioned folder"
                        meta:resourcekey="DisableVersionResource1"></asp:Label>
                        <p class="text-muted" style="font-size: smaller">
                        <asp:Localize ID="Localize1_1" meta:resourcekey="asp_string2" runat="server" Text="When this setting is set, the feature of versioned folder will be hidden."></asp:Localize></p>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox ID="DisableVersion" runat="server" onclick="ShowSavePanel();"  />
             </td>
         </tr>
         <tr>
             <td style="padding: 15px;">
                 <asp:Localize meta:resourcekey="str_disTrhCan" runat="server">Disable Trash Can</asp:Localize>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox ID="NoTrashCan" runat="server" onclick="ShowSavePanel();"  />
             </td>
         </tr>
         

          <tr>
             <td style="padding: 15px;">                  
                 <asp:Localize meta:resourcekey="str_hideteamfolder" runat="server">Don't show team folder that the user doesn't have read/list permission to the underlying folder</asp:Localize>                  
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox ID="HideDeniedTeamFolder" runat="server" onclick="ShowSavePanel();"  />
             </td>
         </tr>
         
         <tr>
             <td style="padding: 15px;">
                 <asp:Localize meta:resourcekey="str_hidetrashcan" runat="server">Don't show Trash Can for non-admin user</asp:Localize>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox ID="HideTrashCan" runat="server" onclick="ShowSavePanel();"  />
             </td>
         </tr>
         <tr>
             <td style="padding: 15px;">
                 <asp:Localize meta:resourcekey="str_nopermsyncdown" runat="server">Don't sync back the folder permissions</asp:Localize>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox checked ID="NoPermSyncDown" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>
         <tr>
             <td style="padding: 15px;">
                 <asp:Label ID="Label4" runat="server" Text="Do not append '(Team Folder)' to published folder."
                                meta:resourcekey="RemoveTeamFolderSuffixResource1"></asp:Label>
                <p class="text-muted" style="font-size: smaller">
                                <asp:Localize ID="Localize13" meta:resourcekey="asp_string6" runat="server" Text="When this setting is NOT set, system will automatically append '(Team Folder)' for
                            team user."></asp:Localize></p>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox ID="RemoveTeamFolderSuffix" runat="server" onclick="ShowSavePanel();"  />
             </td>
         </tr>

         <tr>
             <td style="padding: 15px;">
                 <asp:Label ID="LblSelTmFldChkBx" runat="server" Text="Select Team Folders by default on the user-creation wizard" meta:resourcekey="strSelTmFldChkBx"></asp:Label>
                <p class="text-muted" style="font-size: smaller">
                   <asp:Localize ID="LocSelTmFldChkBxHlp" meta:resourcekey="asp_string7" runat="server" Text="When enabled, the Team Folders' checkboxes will be pre-selected for assignment when creating new native users from the Tenant Dashboard."></asp:Localize></p>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox ID="SelectTeamFoldersInUserCreation" runat="server" onclick="ShowSavePanel();"  />
             </td>
         </tr>

            <%} %>
        </table>
    </div>
    <div style="display: none;">
        <asp:Panel ID="Attach" runat="server" meta:resourcekey="AttachResource1">
        </asp:Panel>
        <p style="padding-top: 8px;">
                                            <asp:CheckBox onclick="ShowSavePanel();" ID="NoUserHomeDirectory" runat="server" Text="Disable user's home directory"
                                                meta:resourcekey="NoUserHomeDirectory" /><br />
                                            <p style="font-size: 12px; color: #808080; margin-left: 16px;">
                                                <asp:Localize ID="Localize4" meta:resourcekey="NoUserHomeDirectoryDesc" runat="server"
                                                    Text="When this option is enabled, user can only access team folder assigned to him."></asp:Localize></p>
    </div>
 <% if (!string.IsNullOrEmpty(ErrorMsg.Text)){ %>
        <script type="text/javascript">
            Ext.onReady(function () {
                            gWMsgBox("<%=ErrorMsg.Text%>");
            ShowSavePanel();

            });
        </script>
    <% } %>
</asp:Content>
