﻿<%@ Page Title="Gladinet Cloud - Publish Folder" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="GroupPolicySecShare.aspx.cs" Inherits="GladinetPayFlow.GroupPolicySecShare"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    

    <style type="text/css">
         td {
             font-size: 15px;
            
             font-weight: 100;
         }
        
        b {
            font-weight: 500;
        }
        
        .badgefont {
            font-size: 15px;
            
        }
    </style>
    <script type="text/javascript">


        function OnSaveChanges() {
            Wait("Please wait...");
            var btn = document.getElementById('ctl00_MainContent_ApplyBtn');
            btn.click();

        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
     <nav class="navbar navbar-default navbar-fixed-top" role="navigation" style="display: none;">
        <div class="navbar-left">
            <asp:Label ID="ErrorMsg" runat="server" ForeColor="Red" meta:resourcekey="ErrorMsgResource1"></asp:Label>
        </div>
            <div class="container-fluid" style="padding-right: 30px;">
                 <% if (m_CanEdit){ %>
                    <asp:Localize runat="server" ID="LocApyChng" meta:resourcekey="str_apyChg" Visible="False">Apply Change</asp:Localize>
                    <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize>
                        <asp:Button ID="EditBtn" runat="server" 
                            CausesValidation="False" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" 
                            Text="Edit" onclick="EditBtn_Click" 
                     meta:resourcekey="EditBtnResource1" ></asp:Button>     
                        <asp:Button ID="CancelBtn" runat="server" Visible="False"
                            CausesValidation="False" 
                            CssClass="btn  navbar-btn navbar-right btndlg" 
                            Text="Cancel" onclick="CancelBtn_Click" Width="108px" 
                     meta:resourcekey="CancelBtnResource1"></asp:Button>    
                            &nbsp;&nbsp;&nbsp;&nbsp; 
                        <asp:Button ID="ApplyBtn" runat="server" Visible="False"
                            CausesValidation="False" OnClick="ApplylNow_Click" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" meta:resourcekey="ApplylNowResource1" 
                            Text="Apply" Width="108px"></asp:Button>       
                            &nbsp;&nbsp;&nbsp;&nbsp;                                                 
                    <%
                    EditBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChng.Text);
                    CancelBtn.OnClientClick = String.Format("Wait('{0}')", LocPlsWat.Text);
                    ApplyBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChng.Text);
                    }%>
            </div>
            </nav>
    
   <div class="wrapper" style="background-color: white; width:100%;margin-top: 10px;font-size: 16px;">
     <table width="100%" class="table-striped" style="margin-bottom: 100px;">
            <tr>
                <td width="500px" style="padding: 15px;">
                    <asp:Label ID="Label2" runat="server" Text="Users must log in to access the content in 'Files shared with me' folder"
                            meta:resourcekey="ShareMustLoginResource1" ></asp:Label>
                            <p class="text-muted" style="font-size: smaller">
                            <asp:Localize ID="Localize8" meta:resourcekey="asp_string5" runat="server" Text="Enable the setting to force the users to login to access the content in 'Files shared with me' folder."></asp:Localize></p>     
                </td>
                <td style="padding: 15px;">
                     <asp:CheckBox ID="ShareMustLogin" runat="server" onclick="ShowSavePanel();" />
                </td>
            </tr>
            
            <tr>
                <td style="padding: 15px;">
                    <asp:Label ID="Label5" runat="server"  Text="Disable team-user share home directory content externally"
                        meta:resourcekey="DisableHomeDirShareResource1"></asp:Label>
                        <p class="text-muted" style="font-size: smaller">
                        <asp:Localize ID="Localize10" meta:resourcekey="asp_string4" runat="server" Text="When this setting is disabled, you can enable/disable the sharing on per-user basis."></asp:Localize></p>
                </td>
                <td style="padding: 15px;">
                    <asp:CheckBox ID="DisableHomeDirShare" runat="server" onclick="ShowSavePanel();" />
                </td>
            </tr>
         <% if (!IsHostedFarm)
            { %>
            <tr>
                <td style="padding: 15px;">
                    <asp:Label ID="Label6" runat="server" Text="Enable internal public share URL"
                        meta:resourcekey="InternalPublicLinkResource1"></asp:Label> 
                </td>
                <td style="padding: 15px;">
                    <asp:CheckBox ID="InternalPublicLink" runat="server" onclick="ShowSavePanel();"  />
                </td>
            </tr>
            <% } %>
            <tr>
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="str_disablepub" runat="server">Disable Public Link</asp:Localize>
                </td>
                <td style="padding: 15px;">
                    <asp:CheckBox ID="DisablePublicLink" runat="server" onclick="ShowSavePanel();"  />
                </td>
            </tr>
                     <tr>
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="str_showguest" runat="server">Show guest user creation option</asp:Localize> 
                </td>
                <td style="padding: 15px;">
                    <asp:CheckBox ID="ShowGuestOption" runat="server" onclick="ShowSavePanel();"  />
                </td>
            </tr>

            <tr style="display:none;">
                <td style="padding: 15px;">
                    <asp:Label ID="Label7" runat="server" Text="Enable distribution group detection in the file/folder sharing's user interface"
                        meta:resourcekey="EnablePDLResource1" ></asp:Label>
                </td>
                <td style="padding: 15px;">
                    <asp:CheckBox ID="EnablePDL" runat="server" onclick="ShowSavePanel();" />
                </td>
            </tr>
            <tr>
                <td style="padding: 15px;">
                    <asp:Label ID="Label8" runat="server" Text="Show user list in sharing dialog"
                            meta:resourcekey="ShowUserInShare" ></asp:Label>
                            <p class="text-muted" style="font-size: smaller">
                        <asp:Localize ID="Localize5_1" meta:resourcekey="ShowUserInShareDesc" runat="server"
                            Text="When this option is enabled, the user list will be shown in the recipient dropdown list."></asp:Localize></p>
                </td>
                <td style="padding: 15px;">
                    <asp:CheckBox ID="ShowUserInShare" runat="server" onclick="ShowSavePanel();" />
                </td>
            </tr>
            <tr>
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="str_sguest" runat="server">Show guest user list in sharing dialog</asp:Localize>
                            
                            <p class="text-muted" style="font-size: smaller">
                        
                                <asp:Localize meta:resourcekey="str_sguesthint" runat="server"> When this option is enabled, the guest user list will be shown in the recipient drop-down list.</asp:Localize>
                            </p>
                </td>
                <td style="padding: 15px;">
                    <asp:CheckBox ID="ShowGuestUserInShare" runat="server" onclick="ShowSavePanel();" />
                </td>
            </tr>
            
            
            <tr>
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="str_showgroupl" runat="server">Show group list in sharing dialog</asp:Localize>
                            <p class="text-muted" style="font-size: smaller">
                                <asp:Localize meta:resourcekey="str_showgroup" runat="server">When this option is enabled, the group list will be shown in the recipient drop-down list.</asp:Localize></p>
                </td>
                <td style="padding: 15px;">
                    <asp:CheckBox ID="ShowGroupInShare" runat="server" onclick="ShowSavePanel();" />
                </td>
            </tr>
             <tr>
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="str_allowsname" runat="server">Allow user to enter share name</asp:Localize>
                            
                </td>
                <td style="padding: 15px;">
                    <asp:CheckBox ID="AllowShareName" runat="server" onclick="ShowSavePanel();" />
                </td>
            </tr>
         <tr>
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="str_ccsender" runat="server">Send a copy of file sharing invitation email to share owner</asp:Localize>
                            
                </td>
                <td style="padding: 15px;">
                    <asp:CheckBox ID="CCShareSender" runat="server" onclick="ShowSavePanel();" />
                </td>
            </tr>
               <tr>
                <td style="padding: 15px;">
                    
                    <asp:Localize meta:resourcekey="str_dntApdEml" runat="server">Don't append email to shared object name under 'Files Shared With Me'</asp:Localize>      
                </td>
                <td style="padding: 15px;">
                    <asp:CheckBox ID="ShortShareName" runat="server" onclick="ShowSavePanel();" />
                </td>
            </tr>

         <tr>
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="str_disablefoldersh" runat="server">Disable folder sharing</asp:Localize>
                            
                </td>
                <td style="padding: 15px;">
                    <asp:CheckBox ID="DisableFolderShare" runat="server" onclick="ShowSavePanel();" />
                </td>
            </tr>
        
          <tr>
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="str_alwayspwd" runat="server"> Enforce password protection</asp:Localize>
                            
                </td>
                <td style="padding: 15px;">
                    <asp:CheckBox ID="AlwaysPwdProtect" runat="server" onclick="ShowSavePanel();" />
                </td>
            </tr>
        
            <tr>
                <td style="padding: 15px;">
                    <asp:Localize ID="Localize6" meta:resourcekey="str_shareex" runat="server" Text="Expiration Time for Shared Folder/File (Days):"></asp:Localize>
                    <p class="text-muted" style="font-size: smaller">
                        <asp:Localize ID="Localize7" meta:resourcekey="str_shareexphelp" runat="server" Text="If left at zero, the users will have an option to set the expiration time for a shared item, otherwise any new shared items will expire after the number of days set above since the shared item is created."></asp:Localize>
                    </p>

                </td>
                <td style="padding: 15px;">
                    <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();"  ID="ShareExpireDays" runat="server" Text="0" meta:resourcekey="ShareExpireDaysResource1"  CssClass="form-control"></asp:TextBox>
                     <asp:Label ID="LShareExpireDays" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
                </td>
            </tr>
         <tr>
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="str_maxshare" runat="server">Maximum Share Expiration Time (Days)</asp:Localize>

                </td>
                <td style="padding: 15px;">
                    <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();"  ID="MaxShareDays" runat="server" Text="0" meta:resourcekey="ShareExpireDaysResource1"  CssClass="form-control"></asp:TextBox>
                     <asp:Label ID="LMaxShareDays" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
                </td>
            </tr>
          <tr>
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="str_expnotify" runat="server">Notify share owner n days before share expiring (0 - do not notify)</asp:Localize>

                </td>
                <td style="padding: 15px;">
                    <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();"  ID="NotifyShareDays"  runat="server" Text="0" meta:resourcekey="ShareExpireDaysResource1"  CssClass="form-control"></asp:TextBox>
                     <asp:Label ID="LNotifyShareDays" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
                </td>
            </tr>
            <tr>
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="str_explink" runat="server">Expiration Time for public links (Days):</asp:Localize>
                    <p class="text-muted" style="font-size: smaller">
                        <asp:Localize meta:resourcekey="str_explinkhint" runat="server">If left at zero, the public link will never expire. Otherwise, the public link will be purged after expired.</asp:Localize>
                    </p>

                </td>
                <td style="padding: 15px;">
                    <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();"  ID="LinkExpireDays" runat="server" Text="0" meta:resourcekey="ShareExpireDaysResource1" CssClass="form-control"></asp:TextBox>
                     <asp:Label ID="LLinkExpireDays" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
                </td>
            </tr>
            <tr>
                <td style="padding: 15px;">
                    <asp:Label ID="Label3" runat="server" Text="Don't create guest user account if the recipient is from following domains (i.e. company.com;company1.com)"
                            meta:resourcekey="Label3Resource1"></asp:Label>
                </td>
                <td style="padding: 15px;">
                    <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();"  ID="NoGuestDomainList" runat="server" Width="100%" meta:resourcekey="NoGuestDomainListResource1"  CssClass="form-control"></asp:TextBox>
                    <asp:Label ID="LNoGuestDomainList" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
                </td>
            </tr>
            
          
            <tr>
                <td style="padding: 15px;">
                     <asp:Label ID="Label1" runat="server" Text="Only allow sending shares to the specified domain(s) (i.e. company.com;company1.com)"
                            meta:resourcekey="Label1Resource1"></asp:Label>
                            <p class="text-muted" style="font-size: smaller">
                            <asp:Localize ID="Localize5" meta:resourcekey="asp_string8" runat="server" Text="When this setting is NOT enabled, your team users can share files with any email addresses. When this setting is enabled, team users can only send shares to the email addresses in the specified domain(s)."></asp:Localize></p>
                </td>
                <td style="padding: 15px;">
                    <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();"  ID="ShareDomainWhiteList" runat="server" Width="100%" meta:resourcekey="ShareDomainWhiteListResource1"
                            CssClass="form-control"></asp:TextBox>
                    <asp:Label ID="LShareDomainWhiteList" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
                </td>
            </tr>
            <tr>
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="str_outlookfolder" runat="server">Default folder to store attachments from Outlook plugin (/folder/subfolder)</asp:Localize>

                     </td>
                <td style="padding: 15px;">
                    <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();"  ID="OutlookFolder" runat="server" Width="100%" meta:resourcekey="ShareDomainWhiteListResource1"
                            CssClass="form-control"></asp:TextBox>
                    <asp:Label ID="LOutlookFolder" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
                </td>
            </tr>   
            <tr>
                <td style="padding: 15px;">
                     <asp:Label runat="server" Text="Show Get Link button on the sharing screen for unprotected shares only"
                            meta:resourcekey="str_shoGetLinButOnShar"></asp:Label>
                            <p class="text-muted" style="font-size: smaller">
                            <asp:Localize meta:resourcekey="str_shoGetLinButOnSharHlp" runat="server" Text="When this setting is NOT enabled, the ability to get the share link without emailing the recipients will be always available."></asp:Localize></p>
                </td>
                <td style="padding: 15px;">
                    <asp:CheckBox onclick="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="ShowGetLinkForNoProtectSharesOnly" runat="server" checked="true"
                            ></asp:CheckBox>
                </td>
            </tr> 
            <tr>
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="str_disVidPreShaWitDowPer" runat="server">Disable video preview for shares without download permission</asp:Localize>

                     </td>
                <td style="padding: 15px;">
                    <asp:CheckBox onclick="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="DisableVideoOnShareWithoutDownload" runat="server" ></asp:CheckBox>
                </td>
            </tr>   
           
            <tr style="display: none;">
                <td>
                    <asp:Label ID="Label4" runat="server" Text="Don't show user list in create share wizard"
                            meta:resourcekey="DisableUserListResource1" ></asp:Label>
                            <p class="text-muted" style="font-size: smaller">
                            <asp:Localize ID="Localize9" meta:resourcekey="asp_string3" runat="server" Text="When this setting is enabled, the system will not populate the recipient dropdown list with the user list."></asp:Localize></p>
                </td>
                <td>
                    <asp:CheckBox ID="DisableUserList" runat="server" onclick="ShowSavePanel();" />
                </td>
            </tr>

        </table>
       
  </div>
  
    <asp:Localize ID="NOTConfig"  meta:resourcekey="str_notconfiged" runat="server" Visible="False">Not Configured</asp:Localize>
 <% if (!string.IsNullOrEmpty(ErrorMsg.Text)){ %>
        <script type="text/javascript">
            Ext.onReady(function () {
                            gWMsgBox("<%=ErrorMsg.Text%>");
            ShowSavePanel();

            });
        </script>
    <% } %>
</asp:Content>
