﻿<%@ Page Title="Gladinet Cloud - Publish Folder" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="GroupPolicySecGeneral.aspx.cs" Inherits="GladinetPayFlow.GroupPolicySecGeneral"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    

    <style type="text/css">
        td {
            font-size: 15px;
          
            font-weight: 100;
        }
        
        b {
            font-weight: 500;
        }
        
        .badgefont {
            font-size: 15px;
            
        }

    </style>
    <script type="text/javascript">




        function OnSaveChanges() {
            Wait("Please wait...");
            var btn = document.getElementById('ctl00_MainContent_ApplyBtn');
            btn.click();

        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <nav class="navbar navbar-default navbar-fixed-top" role="navigation" style="display: none;">
        <div class="navbar-left">
            <asp:Label ID="ErrorMsg" runat="server" ForeColor="Red" meta:resourcekey="ErrorMsgResource1"></asp:Label>
        </div>
            <div class="container-fluid" style="padding-right: 30px;">
                <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize> 
                <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize> 
                
                <% if (m_CanEdit){ %>
                        <asp:Button ID="EditBtn" runat="server" 
                            CausesValidation="False" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" 
                            Text="Edit" onclick="EditBtn_Click" 
                     meta:resourcekey="EditBtnResource1" ></asp:Button>  
                        <asp:Button ID="CancelBtn" runat="server" Visible="False"
                            CausesValidation="False" 
                            CssClass="btn  navbar-btn navbar-right btndlg" 
                            Text="Cancel" onclick="CancelBtn_Click" Width="108px" 
                     meta:resourcekey="CancelBtnResource1"></asp:Button>    
                            &nbsp;&nbsp;&nbsp;&nbsp; 
                        <asp:Button ID="ApplyBtn" runat="server" Visible="False"
                            CausesValidation="False" OnClick="ApplylNow_Click" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" meta:resourcekey="ApplylNowResource1" 
                            Text="Apply" Width="108px"></asp:Button>       
                            &nbsp;&nbsp;&nbsp;&nbsp;                                                 
                <%
                    EditBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                    CancelBtn.OnClientClick = String.Format("Wait('{0}')", LocPlsWat.Text);
                    ApplyBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);

                   } %>
            </div>
            </nav>
   
    <div class="wrapper" style="background-color: white; width:100%;margin-top: 10px;font-size: 16px;">
     <table width="100%" class="table-striped" style="margin-bottom: 100px;">
         <% if (string.Compare(SessionDomainId, "2CD45C43-114F-406C-998C-C6B477148FC3", true) != 0 && !IsServo)
            { %>
         <tr>
             <td width="500px" style="padding: 15px;">
                 <asp:Label ID="Label1" runat="server" Text="Allow Cluster Admin to manage my tenant"
                        meta:resourcekey="ClusterImpersonation"></asp:Label>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox ID="ClusterImpersonation" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>
         <% } %>
         <tr style="display:none;">
             <td width="500px" style="padding: 15px;">
                 <asp:Localize meta:resourcekey="str_disablera" runat="server">Disable remote assistance</asp:Localize>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox ID="DisableRA"  runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>
         <tr>
             <td width="500px" style="padding: 15px;">
                 <asp:Localize meta:resourcekey="str_changeemail" runat="server">Notify user when email is changed</asp:Localize>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox Checked="true" ID="NotifyEmailChange" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>
         <tr>
             <td width="500px" style="padding: 15px;">
                 <asp:Localize meta:resourcekey="str_changenetwork" runat="server">Force client re-authenticate when network changed</asp:Localize>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox  ID="ForceAuthOnNetworkChange" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>
         
         <%if (SessionIsInstalledApp && SessionIsClusterAdmin){ %>
         <tr style="display:none;">
             <td style="padding: 15px;">
                 <asp:Label ID="Label3" runat="server" Text="Accessing management related pages from Intranet Only"
                                        meta:resourcekey="Only_LOCAL_MMC"></asp:Label>
                                        <p class="text-muted" style="font-size: smaller">
                                        <asp:Localize ID="Localize4" meta:resourcekey="Only_LOCAL_MMC_DESC" runat="server" Text="When the setting is set, the management related pages can only be accessed from a set of defined intranet addresses."></asp:Localize></p>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox ID="OnlyLocalMMC" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>
                   <tr style="display:none;">
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="Only_IP_MMC_DESC" runat="server">Only allow the access of the management related pages from following IPs </asp:Localize>
                    <p class="text-muted" style="font-size: smaller">
                        <asp:Localize meta:resourcekey="Only_IP_MMC_DESCex" runat="server">(IP/Mask;IP/Mask, i.e. 254.234.234.128/255.255.255.0; 192.234.234.128/255.255.255.0 empty: no restriction) </asp:Localize>
                    </p>
                </td>
                <td style="padding: 15px;">
                    <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();"  ID="OnlyMMCIps"  runat="server"  meta:resourcekey="ShareExpireDaysResource1"  CssClass="form-control"></asp:TextBox>
                     <asp:Label ID="LOnlyMMCIps" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
                        <asp:Localize ID="NOTConfig"  meta:resourcekey="str_notconfiged" runat="server" Visible="False">Not Configured</asp:Localize>
                </td>
            </tr>
         <%if (!IsServo){ %>
         <tr>
             <td style="padding: 15px;">
                 <asp:Label ID="Label2" runat="server" Text="Enable authenticating user with Google Apps credential"
                                    meta:resourcekey="AllowGoogleAppLoginResource1" ></asp:Label>
                                    <p class="text-muted" style="font-size: smaller">
                                    <asp:Localize ID="Localize1" meta:resourcekey="asp_string7" runat="server" Text="When this setting is set, user can login to the system with Google Apps credential."></asp:Localize></p>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox ID="AllowGoogleAppLogin" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>
        
          <tr>
             <td width="500px" style="padding: 15px;">
                 <asp:Localize meta:resourcekey="str_impersonate" runat="server">When delegate admin login via server agent, impersonate as tenant admin</asp:Localize>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox ID="ImpersonateAdmin" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>
         
         <%} %>
         <tr>
             <td style="padding: 15px;">
                 <asp:Label ID="Label4" runat="server" Text="File upload and download must go through worker node"
                                            meta:resourcekey="WebOnly"></asp:Label>
                                            <p class="text-muted" style="font-size: smaller">
                                            <asp:Localize ID="Localize3" meta:resourcekey="WebOnlyDESC" runat="server" Text="When this option is enabled, uploading files and downloading files will always go through worker node."></asp:Localize></p>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox ID="WebOnly" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>
         <%} %>
        
        </table>
    </div>
    <div style="display: none;">
        <asp:CheckBox onclick="ShowSavePanel();" ID="ShowSecurityOption" runat="server" Text="Show 'Security' Option."
                                    meta:resourcekey="ShowSecurityOption" /><br />
                                <p style="font-size: 12px; color: #808080; margin-left: 16px;">
                                    <asp:Localize ID="Localize2" meta:resourcekey="asp_string6_1" runat="server" Text="When this setting is set, you will be able to grant normal user permission to manage certain part of the tenant"></asp:Localize></p>
    </div>
     <% if (!string.IsNullOrEmpty(ErrorMsg.Text)){ %>
        <script type="text/javascript">
            Ext.onReady(function () {
                            gWMsgBox("<%=ErrorMsg.Text%>");
            ShowSavePanel();

            });
        </script>
    <% } %>
</asp:Content>
