﻿<%@ Page Title="Gladinet Cloud - Publish Folder" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="GroupPolicyRe.aspx.cs" Inherits="GladinetPayFlow.GroupPolicyRe" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        td {
            font-size: 15px;
            
            font-weight: 100;
        }
        
        b {
            font-weight: 500;
        }
        
        .badgefont {
            font-size: 15px;
            
        }

    </style>
    <script type="text/javascript">

        function OnSaveChanges() {
            Wait("Please wait...");
            var btn = document.getElementById('ctl00_MainContent_ApplyBtn');
            btn.click();

        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocDayToPurMusBeANum" meta:resourcekey="str_dayToPurMusBeANum" Visible="false">Days to purge must be a number</asp:Localize>
    
<nav class="navbar navbar-default navbar-fixed-top" role="navigation" style="display: none;">
        <div class="navbar-left">
            <asp:Label ID="ErrorMsg" runat="server" ForeColor="Red" meta:resourcekey="ErrorMsgResource1"></asp:Label>
        </div>
            <div class="container-fluid" style="padding-right: 30px;">
                 <% if (m_CanEdit){ %>
                    <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize> 
                    <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize> 
                        <asp:Button ID="EditBtn" runat="server" 
                            CausesValidation="False" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" 
                            Text="Edit" onclick="EditBtn_Click" 
                                    meta:resourcekey="EditBtnResource1" ></asp:Button>   
                        <asp:Button ID="CancelBtn" runat="server" Visible="False"
                            CausesValidation="False" 
                            CssClass="btn navbar-btn navbar-right btndlg" 
                            Text="Cancel" onclick="CancelBtn_Click" Width="108" 
                                    meta:resourcekey="CancelBtnResource1"></asp:Button> 
                            &nbsp;&nbsp;&nbsp;&nbsp; 
                        <asp:Button ID="ApplyBtn" runat="server" Visible="false"
                            CausesValidation="False" OnClick="ApplylNow_Click" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" meta:resourcekey="ApplylNowResource1" 
                            Text="Apply" Width="108"></asp:Button>       
                            &nbsp;&nbsp;&nbsp;&nbsp;      
                    <%
                        EditBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                        CancelBtn.OnClientClick = String.Format("Wait('{0}')", LocPlsWat.Text);
                        ApplyBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                    } %>
            </div>
            </nav>
    <div class="wrapper" style="background-color: white; width:100%;margin-top: 10px;font-size: 16px;">
     <table width="100%" class="table-striped" style="margin-bottom: 100px;">
         <tr>
             <td width="500px" style="padding: 15px;">
                 <asp:Localize ID="Localize1" meta:resourcekey="asp_string1" runat="server" 
                    Text="Keep last n version(s) of files in versioned folder."></asp:Localize>
                    <p class="text-muted">
                        <asp:Localize ID="Localize2" meta:resourcekey="asp_string2" runat="server" 
                        Text="0 - let system decide, also apply to 'attached local folder'"></asp:Localize>
                    </p>
             </td>
             <td style="padding: 15px;">
                  <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="VersionCount" Text="0" runat="server" 
                    meta:resourcekey="VersionCountResource1" CssClass="form-control"></asp:TextBox>
                    <asp:Label ID="LVersionCount" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
             </td>
         </tr>
         
         <tr>
             <td style="padding: 15px;">
                 <asp:Localize ID="Localize3" meta:resourcekey="str_pdays" runat="server" 
                    Text="Only purge versioned files that are more than n day(s) old:"></asp:Localize>
                    <p class="text-muted">
                     <asp:Localize ID="Localize4" meta:resourcekey="str_purgedays" runat="server" 
                         Text="0 - Purge old versions once they exceed the version limit, regardless of the version lifespan"></asp:Localize>
                </p>
             </td>
             <td style="padding: 15px;">
                 <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" 
                    ID="PurgeVerDays"  Text="0" runat="server"  CssClass="form-control"
                    meta:resourcekey="PurgeVerDaysResource1"></asp:TextBox>
                                        <asp:Label ID="LPurgeVerDays" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>

             </td>
         </tr>
         <tr>
             <td style="padding: 15px;">
                 <asp:Localize ID="Localize11" meta:resourcekey="str_ppdays" runat="server" 
                    Text="Purge previous versions that are more than n day(s) old:"></asp:Localize>
                    <p class="text-muted">
                     <asp:Localize ID="Localize12" meta:resourcekey="str_purgepdays" runat="server" 
                         Text="Purge old versions that meets the criteria, regardless if it exceeds version limit. 0 - do not purge based on file time"></asp:Localize>
                </p>
             </td>
             <td style="padding: 15px;">
                 <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" 
                    ID="PurgePreDays"  Text="0" runat="server"  CssClass="form-control"
                    meta:resourcekey="PurgeVerDaysResource1"></asp:TextBox>
                                        <asp:Label ID="LPurgePreDays" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>

             </td>
         </tr>
         <tr>
             <td style="padding: 15px;">
                 <asp:Localize ID="Localize5" meta:resourcekey="asp_string3" runat="server" 
                    Text="Keep deleted files in versioned folder and/or Trash Can for n day(s)."></asp:Localize>
                    <p class="text-muted">
                    <asp:Localize ID="Localize6" meta:resourcekey="asp_string4" runat="server" 
                        Text="0 - let system decides"></asp:Localize>
                </p>
             </td>
             <td style="padding: 15px;">
                 <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="TrashDays" Text="90" runat="server" 
                    meta:resourcekey="TrashDaysResource1" CssClass="form-control"></asp:TextBox>
                    <asp:Label ID="LTrashDays" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
             </td>
         </tr>
         
         <tr>
             <td style="padding: 15px;">
                 <asp:Localize ID="Localize7" meta:resourcekey="str_cstr1" runat="server" 
                    Text="Keep file change log for n day(s)."></asp:Localize>
                    <p class="text-muted">
                    <asp:Localize ID="Localize8" meta:resourcekey="str_cstr2" runat="server" 
                        Text="0 - don't purge file change log"></asp:Localize>
                </p>
             </td>
             <td style="padding: 15px;">
                 <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="FileChangeLogDays" Text="15" runat="server" CssClass="form-control"
                    meta:resourcekey="FileChangeLogDaysResource1" ></asp:TextBox>
                    <asp:Label ID="LFileChangeLogDays" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
             </td>
         </tr>
         <tr>
             <td style="padding: 15px;">
                 <asp:Localize ID="Localize9" meta:resourcekey="str_adstr1" runat="server" 
                    Text="Keep audit trace for n day(s)."></asp:Localize>
                    <p class="text-muted">
                    <asp:Localize ID="Localize10" meta:resourcekey="str_adstr2" runat="server" 
                        Text="0 - don't purge audit trace"></asp:Localize>
                </p>
             </td>
             <td style="padding: 15px;">
                 <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="AuditTraceDays" Text="0" runat="server" CssClass="form-control"
                    ></asp:TextBox>
                    <asp:Label ID="LAuditTraceDays" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
             </td>
         </tr>   
         <tr>
             <td style="padding: 15px;">
                 <asp:Localize ID="LocKeeMacCliLogNDay" meta:resourcekey="str_keeMacCliLogNDay" runat="server" 
                    Text="Keep Mac client logs for n day(s)."></asp:Localize>
                    <p class="text-muted">
                    <asp:Localize ID="LocDonPurMacCliLog" meta:resourcekey="str_donPurMacCliLog" runat="server" 
                        Text="0 - don't purge Mac Client logs"></asp:Localize>
                </p>
             </td>
             <td style="padding: 15px;">
                 <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="MacClientLogDays" Text="0" runat="server" CssClass="form-control"
                    ></asp:TextBox>
                    <asp:Label ID="LMacClientLogDays" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
             </td>
         </tr>
         <tr>
             <td style="padding: 15px;">
                 <% if (IsServo) { %>
                    <asp:Label ID="LblNoWebPurgeResource2" runat="server" Text="Hide purge option from web file browser (not applicable to cluster administrator)" 
                    meta:resourcekey="NoWebPurgeResource2"></asp:Label>
                 <% } else { %>
                    <asp:Label ID="Label1" runat="server" Text="Hide purge option from web file browser (not applicable to tenant administrator)" 
                    meta:resourcekey="NoWebPurgeResource1"></asp:Label>
                 <% } %>
             </td>
             <td style="padding: 15px;">
                <asp:CheckBox checked="true" ID="NoWebPurge" runat="server" onclick="ShowSavePanel();" /> 
             </td>
         </tr>
         
         <tr>
             <td style="padding: 15px;">
                 <asp:Label ID="Label2" runat="server" Text="Don't send email notifications when purging deleted content"                                
                    meta:resourcekey="NoPurgeTrashNotificationResource1" ></asp:Label>
             </td>
             <td style="padding: 15px;">
              <asp:CheckBox ID="NoPurgeTrashNotification" runat="server" onclick="ShowSavePanel();"  />   
             </td>
         </tr>
         <%if (SessionIsClusterAdmin || SessionIsDelegateClusterAdmin)
                          { %>
                  <tr>
             <td style="padding: 15px;">
                 <asp:Localize meta:resourcekey="str_countdeleted" runat="server">Include deleted but not yet purged items in storage quota</asp:Localize>
             </td>
             <td style="padding: 15px;">
              <asp:CheckBox ID="CountDeleted" runat="server" onclick="ShowSavePanel();"  />   
             </td>
         </tr>
         <%} %>
    </table>
    </div>
 
    <asp:Localize ID="NOTConfig" meta:resourcekey="str_notconfiged" Visible="False" runat="server">Not Configured</asp:Localize>
 <% if (!string.IsNullOrEmpty(ErrorMsg.Text)){ %>
        <script type="text/javascript">
            Ext.onReady(function () {
                            gWMsgBox("<%=ErrorMsg.Text%>");
            ShowSavePanel();

            });
        </script>
    <% } %>
</asp:Content>
