﻿<%@ Page Title="Gladinet Cloud - Publish Folder" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="GroupPolicyPwd.aspx.cs" Inherits="GladinetPayFlow.GroupPolicyPwd" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    

    <style type="text/css">
        td {
            font-size: 15px;
            
            font-weight: 100;
        }
        
        b {
            font-weight: 500;
        }
        
        .badgefont {
            font-size: 15px;
            
        }

    </style>
    <script type="text/javascript">




        function OnSaveChanges() {
            Wait("Please wait...");
            var btn = document.getElementById('ctl00_MainContent_ApplyBtn');
            btn.click();

        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <nav class="navbar navbar-default navbar-fixed-top" role="navigation" style="display: none;">
        <div class="navbar-left">
            <asp:Label ID="ErrorMsg" runat="server" ForeColor="Red" meta:resourcekey="ErrorMsgResource1"></asp:Label>
        </div>
            <div class="container-fluid" style="padding-right: 30px;">
                 <% if (m_CanEdit){ %>
                    <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize> 
                    <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize> 
                        <asp:Button ID="EditBtn" runat="server" 
                            CausesValidation="False" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" 
                            Text="Edit" onclick="EditBtn_Click" 
                     meta:resourcekey="EditBtnResource1" ></asp:Button>   
                        <asp:Button ID="CancelBtn" runat="server" Visible="False"
                            CausesValidation="False" 
                            CssClass="btn  navbar-btn navbar-right btndlg" 
                            Text="Cancel" onclick="CancelBtn_Click" Width="108px" 
                     meta:resourcekey="CancelBtnResource1"></asp:Button>    
                            &nbsp;&nbsp;&nbsp;&nbsp; 
                        <asp:Button ID="ApplyBtn" runat="server" Visible="False"
                            CausesValidation="False" OnClick="ApplylNow_Click" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" meta:resourcekey="ApplylNowResource1" 
                            Text="Apply" Width="108px"></asp:Button>       
                            &nbsp;&nbsp;&nbsp;&nbsp;           
                    <%
                        EditBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                        CancelBtn.OnClientClick = String.Format("Wait('{0}')", LocPlsWat.Text);
                        ApplyBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                   } %>
            </div>
            </nav>
   
   <div class="wrapper" style="background-color: white; width:100%;margin-top: 60px;font-size: 16px;">
     <table width="100%" class="table-striped" style="margin-bottom: 100px;">
           
                    
                    <tr>
                        <td width="500px" style="padding: 15px;">
                            <asp:Label ID="Label1" runat="server" Text="Enforce password policy for non-AD users" meta:resourcekey="EnforcePasswordPolicyResource1" ></asp:Label> 
                        </td>
                        <td style="padding: 15px;">
                            <asp:CheckBox ID="EnforcePasswordPolicy" runat="server" onclick="ShowSavePanel();" />
                        </td>
                    </tr>
                  
                    <tr>
                        <td style="padding: 35px;">
                           <asp:Localize ID="Localize1" meta:resourcekey="asp_string2" runat="server" 
                                        Text="Minimum password length:"></asp:Localize> 
                        </td>
                        <td style="padding: 15px;">
                            <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="PasswordLength" runat="server" Text="8" CssClass="form-control"
                                    meta:resourcekey="PasswordLengthResource1"></asp:TextBox>
                                    <asp:Label ID="LPasswordLength" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
                        </td>
                    </tr>
                       <tr>
                        <td style="padding: 35px;">
                            <asp:Localize meta:resourcekey="str_evenynd" runat="server">Users must change password every n days (0 - never)</asp:Localize>
                        </td>
                        <td style="padding: 15px;">
                            <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="PwdChangeDays" runat="server" Text="0" CssClass="form-control"
                                    ></asp:TextBox>
                                    <asp:Label ID="LPwdChangeDays" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
                        </td>
                    </tr>                      
                    <tr>
                        <td style="padding: 35px;">
                            <asp:Label ID="Label2" runat="server" Text="Must contain upper case characters" 
                                    meta:resourcekey="MustHaveUpperCaseResource1"></asp:Label>
                        </td>
                        <td style="padding: 15px;">
                                <asp:CheckBox Checked=True ID="MustHaveUpperCase" runat="server" onclick="ShowSavePanel();" />
                            
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 35px;">
                            <asp:Label ID="Label3" runat="server" Text="Must contain lower case characters" 
                                    meta:resourcekey="MustHaveLowerCaseResource1"></asp:Label>
                        </td>
                        <td style="padding: 15px;">
                                <asp:CheckBox Checked=True ID="MustHaveLowerCase"  runat="server" onclick="ShowSavePanel();" />                            
                        </td>
                    </tr>
                    
                    <tr>
                        <td style="padding: 35px;">
                            <asp:Label ID="Label4" runat="server" Text="Must contain base10 digits (0-9)" 
                                    meta:resourcekey="MustHaveNumerResource1"></asp:Label> 
                        </td>
                        <td style="padding: 15px;">
                                <asp:CheckBox  Checked=True ID="MustHaveNumer"  runat="server" onclick="ShowSavePanel();" />
                            
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 35px;">
                            <asp:Label ID="Label5" runat="server" Text="Must contain non-alphanumeric characters: ~!@#$%^&*_-+=`|\\(){}[]:;'<>,.?/ " 
                                    meta:resourcekey="MustHaveNonalphanumericResource1"></asp:Label>
                        </td>
                        <td style="padding: 15px;">
                            <asp:CheckBox  Checked=True ID="MustHaveNonalphanumeric"  runat="server" onclick="ShowSavePanel();" />
                        </td>
                    </tr>
                    
           
        </table>
    </div>
        <asp:Panel ID="PwdPolicyPanel" runat="server" Visible=False 
                            meta:resourcekey="PwdPolicyPanelResource1">   
                            
        </asp:Panel>
    <asp:Localize ID="NOTConfig" meta:resourcekey="str_notconfiged" runat="server" Visible="False">Not Configured</asp:Localize>
     <% if (!string.IsNullOrEmpty(ErrorMsg.Text)){ %>
        <script type="text/javascript">
            Ext.onReady(function () {
                            gWMsgBox("<%=ErrorMsg.Text%>");
            ShowSavePanel();

            });
        </script>
    <% } %>
</asp:Content>
