﻿<%@ Page Title="Gladinet Cloud - Publish Folder" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="GroupPolicyHome.aspx.cs" Inherits="GladinetPayFlow.GroupPolicyHome"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        
        td {
            font-size: 15px;
            
            font-weight: 100;
        }
        
        b {
            font-weight: 500;
        }
         .titlecol
         {
             background-color: #f0f0f0;
             font-size: 14px;
         }
        .policygroup
        {
            -moz-border-radius: 5px 5px;
            -webkit-border-radius: 5px 5px;
            -o-border-radius: 5px 5px;
            -ms-border-radius: 5px 5px;
            -khtml-border-radius: 5px 5px;
            border-radius: 5px 5px;
            border: 1px solid #d0d0d0;
            padding-left: 2px;
            background-color: #f0f0f0;
            color: #008000;
            box-shadow: 0pt 0pt 4px 0pt rgb(136, 136, 136);
            padding-bottom: 5px;
        }
        
         .badgefont {
            font-size: 15px;
            
        }
    </style>
    <script type="text/javascript">


        function OnSaveChanges() {
            Wait("Please wait...");
            var btn = document.getElementById('ctl00_MainContent_ApplyBtn');
            btn.click();

        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    
    <nav class="navbar navbar-default navbar-fixed-top" role="navigation" style="display: none;">
        <div class="navbar-left">
            <asp:Label ID="ErrorMsg" runat="server" ForeColor="Red" meta:resourcekey="ErrorMsgResource1"></asp:Label>
        </div>
            <div class="container-fluid" style="padding-right: 30px;">
                 <% if (m_CanEdit){ %>
                    <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize> 
                    <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize> 
                        <asp:Button ID="EditBtn" runat="server" 
                            CausesValidation="False" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" 
                            Text="Edit" onclick="EditBtn_Click" meta:resourcekey="asp_edt"></asp:Button> 
                        <asp:Button ID="CancelBtn" runat="server" Visible="False"
                            CausesValidation="False" 
                            CssClass="btn navbar-btn navbar-right btndlg" 
                            Text="Cancel" onclick="CancelBtn_Click" Width="108" meta:resourcekey="asp_cnl"></asp:Button>  
                            &nbsp;&nbsp;&nbsp;&nbsp; 
                        <asp:Button ID="ApplyBtn" runat="server" Visible="false"
                            CausesValidation="False" OnClick="ApplylNow_Click" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" meta:resourcekey="ApplylNowResource1" 
                            Text="Apply" Width="108"></asp:Button>       
                            &nbsp;&nbsp;&nbsp;&nbsp;        
                    <%
                        EditBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                        CancelBtn.OnClientClick = String.Format("Wait('{0}')", LocPlsWat.Text);
                        ApplyBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                    } %>
            </div>
            </nav>
    
            <div class="wrapper" style="background-color: white; width:100%;margin-top: 10px;font-size: 16px;">
    
                    <table width="100%" class="table-striped" style="margin-bottom: 100px;">
                        <tr>
                            <td width="500px" style="padding: 15px;">
                                <asp:Localize meta:resourcekey="asp_string1" runat="server" Text="Default storage quota for new user (GB, 0-unlimited):"></asp:Localize>
                            </td><td style="padding: 15px;">        
                                <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();"
                                    ID="DefaultHomeSize" Text="0" runat="server" meta:resourcekey="DefaultHomeSizeResource1"
                                    CssClass="form-control"></asp:TextBox>
                                    <asp:Label ID="LDefaultHomeSize" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
                            </td>
                        </tr>

                        <tr>
                            <td style="padding: 15px;">
                                <asp:Label ID="Label1" runat="server" Text="Create default folder (Documents, Pictures)" meta:resourcekey="CreateDefaultDirResource1"></asp:Label>
                                
                            </td>
                            <td style="padding: 15px;">
                                <asp:CheckBox Checked="True" ID="CreateDefaultDir" runat="server" onclick="ShowSavePanel();" />
                            </td>
                        </tr>
                        <%if (!IsServo){ %>

                        <tr style="display:none;">
                            <td style="padding: 15px;">
                                <asp:Label ID="Label2" runat="server" Text="Use user email to generate home directory name" meta:resourcekey="VisibleHomeDirNameResource1"></asp:Label>
                                
                            </td>
                            <td style="padding: 15px;">
                                <asp:CheckBox ID="VisibleHomeDirName"  runat="server" onclick="ShowSavePanel();" />
                            </td>
                        </tr>
                        <%} %>
                        <% if (!IsHostedFarm && !m_ClusterLevel && !IsServo){ %>
                        <tr style="display:none;">
                            <td width="500px" style="padding: 15px;">
                                <asp:Localize meta:resourcekey="str_samname" runat="server">Use user's samAccountName to generate home directory names for Active Directory users</asp:Localize>
                                
                            </td>
                            <td style="padding: 15px;">
                                <asp:CheckBox ID="SamHomeDirName"  runat="server" onclick="ShowSavePanel();" />
                            </td>
                        </tr>
                        <tr>
                                    <td style="padding: 15px;">
                                        <asp:Localize meta:resourcekey="str_pubusrhome" runat="server">Publish user's home drive</asp:Localize>
                                        <p class="text-muted" style="font-weight: 100!important; font-size: smaller;">
                                            <asp:Localize meta:resourcekey="str_pubhomehint" runat="server"> When unchecked, the user home drive space will be allocated from enterprise storage. When checked, existing user home drives will be automatically published from Active Directory. </asp:Localize>   
                                        </p>
                                    </td>
                                    <td style="padding: 15px;">
                                        <asp:CheckBox ID="LDAPHomeDrive" runat="server" Text="" onclick="ShowSavePanel();" />
                                        
                                        
                                    </td>
                                </tr>
                        <tr style="display: none;">
                            <td colspan="2"></td>
                        </tr>
                        <tr>
                                    <td style="padding: 15px; padding-left: 30px;">
                                        <asp:Localize meta:resourcekey="str_mountastopfolder" runat="server">Mount user's home drive as a top level folder.</asp:Localize>
                                    </td>
                                    <td style="padding: 15px;">
                                        <asp:CheckBox ID="RootHomeDrive" runat="server" Text="" onclick="ShowSavePanel();" />        
                                                                                                                
                                    </td>
                                </tr>
                        <tr style="display: none;">
                            <td colspan="2"></td>
                        </tr>
                        <tr>
                                    <td style="padding: 15px; padding-left: 30px;">
                                        
                                        <asp:Localize meta:resourcekey="str_homefname" runat="server">Folder Name:</asp:Localize>
                                    </td>
                                    <td style="padding: 15px;">
                                        <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="RootDriveName" runat="server"  Text="Home Drive" CssClass="form-control"></asp:TextBox>              
                                        <asp:Label ID="LRootDriveName" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>                                                        
                                    </td>
                                </tr>
                        <% } %>
                        <%if (BarclaysPanel.Visible){ %>
                  
                            <tr>
                                <td width="500px" style="padding: 15px;">
                                    <asp:Label ID="Label3" runat="server" Text="Create a new container for each user" 
                                        meta:resourcekey="StandaloneContainerResource1"></asp:Label>
                                    
                                </td>
                                <td style="padding: 15px;">
                                    <asp:CheckBox ID="StandaloneContainer" runat="server" onclick="ShowSavePanel();" />
                                </td>
                            </tr>
                            <tr>
                                <td style="padding: 15px;">
                                    <asp:Localize meta:resourcekey="str_ctrNmeTpt" runat="server">Container name template (available variables:</asp:Localize> {samaccountuser},{email},{upn}):
                                </td>
                                <td style="padding: 15px;">
                                    <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="ContainerTemplate" runat="server" Text="home_{email}"  CssClass="form-control"
                                        meta:resourcekey="ContainerTemplateResource1"></asp:TextBox>
                                        <asp:Label ID="LContainerTemplate" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
                                </td>
                            </tr>
                        
                        <%} %>
                                                <tr style="display: none;">
                            <td colspan="2" style="padding-top: 10px;">
                                <asp:CheckBox onclick="ShowSavePanel();" ID="VisibleHomeDir" runat="server" Text="Make user's home directory visible to administrator"
                                    meta:resourcekey="VisibleHomeDirResource1" />
                            </td>
                        </tr>
                        <tr style="display: none;">
                            <td colspan="2" style="padding-right: 40px;">
                                <span style="color: #808080">
                                    <asp:Localize ID="Localize1" meta:resourcekey="asp_string2" runat="server" Text="The administrator will see the users' home directory under the administrator's &quot;Users&quot; directory."></asp:Localize>
                                </span>
                                <br />
                            </td>
                        </tr>
                    </table>
        </div>
            <asp:Panel ID="BarclaysPanel" runat="server" 
                meta:resourcekey="BarclaysPanelResource1">
                
            </asp:Panel>
    
    <asp:Localize ID="NOTConfig" meta:resourcekey="str_notconfiged" runat="server" Visible="False">Not Configured</asp:Localize>    
     <% if (!string.IsNullOrEmpty(ErrorMsg.Text)){ %>
        <script type="text/javascript">
            Ext.onReady(function () {
                            gWMsgBox("<%=ErrorMsg.Text%>");
            ShowSavePanel();

            });
        </script>
    <% } %>
</asp:Content>
