﻿<%@ Page Title="Gladinet Cloud - Publish Folder" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="GroupPolicyEndpoint.aspx.cs" Inherits="GladinetPayFlow.GroupPolicyEndpoint"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        
        td {
            font-size: 15px;
            
            font-weight: 100;
        }
        
        b {
            font-weight: 500;
        }
         .titlecol
         {
             background-color: #f0f0f0;
             font-size: 14px;
         }
        .policygroup
        {
            -moz-border-radius: 5px 5px;
            -webkit-border-radius: 5px 5px;
            -o-border-radius: 5px 5px;
            -ms-border-radius: 5px 5px;
            -khtml-border-radius: 5px 5px;
            border-radius: 5px 5px;
            border: 1px solid #d0d0d0;
            padding-left: 2px;
            background-color: #f0f0f0;
            color: #008000;
            box-shadow: 0pt 0pt 4px 0pt rgb(136, 136, 136);
            padding-bottom: 5px;
        }
        
         .badgefont {
            font-size: 15px;
            
        }
    </style>
    <script type="text/javascript">


        function OnSaveChanges() {
            Wait("Please wait...");
            var btn = document.getElementById('ctl00_MainContent_ApplyBtn');
            btn.click();

        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    
    <nav class="navbar navbar-default navbar-fixed-top" role="navigation" style="display: none;">
        <div class="navbar-left">
            <asp:Label ID="ErrorMsg" runat="server" ForeColor="Red" meta:resourcekey="ErrorMsgResource1"></asp:Label>
        </div>
            <div class="container-fluid" style="padding-right: 30px;">
                 <% if (m_CanEdit){ %>
                    <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize> 
                    <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize> 
                        <asp:Button ID="EditBtn" runat="server" 
                            CausesValidation="False" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" 
                            Text="Edit" onclick="EditBtn_Click" meta:resourcekey="asp_edt"></asp:Button> 
                        <asp:Button ID="CancelBtn" runat="server" Visible="False"
                            CausesValidation="False" 
                            CssClass="btn navbar-btn navbar-right btndlg" 
                            Text="Cancel" onclick="CancelBtn_Click" Width="108" meta:resourcekey="asp_cnl"></asp:Button>  
                            &nbsp;&nbsp;&nbsp;&nbsp; 
                        <asp:Button ID="ApplyBtn" runat="server" Visible="false"
                            CausesValidation="False" OnClick="ApplylNow_Click" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" meta:resourcekey="ApplylNowResource1" 
                            Text="Apply" Width="108"></asp:Button>       
                            &nbsp;&nbsp;&nbsp;&nbsp;        
                    <%
                        EditBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                        CancelBtn.OnClientClick = String.Format("Wait('{0}')", LocPlsWat.Text);
                        ApplyBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                    } %>
            </div>
            </nav>
    
            <div class="wrapper" style="background-color: white; width:100%;margin-top: 10px;font-size: 16px;">
                <table width="100%" class="table">
               
                <tr>
                    <td style="padding: 15px;" width="500" >
                        <asp:Localize ID="str_bdoc" meta:resourcekey="str_bdoc" runat="server">Backup "My Documents" folder</asp:Localize>
                        
                    </td>
                    <td style="padding: 15px;">
                        <asp:CheckBox ID="BackupMyDoc" runat="server" onclick="ShowSavePanel();" />
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px;" width="500" >
                       
                         <asp:Localize ID="Localize21" meta:resourcekey="str_doclocation" runat="server">Backup to location (Leave empty for default location. )</asp:Localize>
                        <p style="font-size:smaller; color:#565656;">
                             <asp:Localize ID="Localize22" meta:resourcekey="str_doclocationhint" runat="server">myroot/{email} or {samAccountName} or {upn}/My Documents</asp:Localize>         
                            </p>
                    </td>
                    <td style="padding: 15px;">
                         <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="DocLocation" runat="server" CssClass="form-control" Text="" ></asp:TextBox>
                        <asp:Label ID="LDocLocation" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px; ">
                        <asp:Localize ID="str_bpic" meta:resourcekey="str_bpic" runat="server">Backup "My Pictures" folder</asp:Localize>
                        
                    </td>
                    <td style="padding: 15px;">
                        <asp:CheckBox ID="BackupMyPic" runat="server" onclick="ShowSavePanel();" />
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px;" width="500" >
                       
                         <asp:Localize ID="Localize23" meta:resourcekey="str_piclocation" runat="server">Backup to location (Leave empty for default location. )</asp:Localize>
                        <p style="font-size:smaller; color:#565656;">
                             <asp:Localize ID="Localize24" meta:resourcekey="str_piclocationhint" runat="server">myroot/{email} or {samAccountName} or {upn}/My Pictures</asp:Localize>         
                            </p>
                    </td>
                    <td style="padding: 15px;">
                         <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="PicLocation" runat="server" CssClass="form-control" Text="" ></asp:TextBox>
                        <asp:Label ID="LPicLocation" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"></asp:Label>
                    </td>
                </tr>
            </table>
                    
        </div>
            <asp:Panel ID="BarclaysPanel" runat="server" 
                meta:resourcekey="BarclaysPanelResource1">
                
            </asp:Panel>
    
    <asp:Localize ID="NOTConfig" meta:resourcekey="str_notconfiged" runat="server" Visible="False">Not Configured</asp:Localize>    
     <% if (!string.IsNullOrEmpty(ErrorMsg.Text)){ %>
        <script type="text/javascript">
            Ext.onReady(function () {
                            gWMsgBox("<%=ErrorMsg.Text%>");
            ShowSavePanel();

            });
        </script>
    <% } %>
</asp:Content>
