﻿<%@ Page Title="Gladinet Cloud - Publish Folder" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="GroupPolicyClientSettings.aspx.cs" Inherits="GladinetPayFlow.GroupPolicyClientSettings"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        td
        {
            font-size: 15px;
      
            font-weight: 100;
        }
        
        b
        {
            font-weight: 500;
        }
        
        .badgefont
        {
            font-size: 15px;
            
        }
        
         .panel-heading {
            padding-top: 10px;
            background-color: #f0f0f0;
        }
        .dark {
            color: #565656 !important;
            font-weight: 100;
        }
    </style>
    <script type="text/javascript">

  function OnSaveChanges() {
            Wait("Please wait...");
            var btn = document.getElementById('ctl00_MainContent_ApplyBtn');
            btn.click();

        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">     
    <asp:Localize ID="LocInvld" meta:resourcekey="str_invld" runat="server" Visible="false">Invalid Value</asp:Localize>
    <asp:Localize ID="LocFldSavFil" meta:resourcekey="str_fldSavFil" runat="server" Visible="false">failed to save file</asp:Localize>     
    <asp:Localize ID="LocFldAplChg" meta:resourcekey="GroupPolicyClientSettings_ApplylNow_Click_Failed_to_apply_changes" runat="server" Visible="false">Failed to apply changes.</asp:Localize>
    <nav class="navbar navbar-default navbar-fixed-top" role="navigation" style="display: none;">
        <div class="navbar-left">
            <asp:Label ID="ErrorMsg" runat="server" ForeColor="Red" meta:resourcekey="ErrorMsgResource1"></asp:Label>
        </div>

            <div class="container-fluid" style="padding-right: 30px;">
                <% if (string.Compare(SessionDomainId, SettingsId.Value, true) != 0)
                   { %>
                 <button type="button" class="btn btn-default navbar-btn navbar-left dark" title="<%= STRDevList %>" onclick="OnDeviceList()" style="display: none;"> 
                <span class="glyphicon glyphicon-menu-left"></span> <asp:Localize meta:resourcekey="str_ret" ID="STRDevList" runat="server">Return</asp:Localize>
             </button>
             <% } %>
             
                 <% if (m_CanEdit)
                    { %>
                    <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize> 
                    <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize> 
                        <asp:Button ID="EditBtn" runat="server" 
                            CausesValidation="False" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" 
                            Text="Edit" onclick="EditBtn_Click" 
                     meta:resourcekey="EditBtnResource1" ></asp:Button> 
                        <asp:Button ID="CancelBtn" runat="server" Visible="False"
                            CausesValidation="False" 
                            CssClass="btn  navbar-btn navbar-right btndlg" 
                            Text="Cancel" onclick="CancelBtn_Click" Width="108px" 
                     meta:resourcekey="CancelBtnResource1"></asp:Button>    
                            &nbsp;&nbsp;&nbsp;&nbsp; 
                        <asp:Button ID="ApplyBtn" runat="server" Visible="False"
                            CausesValidation="False" OnClick="ApplylNow_Click" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" meta:resourcekey="ApplylNowResource1" 
                            Text="Apply" Width="108px"></asp:Button>       
                            &nbsp;&nbsp;&nbsp;&nbsp;      
                    <%
                        EditBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                        CancelBtn.OnClientClick = String.Format("Wait('{0}')", LocPlsWat.Text);
                        ApplyBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                   } %>
            </div>
            </nav>
    <div class="wrapper" style="background-color: white; width: 100%; margin-top: 10px; padding:10px;
        font-size: 16px;margin-bottom: 100px;">
                   <%if(!SessionMMCMode){ %> 
        <div>
        <p class="dark" style="font-size:16px; font-weight:100;">
            <asp:Localize ID="Localize1"  meta:resourcekey="asp_string1" runat="server" Text="The following settings apply to Windows and Server Agent Clients as well as Mac Clients. The settings configured here take precedence over the client side settings."></asp:Localize>
        </p>
            </div>
        <% } %>


        <div class="card">
            <div class="panel-heading toolnavbtn"  data-toggle="collapse" data-target="#syncst" style="cursor:pointer; font-weight:100; background-color:#f8f8f8;">
                <asp:Localize ID="Localize15" meta:resourcekey="str_synct" runat="server">Sync Throttle</asp:Localize>
            </div>
            <div id="syncst" class="collapse">
            <table width="100%" class="table" >
                <tr>
                    <td width="500" style="padding: 15px;">
                        <asp:Label ID="Label5" runat="server" Text="Enable Throttle Sync" meta:resourcekey="SyncDownThrottledResource1"></asp:Label>
                        <p class="text-muted" style="font-size: smaller">
                            <asp:Localize ID="Localize5" meta:resourcekey="asp_string2" runat="server" Text="When enabled, the following settings will apply."></asp:Localize>
                        </p>
                    </td>
                    <td style="padding: 15px;">
                        <asp:CheckBox ID="SyncDownThrottled" runat="server" onclick="ShowSavePanel();" />
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px;">
                        <asp:Localize ID="LocSncTrdUpdBdw" meta:resourcekey="asp_string3" runat="server" Text="Sync Throttled Upload Bandwidth (KB/s, 0-Unlimited):"></asp:Localize>
                    </td>
                    <td style="padding: 15px;">
                        <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="DayTimeUploadBandwidth" runat="server" CssClass="form-control" Text="0" meta:resourcekey="DayTimeUploadBandwidthResource1"></asp:TextBox>
                        <asp:Label ID="LDayTimeUploadBandwidth" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px;">
                        <asp:Localize ID="LocSncTldDndBdt" meta:resourcekey="asp_string4" runat="server" Text="Sync Throttled Download Bandwidth (KB/s, 0-Unlimited):"></asp:Localize>
                    </td>
                    <td style="padding: 15px;">
                        <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="DayTimeDownloadBandwidth" runat="server" CssClass="form-control" Text="0" meta:resourcekey="DayTimeDownloadBandwidthResource1"></asp:TextBox>
                        <asp:Label ID="LDayTimeDownloadBandwidth" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px;">
                        <asp:Localize ID="LocFulSpdSncStpHor" meta:resourcekey="asp_string5" runat="server" Text="Full Speed Sync Stop Hour (default 7)"></asp:Localize>
                    </td>
                    <td style="padding: 15px;">  
                        <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="DayTimeStartHour" runat="server" CssClass="form-control" Text="7" meta:resourcekey="DayTimeStartHourResource1"></asp:TextBox>
                        <asp:Label ID="LDayTimeStartHour" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px;">
                        <asp:Localize ID="LocFulSpdSncStrHor" meta:resourcekey="asp_string6" runat="server" Text="Full Speed Sync Start Hour (default 20)"></asp:Localize>
                    </td>
                    <td style="padding: 15px;">  
                        <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="DayTimeEndHour" runat="server" CssClass="form-control" Text="20" meta:resourcekey="DayTimeEndHourResource1"></asp:TextBox>
                        <asp:Label ID="LDayTimeEndHour" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"></asp:Label>
                    </td>
                </tr>
            </table>
                </div>
        </div>
        <div style="height:10px"></div>
         <div class="card">
            <div class="panel-heading toolnavbtn"  data-toggle="collapse" data-target="#syncsh" style="cursor:pointer; font-weight:100; background-color:#f8f8f8;">
                <asp:Localize ID="Localize25" meta:resourcekey="str_syncsh" runat="server">Scheduled Sync</asp:Localize>
            </div>
            <div id="syncsh" class="collapse">
            <table width="100%" class="table" >
                <tr>
                    <td width="500" style="padding: 15px;">
                        <asp:Label ID="Label7" runat="server" Text="Enable Scheduled Sync" meta:resourcekey="ScheduledSyncResource1"></asp:Label>
                        <p class="text-muted" style="font-size: smaller">
                            <asp:Localize ID="Localize26" meta:resourcekey="asp_string2" runat="server" Text="When enabled, the following settings will apply."></asp:Localize>
                        </p>
                    </td>
                    <td style="padding: 15px;">
                        <asp:CheckBox ID="ScheduledSync" runat="server" onclick="ShowSavePanel();" />
                    </td>
                </tr>
               
                <tr>
                    <td style="padding: 15px;">
                        <asp:Localize ID="LocPseSncStrHor" meta:resourcekey="asp_sstart" runat="server" Text="Pause Sync Start Hour (default 7):"></asp:Localize>
                    </td>
                    <td style="padding: 15px;">
                        <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="PauseSyncStartHour" runat="server" CssClass="form-control" Text="7" meta:resourcekey="DayTimeStartHourResource1"></asp:TextBox>
                        <asp:Label ID="LPauseSyncStartHour" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px;">
                        <asp:Localize ID="LocPseSncEndHor" meta:resourcekey="asp_sstop" runat="server" Text="Pause Sync End Hour (default 20)"></asp:Localize>
                    </td>
                    <td style="padding: 15px;">
                        <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="PauseSyncEndHour" runat="server" CssClass="form-control" Text="20" meta:resourcekey="DayTimeEndHourResource1"></asp:TextBox>
                        <asp:Label ID="LPauseSyncEndHour" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"></asp:Label>
                    </td>
                </tr>
            </table>
                </div>
        </div>
        <div style="height:10px"></div>
        <div  class="card">
            <div class="panel-heading toolnavbtn"  data-toggle="collapse" data-target="#mapdc" style="cursor:pointer; font-weight:100;background-color:#f8f8f8;">
                <asp:Localize ID="Localize16" meta:resourcekey="str_drivectl" runat="server">Mapped Drive Control</asp:Localize>
            </div>
            <div id="mapdc" class="collapse">
            <table width="100%" class="table">
                <tr>
                    <td width="500px" style="padding: 15px;">
                        <asp:Label ID="Label1" runat="server" Text="Hide Large File Download Tracker (popup progress window on the bottom-right when downloading large files)"
                            meta:resourcekey="HideDownloadTrackResource1"></asp:Label>
                    </td>
                    <td style="padding: 15px;">
                        <asp:CheckBox ID="HideDownloadTrack" runat="server" onclick="ShowSavePanel();" />
                    </td>
                </tr>
                <tr>
                    <td width="500px" style="padding: 15px;">
                        <asp:Label ID="Label8" runat="server" Text="Disable folder moving confirmation"
                            meta:resourcekey="DisableMoveResource1"></asp:Label>
                    </td>
                    <td style="padding: 15px;">
                        <asp:CheckBox onclick="ShowSavePanel();" ID="DisableMoveConfirmation" runat="server" />
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px;">
                        <asp:Label ID="Label2" runat="server" Text="Always Allow Picture Preview" meta:resourcekey="AlwaysAllowPicPreviewResource1"></asp:Label>
                    </td>
                    <td style="padding: 15px;">
                        <asp:CheckBox ID="AlwaysAllowPicPreview" runat="server" onclick="ShowSavePanel();" />
                    </td>
                </tr>
                 <tr>
                    <td style="padding: 15px;">
                        <asp:Localize meta:resourcekey="str_alwayspdf" runat="server">Always Allow PDF Preview</asp:Localize>
                    </td>
                    <td style="padding: 15px;">
                        <asp:CheckBox ID="AlwaysAllowPDFPreview" runat="server" onclick="ShowSavePanel();" />
                    </td>
                </tr>
                 <tr>
                    <td style="padding: 15px;">
                        <asp:Localize meta:resourcekey="str_noffline" runat="server">Don't show folder/files as offline when cache does not exist</asp:Localize>
                    </td>
                    <td style="padding: 15px;">
                        <asp:CheckBox ID="NoOfflineFlag" runat="server" onclick="ShowSavePanel();" />
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px;">
                        <asp:Localize meta:resourcekey="str_noquota" runat="server">Don't show storage quota</asp:Localize>
                    </td>
                    <td style="padding: 15px;">
                        <asp:CheckBox ID="NoShowStorageQuota" runat="server" onclick="ShowSavePanel();" />
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px;">
                        <asp:Localize meta:resourcekey="str_allowsh" runat="server">Allow shortcuts</asp:Localize>
                    </td>
                    <td style="padding: 15px;">
                        <asp:CheckBox ID="AllowShortCuts" runat="server" onclick="ShowSavePanel();" />
                    </td>
                </tr>
                                <tr>
                    <td style="padding: 15px;">
                        <asp:Localize meta:resourcekey="str_nodrive" runat="server">Disable mount drive (Server Agent Only)</asp:Localize>
                    </td>
                    <td style="padding: 15px;">
                        <asp:CheckBox ID="NoDevDrive" runat="server" onclick="ShowSavePanel();" />
                    </td>
                </tr>
                <tr style="display:none">
                    <td style="padding: 15px;">
                        <asp:Localize meta:resourcekey="str_purgecache" runat="server">Force purge cache upon exit</asp:Localize>
                    </td>
                    <td style="padding: 15px;">
                        <asp:CheckBox ID="CleanupCacheUponExit" runat="server" onclick="ShowSavePanel();" />
                    </td>
                </tr>
                
                <tr>
                    <td style="padding: 15px;">
                        <asp:Label ID="Label3" runat="server" Text="When starting the client, open the mounted drive automatically" meta:resourcekey="OpenDriveUponStartResource1"></asp:Label>
                    </td>
                    <td style="padding: 15px;">
                        <asp:CheckBox ID="OpenDriveUponStart" runat="server" onclick="ShowSavePanel();" checked="true"/>
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px;">
                        <asp:Label ID="Label4" runat="server" Text="Do not show file change notifications" meta:resourcekey="DONTSHOWCLResource2"></asp:Label>
                    </td>
                    <td style="padding: 15px;">
                        <asp:CheckBox ID="DONTSHOWCL" runat="server" onclick="ShowSavePanel();" />
                    </td>
                </tr>
                 <tr>
                    <td style="padding: 15px;">
                        <asp:Localize meta:resourcekey="str_noinmsg" runat="server">Do not show file in-place editing/preview disabled notifications</asp:Localize>
                    </td>
                    <td style="padding: 15px;">
                        <asp:CheckBox ID="DONTSHOWPREV" runat="server" onclick="ShowSavePanel();" />
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px;">
                        <asp:Label ID="Label6" runat="server" Text="Enable In-Place Open Zip/Exe File" meta:resourcekey="EnableInplaceZipOpen"></asp:Label>
                    </td>
                    <td style="padding: 15px;">
                        <asp:CheckBox ID="EnableZipOpen" runat="server" onclick="ShowSavePanel();" />
                    </td>
                </tr>
                 <tr>
                    <td style="padding: 15px;">
                        <asp:Localize meta:resourcekey="str_sso" runat="server">Enable Single Sign On with logged in windows user identity </asp:Localize>
                    </td>
                    <td style="padding: 15px;">
                        <asp:CheckBox Checked="True" ID="EnableSSO" runat="server" onclick="ShowSavePanel();" />
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px;">
                        <asp:Localize ID="LocMaxSzeZipFilInPlc" meta:resourcekey="ZipOpenSizeMB" runat="server" Text="Max Size of Zip File Allowed to Open In-Place (MB)"></asp:Localize>
                    </td>
                    <td style="padding: 15px;">
                        <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="ZipOpenSizeMB" runat="server" CssClass="form-control" meta:resourcekey="ZipOpenSizeMBResource1" Text="20"></asp:TextBox>
                        <asp:Label ID="LZipOpenSizeMB" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px;">
                        <asp:Localize id="LocTnlSzeLbl" meta:resourcekey="str_maxiconsize" runat="server">Max Size of File Allowed to Generate Thumbnail (MB)</asp:Localize>
                    </td>
                    <td style="padding: 15px;">
                        <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="ThumbNailSize" runat="server" CssClass="form-control"  Text="2"></asp:TextBox>
                        <asp:Label ID="LThumbNailSize" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px;">
                        <asp:Localize ID="LocCldDrvLbl" meta:resourcekey="asp_string7" runat="server" Text="Cloud Drive Label:"></asp:Localize>&nbsp;
                    </td>
                    <td style="padding: 15px;">
                        <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="MyGladinetDrive" runat="server" CssClass="form-control" meta:resourcekey="MyGladinetDriveResource1"></asp:TextBox>
                        <asp:Label ID="LMyGladinetDrive" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px;">
                        <asp:Localize ID="LocDrvLtr" meta:resourcekey="asp_string8" runat="server" Text="Drive Letter:"></asp:Localize>&nbsp;
                    </td>
                    <td style="padding: 15px;">
                        <asp:DropDownList ID="MappedDriveName" runat="server" CssClass="browser-default custom-select secsubbordercolor" meta:resourcekey="MappedDriveNameResource1" onchange="ShowSavePanel();" width="100px">
                        </asp:DropDownList>
                        <asp:Label ID="LMappedDriveName" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px;">
                        <asp:Localize ID="LocCchSzeLmt" meta:resourcekey="asp_string9" runat="server" Text="Cache Size Limit (MB):"></asp:Localize>&nbsp;
                    </td>
                    <td style="padding: 15px;">
                        <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="CacheLimitMB" runat="server" CssClass="form-control" Text="0" meta:resourcekey="CacheLimitMBResource1"></asp:TextBox>
                        <asp:Label ID="LCacheLimitMB" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"></asp:Label>
                    </td>
                </tr>
                                <tr>
                    <td style="padding: 15px;">
                        <asp:Localize ID="LocMinFreDskSpc" meta:resourcekey="str_freediskgb" runat="server">Minimal free disk space (GB)</asp:Localize> &nbsp;
                    </td>
                    <td style="padding: 15px;">
                        <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="FreediskGB" runat="server" CssClass="form-control" Text="5" ></asp:TextBox>
                        <asp:Label ID="LFreediskGB" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px;">
                        <asp:Localize ID="LocPgeLogDB" meta:resourcekey="str_purgeadb" runat="server">Purge logging DB N-days old (0 - don't purge)</asp:Localize> &nbsp;
                    </td>
                    <td style="padding: 15px;">
                        <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="KeepAuditDays" runat="server" CssClass="form-control" Text="0" ></asp:TextBox>
                        <asp:Label ID="LKeepAuditDays" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px;">
                        <asp:Localize meta:resourcekey="str_mountglobal" runat="server">Mount Drive in global space (Windows Client Only)</asp:Localize>&nbsp;
                        <p class="text-muted" style="font-weight: 100">
                            <asp:Localize meta:resourcekey="str_uacMsg" runat="server">A drive mounted in the global space will not be subject to UAC (User Account Control) limitations, such as when legacy applications are required to run with administrative privilege and cannot see the drive guarded by the UAC. On the other hand, drives that are mounted in the global space are visible to any other users who log in on the same Windows machine at the same time.</asp:Localize>
                            
                        </p>
                    </td>
                    <td style="padding: 15px;">
                        <asp:CheckBox ID="GlobalMount" runat="server" onclick="ShowSavePanel();" />
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px;">
                        <asp:Localize meta:resourcekey="str_hideoff" runat="server">In offline mode, only show files that are cached and available locally</asp:Localize>&nbsp;
                    </td>
                    <td style="padding: 15px;">
                        <asp:CheckBox ID="HideOffline" runat="server" onclick="ShowSavePanel();" />
                    </td>
                </tr>
                                <tr>
                    <td style="padding: 15px;">
                        <asp:Localize meta:resourcekey="str_nocheckout" runat="server">Disable "Check Out"</asp:Localize>&nbsp;
                    </td>
                    <td style="padding: 15px;">
                        <asp:CheckBox ID="NoCheckOut" runat="server" onclick="ShowSavePanel();" />
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px;">
                        <asp:Localize meta:resourcekey="str_usedefaultbrowser" runat="server">Use Windows default browser to open file/folder</asp:Localize>&nbsp;
                    </td>
                    <td style="padding: 15px;">
                        <asp:CheckBox ID="UseDefaultBrowser" runat="server" onclick="ShowSavePanel();" />
                    </td>
                </tr>
                                <tr>
                    <td style="padding: 15px;">
                        <asp:Localize meta:resourcekey="str_encryptlocalcache" runat="server">Encrypt Local Cache</asp:Localize>
                    </td>
                    <td style="padding: 15px;">
                        <asp:CheckBox ID="EncyptLocalCache" runat="server" onclick="ShowSavePanel();" />
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px;">
                        <asp:Localize meta:resourcekey="str_alwayssyncdircache" runat="server">Always sync folder meta data when browsed by explorer</asp:Localize>
                    </td>
                    <td style="padding: 15px;">
                        <asp:CheckBox ID="AlwaysRefreshDirCache" runat="server" onclick="ShowSavePanel();" />
                    </td>
                </tr>
                                <tr>
                    <td style="padding: 15px;">
                        <asp:Localize meta:resourcekey="str_nocad" runat="server">Disable AutoCad Optimization</asp:Localize>
                    </td>
                    <td style="padding: 15px;">
                        <asp:CheckBox ID="NoAutoCad" runat="server" onclick="ShowSavePanel();" />
                    </td>
                </tr>

            </table>
            </div>
        </div>
        <div style="height:10px"></div>
        <div class="card">
            <div class="panel-heading toolnavbtn"   data-toggle="collapse" data-target="#largefu" style="cursor:pointer; font-weight:100;background-color:#f8f8f8;">
                <asp:Localize ID="Localize19" meta:resourcekey="str_largefile" runat="server">Large File Upload</asp:Localize></div>
            <div id="largefu" class="collapse">
            <table width="100%" class="table">
                <tr>
                    <td width="500" style="padding: 15px;">
                        <asp:Localize ID="LocEnlChkUpdWhnFilSzeLrg" meta:resourcekey="asp_enablechuk" runat="server" Text="Enable chunk uploading when file size larger than (MB):"></asp:Localize>&nbsp;
                    </td>
                    <td style="padding: 15px;">
                        <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="ChunkSize" runat="server" CssClass="form-control" Text="50"></asp:TextBox>
                        <asp:Label ID="LChunkSize" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px;">
                        <asp:Localize ID="LocChkFilInMB" meta:resourcekey="asp_chuksize" runat="server" Text="Chunk file in Megabytes:"></asp:Localize>&nbsp;
                    </td>
                    <td style="padding: 15px;">
                        <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="PartSize" runat="server" CssClass="form-control" Text="10"></asp:TextBox>
                        <asp:Label ID="LPartSize" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px;">
                        <asp:Localize meta:resourcekey="str_usevss" runat="server">Use Volume Shadow Copy to Upload Files being Opened</asp:Localize>
                    </td>
                    <td style="padding: 15px;">
                        <asp:CheckBox ID="EnableVSSSupport" runat="server" onclick="ShowSavePanel();" />
                    </td>
                </tr>
                
            </table>
                </div>
        </div>

    <div style="height:10px;display:none;" ></div>
        <div class="card" style="display:none;" >
            <div class="panel-heading toolnavbtn"   data-toggle="collapse" data-target="#endpointb" style="cursor:pointer; font-weight:100;background-color:#f8f8f8;">
                <asp:Localize ID="Localize20" meta:resourcekey="str_endpoint" runat="server">Endpoint Protection</asp:Localize></div>
            <div id="endpointb" class="collapse">
            <table width="100%" class="table">
               
                <tr>
                    <td style="padding: 15px;" width="500" >
                        <asp:Localize ID="str_bdoc" meta:resourcekey="str_bdoc" runat="server">Backup "My Documents" folder</asp:Localize>
                        
                    </td>
                    <td style="padding: 15px;">
                        <asp:CheckBox ID="BackupMyDoc" runat="server" onclick="ShowSavePanel();" />
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px;" width="500" >
                       
                         <asp:Localize ID="Localize21" meta:resourcekey="str_doclocation" runat="server">Backup to location (Leave empty for default location. )</asp:Localize>
                        <p style="font-size:smaller; color:#565656;">
                             <asp:Localize ID="Localize22" meta:resourcekey="str_doclocationhint" runat="server">myroot/{email} or {samAccountName} or {upn}/My Documents</asp:Localize>         
                            </p>
                    </td>
                    <td style="padding: 15px;">
                         <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="DocLocation" runat="server" CssClass="form-control" Text="" ></asp:TextBox>
                        <asp:Label ID="LDocLocation" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px; ">
                        <asp:Localize ID="str_bpic" meta:resourcekey="str_bpic" runat="server">Backup "My Pictures" folder</asp:Localize>
                        
                    </td>
                    <td style="padding: 15px;">
                        <asp:CheckBox ID="BackupMyPic" runat="server" onclick="ShowSavePanel();" />
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px;" width="500" >
                       
                         <asp:Localize ID="Localize23" meta:resourcekey="str_piclocation" runat="server">Backup to location (Leave empty for default location. )</asp:Localize>
                        <p style="font-size:smaller; color:#565656;">
                             <asp:Localize ID="Localize24" meta:resourcekey="str_piclocationhint" runat="server">myroot/{email} or {samAccountName} or {upn}/My Pictures</asp:Localize>         
                            </p>
                    </td>
                    <td style="padding: 15px;">
                         <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="PicLocation" runat="server" CssClass="form-control" Text="" ></asp:TextBox>
                        <asp:Label ID="LPicLocation" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"></asp:Label>
                    </td>
                </tr>
            </table>
                </div>
        </div>


        <div style="height:10px"></div>
        <div class="card">
            <div class="panel-heading toolnavbtn"   data-toggle="collapse" data-target="#bandc" style="cursor:pointer; font-weight:100;background-color:#f8f8f8;">
                <asp:Localize ID="Localize14" meta:resourcekey="asp_string10" runat="server" Text="Bandwidth Control"></asp:Localize></div>
            <div id="bandc" class="collapse">
            <table width="100%" class="table">
                <tr>
                    <td width="500" style="padding: 15px;">
                        <asp:Localize ID="LocDwdBwtLmt" meta:resourcekey="asp_string11" runat="server" Text="Download Bandwidth Limit (KB/s, 0-Unlimited):"></asp:Localize>
                    </td>
                    <td style="padding: 15px;">
                        <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="DownloadBandwidth" runat="server" CssClass="form-control" Text="0" meta:resourcekey="DownloadBandwidthResource2"></asp:TextBox>
                        <asp:Label ID="LDownloadBandwidth" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px;">
                        <asp:Localize ID="LocUpdBwtLmt" meta:resourcekey="asp_string12" runat="server" Text="Upload Bandwidth Limit (KB/s, 0-Unlimited):"></asp:Localize>
                    </td>
                    <td style="padding: 15px;">
                        <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="UploadBandwidth" runat="server" CssClass="form-control" Text="0" meta:resourcekey="UploadBandwidthResource2"></asp:TextBox>
                        <asp:Label ID="LUploadBandwidth" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px;">
                        <asp:Localize ID="LocNumFilTfrThd" meta:resourcekey="asp_string13" runat="server" Text="Number of File Transfer Threads:"></asp:Localize>
                    </td>
                    <td style="padding: 15px;">
                        <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="DownloadWorkerCount" runat="server" CssClass="form-control" Text="5" meta:resourcekey="DownloadWorkerCountResource1"></asp:TextBox>
                        <asp:Label ID="LDownloadWorkerCount" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"></asp:Label>
                    </td>
                </tr>
            </table>
                </div>
        </div>
 <div style="height:10px"></div>

    <div class="card">
            <div class="panel-heading toolnavbtn"   data-toggle="collapse" data-target="#outp" style="cursor:pointer; font-weight:100;background-color:#f8f8f8;">
                <asp:Localize meta:resourcekey="str_outlook" runat="server">Outlook Plugin</asp:Localize>
                </div>
            <div id="outp" class="collapse">

            <table width="100%" class="table" style="background-color: white;">
                <tr>
                    <td width="500" style="padding: 15px;">
                        <asp:Localize ID="LocPrtForCnvWhnFilSze" meta:resourcekey="str_thretext" runat="server">Prompt for conversion only when the file is larger than N KB (0 - unlimited)</asp:Localize>
                    </td>
                    <td style="padding: 15px;">
                        <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="OutlookSize" runat="server" CssClass="form-control" Text="0" ></asp:TextBox>
                        <asp:Label ID="LOutlookSize" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"></asp:Label>
                    </td>
                </tr>
                 <tr>
                <td style="padding: 15px;">
                    <asp:Localize ID="LocDftFldToStrAtcFrmOlk" meta:resourcekey="str_outlookfolder" runat="server">Default folder to store attachments from Outlook plugin (/folder/subfolder)</asp:Localize>

                     </td>
                <td style="padding: 15px;">
                    <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();"  ID="OutlookFolder" runat="server" Width="100%" meta:resourcekey="ShareDomainWhiteListResource1"
                            CssClass="form-control"></asp:TextBox>
                    <asp:Label ID="LOutlookFolder" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
                </td>
            </tr>
                 <tr>
                    <td style="padding: 15px;">
                        <asp:Localize ID="LocLnkExpTme" runat="server" meta:resourcekey="str_lnkExpTme">Link expiration time</asp:Localize>&nbsp;
                    </td>
                    <td style="padding: 15px;">
                        <asp:DropDownList ID="OutlookExpireTime" runat="server" CssClass="browser-default custom-select secsubbordercolor" meta:resourcekey="MappedDriveNameResource1" onchange="ShowSavePanel();" width="100px">
                        </asp:DropDownList>
                        <asp:Localize meta:resourcekey="str_never" id="str_never" Visible="False" runat="server">Never</asp:Localize>
                        <asp:Localize meta:resourcekey="str_days" id="str_days" Visible="False" runat="server">days</asp:Localize>
                        <asp:Localize meta:resourcekey="str_oneday" id="str_oneday" Visible="False" runat="server">One day</asp:Localize>
                        <asp:Localize meta:resourcekey="str_onemonth" id="str_onemonth" Visible="False" runat="server">One month</asp:Localize>
                        <asp:Localize meta:resourcekey="str_6mon" id="str_6mon" Visible="False" runat="server">Six months</asp:Localize> 
                        <asp:Localize meta:resourcekey="str_oneweek"  id="str_oneweek" Visible="False" runat="server">One week</asp:Localize>
                        <asp:Localize meta:resourcekey="str_oneyear"  id="str_oneyear" Visible="False"  runat="server">One year</asp:Localize>
                    </td>
                </tr>
           
            </table>
                                </div>

        </div>
 
        <div style="height:10px"></div>
         <div class="card">
            <div class="panel-heading toolnavbtn"  data-toggle="collapse" data-target="#clientss" style="cursor:pointer; font-weight:100;background-color:#f8f8f8;">
                <asp:Localize meta:resourcekey="str_sss" runat="server">Client Startup Script</asp:Localize>
                </div>
             <div id="clientss" class="collapse">
            <table width="100%" class="table" style="background-color: white;">
                <tr>
                    <td width="500" style="padding: 15px;">
                        <asp:Localize meta:resourcekey="str_wsss" runat="server">Windows Client Startup Script</asp:Localize>
                    </td>
                    <td style="padding: 15px;">
                        
                                    <asp:FileUpload ID="WinSSFile" runat="server"  Width=100% onchange="ShowSavePanel();"
                                        meta:resourcekey="ApplicationIcomFileResource1" />
                                    <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="WinSS" runat="server" Width="100%" CssClass="form-control" Visible="False"
                                                    meta:resourcekey="WApplicationIconUrlResource1"></asp:TextBox>
                                    <asp:Label ID="LWinSS" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"></asp:Label>
                    </td>
                </tr>
                
            </table>
                 </div>
        </div>
        <div style="height:10px"></div>
        
        <div class="card">
            <div class="panel-heading toolnavbtn"  data-toggle="collapse" data-target="#clientsus" style="cursor:pointer; font-weight:100;background-color:#f8f8f8;">
                <asp:Localize meta:resourcekey="str_ssd" runat="server">Client Shutdown Script</asp:Localize>
                </div>
            <div id="clientsus" class="collapse">
            <table width="100%" class="table" style="background-color: white;">
                <tr>
                    <td width="500" style="padding: 15px;">
                        <asp:Localize meta:resourcekey="str_winsd" runat="server">Windows Client Shutdown Script</asp:Localize>
                    </td>
                    <td style="padding: 15px;">
                        
                                    <asp:FileUpload ID="WinSDFile" runat="server"  Width=100% onchange="ShowSavePanel();"
                                        meta:resourcekey="ApplicationIcomFileResource1" />
                                    <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="WinSD" runat="server" Width="100%" CssClass="form-control" Visible="False"
                                                    meta:resourcekey="WApplicationIconUrlResource1"></asp:TextBox>
                                    <asp:Label ID="LWinSD" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"></asp:Label>
                    </td>
                </tr>
                
            </table>
                </div>
        </div>
        <div style="height:10px"></div>
        <div class="card">
            <div class="panel-heading toolnavbtn"  data-toggle="collapse" data-target="#macclients" style="cursor:pointer; font-weight:100;background-color:#f8f8f8;">
                <asp:Localize meta:resourcekey="str_macclient" runat="server">Mac Client Settings</asp:Localize>
                </div>
            <div id="macclients" class="collapse">
            <table width="100%" class="table" style="background-color: white;">
                <tr>
                    <td width="500" style="padding: 15px;">
                        <asp:Localize meta:resourcekey="str_nosyncpopup" runat="server">Do not show Mac Client sync status pop up dialog</asp:Localize>
                        
                    </td>
                    <td style="padding: 15px;">
                        
                                <asp:CheckBox ID="NoMacClientSyncStatus" runat="server" onclick="ShowSavePanel();" />
                    </td>
                </tr>
                <tr>
                    <td width="500" style="padding: 15px;">
                        <asp:Localize meta:resourcekey="str_macautostart" runat="server">Start Mac client automatically</asp:Localize>
                        
                    </td>
                    <td style="padding: 15px;">
                        
                                <asp:CheckBox checked="true" ID="MacAutoStart" runat="server" onclick="ShowSavePanel();" />
                    </td>
                </tr>
            </table>
                </div>
        </div>

        <table width="100%" class="table">
            <tr style="display: none;">
                <td>
                    <asp:Localize ID="LocNumUpdThd" meta:resourcekey="asp_string14" runat="server" Text="Number of Upload Threads:"></asp:Localize>
                </td>
                <td>
                    <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="UploadWorkerCount" runat="server" CssClass="form-control" Text="5" meta:resourcekey="UploadWorkerCountResource1"></asp:TextBox>
                </td>
            </tr>
        </table>
    </div>
    <asp:HiddenField ID="SettingsId" runat="server" />
    <asp:Localize  ID="NOTConfig" meta:resourcekey="str_notconfiged" Visible="False" runat="server">Not Configured</asp:Localize>
 <% if (!string.IsNullOrEmpty(ErrorMsg.Text)){ %>
        <script type="text/javascript">
            function AutoExpandCategory(clientID) {
                try {     
                    //find parent of control
                    var parentPanel = $('div.collapse').has('#' + clientID);  
                    if (parentPanel.length == 1) {
                       //now expand the panel             
                        var parentHeader = $('div.panel-heading[data-target="#' + parentPanel.prop("id") + '"]');  
                        console.log(parentHeader)
                        if (parentHeader.length == 1) {   
                            parentHeader[0].click();
                        }
                    }
                } catch (ex) {
                    console.log("AutoExpandCategory:ex:",ex);
                }
            }
            Ext.onReady(function () {   
            <asp:Literal ID="LtlScripts" runat="server" />
            gWMsgBox("<%=ErrorMsg.Text%>");
            ShowSavePanel();  

            });
        </script>
    <% } %>
</asp:Content>
