﻿<%@ Page Title="Gladinet Cloud - Publish Folder" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="GroupPolicyClientNative.aspx.cs" Inherits="GladinetPayFlow.GroupPolicyClientNative" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">

    <style type="text/css">
        td {
            font-size: 15px;
            
            font-weight: 100;
        }
        
        b {
            font-weight: 500;
        }
        
        .badgefont {
            font-size: 15px;
            
        }

    </style>
    <script type="text/javascript">



        function OnSaveChanges() {
            Wait("Please wait...");
            var btn = document.getElementById('ctl00_MainContent_ApplyBtn');
            btn.click();

        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocFaiToAppCha" meta:resourcekey="str_faiToAppCha" Visible="false">Failed to apply changes</asp:Localize>
   <nav class="navbar navbar-default navbar-fixed-top" role="navigation" style="display: none;">
        <div class="navbar-left">
            <asp:Label ID="ErrorMsg" runat="server" ForeColor="Red" meta:resourcekey="ErrorMsgResource1"></asp:Label>
        </div>
            <div class="container-fluid" style="padding-right: 30px;">
                 <% if (m_CanEdit){ %>
                    <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize> 
                    <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize> 
                        <asp:Button ID="EditBtn" runat="server" 
                            CausesValidation="False" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" 
                            Text="Edit" onclick="EditBtn_Click" 
                     meta:resourcekey="EditBtnResource1" ></asp:Button>   
                        <asp:Button ID="CancelBtn" runat="server" Visible="False"
                            CausesValidation="False" 
                            CssClass="btn  navbar-btn navbar-right btndlg" 
                            Text="Cancel" onclick="CancelBtn_Click" Width="108px" 
                     meta:resourcekey="CancelBtnResource1"></asp:Button>    
                            &nbsp;&nbsp;&nbsp;&nbsp; 
                        <asp:Button ID="ApplyBtn" runat="server" Visible="False"
                            CausesValidation="False" OnClick="ApplylNow_Click" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" meta:resourcekey="ApplylNowResource1" 
                            Text="Apply" Width="108px"></asp:Button>       
                            &nbsp;&nbsp;&nbsp;&nbsp;        
                    <%
                        EditBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                        CancelBtn.OnClientClick = String.Format("Wait('{0}')", LocPlsWat.Text);
                        ApplyBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                    } %>
            </div>
            </nav>
    
   
    <div class="wrapper" style="background-color: white; width:100%;margin-top: 10px;font-size: 16px;">
     <table width="100%" class="table-striped" style="margin-bottom: 100px;">
         <tr>
             <td width="500px" style="padding: 15px;">
                 <asp:Label ID="Label1" runat="server" meta:resourceKey="AddShortCutToDocumentsResource1" 
                    Text="Create shortcut in documents library" ></asp:Label> 
                    <p class="text-muted" style="font-size: smaller;">
                    <asp:Localize ID="Localize7" runat="server" meta:resourceKey="asp_string9" Text="When enabled, the windows client will create a shortcut to the mapped drive in the documents
                        library."></asp:Localize>
                </p>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox Checked="True" ID="AddShortCutToDocuments" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>
         
         <tr>
             <td style="padding: 15px;">
                 <asp:Label ID="Label2" runat="server" meta:resourceKey="AddShortCutToDesktop" Text="Create shortcut on Desktop"></asp:Label>
                 <p class="text-muted" style="font-size: smaller;">
                    <asp:Localize ID="AddShortCutToDesktopDesc" meta:resourcekey="string24" 
                        runat="server" 
                        Text="When enabled, the windows client will create a shortcut to the mapped drive on the desktop."></asp:Localize></p>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox Checked="True" ID="AddShortCutToDesktop" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>
         
         <tr>
             <td style="padding: 15px;">
                 <asp:Label ID="Label3" runat="server" Text="Hide Settings in the Windows Client Management Console" 
                    meta:resourcekey="DisableSettings"></asp:Label> 
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox ID="DisableSettings"  runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>
         
         <tr>
             <td style="padding: 15px;">
                 <asp:Label ID="Label4" runat="server" Text="Don't Allow Setting Changes in the Windows Client Management Console" meta:resourcekey="DisableSettingsChangeResource1" ></asp:Label> 
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox ID="DisableSettingsChange"  runat="server" onclick="ShowSavePanel();" />

             </td>
         </tr>
         
         <tr>
             <td style="padding: 15px;">
                 <asp:Label ID="Label5" runat="server" Text="Disable Windows client in-place drag & drop uploading" meta:resourcekey="NoDDUploadResource1" ></asp:Label>
                 <p class="text-muted" style="font-size: smaller;">
                    <asp:Localize ID="Localize8" meta:resourcekey="asp_string10" runat="server" Text="When enabled, dragging &amp; dropping files (or folders) to the cloud drive will write files to the local cache first and then upload in the background."></asp:Localize></p>

             </td>
             <td style="padding: 15px;">
                <asp:CheckBox ID="NoDDUpload" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>
         
         <tr>
             <td style="padding: 15px;">
                 <asp:Label ID="Label6" runat="server" Text="Disable 'Auto-Login next time'" meta:resourcekey="NoAutoLogonResource1" ></asp:Label>
             </td>
             <td style="padding: 15px;">
                  <asp:CheckBox ID="NoAutoLogon" runat="server" onclick="ShowSavePanel();" />

             </td>
         </tr>
         <tr>
             <td style="padding: 15px;">
                 <asp:Label ID="Label9" runat="server" Text="Disable Context Menu"  ></asp:Label>
             </td>
             <td style="padding: 15px;">
                  <asp:CheckBox ID="DisableContextMenu" runat="server" onclick="ShowSavePanel();" />

             </td>
         </tr>
         <tr>
             <td style="padding: 15px;">
                 <asp:Label ID="Label7" runat="server" Text="Disable drag & drop handler" 
                    meta:resourcekey="DisableDDHandlerResource1"></asp:Label>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox ID="DisableDDHandler" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>
         <tr>
             <td style="padding: 15px;">
                 <asp:Localize meta:resourcekey="str_appdev" runat="server">Require approval for device access</asp:Localize>
                 <p class="text-muted" style="font-size: smaller;">
                     <asp:Localize meta:resourcekey="str_appdevh" runat="server">When a user attempts to log in from a new device via native client applications, the connection will be rejected until the tenant admin approves the new device.</asp:Localize>
                 </p>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox ID="ApproveNewDevice" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>
         <tr>
             <td style="padding: 15px;">
                 <asp:Localize meta:resourcekey="str_appdeven" runat="server">Require approval for device access from external network</asp:Localize>
                 <p class="text-muted" style="font-size: smaller;">
                     <asp:Localize meta:resourcekey="str_appdevenh" runat="server">When a user attempts to log in from a new device via native client applications from external network, the connection will be rejected until the tenant admin approves the new device.</asp:Localize>
                 </p>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox ID="ApproveExternalNewDevice" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>
         <tr>
             <td style="padding: 15px;">
                 <asp:Label ID="Label8" runat="server" Text="Enable auto-installation of the Outlook Plugin" meta:resourcekey="EnableOutlookAddinResource1" ></asp:Label>  
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox ID="EnableOutlookAddin" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>
         <tr>
             <td style="padding: 35px;">
                 <asp:Label ID="LblIntAdnIfNotInt" runat="server" Text="Install Outlook Plugin only if it is not already installed" meta:resourcekey="str_intAdnIfNotInt" ></asp:Label>  
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox ID="SkipOutlookAddinIfInstalled" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>
        <tr>
             <td style="padding: 15px;">
                 <asp:Localize meta:resourcekey="str_noguestclient" runat="server">Disable native client for guest users</asp:Localize>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox ID="NoGuestClient" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>
        <tr>
             <td style="padding: 15px;">
                 <asp:Localize meta:resourcekey="str_shwCltDwdLnkOnLgnPge" runat="server">Show native client download link on the login page</asp:Localize>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox ID="ShowClientLinkOnLoginPage" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>

        <tr>
             <td style="padding: 15px;">
                 <asp:Localize meta:resourcekey="str_reqLgnAcsSvrAgtMgtCsl" runat="server">Require login to access server agent management console</asp:Localize>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox ID="SAMgmtConsoleRequireLogin" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>

        </table>
      </div>
 <% if (!string.IsNullOrEmpty(ErrorMsg.Text)){ %>
        <script type="text/javascript">
            Ext.onReady(function () {
                            gWMsgBox("<%=ErrorMsg.Text%>");
            ShowSavePanel();

            });
        </script>
    <% } %>
</asp:Content>
