﻿<%@ Page Title="Gladinet Cloud - Publish Folder" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="GroupPolicyClientFilter.aspx.cs" Inherits="GladinetPayFlow.GroupPolicyClientFilter" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    

    <style type="text/css">
        td {
            font-size: 15px;
            
            font-weight: 100;
        }
        
        b {
            font-weight: 500;
        }
        
        .badgefont {
            font-size: 15px;
            
        }

    </style>
    <script type="text/javascript">


        function OnSaveChanges() {
            Wait("Please wait...");
            var btn = document.getElementById('ctl00_MainContent_ApplyBtn');
            btn.click();

        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocFaiToApp" meta:resourcekey="str_faiToApp" Visible="false">Failed to apply</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToAppSet" meta:resourcekey="str_faiToAppSet" Visible="false">Failed to apply settings</asp:Localize>
 <nav class="navbar navbar-default navbar-fixed-top" role="navigation" style="display: none;">
        <div class="navbar-left">
            <asp:Label ID="ErrorMsg" runat="server" ForeColor="Red" meta:resourcekey="ErrorMsgResource1"></asp:Label>
        </div>
            <div class="container-fluid" style="padding-right: 30px;">
                 <% if (m_CanEdit){ %>
                        <asp:Button ID="EditBtn" runat="server" 
                            CausesValidation="False" OnClientClick="Wait('Apply Change')"
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" 
                            Text="Edit" onclick="EditBtn_Click" 
                     meta:resourcekey="EditBtnResource1" ></asp:Button>                                                        
                            
                        <asp:Button ID="CancelBtn" runat="server" Visible="False"
                            CausesValidation="False" OnClientClick="Wait('Please wait')"
                            CssClass="btn  navbar-btn navbar-right btndlg" 
                            Text="Cancel" onclick="CancelBtn_Click" Width="108px" 
                     meta:resourcekey="CancelBtnResource1"></asp:Button>    
                            &nbsp;&nbsp;&nbsp;&nbsp; 
                        <asp:Button ID="ApplyBtn" runat="server" Visible="False"
                            CausesValidation="False" OnClick="ApplylNow_Click" OnClientClick="Wait('Apply Change')"
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" meta:resourcekey="ApplylNowResource1" 
                            Text="Apply" Width="108px"></asp:Button>       
                            &nbsp;&nbsp;&nbsp;&nbsp;                                                 
                <% } %>
            </div>
            </nav>
    
  
    <div class="wrapper" style="background-color: white; width:100%;margin-top: 10px;font-size: 16px;">
     <table width="100%" class="table-striped" style="margin-bottom: 100px;">
         <tr>
             <td width="500px" style="padding: 15px;">
                 <asp:Label ID="Label2" runat="server" 
                        Text="Files with following extension will be excluded from attached local folder (i.e.[.pst][.abc]):" 
                        meta:resourcekey="Label2Resource1"></asp:Label>
             </td>
             <td style="padding: 15px;">
                 <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="DropExcludeList" runat="server"  CssClass="form-control" Text="[.pst][.ldb]" 
                        meta:resourcekey="DropExcludeListResource1"></asp:TextBox>
                        <asp:Label ID="LDropExcludeList" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
             </td>
             
         </tr>
         
         
         
         <tr>
             <td style="padding: 15px;">
                 <asp:Localize ID="Localize3" meta:resourcekey="dirlistexclude_str" runat="server" 
                        Text="Files with following extension will be excluded from directory listing (i.e.[.qbw]):"></asp:Localize>
             </td>
             <td style="padding: 15px;">
                 <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="ListExcludeList" runat="server"  CssClass="form-control" meta:resourcekey="ListExcludeListResource1" 
                        ></asp:TextBox>
                        <asp:Label ID="LListExcludeList" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
             </td>
         </tr>
         <% if (!IsServo) { %>
         <tr>
             <td style="padding: 15px;">
                 <asp:Label ID="Label1" runat="server" 
                        
                        Text="Inplace editing/Preview is disabled for files with following extension (i.e.[.exe][.zip]):" meta:resourcekey="Label1Resource1" 
                        ></asp:Label>
             </td>
             <td style="padding: 15px;">
                 <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="PreivewExcludeList" runat="server"  CssClass="form-control"
                        Text="[.exe][.zip]" meta:resourcekey="PreivewExcludeListResource1" 
                        ></asp:TextBox>
                        <asp:Label ID="LPreivewExcludeList" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
             </td>
         </tr>
         <tr>
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="str_allownoext" runat="server">Allow file without file name extension</asp:Localize>
                </td>
                <td style="padding: 15px;">
                     <asp:CheckBox onclick="ShowSavePanel();" ID="AllowNoEntension" runat="server" meta:resourcekey="AllowEmptyFileResource2" 
                    
                     />
                </td>
            </tr>
         <%} %>
         <tr>
                <td style="padding: 15px;">
                    <asp:Label ID="Label4" runat="server" Text="Allow syncing of empty files" meta:resourcekey="AllowEmptyFileResource1" ></asp:Label>
                </td>
                <td style="padding: 15px;">
                     <asp:CheckBox onclick="ShowSavePanel();" ID="AllowEmptyFile" runat="server" meta:resourcekey="AllowEmptyFileResource2" 
                    
                     />
                </td>
            </tr>
    </table>
  
        </div>
        <div style="display: none">
                    <asp:Localize ID="Localize4" meta:resourcekey="asp_string11" runat="server" 
                        Text="Files Stored Locally Only (Separate by ;)"></asp:Localize>:<asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="LocalOnlyList" Text="thumbs.db;desktop.ini;picasa.ini;"
                        Width="250px" runat="server" meta:resourcekey="LocalOnlyListResource1"></asp:TextBox><br />
                    <asp:Localize ID="Localize5" meta:resourcekey="asp_string12" runat="server" 
                        Text="Extensions of Files Stored Locally Only (Separate by ;)"></asp:Localize>:<asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="LocalOnlyExtList"
                        Text=".lnk;" runat="server" meta:resourcekey="LocalOnlyExtListResource1"></asp:TextBox><br />
                    <asp:CheckBox onclick="ShowSavePanel();" ID="ShowExplorerBar" runat="server" Checked="True" Text="Show Gladinet Explorer Menu Bar"
                        Visible="False" meta:resourcekey="ShowExplorerBarResource1" /><br />
                        
            <asp:Localize ID="NOTConfig" meta:resourcekey="str_notconfiged" runat="server">Not Configured</asp:Localize>
                </div>
 <% if (!string.IsNullOrEmpty(ErrorMsg.Text)){ %>
        <script type="text/javascript">
            Ext.onReady(function () {
                            gWMsgBox("<%=ErrorMsg.Text%>");
            ShowSavePanel();

            });
        </script>
    <% } %>
</asp:Content>
