﻿<%@ Page Title="Gladinet Cloud - Publish Folder" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="GroupPolicyClient.aspx.cs" Inherits="GladinetPayFlow.GroupPolicyClient" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <script type="text/javascript">


        Ext.onReady(function () {
            Ext.define('GroupAccordion', {
                extend: 'Ext.panel.Panel',
                alias: 'widget.policygroup',

                requires: [
                    'Ext.layout.container.Accordion',
                    'Ext.grid.*'
                ],
                xtype: 'layout-accordion',
              


                layout: 'accordion',
                renderTo: 'allgroup',

                height: document.documentElement.clientHeight - 8,
                defaults: {
                    bodyPadding: 2
                },
                fbar: {
                    xtype:'panel',
                    contentEl: 'buttons'
                },
                
                initComponent: function () {
                    Ext.apply(this, {
                        items: [ 
                            {
                                title: "<asp:Localize meta:resourcekey="str_locking" runat="server">File Locking</asp:Localize>",
                                contentEl: 'group2',
                                autoScroll: true
                            },
                            {
                                title: "<asp:Localize meta:resourcekey="str_attached" runat="server">Attached Folder</asp:Localize>",
                                contentEl: 'group5',
                                autoScroll: true
                            },

                            {
                                title: "<asp:Localize meta:resourcekey="str_web" runat="server">Web Portal</asp:Localize>",
                                contentEl: 'group3',
                                autoScroll: true
                            },
                            {
                                title: "<asp:Localize meta:resourcekey="str_Native" runat="server">Native Client (Windows Client, Server Agent, Mac Client)</asp:Localize>",
                                contentEl: 'group4',
                                autoScroll: true
                            },
                            {
                                title: "<asp:Localize meta:resourcekey="str_filters" runat="server">Filters</asp:Localize>",
                                contentEl: 'group1',
                                autoScroll: true
                            }
                            

                        ]
                    });
                    this.callParent();
                }
            });

            var panel = Ext.create('widget.policygroup');

            Ext.EventManager.onWindowResize(function (w, h) {
                panel.setHeight(document.documentElement.clientHeight - 8);
                panel.doComponentLayout();
            });
        });
    </script>
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        .policygroup
        {
            -moz-border-radius: 5px 5px;
            -webkit-border-radius: 5px 5px;
            -o-border-radius: 5px 5px;
            -ms-border-radius: 5px 5px;
            -khtml-border-radius: 5px 5px;
            border-radius: 5px 5px;
            border: 1px solid #d0d0d0;
            padding-left: 2px;
            background-color: #f0f0f0;
            color: #008000;
            box-shadow: 0pt 0pt 4px 0pt rgb(136, 136, 136);
            padding-bottom: 5px;
        }
    </style>
    <script type="text/javascript">

        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 8000);



        function closeCancelActiveWin() {
        }

        function closeActiveWin() {
            window.location = "AddUserPage.aspx";
        }

        function OnCancelApply() {
            parent.closeActiveWin();
        }

        function dummy(e) {
            if (window.event) {
                window.event.cancelBubble = true;
            } else {
                e.stopPropagation();
            }

        }
        var lastexpand = "";
        function Toggle(name) {
            var d = document.getElementById(name);
            var i = document.getElementById(name + "icon");


            if (lastexpand != "" && name != lastexpand) {

                var ld = document.getElementById(lastexpand);
                var li = document.getElementById(lastexpand + "icon");
                ld.style.display = 'none';
                li.src = "images/expand.png";

                lastexpand = "";
            }

            if (d.style.display == 'none') {
                d.style.display = '';
                i.src = "images/collapse.gif";
                lastexpand = name;
            } else {
                d.style.display = 'none';
                i.src = "images/expand.png";
            }
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Label ID="ErrorMsg" runat="server" ForeColor="Red" 
        meta:resourcekey="ErrorMsgResource1"></asp:Label>
<table width="100%" class="checkout3 x-panel-header-light" style=" margin: 0px;
        padding: 0px;" align="center">
        <tr>
            <td>
                <div id='allgroup' style="overflow: auto; width: 100%;">
                </div>
            </td>
        </tr>
    </table>
    <asp:Panel ID="PolicyPanel" runat="server" 
        meta:resourcekey="PolicyPanelResource1">
    
    <table id='group2' width="100%" >
        <tr>
            <td colspan="2" style="padding-top: 8px; padding-left: 8px; background-color: white;
                color: black;" id="client">
                <table width="96%">
                    <tr>
                        <td class="idea_flex" style="vertical-align: middle; height:40px; margin:8px;">
                             <p>
                    <asp:Localize ID="Localize1" meta:resourcekey="asp_string1" runat="server" 
                                     Text="Following setting will apply to all clients (Desktop Client/File Server Client)."></asp:Localize></p>
                        </td>
                    </tr>
                </table>
               
                <asp:CheckBox ID="EnableDistributedLocking" runat="server" 
                    Text="Enable distributed locking when accessing files" 
                    meta:resourcekey="EnableDistributedLockingResource1" /><br />
                <p style="line-height: 16px; font-size: 12px; color: #808080; margin-left: 16px;">
                    <asp:Localize meta:resourcekey="asp_string2" runat="server" Text="When set, the file will be locked when accessed, this will prevent multiple users
                        editing the same file at the same time. This may not take effect if the application
                        used to access the file does not support locking."></asp:Localize></p>
                <span style="width: 20px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span><asp:CheckBox
                    ID="ForceLock" runat="server" Text="Lock file exclusively" 
                    meta:resourcekey="ForceLockResource1" /><br />
                <p style="line-height: 16px; font-size: 12px; color: #808080; margin-left: 16px;">
                    <span style="width: 20px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>
                    <asp:Localize meta:resourcekey="asp_string3" runat="server" Text="When
                                    set, the locked file will be locked exclusively. When not set, other user trying
                                    to open a locked file will be notified about the lock status, but can still open
                                    the file."></asp:Localize></p>
                <span style="width: 20px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span><asp:CheckBox
                    ID="DelaySync" runat="server" Text="Delay sync until file is unlocked" 
                    meta:resourcekey="DelaySyncResource1" /><br />
                <p style="line-height: 16px; font-size: 12px; color: #808080; margin-left: 16px;">
                <span style="width: 20px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>
                    <asp:Localize meta:resourcekey="asp_string4" runat="server" 
                        Text="When set, the sync of modified file will be delayed until the file is unlocked (the editing process exits)"></asp:Localize></p>
                <span style="width: 20px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>
                <asp:Localize meta:resourcekey="asp_string5" runat="server" Text="Apply
                    lock only to following process (lower case)"></asp:Localize>:<asp:TextBox Width="350px" ID="LockProcess"
                    runat="server" Text="winword.exe;excel.exe;powerpnt.exe;" 
                    meta:resourcekey="LockProcessResource1"></asp:TextBox><br /><span style="width: 20px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>
                <asp:Localize meta:resourcekey="str_lockmacprocess" runat="server" Text="Apply
                    lock only to the following Mac process (lower case):"></asp:Localize><asp:TextBox 
                    Width="350px" ID="MacLockProcess"
                    runat="server" 
                    Text="microsoft word;microsoft excel;microsoft powerpoint;textedit" meta:resourcekey="MacLockProcessResource1" 
                    ></asp:TextBox>
                <br style="line-height: 5px" />
                
                <br style="line-height: 3px" />
                <asp:CheckBox ID="NoSharesFolder" runat="server" Visible="False"
                    Text="Hide 'Files shared with me' folder" 
                    meta:resourcekey="NoSharesFolderResource1" /><br />
                <p style="line-height: 16px; font-size: 12px; color: #808080; margin-left: 16px;display: none;">
                    <asp:Localize meta:resourcekey="asp_string8" runat="server" 
                        Text="When set, the folder 'Files shared with me' will be hidden"></asp:Localize></p>

                
            </td>
        </tr>
    </table>
    <table id='group3' width="100%" >
        <tr>
            <td>
                <asp:CheckBox ID="DisableFolderDownload" runat="server" 
                    Text="Disable folder download from web client" 
                    meta:resourcekey="DisableFolderDownloadResource1" /><br />
                <p style="line-height: 16px; font-size: 12px; color: #808080; margin-left: 16px;">
                    <asp:Localize ID="Localize6" meta:resourcekey="asp_string7" runat="server" Text="When set, the functionality of downloading a folder as zip file from web client
                        is disabled"></asp:Localize></p>
                        
                <%if (SessionIsInstalledApp)
                  { %>
                <br style="line-height: 3px" />
                <asp:CheckBox ID="DisableSearch"  runat="server" 
                    Text="Disable Search" 
                    meta:resourcekey="DisableSearch" />
                <%} %>
                <br style="line-height: 3px" />
                <asp:CheckBox ID="DisableJavaUploader"  runat="server" Checked="True"
                    Text="Web Browser - Disable Java Uploader" meta:resourcekey="DisableJavaUploaderResource1" 
                     />
                <br style="line-height: 3px" />
                <asp:CheckBox ID="DisableFlashUploader"  runat="server" Checked="True"
                    Text="Web Browser - Disable Flash Uploader" meta:resourcekey="DisableFlashUploaderResource1" 
                     />
                <br style="line-height: 3px" />
                <asp:CheckBox ID="DisableLocalUploader"  runat="server" Checked="True"
                    Text="Web Browser - Disable Local Uploader" meta:resourcekey="DisableLocalUploaderResource1" 
                     />

                <br style="line-height: 3px" />
                <asp:CheckBox ID="TabedUserMgr"  runat="server"  Visible="false"
                    Text="Enable Tabbed-Browsing in User Manager" 
                    meta:resourcekey="TabedUserMgr" />
                    <br style="line-height: 3px" />
                <asp:CheckBox ID="SearchOnlyUserMgr"  runat="server" 
                    Text="Only show search interface in User Manager" meta:resourcekey="SearchOnlyUserMgrResource1" 
                     />
                     
                <br style="line-height: 3px" />
                <asp:CheckBox ID="NoTopWebPanel" runat="server" Visible="False"
                    Text="Don't show top help panel in web portal" 
                    meta:resourcekey="NoTopWebPanel" /><br />
                <asp:CheckBox ID="ShowTutorForSubUser" runat="server" 
                    Text="Show tutorial page for non-admin user" meta:resourcekey="ShowTutorForSubUserResource1" 
                     />
                <br style="line-height: 3px" />
                <asp:CheckBox ID="ShowPubAdvMode" runat="server" 
                    Text="Show advanced setting in team folder publishing dialog" meta:resourcekey="ShowPubAdvModeResource1"  
                     /><br />

            </td>
        </tr>
    </table>
    <table id='group4' width="100%" >
        <tr>
            <td>
                <br style="line-height: 3px" />
                <asp:CheckBox ID="AddShortCutToDocuments" runat="server" Checked="True" 
                    meta:resourceKey="AddShortCutToDocumentsResource1" 
                    Text="Create shortcut in documents library" />
                <br />
                <p style="line-height: 16px; font-size: 12px; color: #808080; margin-left: 16px;">
                    <asp:Localize ID="Localize7" runat="server" meta:resourceKey="asp_string9" Text="When set, the windows client will create a shortcut to the mapped drive in documents
                        library"></asp:Localize>
                </p>
                <asp:CheckBox ID="AddShortCutToDesktop" runat="server" Checked="True" 
                    meta:resourceKey="AddShortCutToDesktop" Text="Create shortcut on Desktop" />
                <br />
                <p style="line-height: 16px; font-size: 12px; color: #808080; margin-left: 16px;">
                    <asp:Localize ID="AddShortCutToDesktopDesc" meta:resourcekey="string24" 
                        runat="server" 
                        Text="When set, the windows client will create a shortcut to the mapped drive on desktop"></asp:Localize></p>

                <br style="line-height: 3px" />
                <asp:CheckBox ID="DisableSettings"  runat="server" 
                    Text="Hide Settings in Windows Client Management Console" 
                    meta:resourcekey="DisableSettings" />
                <br style="line-height: 3px" />
                <asp:CheckBox ID="DisableSettingsChange"  runat="server" 
                    Text="Don't Allow Setting Changes in Windows Client Management Console" meta:resourcekey="DisableSettingsChangeResource1" 
                     />

                <br />
                


                

                <asp:CheckBox ID="NoDDUpload" runat="server" 
                    Text="Disable Windows client inplace drag & drop upload" meta:resourcekey="NoDDUploadResource1" 
                     /><br />
                <asp:CheckBox ID="NoAutoLogon" runat="server" 
                    Text="Disable 'Auto-Login next time'" meta:resourcekey="NoAutoLogonResource1" 
                     />

                <br style="line-height: 3px" />
                <asp:CheckBox ID="DisableDDHandler" runat="server" 
                    Text="Disable drag & drop handler" 
                    meta:resourcekey="DisableDDHandlerResource1" /><br />

                <p style="line-height: 16px; font-size: 12px; color: #808080; margin-left: 16px;">
                    <asp:Localize ID="Localize8" meta:resourcekey="asp_string10" runat="server" Text="When set, drag &amp; drop files(or folders) to cloud drive will write files to local
                        cache first, and then upload in background"></asp:Localize></p>

                <br/>                        
                
                <asp:CheckBox ID="EnableOutlookAddin" runat="server" 
                    Text="Enable auto-install of Outlook Plugin" meta:resourcekey="EnableOutlookAddinResource1" 
                     /><br />
              
                <br style="line-height: 5px" />
            </td>
        </tr>
        </table>
            <table id="group5" width="100%">
            <tr>
                <td>
                
                <asp:CheckBox ID="DisableAttach" runat="server" 
                    Text="Disable backup/attach local folder from client device" 
                    meta:resourcekey="DisableAttachResource1" /><br />
                <p style="line-height: 16px; font-size: 12px; color: #808080; margin-left: 16px;">
                    <asp:Localize ID="Localize9" meta:resourcekey="asp_string6" runat="server" Text="When set, the functionality of backup or attaching local folder from a client device
                        is disabled"></asp:Localize></p>
                
                <asp:CheckBox ID="EnableSnapShot" runat="server" 
                    Text="Enable snapshot backup for server agent" meta:resourcekey="EnableSnapShotResource1" 
                     />
                <br style="line-height: 3px" />
                <asp:CheckBox ID="AllowProxyMode" runat="server" 
                    Text="Allow attaching folder in proxy mode" meta:resourcekey="AllowProxyModeResource1" 
                     /><br />
                     <asp:CheckBox ID="AllowEmptyFile" runat="server" 
                    Text="Allow syncing empty file" meta:resourcekey="AllowEmptyFileResource1" 
                     /><br />
            </td>
        </tr>
        </table>
    <table id='group1' width="100%" >
        <tr>
            <td>
                <p style="padding-top: 8px;">
                    <asp:Label ID="Label2" runat="server" 
                        Text="Files with following extension will be excluded from attached local folder (i.e.[.pst][.abc]):" 
                        meta:resourcekey="Label2Resource1"></asp:Label><br />
                    <asp:TextBox ID="DropExcludeList" runat="server" Width="90%" Text="[.pst][.ldb]" 
                        meta:resourcekey="DropExcludeListResource1"></asp:TextBox>
                        <br />  <br/>
                
                    
                <asp:Localize ID="Localize3" meta:resourcekey="dirlistexclude_str" runat="server" 
                        Text="Files with following extension will be excluded from directory listing (i.e.[.qbw]):"></asp:Localize>
                        <br />
                    <asp:TextBox ID="ListExcludeList" runat="server" Width="90%" meta:resourcekey="ListExcludeListResource1" 
                        ></asp:TextBox>
                        <br />  <br/>

                    <asp:Label ID="Label1" runat="server" 
                        
                        Text="Inplace editing/Preview is disabled for files with following extension (i.e.[.exe][.zip]):" meta:resourcekey="Label1Resource1" 
                        ></asp:Label><br />
                    <asp:TextBox ID="PreivewExcludeList" runat="server" Width="90%" 
                        Text="[.exe][.zip]" meta:resourcekey="PreivewExcludeListResource1" 
                        ></asp:TextBox>

                <div style="display: none">
                    <asp:Localize ID="Localize4" meta:resourcekey="asp_string11" runat="server" 
                        Text="Files Stored Locally Only (Separate by ;)"></asp:Localize>:<asp:TextBox ID="LocalOnlyList" Text="thumbs.db;desktop.ini;picasa.ini;"
                        Width="250px" runat="server" meta:resourcekey="LocalOnlyListResource1"></asp:TextBox><br />
                    <asp:Localize ID="Localize5" meta:resourcekey="asp_string12" runat="server" 
                        Text="Extensions of Files Stored Locally Only (Separate by ;)"></asp:Localize>:<asp:TextBox ID="LocalOnlyExtList"
                        Text=".lnk;" runat="server" meta:resourcekey="LocalOnlyExtListResource1"></asp:TextBox><br />
                    <asp:CheckBox ID="ShowExplorerBar" runat="server" Checked="True" Text="Show Gladinet Explorer Menu Bar"
                        Visible="False" meta:resourcekey="ShowExplorerBarResource1" /><br />
                </div>
            </td>
        </tr>
    </table>
    </asp:Panel>
        <table width="100%" id='buttons'>
        <tr>
                <td align="right" style="padding: 10px;">
                    <% if (m_CanEdit)
                       { %>
                    <asp:Button ID="ApplylNow" runat="server" Text="Apply" Font-Size="12px" Height="26px"
                        Width="128px" OnClientClick="Wait('Applying Settings');this.style.display='none'"
                        OnClick="ApplylNow_Click" meta:resourcekey="ApplylNowResource1" />&nbsp;&nbsp;&nbsp;&nbsp;
                        <% } %>
                    <asp:Button ID="CancelAChange" runat="server" Text="Cancel" Font-Size="12px" Height="26px"
                        OnClientClick="parent.closeActiveWin();return false;" Width="128px" 
                        Visible="False" meta:resourcekey="CancelAChangeResource1" />
                </td>
            </tr>
        </table>

</asp:Content>
