﻿<%@ Page Title="GDPR" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="GDPR.aspx.cs" Inherits="GladinetPayFlow.GDPR" Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .style1 {
            width: 388px;
        }

        .style2 {
            min-width: 16px;
            text-align: center;
        }

        .pricetable {
            border: 1px solid #cccccc;
        }

        .plain9BlackOnNone {
            border-bottom: 1px solid #cccccc;
            border-right: 1px solid #cccccc;
        }

        .style3 {
            border-bottom: 1px solid #cccccc;
            border-right: 1px solid #cccccc;
            width: 121px;
        }
         .panel-heading{
            height:48px;
            vertical-align:middle;
            padding:10px;
        }
    </style>
</asp:Content>

<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <div id="ConsentModal" class="modal fade" role="dialog">
        <div class="modal-dialog">


            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title"><asp:Localize meta:resourcekey="str_cstFrm" runat="server">Consent Form</asp:Localize></h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    
                </div>
                <div class="modal-body">
                    <table >
                        <tr>
                            <td style="padding:5px; font-size:16px; font-weight:100; color:#565656;"><asp:Localize meta:resourcekey="str_shwCstFrm" runat="server">Show consent form when the user logs in</asp:Localize>
                            </td>
                            <td width="50px" align="left">
                                <asp:CheckBox ID="EnableConsentForm" runat="server" />
                            </td>
                        </tr>
                        <tr>
                            <td style="padding:5px; font-size:16px; font-weight:100; color:#565656;"><asp:Localize meta:resourcekey="str_shwAlwaysCstFrm" runat="server">Always show consent form when the user logs in</asp:Localize>
                            </td>
                            <td  align="left">
                                <asp:CheckBox ID="AlwaysEnableConsentForm" runat="server" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <table width="100%">
                                    <tr>
                            <td style="padding:5px; font-size:16px; font-weight:100; color:#565656;"><asp:Localize meta:resourcekey="str_cstFrmUrl" runat="server">Consent form URL</asp:Localize>
                            </td>
                                        </tr>
                                    <tr>
                            <td>
                                <asp:TextBox ID="ConsentFormUrl" runat="server" CssClass="form-control"></asp:TextBox>
                            </td>
                                        </tr>
                                </table>
                            </td>
                        </tr>
                    </table>

                </div>
                <div class="modal-footer">
                    <asp:Button ID="ConsentFormBtn" runat="server" meta:resourcekey="str_apy" Text="Apply" CssClass="btn btn-primary gladbtn" OnClick="ConsentFormBtn_Click" />
                    <button type="button" class="btn btn-default" data-dismiss="modal"><asp:Localize meta:resourcekey="str_cls" runat="server">Close</asp:Localize></button>
                </div>
            </div>

        </div>
    </div>

    <div id="PrivacyModal" class="modal fade" role="dialog">
        <div class="modal-dialog">


            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title"><asp:Localize meta:resourcekey="str_prvPlcUrl" runat="server">'Privacy Policy' URL</asp:Localize></h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    
                </div>
                <div class="modal-body">
                    <table width="100%">
                       
                        <tr>
                            <td style="padding:5px; font-size:16px; font-weight:100; color:#565656;">
                                <asp:Localize meta:resourcekey="str_prvPlcUrlHlp" runat="server">The URL of your 'Privacy Policy' page</asp:Localize>
                            </td>
                            </tr><tr>
                            <td>
                                <asp:TextBox ID="PrivacyLink" runat="server" CssClass="form-control"></asp:TextBox>
                            </td>
                        </tr>
                    </table>

                </div>
                <div class="modal-footer">
                    <asp:Button ID="Button1" runat="server" meta:resourcekey="str_apy" Text="Apply" CssClass="btn btn-primary gladbtn" OnClick="PrivacyBtn_Click" />
                    <button type="button" class="btn btn-default" data-dismiss="modal"><asp:Localize meta:resourcekey="str_cls" runat="server">Close</asp:Localize></button>
                </div>
            </div>

        </div>
    </div>

     <div id="SettingsModal" class="modal fade" role="dialog">
        <div class="modal-dialog">


            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title"><asp:Localize meta:resourcekey="str_gdprStg" runat="server">GDPR Settings</asp:Localize></h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    
                </div>
                <div class="modal-body">
                    <table width="100%">
                       
                        <tr>
                            <td style="padding:5px; font-size:16px; font-weight:100; color:#565656;">
                               <asp:Localize meta:resourcekey="str_alwPrsDtaTag" runat="server">Allow personal data tagging</asp:Localize>
                            </td>
                            <td width="48px">
                                <asp:CheckBox ForeColor="#009000"   ID="PersonalTag"  runat="server" Text="" />
                            </td>
                            </tr>
                             <tr>
                            <td style="padding:5px; font-size:16px; font-weight:100; color:#565656;">
                                <asp:Localize meta:resourcekey="str_shwGDPCtrInUsrMnu" runat="server">Show GDPR Center in the user drop-down menu</asp:Localize>
                            </td>
                            <td width="48px">
                                <asp:CheckBox ForeColor="#009000"   ID="GDPRCenter"  runat="server" Text="" />
                            </td>
                            </tr>
                         <tr>
                            <td style="padding:5px; font-size:16px; font-weight:100; color:#565656;">
                               <asp:Localize meta:resourcekey="str_eblUsrSlfDlt" runat="server">Enable user self-deletion</asp:Localize>
                            </td>
                            <td width="48px">
                                <asp:CheckBox ForeColor="#009000"   ID="UserSelfDel"  runat="server" Text="" />
                            </td>
                            </tr>
                        <tr>
                            <td style="padding:5px; font-size:16px; font-weight:100; color:#565656;">
                               <asp:Localize meta:resourcekey="str_eblIntDtc" runat="server">Enable intrusion detection</asp:Localize>
                            </td>
                            <td width="48px">
                                <asp:CheckBox ForeColor="#009000"   ID="IntrusionDetect"  runat="server" Text="" />
                            </td>
                            </tr>
                    </table>

                </div>
                <div class="modal-footer">
                    <asp:Button ID="SettingsBtn" runat="server" meta:resourcekey="str_apy" Text="Apply" CssClass="btn btn-primary gladbtn" OnClick="SettingsBtn_Click" />
                    <button type="button" class="btn btn-default" data-dismiss="modal"><asp:Localize meta:resourcekey="str_cls" runat="server">Close</asp:Localize></button>
                </div>
            </div>

        </div>
    </div>
    <div id="main_body" style="width: 100%;">
        <table width="100%">
            <tr>
                <td align="right">

                    <asp:LinkButton ID="LinkButton1" runat="server" CssClass="btn btn-primary gladbtn" OnClick="LinkButton1_Click">
                       <i class="gladinet-icons md-32 md-dark hand" style="display:table-cell;" >µ</i>              
                    </asp:LinkButton>


                </td>
            </tr>
            <tr>
                <td style="font-size: 18px; font-weight: 100; padding: 10px; padding-top: 0px; color: #808080;">
                    <p><asp:Localize meta:resourcekey="str_intDtaPrtAndPrvPrc" runat="server">In order to meet the GDPR requirement, you will need to integrate data protection and privacy principles into every phase of product deployment and daily operations.</asp:Localize></p>  
                    <p><asp:Localize meta:resourcekey="str_lstOfActItm" runat="server">Here is the list of action items that may help you to be better prepared for the GDPR requirements. GDPR compliance does not replace your own due-diligence.</asp:Localize></p>
                </td>
            </tr>
            <tr>
                <td style="padding: 20px;">

                    <div class="card">
                        <div class="panel-heading toolnavbtn selbox" data-toggle="collapse" data-target="#genrule" style="cursor: pointer; font-size: 20px; font-weight: 100;">
                            <asp:Localize meta:resourcekey="str_cndForCst" runat="server">(Article 7) Conditions for consent</asp:Localize> 
                        </div>
                        <div id="genrule" class="collapse" style="background-color: white; padding: 10px;">
                            <table width="100%">
                                <tr>
                                    <td style="font-size: 18px; font-weight: 100; color: #404040; border-bottom: 1px solid #d0d0d0;" class="btniconcolor"><asp:Localize meta:resourcekey="str_cstMstBeClr" runat="server">Consent must be clear and distinguishable from other matters and must be provided in an intelligible and easily accessible form, using clear and plain language. It must be as easy to withdraw consent as it is to give it.</asp:Localize>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 10px; padding-bottom: 20px; font-weight: 100; font-size: 16px;">
                                        <table width="100%" class="table-striped">
                                            <tr>
                                                <td class="btniconcolor" width="150px" style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_gce" runat="server">CentreStack</asp:Localize>
                                                </td>
                                                <td style="font-size: 16px;">
                                                    <table width="100%">
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px; width: 600px;"><asp:Localize meta:resourcekey="str_enlCstFrm" runat="server">Enable Consent form</asp:Localize>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (m_ConsentForm)
                                                                { %>
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                                <%}
                                                                else
                                                                { %>
                                                                <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                                <%}%>

                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (!m_ConsentForm)
                                                                { %>
                                                                    <asp:Localize meta:resourcekey="str_cstFrmNotEnl" runat="server">Consent form is not enabled</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                            <td align="right" style="padding-right: 5px; font-weight: 100;">
                                                                <span class="btn btn-primary gladbtn" style="font-weight: 100!important;" data-toggle="modal" data-target="#ConsentModal"><asp:Localize meta:resourcekey="str_edt" runat="server">Edit</asp:Localize></span>

                                                            </td>

                                                            
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px; width: 600px;"><asp:Localize meta:resourcekey="str_pvdPrvPlc" runat="server">Provide Privacy Policy</asp:Localize>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (m_Privacy)
                                                                { %>
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                                <%}
                                                                else
                                                                { %>
                                                                <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                                <%}%>

                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (!m_Privacy)
                                                                { %>
                                                                    <asp:Localize meta:resourcekey="str_prvPlcLnkNotCfg" runat="server">"Privacy Policy" link is not configured.</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                            <td align="right" style="padding-right: 5px; font-weight: 100;">
                                                                
                                                                <span class="btn btn-primary gladbtn" style="font-weight: 100!important;" data-toggle="modal" data-target="#PrivacyModal"><asp:Localize meta:resourcekey="str_edt" runat="server">Edit</asp:Localize></span>
                                                        </tr>

                                                    </table>
                                                </td>
                                            </tr>

                                            <tr style="padding-top: 10px;">
                                                <td class="btniconcolor" style="font-size: 16px; padding: 3px;">
                                                <asp:Localize meta:resourcekey="str_hstPvr" runat="server">Hosting Provider</asp:Localize></td>
                                                <td style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_cstCstFrm" runat="server">Customize the consent form and provide privacy policy that meet GDPR requirement.</asp:Localize>
                                                </td>
                                            </tr>

                                        </table>
                                    </td>
                                </tr>

                            </table>


                        </div>
                    </div>
                    <div style="height: 10px"></div>
                    <div class="card">
                        <div class="panel-heading toolnavbtn selbox" data-toggle="collapse" data-target="#adminguard" style="cursor: pointer; font-size: 18px; font-weight: 100;">
                             <asp:Localize meta:resourcekey="str_prcOfSpcCtgPsnDta" runat="server">(Article 9) Processing of special categories of personal data</asp:Localize>
                        </div>
                        <div id="adminguard" class="collapse" style="background-color: white; padding: 10px;">
                            <table width="100%">
                                <tr>
                                    <td style="font-size: 18px; font-weight: 100; color: #404040; border-bottom: 1px solid #d0d0d0;" class="btniconcolor"><asp:Localize meta:resourcekey="str_prcPsnAndChdPsnDta" runat="server">Processing personal and children's personal data</asp:Localize> 
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 10px; padding-bottom: 20px; font-weight: 100; font-size: 16px;">
                                        <table width="100%" class="table-striped">
                                            <tr>
                                                <td class="btniconcolor" width="150px" style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_gce" runat="server">CentreStack</asp:Localize>
                                                </td>
                                                <td style="font-size: 16px;">
                                                    <table width="100%">
                                                         <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px; width: 600px;"><asp:Localize meta:resourcekey="str_enbDARE" runat="server">Enable Data-At-Rest Encryption</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                              
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                              
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                              <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_enlHtpTrs" runat="server">Enable HTTPS transmission</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (m_SSL)
                                                                { %>
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                                <%}
                                                                else
                                                                { %>
                                                                <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (!m_SSL)
                                                                { %>
                                                                <asp:Localize meta:resourcekey="str_extUrlOrFrcSSLNotEnl" runat="server">External URL is not configured with HTTPS, or the Force SSL setting is not enabled.</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_enlTfrThrWkrNde" runat="server">Enable Upload/Download must be via worker node</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (m_ViaWorkerNode)
                                                                { %>
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                                <%}
                                                                else
                                                                { %>
                                                                <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (!m_ViaWorkerNode)
                                                                { %>
                                                                    <asp:Localize meta:resourcekey="str_chgStgInGrpPlcSec" runat="server">Change setting in Group Policy -> Security.</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_enlVsnCtl" runat="server">Enable Version-Control</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_enlAntVrsItg" runat="server">Enable Anti-virus integration</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (m_AV)
                                                                { %>
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                                <%}
                                                                else
                                                                { %>
                                                                <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (!m_AV)
                                                                { %>
                                                                    <asp:Localize meta:resourcekey="str_antVrsNotEnl" runat="server">Anti-virus is not enabled</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">

                                                            <td style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_enlRswPrt" runat="server">Enable Ransomware protection</asp:Localize></td>

                                                            <td style="font-size: 16px; padding: 3px;">
                                                               
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                               
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                               <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_enlPsnDtaTag" runat="server">Enable personal data tagging</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (m_PersonalTag)
                                                                { %>
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                                <%}
                                                                else
                                                                { %>
                                                                <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (!m_PersonalTag)
                                                                { %>
                                                               <asp:Localize meta:resourcekey="str_psnDtaTagIsNotEnl" runat="server">Personal data tagging is not enabled</asp:Localize>
                                                                    
                                                                <%}%>
                                                            </td>
                                                                                                                        <td align="right" style="padding-right: 5px; font-weight: 100;">
                                                                <span class="btn btn-primary gladbtn" style="font-weight: 100!important;" data-toggle="modal" data-target="#SettingsModal"><asp:Localize meta:resourcekey="str_edt" runat="server">Edit</asp:Localize></span>

                                                            </td>

                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_enlcheEcr" runat="server">Enable local cache encryption</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                               
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                               
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                               <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </td>
                                            </tr>

                                            <tr style="padding-top: 10px;">
                                                <td class="btniconcolor" style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_hstPvr" runat="server">Hosting Provider</asp:Localize>
                                                </td>
                                                <td style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_edcCstPrv" runat="server">Educate customers about the privacy and data protection features included.</asp:Localize>
                                                </td>
                                            </tr>

                                        </table>
                                    </td>
                                </tr>

                            </table>
                        </div>
                    </div>
                    <div style="height: 10px"></div>

                    <div class="card">
                        <div class="panel-heading toolnavbtn selbox" data-toggle="collapse" data-target="#phyguards" style="cursor: pointer; font-weight: 100; font-size: 18px;">
                           <asp:Localize meta:resourcekey="str_trpIfnCmtMds" runat="server">(Article 12) Transparent information, communication and modalities for the exercise of the rights of the data subject</asp:Localize>
                        </div>
                        <div id="phyguards" class="collapse" style="background-color: white; padding: 10px;">
                            <table width="100%">
                                <tr sty>
                                    <td style="font-size: 18px; font-weight: 100; color: #404040; border-bottom: 1px solid #d0d0d0;" class="btniconcolor"><asp:Localize meta:resourcekey="str_dtaPrvPlcShdPrsEchUsr" runat="server">Data privacy policy that should be presented to each user of the system</asp:Localize>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 10px; padding-bottom: 20px; font-weight: 100; font-size: 16px;">
                                        <table width="100%" class="table-striped">
                                            <tr>
                                                <td class="btniconcolor" width="150px" style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_gce" runat="server">CentreStack</asp:Localize>
                                                </td>
                                                <td style="font-size: 16px;">
                                                    <table width="100%">
                                                         <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px; width: 600px;"><asp:Localize meta:resourcekey="str_enlCstFrm" runat="server">Enable Consent form</asp:Localize>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (m_ConsentForm)
                                                                { %>
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                                <%}
                                                                else
                                                                { %>
                                                                <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                                <%}%>

                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (!m_ConsentForm)
                                                                { %>
                                                                    <asp:Localize meta:resourcekey="str_cstFrmNotEnl" runat="server">Consent form is not enabled</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                            <td align="right" style="padding-right: 5px; font-weight: 100;">
                                                                <span class="btn btn-primary gladbtn" style="font-weight: 100!important;" data-toggle="modal" data-target="#ConsentModal"><asp:Localize meta:resourcekey="str_edt" runat="server">Edit</asp:Localize></span>

                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px; width: 600px;"><asp:Localize meta:resourcekey="str_pvdPrvPlc" runat="server">Provide Privacy Policy</asp:Localize>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (m_Privacy)
                                                                { %>
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                                <%}
                                                                else
                                                                { %>
                                                                <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                                <%}%>

                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (!m_Privacy)
                                                                { %>
                                                                    <asp:Localize meta:resourcekey="str_prvPlcLnkNotCfg" runat="server">"Privacy Policy" link is not configured.</asp:Localize> 
                                                                <%}%>
                                                            </td>
                                                            <td align="right" style="padding-right: 5px; font-weight: 100;">
                                                                
                                                                <span class="btn btn-primary gladbtn" style="font-weight: 100!important;" data-toggle="modal" data-target="#PrivacyModal"><asp:Localize meta:resourcekey="str_edt" runat="server">Edit</asp:Localize></span>
                                                        </tr>

                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px; width: 600px;"><asp:Localize meta:resourcekey="str_cfgSmt" runat="server">Configure SMTP Service</asp:Localize>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (m_DareSet)
                                                                { %>
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                                <%}
                                                                else
                                                                { %>
                                                                <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                                <%}%>

                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (!m_DareSet)
                                                                { %>
                                                                    <asp:Localize meta:resourcekey="str_smtNotEnl" runat="server">SMTP service is not enabled. Emails may be sent via CentreStack email service.</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px; width: 600px;"><asp:Localize meta:resourcekey="str_shwGDPCtrInUsrMnu" runat="server">Show GDPR Center in the user drop-down menu</asp:Localize>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (m_GDPRCenter)
                                                                { %>
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                                <%}
                                                                else
                                                                { %>
                                                                <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                                <%}%>

                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (!m_GDPRCenter)
                                                                { %>
                                                                    <asp:Localize meta:resourcekey="str_stgIsNotEbl" runat="server">Setting is not enabled.</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                             <td align="right" style="padding-right: 5px; font-weight: 100;">
                                                                <span class="btn btn-primary gladbtn" style="font-weight: 100!important;" data-toggle="modal" data-target="#SettingsModal"><asp:Localize meta:resourcekey="str_edt" runat="server">Edit</asp:Localize></span>

                                                            </td>
                                                        </tr>
                                                    </table>
                                                </td>
                                            </tr>

                                            <tr style="padding-top: 10px;">
                                                <td class="btniconcolor" style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_hstPvr" runat="server">Hosting Provider</asp:Localize>
                                                </td>
                                                <td style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_cstCstFrm" runat="server">Customize the consent form and provide privacy policy that meet GDPR requirement.</asp:Localize>
                                                </td>
                                            </tr>

                                        </table>
                                    </td>
                                </tr>


                            </table>
                        </div>
                    </div>
                    <div style="height: 10px"></div>

                    <div class="card">
                        <div class="panel-heading toolnavbtn selbox" data-toggle="collapse" data-target="#tecguards" style="cursor: pointer; font-weight: 100; font-size: 18px;">
                             <asp:Localize meta:resourcekey="str_infPrvPsnDta" runat="server">(Article 13) Information to be provided where personal data are collected from the data subject</asp:Localize>
                        </div>
                        <div id="tecguards" class="collapse" style="background-color: white; padding: 10px;">

                            <table width="100%">
                                <tr>
                                    <td style="font-size: 18px; font-weight: 100; color: #404040; border-bottom: 1px solid #d0d0d0;" class="btniconcolor"><asp:Localize meta:resourcekey="str_cstMstBeClr" runat="server">Consent must be clear and distinguishable from other matters and must be provided in an intelligible and easily accessible form, using clear and plain language. It must be as easy to withdraw consent as it is to give it.</asp:Localize>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 10px; padding-bottom: 20px; font-weight: 100; font-size: 16px;">
                                        <table width="100%" class="table-striped">
                                            <tr>
                                                <td class="btniconcolor" width="150px" style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_gce" runat="server">CentreStack</asp:Localize>
                                                </td>
                                                <td style="font-size: 16px;">
                                                    <table width="100%">
                                                         <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px; width: 600px;"><asp:Localize meta:resourcekey="str_enlCstFrm" runat="server">Enable Consent form</asp:Localize>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (m_ConsentForm)
                                                                { %>
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                                <%}
                                                                else
                                                                { %>
                                                                <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                                <%}%>

                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (!m_ConsentForm)
                                                                { %>
                                                                    <asp:Localize meta:resourcekey="str_cstFrmNotEnl" runat="server">Consent form is not enabled</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                            <td align="right" style="padding-right: 5px; font-weight: 100;">
                                                                <span class="btn btn-primary gladbtn" style="font-weight: 100!important;" data-toggle="modal" data-target="#ConsentModal"><asp:Localize meta:resourcekey="str_edt" runat="server">Edit</asp:Localize></span>

                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px; width: 600px;"><asp:Localize meta:resourcekey="str_pvdPrvPlc" runat="server">Provide Privacy Policy</asp:Localize>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (m_Privacy)
                                                                { %>
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                                <%}
                                                                else
                                                                { %>
                                                                <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                                <%}%>

                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (!m_Privacy)
                                                                { %>
                                                                    <asp:Localize meta:resourcekey="str_prvPlcLnkNotCfg" runat="server">"Privacy Policy" link is not configured.</asp:Localize> 
                                                                <%}%>
                                                            </td>
                                                            <td align="right" style="padding-right: 5px; font-weight: 100;">
                                                                
                                                                <span class="btn btn-primary gladbtn" style="font-weight: 100!important;" data-toggle="modal" data-target="#PrivacyModal"><asp:Localize meta:resourcekey="str_edt" runat="server">Edit</asp:Localize></span>
                                                        </tr>

                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px; width: 600px;"><asp:Localize meta:resourcekey="str_shwGDPCtrInUsrMnu" runat="server">Show GDPR Center in the user drop-down menu</asp:Localize>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (m_GDPRCenter)
                                                                { %>
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                                <%}
                                                                else
                                                                { %>
                                                                <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                                <%}%>

                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (!m_GDPRCenter)
                                                                { %>
                                                                    <asp:Localize meta:resourcekey="str_stgIsNotEbl" runat="server">Setting is not enabled.</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                             <td align="right" style="padding-right: 5px; font-weight: 100;">
                                                                <span class="btn btn-primary gladbtn" style="font-weight: 100!important;" data-toggle="modal" data-target="#SettingsModal"><asp:Localize meta:resourcekey="str_edt" runat="server">Edit</asp:Localize></span>

                                                            </td>
                                                        </tr>
                                                    </table>
                                                </td>
                                            </tr>

                                            <tr style="padding-top: 10px;">
                                                <td class="btniconcolor" style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_hstPvr" runat="server">Hosting Provider</asp:Localize>
                                                </td>
                                                <td style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_dsgPrvCtr" runat="server">Has designated privacy controller. The privacy agreement provided to the user must include contact information about the controller in the event that the end user would like to file a complaint or have their personal data removed from the system.</asp:Localize>
                                                </td>
                                            </tr>

                                        </table>
                                    </td>
                                </tr>

                            </table>
                        </div>
                    </div>
                    <div style="height: 10px"></div>
                    <div class="card">
                        <div class="panel-heading toolnavbtn selbox" data-toggle="collapse" data-target="#ar15" style="cursor: pointer; font-weight: 100; font-size: 18px;">
                            <asp:Localize meta:resourcekey="str_rgtAcsDtaSbj" runat="server">(Article 15) Right of access by the data subject</asp:Localize>
                        </div>
                        <div id="ar15" class="collapse" style="background-color: white; padding: 10px;">

                            <table width="100%">
                                <tr>
                                    <td style="font-size: 18px; font-weight: 100; color: #404040; border-bottom: 1px solid #d0d0d0;" class="btniconcolor"><asp:Localize meta:resourcekey="str_dtaSjtRgtObnCtrCnf" runat="server">The data subject shall have the right to obtain from the controller confirmation as to whether or not personal data concerning him or her are being processed...</asp:Localize>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 10px; padding-bottom: 20px; font-weight: 100; font-size: 16px;">
                                        <table width="100%" class="table-striped">
                                            <tr>
                                                <td class="btniconcolor" width="150px" style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_gce" runat="server">CentreStack</asp:Localize>
                                                </td>
                                                <td style="font-size: 16px;">
                                                    <table width="100%">

                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px; width: 600px;"><asp:Localize meta:resourcekey="str_shwGDPCtrInUsrMnu" runat="server">Show GDPR Center in the user drop-down menu</asp:Localize>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (m_GDPRCenter)
                                                                { %>
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                                <%}
                                                                else
                                                                { %>
                                                                <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                                <%}%>

                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (!m_GDPRCenter)
                                                                { %>
                                                                    <asp:Localize meta:resourcekey="str_stgIsNotEbl" runat="server">Setting is not enabled.</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                             <td align="right" style="padding-right: 5px; font-weight: 100;">
                                                                <span class="btn btn-primary gladbtn" style="font-weight: 100!important;" data-toggle="modal" data-target="#SettingsModal"><asp:Localize meta:resourcekey="str_edt" runat="server">Edit</asp:Localize></span>

                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_enlPsnDtaTag" runat="server">Enable personal data tagging</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (m_PersonalTag)
                                                                { %>
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                                <%}
                                                                else
                                                                { %>
                                                                <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (!m_PersonalTag)
                                                                { %>
                                                                   <asp:Localize meta:resourcekey="str_psnDtaTagIsNotEnl" runat="server">Personal data tagging is not enabled</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                                                                                        <td align="right" style="padding-right: 5px; font-weight: 100;">
                                                                <span class="btn btn-primary gladbtn" style="font-weight: 100!important;" data-toggle="modal" data-target="#SettingsModal"><asp:Localize meta:resourcekey="str_edt" runat="server">Edit</asp:Localize></span>

                                                            </td>

                                                        </tr>

                                                    </table>
                                                </td>
                                            </tr>

                                            <tr style="padding-top: 10px;">
                                                <td class="btniconcolor" style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_hstPvr" runat="server">Hosting Provider</asp:Localize>
                                                </td>
                                                <td style="font-size: 16px; padding: 3px;">
                                                    <p><asp:Localize meta:resourcekey="str_prvRsbAst" runat="server">Provide reasonable assistance to customers for accessing and exporting the personal data they store in the product.</asp:Localize></p> 
                                                    <p><asp:Localize meta:resourcekey="str_cstDfnOwnPlc" runat="server">While customers need to define their own policies and processes to fulfill a subject access request, the product provides a number of methods to access and export personal data.</asp:Localize></p> 
                                                </td>
                                            </tr>

                                        </table>
                                    </td>
                                </tr>

                            </table>
                        </div>
                    </div>
                    <div style="height: 10px"></div>
                    <div class="card">
                        <div class="panel-heading toolnavbtn selbox" data-toggle="collapse" data-target="#ar17" style="cursor: pointer; font-weight: 100; font-size: 18px;">
                            <asp:Localize meta:resourcekey="str_rgtToErs" runat="server">(Article 17) Right to erasure</asp:Localize>
                        </div>
                        <div id="ar17" class="collapse" style="background-color: white; padding: 10px;">
                            <table width="100%">
                                <tr>
                                    <td style="font-size: 18px; font-weight: 100; color: #404040; border-bottom: 1px solid #d0d0d0;" class="btniconcolor"><asp:Localize meta:resourcekey="str_dtaSbjRgtToErs" runat="server">The data subject shall have the right to erase his or her own personal data (right to be forgotten).</asp:Localize>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 10px; padding-bottom: 20px; font-weight: 100; font-size: 16px;">
                                        <table width="100%" class="table-striped">
                                            <tr>
                                                <td class="btniconcolor" width="150px" style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_gce" runat="server">CentreStack</asp:Localize>
                                                </td>
                                                <td style="font-size: 16px;">
                                                    <table width="100%">

                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px; width: 600px;"><asp:Localize meta:resourcekey="str_shwGDPCtrInUsrMnu" runat="server">Show GDPR Center in the user drop-down menu</asp:Localize>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (m_GDPRCenter)
                                                                { %>
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                                <%}
                                                                else
                                                                { %>
                                                                <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                                <%}%>

                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (!m_GDPRCenter)
                                                                { %>
                                                                    <asp:Localize meta:resourcekey="str_stgIsNotEbl" runat="server">Setting is not enabled.</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                             <td align="right" style="padding-right: 5px; font-weight: 100;">
                                                                <span class="btn btn-primary gladbtn" style="font-weight: 100!important;" data-toggle="modal" data-target="#SettingsModal"><asp:Localize meta:resourcekey="str_edt" runat="server">Edit</asp:Localize></span>

                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_enlPsnDtaTag" runat="server">Enable personal data tagging</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (m_PersonalTag)
                                                                { %>
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                                <%}
                                                                else
                                                                { %>
                                                                <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (!m_PersonalTag)
                                                                { %>
                                                                   <asp:Localize meta:resourcekey="str_psnDtaTagIsNotEnl" runat="server">Personal data tagging is not enabled</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                                                                                        <td align="right" style="padding-right: 5px; font-weight: 100;">
                                                                <span class="btn btn-primary gladbtn" style="font-weight: 100!important;" data-toggle="modal" data-target="#SettingsModal"><asp:Localize meta:resourcekey="str_edt" runat="server">Edit</asp:Localize></span>

                                                            </td>

                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_enlSlfDlt" runat="server">Enable self-deletion</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (m_UserSelfDel)
                                                                { %>
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                                <%}
                                                                else
                                                                { %>
                                                                <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (!m_UserSelfDel)
                                                                { %>
                                                                   <asp:Localize meta:resourcekey="str_slfDltIsNotEnl" runat="server">Self-deletion is not enabled</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                             <td align="right" style="padding-right: 5px; font-weight: 100;">
                                                                <span class="btn btn-primary gladbtn" style="font-weight: 100!important;" data-toggle="modal" data-target="#SettingsModal"><asp:Localize meta:resourcekey="str_edt" runat="server">Edit</asp:Localize></span>

                                                            </td>

                                                        </tr>
                                                        
                                                    </table>
                                                </td>
                                            </tr>

                                            <tr style="padding-top: 10px;">
                                                <td class="btniconcolor" style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_hstPvr" runat="server">Hosting Provider</asp:Localize>
                                                </td>
                                                <td style="font-size: 16px; padding: 3px;"><p><asp:Localize meta:resourcekey="str_prvRsbAst" runat="server">Provide reasonable assistance to customers for accessing and exporting the personal data they store in the product.</asp:Localize></p>
                                                    <p><asp:Localize meta:resourcekey="str_cstDfnOwnPlc" runat="server">While customers need to define their own policies and processes to fulfill a subject access request, the product provides a number of methods to access and export personal data.</asp:Localize></p>
                                                </td>
                                            </tr>

                                        </table>
                                    </td>
                                </tr>

                            </table>

                        </div>
                    </div>
                    <div style="height: 10px"></div>
                    <div class="card" >
                        <div class="panel-heading toolnavbtn selbox" data-toggle="collapse" data-target="#ar25" style="cursor: pointer; font-weight: 100; font-size: 18px;">
                            <asp:Localize meta:resourcekey="str_dtaPrtByDsg" runat="server">(Article 25) Data protection by design</asp:Localize>
                        </div>
                        <div id="ar25" class="collapse" style="background-color: white; padding: 10px;">
                            <table width="100%">
                                <tr>
                                    <td style="font-size: 18px; font-weight: 100; color: #404040; border-bottom: 1px solid #d0d0d0;" class="btniconcolor">
                                        <asp:Localize meta:resourcekey="str_esrCfdItgAvb" runat="server">Ensure the confidentiality, integrity, and availability of all file data they create, receive, maintain or transmit.</asp:Localize>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 10px; padding-bottom: 20px; font-weight: 100; font-size: 16px;">
                                        <table width="100%" class="table-striped">
                                            <tr>
                                                <td class="btniconcolor" width="150px" style="font-size: 16px; padding: 3px;">
                                                    <asp:Localize meta:resourcekey="str_gce" runat="server">CentreStack</asp:Localize>
                                                </td>
                                                <td style="font-size: 16px;">
                                                    <table width="100%">
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px; width: 600px;">
                                                                <asp:Localize meta:resourcekey="str_enbDARE" runat="server">Enable Data-At-Rest Encryption</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">

                                                                <span class="fa fa-check" style="color: #008000;"></span>

                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_enlHtpTrs" runat="server">Enable HTTPS transmission</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (m_SSL)
                                                                    { %>
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                                <%}
                                                                    else
                                                                    { %>
                                                                <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (!m_SSL)
                                                                    { %>
                                                                <asp:Localize meta:resourcekey="str_extUrlOrFrcSSLNotEnl" runat="server">External URL is not configured with HTTPS, or the Force SSL setting is not enabled.</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_enlTfrThrWkrNde" runat="server">Enable Upload/Download must be via worker node</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (m_ViaWorkerNode)
                                                                    { %>
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                                <%}
                                                                    else
                                                                    { %>
                                                                <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (!m_ViaWorkerNode)
                                                                    { %>
                                                                <asp:Localize meta:resourcekey="str_chgStgInGrpPlcSec" runat="server">Change setting in Group Policy -> Security.</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_enlVsnCtl" runat="server">Enable Version-Control</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_enlAntVrsItg" runat="server">Enable Anti-virus integration</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (m_AV)
                                                                    { %>
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                                <%}
                                                                    else
                                                                    { %>
                                                                <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (!m_AV)
                                                                    { %>
                                                                <asp:Localize meta:resourcekey="str_antVrsNotEnl" runat="server">Anti-virus is not enabled</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">

                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_enlRswPrt" runat="server">Enable Ransomware protection</asp:Localize></td>

                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>

                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_enlcheEcr" runat="server">Enable local cache encryption</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">

                                                                <span class="fa fa-check" style="color: #008000;"></span>

                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_enlEdpPrt" runat="server">Enable "Endpoint Protection"</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px; width: 600px;">
                                                                <asp:Localize meta:resourcekey="str_PutCsDmz" runat="server">Put CentreStack in the DMZ, behind a firewall</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (m_DMZ)
                                                                    { %>
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                                <%}
                                                                    else
                                                                    { %>
                                                                <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (!m_EPProtect)
                                                                    { %>
                                                                <asp:Localize meta:resourcekey="str_cntVryDmz" runat="server">We cannot verify if the server is in the DMZ.</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_enlPwdPlc" runat="server">Enable password policy</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (m_Pwd)
                                                                    { %>
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                                <%}
                                                                    else
                                                                    { %>
                                                                <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (!m_Pwd)
                                                                    { %>
                                                                <asp:Localize meta:resourcekey="str_pwdPlcNotEnl" runat="server">"Password policy" is not enabled for one or more tenants</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_efcTwoStpVfn" runat="server">Enforce 2-Step Verification</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_enlItrDtcAndAlt" runat="server">Enable intrusion detection and alerting</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (m_Intru)
                                                                    { %>
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                                <%}
                                                                    else
                                                                    { %>
                                                                <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (!m_Intru)
                                                                    { %>
                                                                <asp:Localize meta:resourcekey="str_itrDtcAndAltNotEnl" runat="server">"intrusion detection and alerting" is not enabled</asp:Localize>

                                                                <%}%>
                                                            </td>
                                                            <td align="right" style="padding-right: 5px; font-weight: 100;">
                                                                <span class="btn btn-primary gladbtn" style="font-weight: 100!important;" data-toggle="modal" data-target="#SettingsModal">
                                                                    <asp:Localize meta:resourcekey="str_edt" runat="server">Edit</asp:Localize></span>

                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_rlebsdAcs" runat="server">Enable "Role-based access"</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px; width: 600px;">
                                                                <asp:Localize meta:resourcekey="str_enlPlcSndEmlNtfWhnLgnIn" runat="server">Enable Policy "Send email notification when logging in from a new location/device"</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_enlActLgnPrtPlc" runat="server">Enable account login protection policy</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_enlStgShrPlc" runat="server">Enable strong sharing policy</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_enlMinSetOfFldPrm" runat="server">Enable minimal set of folder permissions</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_hdeFldUsrDntHvePrm" runat="server">Hide the folder that user doesn't have permissions for</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_lmtAcsOfCrtInfBsdOnLct" runat="server">Limited access of critical information based on location</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_lvgSecDtaRom" runat="server">Leverage secure data room feature</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </td>
                                            </tr>

                                            <tr style="padding-top: 10px;">
                                                <td class="btniconcolor" style="font-size: 16px; padding: 3px;">
                                                    <asp:Localize meta:resourcekey="str_hstPvr" runat="server">Hosting Provider</asp:Localize>
                                                </td>
                                                <td style="font-size: 16px; padding: 3px;">
                                                    <asp:Localize meta:resourcekey="str_usrRspHowCntMng" runat="server">Users are responsible for how content is managed through the Solution. Organizations should periodically review their use and configuration of the Solution to validate data protection has been taken into account by design.</asp:Localize>
                                                </td>
                                            </tr>

                                        </table>
                                    </td>
                                </tr>


                            </table>

                        </div>
                    </div>

                    <div style="height: 10px"></div>
                    <div class="card">
                        <div class="panel-heading toolnavbtn selbox" data-toggle="collapse" data-target="#ar30" style="cursor: pointer; font-weight: 100; font-size: 18px;">
                             <asp:Localize meta:resourcekey="str_psnDtaInv" runat="server">(Article 30) Personal data inventory</asp:Localize>
                        </div>
                        <div id="ar30" class="collapse" style="background-color: white; padding: 10px;">
                            <table width="100%">
                                <tr>
                                    <td style="font-size: 18px; font-weight: 100; color: #404040; border-bottom: 1px solid #d0d0d0;" class="btniconcolor"></td>
                                </tr>
                                <tr>
                                    <td style="padding: 10px; padding-bottom: 20px; font-weight: 100; font-size: 16px;">
                                        <table width="100%" class="table-striped">
                                            <tr>
                                                <td class="btniconcolor" width="150px" style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_gce" runat="server">CentreStack</asp:Localize>
                                                </td>
                                                <td style="font-size: 16px;">
                                                    <table width="100%">

                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px; width: 600px;"><asp:Localize meta:resourcekey="str_shwGDPCtrInUsrMnu" runat="server">Show GDPR Center in the user drop-down menu</asp:Localize>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (m_GDPRCenter)
                                                                { %>
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                                <%}
                                                                else
                                                                { %>
                                                                <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                                <%}%>

                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (!m_GDPRCenter)
                                                                { %>
                                                                    <asp:Localize meta:resourcekey="str_stgIsNotEbl" runat="server">Setting is not enabled.</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                             <td align="right" style="padding-right: 5px; font-weight: 100;">
                                                                <span class="btn btn-primary gladbtn" style="font-weight: 100!important;" data-toggle="modal" data-target="#SettingsModal"><asp:Localize meta:resourcekey="str_edt" runat="server">Edit</asp:Localize></span>

                                                            </td>
                                                        </tr>
                                                       <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_enlPsnDtaTag" runat="server">Enable personal data tagging</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (m_PersonalTag)
                                                                { %>
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                                <%}
                                                                else
                                                                { %>
                                                                <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (!m_PersonalTag)
                                                                { %>
                                                                <asp:Localize meta:resourcekey="str_psnDtaTagIsNotEnl" runat="server">Personal data tagging is not enabled</asp:Localize>
                                                                    
                                                                <%}%>
                                                            </td>
                                                                                                                        <td align="right" style="padding-right: 5px; font-weight: 100;">
                                                                <span class="btn btn-primary gladbtn" style="font-weight: 100!important;" data-toggle="modal" data-target="#SettingsModal"><asp:Localize meta:resourcekey="str_edt" runat="server">Edit</asp:Localize></span>

                                                            </td>

                                                        </tr>
                                                    </table>
                                                </td>
                                            </tr>

                                            <tr style="padding-top: 10px;">
                                                <td class="btniconcolor" style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_hstPvr" runat="server">Hosting Provider</asp:Localize>
                                                </td>
                                                <td style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_lvgExtFtr" runat="server">Leverage existing features, and train users on how to tag personal data if they need to.</asp:Localize>
                                                </td>
                                            </tr>

                                        </table>
                                    </td>
                                </tr>

                            </table>

                        </div>
                    </div>

                    <div style="height: 10px"></div>
                    <div class="card">
                        <div class="panel-heading toolnavbtn selbox" data-toggle="collapse" data-target="#ar32" style="cursor: pointer; font-weight: 100; font-size: 18px"> <asp:Localize runat="server" meta:resourcekey="str_art32SecPrc">(Article 32) Security of processing</asp:Localize>
                        </div>
                        <div id="ar32" class="collapse" style="background-color: white; padding: 10px;">

                            <table width="100%">
                                <tr>
                                    <td style="font-size: 18px; font-weight: 100; color: #404040; border-bottom: 1px solid #d0d0d0;" class="btniconcolor"><asp:Localize meta:resourcekey="str_esrCfdItgAvb" runat="server">Ensure the confidentiality, integrity, and availability of all file data they create, receive, maintain or transmit.</asp:Localize>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 10px; padding-bottom: 20px; font-weight: 100; font-size: 16px;">
                                        <table width="100%" class="table-striped">
                                            <tr>
                                                <td class="btniconcolor" width="150px" style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_gce" runat="server">CentreStack</asp:Localize>
                                                </td>
                                                <td style="font-size: 16px;">
                                                    <table width="100%">
                                                         <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px; width: 600px;"><asp:Localize meta:resourcekey="str_enbDARE" runat="server">Enable Data-At-Rest Encryption</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                              
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                              
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                              <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_enlHtpTrs" runat="server">Enable HTTPS transmission</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (m_SSL)
                                                                { %>
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                                <%}
                                                                else
                                                                { %>
                                                                <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (!m_SSL)
                                                                { %>
                                                                    <asp:Localize meta:resourcekey="str_extUrlOrFrcSSLNotEnl" runat="server">External URL is not configured with HTTPS, or the Force SSL setting is not enabled.</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_enlTfrThrWkrNde" runat="server">Enable Upload/Download must be via worker node</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (m_ViaWorkerNode)
                                                                { %>
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                                <%}
                                                                else
                                                                { %>
                                                                <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (!m_ViaWorkerNode)
                                                                { %>
                                                                   <asp:Localize meta:resourcekey="str_chgStgInGrpPlcSec" runat="server">Change setting in Group Policy -> Security.</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_enlVsnCtl" runat="server">Enable Version Control</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                               <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_enlAntVrsItg" runat="server">Enable Anti-virus integration</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (m_AV)
                                                                { %>
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                                <%}
                                                                else
                                                                { %>
                                                                <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                                <%}%>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <%if (!m_AV)
                                                                { %>
                                                                    <asp:Localize meta:resourcekey="str_antVrsNotEnl" runat="server">Anti-virus is not enabled</asp:Localize>
                                                                <%}%>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">

                                                            <td style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_enlRswPrt" runat="server">Enable Ransomware protection</asp:Localize></td>

                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                               <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                         <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_enlcheEcr" runat="server">Enable local cache encryption</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                               
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                               
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                               <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                            <td style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_enlEdpPrt" runat="server">Enable "Endpoint Protection"</asp:Localize></td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <span class="fa fa-check" style="color: #008000;"></span>
                                                            </td>
                                                            <td style="font-size: 16px; padding: 3px;">
                                                                <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                            </td>
                                                        </tr>



                                                    </table>
                                                </td>
                                            </tr>

                                            <tr style="padding-top: 10px;">
                                                <td class="btniconcolor" style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_hstPvr" runat="server">Hosting Provider</asp:Localize>
                                                </td>
                                                <td style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_rspEsrEcr" runat="server">Responsible for ensuring the encryption meets their requirements.</asp:Localize> 
                                                </td>
                                            </tr>

                                        </table>
                                    </td>
                                </tr>


                            </table>
                        </div>
                    </div>

                    <div style="height: 10px"></div>
                    <div class="card">
                        <div class="panel-heading toolnavbtn selbox" data-toggle="collapse" data-target="#ar35" style="cursor: pointer; font-weight: 100; font-size: 18px;">
                            <asp:Localize meta:resourcekey="str_dtaPrtIptAst" runat="server">(Article 35) Data protection impact assessment</asp:Localize>
                        </div>
                        <div id="ar35" class="collapse" style="background-color: white; padding: 10px;">

                            <table width="100%" class="table-striped">
                                <tr>
                                    <td class="btniconcolor" width="150px" style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_gce" runat="server">CentreStack</asp:Localize>
                                    </td>
                                    <td style="font-size: 16px;">
                                        <table width="100%" style="padding: 10px; padding-bottom: 20px; font-weight: 100; font-size: 16px;">
                                            <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                <td style="font-size: 16px; padding: 3px; width: 600px;"><asp:Localize meta:resourcekey="str_stpAdtRetPlc" runat="server">Setup audit retention policy that meets the policy</asp:Localize></td>
                                                <td style="font-size: 16px; padding: 3px;">
                                                    <span class="fa fa-check" style="color: #008000;"></span>
                                                </td>
                                                <td style="font-size: 16px; padding: 3px;">
                                                   <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                </td>
                                            </tr>
                                            <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                <td style="font-size: 16px; padding: 3px; width: 600px;"><asp:Localize meta:resourcekey="str_stpFilChgLogRetPlc" runat="server">Setup file change log retention policy that meets the policy</asp:Localize></td>
                                                <td style="font-size: 16px; padding: 3px;">
                                                   <span class="fa fa-check" style="color: #008000;"></span>
                                                </td>
                                                <td style="font-size: 16px; padding: 3px;">
                                                   <asp:Localize meta:resourcekey="str_ftrPvdCfgAtTntLvl" runat="server">Feature provided, configure at tenant level</asp:Localize>
                                                </td>
                                            </tr>

                                            <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                <td style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_splDbAdtChgLog" runat="server">Split database for audit and change logs</asp:Localize></td>
                                                <td style="font-size: 16px; padding: 3px;">
                                                    <%if (m_SplitDB)
                                                    { %>
                                                    <span class="fa fa-check" style="color: #008000;"></span>
                                                    <%}
                                                    else
                                                    { %>
                                                    <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                    <%}%>
                                                </td>
                                                <td style="font-size: 16px; padding: 3px;">
                                                    <%if (!m_SplitDB)
                                                    { %>
                                                                    <asp:Localize meta:resourcekey="str_lgnDbNotIst" runat="server">Logging database is not isolated and SQL Express is used.</asp:Localize>
                                                                <%}%>
                                                </td>
                                            </tr>
                                            <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                <td style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_enlPsnDtaTag" runat="server">Enable personal data tagging</asp:Localize></td>
                                                <td style="font-size: 16px; padding: 3px;">
                                                    <%if (m_PersonalTag)
                                                    { %>
                                                    <span class="fa fa-check" style="color: #008000;"></span>
                                                    <%}
                                                    else
                                                    { %>
                                                    <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                    <%}%>
                                                </td>
                                                <td style="font-size: 16px; padding: 3px;">
                                                    <%if (!m_PersonalTag)
                                                    { %>
                                                                <asp:Localize meta:resourcekey="str_psnDtaTagIsNotEnl" runat="server">Personal data tagging is not enabled</asp:Localize>
                                                                <%}%>
                                                </td>
                                                                                                            <td align="right" style="padding-right: 5px; font-weight: 100;">
                                                                <span class="btn btn-primary gladbtn" style="font-weight: 100!important;" data-toggle="modal" data-target="#SettingsModal"><asp:Localize meta:resourcekey="str_edt" runat="server">Edit</asp:Localize></span>

                                                            </td>

                                            </tr>
                                            <tr style="border-bottom: 1px solid #f0f0f0;" class="secsubbordercolor">
                                                <td style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_enlItrDtcAlt" runat="server">Enable intrusion detection and alerting</asp:Localize></td>
                                                <td style="font-size: 16px; padding: 3px;">
                                                    <%if (m_Intru)
                                                    { %>
                                                    <span class="fa fa-check" style="color: #008000;"></span>
                                                    <%}
                                                    else
                                                    { %>
                                                    <span class="	fa fa-exclamation-circle" style="color: #800040;"></span>
                                                    <%}%>
                                                </td>
                                                <td style="font-size: 16px; padding: 3px;">
                                                    <%if (!m_Intru)
                                                    { %>
                                                            <asp:Localize meta:resourcekey="str_itrDtcAltNotEnl" runat="server">"Intrusion detection and alerting" is not enabled</asp:Localize>     
                                                                <%}%>
                                                </td>
                                                <td align="right" style="padding-right: 5px; font-weight: 100;">
                                                                <span class="btn btn-primary gladbtn" style="font-weight: 100!important;" data-toggle="modal" data-target="#SettingsModal"><asp:Localize meta:resourcekey="str_edt" runat="server">Edit</asp:Localize></span>

                                                            </td>
                                            </tr>

                                        </table>
                                    </td>
                                </tr>

                                <tr style="padding-top: 10px;padding: 10px; padding-bottom: 20px; font-weight: 100; font-size: 16px;">
                                    <td class="btniconcolor" style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_hstPvr" runat="server">Hosting Provider</asp:Localize>
                                    </td>
                                    <td style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_hstPvrNtwAcsAdt" runat="server">Hosting provider has network access related audit</asp:Localize>
                                    </td>
                                </tr>

                            </table>
                        </div>
                    </div>

                    <div style="height: 10px"></div>
                    <div class="card">
                        <div class="panel-heading toolnavbtn selbox" data-toggle="collapse" data-target="#ar37" style="cursor: pointer; font-weight: 100; font-size: 18px;">
                             <asp:Localize meta:resourcekey="str_dsgDtaPrtOfr" runat="server">(Article 37) Designation of the data protection officer</asp:Localize>

                        </div>
                        <div id="ar37" class="collapse" style="background-color: white; padding: 10px;">

                            <table width="100%" class="table-striped" style="padding: 10px; padding-bottom: 20px; font-weight: 100; font-size: 16px;">
                                <tr>
                                    <td class="btniconcolor" width="150px" style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_gce" runat="server">CentreStack</asp:Localize>
                                    </td>
                                    <td style="font-size: 16px;"></td>
                                </tr>

                                <tr style="padding-top: 10px;">
                                    <td class="btniconcolor" style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_hstPvr" runat="server">Hosting Provider</asp:Localize>
                                    </td>
                                    <td style="font-size: 16px; padding: 3px;"><asp:Localize meta:resourcekey="str_rspAptDtaPrtOfr" runat="server">Responsible for appointing a data protection officer if required to maintain GDRP compliance, depending on the client's operating circumstances</asp:Localize>
                                    </td>
                                </tr>

                            </table>
                        </div>
                    </div>
                </td>
            </tr>
        </table>
    </div>

    <script type="text/javascript">
        function ReturnLast() {
            window.location = "<%=PageReturnUrl %>";
        }

        function AdjustSize() {

            var f = document.getElementById('main_body');
            f.style.height = (document.documentElement.clientHeight - 42) + "px";
            f.style.marginTop = "8px";
        }


        Ext.onReady(function () {
            AdjustSize();

        });

        Ext.EventManager.onWindowResize(function () {
            AdjustSize();
        });




    </script>

</asp:Content>
