﻿<%@ Page Title="Folder Permission Report" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="FolderPermsReport.aspx.cs" Inherits="GladinetPayFlow.FolderPermsReport"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        
        
        .securityicon
        {
            background-image: url(images/security2.png);
        }
        .groupicon
        {
            background-image: url(images/group.png);
        }                                                      
        .denyacl{color:#C7C7CE;font-weight:normal;font-size:30px;}
        .allowacl{color:#C7C7CE;font-weight:normal;font-size:20px;}
        .gladinet-icons.md-24{line-height:28px;}

        #leftControls .bmd-form-group{padding-top:0;}      
        #leftControls .bmd-form-group input::placeholder{color:#C7C7C7;}
    </style>
    <script type="text/javascript">




        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //parent.setActivePanel("PubMgr");




        function gEncodeUri(str) {
            var s = encodeURI(str).replace(/&/g, '%26').replace(/#/g, '|').replace('+', ':');
            while (true) {
                var i = s.indexOf('+');
                if (i == -1)
                    break;
                s = s.replace('+', ':');
            }

            return s;

        }



        var ActiveWin;
       

        //parent.HelpSrc = "PubMgrHelp.htm";


        function closeActiveWin() {


            window.location = window.location;

        }

        function closeCancelActiveWin() {
            ActiveWin.close();
        }

        function EditAcl(id) {
            var obj = document.getElementById(id);
            var fullName = "";
            try {
                fullName = obj.innerHTML.trim();
            } catch (ex) { }
            var err = "Error. Cannot retrieve permissions for this object.";
            if (fullName == "") {
                alert(err);
                return;
            }
            if (parent.EditFolderPermission)
                parent.EditFolderPermission(fullName, "<%=SessionDomainId%>");
            else if (parent.parent.EditFolderPermission) {

                parent.parent.EditFolderPermission(fullName, "<%=SessionDomainId%>");
            } else {
                alert(err);
            }
        }
        function PrintFile() {

            var originalContents = document.body.innerHTML;

            var printReport = document.getElementById('grid-table').innerHTML;
            document.body.innerHTML = printReport;
            document.body.style.overflow = "visible";
            window.print();

            document.body.innerHTML = originalContents;


        }
        function Sort(dir) {
            var obj = document.getElementById("<%=hidSortDir.ClientID %>");
            if (dir == "desc") {
                obj.value = "desc";
            } else {
                obj.value = "asc";
            }
            Refresh();
        }
        function Refresh() {
            document.getElementById("<%=btnSort.ClientID %>").click();
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocFaiToGetShaObjLis" meta:resourcekey="str_faiToGetShaObjLis" Visible="false">Failed to get shared object list.</asp:Localize>
    <asp:Localize runat="server" ID="LocEvn" meta:resourcekey="str_evn" Visible="false">Everyone</asp:Localize>
<asp:Localize runat="server" ID="LocAllADUsr" meta:resourcekey="str_allADUsr" Visible="false">All AD Users</asp:Localize>
<asp:Localize runat="server" ID="LocUkn" meta:resourcekey="str_ukn" Visible="false">Unknown</asp:Localize>
<asp:Localize runat="server" ID="LocNa" meta:resourcekey="str_na" Visible="false">N/A</asp:Localize>
<asp:Localize runat="server" ID="LocUknUsr" meta:resourcekey="str_uknUsr" Visible="false">Unknown User</asp:Localize>
    <asp:Localize ID="LocFldPrm" meta:resourcekey="str_fldPrm" runat="server" Visible="false">Folder Permission(s)</asp:Localize>
    <asp:Localize ID="LocEvrone" meta:resourcekey="str_evrone" runat="server" Visible="False">Everyone</asp:Localize>
    <asp:Localize ID="LocSrtAsc" meta:resourcekey="str_srtAsc" runat="server" Visible="False">Sort by Name, Ascending</asp:Localize>
    <asp:Localize ID="LocSrtDesc" meta:resourcekey="str_srtDesc" runat="server" Visible="False">Sort by Name, Descending</asp:Localize>
    <asp:Localize ID="LocRfs" meta:resourcekey="str_rfs" runat="server" Visible="False">Refresh</asp:Localize>    
    <asp:Localize ID="LocFolNam" meta:resourcekey="str_folNam" runat="server" Visible="False">Folder or User Name</asp:Localize>   
    <asp:Localize ID="LocAppFil" meta:resourcekey="str_appFil" runat="server" Visible="False">Apply Filter</asp:Localize>


    <div 
        <%if (IsChildUi) { %>
        style="width:100%;border-bottom:1px solid #eeeeee"
        <%}else { %>
        class=" meubardrop"
        <%} %>
        >
        <table width="100%">
            <tr>
                <td id="leftControls" style="padding-left:10px;display:flex;align-items:flex-start;align-content:flex-start;">
                    <div>  
                    <asp:Label ID="PubFolderCount" runat="server" meta:resourcekey="PubFolderCountResource1" CssClass="badge hollowbadge" style="font-size:12px;"></asp:Label>
                    </div>
                    <div style="display:flex;align-items:flex-start;align-content:flex-start;">
                        <asp:TextBox ID="txtSearch" CssClass="form-control" runat="server" style="width:200px;margin-top:-7px;margin-left:40px;" />
                        <asp:Button ID="btnFilterResults" CssClass="btn btn-primary gladbtn" runat="server" OnClick="btnFilterResults_Click" />
                    </div>


                </td>
                <td>
                    <b>
                   <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                </td>
                <td align="right" style="padding-right:10px;">
                    <asp:Localize id="LocPrt" meta:resourcekey="resLocPrt" runat="server" Visible="false">Print</asp:Localize>
                <asp:Localize id="LocCsv" meta:resourcekey="resLocCsv" runat="server" Visible="false">Download as CSV file</asp:Localize>  
               <table>
                   <tr>
                <td title="<%=LocSrtAsc.Text %>" style="width:48px;height:48px;">
                    <i onclick="Sort('asc');return false;" class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 3px;">&#xE5;</i>
                </td>
                <td title="<%=LocSrtDesc.Text %>" style="width:48px;height:48px;">
                    <i onclick="Sort('desc');return false;" class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 3px;">&#xE6;</i>
                    <div style="display:none;">
                        <asp:Button ID="btnSort" runat="server" Text="" OnClick="btnSort_Click" />
                        <input type="hidden" id="hidSortDir" runat="server" value="asc" />
                    </div>
                </td>
                <td title="<%=LocRfs.Text %>" style="width:48px;height:48px;">
                    <i onclick="Refresh();return false;" class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 3px;">&#xB5;</i>
                </td>

                       <td align="right" width="48px" height="48px" onclick='PrintFile();return false;' title="<%=LocPrt.Text %>">
                <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 3px;">\</i>
            </td>
            <td align="right" width="48px" height="48px"  title="<%=LocCsv.Text %>">
                <asp:LinkButton ID="ExportBtn" runat="server" OnClick="ExportBtn_Click">
                <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 3px;">&#0178;</i>
                    </asp:LinkButton>
            </td>
                   </tr>
               </table>
                </td>
            </tr>
            </table>
        </div>
   
    <table width="100%" style="padding: 2px; background-color: white; margin-top: 20px; overflow: auto;" cellspacing="0" cellpadding="0" id="grid-table">
        
        <tr>
            <td style="padding:0px;padding-top: 0px; border-bottom: 0px solid #c0c0c0; border-left: 0px solid #c0c0c0; border-right: 0px solid #c0c0c0; background-color: white; padding-top: 20px;" align="center" valign="top"
                id="grid-example">
                
                <div class="row " align="center" style="width: 95%; background-color: white;">
                <asp:Repeater ID="PubsRepeater" runat="server" OnItemDataBound="OnFolderItemBound" OnPreRender="PubsRepeater_PreRender">
        <ItemTemplate>
                <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 text-center topbuffer">
                                <div class=" panel panel-default" style="box-shadow: 0px px 3px #d0d0d0; align-content: center;"
                                    align="center">
                                    <table width="100%">
                                        <tr>
                                            <td valign="middle" align="center" style="border-right: 1px dashed #d0d0d0;background-color: #f8f8f8;width:70px;">
                                                 <i class="gladinet-icons md-32 md-dark hand center toolbtn" style="display: inline-block;width:70px;margin-top: 3px;line-height:62px;" title="<asp:Localize meta:resourcekey="str_edt" runat="server">Edit</asp:Localize>" onclick="EditAcl('pubRpt_<%# Container.ItemIndex + 1 %>');">/</i>
                                                <div style="display:none;">
                                                    <div id="pubRpt_<%# Container.ItemIndex + 1 %>"><%#DataBinder.Eval(Container.DataItem, "Tag")%></div>
                                                </div>
                                            </td>
                                            <td>
                                                <table width="100%">
                                                    <tr>
                                                        <td  style="padding: 5px; padding-left: 10px;  color: black;white-space:nowrap">
                                                            <table width="100%">
                                                                <tr>
                                                                    <td>
                                                            <h4 class="pubRptStr" style="font-weight: 100; color: #404040;"><asp:Literal ID="ltlFldName" runat="server" Text='<%#DataBinder.Eval(Container.DataItem, "Name")%>' /></h4>
                                                                    </td>
                                                                    <!--td width="24px" >
                                                            <i class='gladinet-icons md-32 md-dark hand center toolbtn" style="display: inline-block; margin-top: 3px;' style="display: none;cursor: pointer;" title="<asp:Localize meta:resourcekey="str_edt" runat="server">Edit</asp:Localize>" onclick='EditAcl(&#039;<%# DataBinder.Eval(Container.DataItem, "Name") %>&#039;);'>/</i>
                                                            
                                                        </td-->
                                                                </tr>
                                                            </table>
                                                        </td>
                                                        
                                                       
                                                    </tr>
                                                    <tr>
                                                        
                                                        <td style="border-top:1px dashed #d0d0d0; padding: 5px; padding-left: 10px;"  class="text-muted">
                                                         <table width="100%" class="table-striped" style="font-weight: 100 !important;">
                                                             <tr>
                                                                     <td></td>
                                                                     <td></td>
                                                                     <td width="100px" align="center"><asp:Localize meta:resourcekey="str_list" runat="server">List</asp:Localize></td>
                                                                     <td width="100px" align="center"><asp:Localize meta:resourcekey="str_read" runat="server">Read</asp:Localize></td>
                                                                     <td width="100px" align="center"><asp:Localize meta:resourcekey="str_write" runat="server">Write</asp:Localize></td>
                                                                     <td width="100px" align="center"><asp:Localize meta:resourcekey="str_delete" runat="server">Delete</asp:Localize></td>
                                                                 <td width="100px" align="center"><asp:Localize meta:resourcekey="str_share" runat="server">Share</asp:Localize></td>
                                                                 </tr>
                                                             <asp:Repeater ID="UserRepeater" runat="server">
                                                                 
                                                            <ItemTemplate>
                                                                <tr>
                                                                    <td>
                                                                         <asp:Literal ID="ltlFirstName" runat="server" Text='<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "FirstName").ToString())%>' /> <asp:Literal ID="ltlLastName" runat="server" Text='<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "LastName").ToString())%>' /> (<asp:Literal ID="ltlEmail" runat="server" Text='<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "Email").ToString())%>' />)
                                                                    </td>
                                                                    <td align="center">
                                                                        <span class="gladinetFont <%# DenyACLCssClass(DataBinder.Eval(Container.DataItem, "DenyAcl")) %>"><%# DenyACLSymbol(DataBinder.Eval(Container.DataItem, "DenyAcl")) %></span>
                                                                    </td>
                                                                    <td align="center">
                                                                        <input  type="checkbox" disabled="disabled" <%# DataBinder.Eval(Container.DataItem, "ListRight") %> />
                                                                    </td>
                                                                    <td align="center">
                                                                        <input  type="checkbox" disabled="disabled" <%# DataBinder.Eval(Container.DataItem, "ReadRight") %> />
                                                                    </td>
                                                                    <td align="center">
                                                                        <input  type="checkbox" disabled="disabled" <%# DataBinder.Eval(Container.DataItem, "WriteRight") %> />
                                                                    </td>
                                                                    <td align="center">
                                                                        <input  type="checkbox" disabled="disabled" <%# DataBinder.Eval(Container.DataItem, "DeleteRight") %> />
                                                                    </td>
                                                                    <td align="center">
                                                                        <input  type="checkbox" disabled="disabled" <%# DataBinder.Eval(Container.DataItem, "ShareRight") %> />
                                                                    </td>
                                                                </tr>
                                                            </ItemTemplate>
                                                            </asp:Repeater>
                                                         </table>
                                                            
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                            </ItemTemplate>
    </asp:Repeater>      
                </div>
            </td>
        </tr>
        
    </table>
    <div style="display: none;">
    </div>
    <input type="hidden" id="current_share" name="current_share" />
    
    <script type="text/javascript">

        Ext.require([
          'Ext.grid.*',
          'Ext.data.*',
          'Ext.util.*',
          'Ext.state.*'
      ]);
        var grid;
function AdjustGridTable () {
           
        var h = 400;
          
        try {

           
            h = document.body.offsetHeight-93;
           

          } catch (err) {
          }
             

          var e = document.getElementById("grid-table");
          e.style.height = h + "px";

      }
    
    function GetShortString(src, MaxLen) {
        if (src.length <= MaxLen)
            return src;
        var len = (MaxLen - 3) / 2;
        var p1 = src.substring(0, len);
        var p2 = src.substring(src.length - len);
        return p1 + "..." + p2;
    }
    function callGetShortString(str, MaxLen) {
        var origStr = "..." + str;
        var shorterName = GetShortString(str, MaxLen);
        if (origStr == shorterName) return str;
        else return shorterName;
    }
        Ext.onReady(function () {

            Ext.QuickTips.init();

            var arr = document.querySelectorAll(".pubRptStr");
            if (arr) {
                for (var i = 0; i < arr.length; i++) {
                    try {
                    var id = arr[i].id;
                    var str = arr[i].innerHTML.trim();
                    var parts = str.split("\n");
                    if (str.length > 80) {
                        arr[i].innerHTML = callGetShortString(parts[0], 80);
                        arr[i].title = parts[1];
                    }
                    } catch (ex) {
                        console.log("ERROR: " + ex);
                    }
                }
            }
            
              AdjustGridTable ();
             
             Ext.EventManager.onWindowResize(AdjustGridTable);

        });
    </script>
</asp:Content>
