﻿<%@ Page Title="Encrypt Data" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="EncryptData.aspx.cs" Inherits="GladinetPayFlow.EncryptData" Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">

    <style type="text/css">
        .wrapper {
            padding: 0px;
            background-color: white;
            padding-bottom: 68px;
        }
    </style>

    <script type="text/javascript">
        
    </script>
</asp:Content>

<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">

    <%if (!string.IsNullOrEmpty(ErrorMsg.Text))
        { %>
    <div class="alert alert-warning alert-dismissible fade show" role="alert">
        <b>
            <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label>
        </b>
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>

    <%} %>


    <table width="100%" border="0">
        <tr>
            <td align="center" style="padding-top: 30px;">
                <table width="100%" align="center" style="background-color: white; padding-top: 0px; padding-bottom: 0px; max-width: 800px;" cellspacing="0">
                    <tr>
                        <td align="center">
                            <asp:Panel ID="EulaPanel" runat="server">
                                <div style="font-size: 24px; font-weight: 100; color: #202020; padding: 10px; margin-top: 60px;"><asp:Localize meta:resourcekey="str_thiDatEncUtiIsNotCovByOur" runat="server">This data encryption utility is not covered by our offical test process, may not meet our product quality. Although we have tried our best to verify its functionlity, use it at your own risk.</asp:Localize></div>
                                <div style="padding: 10px;">
                                    <asp:CheckBox ID="CheckBoxTerm" runat="server" Text="By using this utility, you agree to the " CssClass="thintext" />
                                    <a href="http://www.gladinet.com/p/terms.htm" target="_blank">
                                        <asp:Localize meta:resourcekey="str_trmSvc" runat="server">TERMS OF SERVICE</asp:Localize></a>
                                </div>
                                <asp:LinkButton ID="StepContBtn" runat="server" OnClick="StepContBtn_Click" CssClass="btn btn-primary">Continue</asp:LinkButton>
                            </asp:Panel>
                            <asp:Panel ID="SettingsPanel" runat="server" Visible="false">
                                <table style="width: 100%">
                                    <tr>
                                        <td>
                                            <h2 style="font-weight: 100;"><asp:Localize meta:resourcekey="str_locStoLocCmyOrMyfToBeEnc" runat="server">Local Storage Location (C:\myfolder or \myfileserver\myshare) to be encrypted:</asp:Localize></h2>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <asp:TextBox ID="StorageLocation" runat="server" Width="100%" meta:resourcekey="StorageLocationResource1" CssClass="form-control"></asp:TextBox>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <h2 style="font-weight: 100; padding-top: 20px;"><asp:Localize meta:resourcekey="str_pasToEncTheDat" runat="server">Password to encrypt the data</asp:Localize></h2>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td style="border-bottom: 0px solid #cccccc; padding-bottom: 10px;">
                                            <asp:TextBox ID="DstPwd" runat="server" Width="100%" CssClass="form-control"></asp:TextBox>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <h2 style="font-weight: 100; padding-top: 20px;"><asp:Localize meta:resourcekey="str_onlEncFilSizLarThaMb" runat="server">Only encrypt file size larger than (MB)</asp:Localize></h2>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td style="border-bottom: 0px solid #cccccc; padding-bottom: 10px;">
                                            <asp:TextBox ID="MinFileSize" runat="server" Width="100%" CssClass="form-control" Text="20" ></asp:TextBox>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 10px;">Credential to access the storage:
                                            <div style="padding: 10px; border: 1px solid #cccccc">
                                                <table style="width: 100%">
                                                    <tr>
                                                        <td style="white-space: nowrap; color: #565656; padding-top: 20px;">
                                                            <h3><asp:Localize meta:resourcekey="str_useNamForLocStoAcc" runat="server">User Name (for local storage access):</asp:Localize></h3>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>

                                                            <asp:TextBox ID="StorageUser" runat="server" Width="100%" meta:resourcekey="StorageUserResource1" CssClass="form-control"></asp:TextBox>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td style="white-space: nowrap; color: #565656; padding-top: 20px;">
                                                            <h3><asp:Localize meta:resourcekey="str_pasForLocStoAcc" runat="server">Password (for local storage access):</asp:Localize></h3>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <asp:TextBox ID="StoragePassword" runat="server" Width="100%" TextMode="Password" CssClass="form-control"
                                                                meta:resourcekey="StoragePasswordResource1"></asp:TextBox>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 10px;">Settings:
                                            <div style="padding: 10px; border: 1px solid #cccccc; padding-top: 20px;">
                                                <table style="width: 100%">
                                                    <tr>
                                                        <td>
                                                            <h3 style="font-weight: 100;"><asp:Localize meta:resourcekey="str_locStoLocForComLeaBlaIfNo" runat="server">Local Storage Location for comparision (leave blank if no comparision needed)</asp:Localize></h3>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <asp:TextBox ID="OldStorageLocation" runat="server" Width="100%" CssClass="form-control"></asp:TextBox>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <h3 style="font-weight: 100; padding-top: 20px;"><asp:Localize meta:resourcekey="str_pasToDecTheDatEmpIfIsNot" runat="server">Password to decrypt the data (empty if is not encrypted)</asp:Localize></h3>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td style="border-bottom: 0px solid #cccccc; padding-bottom: 10px;">
                                                            <asp:TextBox ID="SrcPwd" runat="server" Width="100%" CssClass="form-control"></asp:TextBox>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td>
                                                            <h3 style="font-weight: 100; padding-top: 20px;"><asp:Localize meta:resourcekey="str_onlEncFilOldTha" runat="server">Only encrypt file older than</asp:Localize></h3>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td style="border-bottom: 0px solid #cccccc; padding-bottom: 10px;">
                                                            <asp:TextBox ID="FileChangeTime" runat="server" Width="100%" CssClass="form-control" ></asp:TextBox>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td align="center">
                                            <asp:LinkButton ID="PreviewBtn" runat="server" OnClick="Preview_Btn_Click" CssClass="btn btn-primary">Preview</asp:LinkButton>
                                            <asp:LinkButton ID="EncryptBtn" runat="server" OnClick="EncryptBtn_Click" CssClass="btn btn-primary">Encrypt</asp:LinkButton>

                                        </td>
                                    </tr>
                                </table>
                            </asp:Panel>
                            <asp:Panel ID="ProgressPanel" runat="server" Visible="false">
                                <table style="width: 100%">
                                    <tr>
                                        <td style="font-size: 18px; font-weight: 100; color: #565656" id="pstat"></td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="progress" style="width: 100%;">
                                                <div class="progress-bar progress-bar-success progress-bar-striped progress-bar-animated" role="progressbar" aria-valuenow="40" id="iTaskProgress"
                                                    aria-valuemin="0" aria-valuemax="100" style="width: 0%"></div>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <asp:LinkButton ID="LinkButton1" runat="server" OnClick="RestartBtn_Click" CssClass="btn btn-primary">Cancel</asp:LinkButton>
                                        </td>
                                    </tr>
                                </table>
                            </asp:Panel>
                            <asp:Panel ID="ResultPanel" runat="server" Visible="false">
                                <table style="width: 100%">
                                    <tr>
                                        <td colspan="5" align="right">
                                            <asp:LinkButton ID="CommitTask" runat="server" OnClick="CommitBtn_Click" CssClass="btn btn-primary" Visible="false">Commit</asp:LinkButton>
                                            <asp:LinkButton ID="RestartBtn" runat="server" OnClick="RestartBtn_Click" CssClass="btn btn-primary">Re-Start</asp:LinkButton>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div style="width: 100%;  border: 1px solid #cccccc; border-radius: 5px; padding: 5px; overflow: auto">
                                                <table style="width: 100%">
                                                    <asp:Repeater ID="EncFileList" runat="server">
                                                        <ItemTemplate>
                                                            <tr style="border-bottom: 1px solid #cccccc;" class="filerow">
                                                                <td style="padding:10px;">
                                                                    <table style="width: 100%">
                                                                        <tr>
                                                                            <td style="font-size:14px; font-weight:400;" class="sectextcolor">
                                                                                <%#DataBinder.Eval(Container.DataItem,"RelPath") %>
                                                                            </td>

                                                                            <td width="120px">
                                                                                <%#DataBinder.Eval(Container.DataItem,"DisplayChangeTime") %>
                                                                            </td>
                                                                            <td width="80px">
                                                                                <%#DataBinder.Eval(Container.DataItem,"DisplaySize") %>
                                                                            </td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td colspan="3" >
                                                                                <span style=" <%#DataBinder.Eval(Container.DataItem,"DisplayStyle") %>"><%#DataBinder.Eval(Container.DataItem,"Status") %> </span> <%#DataBinder.Eval(Container.DataItem,"Note") %>
                                                                            </td>
                                                                        </tr>

                                                                    </table>
                                                                </td>


                                                            </tr>
                                                        </ItemTemplate>
                                                    </asp:Repeater>
                                                </table>
                                            </div>
                                        </td>

                                    </tr>

                                    
                                </table>

                            </asp:Panel>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>

    <asp:HiddenField ID="HiddenTaskId" runat="server" />

    <div style="display: none">
        <asp:LinkButton ID="ShowResult" runat="server" OnClick="ShowResult_Click" CssClass="btn btn-primary">Encrypt</asp:LinkButton>
    </div>

    <script type="text/javascript">
        function stringStartsWith(s, p) {
            return (s.indexOf(p) == 0);
        }
        function OnPollRes(m) {
            try {
                var e = document.getElementById("pstat");
                if (stringStartsWith(m, "bad^")) {

                    e.innerHTML = m.substring(4);
                    return;
                }
                var ps = m.split('^');
                e.innerHTML = ps[0];
                if (ps[0] == "completed") {
                    var be = document.getElementById("ctl00_MainContent_ShowResult");
                    be.click();
                    return;
                }
                e = document.getElementById("iTaskProgress");
                e.style.width = ps[1] + "%";


            } catch (ee) {

            }
            setTimeout("Poll()", 1000);
        }


        function Poll() {

            try {
                Ext.Ajax.request({
                    url: '/management/EncryptData.aspx?tid=<%=HiddenTaskId.Value%>&poll=1',
                    success: function (response) {

                        OnPollRes(response.responseText);
                    },
                    failure: function () {
                        OnPollRes('bad^unknown');
                    },
                    method: 'GET'
                });

            } catch (e) {
                alert(e);
            }

        }
        <%if (ProgressPanel.Visible)
        {%>
        setTimeout("Poll()", 1000);
        <%}%>
    </script>
</asp:Content>
