﻿<%@ Page Title="Tenant Dashboard" Language="C#" MasterPageFile="~/WebAppPanel.master" AutoEventWireup="true"
    CodeBehind="EditTenantDashboard.aspx.cs" Inherits="GladinetPayFlow.EditTenantDashboard"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .auto-style1 {
            font-weight: 500;
            font-size: 24px;
            color: rgb(51, 51, 51);
        }

        .style3 {
            font-size: small;
        }

        .style4 {
            padding-left: 15px;
        }

        .linkbuttond {
            background-image: url(images/linkbutton_done.png);
            background-repeat: no-repeat;
            text-align: center;
            vertical-align: middle;
            width: 128px;
            height: 32px;
            display: inline-block;
        }

        .linkbuttona {
            text-align: center;
            vertical-align: middle;
            color: #006000;
            display: block;
            vertical-align: top;
            padding-top: 6px;
            width: 128px;
            height: 32px;
            font-size: 16px;
            font-weight: bold;
        }

        .AssetBox {
            padding: 5px;
            background-color: White;
            -moz-border-radius: 10px 10px;
            -webkit-border-radius: 10px 10px;
            -o-border-radius: 10px 10px;
            -ms-border-radius: 10px 10px;
            -khtml-border-radius: 10px 10px;
            border-radius: 10px 10px;
            border: 1px solid #D0D0D0;
            width: 250px;
            height: 250px;
            text-align: left;
            font: normal 10pt 'Verdana';
            color: #404040;
            margin: 0 auto;
        }

        .AssetBox2 {
            min-width: 250px;
            width: 90%;
            height: 270px;
            margin: 0 auto;
        }

        .AssetTitle {
            padding: 5px;
            text-align: center;
            border-bottom: 1px solid #d0d0d0; /*background-color: #eef4f9;*/
            moz-border-radius: 10px 10px;
            -webkit-border-radius: 10px 10px;
            -o-border-radius: 10px 10px;
            -ms-border-radius: 10px 10px;
            -khtml-border-radius: 10px 10px;
            border-radius: 10px 10px;
        }

        .AssetInfo {
            padding: 15px;
            padding-top: 45px;
            text-align: center;
            font: normal 24pt 'Verdana';
            color: #404040;
            font-weight: bold;
        }

        body {
            background-image: url("images/bggrid.png");
        }

        

        .usermenubody {
            position: absolute;
            width: 300px;
            display: none;
            background-color: white;
            border-left: 1px solid #808080;
            border-right: 1px solid #808080;
            border-bottom: 1px solid #808080;
            padding: 1px;
            border-radius: 0px 6px 6px 6px;
            cursor: hand;
        }

        .usermenubtn {
            background-color: white;
            border-left: 1px solid #808080;
            border-top: 1px solid #808080;
            border-radius: 12px 0px 0px 0px;
            padding: 1px;
            color: Black;
            cursor: hand;
        }

        .usermenubtnimg {
            background-color: white;
            border-right: 1px solid #808080;
            border-top: 1px solid #808080;
            border-radius: 0px 12px 0px 0px;
            padding: 1px;
            cursor: hand;
        }

        .usermenubtnright {
            border-bottom: 0px solid #808080;
            border-radius: 0px 0px 0px 6px;
            padding: 1px;
        }

        .returnlbl {
            background-position: center;
            background-repeat: no-repeat;
            border-radius: 12px 12px 12px 12px;
            border: 0px solid #c0c0c0;
            padding-left: 8px;
            padding-right: 8px;
            padding-top: 0px;
            padding-bottom: 0px;
            white-space: nowrap;
            overflow: hidden;
            height: 24px;
        }

        body {
            /*background-image: url("images/dashboardbg.jpg") !important;
            background-size: 100%;*/
        }

        #aspnetForm {
            background-image: url("images/dashbdbg.jpg");
            background-repeat: no-repeat;
            background-size: cover;
            
        }

        .topbuffer {
            margin-top: 28px;
        }

        .glyphgray {
            color: #808080;
        }
        code
        {
            color: #337ab7;
        }
        #origcontrol{display:flex !important;flex-wrap:wrap;max-width:435px;} 
        #origcontrol .btn{flex-grow:2;margin:2px; text-align:center;}
        .dropdown-menu-right {
            /*fix bootstrap menu bug outside of nav*/
            right: 0;
            left: auto;
        }
    </style>
    <script type="text/javascript">
        var activewin;

        function SetView(Url, t) {
             
            parent.SetSubView(Url,t);
        }
        function OnUserMgr() {
            
            if (parent.OnSetUserMgr) {
                parent.OnSetUserMgr();
                return;
            }
            
            if(parent.SetSecondPageTitle)
                parent.SetSecondPageTitle("<asp:Localize  meta:resourcekey="asp_string29" runat="server" >Manage Users</asp:Localize>","/portal/UserMgrPage.aspx?vdid=<%=SessionDomainId %>");
            window.location ="/portal/UserMgrPage.aspx?vdid=<%=SessionDomainId %>"

           
            return;
            
        }

        function OnTenantPlan() {
            if(parent.SetSecondPageTitle)
                parent.SetSecondPageTitle("<asp:Localize  meta:resourcekey="asp_string29" runat="server" >Manage Users</asp:Localize>","/portal/UserMgrPage.aspx?vdid=<%=SessionDomainId %>");
            window.location ="/portal/UserMgrPage.aspx?vdid=<%=SessionDomainId %>"

           
            return;
            
        }
        function EditShare(name,n) {
            var u = "/management/AddLocalStorage.aspx?f=" + encodeURIComponent(name) + "&vdid=<%=SessionDomainId %>";
            u = "/portal/AddPubPage.aspx?src=filebrowser&location="+ encodeURIComponent(name) +"&vdid=<%=SessionDomainId %>";
            if(parent.SetSecondPageTitle)
                parent.SetSecondPageTitle("<asp:Localize  meta:resourcekey="str_mngFld" runat="server" >Manage Users</asp:Localize>: "+n,u);
            window.location = u;
        }
        function OnCollab() {
            if (parent.OnSetTeamFolders) {
                parent.OnSetTeamFolders();
                return;
            }
            if(parent.SetSecondPageTitle)
                parent.SetSecondPageTitle("<%=Localize61.Text %>", "/portal/PubMgrPage.aspx?vdid=<%=SessionDomainId %>");
            window.location = "/portal/PubMgrPage.aspx?vdid=<%=SessionDomainId %>";
        }

        function OnShare() {
            if(parent.SetSecondPageTitle)
                parent.SetSecondPageTitle("<asp:Localize meta:resourcekey="asp_string20" runat="server">Shared Objects</asp:Localize>","/Management/TenantShareMgrPage.aspx?vdid=<%=SessionDomainId %>");
            window.location = "/Management/TenantShareMgrPage.aspx?vdid=<%=SessionDomainId %>";
        }
        function OnAddUser() {

            activewin = new Ext.Window({
                id: 'On_Add_User',
                title: "<asp:Localize meta:resourcekey="js_string1" runat="server">Add Users</asp:Localize>",
                width: 880,
            height: maxh(560),
            constrain: true,                
            plain: true,
            modal: true,
            maximizable: true,
            resizable: false,
            maximized: false,
            shadow: 'drop',
            shadowOffset: 20,
            layout: 'fit',
            bodyPadding: 3,
            html: "<iframe id='openwin' src='/management/AddUserWizard/SingleUserInfo.aspx' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>",
            defaults: {
                border: false
            }
        });
        activewin.show();



        }

        function ConfigAD() {
            if(parent.SetSecondPageTitle)
                parent.SetSecondPageTitle("<asp:Localize  meta:resourcekey="str_configad" runat="server">Configure Active Directory</asp:Localize>","LDAPCfgPage.aspx?vdid=<%=SessionDomainId %>");
            window.location = "LDAPCfgPage.aspx?vdid=<%=SessionDomainId %>";
            return;

        }

        function AddCloudStorage() {
            window.location = "SelectProvider.aspx?src=mgr&vdid=<%=SessionDomainId %>";
            return;
         
        }

        

        function AddLocalStorage() {
            if(parent.SetSecondPageTitle)
                parent.SetSecondPageTitle("<asp:Localize  meta:resourcekey="str_alocal" runat="server">Attach Local Storage</asp:Localize>",'AddLocalStorage.aspx?vdid=<%=SessionDomainId %>');
            window.location = 'AddLocalStorage.aspx?vdid=<%=SessionDomainId %>';
        }

        function ImportShare() {
            //window.location = 'ImportShareName.aspx?vdid=<%=SessionDomainId %>';
            if(parent.SetSecondPageTitle)
                parent.SetSecondPageTitle("<%=str_cteamfolder.Text%>",'SelectStoragePage.aspx?i=0&vdid=<%=SessionDomainId %>');
            try {
                if (parent.SetSubTitle)
                    parent.SetSubTitle( "<%=str_cteamfolder.Text%>");
            } catch (e) {
                  
            }
            Wait("<asp:Localize ID="LocLdg" meta:resourcekey="str_ldg" runat="server">Loading...</asp:Localize>");
            window.location = 'SelectStoragePage.aspx?i=0&vdid=<%=SessionDomainId %>';
        }

        function ImportShareAgent() {
            window.location = '/management/adduserwizard/MigrateSvrWelcome.aspx?vdid=<%=SessionDomainId %>';
          }
        

        function AddPubFolder() {
            
              if(parent.SetSecondPageTitle)
                  parent.SetSecondPageTitle("<asp:Localize  meta:resourcekey="str_cteamfolder" runat="server">Create a Team Folder</asp:Localize>",'/management/SelectStoragePage.aspx?i=0&vdid=<%=SessionDomainId %>');
            window.location = '/management/SelectStoragePage.aspx?i=0&vdid=<%=SessionDomainId %>';
            return;
            if (parent.AddNewTeamFoleWizard) {
                parent.AddNewTeamFoleWizard();
            } else {
                parent.parent.AddNewTeamFoleWizard();
            }

        }
        function AddPubFolderWizard() {
            if(parent.SetSecondPageTitle)
                parent.SetSecondPageTitle("<asp:Localize meta:resourcekey="asp_string34" runat="server">Create a New Team Folder</asp:Localize>", '/management/SelectStoragePage.aspx?i=0&vdid=<%=SessionDomainId %>');
              window.location = '/management/SelectStoragePage.aspx?i=0&vdid=<%=SessionDomainId %>';
              return;
           

          }

          function OnInstallAgent() {

              activewin = new Ext.Window({
                  id: 'On_Add_User',
                  title: "<asp:Localize meta:resourcekey="js_string2" runat="server">Install Server Agent</asp:Localize>",
                  width: 880,
              height: maxh(560),
              constrain: true,
              plain: true,
              modal: true,
              maximizable: true,
              resizable: false,
              maximized: false,
              shadow: 'drop',
              shadowOffset: 20,
              layout: 'fit',
              bodyPadding: 3,
              html: "<iframe id='openwin' src='/management/AddUserWizard/InstallServerAgent.aspx?noback=1' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>",
              defaults: {
                  border: false
              }
          });
          activewin.show();



        }

          function StorageDetail(){
              parent.OpenQuickWindow('/management/UserStorageStat.aspx?child=1&domain=1&uid=<%=SessionDomainId%>&vdid=<%=SessionDomainId%>',"<%=str_storagedetail.Text%>");
          }

          function EditLocalStorage() {
              window.location = 'AddLocalStorage.aspx?f=/&did=<%=SessionDomainId %>'; 
              return;
          }

          function EditCloudStorage() {

              window.location = 'SelectProvider.aspx?c=1&f=/&did=<%=SessionDomainId %>' ;

            return;


        }

        function WizardMigrateShare() {
            activewin = new Ext.Window({
                id: 'msvr_win',
                title: "<asp:Localize meta:resourcekey="js_string3" runat="server">Migrate File Server</asp:Localize>",
                width: 880,
            height: maxh(560),
            plain: true,
            modal: true,
            maximizable: false,
            maximized: false,
            layout: 'fit',
            bodyPadding: 3,
            html: "<iframe id='openwin' src='/management/adduserwizard/MigrateSvrWelcome.aspx' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0;border:0;'></iframe>",
            defaults: {
                border: false
            }
        });
        activewin.show();


        }

        function OnMouseOver(id) {
                
            var e = document.getElementById("e_" + id);
            e.style.display = "";
        }

        function OnMouseLeave(id) {
            var e = document.getElementById("e_" + id);
            e.style.display = "none";
        }

        function OnUserManager() {
        }


        function OnAddUserWizard() {
            
           
            try {
                if(parent.SetSecondPageTitle)
                    parent.SetSecondPageTitle("<asp:Localize  meta:resourcekey="asp_string27" runat="server" >Add Users</asp:Localize>","/management/adduserwizard/AddUserType.aspx?vdid=<%=SessionDomainId %>");
            } catch (e) {
                
            }

            try {
                if (parent.SetSubTitle)
                    parent.SetSubTitle( "<%= str_newu.Text %>");
            } catch (e) {
                
            }
            window.location = "/management/adduserwizard/AddUserType.aspx?vdid=<%=SessionDomainId %>";
            return;
            activewin = new Ext.Window({
                id: 'newuser_win',
                title: "<asp:Localize meta:resourcekey="js_string4" runat="server">Migrate Users</asp:Localize>",
                width: 880,
            height: maxh(560),
            plain: true,
            modal: true,
            maximizable: false,
            maximized: false,
            layout: 'fit',
            bodyPadding: 3,
            html: "<iframe id='openwin' src='/management/adduserwizard/AddUserType.aspx' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0;border:0;'></iframe>",
            defaults: {
                border: false
            }
        });
        activewin.show();
        }
        function closeCancelActiveWin() {
            activewin.close();
        }

        function closeActiveWin() {
            window.location = window.location;
        }




        function ShowUserMenu() {
            
            var d = document.getElementById("usermenu");
            d.style.display = 'block';

            d = document.getElementById("UserMenuBtn");
            d.className = "usermenubtn";
            

            d = document.getElementById("UserMenuBtnImg");
            d.className = "usermenubtnimg";

            d = document.getElementById("UserMenuBtnRight");
            d.className = "usermenubtnright";

            
        }
        function HideUserMenu(evt){
            var d = document.getElementById("usermenu");
            try {
                if (window.event) {
                    if (window.event.offsetX >= 0 && window.event.offsetX < d.offsetWidth && window.event.offsetY >= 0 && window.event.offsetY < d.offsetHeight)
                        return;

                } else {
                    if (evt) {
                        if( evt.screenX > d.offsetLeft && evt.screenX < (d.offsetLeft + d.offsetWidth) && evt.screenY > d.offsetTop && evt.screenY < (d.offsetTop + d.offsetHeight))                         
                            return;
                    }
                }
            } catch (e) {
                
            }

            d.style.display = 'none';

            d = document.getElementById("UserMenuBtn");
            d.className = "returnlbl x-tab-default-active";
            

            d = document.getElementById("UserMenuBtnImg");
            d.className = "";

            d = document.getElementById("UserMenuBtnRight");
            d.className = "";

        }

        function EditUser(u, n) {
            SetView("/portal/EditUserInfo.aspx?uid=" + u + "&vdid=<%=SessionDomainId%>", n);
        }

        function DeleteUser(u, n) {
            gConfirm("<asp:Localize meta:resourcekey="js_string7" runat="server">Confirm delete user: </asp:Localize>" + n, "", function (btn, tex) {
                if (btn == 'yes' || btn == 'ok') {
                    var e = document.getElementById("ctl00_MainContent_DeleteUserBtn");
                    var uid = document.getElementById('ctl00_MainContent_TargetUserId');
                    uid.value = u;
                    Wait("<asp:Localize meta:resourcekey="js_string8" runat="server">Apply Change</asp:Localize>");
                    e.click();
                }
            });
        }

        function DeleteShare(n) {
            gConfirm("<asp:Localize meta:resourcekey="js_string6" runat="server">Confirm deletion. this will remove the storage/team folder, but data will not be purged: </asp:Localize>" + n, "", function (btn, tex) {
                if (btn == 'yes' || btn == 'ok') {
                    var e = document.getElementById("ctl00_MainContent_DeleteShareBtn");
                    var uid = document.getElementById('ctl00_MainContent_TargetUserId');
                    uid.value = n;
                    Wait("<asp:Localize meta:resourcekey="js_string11" runat="server">Apply Change</asp:Localize>");
                    e.click();
                }
            });
        }

        function RefreshTenant() {
            parent.parent.parent.RefreshTenant('<%=ViewSessionDomainId%>', '<%=TargetAdminId.Value%>', "<%=AdminName.Text%>");
        }
        function DeleteTenant() {
            parent.parent.parent.DeleteTenant('<%=ViewSessionDomainId%>', '<%=TargetAdminId.Value%>', "<%=AdminName.Text%>");
        }

        function OnSuspend() {
            var domainid = document.getElementById('ctl00_MainContent_PageDomainId');
            var btn = document.getElementById('ctl00_MainContent_SubspendTenant');
            domainid.value = '<%=SessionDomainId %>';
            btn.click();
        }

        function OnResume() {
            var domainid = document.getElementById('ctl00_MainContent_PageDomainId');
            var btn = document.getElementById('ctl00_MainContent_ResumeTenant');
            domainid.value = '<%=SessionDomainId %>';
            btn.click();
        }
        function ToggleVideo() {
            var e = document.getElementById("DemoVideo");
            var v = document.getElementById("videoctrl");
            var t = document.getElementById("VideoText");
            if (e.style.display == "none") {
                e.style.display = "";
                t.title = "<asp:Localize meta:resourcekey="js_string9" runat="server">Stop Watching Tutorial Video for Tenant Management Console</asp:Localize>";
                v.play();
            } else {
                t.title = "<asp:Localize meta:resourcekey="js_string10" runat="server">Watch Tutorial Video for Tenant Management Console</asp:Localize>";
                e.style.display = "none";
                v.pause();
            }
        }

        function OnDeviceDashboard(id) {
            Wait("<%=LocLdg.Text%>");
            window.location = "DeviceDashboard.aspx?id=" + id;
        }

        function OnAvLoad(id) {
            
            var i = document.getElementById("i_" + id);
            if (i.width == 1 )
                return;
           
            i.style.display = "";
            var e = document.getElementById("av_" + id);
            e.style.display = "none";
        }
        function fixCenterCellSize(){
            try{
                var calcMaxWidth = document.getElementById("centerCell").offsetWidth;
                //console.log("set max width of centerCell for IE 11 only to "+calcMaxWidth);
                var limitWidthSections = document.querySelectorAll(".limitWidth");
                for(var i=0;i<limitWidthSections.length;i++){
                    limitWidthSections[i].style.maxWidth = parseInt(calcMaxWidth)+"px";
                }
            }catch(ex){
                console.log("fixCenterCellSize  "+ex);
            }
        }
        var oldOnload = window.onload;
        window.onload = function () {
            if (oldOnload) oldOnload();
            try{
                //moved this up from a jquery.ready call on the bottom of the page
                $('[data-toggle="tooltip"]').tooltip();
            }catch(ex){}            
            var isIE11 = !!window.MSInputMethodContext && !!document.documentMode;
            if(isIE11){
                fixCenterCellSize();
                window.onresize = fixCenterCellSize;
            }
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Localize ID="LocSha" meta:resourcekey="str_sha" Visible="false" runat="server">Sharepoint</asp:Localize>
    <asp:Localize ID="LocShaOnl" meta:resourcekey="str_shaOnl" Visible="false" runat="server">Sharepoint Online</asp:Localize>
    <asp:Localize ID="LocWebDav" meta:resourcekey="str_webDav" Visible="false" runat="server">Web Dav</asp:Localize>
    <asp:Localize ID="LocGooDri" meta:resourcekey="str_gooDri" Visible="false" runat="server">Google Drive</asp:Localize>
<asp:Localize ID="LocGooCloSto" meta:resourcekey="str_gooCloSto" Visible="false" runat="server">Google Cloud Storage</asp:Localize>
<asp:Localize ID="LocMicOne" meta:resourcekey="str_micOne" Visible="false" runat="server">Microsoft OneDrive</asp:Localize>
<asp:Localize ID="LocS3GovCloWes" meta:resourcekey="str_s3GovCloWes" runat="server" Visible="False">S3 Gov Cloud West</asp:Localize>
<asp:Localize ID="LocS3GovCloEas" meta:resourcekey="str_s3GovCloEas" runat="server" Visible="False">S3 Gov Cloud East</asp:Localize>
<asp:Localize ID="LocInpVerFol" meta:resourcekey="str_inpVerFol" runat="server" Visible="False">Inplace Versioned Folder</asp:Localize>
<asp:Localize ID="LocOpeSta" meta:resourcekey="str_opeSta" runat="server" Visible="False">Open Stack</asp:Localize>
<asp:Localize ID="LocGooSto" meta:resourcekey="str_gooSto" runat="server" Visible="False">Google Storage</asp:Localize>
<asp:Localize ID="LocWinAzu" meta:resourcekey="str_winAzu" runat="server" Visible="False">Windows Azure</asp:Localize>
<asp:Localize ID="LocWasSto" meta:resourcekey="str_wasSto" runat="server" Visible="False">Wasabi Storage</asp:Localize>
<asp:Localize ID="LocS3Clo" meta:resourcekey="str_s3Clo" runat="server" Visible="False">S3 Clone</asp:Localize>
<asp:Localize ID="LocNir" meta:resourcekey="str_nir" runat="server" Visible="False">Nirvanix</asp:Localize>
<asp:Localize ID="LocOpeStaWitKey" meta:resourcekey="str_opeStaWitKey" runat="server" Visible="False">Open Stack with KeyStone</asp:Localize>
<asp:Localize ID="LocEMCATM2" meta:resourcekey="str_eMCATM2" runat="server" Visible="False">EMC ATMOS 2</asp:Localize>
<asp:Localize ID="LocAttLocFol" meta:resourcekey="str_attLocFol" runat="server" Visible="False">Attached Local Folder</asp:Localize>
 
<asp:Localize ID="LocTasPen" meta:resourcekey="str_tasPen" runat="server" Visible="False">Task Pending</asp:Localize>
<asp:Localize ID="LocRun" meta:resourcekey="str_run" runat="server" Visible="False">Running</asp:Localize>
<asp:Localize ID="LocTasPau" meta:resourcekey="str_tasPau" runat="server" Visible="False">Task Paused</asp:Localize>
<asp:Localize ID="LocTasFai" meta:resourcekey="str_tasFai" runat="server" Visible="False">Task Failed:</asp:Localize>
<asp:Localize ID="LocFaiToRetSynSta" meta:resourcekey="str_faiToRetSynSta" runat="server" Visible="False">Failed to retrieve sync status</asp:Localize>
<asp:Localize ID="LocCom" meta:resourcekey="str_com" runat="server" Visible="False">Completed</asp:Localize>
<asp:Localize ID="LocUnk" meta:resourcekey="str_unk" runat="server" Visible="False">Unknown</asp:Localize>
<asp:Localize ID="LocSynced" meta:resourcekey="str_synced" Visible="false" runat="server">Synced</asp:Localize>     
<asp:Localize ID="LocSyn" meta:resourcekey="str_syn" runat="server" Visible="False">Syncing</asp:Localize>
<asp:Localize ID="LocSynFai" meta:resourcekey="str_synFai" runat="server" Visible="False">Sync Failed</asp:Localize>
<asp:Localize ID="LocSynTasPen" meta:resourcekey="str_synTasPen" runat="server" Visible="False">Sync task pending</asp:Localize>
<asp:Localize ID="LocSynTasPau" meta:resourcekey="str_synTasPau" runat="server" Visible="False">Sync task paused</asp:Localize>

<asp:Localize runat="server" ID="LocFaiToDel" meta:resourcekey="str_faiToDel" Visible="false">Failed to delete</asp:Localize>
<asp:Localize runat="server" ID="LocItIsNotAllToDelTenAdm" meta:resourcekey="str_itIsNotAllToDelTenAdm" Visible="false">It is not allowed to delete tenant admin</asp:Localize>
<asp:Localize runat="server" ID="LocUseNotFou" meta:resourcekey="str_useNotFou" Visible="false">User not found</asp:Localize>
    <asp:Localize runat="server" ID="LocLclStg" meta:resourcekey="str_lclStg" Visible="false">Local Storage</asp:Localize>
    <asp:Localize runat="server" ID="LocS3Stg" meta:resourcekey="str_s3Stg" Visible="false">S3 Storage</asp:Localize>
    <asp:Localize runat="server" ID="LocAthLclFld" meta:resourcekey="str_athLclFld" Visible="false">Attached Local Folder</asp:Localize>
    <asp:Localize runat="server" ID="LocUlt" meta:resourcekey="str_ult" Visible="false">Unlimited</asp:Localize>
    <style type="text/css">
        

        td {
            font-size: 15px;
        }

        b {
            font-weight: 500;
        }

        #mainbody {
            /*background-image: url('images/guideup.png');*/
            background-repeat: no-repeat;
            background-position: right top;
            margin-top: 0px;
            padding-top: 0px;
        }
    </style>
   
    <table width="100%" valign='top' align="center" id="mainbody" border="0" style="display: none;">
    <% if (!HelpPanel.Visible)       { %>
        <tr>
            <td align="right" style="padding-right: 15px;">
                <button type="button" class="btn btn-info btn-lg " data-toggle="modal" data-target="#myModal" style="padding: 3px !important;"><span class="fa fa-th-large" style="font-size: 18px;"></span></button>
                
                <div id="myModal" class="modal fade" role="dialog" >
  <div class="modal-dialog" style="width: 800px;">

    <!-- Modal content-->
    <div class="modal-content" style="width: 800px;">
     
      <div class="modal-body" >
          <div class="container" style="width: 100%; align-content: center; vertical-align: top; padding:0px;">
              <div class="row" style="width: 100%; align-content: center; margin: 0; opacity: 0.88; text-align="center">
                  
                  <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 text-center topbuffer">
                            <div class="panel panel-info" >
                                <div class="panel-heading">
                                     <table width="100%">
                                        <tr>
                                            <td align="left"><asp:Localize runat="server" meta:resourcekey="str_SysInf">System Info</asp:Localize></td>
                                            <td align="right">
                                                 
                                            </td>
                                        </tr>
                                    </table>
                                    
                                </div>
                                <div class="panel-body" style="padding:5px;height:250px;  ">
                                    <table width="100%" class="table-striped">
                                        <tr>
                                            <td align="left" width="260px" style="padding:3px; font-size:14px; font-weight:100;color:#404040;">
                                                <asp:Localize ID="Localize12" meta:resourcekey="asp_string26" runat="server">Users</asp:Localize>
                                            </td>
                                            <td>
                                               <span class="badge"> <asp:Label ID="UserCount" runat="server" Text="0" meta:resourcekey="UserCountResource1"></asp:Label></span>
                                            </td>
                                            <td width="60" style="cursor:pointer;padding-right:5px;" align="right">
                                                <span class="fa fa-plus" style="font-size:14px; color:#404040;" onclick="OnAddUserWizard();return false;" ></span>&nbsp;
                                                <span class="fa fa-edit" style="font-size:14px; color:#404040;" onclick="SetView('/portal/UserMgrPage.aspx?vdid=<%= ViewSessionDomainId %>',&quot;<%= str_um.Text %>&quot;);return false;"  ></span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td align="left"  style="padding:3px; font-size:14px; font-weight:100;color:#404040;">
                                                <asp:Localize meta:resourcekey="str_edittf" runat="server" id="str_edittf" visible="False">Edit Team Folder</asp:Localize>
                                                    <asp:Localize ID="Localize1" meta:resourcekey="str_guests" runat="server">Guest User(s)</asp:Localize>
                                            </td>
                                            <td>
                                                      <span class="badge">    <asp:Label ID="GuestUserCount" runat="server" Text="0" meta:resourcekey="UserCountResource1"></asp:Label></span>
                                            </td>
                                            <td>

                                            </td>
                                        </tr>
                                                                                <asp:Panel ID="Panel1" runat="server" Visible="False">
                                        <tr>
                                            <td align="left"  style="padding:3px; font-size:14px; font-weight:100;color:#404040;">
                                                 <asp:Localize ID="Localize3" meta:resourcekey="str_userplan" runat="server">User Plan:</asp:Localize>
                                            </td>
                                            <td>
                                                   <span class="badge">   <asp:Label
                                                    ID="UserPlan" runat="server" Text=""></asp:Label></span>
                                            </td>
                                            <td  style="cursor:pointer;padding-right:5px;" align="right">
                                                <% if (SessionIsClusterAdmin || SessionIsDelegateClusterAdmin)
                                                    { %>
                                                <span class="fa fa-edit" style="font-size:14px; color:#404040;" onclick="SetView('TenantPlanPage.aspx?mode=1&userid=<%= TargetAdminId.Value %>',&quot;<asp:Localize meta:resourcekey="str_tntPln" runat="server">Tenant Plan</asp:Localize>&quot;);return false;"></span>
                                                <% } %>    
                                            </td>
                                        </tr>

                                        </asp:Panel>
                                        <tr title="<%= asp_string33.Text %>">
                                            <td align="left"  style="padding:3px; font-size:14px; font-weight:100;color:#404040;">
                                                <asp:Localize ID="Localize61" meta:resourcekey="asp_string3" runat="server">Team Folders</asp:Localize>
                                                <asp:Localize ID="asp_string33" Visible="False" meta:resourcekey="asp_string33" runat="server">You can set up team folders and assign users to the team folder with permissions. The concept is similar to a network share. users can visit team folder from web browser, mobile clients, in addition to using native PC clients.</asp:Localize>
                                            </td>
                                            <td>
                                                 <span class="badge"> <asp:Label ID="TeamFolderCount" runat="server" Text="0" meta:resourcekey="TeamFolderCountResource1"></asp:Label></span>
                                            </td>
                                            <td  style="cursor:pointer;padding-right:5px;" align="right">
                                               <span class="fa fa-plus" style="font-size:14px; color:#404040;" onclick="AddPubFolder();return false;" ></span>&nbsp;&nbsp; <span class="fa fa-edit" style="font-size:14px; color:#404040;"  onclick="SetView('/portal/pubmgrpage.aspx?vdid=<%= ViewSessionDomainId %>',&quot;<asp:Localize meta:resourcekey="str_teamfolders" runat="server">Team Folders</asp:Localize>&quot;);return false;"  ></span>
                                                </td>
                                        </tr>
                                        <tr>
                                            <td  align="left"  style="padding:3px; font-size:14px; font-weight:100;color:#404040;">
                                                <asp:Localize ID="Localize62" meta:resourcekey="asp_string4" runat="server">Shared Objects</asp:Localize>
                                            </td>
                                            <td>
                                                <asp:Localize ID="asp_string37" Visible="False" meta:resourcekey="asp_string37" runat="server">You can manage shared files and folders and present them as external URL links to external users. Or the files and folders will show up to other registered users as items under 'Files Shared with Me'.</asp:Localize>
                                                 <span class="badge"> <asp:Label ID="SharedObjectCount" runat="server" Text="0" meta:resourcekey="SharedObjectCountResource1"></asp:Label></span>
                                            </td>
                                            <td  style="cursor:pointer;padding-right:5px;" align="right">
                                                <span class="fa fa-edit" style="font-size:14px; color:#404040;" onclick="SetView('/management/TenantShareMgrPage.aspx?vdid=<%= ViewSessionDomainId %>',&quot;<%=Localize62.Text %>&quot;);return false;"></span>
                                                </td>
                                        </tr>
                                        <tr>
                                            <td  align="left"  style="padding:3px; font-size:14px; font-weight:100;color:#404040;">
                                                 <asp:Localize ID="Localize6" meta:resourcekey="asp_string51" runat="server">Total File Size (GB)</asp:Localize>
                                            </td>
                                            <td>
                                                 <span class="badge"> <asp:Label ID="FileSize" runat="server" Text="0"></asp:Label></span>
                                            </td>
                                            <td  style="cursor:pointer;padding-right:5px;" align="right">
                                                <span class="fa fa-zoom-in" style="font-size:14px; color:#404040;" onclick="SetView('admindashboard.aspx?mode=1&vdid=<%= ViewSessionDomainId %>',&quot;<asp:Localize meta:resourcekey="str_rpt" runat="server">Reports</asp:Localize>&quot;);return false;" ></span>
                                                </td>
                                        </tr>
                                        <tr>
                                            <td  align="left"  style="padding:3px; font-size:14px; font-weight:100;color:#404040;"><asp:Localize meta:resourcekey="str_bkdStg" runat="server">Backend Storage</asp:Localize>
                                            </td>
                                            <td>
                                                 <span class="badge"> <asp:Label ID="StorageProvider" runat="server" Text=""></asp:Label></span>
                                            </td>
                                            <td  style="cursor:pointer; padding-right:5px;" align="right">
                                                <% if (m_ShowStorageManager)
                                                   { %>
                                                <span class="fa fa-edit" style="font-size:14px; color:#404040;" onclick="SetView('/management/StorageMgr.aspx?vdid=<%= ViewSessionDomainId %>',&quot;<%=sttext.Text %>&quot;);return false;" ></span>
                                                <% } %>
                                                
                                                </td>
                                        </tr>

                                        <tr  title="<%= asp_string37.Text %>" style="display:none;">
                                            <td style="padding-top: 30px" align="center">
                                                <% if (SessionIsAdmin && !EditingTenant)
                                                   { %>
                                                <table>
                                                    <tr>
                                                        <td style="padding-right: 20px">
                                                            <% if (m_EditUser)
                                                               { %>
                                                            <asp:Localize ID="asp_string27" meta:resourcekey="asp_string27" runat="server" Visible="False">Add Users</asp:Localize>
                                                            <a href="javascript:;" onclick="OnAddUserWizard();return false;" style="font-size: 12px;" title='<%= asp_string27.Text %>'>
                                                                <img class="mcon_adduser32" width="32px" height="32" src="s.gif" alt="" /></a>
                                                            <% } %>
                                                        </td>
                                                        <td style="padding-right: 20px; display: none;">
                                                            <asp:Localize ID="asp_string28" meta:resourcekey="asp_string28" runat="server" Visible="False">Batch create user/Migrate User</asp:Localize>
                                                            <a href="javascript:;" onclick="OnAddUserWizard();return false;" style="font-size: 12px;" title="<%= asp_string28.Text %>">
                                                                <img class="mcon_adduser32" width="32px" height="32" src="s.gif" alt="" /></a>
                                                        </td>
                                                        <td>
                                                            <% if (m_ShowUserMgr)
                                                               { %>
                                                            <asp:Localize ID="asp_string29" meta:resourcekey="asp_string29" runat="server" Visible="False">Manage Users</asp:Localize>
                                                            <a href="javascript:;" onclick="OnUserMgr();return false;" style="font-size: 12px;" title="<%= asp_string29.Text %>">
                                                                <img class="mcon_follow32" width="32px" height="32" src="s.gif" alt="" /></a>
                                                            <% } %>
                                                        </td>
                                                    </tr>
                                                </table>
                                                <% }
                                                   else
                                                   { %>
                                               <b></b>
                                                <% } %>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                  <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 text-center topbuffer">
                            <div class=" panel panel-warning">
                                <div class="panel-heading">
                               
                                        <table width="100%">
                                        <tr>
                                            <td align="left">
                                                <asp:Localize meta:resourcekey="str_pndApvDvc" runat="server">Pending Approval Devices</asp:Localize>
                                            </td>
                                            <td align="right">
                                                 <span class="fa fa-wrench" style="font-size:14px; color:white;cursor:pointer;" onclick="SetView('/portal/SearchDevicesPage.aspx?vdid=<%= ViewSessionDomainId %>',&quot;<asp:Localize meta:resourcekey="str_cntDvcMgr" runat="server">Client Device Manager</asp:Localize>&quot;);return false;" ></span>
                                            </td>
                                        </tr>
                                    </table>
                                    </div>
                                <div class="panel-body" style=" width: 100%; height:160px;" id="Div1">
                                    <% if (HasDevice)
                                       { %>
                                    <table width="100%" >
                                           <tr>
                                            <td style="align-content: center;">
                                                <div class="row " style=" align-content: center; padding-left: 20px; padding-bottom: 10px;">
                                                 <asp:Repeater ID="DeviceList" runat="server">
                                        <ItemTemplate>
                                            <div class="col-xs-2 col-sm-2 col-md-2 col-lg-2 text-center topbuffer">
                                                <a href="javascript:;" onclick="OnDeviceDashboard('<%#DataBinder.Eval(Container.DataItem, "InstanceId")%>'); return false;">
                                                <table width="100%" >
                                                    <tr>
                                                        <td align="center" style="padding-bottom: 0px;vertical-align: bottom" valign="bottom">
                                                            <div class="panel panel-default"  style="padding: 5px; width: 63px; height: 63px;" data-toggle="tooltip"
                                                     title=" <%#DataBinder.Eval(Container.DataItem, "ClientVer")%> &#13;&#10;"
                                                 >
                                                    <div style="padding:2px; width: 52px; height: 52px;background: url(images/<%#DataBinder.Eval(Container.DataItem, "UserId")%>) no-repeat ;">
                                                        <table width="100%" style="width: 100%; height: 100%;" >
                                                        
                                                        <tr>
                                                            
                                                            <td valign="bottom" align="right" >
                                                                <span class="fa <%#DataBinder.Eval(Container.DataItem, "SyncStatusIcon")%>  " title="<%#DataBinder.Eval(Container.DataItem, "SyncStatusString")%>" style="color:<%#DataBinder.Eval(Container.DataItem, "SyncStatusColor")%>; font-size: 24px;"></span>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                    
                                                    </div>
                                                    
                                                   
                                                
                                                
                                                </div>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="text-muted" style="font-size: 14px;" valign="top">
                                                            <%#DataBinder.Eval(Container.DataItem, "HostName")%>
                                                        </td>
                                                    </tr>
                                                </table>
                                                </a>
                                                 
                                            </div>
                                        </ItemTemplate>
                                    </asp:Repeater>
                                    </div>
                                            </td>
                                        </tr>
                                    </table>
                                    <% }
                                       else
                                       { %>
                                      <div style="font-size:16px; font-weight:100; color:#404040;padding-top:20px;"><asp:Localize runat="server" meta:resourcekey="str_NoSerAgeFou">No server agent found.</asp:Localize></div>
                                    <% } %>              
                                </div>
                            </div>
                        </div>
                  </div>
              </div>
          </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal"><asp:Localize meta:resourcekey="str_cls" runat="server">Close</asp:Localize></button>
      </div>
    </div>

  </div>
</div>
                
            </td>
        </tr>
        <% } %>
        <tr>
            <td align="center">
                <span class="auto-style1" style="display: none;">
                    <asp:Localize meta:resourcekey="asp_string1" runat="server"></asp:Localize></span>
                <table width="100%" cellspacing="0" cellpadding="0" style="padding: 0px; height: 40px;"
                    border="0" valign="top">
                    <tr>
                        <% if (EditingTenant)
                           { %>
                        <% if (m_IsActivated)
                           { %>
                        <td width="310px" onmouseleave="HideUserMenu(event)" style="cursor: hand;display: none;" align="left">
                            <table cellpadding="0" cellspacing="0">
                                <tr>
                                    <td style="height: 10px; cursor: hand; white-space: nowrap;" width="160px" nowrap="nowrap"
                                        id="UserMenuBtn" class="returnlbl x-tab-default-active" align="center" onmouseover='ShowUserMenu();'>
                                        <table width="100%">
                                            <tr>
                                                <td width="16px" style="vertical-align: middle;">
                                                    <div style="width: 16px; height: 16px;">
                                                        <img src="/portal/images/menu.png" height="16px" alt="" /></div>
                                                </td>
                                                <td align="center">
                                                    <asp:Label ID="AdminName" runat="server" Text=""></asp:Label>
                                                </td>
                                                <td width="20px" align="right">
                                                    &#x25BC;
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                    <td onmouseover='ShowUserMenu();' align="left" id="UserMenuBtnImg" width="16px" style="padding: 3px">
                                    </td>
                                    <td id="UserMenuBtnRight">&nbsp;
                                        
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2" style="padding-right: 10px">
                                        <div class='usermenubody' id="usermenu" style="border-top: 1px solid #808080; z-index: 9999;">
                                            <table width="100%" cellpadding="0" cellspacing="0">
                                                <tr>
                                                    <td colspan="2" height="150px" style="padding: 10px;" valign="top">
                                                        <table width="100%">
                                                            <tr>
                                                                <td width="32px">
                                                                    <img width="24px" src="/portal/images/changepassword.png" />
                                                                </td>
                                                                <td valign="middle">
                                                                    <a href="javascript:;" onclick='parent.parent.ResetPassword();return false;' style="font-size: 12px;
                                                                        color: Black;">
                                                                        <asp:Localize meta:resourcekey="str_changeadminpwd" runat="server">Change Tenant Admin Password</asp:Localize>
                                                                    </a>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td width="32px">
                                                                    <img width="24px" src="/portal/images/editstor.png" alt="" />
                                                                </td>
                                                                <td valign="middle">
                                                                    <a href="javascript:;" onclick='parent.parent.EditStorage();return false;' style="font-size: 12px;
                                                                        color: Black;">
                                                                        <asp:Localize meta:resourcekey="str_editexde" runat="server">Edit existing default storage</asp:Localize>
                                                                    </a>
                                                                </td>
                                                            </tr>
                                                            <% if (m_CanChangeDefaultStorage)
                                                               { %>
                                                            <tr>
                                                                <td width="32px">
                                                                    <img width="24px" src="/portal/images/mystorage.png" />
                                                                </td>
                                                                <td valign="middle">
                                                                    <a href="javascript:;" onclick='parent.parent.EditCloudStorageEx();return false;' style="font-size: 12px;
                                                                        color: Black;">
                                                                        <asp:Localize meta:resourcekey="str_editdecl" runat="server">Replace default storage with new cloud storage</asp:Localize>
                                                                    </a>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td width="32px">
                                                                    <img width="24px" width="32" src="/portal/images/addlocal.png" alt="" />
                                                                </td>
                                                                <td valign="middle">
                                                                    <a href="javascript:;" onclick='parent.parent.EditLocalStorage();return false;' style="font-size: 12px;
                                                                        color: Black;">
                                                                        <asp:Localize meta:resourcekey="str_editdefloc" runat="server">Replace default storage with new local storage</asp:Localize>
                                                                    </a>
                                                                </td>
                                                            </tr>
                                                            <% } %>
                                                            <tr>
                                                                <td colspan="2" style="height: 5px; border-top: 1px solid #e0e0e0;">
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td width="32px">
                                                                    <img width="24px" width="32" src="/portal/images/forcesync.png" alt="" />
                                                                </td>
                                                                <td valign="middle">
                                                                    <a href="javascript:;" onclick='RefreshTenant();return false;' style="font-size: 12px; color: Black;">
                                                                        <asp:Localize ID="Localize2" meta:resourcekey="str_forcescan" runat="server">Force full scan for storage quota usage</asp:Localize>
                                                                    </a>
                                                                </td>
                                                            </tr>
                                                            <% if (!IsDefaultTenant)
                                                               { %>
                                                            <tr>
                                                                <td width="32px">
                                                                    <img width="24px" src="images/trash.png" alt="" />
                                                                </td>
                                                                <td valign="middle">
                                                                    <a href="javascript:;" onclick='DeleteTenant();return false;' style="font-size: 12px; color: Black;">
                                                                        <asp:Localize meta:resourcekey="str_deltenant" runat="server">Delete Tenant</asp:Localize>
                                                                    </a>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td width="32px">
                                                                    <img width="24px" src="images/stop.png" alt="" />
                                                                </td>
                                                                <td valign="middle">
                                                                    <a href="javascript:;" onclick='OnSuspend();return false;' style="font-size: 12px; color: Black;">
                                                                        <asp:Localize meta:resourcekey="str_disabletenant" runat="server">Disable Tenant</asp:Localize>
                                                                    </a>
                                                                </td>
                                                            </tr>
                                                            <% }
                                                               else
                                                               { %>
                                                            <tr>
                                                                <td width="32px">
                                                                    <img src="images/fexplorer24.png" height="24px" title="My Files" alt="" />
                                                                </td>
                                                                <td valign="middle">
                                                                    <a href="/portal/files" target="_blank" style="font-size: 12px; color: Black;">
                                                                        <asp:Localize meta:resourcekey="str_openportal" runat="server">Open Web Portal</asp:Localize>
                                                                    </a>
                                                                </td>
                                                            </tr>
                                                            <% } %>
                                                        </table>
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                    </td>
                                </tr>
                            </table>
                        </td>
                        <% }
                           else
                           { %>
                        <td align="left" style="color: red; font-size: 14px;">
                            <asp:Localize runat="server" meta:resourcekey="str_tnt">Tenant,</asp:Localize>
                            <%=AdminName.Text %><asp:Localize meta:resourcekey="str_isSpd" runat="server">, is suspended. </asp:Localize><a href="javascript:;" onclick="OnResume();return false;"><asp:Localize meta:resourcekey="str_resNow" runat="server">Resume Now</asp:Localize></a>
                            <% %>
                            <% } %>
                            <% } %>
                            <td style="color: #606060; font-weight: bold; overflow: hidden;" nowrap="nowrap"
                                valign="middle">
                            </td>
                            <td width="30px" align="left" style="padding-left: 4px; display: none;" nowrap="nowrap">
                            </td>
                            <td align="center" style="overflow: hidden;">
                                <div id="errmsgdiv">
                                    <b>
                                        <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;"></asp:Label></b>
                                </div>
                            </td>
                            <td width="50px" align="left" style="padding-left: 4px; display: none;">
                            </td>
                            <td style="width: 1px; overflow: hidden">
                                <%if (GetWebSessionTimeout() != 0)
                                  { %>
                                <iframe id='Iframe1' src="/portal/RefreshPage.aspx" frameborder="0" border="0" style="width: 1px;
                                    height: 1px"></iframe>
                                <%} %>
                            </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
    <asp:Panel ID="AssetPanel" runat="server" meta:resourcekey="AssetPanelResource1">
        <div class="dropdown" style="width:380px;float:right;">
            <span id="edtStgDDMLnk2" class="dropdown-toggle" data-toggle="dropdown" style="display:none;"></span>
            <div id="edtStgDDM2" class="dropdown-menu dropdown-menu-right"></div>
        </div>
          <div  id="topmenu" style="height:60px; padding-top:14px; padding-left:20px;  width:100%; display:none;   box-shadow:0px 3px 3px #c0c0c0;" valign="top" class="trbordercolor">
                        <table>
                            <tr>

                                <td style="padding:5px;">
                                    <% if (SessionIsClusterAdmin || SessionIsDelegateClusterAdmin){ %>         
                                     <i class="gladinet-icons md-32 md-dark hand center toolbtn" title="<%=str_tplan.Text %>" onclick="SetView('TenantPlanPage.aspx?mode=1&userid=<%= TargetAdminId.Value %>',&quot;<%= str_tplan.Text %>&quot;);return false;" style="line-height:32px;">g</i>
                                    <%} %>
                                </td>
                                <td style="padding:5px;">
                                    <% if (SessionIsClusterAdmin || SessionIsDelegateClusterAdmin || ManagingByPartner){ %>                                    
                                    <i class="gladinet-icons md-32 md-dark hand center toolbtn"  title="<%=str_tac.Text %>" onclick="SetView('TenantAccessCtrl.aspx?mode=1&userid=<%= TargetAdminId.Value %>',&quot;<%= str_tac.Text %>&quot;);return false;" style="line-height:32px;">r</i>
                                    <%} %>
                                </td>
                                <td style="padding:5px;">
                                    <i class="gladinet-icons md-32 md-dark hand center toolbtn"  title="<%=str_cpl.Text %>" onclick="SetView('/management/TenantControlPanel.aspx?vdid=<%=SessionDomainId %>',&quot;<%=str_cpl.Text %>&quot;);return false;" style="line-height:32px;">c</i>
                                </td>
                                <td style="padding:5px;">
                                    <i class="gladinet-icons md-32 md-dark hand center toolbtn"  title="<%=str_um.Text %>" onclick="OnUserMgr();return false;"  title="<%= str_um.Text %>" style="line-height:32px;">8</i>
                                </td>
                                <td style="padding:5px;">
                                    <%if(m_ShowGuestUserManager) { %>
                                    <i class="gladinet-icons md-32 md-dark hand center toolbtn"  title="<%=str_guestusers.Text %>" onclick="SetView('/management/GuestUserMgrPage.aspx?vdid=<%=SessionDomainId %>',&quot;<%=str_guestusers.Text %>&quot;);return false;" style="line-height:32px;">6</i>
                                    <%} %>
                                </td>
                                <td style="padding:5px;">
                                    <i class="gladinet-icons md-32 md-dark hand center toolbtn"  title="<%=str_grps.Text %>" onclick="SetView('/portal/GroupMgrPage.aspx?vdid=<%=SessionDomainId %>',&quot;<%=str_grps.Text %>&quot;);return false;" style="font-size:42px;line-height:42px;position:relative;top:2px;">G</i>
                                </td>
                                <td style="padding:5px;">
                                    <i class="gladinet-icons md-32 md-dark hand center toolbtn"  title="<%=str_roles.Text %>" onclick="SetView('/management/RoleMgrPage.aspx?vdid=<%=SessionDomainId %>',&quot;<%=str_roles.Text %>&quot;);return false;" style="line-height:32px;">M</i>
                                </td>
                                <td style="padding:5px;">
                                     <i class="gladinet-icons md-32 md-dark hand center toolbtn"  title="<%=str_teamfolders.Text %>" onclick="OnCollab();return false;" style="font-size:33px;line-height:33px;position:relative;top:2px;">+</i>
                                </td>
                                <td style="padding:5px;">
                                    <%if(m_ShowGroupPolicy||SessionIsClusterAdmin || SessionIsDelegateClusterAdmin) { %>
                                    <i class="gladinet-icons md-32 md-dark hand center toolbtn"  title="<%=str_gp.Text %>"  onclick="SetView('/management/GroupPolicyMgrPage.aspx?vdid=<%=SessionDomainId %>',&quot;<%=str_gp.Text %>&quot;);return false;" style="font-size:40px;line-height:40px;position:relative;top:1px;">S</i>
                                    <%} %>
                                </td>
                                <td style="padding:5px;">
                                    <%if(SessionIsClusterAdmin || SessionIsDelegateClusterAdmin) { %>
                                    <i class="gladinet-icons md-32 md-dark hand center toolbtn"  title="<%=str_accessp.Text %>"  onclick="SetView('/management/AccessPolicy/AccessPolicyMgrPage.aspx?vdid=<%=SessionDomainId %>',&quot;<%=str_accessp.Text %>&quot;);return false;" style="font-size:28px;line-height:28px;position:relative;top:1px;">&#x162;</i>
                                    <%} %>
                                </td>
                                <td style="padding:5px;">
                                    <%if(m_ShowBranding ||SessionIsClusterAdmin || SessionIsDelegateClusterAdmin) { %>
                                    <i class="gladinet-icons md-32 md-dark hand center toolbtn"  title="<%=str_branding.Text %>" onclick="SetView('BrandingMgrPage.aspx?mode=edit&brid=<%=SessionDomainId %>',&quot;<%=str_branding.Text %>&quot;);return false;" style="line-height:32px;">B</i>
                                    <%} %>
                                </td>
                                <td style="padding:5px;">
                                     <i class="gladinet-icons md-32 md-dark hand center toolbtn"  title="<%=StrReports.Text %>"  onclick="SetView('/management/AdminDashboard.aspx?vdid=<%=SessionDomainId %>',&quot;<%=str_reports.Text %>&quot;);return false;" style="line-height:32px;">R</i>
                                </td>
                                <td style="padding:5px;">
                                    <%if(m_AllowBackup && !IsHostedFarm) { %>
                                    <i class="gladinet-icons md-32 md-dark hand center toolbtn"  title="<%=str_backuptitle.Text %>" onclick="parent.OnTenantBackupMgr();return false;" style="font-size:40px;line-height:40px;position:relative;top:1px;margin-right:-5px;">&#x14C;</i>
                                    <%} %>
                                    
                                </td>
                                <td style="padding:5px; display:none;">
                                    <i class="gladinet-icons md-32 md-dark hand center toolbtn"  title="<%=str_addsa.Text %>" style="line-height:32px;">(</i>
                                </td>
                                <td style="padding:5px;">
                                     <% if (m_ShowLDAP && !IsHostedFarm){ %>
                                    <i class="gladinet-icons md-32 md-dark hand center toolbtn"  title="<%=str_adStg.Text %>" onclick="SetView('/management/LDAPCfgPage.aspx?c=1&g=<%= ViewSessionDomainId %>','<%=str_adStg.Text %>');return false;" style="line-height:32px;">A</i>
                                    <%} %>
                                </td>
                                                                <td style="padding:5px;">

                                </td>

                            </tr>
                        </table>
                        
                         </div>
        <div style="width:100%; display:none; padding-bottom:10px; padding-top:10px;  height:80px; overflow:hidden;" id="hint00">

                     </div>   
        <div style="overflow:auto;" id="wdiv">
            <% if (!IsMobile()){ %>
            <table width="100%"  align="center" style="height:100%;">
                
                <tr>
                    <td id="centerCell" style="padding:0px; padding-right: 25px;padding-left: 25px; padding-top: 15px;" valign="top">
                     <%if(m_HideDashUsersList && m_HideDashTeamFoldersList){%>
                        <iframe src="/management/TenantBandwidthStat.aspx?child=1&amp;vdid=<%=SessionDomainId%>" border="0" id="main_body" style="height: 486px; margin-top: 8px;" width="100%" height="100%" frameborder="0"></iframe>
                    <%}%>
                    <div class="row "  style=" padding: 0px!important;<%if(m_HideDashUsersList){%>display:none;<%}%>">
                        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 text-center topbuffer staticviewcarddark" style="width: 100%; background-color: white;  padding: 0px; margin: 0px;" >
                             <table width="100%">
                                <tr style="padding: 10px; border-bottom: 1px solid #f0f0f0;overflow:hidden;" class="boxbordercolor menubox" id="userhead">
                                    <td  style="height: 96px!important; border-bottom: 1px solid #e8e8e8;  width: 48px; padding-right: 5px;" align="right" valign="middle"  class="panel-heading" id="head0">
                                       <i class="gladinet-icons md-32 md-dark hand center toolbtn">G</i>
                                    </td>
                                    <td style=" border-bottom: 1px solid #e8e8e8; color: #202020; font-weight: 300; font-size: 24px; padding-left: 3px;" align="left" valign="middle" id="head01">
                                        <span class="toolnavbtn sectextcolor" style=" cursor: pointer;" onclick="OnUserMgr();return false;"  title="<%= str_um.Text %>"><%= Localize12.Text %></span>
                                    </td>
                                    <td style=" border-bottom: 1px solid #e8e8e8; color: #565656; font-weight: 300; font-size: 24px; padding-right: 10px;" align="right" valign="middle" id="head02">
                                         <span class="fa fa-chevron-right toolbtn sectextcolor" onclick="OnUserMgr();return false;"   style="cursor: pointer;" title="<%= str_um.Text %>"></span>
                                    </td>
                                </tr>
                               
                                <tr>
                                    <td colspan="3" style=" color: #565656; font-weight: 100; font-size: 16px;  min-height:160px; max-height: 410px; overflow: auto; " align="left" valign="middle">        
                                        <div style=" min-height:160px; max-height: 410px; overflow-x: hidden; overflow-y: auto; width: 100%;">
                                        <table width="98%">
                                        <tr>
                                            <td style="align-content: center;">
                                                <div class="row limitWidth" style="align-content: center; padding-left: 20px; padding-bottom: 10px;">
                                                    <div class="col-xs-4 col-sm-4 col-md-3 col-lg-2 text-center topbuffer">
                                                         <a href="javascript:;" onclick="OnAddUserWizard();return false;">
                                                                    <table width="100%">
                                                                        <tr>
                                                                            <td align="center" style="padding-bottom: 0px; vertical-align: bottom" valign="bottom">
                                                                                    <div style="padding-left: 2px; width: 96px; height: 70px; font-size:64px;padding-top:18px;
                                                                                            " class="toolbtn addnewbox sectextcolor" title="<%= str_newu.Text %>">
                                                                                             <span class=" iconviewitemcolor" aria-hidden="true" style="font-size: 48px; margin-left: 45px; margin-top: -15px; display: inline-block; position: absolute;">+
                                                                            </span>
                                                                                    <i class="gladinet-icons md-32 iconviewitemcolor hand center" style="font-size: 50px; font-weight: 100;">M</i>                                    
                                                                                      </div>
                                                                                    


                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="text-muted" style="font-size: 14px; font-weight: 100;" valign="top">
                                                            <asp:Localize meta:resourcekey="str_newu" id="str_newu" runat="server">Add New User</asp:Localize>
                                                        </td>
                                                    </tr>
                                                            </table>
                                                                </a>
                                                 
                                                    </div>

                                                    <asp:Repeater ID="UserList" runat="server">
                                                        <ItemTemplate>
                                                            <div class="col-xs-4 col-sm-4 col-md-3 col-lg-2 text-center topbuffer"
                                                                
                                                                >
                                                                
                                                                <table width="100%" >
                                                                    <tr>
                                                                        <td align="center" style="padding-bottom: 0px; vertical-align: bottom" valign="bottom">
                                                                            <div style="padding: 2px; width: 100%; height: 96px; position: absolute; display: none; align-content: center;" id="e_<%#DataBinder.Eval(Container.DataItem, "UserGuid")%>">
                                                                                <table align="center" style="margin-top: 70px; padding: 10px; width:100%"  t> 
                                                                                    <tr>
                                                                                        <td align="center" style="padding-right: 25px;background-color: white; ">
                                                                                            <a href="javascript:;" onclick='EditUser("<%#DataBinder.Eval(Container.DataItem, "UserGuid")%>","<%#DataBinder.Eval(Container.DataItem, "FirstName")%>  <%#DataBinder.Eval(Container.DataItem, "LastName")%> (<%#DataBinder.Eval(Container.DataItem, "Email")%>)");return false;'>
                                                                                                <span class="fa fa-edit" style="font-size: 16px; color: #a0a0a0;"></span>
                                                                                            </a>
                                                                                            &nbsp; &nbsp;
                                                                                                     <a style="<%#DataBinder.Eval(Container.DataItem, "ControlDisplay")%>" href="#" onclick='DeleteUser("<%#DataBinder.Eval(Container.DataItem, "UserGuid")%>","<%#DataBinder.Eval(Container.DataItem, "FirstName")%>  <%#DataBinder.Eval(Container.DataItem, "LastName")%> (<%#DataBinder.Eval(Container.DataItem, "Email")%>)");return false;'>
                                                                                                         <span class="fa fa-remove" style="font-size: 16px; color: #a0a0a0;"></span>
                                                                                                     </a>
                                                                                        </td>

                                                                                    </tr>
                                                                                </table>
                                                                            </div>
                                                                            <div style="padding: 2px; width: 96px; height: 70px; cursor: pointer; " class="toolbtn"
                                                                                id="p_<%#DataBinder.Eval(Container.DataItem, "UserGuid")%>" title=" <%#DataBinder.Eval(Container.DataItem, "FirstName")%>  <%#DataBinder.Eval(Container.DataItem, "LastName")%> (<%#DataBinder.Eval(Container.DataItem, "Email")%>)"
                                                                                onclick='EditUser("<%#DataBinder.Eval(Container.DataItem, "UserGuid")%>","<%#DataBinder.Eval(Container.DataItem, "FirstName").ToString().Replace("'","%27").Replace("\n"," ")%>  <%#DataBinder.Eval(Container.DataItem, "LastName").ToString().Replace("'","%27").Replace("\n"," ")%> (<%#DataBinder.Eval(Container.DataItem, "Email").ToString().Replace("'","%27").Replace("\n"," ")%>)");return false;'
                                                                                >
                                                                                <i class="gladinet-icons md-63  hand iconviewitemcolor" style="margin-top: 20px; margin-left: -2px;" id="av_<%#DataBinder.Eval(Container.DataItem, "UserGuid")%>" title="<%#DataBinder.Eval(Container.DataItem, "FirstName")%>  <%#DataBinder.Eval(Container.DataItem, "LastName")%> (<%#DataBinder.Eval(Container.DataItem, "Email")%>)">M</i> 

                                                                                


                                                                                <img   style="display: none; border-radius: 50%;" title="<%#DataBinder.Eval(Container.DataItem, "FirstName")%>  <%#DataBinder.Eval(Container.DataItem, "LastName")%>" id="i_<%#DataBinder.Eval(Container.DataItem, "UserGuid")%>" src="/storage/avarta.dn?u=<%#DataBinder.Eval(Container.DataItem, "UserGuid")%>&w=64&h=64&d=<%=SessionDomainId %>" onload="OnAvLoad('<%#DataBinder.Eval(Container.DataItem, "UserGuid")%>')" alt="" />

                                                                            </div>
                                                                            

                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="text-muted" style="font-size: 14px; font-weight: 100;" valign="top" >
                                                                            <%#GetShortStringEx(DataBinder.Eval(Container.DataItem, "FirstName").ToString()+" "+DataBinder.Eval(Container.DataItem, "LastName").ToString(),16)%>
                                                                            
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                                
                                                 
                                                            </div>
                                                        </ItemTemplate>
                                                    </asp:Repeater>
                                                </div>
                                            </td>
                                        </tr>
                                    </table>
                                            </div>                                
                                    </td>
                                </tr>
                            </table>
                            
                        </div>
                        </div>
                         <div class="row "  style=" padding: 0px; padding-top: 10px!important;<%if(m_HideDashTeamFoldersList){%>display:none;<%}%><%if(m_HideDashUsersList){%>padding-top:0px!important;<%}%>">
                          <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 text-center topbuffer staticviewcarddark" style="width: 100%; background-color: white;  padding: 0px;<%if(m_HideDashUsersList){%>margin-top:0px!important;<%}%>">
                                
                                 <table width="100%">
                                <tr style="padding: 10px; border-bottom: 1px solid #f0f0f0;" class="boxbordercolor menubox" id="teamhead">
                                    <td  style="height: 96px!important; border-bottom: 1px solid #e8e8e8;  width: 48px; padding-right: 5px;" align="right" valign="middle"  class="panel-heading"  id="head1">
                                       <i class="gladinet-icons md-32 md-dark hand center toolbtn">+</i>
                                    </td>
                                    <td style=" border-bottom: 1px solid #e8e8e8; color: #202020; font-weight: 300; font-size: 24px; padding-left: 5px;" align="left" valign="middle">
                                         <asp:Localize meta:resourcekey="str_infs" runat="server" Visible="False">Imported Network File Shares</asp:Localize>
                                        <span class="toolnavbtn sectextcolor" onclick="OnCollab();return false;"  style="cursor: pointer; " title="<%= Localize61.Text %>"><asp:Localize meta:resourcekey="str_tmflds" runat="server">Team Folders (Shared WorkSpaces)</asp:Localize></span>
                                    </td>
                                    <td style=" border-bottom: 1px solid #e8e8e8; color: #565656; font-weight: 300; font-size: 24px; padding-right: 10px;" align="right" valign="middle">
                                         <span class="fa fa-chevron-right toolbtn sectextcolor" onclick="OnCollab();return false;" style="cursor: pointer; " title="<%= Localize61.Text %>"></span>
                                    </td>
                                </tr>
                                      <tr>
                                    <td colspan="3" style=" color: #565656; font-weight: 100; font-size: 16px;  min-height: 160px; max-height: 410px; overflow: auto;" align="left" valign="middle">       
                                        <div style=" min-height:160px; max-height: 410px; overflow-x: hidden; overflow-y: auto; width: 100%;">
                                         <asp:Panel ID="HasTeamFolderPanel" runat="server" Visible="false">
                                    <table width="98%">
                                        <tr>
                                            <td style="align-content: center;">
                                                <div class="row limitWidth" style="align-content: center; padding-left: 20px; padding-bottom: 10px;">
                                                    <div class="col-xs-4 col-sm-4 col-md-3 col-lg-2 text-center topbuffer">
                                                         <a href="javascript:;" onclick="ImportShare();return false;">
                                                                    <table width="100%">
                                                                        <tr>
                                                                            <td align="center" style="padding-bottom: 0px; vertical-align: bottom" valign="bottom">
                                                                                    <div style="padding-left: 2px; width: 96px; height: 70px; font-size:64px;padding-top:19px;" title="<%=str_cteamfolder.Text%>" class="toolbtn addnewbox sectextcolor">
                                                                                              <span class=" iconviewitemcolor" aria-hidden="true" style="font-size: 48px; margin-left: 45px; margin-top: -15px; display: inline-block; position: absolute;">+
                                                                            </span>
                                                                                    <i class="gladinet-icons md-32 iconviewitemcolor hand center" style="font-size: 50px; font-weight: 100;">+</i>                                    
                                                                                                       
                                                                                      </div>
                                                                                    

                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="text-muted" style="font-size: 14px;" valign="top">
                                                           <%=str_cteamfolder.Text%>
                                                             <asp:Localize meta:resourcekey="str_cmgr" id="str_cmgr" Visible="False" runat="server">Click to manage</asp:Localize>
                                                        </td>
                                                    </tr>
                                                            </table>
                                                                </a>
                                                 
                                                    </div>

                                                    <asp:Repeater ID="ShareList" runat="server">
                                                        <ItemTemplate>
                                                            <div class="col-xs-4 col-sm-4 col-md-3 col-lg-2 text-center topbuffer" style="cursor: pointer;border-radius: 6px;"  onclick='EditShare("<%#DataBinder.Eval(Container.DataItem, "DirLocation").ToString().Replace("&","%26").Replace("'","&apos;")%>","<%#DataBinder.Eval(Container.DataItem, "ShareName")%>")' title="<%=str_cmgr.Text %>"  >
                                                                
                                                                <table width="100%">
                                                                    <tr>
                                                                        <td align="center" style="padding-bottom: 0px; vertical-align: bottom" valign="bottom">
                                                                            
                                                                                <div style="padding: 2px; width: 96px; height: 70px;cursor: pointer; "  class="toolbtn"
                                                                               >
                                                                                    <i class="gladinet-icons md-63  hand iconviewitemcolor" style="display: block; margin-top: 20px;" ><%#DataBinder.Eval(Container.DataItem, "StorageIcon")%></i>

                                                                                    
                                                                                   

                                                                                </div>


                                                                            

                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="text-muted" style="font-size: 14px;" valign="top">
                                                                            <%#GetShortStringEx(DataBinder.Eval(Container.DataItem, "ShareName").ToString(),16)%>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                              
                                                 
                                                            </div>
                                                        </ItemTemplate>
                                                    </asp:Repeater>
                                                </div>
                                            </td>
                                        </tr>
                                    </table>
                                        </asp:Panel>
                                    <asp:Panel ID="NoTeamFolderPanel" runat="server">
                                        <table width="98%" style="padding: 5px; font-weight: 100; color: #565656;">
                                            <tr>
                                                <td width="132px" style="padding: 10px; height: 140px;">
                                                    <i class="gladinet-icons md-32 md-dark hand center toolbtn" style="font-size: 128px; display: inline-block;"\>+</i>
                                                </td>
                                                <td style="padding: 10px; padding-top: 20px; padding-bottom: 30px;" align="left"><asp:Localize meta:resourcekey="str_temFldAreShdWsp" runat="server">Team folders are shared workspaces for assigned users. Each team folder may be associated with the backend storage from a file server network share, cloud storage services like AWS S3, Azure blob, Wasabi etc. or a team folder that is created from scratch. IT can set permissions independently on team folders and the sub-folders inside it. Team folders can also mirror the existing NTFS permissions or enforce permissions against existing NTFS permissions. 
</asp:Localize>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="2" align="right" style="padding-top: 5px; border-top: 1px solid #f0f0f0;">
                                                    <button  class="btn btn-primary gladbtn sectextcolor" onclick="ImportShare();return false;"><%=str_cteamfolder.Text%></button>
                                                </td>
                                            </tr>
                                        </table>
                                    </asp:Panel>
                                            </div>
                                        </td>
                                          </tr>
                                     </table>
                                
                            </div>
                           
                   
                    </div>

                        
                     
                    <div class="row " style="display:none;">
                             <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6 text-center topbuffer" style="display:none;">
                            <div class="AssetBox2 panel panel-info">
                                <div class="panel-heading">
                                    
                                </div>
                                <div class="panel-body">
                                    <table width="100%">
                                        <tr>
                                            <td class="AssetInfo" title="<%= asp_string33.Text %>">
                                                
                                                
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="font-size: 12px; font-weight: bold; align-content: center;" align="center">&nbsp;
                                                
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding-top: 30px" align="center">
                                                <% if (SessionIsAdmin && !EditingTenant)
                                                   { %>
                                                <table>
                                                    <tr>
                                                        <td style="padding-right: 20px">
                                                            <asp:Localize ID="asp_string34" Visible="False" meta:resourcekey="asp_string34" runat="server">Create a New Team Folder</asp:Localize>
                                                            <a href="javascript:;" onclick="AddPubFolderWizard();return false;" style="font-size: 12px;" title="<%= asp_string34.Text %>">
                                                                <img class="mcon_addteam32" width="32px" height="32" src="s.gif" alt="" /></a>
                                                        </td>
                                                        <td style="padding-right: 20px; display: none;">
                                                            <asp:Localize ID="asp_string35" Visible="False" meta:resourcekey="asp_string35" runat="server">Import Network Share </asp:Localize>
                                                            <a href="javascript:;" onclick="ImportShare();return false;" style="font-size: 12px;" title="<%= asp_string35.Text %>">
                                                                <img class="mcon_addteam32" width="32px" height="32" src="s.gif" alt="" /></a>
                                                        </td>
                                                        <td style="padding-right: 20px; display: none;">
                                                            <asp:Localize ID="asp_string36" Visible="False" meta:resourcekey="asp_string36" runat="server">Migrate CIFS Share from Server Agent as Team Folder</asp:Localize>
                                                            <a href="javascript:;" onclick="WizardMigrateShare();return false;" style="font-size: 12px;"
                                                                title="<%= asp_string36.Text %>">
                                                                <img class="mcon_migrate32" width="32px" height="32" src="s.gif" alt="" /></a>
                                                        </td>
                                                        <td>
                                                            <asp:LinkButton ID="ManageTeamFolders" runat="server" OnClientClick="OnCollab();return false;"
                                                                ToolTip="Manage Team Folders" meta:resourcekey="ManageTeamFoldersResource1"><img class="mcon_follow32" width="32px" height="32" src="s.gif" alt="" /></asp:LinkButton>
                                                        </td>
                                                    </tr>
                                                </table>
                                                <% } %>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6  text-center topbuffer" style="display:none;">
                            <div class="AssetBox2 panel panel-info" >
                                <div class="panel-heading">
                                    
                                </div>
                                <div class="panel-body">
                                    <table width="100%">
                                        <tr>
                                            <td class="AssetInfo">
                                                
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="font-size: 12px; font-weight: bold; align-content: center;" align="center">&nbsp;
                                                
                                            </td>
                                        </tr>
                                        <tr>
                                            <td align="center" style="padding-top: 30px">
                                                <table>
                                                    <tr>
                                                        <td>
                                                            <% if (SessionIsAdmin && !EditingTenant)
                                                               { %>
                                                            <asp:LinkButton ID="MgrSharedObjects" runat="server" meta:resourcekey="MgrSharedObjectsResource1"
                                                                OnClientClick="OnShare();return false;" ToolTip="Manage Shared Objects"><img class="mcon_follow32" width="32px" height="32" src="s.gif" alt="" /></asp:LinkButton>
                                                            <% } %>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6 text-center topbuffer" style="display:none;">
                            <div class="AssetBox2 panel panel-info" >
                                <div class="panel-heading">
                                   
                                </div>
                                <div class="panel-body">
                                    <table width="100%" border="0">
                                        <tr>
                                            <td class="AssetInfo">
                                                
                                            </td>
                                        </tr>
                                        <tr>
                                            <td align="center" valign="top">
                                                &nbsp;<b></b>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding-top: 30px" align="center">
                                                <% if (SessionIsAdmin && !EditingTenant){ %>
                                                <table>
                                                    <tr>
                                                        <td style="padding-right: 20px">
                                                            <asp:Localize Visible="False" ID="StrReports" meta:resourcekey="str_reports" runat="server">Reports</asp:Localize>
                                                            <a href="/management/admindashboard.aspx?vdid=<%= SessionDomainId %>" title="<%= StrReports.Text %>" onclick="parent.SetSecondPageTitle('<%= StrReports.Text %>','/management/admindashboard.aspx?vdid=<%= SessionDomainId %>');return true;">
                                                                <img class="cc_report32" width="32px" height="32" src="s.gif" alt="" />
                                                            </a>
                                                        </td>
                                                        <td>
                                                            <asp:Localize ID="StrWFB" meta:resourcekey="str_wfb" runat="server" Visible="False">Web File Browser</asp:Localize>
                                                            <a href="/portal/files" target="_blank" title="<%= StrWFB.Text %>">
                                                                <img class="mcon_follow32" width="32px" height="32" src="s.gif" alt="" />
                                                            </a>
                                                        </td>
                                                    </tr>
                                                </table>
                                                <% } %>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                      
                    </div>
                    </td>
                  
                    <td width="450px" style="height:100%;border-left:0px solid #f0f0f0; padding-right: 15px; padding-top: 15px;" id="rightmenu" valign="top">
                        <% } %>
                          <div style="width: 100%;height:100%;background-color:#FFF; " class="staticviewcarddark">
                            <table width="100%" style="height:100%;">
                                <tr style="display:none;height:96px;" valign="top">
                                    <td  style="height: 96px!important; border-bottom: 1px solid #e8e8e8;  width: 48px; padding-right: 5px; padding-left: 5px;" align="right" valign="middle">
                                        <% if (string.IsNullOrEmpty(m_TenantLogo)){ %>
                                        <i class="gladinet-icons md-63 md-dark hand center " style="font-size:64px;font-weight: 100;  margin-top:-5px;">t</i>
                                        <% }else{ %>
                                       <img width="64px" height="64" src="<%= m_TenantLogo %>" alt="" />
                                        <% } %>
                                    </td>
                                    <td style=" border-bottom: 1px solid #e8e8e8;  font-weight: 100; font-size: 28px; padding-left: 5px; color: #565656;" align="left" valign="middle" >
                                        <table>
                                            <tr>
                                                <td style="   font-weight: 100; font-size: 28px; padding-left: 5px; color: #565656;" colspan="2" >
                                                    <asp:Label ID="OrgName" runat="server" Text="Configure Tenant"></asp:Label>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td align="right" style="padding-right:10px;">
                                                    <asp:Label ID="StorageQuota" runat="server" Text="" CssClass="sectextcolor "></asp:Label>
                                                </td>
                                                <td width="32px">
                                                    <i class="gladinet-icons md-63 md-dark hand center toolbtn" title="<%=str_storagedetail.Text %>" onclick="StorageDetail();return false;" style="font-size:18px;line-height:18px;font-weight: 100;  margin-top:-5px;">&#xA7;</i>
                                                </td>
                                            </tr>
                                        </table>
                                        
                                        
                                    </td>
                                    <td style=" border-bottom: 1px solid #e8e8e8; color: #565656; font-weight: 300; font-size: 24px; padding-right: 10px;" align="right" valign="middle">
                                         <% if (UseDefaultStorage.Value == "true")
                                        { %>
                <button type="button" class="btn btn-warning btn-lg" data-toggle="modal" data-target="#WarningModal" style="padding: 3px !important;"><span class="fa fa-exclamation-sign" style="font-size: 24px;"></span></button>
                <% } %>
                                    </td>
                                </tr>
                              
                                <tr id="hint0" valign="top" style="height:1%;">
                                    <td colspan="3" style=" color: #565656; font-weight: 100; font-size: 16px; padding: 15px;" align="left" valign="middle" id="origcontrol">    
                                        <% if (SessionIsClusterAdmin || SessionIsDelegateClusterAdmin){ %>                                    
                                        <a class="btn btn-sm btnsmallex navtoolbtn" href="javascript:;" onclick="SetView('TenantPlanPage.aspx?mode=1&userid=<%= TargetAdminId.Value %>',&quot;<%= str_tplan.Text %>&quot;);return false;"><asp:Localize meta:resourcekey="str_tplan" id="str_tplan" runat="server">Tenant Plan</asp:Localize></a>
                                        <% } %>
                                        <% if (SessionIsClusterAdmin || SessionIsDelegateClusterAdmin || ManagingByPartner){ %>                                    
                                        <a class="btn btn-sm btnsmallex navtoolbtn" href="javascript:;" onclick="SetView('TenantAccessCtrl.aspx?mode=1&userid=<%= TargetAdminId.Value %>',&quot;<%= str_tac.Text %>&quot;);return false;"><asp:Localize meta:resourcekey="str_tac" id="str_tac" runat="server">Access Control</asp:Localize></a>
                                        <% } %>
                                        <a class="btn btn-sm btnsmallex navtoolbtn" href="javascript:;" onclick="SetView('/management/AdminDashboard.aspx?vdid=<%=SessionDomainId %>',&quot;<%=str_reports.Text %>&quot;);return false;"><asp:Localize meta:resourcekey="str_reports" id="str_reports" runat="server">Reports</asp:Localize></a>
                                        <% if (m_ShowEditAdmin){ %>
                                        <% if (SessionIsClusterAdmin || SessionIsDelegateClusterAdmin){ %>                                    
                                        <a class="btn btn-sm btnsmallex navtoolbtn" href="javascript:;" style="display: none;" onclick="SetView('TenantAdminInfo.aspx?mode=1&userid=<%= TargetAdminId.Value %>&vdid=<%= SessionDomainId %>',&quot;<%= str_ainfo.Text %>&quot;);return false;"><asp:Localize meta:resourcekey="str_ainfo" id="Localize8" runat="server">Administrator Info</asp:Localize></a>
                                        <% }else { %>
                                        <a class="btn btn-sm btnsmallex navtoolbtn" href="javascript:;"  style="display: none;"  onclick="SetView('EditUserInfo.aspx?mode=1&userid=<%= TargetAdminId.Value %>&vdid=<%= SessionDomainId %>',&quot;<%= str_ainfo.Text %>&quot;);return false;"><asp:Localize meta:resourcekey="str_ainfo" id="str_ainfo" runat="server">Administrator Info</asp:Localize></a>
                                        <% } %>
                                        
                                        <% } %>
                                        <%if(m_ShowBranding ||SessionIsClusterAdmin || SessionIsDelegateClusterAdmin) { %>
                                        <a class="btn btn-sm btnsmallex navtoolbtn" href="javascript:;" onclick="SetView('BrandingMgrPage.aspx?mode=edit&brid=<%=SessionDomainId %>',&quot;<%=str_branding.Text %>&quot;);return false;"><asp:Localize meta:resourcekey="str_branding" id="str_branding" runat="server">Tenant Branding</asp:Localize></a>
                                        <% } %>
                                        <a class="btn btn-sm btnsmallex navtoolbtn" href="javascript:;" onclick="SetView('/portal/SearchDevicesPage.aspx?vdid=<%=SessionDomainId %>',&quot;<%=str_devm.Text %>&quot;);return false;" style="display: none;"><asp:Localize meta:resourcekey="str_devm" ID="str_devm" runat="server">Device Manager</asp:Localize></a>        
                                        <%if(m_ShowGroupPolicy||SessionIsClusterAdmin || SessionIsDelegateClusterAdmin) { %>
                                        <a class="btn btn-sm btnsmallex navtoolbtn" href="javascript:;" onclick="SetView('/management/GroupPolicyMgrPage.aspx?vdid=<%=SessionDomainId %>',&quot;<%=str_gp.Text %>&quot;);return false;"><asp:Localize meta:resourcekey="str_gp" id="str_gp" runat="server">Group Policy</asp:Localize></a>               
                                        <% } %>
                                        <%if(SessionIsClusterAdmin || SessionIsDelegateClusterAdmin) { %>
                                        <a class="btn btn-sm btnsmallex navtoolbtn" href="javascript:;" onclick="SetView('/management/AccessPolicy/AccessPolicyMgrPage.aspx?vdid=<%=SessionDomainId %>',&quot;<%=str_accessp.Text %>&quot;);return false;"><asp:Localize meta:resourcekey="str_accessp" id="str_accessp" runat="server">Access Policy</asp:Localize></a>               
                                        <% } %>
                                        <a class="btn btn-sm btnsmallex navtoolbtn" href="javascript:;" style="display: none;" onclick="SetView('/management/TenantNotification.aspx?vdid=<%=SessionDomainId %>',&quot;<%=str_notm.Text %>&quot;);return false;"><asp:Localize meta:resourcekey="str_notm" ID="str_notm" runat="server">Notification Manager</asp:Localize></a>
                                        <a class="btn btn-sm btnsmallex navtoolbtn" href="javascript:;"  onclick="SetView('/management/TenantControlPanel.aspx?vdid=<%=SessionDomainId %>',&quot;<%=str_cpl.Text %>&quot;);return false;"><asp:Localize meta:resourcekey="str_cpl" ID="str_cpl" runat="server">Control Panel</asp:Localize></a>
                                        
                                        <a class="btn btn-sm btnsmallex navtoolbtn" href="javascript:;"  onclick="OnUserMgr();return false;"><asp:Localize meta:resourcekey="str_users" id="str_users" runat="server">Users</asp:Localize></a>
                                        <%if(m_ShowGuestUserManager) { %>
                                        <a class="btn btn-sm btnsmallex navtoolbtn" href="javascript:;"  onclick="SetView('/management/GuestUserMgrPage.aspx?vdid=<%=SessionDomainId %>',&quot;<%=str_guestusers.Text %>&quot;);return false;"><asp:Localize meta:resourcekey="str_guestusers" id="str_guestusers" runat="server">Guest Users</asp:Localize></a>
                                        <% } %>
                                        <a class="btn btn-sm btnsmallex navtoolbtn" href="javascript:;"  onclick="SetView('/portal/GroupMgrPage.aspx?vdid=<%=SessionDomainId %>',&quot;<%=str_grps.Text %>&quot;);return false;"><asp:Localize meta:resourcekey="str_grps" id="str_grps" runat="server">Groups</asp:Localize></a>
                                        <a class="btn btn-sm btnsmallex navtoolbtn" href="javascript:;"  onclick="SetView('/management/RoleMgrPage.aspx?vdid=<%=SessionDomainId %>',&quot;<%=str_roles.Text %>&quot;);return false;"><asp:Localize meta:resourcekey="str_roles" id="str_roles" runat="server">Roles</asp:Localize></a>
                                        <a class="btn btn-sm btnsmallex navtoolbtn" href="javascript:;"  onclick="OnCollab();return false;"><asp:Localize meta:resourcekey="str_teamfolders" ID="str_teamfolders" runat="server">Team Folders</asp:Localize></a>
                                    
                                    </td>
                                </tr>
                                <%if(m_AllowBackup && !IsHostedFarm && !EditingTenant) { %>
                                <tr valign="top" style="height:1%;">
                                    <td colspan="3" style="color: #565656; border-top: 1px solid #e8e8e8; font-weight: 100; font-size: 14px; padding: 15px;" align="left">

                                        <table width="100%">
                                            
                                            <tr>
                                                <td width="55px" valign="middle" rowspan="2" >
                                                    <span title="<asp:Localize meta:resourcekey="str_backuptitle"  id="str_backuptitle" runat="server" >Backup and Restore</asp:Localize>" style="font-size:45px;line-height:45px;" class="gladinet-icons md-dark hand center">&#x10C;</span>
                                                </td>
                                                <td style="color: #565656; font-weight: 100; font-size: 18px; border-bottom: 1px solid #f0f0f0;">
                                                    <span class="toolnavbtn" style="color: #202020; cursor:pointer;" onclick="parent.OnTenantBackupMgr();return false;"><asp:Localize meta:resourcekey="str_backuptitle" runat="server">Cloud Backup</asp:Localize></span>
                                                </td>
                                                <td width="64px" style="color: #565656; font-weight: 100; font-size: 18px; border-bottom: 1px solid #f0f0f0;" align="right">
                                                    <span class="fa fa-wrench toolbtnb iconviewitemcolor" onclick="parent.OnTenantBackupMgr();return false;" style="cursor: pointer;"></span>
                                                </td>
                                            </tr>
                                            <tr id="hint001">
                                                <td style="color: #565656; font-weight: 100; font-size: 12px; padding-top: 10px;" colspan="3">
                                                    <asp:Panel ID="Panel2" runat="server">
                                                        <div style="font-size: 10px; font-weight: 100; color: #404040; padding-top: 0px; padding-bottom: 20px;">
                                                            <asp:Localize meta:resourcekey="str_locBackupMsg" ID="Localize10" runat="server">Cloud backup allows you to backup your team folder and device to cloud, </asp:Localize>
                                                            
                                                        </div>
                                                    </asp:Panel>
                                                    
                                                </td>
                                            </tr>

                                        </table>

                                    </td>
                                </tr>
                                <% } %>
                                <% if (m_ShowLDAP && !IsHostedFarm){ %>
                                <tr valign="top" style="height:1%;">
                                    <td colspan="3" style="color: #565656; border-top: 1px solid #e8e8e8; font-weight: 100; font-size: 14px; padding: 15px;" align="left">

                                        <table width="100%">
                                            <tr>
                                                <td width="55px" valign="middle" rowspan="2" >
													<i class="gladinet-icons md-45 md-dark hand center">A</i>
                                                </td>
                                                <td style="color: #565656; font-weight: 100; font-size: 18px; border-bottom: 1px solid #f0f0f0;">
                                                    <span class="toolnavbtn" style="color: #202020; cursor:pointer;" onclick="SetView('/management/LDAPCfgPage.aspx?c=1&g=<%= ViewSessionDomainId %>','<%=str_adStg.Text %>');return false;"><asp:Localize meta:resourcekey="str_adtitle" runat="server">Active Directory</asp:Localize></span>
                                                </td>
                                                <td width="64px" style="color: #565656; font-weight: 100; font-size: 18px; border-bottom: 1px solid #f0f0f0;" align="right">
                                                    <span class="fa fa-wrench toolbtnb iconviewitemcolor" onclick="SetView('/management/LDAPCfgPage.aspx?c=1&g=<%= ViewSessionDomainId %>',&quot;<asp:Localize meta:resourcekey="str_adStg" id="str_adStg" runat="server">AD Settings</asp:Localize>&quot;);return false;" style="cursor: pointer;" title="<asp:Localize meta:resourcekey="str_cnfNow" runat="server">Configure Now.</asp:Localize>"></span>
                                                </td>
                                            </tr>
                                            <tr id="hint1">
                                                <td style="color: #565656; font-weight: 100; font-size: 12px; padding-top: 10px;" colspan="3">
                                                    <asp:Panel ID="NoAdPanel" runat="server">
                                                        <div style="font-size: 10px; font-weight: 100; color: #404040; padding-top: 0px; padding-bottom: 20px;">
                                                            <asp:Localize meta:resourcekey="str_locADSvcMsg" ID="str_locADSvcMsg" runat="server">Local Active Directory Service is not configured. If you have Active Directory local to the CentreStack server, </asp:Localize>
                                                            <a href="javascript:;" onclick="SetView('/management/LDAPCfgPage.aspx?c=1&g=<%= ViewSessionDomainId %>',&quot;<asp:Localize meta:resourcekey="str_adStg" runat="server">AD Settings</asp:Localize>&quot;);return false;"><asp:Localize meta:resourcekey="str_cnfNow" runat="server">Configure Now.</asp:Localize></a>
                                                        </div>
                                                    </asp:Panel>
                                                    <% if (!NoAdPanel.Visible)
                                                    { %>
                                                    
                                                        <asp:Label ID="LDAPSvr" runat="server" Text=""></asp:Label> /
                                                            <asp:Label ID="FDomainName" runat="server"></asp:Label> /
                                                                <asp:Label ID="LDAPUser" runat="server"></asp:Label>

                                                    <% } %>
                                                </td>
                                            </tr>

                                        </table>

                                    </td>
                                </tr>
                                <% } %>
                                <% if (m_ShowLDAP ){ %>
                                <tr valign="top" style="height:1%;">
                                    <td colspan="3" style="color: #565656; border-top: 1px solid #e8e8e8; font-weight: 100; font-size: 14px; padding: 15px;" align="left">

                                        <table width="100%">
                                            <tr>
                                                <td width="55px" valign="middle" rowspan="2" >
													<i class="gladinet-icons md-45 md-dark hand center">(</i>
                                                </td>
                                                <td style="color: #565656; font-weight: 100; font-size: 18px; border-bottom: 1px solid #f0f0f0;">
                                                    <span class="toolnavbtn" style="color: #202020; cursor:pointer;" data-toggle="modal" data-target="#DownloadModal"  title="<%=str_addsa.Text %>" ><asp:Localize meta:resourcekey="str_rads" runat="server">Remote Active Directory</asp:Localize></span>
                                                </td>
                                                <td width="64px" style="color: #565656; font-weight: 100; font-size: 18px; border-bottom: 1px solid #f0f0f0;" align="right">
                                                    <button type="button" class="btn btn-info btn-lg toolbtn" data-toggle="modal" data-target="#DownloadModal" style="padding: 1px;" title="<%=str_addsa.Text %>"><span class="fa fa-plus toolbtn iconviewitemcolor"  style="cursor: pointer; "></span></button>
                                                    
                                                    <div id="DownloadModal" class="modal fade" role="dialog" >
  <div class="modal-dialog" style="max-width:850px!important; width: 850px!important;">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        
        <h4 class="modal-title" style="font-weight:400;"><asp:Localize meta:resourcekey="str_dnsa" runat="server">Download Server Agent</asp:Localize></h4>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <div class="modal-body" style="padding-top:0px;">
        <iframe src='/portal/downloadpage.aspx?serveronly=1&vdid=<%=SessionDomainId%>' style='width: 800px; max-width: 900px; height: 220px;margin:0;padding:0;border:0; overflow:hidden;'></iframe>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal"><asp:Localize ID="LocCls" meta:resourcekey="str_cls" runat="server">Close</asp:Localize></button>
      </div>
    </div>

  </div>
</div>
                                                </td>
                                            </tr>
                                            <tr id="hint2">
                                                <td style="color: #565656; font-weight: 100; font-size: 12px; padding-top: 10px;" colspan="3">
                                                    <asp:Panel ID="NoSAPanel" runat="server">
                                                        <div style="font-size: 10px; font-weight: 100; color: #565656; padding-top: 10px; padding-bottom: 10px;">
                                                            <asp:Localize meta:resourcekey="str_addsa" ID="str_addsa" runat="server">If the Active Directory environment is located remotely and not directly accessible from the CentreStack server, please install our Server Agent client on a domain joined machine. Click on the + icon to download and install the Server Agent client.</asp:Localize>
                                            
                                                            
                                                        </div>
                                                    </asp:Panel>
                                                    <% if (!NoSAPanel.Visible){ %>
                                                    
                                                         <table width="100%" >
                                                    
                                                    <asp:Repeater ID="UserSrcRepeater" runat="server">
                                                        <ItemTemplate>
                                                        <tr>
                                                            <td style="font-size: 10px; font-weight: 100; color: #565656; ">
                                                                <%#DataBinder.Eval(Container.DataItem,"Name") %>
                                                            </td>
                                                        </tr>            
                                                        </ItemTemplate>
                                                    </asp:Repeater>
                                                             </table>
                                                                  

                                                    <% } %>
                                                    
                                                </td>
                                            </tr>

                                        </table>

                                    </td>
                                </tr>
                                <% } %>
                                <%if (m_ShowStorageManager  && SessionIsInstalledApp && (SessionIsClusterAdmin || SessionIsDelegateClusterAdmin))
                                    { %>
                                <tr valign="top">
                                    <td colspan="3" style="color: #565656; border-top: 1px solid #e8e8e8; font-weight: 100; font-size: 14px; padding: 15px;" align="left">

                                        <table width="100%">
                                            <tr>
                                                <td width="64px" valign="middle" style="color: #565656; font-weight: 100; font-size: 18px;" rowspan="2">

                                                     <i class="gladinet-icons md-63  hand iconviewitemcolor" style="display: block; margin-top: 3px; font-size:48px!important" ><%=StorageIcon.Value%></i>
                                                </td>
                                                <td style="color: #565656; font-weight: 100; font-size: 18px; border-bottom: 1px solid #f0f0f0;">
                                                     <asp:Localize meta:resourcekey="str_bs" runat="server"  >Backend Storage</asp:Localize>
                                                    
                                                </td>
                                                <td width="64px" style="color: #565656; font-weight: 100; font-size: 12px; border-bottom: 1px solid #f0f0f0;" align="right">
                                                    <div class="dropdown" style="padding: 0px; height: 24px; margin-left:-60px;">

                                                            <span id="edtStgDDMLnk" class="fa fa-option-vertical dropdown-toggle toolbtn iconviewitemcolor" data-toggle="dropdown" style="font-size: 24px; cursor: pointer;" title="<asp:Localize meta:resourcekey="str_editdefs" runat="server">Edit</asp:Localize>"></span>


                                                            <div id="edtStgDDM" class="dropdown-menu" style="padding: 0px; margin-left: -140px; ">
                                                                <a href="javascript:;"  class="dropdown-item"  onclick="StorageDetail();return false;" style="font-weight: 100; color: #868686; font-size: 14px;">
                                                                    <asp:Localize meta:resourcekey="str_storagedetail" runat="server" ID="str_storagedetail">View Storage Detail</asp:Localize></a>
                                                                <% if (LocalDisk) { %>
                                                                <a href="javascript:;" class="dropdown-item"  onclick="EditLocalStorage();return false;" style="font-weight: 100; color: #868686; font-size: 14px;">
                                                                    <asp:Localize meta:resourcekey="str_editdefs" runat="server">Edit</asp:Localize></a>
                                                                <a href="javascript:;" class="dropdown-item"  onclick="EditCloudStorage();return false;" style="font-weight: 100; color: #868686; font-size: 14px; display: none;">
                                                                    <asp:Localize meta:resourcekey="str_replcloud" runat="server">Replace with Cloud Storage</asp:Localize></a>
                                                                <% }
                                                                    else
                                                                    { %>
                                                                <a href="javascript:;" class="dropdown-item" onclick="EditCloudStorage();return false;" style="font-weight: 100; color: #868686; font-size: 14px;">
                                                                    <asp:Localize meta:resourcekey="str_editdefs" runat="server">Edit</asp:Localize></a>
                                                                <a href="javascript:;" class="dropdown-item"  onclick="EditLocalStorage();return false;" style="font-weight: 100; color: #868686; font-size: 14px;display:none;">
                                                                    <asp:Localize meta:resourcekey="str_replfile" runat="server">Replace with File Share</asp:Localize></a>
                                                                <% } %>

                                                                <% if (AllowHostedClusterManager()) { %>
                                                                <a href="javascript:;" class="dropdown-item" onclick="SetView('/management/AddHomeStorageMigrateTask.aspx?vdid=<%=ViewSessionDomainId %>',&quot;<%=str_migrate.Text %>&quot;);return false;" style="font-weight: 100; color: #868686; font-size: 14px;">
                                                                    <asp:Localize meta:resourcekey="str_migrate" ID="str_migrate" runat="server">Migrate to new  storage</asp:Localize></a>
                                                                <% } %>
                                                                <%if(m_ShowDefaultStorageManager) { %>
                                                                <a href="javascript:;" class="dropdown-item" onclick="SetView('/management/StorageMgr.aspx?vdid=<%=ViewSessionDomainId %>',&quot;<%=sttext.Text %>&quot;);return false;" style="font-weight: 100; color: #868686; font-size: 14px;">
                                                                    <asp:Localize meta:resourcekey="str_storagemanager" ID="sttext" runat="server">Storage Manager</asp:Localize></a>
                                                                <% } %>
                                                            </div>
                                                        </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td style="color: #565656; font-weight: 100; font-size: 12px; padding-top: 10px;" colspan="3">
                                                    
                                                    
                                                    
                                                         <%= StorageProvider.Text %> (
                                                            <asp:Label ID="StorageSettings" runat="server" meta:resourcekey="PathLocResource1"></asp:Label>)<br />

                                                    

                                                    
                                                </td>
                                            </tr>

                                        </table>

                                    </td>
                                </tr>
                                <% } %>
                                <%if(HasTask){ %>
                                <tr valign="top">
                                    <td colspan="3" style="color: #565656; border-top: 1px solid #e8e8e8; font-weight: 100; font-size: 14px; padding: 15px;" align="left">

                                        <table width="100%">
                                            <tr>
                                                <td width="64px" valign="middle" style="color: #565656; font-weight: 100; font-size: 18px;" rowspan="2">

                                                     <i class="gladinet-icons md-63  hand iconviewitemcolor" style="display: block; margin-top: 3px; font-size:48px!important" >=</i>
                                                </td>
                                                <td style="color: #565656; font-weight: 100; font-size: 18px; border-bottom: 1px solid #f0f0f0;">
                                                    <span class="toolnavbtn" style="cursor:pointer;"  onclick="SetView('/management/TenantTasks.aspx?child=1&vdid=<%=SessionDomainId %>','<%=str_bgtasks.Text %>')"><asp:Localize meta:resourcekey="str_bgtasks" ID="str_bgtasks" runat="server">Background Tasks</asp:Localize></span>
                                                    
                                                </td>
                                                <td width="64px" style="color: #565656; font-weight: 100; font-size: 12px; border-bottom: 1px solid #f0f0f0;" align="right">
                                                    <asp:LinkButton ID="LinkButton1" runat="server" OnClick="RefreshTask_Click" OnClientClick="Wait('...');">
                                                    <i class="gladinet-icons md-24 md-dark hand center">&#xB5;</i></asp:LinkButton>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td style="color: #565656; font-weight: 100; font-size: 12px; padding-top: 10px;" colspan="3">
                                                    
                                                    <table width="100%">
                                                                       <asp:Repeater ID="TaskRepeater" runat="server" >
                                                                                    <ItemTemplate>
                                                                                        <tr>
                                                                                            <td width="24px">
                                                                                                <span class='fa <%# DataBinder.Eval(Container.DataItem, "SyncStatusIcon") %>  ' 
                                                     title='<%# DataBinder.Eval(Container.DataItem, "SyncStatusString") %>' 
                                                     style='color:<%# DataBinder.Eval(Container.DataItem, "SyncStatusColor") %>; font-size: 18px; cursor: pointer;'></span>
                                                                                            </td>
                                                                                            <td>
                                                                                                <table width="100%">
                                                                                                    <tr>
                                                                                                        <td style="font-size:10px; font-weight:100; color:#565656;">
                                                                                                            <%#DataBinder.Eval(Container.DataItem,"TaskDesc") %>
                                                                                                        </td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td>
                                                                                                             <div class="progress" style="<%#DataBinder.Eval(Container.DataItem,"SyncProgressBarDisplay")%>">
                                                                <div class="progress-bar  <%#DataBinder.Eval(Container.DataItem,"SyncProgressBarType") %>" role="progressbar" aria-valuenow="40"
                                                                    aria-valuemin="0" aria-valuemax="100" style="width:<%#DataBinder.Eval(Container.DataItem,"SyncProgressPercent") %>%">

                                                                  </div>
                                                                </div>
                                                                                                        </td>
                                                                                                    </tr>
                                                                                                </table>
                                                                                            </td>
                                                                                        </tr>
                                                                                        </ItemTemplate>
                                                                           </asp:Repeater>
                                                        </table>



                                                    
                                                </td>
                                            </tr>

                                        </table>

                                    </td>
                                </tr>
                                <% } %>
                            </table>
                        </div>
                       
                        
                        <div id="WarningModal" class="modal fade" role="dialog" >
  <div class="modal-dialog" style="width: 800px;">

    <!-- Modal content-->
    <div class="modal-content" style="width: 800px;">
     
      <div class="modal-body" >
          
                    
                        
                        <table width="100%">
                            <tr>
                                <td style="font-weight: 100; color: #565656; padding-bottom: 20px;">
                                    <asp:Localize meta:resourcekey="str_tntUsnDftStg" runat="server">The tenant is still using default storage located on C:\CentreStack.</asp:Localize>
                                    
                                </td>
                                </tr><tr>
                            <td align="right">
                                
                            </td>
                            
                            </tr>
                        </table>
                         
                    
                    
          </div>
      <div class="modal-footer">
           <% if (m_ShowStorageManager && !IsHostedFarm && SessionIsInstalledApp)
              { %>
       <a href="javascript:;" onclick='EditLocalStorage();return false;'><asp:Localize meta:resourcekey="str_rpcWthFilShr" runat="server">Replace with File Share</asp:Localize></a> &nbsp; <a href="javascript:;" onclick="EditCloudStorage();return false;"><asp:Localize meta:resourcekey="str_rpcWthCldStr" runat="server">Replace with Cloud Storage</asp:Localize></a> <% } %>       <button type="button" class="btn btn-default" data-dismiss="modal"><%=LocCls.Text %></button>
      </div>
    </div>

  </div>
</div>
                        
                        <% if (!IsMobile()){ %>
                        </td>
                            
                             
                        
                </tr>
            </table>
        <% } %>
            <div class="row" style="width: 100%; align-content: center; margin: 0; opacity: 0.88;display: none;" align="center">
                
                
                <div class="col-xs-3 col-sm-3 col-md-3 col-lg-3" >
                    <div class=" panel panel-success topbuffer" style="width: 100%; ">
                        
                        <div style="padding:10px; padding-bottom:30px;">
                            <table width="100%" class="table-striped" style="font-size: 12px; display:none;">
                                <% if (m_ShowLDAP)
                                    { %>
                                <tr>
                                    <td width="48px" align="center" style="padding: 5px; cursor: pointer;" onclick="ConfigAD();return false;">
                                        <span style="color: #808080;" class="fa fa-book" aria-hidden="true"></span>
                                    </td>
                                    <td onclick="ConfigAD();return false;" style="padding: 5px; cursor: pointer; font-size: 12px;">
                                        <asp:Localize ID="Localize7" meta:resourcekey="str_configad" runat="server">Configure Active Directory</asp:Localize>
                                    </td>
                                </tr>
                                <% } %>
                               
                                <tr>
                                    <td width="48px" align="center" style="padding: 5px; cursor: pointer;" onclick="ImportShare();return false;">
                                        <span style="color: #808080;" class="fa fa-folder-open" aria-hidden="true"></span>
                                    </td>
                                    <td onclick="ImportShare();return false;" style="padding: 5px; cursor: pointer;
                                        font-size: 12px;" title="<%=str_iHint.Text %>">
                                        <asp:Localize meta:resourcekey="str_ihint" ID="str_iHint" Visible="False" runat="server">convert or migrate existing file share to a team folder</asp:Localize>
                                        <asp:Localize meta:resourcekey="str_importshare" runat="server">Import Network Share</asp:Localize>
                                    </td>
                                </tr>
                                <tr style="display: none;">
                                    <td width="48px" align="center" style="padding: 5px; cursor: pointer;" onclick="ImportShareAgent();return false;">
                                        <span style="color: #808080;" class="fa fa-folder-open" aria-hidden="true"></span>
                                    </td>
                                    <td onclick="ImportShareAgent();return false;" style="padding: 5px; cursor: pointer;
                                        font-size: 12px;">
                                        <asp:Localize meta:resourcekey="str_importshareagent" runat="server"> Import Network Share that Can't be Accessed Directly</asp:Localize>
                                    </td>
                                </tr>
                               <tr>
                                    <td width="48px" align="center" style="padding: 5px; cursor: pointer;" onclick="OnAddUserWizard();return false;">
                                        <span style="color: #808080;" class="fa fa-user" aria-hidden="true"></span>
                                    </td>
                                    <td onclick="OnAddUserWizard();return false;" style="padding: 5px; cursor: pointer;
                                        font-size: 12px;">
                                        <asp:Localize ID="Localize9" meta:resourcekey="asp_string27" runat="server">Add Users</asp:Localize>
                                    </td>
                                </tr>
                                <tr style="display: none;">
                                    <td width="48px" align="center" style="padding: 5px; cursor: pointer;" onclick="AddPubFolder();return false;">
                                        <span style="color: #808080;" class="fa fa-folder-open" aria-hidden="true"></span>
                                    </td>
                                    <td onclick="AddPubFolder();return false;" style="padding: 5px; cursor: pointer;
                                        font-size: 12px;">
                                        <asp:Localize  meta:resourcekey="str_cteamfolder" id="str_cteamfolder" runat="server">Create a Team Folder</asp:Localize>
                                    </td>
                                </tr>
                                
                                 <% if (SessionIsInstalledApp && !IsHosted)
                                     { %>
                                <tr style="display: none;">
                                    <td width="48px" align="center" style="padding: 5px; cursor: pointer;" onclick="AddLocalStorage();return false;">
                                        <span style="color: #808080;" class="fa fa-hdd" aria-hidden="true"></span>
                                    </td>
                                    <td onclick="AddLocalStorage();return false;" style="padding: 5px; cursor: pointer;
                                        font-size: 12px;">
                                        <asp:Localize ID="Localize4" meta:resourcekey="str_alocal" runat="server">Attach Local Storage</asp:Localize>
                                    </td>
                                </tr>
                                <% } %>
                                 <% if (MountCloudStorage)
                                     { %>
                                <tr style="display: none;">
                                    <td width="48px" align="center" style="padding: 5px; cursor: pointer;" onclick="AddCloudStorage();return false;">
                                        <span style="color: #808080;" class="fa fa-cloud-upload" aria-hidden="true"></span>
                                    </td>
                                    <td onclick="AddCloudStorage();return false;" style="padding: 5px; cursor: pointer;
                                        font-size: 12px;">
                                        <asp:Localize ID="Localize5" meta:resourcekey="str_acloud" runat="server">Attach Cloud Storage</asp:Localize>
                                    </td>
                                </tr>
                                <% } %>
                            </table>
                           
                        </div>
                    </div>
                </div>
               
            </div>
        </div>
        <asp:Panel ID="LeftPanel" runat="server">
            </asp:Panel>
    </asp:Panel>
    <asp:Panel ID="HelpPanel" runat="server" meta:resourcekey="HelpPanelResource1">
          <asp:Localize runat="server" meta:resourcekey="str_dshIsNotAvb">Dashboard is not available</asp:Localize>
        </asp:Panel>
   
    <asp:HiddenField ID="TargetAdminId" runat="server" />
    <asp:HiddenField ID="TargetEmail" runat="server" />
    <asp:HiddenField ID="TargetUserId" runat="server" />
    <asp:HiddenField ID="StorageIcon" runat="server" />
    
    <asp:HiddenField ID="PageDomainId" runat="server" />
    <asp:HiddenField ID="UseDefaultStorage" runat="server" />
    <div style="display: none;">
        <asp:Button ID="SubspendTenant" runat="server" Text="Button" OnClick="SubspendTenant_Click" />
        <asp:Button ID="ResumeTenant" runat="server" Text="Button" OnClick="ResumeTenant_Click" />
        <asp:Button ID="DeleteUserBtn" runat="server" Text="Button" OnClick="DeleteUser_Click" />
        <asp:Button ID="DeleteShareBtn" runat="server" Text="Button" OnClick="DeleteShareBtn_Click" />
        <asp:Localize meta:resourcekey="asp_string13" runat="server" id="str_um">User Manager</asp:Localize>
        
    </div>
    <script type="text/javascript">
        function adjust()
        {
            var e = document.getElementById("rightmenu");
            var e1 = document.getElementById("topmenu");
            var e2  = document.getElementById("userhead");
            var e3 =document.getElementById("teamhead");
                
            
            if(document.documentElement.clientWidth > 800){
                e.style.display = "";
                e2.style.display = "";
                e3.style.display = "";
                e1.style.display = "none";
            }else{
                e.style.display = "none";
                e2.style.display = "none";
                e3.style.display = "none";
                e1.style.display = "";
            }
        }
        
        function adjustright(){
            var e = document.getElementById("rightmenu");
            //e.style.height = (document.documentElement.offsetHeight-10) +"px";
        }
        Ext.onReady(function () {
            var o = document.getElementById("origcontrol");
            var o1 = document.getElementById("hint00");
            o1.innerHTML = o.innerHTML;
            adjust();
            Ext.EventManager.onWindowResize(function () {
                adjustright();
            });
   
        });
    </script>
    <script>
        
        try {
            parent.SetSubTitle('');
        } catch (e) {
            
        }
        try {
            var s = "" + parent.location;
            s = s.toLowerCase();
           
            if(s.indexOf("webapppage.aspx") == -1)
                parent.closeCancelActiveWin();
           
        } catch (e) {
            
        }
        //after a wizard is complete, such as tenant creation, this page will reload.
        //if we don't reset the breadcrum, then the wizard will be complete, but the breadcrum will still say dashboard > create new tenant
        setTimeout(function(){
            try {
                if(parent.SetSecondPageTitleNoLoading) parent.SetSecondPageTitleNoLoading("<%=OrgName.Text%>","/management/EditTenantDashboard.aspx?vdid=<%=SessionDomainId %>");
            } catch (e) {}
        },200);

</script>
</asp:Content>



