﻿<%@ Page Title="Gladinet Cloud - Role" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="EditRole.aspx.cs" Inherits="GladinetPayFlow.EditRole"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        td {
            font-size: 15px;
            font-weight: 100;
        }

        b {
            font-weight: 500;
        }

        .badgefont {
            font-size: 15px;
        }


        li {
            padding-right: 5px;
            font-size: 12px;
            font-weight: 100 !important;
        }
    </style>
    <style type="text/css">
        .titlecol {
            background-color: #f0f0f0;
            font-size: 14px;
        }

        html, body {
            height: 100%;
        }

        .main, #aspnetForm {
            height: 100%;
        }

        .wrapper {
            min-height: 100%;
            height: auto !important;
            height: 100%;
            padding: 0px;
            background-color: inherit;
            margin: 0 auto -69px; /* the bottom margin is the negative value of the footer's height */
        }

        .x-grid-cell {
            font-size: 12px;
            font-family: tahoma,arial,verdana,sans-serif;
            font-weight: 100;
        }

        label {
            font-weight: 100 !important;
            color: #565656 !important;
        }

        .mylabel {
            font-weight: 100 !important;
            color: #565656 !important;
        }

        li {
            padding-right: 10px;
            font: 14px !important;
        }
    </style>
    <script type="text/javascript">
        var UserCount = 0;
        <%if (m_AclList != null)
        { %>
        UserCount = <%=m_AclList.Count%>;
        <%} %>
        
        function removeNodeSafely(node) {
            try {
                node.innerHTML = ''; // in IE 8, it doesn't work for TR and TABLE
                
            } catch (e1) {
                try {
                    node.parentNode.removeChild(node);
                } catch (e2) {
                    
                }
            }
        }
                
        function DeleteACL(idd){
            var PermTable = document.getElementById("PermTable");
            var ch = document.getElementById(idd);
            ch.id = idd+"xxxx";
            removeNodeSafely(ch); //ch.innerHTML = "";
            --UserCount;
            AdjustPanel();
        }
        function AdjustPanel(){
            console.log("AdjustPanel: not implemented");
        }
        
        function OnGroupSelected(GroupList) {
 
            var groupsArr = GroupList.split("\n");
            var PermTable = document.getElementById("PermTable");
            if(GroupList.length <= 2)
                return;
            for(i=0; i<groupsArr.length; ++i){
                var para = groupsArr[i].split(';');
                var etr = document.createElement("tr");
                var etd;
                var echeck;
                var eid = document.getElementById(para[2]);
                
                if (eid)
                    continue;
                    

                etr.id = para[1];
                etd = document.createElement("td");                
                etr.appendChild(etd);
                etd.innerHTML = para[0];

                etd = document.createElement("td");
                etr.appendChild(etd);
                etd.innerHTML = "[PROXIED GROUP]";

                etd = document.createElement("td");
                etd.id = para[1];
                etr.appendChild(etd);
                var str = "<a href='#' onclick='DeleteACL(\"" + para[2] + "\");return false;' style='padding:5px'>";;
                str += '<span class="fa fa-remove" style="color: #565656;"></span></a>';;
                etd.innerHTML = str;
                etd.style.paddingRight = "4px";
                
                etd = document.createElement("td");
                etd.style.display = 'none';
                etr.appendChild(etd);
                str = "<input type=checkbox checked='checked' name='aa_" + para[2] + "' value='" + groupsArr[i] +"' />";
                etd.innerHTML = str;
                    
                PermTable.appendChild(etr);
                    
                ++UserCount;
            }
            AdjustPanel();
        }

        function OnUserSelected(UserList) {
            var users = UserList.split("\n");
            var PermTable = document.getElementById("PermTable");

            if(UserList.length <= 2)
                return;
            for(i=0; i<users.length; ++i){
                var para = users[i].split(',');
                var etr = document.createElement("tr");
                var etd;
                var echeck;
                var eid = document.getElementById(para[0]);
                
                if (eid)
                    continue;
                    

                etr.id = para[0];
                etd = document.createElement("td");                
                etr.appendChild(etd);
                etd.innerHTML = para[2];

                etd = document.createElement("td");
                etr.appendChild(etd);
                etd.innerHTML = para[1];

                etd = document.createElement("td");
                etd.id = para[0];
                etr.appendChild(etd);
                var str = "<a href='#' onclick='DeleteACL(\"" + para[0] + "\");return false;' style='padding:5px'>";;
                str += '<span class="fa fa-remove" style="color: #565656;"></span></a>';;
                etd.innerHTML = str;
                etd.style.paddingRight = "4px";
                
                etd = document.createElement("td");
                etd.style.display = 'none';
                etr.appendChild(etd);
                //echeck = document.createElement("input");
                //echeck.type = "checkbox";
                //echeck.checked = true
                //echeck.name = "uu_" + para[0]+"," + para[1]+","+para[2];
                //etd.appendChild(echeck);
                    
                    
                str = "<input type=checkbox checked='checked' name='aa_" + para[0] + "' value='" + para[0]+"' />";
                etd.innerHTML = str;
                    
                    
                    
                PermTable.appendChild(etr);
                    
                ++UserCount;
            }
            AdjustPanel();
        }
        
        function Toggle(name) {
            var d = document.getElementById(name);
            if (d.style.display == 'none')
                d.style.display = 'block';
            else
                d.style.display = 'none';
        }

        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 8000);

        function OnSelFolder() {
            var d = document.getElementById("SelFolderControl");

            d.style.display = 'block';
            d.style.left = (document.body.offsetWidth - 550) / 2  + "px";
            d.style.top = "0px";
        }

        var folder = "";
        function setcurfoldersel(f) {
            folder = f;
        }

        function setfoldercursel() {
            cancelfoldercursel();
            var d = document.getElementById("MainContent_Location");
            d.value = "/" + folder;
            // now look for share name, remove all slash, keep the last part, if last part is empty, change it to PublishFolder

            var indexSlash = folder.lastIndexOf("/");
            var ShareName = folder;
            if (indexSlash >= 0) {
                if ((indexSlash + 1) < folder.length) {
                    ShareName = folder.substring(indexSlash + 1);
                } else {
                    ShareName = "<asp:Localize meta:resourcekey="str_pbsFld" runat="server">Publish Folder</asp:Localize>";
                }
            }
            var e = document.getElementById("MainContent_ShareName");
            e.value =  ShareName;
        }
        function cancelfoldercursel() {
            var d = document.getElementById("SelFolderControl");

            d.style.display = 'none';

        }

        var activewin;
        function closeCancelActiveWin()
        {
            activewin.close();
        }

        function closeActiveWin() {
            window.location = window.location;
        }

        function OnCancelPub() {
            parent.closeActiveWin();
        }

        function OnAddUser() {

            activewin = new Ext.Window({
                id: 'pubs_win',
                title: "<asp:Localize meta:resourcekey="js_create_user" runat="server">Create New User</asp:Localize>",
                width: 560,
                height: 520,
                plain: true,
                modal: true,
                maximizable: true,
                constrain: true,
                maximized: false,
                layout: 'fit',
                bodyPadding: 3,
                html: "<iframe id='openwin' src='SelectUser.aspx' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>",
                defaults: {
                    border: false
                }
            });
            activewin.show();



        }

        function SelectUser() {
            
            
            if (parent.OnSelectUserTypeWithDomain) {
                parent.CurrentActiveIFrame = "main_body";
                parent.OnSelectUserTypeWithDomain('<%=SessionDomainId %>');
                
            } else {
                parent.parent.CurrentActiveIFrame = "main_body";
                parent.parent.OnSelectUserTypeWithDomain('<%=SessionDomainId %>');
            }

        }

        function SelectLDAPUser() {
            

            if (parent.parent.OnLDAPSelectUserWithDomain) {
                parent.parent.CurrentActiveIFrame = "main_body";
                parent.parent.OnLDAPSelectUserWithDomain('<%=SessionDomainId %>');
            } else {
                parent.CurrentActiveIFrame = "main_body";
                parent.OnLDAPSelectUserWithDomain('<%=SessionDomainId %>');
            }

        }
            


        
       function SetPage(p) {
           var e = document.getElementById("page_1");
           if(e)
            e.className = "gladtab_lg_inactive";

        e = document.getElementById("page_2");
        e.className = "gladtab_lg_inactive";

        e = document.getElementById("page_3");
        e.className = "gladtab_lg_inactive";

        e = document.getElementById("page_4");
        e.className = "gladtab_lg_inactive";

        e = document.getElementById("page_" + p);
        e.className = "gladtab_lg_active";
        

        e = document.getElementById("page_1_p");
        e.style.display = "none";
        e = document.getElementById("page_2_p");
        e.style.display = "none";
        e = document.getElementById("page_3_p");
        e.style.display = "none";
        e = document.getElementById("page_4_p");
        e.style.display = "none";

        e = document.getElementById("adduserbtn");
           if (p == 4)
               e.style.display = "";
        else
               e.style.display = "none";
        
        e = document.getElementById("page_" + p+"_p");
           e.style.display = "";

    }

     function AdjustSize() {

        var f = document.getElementById('content_div');
        f.style.height = (document.documentElement.clientHeight - 80) + "px";

    }




        Ext.onReady(function () {  
            try {  
                //sets the default permissions to checked when creating the role
                var isNewRole = (document.location.href.indexOf("&RoleId=") == -1);
                if (isNewRole) {   
                    var chks = document.getElementsByClassName("prmChkBx");
                    if (chks) {
                        for (var i = 0; i <= chks.length - 1; i++) {
                            chks[i].checked = true;
                        }
                    }
                }
            } catch (ex) {}
        AdjustSize();
    });

    Ext.EventManager.onWindowResize(function () {
        AdjustSize();
    });

    function validationSemiColonList(source, arguments) {
        if (arguments.Value != "") {
            if(arguments.Value.indexOf(",")>-1){
                arguments.IsValid = false;
                return false;
            }
            var patt = /^[^@,)]+@[^@]+\.[^@,]+$/;
            if(arguments.Value.indexOf(";")>-1){
                var arr = arguments.Value.split(";");
                for(var i=0;i<arr.length;i++){
                    if(patt.test(arr[i].toLowerCase())==false){
                        arguments.IsValid = false;
                        return false;
                    }
                }
            }else{
                if(patt.test(arguments.Value)==false){
                    arguments.IsValid = false;
                    return false;
                }
            }
        }
        arguments.IsValid = true;
        return true;
    }
    function sanitize(ref) {
        var val = ref.value.replace(/[^a-zA-Z0-9_\-\*;\.@]/g, '');
        val = val.replace(/@+/g, '@');
        ref.value = val.toLowerCase();
    }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Localize runat="server" ID="LocFaiToAppTheSet" meta:resourcekey="str_faiToAppTheSet" Visible="false">Failed to apply the settings</asp:Localize>
    <asp:Localize runat="server" ID="LocRolNamCanNotBeEmp" meta:resourcekey="str_rolNamCanNotBeEmp" Visible="false">Role name can not be empty</asp:Localize>
    <asp:Localize runat="server" ID="LocBadRolId" meta:resourcekey="str_badRolId" Visible="false">Bad role id</asp:Localize>
    <asp:Localize runat="server" ID="LocEvn" meta:resourcekey="str_evn" Visible="false">Everyone</asp:Localize>
    <asp:Localize runat="server" ID="LocAllADUsr" meta:resourcekey="str_allADUsr" Visible="false">All AD Users</asp:Localize>
    <asp:Localize runat="server" ID="LocUkn" meta:resourcekey="str_ukn" Visible="false">Unknown</asp:Localize>
    <asp:Localize runat="server" ID="LocNa" meta:resourcekey="str_na" Visible="false">N/A</asp:Localize>
    <asp:Localize runat="server" ID="LocUknUsr" meta:resourcekey="str_uknUsr" Visible="false">Unknown User</asp:Localize>
    <asp:Localize runat="server" ID="LocRleNmeCntBeEmt" meta:resourcekey="str_rleNmeCntBeEmt" Visible="false">Role name cannot be empty</asp:Localize>
    <asp:Localize runat="server" ID="LocPrxGrp" meta:resourcekey="str_prxGrp" Visible="false">[Proxied Group]</asp:Localize>
    
    <asp:Localize runat="server" ID="LocPubSha" meta:resourcekey="str_pubSha" Visible="false">Published Shares</asp:Localize>
    <asp:Localize runat="server" ID="LocUsr" meta:resourcekey="str_usr" Visible="false">Users</asp:Localize>
    <asp:Localize runat="server" ID="LocRep" meta:resourcekey="str_rep" Visible="false">Reports</asp:Localize>

    <div class=" " style="font-size: 10px; overflow: auto;" id="content_div">

        <div id="allgroup">
            <table width="100%" border="0">
                <tr style="border-bottom: 1px solid #cccccc;">
                    <td style="padding-left: 10px; border-bottom: 0px solid  #f0f0f0; font-weight: 100; color: #202020;" valign="middle">

                        <table>
                            <tr>
                                <td>
                                    <asp:Localize meta:resourcekey="group_name_str" runat="server"
                                        Text="Role Name:"></asp:Localize>
                                </td>
                                <td style="padding-right: 10px; border-bottom: 0px solid  #f0f0f0;" valign="middle">
                                    <asp:TextBox ID="RoleName" MaxLength="96" runat="server"
                                        CssClass="form-control" meta:resourcekey="GroupNameResource1"></asp:TextBox>
                                </td>

                            </tr>
                        </table>


                    </td>
                    <td style="padding-right: 10px; border-bottom: 0px solid  #f0f0f0;">

                        <asp:HiddenField ID="RoleId" runat="server" />
                        <%if (!string.IsNullOrEmpty(ErrorMsg.Text))
                            { %>
                        <asp:Label ID="ErrorMsg" runat="server" CssClass="errmsg" meta:resourcekey="ErrorMsgResource1"></asp:Label>
                        <% } %>
                    </td>
                    <td style="padding-right: 10px; border-bottom: 0px solid  #f0f0f0;">
                        <table width="100%" style="height: 48px; text-align: right; padding-right: 64px;"
                            align="right">
                            <tr>
                                <td align="left" style="border-top: 0px solid #d0d0d0; padding-top: 15px;"></td>
                                <td align="right" colspan="2" style="border-top: 0px solid #d0d0d0; padding-top: 15px;">
                                    <asp:Localize runat="server" ID="Localize6" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize>
                                    <asp:Localize runat="server" ID="Localize9" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize>
                                    <asp:Button ID="Button1" runat="server" Text="Apply" CssClass="btn btn-primary gladbtn"
                                        OnClick="PublishNow_Click" Width="128px"
                                        meta:resourcekey="PublishNowResource1" />&nbsp;&nbsp;&nbsp;&nbsp;
                    <asp:Button ID="Button2" runat="server" Text="Cancel" CssClass="btn btn-default"
                        Width="128px" CausesValidation="False"
                        meta:resourcekey="CancelPublishResource1" OnClick="CancelPublish_Click1" />
                                    <%
                                        Button1.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                                        Button2.OnClientClick = String.Format("Wait('{0}')", LocPlsWat.Text);
                                    %>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td align="left" style="padding: 0px; width: 100px;" valign="bottom" >
                        <table style="border-collapse: collapse;" cellpadding="0" cellspacing="0">
                            <tr>
                                <td style="width: 15px; border-bottom: 1px solid #f0f0f0;">&nbsp;</td>
                                <td style="padding-top: 10px;" valign="bottom">
                                    <div class="gladtab_lg_active" id="page_2" onclick="SetPage(2);return false;">
                                        <asp:Localize ID="Localize12" meta:resourcekey="str_sharing" runat="server" Text="Sharing"></asp:Localize>
                                    </div>
                                </td>

                                <td style="padding-top: 10px;" valign="bottom">
                                    <div class="gladtab_lg_inactive" id="page_3" onclick="SetPage(3);return false;">
                                        <asp:Localize ID="Localize13" meta:resourcekey="str_policy" runat="server" Text="Policies"></asp:Localize>
                                    </div>
                                </td>
                                <%if (IsServo || !IsCSBiz || m_ShowRolePermissions)
                                { %>
                                <td style="padding-top: 10px;" valign="bottom">
                                    <div class="gladtab_lg_inactive" id="page_1" onclick="SetPage(1);return false;">
                                        <asp:Localize meta:resourcekey="str_perms" runat="server" Text="Permissions"></asp:Localize>
                                    </div>
                                </td>
                                <%} %>
                                <td style="padding-top: 10px;" valign="bottom">
                                    <div class="gladtab_lg_inactive" id="page_4" onclick="SetPage(4);return false;">
                                        <asp:Localize meta:resourcekey="str_assigned" runat="server" Text="Assigned Users/Groups"></asp:Localize>
                                    </div>
                                </td>

                            </tr>
                        </table>

                    </td>

                    <td style="padding-left: 10px; border-bottom: 1px solid  #f0f0f0; font-weight: 100; color: #565656;" colspan="2"></td>
                    <td style="padding-right: 10px; border-bottom: 1px solid #f0f0f0; display: none;" align="right" id="adduserbtn">
                        <a href="javascript:;" onclick="SelectUser();return false;" style="font-size: 12px;">
                            <button type="button" class="btn btn-primary gladbtn" title="<%=Localize7.Text %>">
                                <span class="fa fa-plus" style="font-size: 16px;"></span>
                                <asp:Localize ID="Localize7" meta:resourcekey="string4" runat="server" Visible="false"
                                    Text="Add user(s) or group(s)"></asp:Localize>
                            </button>
                        </a>

                        <%if (m_AllowLDAPUser)
                            { %>

                        <a href="javascript:;" onclick="SelectLDAPUser();return false;" style="font-size: 12px; display: none;">
                            <button type="button" class="btn btn-default">
                                <span class="fa fa-plus" style="font-size: 20px; color: #565656;"></span>
                                <asp:Localize ID="Localize8" meta:resourcekey="string5" runat="server"
                                    Text="Add AD User"></asp:Localize>
                            </button>
                        </a>

                        <%} %>
                    </td>


                </tr>
                <tr>
                </tr>

            </table>


            <div id="page_1_p" style="border: 0px solid #c0c0c0; padding: 1px; padding: 10px; display: none;">
                <table width="100%" align="center">
                    <tr>
                        <td class="InputLabel" colspan="2" valign="top" id="pubusersc" style="padding-top: 5px">
                            <div id="pubusers" width="100%" style="background-color: white; overflow: auto; border: 0px solid #C0C0C0;">
                                <table width="100%" style="background-color: white;" class="table-striped">
                                    <tbody id="tbody">
                                        <tr style="background-color: white; border-bottom: 1px solid #f0f0f0; color: #404040; font-size: 16px; font-weight: 100;">
                                            <td width="200px">
                                                <asp:Localize meta:resourcekey="operation_str" runat="server" Text="Operation"></asp:Localize>
                                            </td>
                                            <td style="width: 40px;">
                                                <asp:Localize meta:resourcekey="View_Str" runat="server" Text="View"></asp:Localize>
                                            </td>
                                            <% if (!m_ShowRolePermissions) { %>
                                            <td style="width: 40px;">
                                                <asp:Localize meta:resourcekey="Add_Str" runat="server" Text="Add"></asp:Localize>
                                            </td>
                                            <td style="width: 40px;">
                                                <asp:Localize meta:resourcekey="Edit_Str" runat="server" Text="Edit"></asp:Localize>
                                            </td>
                                            <td style="width: 40px;">
                                                <asp:Localize meta:resourcekey="Delete_Str" runat="server" Text="Delete"></asp:Localize>
                                            </td>
                                            <% } %>
                                        </tr>
                                        <asp:Repeater ID="RightRepeater" runat="server">
                                            <ItemTemplate>
                                                <tr style="padding-top: 5px;" onmouseover="this.style.borderBottom='1px solid #008000';this.style.borderTop='1px solid #008000';" onmouseout="this.style.borderBottom='0px solid #008000';this.style.borderTop='0px solid #008000';">
                                                    <td width="200px">
                                                        <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "ObjectName").ToString())%>
                                                    </td>
                                                    <td>
                                                        <input type="checkbox"
                                                            name='uu_view_<%# DataBinder.Eval(Container.DataItem, "Id") %>'
                                                            <%# DataBinder.Eval(Container.DataItem, "ViewChecked") %>="">
                                                    </td>
                                                    <% if (!m_ShowRolePermissions) { %>
                                                    <td>
                                                        <input type="checkbox"
                                                            name='uu_add_<%# DataBinder.Eval(Container.DataItem, "Id") %>'
                                                            <%# DataBinder.Eval(Container.DataItem, "AddChecked") %>="">
                                                    </td>
                                                    <td>
                                                        <input type="checkbox"
                                                            name='uu_edit_<%# DataBinder.Eval(Container.DataItem, "Id") %>'
                                                            <%# DataBinder.Eval(Container.DataItem, "EditChecked") %>="">
                                                    </td>
                                                    <td>
                                                        <input type="checkbox"
                                                            name='uu_delete_<%# DataBinder.Eval(Container.DataItem, "Id") %>'
                                                            <%# DataBinder.Eval(Container.DataItem, "DeleteChecked") %>="">
                                                    </td>
                                                    <td style="display: none;"></td>
                                                    <% } %>
                                                </tr>
                                            </ItemTemplate>
                                        </asp:Repeater>
                                        
                                        <asp:Repeater ID="RightRepeaterTF" runat="server" OnItemDataBound="RightRepeaterTF_ItemDataBound">
                                            <ItemTemplate>
                                                <tr style="padding-top: 5px;" onmouseover="this.style.borderBottom='1px solid #008000';this.style.borderTop='1px solid #008000';" onmouseout="this.style.borderBottom='0px solid #008000';this.style.borderTop='0px solid #008000';">
                                                    <td width="200px">
                                                        <asp:Label ID="ObjectNameLabel" runat="server" Text='<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "ObjectName").ToString())%>'></asp:Label>
                                                    </td>
                                                    <td>
                                                        <asp:Panel ID="ViewCheckBoxPanel" runat="server">
                                                        <input type="checkbox" class="prmChkBx"
                                                            name='uu_view_<%# DataBinder.Eval(Container.DataItem, "Id") %>'
                                                            <%# DataBinder.Eval(Container.DataItem, "ViewChecked") %>=""></asp:Panel>
                                                    </td>
                                                    <td>
                                                        <asp:Panel ID="AddCheckBoxPanel" runat="server">
                                                        <input type="checkbox" class="prmChkBx"
                                                            name='uu_add_<%# DataBinder.Eval(Container.DataItem, "Id") %>'
                                                            <%# DataBinder.Eval(Container.DataItem, "AddChecked") %>=""></asp:Panel>
                                                        <asp:CheckBox ID="chkDummyAdd" runat="server" Enabled="false" Visible="false" />
                                                    </td>
                                                    <td>
                                                        <asp:Panel ID="EditCheckBoxPanel" runat="server">
                                                        <input type="checkbox" class="prmChkBx"
                                                            name='uu_edit_<%# DataBinder.Eval(Container.DataItem, "Id") %>'
                                                            <%# DataBinder.Eval(Container.DataItem, "EditChecked") %>=""></asp:Panel>  
                                                        <asp:CheckBox ID="chkDummyEdit" runat="server" Enabled="false" Visible="false" />
                                                    </td>
                                                    <td>
                                                        <asp:Panel ID="DeleteCheckBoxPanel" runat="server">
                                                        <input type="checkbox" class="prmChkBx"
                                                            name='uu_delete_<%# DataBinder.Eval(Container.DataItem, "Id") %>'
                                                            <%# DataBinder.Eval(Container.DataItem, "DeleteChecked") %>=""></asp:Panel>  
                                                        <asp:CheckBox ID="chkDummyDelete" runat="server" Enabled="false" Visible="false" />
                                                    </td>
                                                    <td style="display: none;"></td>
                                                </tr>
                                            </ItemTemplate>
                                        </asp:Repeater>
                                    </tbody>
                                </table>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2" style="padding-right: 1px;">
                            <div style="height: 11px">
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td height="20px"></td>
                    </tr>
                </table>
            </div>
            
            <div id="page_2_p" style="padding: 10px;">
                <table width="100%" align="center">
                    <tr>
                        <td style="font-weight: 100;">
                            <asp:CheckBox ID="DisableSharing" runat="server" CssClass="mylabel"
                                Text="Disable External Sharing" AutoPostBack="True"
                                OnCheckedChanged="DisableSharing_CheckedChanged"
                                meta:resourcekey="DisableSharingResource1" />
                            <br />
                            <asp:CheckBox ID="DisableFolderShare" runat="server"
                                Text="Disable folder sharing" meta:resourcekey="asp_dsbFldShr" /><br />

                            <asp:CheckBox ID="DisablePublicLink" runat="server"
                                Text="Disable Public Link" meta:resourcekey="asp_dsbPublicLink" /><br />

                            <asp:Panel ID="ShareOptionPanel" runat="server"
                                meta:resourcekey="ShareOptionPanelResource1">

                                <asp:CheckBox ID="OnlyShareWithADUser" runat="server"
                                    Text="Can only share with AD User"
                                    meta:resourcekey="OnlyShareWithADUserResource1" />

                                <p style="padding-top: 8px;">
                                    <label><asp:Label ID="Label1" runat="server"
                                        Text="Only allow sending share to specified user  or domain (i.e. user1@domain.com;*@domain1.com)" meta:resourcekey="Label1Resource2"></asp:Label></label><br />
                                    <asp:TextBox ID="ShareDomainWhiteList" runat="server" Width="90%" CssClass="form-control"
                                        meta:resourcekey="ShareDomainWhiteListResource1" onblur="sanitize(this)"></asp:TextBox>       
                                    <asp:CustomValidator ID="CustomValidator1" ControlToValidate="ShareDomainWhiteList" ValidateEmptyText="false" runat="server" ErrorMessage="Format must be: user1@domain.com;*@domain1.com" meta:resourcekey="customValidatorResource" ClientValidationFunction="validationSemiColonList" ForeColor="#D00000"></asp:CustomValidator>
                                    <br />
                                    <label><asp:Label ID="Label2" runat="server"
                                        Text="Do NOT allow sending share to specified user  or domain (i.e. user1@domain.com;*@domain1.com)"
                                        meta:resourcekey="Label1Resource1"></asp:Label></label><br />
                                    <asp:TextBox ID="ShareDomainBlackList" runat="server" Width="90%" CssClass="form-control"
                                        meta:resourcekey="ShareDomainWhiteListResource1" onblur="sanitize(this)"></asp:TextBox>
                                    <asp:CustomValidator ID="CustomValidator2" ControlToValidate="ShareDomainBlackList" ValidateEmptyText="false" runat="server" ErrorMessage="Format must be: user1@domain.com;*@domain1.com" meta:resourcekey="customValidatorResource" ClientValidationFunction="validationSemiColonList" ForeColor="#D00000"></asp:CustomValidator>

                                    <br />
                            </asp:Panel>
                        </td>
                    </tr>
                </table>
            </div>
            <div id="page_3_p" style="display: none; padding: 10px;">
                <table width="100%" align="center">
                    <tr>
                        <td>
                            <div id="Div1" width="100%" style="background-color: white; overflow: auto; border: 0px solid #C0C0C0;">
                                <asp:CheckBox ID="AllowGuestUser" Checked="True" runat="server"
                                    Text="Allow creating guest user" meta:resourcekey="AllowGuestUserResource1" /><br />

                                <asp:CheckBox ID="DisableHomeDirShare" runat="server"
                                    Text="Disable team-user share home directory content externally"
                                    meta:resourcekey="DisableHomeDirShareResource1" />
                                <br />
                                <asp:CheckBox ID="NoUserHomeDirectory" runat="server"
                                    Text="Disable user's home directory"
                                    meta:resourcekey="NoUserHomeDirectoryResource1" /><br />

                                <asp:CheckBox ID="UserNoCache" runat="server" Text="Disable local cache"
                                    meta:resourcekey="UserNoCacheResource1" /><br />
                                <asp:CheckBox ID="UserNoOfflineFolder" runat="server" Text="Disable offline accessible folder"
                                    meta:resourcekey="UserNoOfflineResource1" /><br />

                                <asp:CheckBox ID="NoAutoLogon" runat="server" Text="Disable 'Auto-Login next time'" meta:resourcekey="NoAutoLogonResource1" /><br />
                                <asp:CheckBox ID="DisableFolderDownload" runat="server"
                                    Text="Disable folder download from web client"
                                    meta:resourcekey="DisableFolderDownloadResource1" /><br />
                                <asp:CheckBox ID="DisablePrivateFileDownload" runat="server"
                                    Text="Disable personal file download from web client"
                                    meta:resourcekey="DisableFileDownloadResource1" /><br />
                                <asp:CheckBox ID="DisableSearch" runat="server" Text="Disable Search"
                                    meta:resourcekey="DisableSearchResource1" /><br />
                                <asp:CheckBox ID="ApproveNewDevice" runat="server" Text="Require approval for device access"
                                    meta:resourcekey="ApproveDeviceResource1" /><br />

                                <asp:CheckBox ID="ForceTwoFactor" runat="server" Text="Enforce 2-Step Verification on users"
                                    meta:resourcekey="ForceTwoResource1" /><br />
                                <asp:CheckBox ID="AlwaysTwoEmail" runat="server" Text="Send 2-step verification code by mail only"
                                    meta:resourcekey="AlwaysTwoEmailResource1" /><br />
                                <asp:CheckBox ID="DisableSettings" runat="server"
                                    Text="Hide Settings in Windows Client Management Console"
                                    meta:resourcekey="DisableSettingsResource1" /><br />
                                <asp:CheckBox ID="DisableClientDownload" runat="server"
                                    Text="Disable Client Download"
                                    meta:resourcekey="DisableClientDownloadResource1" /><br />
                                <asp:CheckBox ID="DisableWebClient" runat="server"
                                    Text="Disable WebClient" meta:resourcekey="CheckBox1Resource1" /><br />
                                <asp:CheckBox ID="DisableMobileClient" runat="server"
                                    Text="Disable Mobile Client" meta:resourcekey="DisableMobileResource1" /><br />
                                <asp:CheckBox ID="DisableRemoteAccess" runat="server"
                                    Text="Restrict access to Intranet only" meta:resourcekey="DisableRemoteResource1" /><br />
                                <asp:CheckBox ID="AddShortCutToDesktop" runat="server" Checked="True"
                                    Text="Create shortcut on Desktop"
                                    meta:resourcekey="AddShortCutToDesktopResource1" />
                                <br />
                                <asp:CheckBox ID="NoShowUpdater" runat="server"
                                    Text="Don't show the user who made the change in activities panel" meta:resourcekey="NoShowUpdaterResource1" />
                                <br />  
                                <asp:CheckBox ID="RequirePasswordForShares" runat="server"
                                    Text="Disable the no password option for new shares" meta:resourcekey="str_reqPasForSha" />
                                <br />
                                <asp:CheckBox ID="DisableOneTimePasswordForShares" runat="server"
                                    Text="Disable the one-time password option for new shares" meta:resourcekey="str_disOneTimPasForSha" />
                                <br />

                                <br />
                                <asp:CheckBox ID="SyncDownThrottled" runat="server" Text="Enable Throttle Sync"
                                    meta:resourcekey="SyncDownThrottledResource1" /><br />
                                <p style="line-height: 5px; font-size: 12px; color: #808080; margin-left: 16px;">
                                    <asp:Localize ID="Localize1" runat="server"
                                        Text="When set, following setting will apply."
                                        meta:resourcekey="Localize1Resource1"></asp:Localize>
                                </p>

                                <table>
                                    <tr>
                                        <td>
                                            <label><asp:Localize ID="Localize2" meta:resourcekey="asp_string3" runat="server"
                                                Text="Sync Throttled Upload Bandwidth (KB/s, 0-Unlimited):"></asp:Localize></label>
                                        </td>
                                        <td>
                                            <asp:TextBox ID="DayTimeUploadBandwidth" runat="server" Width="100px" Text="0" CssClass="form-control"
                                                meta:resourcekey="DayTimeUploadBandwidthResource1"></asp:TextBox>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label><asp:Localize ID="Localize3" meta:resourcekey="asp_string4" runat="server"
                                                Text="Sync Throttled Download Bandwidth (KB/s, 0-Unlimited):"></asp:Localize></label>
                                        </td>
                                        <td>
                                            <asp:TextBox ID="DayTimeDownloadBandwidth" runat="server" Width="100px" CssClass="form-control"
                                                Text="0" meta:resourcekey="DayTimeDownloadBandwidthResource1"></asp:TextBox>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label><asp:Localize ID="Localize4" meta:resourcekey="asp_string5" runat="server"
                                                Text="Full Speed Sync Stop Hour (default 7:00):"></asp:Localize></label>
                                        </td>
                                        <td>
                                            <asp:TextBox ID="DayTimeStartHour" runat="server" Width="100px" Text="7" CssClass="form-control"
                                                meta:resourcekey="DayTimeStartHourResource1"></asp:TextBox>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label><asp:Localize ID="Localize5" meta:resourcekey="asp_string6" runat="server"
                                                Text="Full Speed Sync Start Hour (default 20:00)"></asp:Localize></label>
                                        </td>
                                        <td>
                                            <asp:TextBox ID="DayTimeEndHour" runat="server" Width="100px" Text="20" CssClass="form-control"
                                                meta:resourcekey="DayTimeEndHourResource1"></asp:TextBox>
                                        </td>
                                    </tr>
                                </table>
                                <asp:CheckBox ID="LoginTimeLimit" runat="server" Text="Restrict User Logon Hours"
                                    meta:resourcekey="LoginTimeLimitResource1" /><br />
                                <table>
                                    <tr>
                                        <td>
                                            <label><asp:Localize meta:resourcekey="str_startHour" runat="server">Start hour</asp:Localize></label>
                                        </td>
                                        <td>
                                            <asp:TextBox ID="LoginStartHour" runat="server" Width="100px" Text="8" CssClass="form-control"></asp:TextBox>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label><asp:Localize meta:resourcekey="str_endHour" runat="server">End hour</asp:Localize></label>
                                        </td>
                                        <td>
                                            <asp:TextBox ID="LoginEndHour" runat="server" Width="100px" Text="18" CssClass="form-control"></asp:TextBox>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </td>
                    </tr>
                </table>
            </div>
            <div id="page_4_p" style="border: 0px solid #c0c0c0; padding: 10px; display: none;">
                <table width="100%" align="center" style="height: 100%;">
                    <tr style="display: none;">
                        <td class="InputLabel" align="left" style="padding-top: 10px;">

                            <table width="100%">
                                <tr>
                                    <td style="padding-right: 10px">
                                        <input type="checkbox" name="pub_to_all" onclick="Toggle('pubusers')" style="display: none;" />
                                        <asp:Localize meta:resourcekey="str_usrGrpAsdRol" runat="server">Users/Groups assigned to this role</asp:Localize>
                                    </td>


                                </tr>
                            </table>

                        </td>


                    </tr>
                    <tr>
                        <td class="InputLabel" colspan="2" valign="top" id="Td1" style="padding-top: 5px">
                            <div id="Div2" style="background-color: white; height: 320px; overflow: auto; border: 0px solid #C0C0C0;">
                                <table width="100%" style="background-color: white;" class="table-striped">
                                    <tbody id="PermTable">
                                        <tr style="background-color: white; border-bottom: 1px solid #f0f0f0; color: #404040;">
                                            <td style="padding: 5px;">
                                                <asp:Localize ID="Localize10" meta:resourcekey="string7" runat="server"
                                                    Text="User Name"></asp:Localize>
                                            </td>
                                            <td style="padding: 5px;">
                                                <asp:Localize ID="Localize11" meta:resourcekey="string8" runat="server"
                                                    Text="Email"></asp:Localize>
                                            </td>
                                            <td width="32px">&nbsp;</td>
                                        </tr>
                                        <asp:Repeater ID="UsersRepeater" runat="server">
                                            <ItemTemplate>
                                                <tr id='<%# DataBinder.Eval(Container.DataItem, "UserGuid") %>'
                                                    style='padding-top: 10px; border-bottom: 1px solid #f8f8f8;'>
                                                    <td width="200px" style="padding: 5px;">
                                                        <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "FirstName").ToString())%>&nbsp;<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "LastName").ToString())%></td>
                                                    <td>
                                                        <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"Email").ToString()) %>
                                                    </td>
                                                    <td style="padding: 5px;">
                                                        <a href='#'
                                                            onclick='DeleteACL("<%# DataBinder.Eval(Container.DataItem, "UserGuid") %>");return false;'><span class="fa fa-remove" style="color: #565656;"></span></a>
                                                    </td>
                                                    <td style="display: none;">
                                                        <input type="checkbox" checked="checked" name='aa_<%# DataBinder.Eval(Container.DataItem, "UserGuid") %>' value='<%# DataBinder.Eval(Container.DataItem, "UserGuid") %>'>
                                                    </td>
                                                </tr>
                                            </ItemTemplate>
                                        </asp:Repeater>
                                    </tbody>
                                </table>
                                <table id='non_user' width="100%" style="display: none;">
                                    <tr>
                                        <td style="padding-top: 50px;">
                                            <div class="guide" style="margin: 6px; margin-left: 26px; margin-right: 26px; vertical-align: middle; padding-top: 8px; padding-bottom: 8px; height: auto; width: 550px;">
                                                <asp:Localize ID="Localize16" meta:resourcekey="string13" runat="server"
                                                    Text="No permissions were set for the folder. All team users will have full access by default. The admin user always has full access."></asp:Localize>
                                                <br />
                                                <br />
                                                <asp:Localize ID="Localize17" meta:resourcekey="string14" runat="server"
                                                    Text="Please click 'Add User' above to add user(s) to the folder."></asp:Localize>
                                                <br />
                                                <br />
                                                <asp:Localize ID="Localize18" meta:resourcekey="string15" runat="server"
                                                    Text="This folder may not be visible to team users if it is not part of a team folder, regardless of permissions."></asp:Localize>
                                            </div>

                                        </td>
                                    </tr>
                                </table>

                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2" style="padding-right: 1px;">
                            <div style="height: 11px"></div>

                        </td>
                    </tr>

                </table>
            </div>
            <asp:HiddenField ID="PubFolderId" runat="server" />
        </div>
    </div>
    <div class="footer " style="border-left: 0; border-right: 0; border-bottom: 0; vertical-align: middle;"
        id="buttonspanel">
        <table width="100%" style="height: 48px; text-align: right; padding-right: 64px;"
            align="right">
            <tr>
                <td align="left" style="border-top: 0px solid #d0d0d0; padding-top: 15px;"></td>
                <td align="right" colspan="2" style="border-top: 0px solid #d0d0d0; padding-top: 15px;">
                    <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize>
                    <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize>
                    <asp:Button ID="PublishNow" runat="server" Text="Apply" CssClass="btn btn-primary gladbtn"
                        OnClick="PublishNow_Click" Width="128px"
                        meta:resourcekey="PublishNowResource1" />&nbsp;&nbsp;&nbsp;&nbsp;
                    <asp:Button ID="CancelPublish" runat="server" Text="Cancel" CssClass="btn btn-default"
                        Width="128px" CausesValidation="False"
                        meta:resourcekey="CancelPublishResource1" OnClick="CancelPublish_Click1" />
                    <%
                        PublishNow.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                        CancelPublish.OnClientClick = String.Format("Wait('{0}')", LocPlsWat.Text);
                    %>
                </td>
            </tr>
        </table>
    </div>


</asp:Content>
