﻿<%@ Page Title="Gladinet Cloud - Publish Folder" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="DomainStorageStat.aspx.cs" Inherits="GladinetPayFlow.DomainStorageStat"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    
    
    <style type="text/css">
        
.toolbtn {
  will-change: box-shadow, transform;
  -webkit-transition: -webkit-box-shadow 0.3s cubic-bezier(0.4, 0, 1, 1), background-color 0.3s cubic-bezier(0.4, 0, 0.2, 1), color 0.2s cubic-bezier(0.4, 0, 0.2, 1);
       -o-transition: box-shadow 0.3s cubic-bezier(0.4, 0, 1, 1), background-color 0.3s cubic-bezier(0.4, 0, 0.2, 1), color 0.2s cubic-bezier(0.4, 0, 0.2, 1);
          transition: box-shadow 0.3s cubic-bezier(0.4, 0, 1, 1), background-color 0.3s cubic-bezier(0.4, 0, 0.2, 1), color 0.2s cubic-bezier(0.4, 0, 0.2, 1);
  background: transparent;
}
.toolbtn:hover,
.toolbtn:focus {
  background-color: rgba(153, 153, 153, 0.2);
}

        
         td {
             font-size: 15px;
            
             font-weight: 100;
         }
        
        b {
            font-weight: 500;
        }
        
        #SizeChart  [hidden],#SizeChart template {
            display: block !important;
        }


        #FileTypeChart  [hidden],#FileTypeChart template {
            display: block !important;
        }

        
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        
        .style1
        {
            width: 153px;
        }
        
        .newusericon
        {
            background-image: url(images/upgradeuser.png);
        }
        .panel-title {font-weight: 400 !important;}
    </style>
    <script type="text/javascript">

        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 8000);



        
        var activewin;
        function closeCancelActiveWin() {
            activewin.close();
        }

        function closeActiveWin() {
            window.location = window.location;
        }

        function OnCancelPub() {
            parent.closeActiveWin();
        }

        function OnRefresh() {
            var rowURL = window.location.href;
            var e = document.getElementById("ImgContainer");

            if (rowURL.indexOf("sw") == -1)
                window.location.href = window.location.href + "?sw=" + (e.offsetWidth - 60) + "&sh=" + (e.offsetHeight - 70);
            else
                window.location.href = window.location.href + "&id=" + (new Date()).toString();
        }
      
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocBts" meta:resourcekey="str_bts" Visible="false">Bytes</asp:Localize>
<asp:Localize runat="server" ID="LocFldGetTntInf" meta:resourcekey="str_fldGetTntInf" Visible="false">Failed to get tenant info</asp:Localize>
<asp:Localize runat="server" ID="LocScnWasScf" meta:resourcekey="str_scnWasScf" Visible="false">Scan was successful</asp:Localize>
<asp:Localize ID="LocTtlFil" meta:resourcekey="str_ttlFil" runat="server" Visible="false">Total Files</asp:Localize>
<asp:Localize ID="LocTtlFld" meta:resourcekey="str_ttlFld" runat="server" Visible="false">Total Folders</asp:Localize>
<asp:Localize ID="LocTtlFilSze" meta:resourcekey="str_ttlFilSze" runat="server" Visible="false">Total File Size</asp:Localize>
<asp:Localize ID="LocAvgFilSze" meta:resourcekey="str_avgFilSze" runat="server" Visible="false">Average File Size</asp:Localize>
    <div 
        <%if (IsChildUi) { %>
        style="width:100%;border-bottom:1px solid #eeeeee"
        <%}else { %>
        class=" meubardrop"
        <%} %>
        >
     <table style="width:100%">
         <tr>
             <%if(!IsMobile()) { %>
             <td style="padding-left:10px;">
                 <p class="navbar-text alert alert-info5 panelhead"  ><asp:Localize meta:resourcekey="str_notRelTim" runat="server">This is NOT a real time report. The information is supplied by the background scan process.</asp:Localize></p>
             </td>
             <%} %>
             <td>
                  <div id="errmsgdiv" class="navbar-text">
                <b>
                    <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
            
                 </div>
             </td>
             <td align="right">
             <asp:LinkButton ID="LinkButton2" runat="server" OnClick="LinkButton1_Click" cssclass="btn btn-primary gladbtn navbar-btn navbar-right" onclientclick="Wait('...');" meta:resourcekey="resLocRfs"><span class="fa fa-refresh" aria-hidden="true"></span></asp:LinkButton>

             </td>
         </tr>
     </table>
    </div>
    
    <table style="width:100%">
        <tr>
            <td>
    <div class="row " style=" margin-top: 28px; padding:10px!important;" >
        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 " style=" padding-bottom:10px!important;" >
            <div class="viewcard" style="width:100%!important;"">
                <div style="padding: 10px; border-bottom: 1px solid #f0f0f0;" class="boxbordercolor secsubcolor" >
                    <h3 class="panel-title">
                        <asp:Localize meta:resourcekey="str_ovlSts" runat="server">Overall Statistics</asp:Localize>
                    </h3>
                </div>
                <div class="panel-body" style="padding:0px!important;">
                    <table width="100%" style="background-color: white;" class="table-striped">
                        <asp:Repeater ID="OverallRepeater" runat="server">
                            <ItemTemplate>
                                <tr style="padding-top: 5px;">
                                    <td style="padding-left: 10px;" align="left">
                                        &nbsp;<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "Name").ToString())%></td>
                                    <td>
                                        <%#DataBinder.Eval(Container.DataItem, "Value")%>
                                    </td>
                                    <td>
                                        <%#DataBinder.Eval(Container.DataItem, "Note")%>
                                    </td>
                                </tr>
                            </ItemTemplate>
                        </asp:Repeater>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 text-center topbuffer" style="padding-bottom:10px;">
            <div class="viewcard">
                <div style="padding: 10px; border-bottom: 1px solid #f0f0f0;" class="boxbordercolor secsubcolor">
                    <h3 class="panel-title">
                        <asp:Localize meta:resourcekey="str_szeDtr" runat="server">File Size Distribution</asp:Localize>
                    </h3>
                </div>
                <div class="panel-body" style="padding:0px!important;">
                    <table width="100%" style="background-color: white">
                        <tr>
                            <td>
                                <table width="100%" class="table-striped">
                                    <asp:Repeater ID="FileSizeRepeater" runat="server">
                                        <ItemTemplate>
                                            <tr style="padding-top: 5px;">
                                                <td style="padding-left: 10px;" align="left">
                                                    <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "Name").ToString())%>
                                                </td>
                                                <td>
                                                    <%#DataBinder.Eval(Container.DataItem, "Value")%>
                                                </td>
                                                <td>
                                                    <%#DataBinder.Eval(Container.DataItem, "Note")%>
                                                </td>
                                            </tr>
                                        </ItemTemplate>
                                    </asp:Repeater>
                                </table>
                            </td>
                            <td width="200px" id="SizeChart">
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
   
        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 text-center topbuffer" style="padding-bottom:10px;">
            <div class="viewcard">
                <div style="padding: 10px; border-bottom: 1px solid #f0f0f0;" class="boxbordercolor secsubcolor"  >
                    <h3 class="panel-title">
                        <asp:Localize meta:resourcekey="str_filTpeDtr" runat="server">File Type Distribution</asp:Localize>
                    </h3>
                </div>
                <div class="panel-body" style="padding:0px!important;">
                    <table width="100%" style="background-color: white;">
                        <tr>
                            <td>
                                <table width="100%" class="table-striped">
                                    <asp:Repeater ID="FileTypeRepeater" runat="server">
                                        <ItemTemplate>
                                            <tr style="padding-top: 5px;">
                                                <td style="padding-left: 10px;" align="left">
                                                    <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "Name").ToString())%>
                                                </td>
                                                <td>
                                                    <%#DataBinder.Eval(Container.DataItem, "Value")%>
                                                </td>
                                                <td>
                                                    <%#DataBinder.Eval(Container.DataItem, "Note")%>
                                                </td>
                                            </tr>
                                        </ItemTemplate>
                                    </asp:Repeater>
                                </table>
                            </td>
                            <td width="200px" id="FileTypeChart">
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 text-center topbuffer" style="padding-bottom:10px;">
            <div class="viewcard">
                <div style="padding: 10px; border-bottom: 1px solid #f0f0f0;" class="boxbordercolor secsubcolor"  >
                    <table width="100%">
                        <tr>
                            <td>
                                <h3 class="panel-title">
                        <asp:Localize meta:resourcekey="str_usdMstStr" runat="server">Users with the Most Storage Usage</asp:Localize>
                    </h3>
                            </td>
                            <td width="32px">
                                <span class="fa fa-export toolicon" style="color: white;" title="<%=str_useage.Text %>" onclick="ExportUsage();"></span>
                                <asp:Localize meta:resourcekey="str_useage" id="str_useage" runat="server" visible="False">User Storage Usage Report</asp:Localize>
                            </td>
                        </tr>

                    </table>
                    
                </div>
                <div class="panel-body" style="padding:0px!important;">
                    <table width="100%" style="background-color: white;" class="table-striped">
                        <asp:Repeater ID="TopUserRepeater" runat="server">
                            <ItemTemplate>
                                <tr style="padding-top: 5px;">
                                    <td style="padding-left: 10px;" align="left">
                                        <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "Name").ToString())%>
                                    </td>
                                    <td>
                                        <%#DataBinder.Eval(Container.DataItem, "UsedStr")%>
                                    </td>
                                    <%if (!IsMobile()) {%>
                                    <td>
                                        <%#DataBinder.Eval(Container.DataItem, "QuotaStr")%>
                                    </td>
                                    <%} %>
                                </tr>
                            </ItemTemplate>
                        </asp:Repeater>
                    </table>
                </div>
            </div>
        </div>
    </div>
            </td>
        </tr>
        </table>

    <div style="display: none">
    <asp:Button ID="ExportUser" runat="server" Text="Button" OnClick="ExportUser_Click" />    
    </div>
    
    <script type="text/javascript">
        function ExportUsage() {
            var b = document.getElementById("ctl00_MainContent_ExportUser");
            b.click();
        }
        
        Ext.require('Ext.chart.*');

        
        function DrawChart(rid, fields, data, min, max, xtitle, ytitle, xfield, yfield, charttype) {
            
            var browserStore = new Ext.data.JsonStore({
                fields: fields,
                data: data
            });

            var colors = ['rgb(47, 162, 223)'];

            Ext.chart.theme.Browser = Ext.extend(Ext.chart.theme.Base, {
                constructor: function (config) {
                    Ext.chart.theme.Base.prototype.constructor.call(this, Ext.apply({
                        colors: colors
                    }, config));
                }
            });
        
            var chart = new Ext.chart.Chart({
                renderTo: rid,
                width: '100%',
                height: '100%',
              
                store: browserStore,
                legend: {
                    position: 'right'
                },
                axes: [{
                    type: 'Numeric',
                    position: 'left',
                   
                    title: ytitle,
                    grid: true,
                    minimum: min,
                    maximum: max
                }, {
                    type: 'Category',
                    position: 'bottom',
                    grid: true,
                    fields: [xfield],
                    title: xtitle,
                    label: {
                        renderer: function (v) {
                            return v;
                        }
                    }
                }],
                series: [{
                    type: charttype,
                    axis: 'left',
                    highlight: true,
                    xField: xfield,
                    yField: yfield
                }]
            });
        }


        function DrawPieChart(rid, fields, data,   xfield, yfield) {
            
            var browserStore = new Ext.data.JsonStore({
                fields: fields,
                data: data
            });

            var colors = ['rgb(47, 162, 223)'];

            Ext.chart.theme.Browser = Ext.extend(Ext.chart.theme.Base, {
                constructor: function (config) {
                    Ext.chart.theme.Base.prototype.constructor.call(this, Ext.apply({
                        colors: colors
                    }, config));
                }
            });
            chart = new Ext.chart.Chart({
                renderTo: rid,
                width: '200px',
                height: '200px',
                animate: true,
                store: browserStore,
        
                shadow: true,
                legend: {
                    position: 'right'
                },
                insetPadding: 25,
                theme: 'Base:gradients',
                series: [{
                    type: 'pie',
                    field: yfield,
                    showInLegend: false,
                    highlight: {
                        segment: {
                            margin: 20
                        }
                    },
                    label: {
                        field: xfield,
                        display: 'rotate',
                        contrast: true,
                        font: '10px "Lucida Grande", "Lucida Sans Unicode", Verdana, Arial, Helvetica, sans-serif'
                    },
                    animate: true
                }]
            });
            
        }

        var SizeDistData = [
            <asp:Repeater ID="SizeDistRepeater" runat="server" >
            <ItemTemplate>         
            <%#(Container.ItemIndex == 0)? "": "," %>      
            {        
            stype:'<%#DataBinder.Eval(Container.DataItem,"Name") %>',
            Distribution:<%#DataBinder.Eval(Container.DataItem,"Value") %>
            }
            </ItemTemplate>
        </asp:Repeater>      
        ];


        var TypeDistData = [
            <asp:Repeater ID="TypeDistRepeater" runat="server" >
            <ItemTemplate>         
            <%#(Container.ItemIndex == 0)? "": "," %>      
            {        
            stype:'<%#DataBinder.Eval(Container.DataItem,"Name") %>',
            Distribution:<%#DataBinder.Eval(Container.DataItem,"Value") %>
            }
            </ItemTemplate>
        </asp:Repeater>      
        ];


        Ext.onReady(function () {
            DrawPieChart('SizeChart', ['stype', 'Distribution'], SizeDistData,  'stype', 'Distribution');
            DrawPieChart('FileTypeChart', ['stype', 'Distribution'], TypeDistData,  'stype', 'Distribution');

        });

    </script>


          <asp:HiddenField ID="TargetDomainId" runat="server" />
    
</asp:Content>
