﻿<%@ Page Title="Gladinet Cloud - User Manager" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="DeviceTasks.aspx.cs" Inherits="GladinetPayFlow.DeviceTasks"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
    </style>
    <script type="text/javascript">
        function getScrollXY() {
            var scrOfX = 0, scrOfY = 0;
            if (typeof (window.pageYOffset) == 'number') {
                //Netscape compliant
                scrOfY = window.pageYOffset;
                scrOfX = window.pageXOffset;
            } else if (document.body && (document.body.scrollLeft || document.body.scrollTop)) {
                //DOM compliant
                scrOfY = document.body.scrollTop;
                scrOfX = document.body.scrollLeft;
            } else if (document.documentElement && (document.documentElement.scrollLeft || document.documentElement.scrollTop)) {
                //IE6 standards compliant mode
                scrOfY = document.documentElement.scrollTop;
                scrOfX = document.documentElement.scrollLeft;
            }
            //return [scrOfX, scrOfY];
            return scrOfY;
        }




        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //parent.setActivePanel("UserMgr");

        function onDelUser(id, name) {
            var h = "/management/GuestUserMgrPage.aspx?op=delete&id=" + id;

            if (confirm("Do you really want to delete (" + unescape(name) + ")?")) {
                Wait('Deleting');
                window.location = h;
            }

        }

        function onTaskInfo(info) {
            var e = document.getElementById("taskinfo");
            var parts = info.split(';');
            try {
                var t = document.getElementById(parts[0] + "_total");
                var p = document.getElementById(parts[0] + "_pending");
                var f = document.getElementById(parts[0] + "_failed");
                var r = document.getElementById(parts[0] + "_run");
                
                t.innerHTML = parts[1];
                r.innerHTML = parts[2];
                f.innerHTML = parts[3];
                p.innerHTML = parts[4];

                var total = parseInt(parts[1]);
                var pending = parseInt(parts[4]);

                var ic = document.getElementById(parts[0] + "_icon");
                var p1 = document.getElementById(parts[0] + "_p1");
                if (total != 0 && total > pending) {
                    ic.className = "fa fa-refresh";
                    var p2 = document.getElementById(parts[0] + "_p2");
                    ic.style.color = "#004080";
                    ic.title = "Running";
                    p1.style.display = "";
                    var ec = parseInt(parts[4]);

                    var pr = total - pending;
                    pr = (pr * 10000+ec) / (total * 100);
                    p2.style.width = "" + Math.ceil(pr) + "%";
                    r.innerHTML = "" + Math.ceil(pr) + "%";
                    //e.innerHTML = "" + Math.floor(pr) + "%";
                } else {
                    ic.className = "fa fa-calendar";
                    ic.style.color = "#008080";
                    ic.title = "Pending";
                    p1.style.display = "none";
                    r.innerHTML = "";
                }

            } catch (ee) {
                e.innerHTML = ee.toString();
            }
          
        }

        function OpenHtmlWindowShort(id, title, Html, w, h) {

            activewin = new Ext.Window({
                id: id,
                title: title,
                width: w,
                height: maxh(h),
                plain: true,
                modal: true,
                constrain: true,
                maximizable: false,
                maximized: false,
                bodyPadding: 5,
                resizable: false,
                shadow: 'drop',
                iconCls: 'publish',
                bodyStyle: 'background:#dfe8f6;border:0px; ',
                shadowOffset: 10,
                html: Html,
                defaults: {
                    border: false
                }
            });
            activewin.show();

        }


        function closeCancelActiveWin() {
            activewin.close();
        }

        function closeActiveWin() {
            window.location = "/management/AttachedFolders.aspx";
        }

        function OnWipeDevice(id, name) {
            var ng = document.getElementById("ctl00_MainContent_DeviceId");
            var btn = document.getElementById("ctl00_MainContent_WipeDevice");

            if (confirm("<asp:Localize meta:resourcekey="js_string11" runat="server">Confirm detaching the folder (</asp:Localize>" + unescape(id) + ")?")) {

                Wait("<asp:Localize meta:resourcekey="js_string12" runat="server">Detaching...</asp:Localize>");
                ng.value = id;
                btn.click();
            }
        }

        function OnAttachFolder() {
            window.location = "/management/AddAttachedFolder.aspx?id=<%=ViewInstanceId%>&name=<%=ViewDeviceName %>";
        }
        function OnDeviceList() {
            window.location = "<%=PageReturnUrl %>";
        }

        function OpenSubTask(tid, t, ti) {
            parent.SetSubView( "DeviceSubTasks.aspx?id=<%=ViewInstanceId%>&tid="+tid+"&t=" + t, ti);
        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocFai" meta:resourcekey="str_fai" Visible="false">Failed</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToLoaDevInf" meta:resourcekey="str_faiToLoaDevInf" Visible="false">Failed to load device info</asp:Localize>
    <asp:Localize ID="LocSncStsTxtUnk" meta:resourcekey="str_sncStsTxtUnk" runat="server" Visible="false">Unknown</asp:Localize>
    <asp:Localize ID="LocSncStsTxtFldRtvSts" meta:resourcekey="str_sncStsTxtFldRtvSts" runat="server" Visible="false">Failed to retrieve sync status</asp:Localize>
    <asp:Localize ID="LocSncStsTxtFld" meta:resourcekey="str_sncStsTxtFld" runat="server" Visible="false">Sync Failed</asp:Localize>
    <asp:Localize ID="LocSncStsTxtPsd" meta:resourcekey="str_sncStsTxtPsd" runat="server" Visible="false">Task Paused</asp:Localize>
    <asp:Localize ID="LocSncStsTxtRng" meta:resourcekey="str_sncStsTxtRng" runat="server" Visible="false">Running</asp:Localize>
    <asp:Localize ID="LocSncStsTxtPnd" meta:resourcekey="str_sncStsTxtPnd" runat="server" Visible="false">Task Pending</asp:Localize>

    <div class="meubardrop navbar navbar-default" role="navigation">
               <div class="container-fluid">
                   
                   <button type="button" class="btn btn-default navbar-btn navbar-left " title="<%=STRDevList.Text %>" onclick="OnDeviceList()" style="display: none;"> 
                <span class="fa fa-menu-left"></span>  
                       <asp:Localize meta:resourcekey="str_devlist" ID="STRDevList" runat="server" 
                           Text="Return"></asp:Localize>
             </button>

                   <p class="navbar-text dark">
                        <asp:Label ID="UserCount" runat="server" meta:resourcekey="UserCountResource1"></asp:Label>
                            <asp:Label ID="GuestQuota" runat="server" Visible="False" Text="0 available guest user quota"
                                meta:resourcekey="GuestQuotaResource1"></asp:Label>
                   </p>
                    <p class="navbar-text dark" id="taskinfo"></p>
                   <div id="errmsgdiv" class="navbar-text">
                       <b>
                          <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                   </div>
                   <div  class="btn btn-primary gladbtn navbar-btn navbar-right dark" style="margin-right: 8px;">
                       <span class="fa fa-refresh" aria-hidden="true"></span>
                    
                       <asp:LinkButton ID="RefreshBtn"  runat="server" cssclass="btn btn-primary gladbtn"
                           OnClick="LinkButton2_Click"  OnClientClick="Wait('one minute'); return true;"><asp:Localize meta:resourcekey="str_refesh" runat="server">Refresh</asp:Localize> </asp:LinkButton>
                   </div>
               </div>
           </div>
    <table id="grid-table" width="95%" align="center" style="background-color: transparent;
        margin-top: 18px;" cellspacing="0" cellpadding="0">
        <tr>
            <td id="grid-example" valign="top" style="background-color: transparent; padding: 10px; padding-top: 30px;">
                <div class="row " align="center">
                    <asp:Repeater ID="UsersRepeater" runat="server" OnItemCommand="UsersRepeater_ItemCommand"
                        OnItemDataBound="OnUserItemBound">
                        <ItemTemplate>
                            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 text-center topbuffer" style="padding-bottom:10px;">
                                <div class=" panel panel-default viewcard" style="box-shadow: 0px px 3px #d0d0d0; align-content: center;"
                                    align="center">
                                    <table width="100%">
                                        <tr>
                                            <td width="80px;" valign="middle" align="center" style="border-right: 1px dashed #d0d0d0;background-color: #f8f8f8; ">
                                                <table width="100%">
                                                    <tr>
                                                       <td style="padding: 5px;padding-top: 10px;" align="center">
                                                 <span class='fa <%# DataBinder.Eval(Container.DataItem, "SyncStatusIcon") %>  ' id="<%# DataBinder.Eval(Container.DataItem, "TaskId") %>_icon"
                                                     title='<%# DataBinder.Eval(Container.DataItem, "SyncStatusString") %>' 
                                                     style='color:<%# DataBinder.Eval(Container.DataItem, "SyncStatusColor") %>; font-size: 32px; cursor: pointer;'></span>
                                                           
                                                       </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                        <table>
                                                            <tr>
                                                                <td style="<%# DataBinder.Eval(Container.DataItem, "ResumeDisplay") %>">
                                                                    <a class="btn btn-primary gladbtn" href="javascript:void(0)" onclick="ResumeTask('<%# DataBinder.Eval(Container.DataItem, "TaskId") %>');return false;" style="font-size: 10px!important;padding:2px; font-weight: 100;"><asp:Localize meta:resourcekey="str_resume" runat="server">Resume</asp:Localize></a>
                                                                </td>
                                                                <td style="<%# DataBinder.Eval(Container.DataItem, "PauseDisplay") %>">
                                                                    <a class="btn btn-primary gladbtn" href="javascript:void(0)" onclick="PauseTask('<%# DataBinder.Eval(Container.DataItem, "TaskId") %>');return false;" style="font-size: 10px!important; padding:2px; font-weight: 100;"><asp:Localize meta:resourcekey="str_pause" runat="server">Pause</asp:Localize></a>
                                                                </td>

                                                                <td style="<%# DataBinder.Eval(Container.DataItem, "StartDisplay") %>">
                                                                    <a class="btn btn-primary gladbtn" href="javascript:void(0)" onclick="StartTask('<%# DataBinder.Eval(Container.DataItem, "TaskId") %>');return false;" style="font-size: 10px!important; padding:2px; font-weight: 100;"><asp:Localize meta:resourcekey="str_start" runat="server">Start</asp:Localize></a>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                            <td>
                                                <table width="100%" >
                                                    <tr>
                                                        <td  style="padding: 5px; padding-left: 10px; color: #808080;" width="200px">
                                                            <h4 id="h4TaskName<%# Container.ItemIndex + 1 %>" style="font-size:18px;">
                                                                <%#SanitizeOutput(DataBinder.Eval(Container.DataItem,"TaskName"))%>
                                                            </h4>
                                                            <script>
                                                                var tn = document.getElementById("h4TaskName<%# Container.ItemIndex + 1 %>");
                                                                if(tn){
                                                                    switch(tn.innerText.toLowerCase()){
                                                                        case "system check task":
                                                                            tn.innerText = "<asp:Localize runat="server" meta:resourcekey="str_stmChkTask">System Check Task</asp:Localize>";
                                                                            break;
                                                                        case "system sync task":
                                                                            tn.innerText = "<asp:Localize runat="server" meta:resourcekey="str_stmSnkTask">System Sync Task</asp:Localize>";
                                                                            break;
                                                                        case "system sync down task":
                                                                            tn.innerText = "<asp:Localize runat="server" meta:resourcekey="str_stmSnkDwnTask">System Sync Down Task</asp:Localize>";
                                                                            break;
                                                                        case "system update task":
                                                                            tn.innerText = "<asp:Localize runat="server" meta:resourcekey="str_stmUpdTask">System Update Task</asp:Localize>";
                                                                            break;
                                                                    }
                                                                }
                                                            </script>
                                                        </td>
                                                        <td colspan="5" style="padding: 5px; padding-right: 10px; color: #808080;" valign="bottom" align="left" >
                                                            <div class="progress" style="<%#DataBinder.Eval(Container.DataItem,"SyncProgressBarDisplay")%>" id="<%# DataBinder.Eval(Container.DataItem, "TaskId") %>_p1">
                                                                <div class="progress-bar  <%#DataBinder.Eval(Container.DataItem,"SyncProgressBarType") %>" role="progressbar" aria-valuenow="40" id="<%# DataBinder.Eval(Container.DataItem, "TaskId") %>_p2"
                                                                    aria-valuemin="0" aria-valuemax="100" style="width:<%#DataBinder.Eval(Container.DataItem,"SyncProgressPercent") %>%">
                                                                    <span class="sr-only"><asp:Localize meta:resourcekey="str_70Com" runat="server">70% Complete</asp:Localize></span>
                                                                  </div>
                                                                </div>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        
                                                        <td style="border-top:1px dashed #d0d0d0; padding: 5px; padding-left: 10px;" class="text-muted" width="200px" id="tdTaskDesc<%# Container.ItemIndex + 1 %>" >
                                                            <%#DataBinder.Eval(Container.DataItem,"TaskDesc")%>
                                                        </td>
                                                        <td style="border-top:1px dashed #d0d0d0;padding: 5px; " class="text-muted" width="120px">
                                                            <script>
                                                                var tn = document.getElementById("tdTaskDesc<%# Container.ItemIndex + 1 %>");
                                                                if(tn){
                                                                    switch(tn.innerText.toLowerCase().trim()){
                                                                        case "system check task":
                                                                            tn.innerText = "<asp:Localize runat="server" meta:resourcekey="str_stmChkTask">System Check Task</asp:Localize>";
                                                                            break;
                                                                        case "system sync task":
                                                                            tn.innerText = "<asp:Localize runat="server" meta:resourcekey="str_stmSnkTask">System Sync Task</asp:Localize>";
                                                                            break;
                                                                        case "system sync down task":
                                                                            tn.innerText = "<asp:Localize runat="server" meta:resourcekey="str_stmSnkDwnTask">System Sync Down Task</asp:Localize>";
                                                                            break;
                                                                        case "system update task":
                                                                            tn.innerText = "<asp:Localize runat="server" meta:resourcekey="str_stmUpdTask">System Update Task</asp:Localize>";
                                                                            break;
                                                                    }
                                                                }
                                                            </script>
                                                            <asp:Localize meta:resourcekey="str_totals" runat="server">Total Tasks:</asp:Localize>
                                                            <span id="<%# DataBinder.Eval(Container.DataItem, "TaskId") %>_total"><%#DataBinder.Eval(Container.DataItem,"TotalTaskCount") %></span>

                                                        </td>
                                                        <td  style="border-top:1px dashed #d0d0d0;padding: 5px; " class="text-muted" width="120px">
                                                            
                                                            <a href='#' onclick='OpenSubTask("<%# DataBinder.Eval(Container.DataItem, "TaskId") %>", 1,"<%=str_pendings.Text%>");return false;'><%=str_pendings.Text%></a>
                                                             <span id="<%# DataBinder.Eval(Container.DataItem, "TaskId") %>_pending"><%#DataBinder.Eval(Container.DataItem,"PendingTaskCount") %></span>
                                                        </td>
                                                        <td  style="border-top:1px dashed #d0d0d0;padding: 5px; " class="text-muted" width="120px">
                                                             <a href='#' onclick='OpenSubTask("<%# DataBinder.Eval(Container.DataItem, "TaskId") %>", 2,"<%=str_failed.Text %>");return false;'><%=str_failed.Text %></a>
                                                            <span id="<%# DataBinder.Eval(Container.DataItem, "TaskId") %>_failed"><%#DataBinder.Eval(Container.DataItem,"FailedTaskCount") %></span>
                                                                </td>
                                                        <td  style="border-top:1px dashed #d0d0d0;padding: 5px; " class="text-muted" width="120px">
                                                            <asp:Localize meta:resourcekey="str_progress" runat="server">Progress:</asp:Localize>
                                                            <span id="<%# DataBinder.Eval(Container.DataItem, "TaskId") %>_run"><%#DataBinder.Eval(Container.DataItem,"RunningTaskCount") %></span>
                                                                </td>
                                                        
                                                        <td style="border-top:1px dashed #d0d0d0;padding: 5px; " class="text-muted" width="120px">
                                                            <asp:Localize meta:resourcekey="str_nextrun" runat="server">Next Run Time:</asp:Localize>
                                                            <span id="<%# DataBinder.Eval(Container.DataItem, "TaskId") %>_nr"><%#DataBinder.Eval(Container.DataItem,"TaskStartTime") %></span>

                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </ItemTemplate>
                    </asp:Repeater>
                </div>
            </td>
        </tr>
                                                                    <tr style="display: none;">
                                                                <td>
                                                                    <asp:Localize meta:resourcekey="str_pendings" runat="server" ID="str_pendings">Pending Tasks:</asp:Localize>
                                                                    <asp:Localize meta:resourcekey="str_failed" runat="server" id="str_failed" >Failed Tasks:</asp:Localize>
                                                                    <asp:Button ID="Resume" runat="server" Text="Resume" CssClass="btn btn-primary gladbtn" 
                                                                        onclick="Resume_Click"/>
                                                                    <asp:Button ID="Pause" runat="server" Text="Pause" CssClass="btn btn-primary gladbtn" 
                                                                        onclick="Pause_Click"/>
                                                                    <asp:Button ID="Start" runat="server" Text="Start" CssClass="btn btn-primary gladbtn" 
                                                                        onclick="Start_Click"/>

                                                                </td>
                                                            </tr>

    </table>
    <asp:HiddenField ID="DeviceId" runat="server" />
    <asp:HiddenField ID="HiddenTaskId" runat="server" />
    <div style="display: none;">
        <asp:Button ID="WipeDevice" runat="server" OnClick="WipeDevice_Click" meta:resourcekey="WipeDeviceResource1" />
    </div>
    <script type="text/javascript">
        var grid;
        function AdjustGridTable() {
            

            var e = document.getElementById("grid-example");
            e.style.height = (document.documentElement.offsetHeight - 102) + "px";
        }

        Ext.onReady(function () {
            Ext.EventManager.onWindowResize(AdjustGridTable);
            AdjustGridTable();
        });

        function ResumeTask(tid) {
            var b = document.getElementById("ctl00_MainContent_Resume");
            var t = document.getElementById("ctl00_MainContent_HiddenTaskId");

            t.value = tid;
            Wait('One Minute');
            b.click();
        }

        function PauseTask(tid) {
            var b = document.getElementById("ctl00_MainContent_Pause");
            var t = document.getElementById("ctl00_MainContent_HiddenTaskId");

            t.value = tid;
            Wait('One Minute');
            b.click();

        }

        function StartTask(tid) {
            var b = document.getElementById("ctl00_MainContent_Start");
            var t = document.getElementById("ctl00_MainContent_HiddenTaskId");

            t.value = tid;
            Wait('One Minute');
            b.click();

            

        }


    </script>
    
    
    <asp:HiddenField ID="backtotarget" runat="server" />    
    <asp:HiddenField ID="HiddenTaskType" runat="server" />
</asp:Content>
