﻿<%@ Page Title="Gladinet Cloud - User Manager" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="DeviceSyncScan.aspx.cs" Inherits="GladinetPayFlow.DeviceSyncScan"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<%@ Import Namespace="GladinetPayFlow" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol {
            background-color: #f0f0f0;
            font-size: 14px;
        }

        .x-tree-icon {
            display: none !important;
        }

        .x-grid3-row td {
            line-height: 10px;
        }

        .x-tree3-el {
            height: 15px !important;
        }
        .cstreeleaf{font-size:18px !important;}                                                         
        .x-tree-arrows .x-grid-tree-node-expanded .x-tree-expander,.x-tree-arrows .x-tree-expander-over .x-tree-expander {background-position: -20px center;}
        #scanFilterRow{display:flex;align-items:center;gap:10px;color: #565656;font-size: 16px;font-weight: 100;}
        @media (max-width: 1090px) {
             #scanFilterRow{justify-content: center;width:100%;}
             #ctl00_MainContent_UserCount{display:block;padding-top:20px;width: 100%;clear: both;}
        }
        @media (min-width: 1091px) {
             #scanFilterRow{justify-content: flex-end;float: right;}  
             #ctl00_MainContent_UserCount{display:inline-block;padding-top:10px;float:left;padding-left:10px;}
        }
        #scanFilterRow span.bmd-form-group{padding:0 0 0 0;}  
        #scanFilterRow input{padding:0 0 0 0;width:200px;}
        #scanFilterRow p{margin:0 0 0 0;font-weight:100;}     
        #<%=txtScanFilter.ClientID %> { padding-left:7px; }        
        #<%=txtScanFilter.ClientID %>:-ms-input-placeholder,.form-control:-ms-input-placeholder {
            color:#bfbfbf !important;   
        }
        #<%=txtScanFilter.ClientID %>::-ms-input-placeholder,.form-control::-ms-input-placeholder {
            color:#bfbfbf !important;   
        }
        #<%=txtScanFilter.ClientID %>::placeholder,.form-control::placeholder {
            color:#bfbfbf !important;   
            opacity: 1; /* Firefox */
        }
    </style>
    <script type="text/javascript">
        function getScrollXY() {
            var scrOfX = 0, scrOfY = 0;
            if (typeof (window.pageYOffset) == 'number') {
                //Netscape compliant
                scrOfY = window.pageYOffset;
                scrOfX = window.pageXOffset;
            } else if (document.body && (document.body.scrollLeft || document.body.scrollTop)) {
                //DOM compliant
                scrOfY = document.body.scrollTop;
                scrOfX = document.body.scrollLeft;
            } else if (document.documentElement && (document.documentElement.scrollLeft || document.documentElement.scrollTop)) {
                //IE6 standards compliant mode
                scrOfY = document.documentElement.scrollTop;
                scrOfX = document.documentElement.scrollLeft;
            }
            //return [scrOfX, scrOfY];
            return scrOfY;
        }


        function stringStartsWith(s, p) {
            return (s.indexOf(p) == 0);
        }
        function GetShortString(src, MaxLen) {
            if (src.length <= MaxLen)
                return src;
            src = src.replace('[BuiltInGroup]', '');
            if (src.length <= MaxLen)
                return src;
            var len = (MaxLen - 3) / 2;
            var p1 = src.substring(0, len);
            var p2 = src.substring(src.length - len);
            return p1 + "..." + p2;

        }

        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //parent.setActivePanel("UserMgr");

        function onDelUser(id, name) {
            var h = "/management/GuestUserMgrPage.aspx?op=delete&id=" + id;

            if (confirm("<asp:Localize meta:resourcekey="str_dltCfmMsg" runat="server">Do you really want to delete</asp:Localize> (" + unescape(name) + ")?")) {
                Wait('Deleting');
            window.location = h;
        }

        }

        function OpenHtmlWindowShort(id, title, Html, w, h) {

            activewin = new Ext.Window({
                id: id,
                title: title,
                width: w,
                height: maxh(h),
                plain: true,
                modal: true,
                constrain: true,
                maximizable: false,
                maximized: false,
                bodyPadding: 5,
                resizable: false,
                shadow: 'drop',
                iconCls: 'publish',
                bodyStyle: 'background:#dfe8f6;border:0px; ',
                shadowOffset: 10,
                html: Html,
                defaults: {
                    border: false
                }
            });
            activewin.show();

        }


        function closeCancelActiveWin() {
            activewin.close();
        }

        function closeActiveWin() {
            window.location = "/management/AttachedFolders.aspx";
        }

        function OnWipeDevice(id, name) {
            var ng = document.getElementById("ctl00_MainContent_DeviceId");
            var btn = document.getElementById("ctl00_MainContent_WipeDevice");

            if (confirm('<asp:Localize meta:resourcekey="js_string11" runat="server">Confirm detaching the folder (</asp:Localize>' + unescape(id) + ")?")) {

                Wait('<asp:Localize meta:resourcekey="js_string12" runat="server">Detaching...</asp:Localize>');
                ng.value = id;
                btn.click();
            }
        }

        function OnAttachFolder() {
            window.location = "/management/AddAttachedFolder.aspx?id=<%=HiddenInstanceId.Value%>&name=<%=HiddenDeviceName.Value %>";
        }
        function OnDeviceList() {
            window.location = "DeviceAttachedFolders.aspx?id=<%=HiddenInstanceId.Value %>";
        }

        function RefreshList() {
            var e = document.getElementById("ctl00_MainContent_RefreshBtn");
            Wait("Loading...");
            e.click();
        }

        function OnIconView() {
            var e = document.getElementById("lisview");
            e.style.display = "none";

            e = document.getElementById("grid-example");
            e.style.display = "";

            e = document.getElementById("iconviewbtn");
            e.style.display = "none";

            e = document.getElementById("listviewbtn");
            e.style.display = "";

        }

        function OnListView() {
            var e = document.getElementById("lisview");
            e.style.display = "";

            e = document.getElementById("grid-example");
            e.style.display = "none";

            e = document.getElementById("iconviewbtn");
            e.style.display = "";

            e = document.getElementById("listviewbtn");
            e.style.display = "none";

        }                        
        function SelectAllUploadTasks() {    
            DeSelectAll();                               
            var localOnlyOrLocalNewer = document.querySelectorAll("input[type=checkbox].taskStatus_localonly, input[type=checkbox].taskStatus_localnewer");
            for (var i = 0; i < localOnlyOrLocalNewer.length; ++i) {
                if (localOnlyOrLocalNewer[i].name && localOnlyOrLocalNewer[i].name.indexOf("|") != -1) {
                    localOnlyOrLocalNewer[i].checked = true;
                }
            }
        }
        function SelectAllDownloadTasks() { 
            DeSelectAll();
            var cloudOnlyOrCloudNewer = document.querySelectorAll("input[type=checkbox].taskStatus_cloudonly, input[type=checkbox].taskStatus_cloudnewer");
            for (var i = 0; i < cloudOnlyOrCloudNewer.length; ++i) {
                if (cloudOnlyOrCloudNewer[i].name && cloudOnlyOrCloudNewer[i].name.indexOf("|") != -1) {
                    cloudOnlyOrCloudNewer[i].checked = true;
                }
            }
        }
        function SelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox" && Users[i].name && Users[i].name.indexOf("|") != -1) {
                    Users[i].checked = true;
                }
            }
        }

        function DeSelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox" && Users[i].name && Users[i].name.indexOf("|") != -1) {
                    Users[i].checked = false;
                }
            }
        }

        function ReSelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox" && Users[i].name && Users[i].name.indexOf("|") != -1) {
                    Users[i].checked = !Users[i].checked;
                }
            }
        }

        var gTaskQueue = [];

        function SyncAll() {
            gTaskQueue = [];

            var Users = document.getElementsByTagName("input");
            $('#progressModelEx').modal({ backdrop: 'static', keyboard: false });
            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox" && Users[i].checked && Users[i].name && Users[i].name.indexOf("|") != -1) {
                    
                    gTaskQueue.push(Users[i].name);

                }
            }

            if (gTaskQueue.length == 0) {
                $('#progressModelEx').modal('hide');
                return;
            }

            ProcessQueue();
        } function gEncodeUri(str) {

            var s = encodeURI(str).replace(/&/g, '%26').replace(/#/g, '|').replace('+', ':').replace(/'/g, '%27');
            while (true) {
                var i = s.indexOf('+');
                if (i == -1)
                    break;
                s = s.replace('+', ':');
            }

            return s;

        }
        function GetFilterValue(){
            var obj = document.getElementById("<%=txtScanFilter.ClientID %>");
            if(obj){
               if(obj.value.trim() != ""){
                   return "&flt=" + encodeURIComponent(obj.value.trim());
               }
            }
            return "";
        }
        function PopulateScanFilterField(str){
            var obj = document.getElementById("<%=txtScanFilter.ClientID %>");
            if(obj){
               obj.value = str;
            }
        }
        function ProcessQueue() {
            var t = gTaskQueue.shift();

            if (t == null || t === undefined) {
                $('#progressModelEx').modal('hide');
                
                return;
            }

            var e = document.getElementById("SyncTaskTd");
            var parts = t.split("|");
            var op;
            var desc = "Sync Down";
            

            if (parts[0] == "cloudonly" || parts[0] == "cloudnewer") {
                op = "down";
            } else {
                op = "up";
                desc = "Sync Up";
            }

            e.innerHTML = "<span style='color:#008000'>"+ desc+ "</span><br/> " + parts[1];

            Ext.Ajax.request({
                url: '/management/DeviceSyncScan.aspx?id=<%=HiddenInstanceId.Value %>&name=<%=HiddenDeviceName.Value%>&op=' + op + "&f=" + parts[2] + "&r=" + gEncodeUri(parts[1]) + GetFilterValue(),
                success: function (response) {
                    var m = response.responseText;
                    var ee = document.getElementsByName(t);

                    if (stringStartsWith(m, "bad^")) {
                        ee[0].style.backgroundColor = "red";
                    } else {
                        ee[0].checked = false;
                    }
                    ProcessQueue();
                },
                failure: function () {                   
                    try{
                        var ee = document.getElementsByName(t);
                        ee[0].style.backgroundColor = "red";
                        ProcessQueue();
                    }catch(aee){

                    }

                },
                method: 'GET'
            });
        }
        function ReturnButtonAction(){
            if(parent.SetPage){  
                var isAttachedFoldersPage = false;
                try{
                    isAttachedFoldersPage = (parent.document.getElementById("page_4").className.indexOf("_active")>-1);
                }catch(ex){}
                if(isAttachedFoldersPage){ 
                    parent.SetPage(4);
                }else{ 
                    parent.SetPage(2);
                }
            }else{
                //probably server agent, so there is no parent frame   
                var ref = "<%=PageReturnUrl %>";  
                if(ref=="") {
                    ref = document.referrer;
                }
                location.href = ref;
            }
            return false;
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Localize runat="server" ID="LocFaiToDet" meta:resourcekey="str_faiToDet" Visible="false">Failed to detach</asp:Localize>
    <div style="width: 100%; min-height:48px; padding: 5px; <% if (NoReturn){ %>border-bottom: 1px solid #eeeeee; <% } %>" <% if (!NoReturn)
        { %>class="meubardrop" <% } %>>
        <table style="width: 100%">
            <tr>
                <td align="left" >     
                    <% if (!NoReturn)
                    { %>
                    <button id="btnReturn" type="button" class="btn btn-default " title="<%= STRDevList.Text %>" onclick="ReturnButtonAction();">
                        <span class="glyphicon glyphicon-menu-left"></span>
                        <asp:Localize meta:resourcekey="str_devlist" ID="STRDevList" runat="server"
                            Text="Return"></asp:Localize>
                    </button>
                    <% } %>
                </td>
                <td align="center" style="min-height:48px;" >
                    <div id="scanFilterRow">
                       <p>Show only items containing:</p> 
                        <asp:TextBox id="txtScanFilter" cssclass="form-control" autocomplete="off" placeholder="file/folder name here" runat="server" />
                        
                        <asp:LinkButton ID="RefreshBtn" ForeColor="#404040" runat="server"
                            OnClick="LinkButton2_Click">
                            <asp:Localize runat="server" meta:resourcekey="str_scn">SCAN</asp:Localize>
                            <asp:Label ID="DeviceName" runat="server" Visible="False" Text="Label" meta:resourcekey="DeviceNameResource1"></asp:Label>
                        </asp:LinkButton>
                    </div>
                    
                    <asp:Label ID="UserCount" runat="server" meta:resourcekey="UserCountResource1"></asp:Label>
                    <asp:Label ID="GuestQuota" runat="server" Visible="False" Text="0 available guest user quota"
                        meta:resourcekey="GuestQuotaResource1"></asp:Label>
                </td>
                <td  style="display:none;">
                    <div id="errmsgdiv" >
                        <b>
                            <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                    </div>
                </td>
                <td align="right"  >
                    <% if (NotScaning)
                    { %>
                    <div class="btn btn-primary gladbtn " style="margin-right: 8px;" onclick="RefreshList();">
                        <span class="glyphicon glyphicon-refresh" aria-hidden="true"></span>

                    </div>
                    <% } %>
                    <% if (ScanDoneWithResult)
                        { %>
                    <a href="javascript:;" onclick="OnIconView();return false;" style="color: white; display: none;" id="iconviewbtn">
                        <button type="button" class="btn " style="padding: 2px; margin-left: 5px;">
                            <img src="/webui/image-gray/viewicon-32.png" />

                        </button>
                    </a>

                    <a href="javascript:;" onclick="OnListView();return false;" style="color: white;" id="listviewbtn">
                        <button type="button" class="btn " style="padding: 2px; margin-left: 5px;">
                            <img src="/webui/image-gray/viewlist-32.png" />

                        </button>
                    </a>
                    <% } %>
                    <div class="btn btn-primary gladbtn" data-toggle="modal" data-target="#SettingModel" style="padding-left: 3px; padding-right: 3px;">
                        <span class="glyphicon glyphicon-cog" style="font-size: 14px;"></span>
                    </div>
                </td>
            </tr>
        </table>

        
    </div>
    <table id="grid-table" width="95%" align="center" style="background-color: transparent; margin-top: -10px;"
        cellspacing="0" cellpadding="0">
        <% if (ScanDone)
            { %>
        <tr style="display: none;">
            <td style="padding-left: 10px;">
                <table>
                    <tr>
                        <td><span class="glyphicon glyphicon-hdd" style="color: #565656">
                            <asp:Localize runat="server" meta:resourcekey="str_NbsOnlExiInLocOrLocVerIsNew">&nbsp;(File only exists in local or local version is newer)</asp:Localize></span></td>
                        <td style="padding-left: 10px;">
                            <span class="glyphicon glyphicon-cloud" style="color: #565656">
                                <asp:Localize runat="server" meta:resourcekey="str_NbsOnlExiInCloOrCloVerIsNew">&nbsp;(File only exists in cloud or cloud version is newer)</asp:Localize></span>
                        </td>
                    </tr>
                </table>
            </td>



        </tr>
        <% } %>
        <tr>
            <td id="grid-example" valign="top" style="background-color: transparent; padding: 10px; padding-top: 30px;">
                <% if (ScanUnknown)
                    { %>
                <p style="font-size: 16px; color: #565656; font-weight: 100;">
                    <asp:Localize runat="server" meta:resourcekey="str_strScnMsg1">Click</asp:Localize>
                    <a href="javascript:;" onclick="RefreshList();return false;">
                        <asp:Localize runat="server" meta:resourcekey="str_strScnMsg2">here</asp:Localize></a>
                    <asp:Localize runat="server" meta:resourcekey="str_strScnMsg3">to start scanning for out of sync items, it may take a while depends on the size of the data and your network bandwidth.</asp:Localize>
                </p>
                <% }
                else if (ScanRunning)
                { %>
                <table align="center">
                    <tr>
                        <td style="padding-right: 20px;"></td>
                        <td>


                            <table class="table-striped" align="center">
                                <tr>
                                    <td style="padding: 5px; font-size: 18px; color: #404040; font-weight: 100;">
                                        <asp:Localize runat="server" meta:resourcekey="str_scnStrTme">Scan Start Time</asp:Localize></td>
                                    <td style="min-width: 350px; padding: 5px; font-size: 18px; color: #008000; font-weight: 100;" align="right"><span id="ScanTime"></span></td>
                                </tr>
                                <tr>
                                    <td style="padding: 5px; font-size: 18px; color: #404040; font-weight: 100;">
                                        <asp:Localize runat="server" meta:resourcekey="str_elaTme">Elapsed Time</asp:Localize></td>
                                    <td style="min-width: 350px; padding: 5px; font-size: 18px; color: #008000; font-weight: 100;" align="right"><span id="ElapsedTime"></span>
                                        <img width="32x" src="/webui/images/loading-home2.svg" /></td>
                                </tr>
                                <tr>
                                    <td style="padding: 5px; font-size: 18px; color: #404040; font-weight: 100;">
                                        <asp:Localize runat="server" meta:resourcekey="str_filScn" ID="str_filScn">Files Scanned</asp:Localize></td>
                                    <td id="FileCount" style="padding: 5px; font-size: 18px; color: #008000; font-weight: 100;" align="right">0</td>
                                </tr>
                                <tr>
                                    <td style="padding: 5px; font-size: 18px; color: #404040; font-weight: 100;">
                                        <asp:Localize runat="server" meta:resourcekey="str_fldScn" ID="str_fldScn">Folders Scanned</asp:Localize></td>
                                    <td id="FolderCount" style="padding: 5px; font-size: 18px; color: #008000; font-weight: 100;" align="right">0</td>
                                </tr>
                                <tr>
                                    <td style="padding: 5px; font-size: 18px; color: #404040; font-weight: 100;">
                                        <asp:Localize runat="server" meta:resourcekey="str_outSncDtd">Out of Sync Items Detected</asp:Localize></td>
                                    <td style="padding: 5px; font-size: 18px; color: #800000; font-weight: 100;" align="right" id="OutSyncCount">0</td>
                                </tr>
                                <tr>
                                    <td style="padding: 5px; font-size: 18px; color: #404040; font-weight: 100;">
                                        <asp:Localize runat="server" meta:resourcekey="str_curSts">Current Status</asp:Localize></td>
                                    <td style="padding: 5px; font-size: 18px; color: #008000; font-weight: 100;" align="right" id="ScanStatus"></td>
                                </tr>

                            </table>
                        </td>
                    </tr>
                </table>
                <% }
                    else if (string.IsNullOrEmpty(mTreeContent))
                    {%>
                <span style="font-size: 18px; color: #404040; font-weight: 100;">
                    <asp:Localize runat="server" meta:resourcekey="str_allFilSnc">All files are synced.</asp:Localize></span>
                <%} %>
            </td>
        </tr>
        <tr>
            <td id="lisview" valign="top" style="background-color: transparent; padding: 10px; padding-top: 30px; display: none; font-size: 16px; color: #404040; font-weight: 100;">

                <table>
                    <tr>
                        <td>
                            <a href="javascript:;" onclick="SelectAll();return false;" style="padding-left: 10px; padding-right: 10px; color: #008000">
                                <asp:Localize ID="Localize1" meta:resourcekey="asp_string4" runat="server"
                                    Text="Select All"></asp:Localize></a>
                        </td>
                        <td>
                            <a href="javascript:;" onclick="DeSelectAll();return false;" style="padding-right: 10px; color: #008000">
                                <asp:Localize ID="Localize2" meta:resourcekey="asp_string5" runat="server"
                                    Text="Deselect All"></asp:Localize></a>
                        </td>     

                        <td>                                                
                            <a href="javascript:;" onclick="SelectAllUploadTasks();return false;" style="padding-right: 10px; color: #008000">
                                <asp:Localize meta:resourcekey="str_selAllUplTas" runat="server">Select All Upload Tasks</asp:Localize>
                            </a>
                        </td> 
                        <td>
                            <a href="javascript:;" onclick="SelectAllDownloadTasks();return false;" style="padding-right: 10px; color: #008000">
                                <asp:Localize meta:resourcekey="str_selAllDowTas" runat="server">Select All Download Tasks</asp:Localize>
                            </a>
                        </td>

                        <td>
                            <a href="javascript:;" onclick="ReSelectAll();return false;" style="padding-right: 10px; color: #008000">
                                <asp:Localize ID="Localize3" meta:resourcekey="asp_string6" runat="server"
                                    Text="Reverse Selection"></asp:Localize></a>
                        </td>  

                        <td>
                            <a href="javascript:;" onclick="SyncAll();return false;" style="padding-right: 10px; color: #008000">
                                <asp:Localize meta:resourcekey="str_sncAllSltItm" runat="server">Sync All Selected Items</asp:Localize>
                            </a>
                        </td>

                    </tr>
                    <tr>
                        <td height="5px">&nbsp;</td>
                    </tr>
                </table>
                <% if (ScanDoneWithResult)
                    { %>
                <table width="100%">
                    <tr style="border-bottom: 1px solid #f0f0f0;">
                        <td></td>
                        <td></td>
                        <td style="font-size: 16px; color: #404040; font-weight: 100; padding: 3px">
                            <asp:Localize meta:resourcekey="str_filNme" runat="server">File Name</asp:Localize></td>
                        <td style="font-size: 16px; color: #404040; font-weight: 100; padding: 3px">
                            <asp:Localize meta:resourcekey="str_cldSze" runat="server">Cloud Size</asp:Localize></td>
                        <td style="font-size: 16px; color: #404040; font-weight: 100; padding: 3px">
                            <asp:Localize meta:resourcekey="str_cldMdfTme" runat="server">Cloud Modify Time</asp:Localize></td>
                        <td style="font-size: 16px; color: #404040; font-weight: 100; padding: 3px">
                            <asp:Localize meta:resourcekey="str_locSze" runat="server">Local Size</asp:Localize></td>
                        <td style="font-size: 16px; color: #404040; font-weight: 100; padding: 3px">
                            <asp:Localize meta:resourcekey="str_locMdfTme" runat="server">Local Modify Time</asp:Localize></td>
                    </tr>
                    <asp:Repeater ID="UsersRepeater" runat="server" EnableViewState="false">
                        <ItemTemplate>
                            <tr onmouseover="this.style.borderBottom='1px solid #008000';this.style.borderTop='1px solid #008000';" onmouseout="this.style.borderBottom='0px solid #008000';this.style.borderTop='0px solid #008000';">
                                <td>
                                    <input type="checkbox" class="taskStatus_<%#DataBinder.Eval(Container.DataItem, "Status").ToString()%>" name="<%#DataBinder.Eval(Container.DataItem, "Status").ToString()%>|<%#DataBinder.Eval(Container.DataItem, "Name").ToString()%>|<%#DataBinder.Eval(Container.DataItem, "IsFolder").ToString()%>" checked /></td>
                                <td style="font-size: 14px; color: #404040; font-weight: 100; padding: 3px"><span class="gladinet-icons gladbtn" style="font-size:26px !important; color: #404040; font-weight: 100; padding: 3px"><%#DataBinder.Eval(Container.DataItem, "SyncStatusIcon").ToString()%></span></td>
                                <td style="font-size: 14px; color: #404040; font-weight: 100; padding: 3px"><%#DataBinder.Eval(Container.DataItem, "Name").ToString()%>  </td>
                                <td style="font-size: 14px; color: #404040; font-weight: 100; padding: 3px"><%#DataBinder.Eval(Container.DataItem, "CloudSize").ToString()%> </td>
                                <td style="font-size: 14px; color: #404040; font-weight: 100; padding: 3px"><%#DataBinder.Eval(Container.DataItem, "CloudModifyTime").ToString()%> </td>
                                <td style="font-size: 14px; color: #404040; font-weight: 100; padding: 3px"><%#DataBinder.Eval(Container.DataItem, "LocalSize").ToString()%> </td>
                                <td style="font-size: 14px; color: #404040; font-weight: 100; padding: 3px"><%#DataBinder.Eval(Container.DataItem, "LocalModifyTime").ToString()%> </td>

                            </tr>
                        </ItemTemplate>
                    </asp:Repeater>

                </table>
                <% } %>
            </td>
        </tr>
        <tr>
            <td>
                <div id="detailModel" class="modal fade" role="dialog">
                    <div class="modal-dialog modal-vertical-centered " style="width: 600px;">

                        <!-- Modal content-->
                        <div class="modal-content">
                            <div class="modal-header" style="display: none;">

                                <h4 class="modal-title" style="color: #808080" id="WaitTitle"></h4>
                            </div>
                            <div class="modal-body" style="height: 260px;">

                                <table width="100%">

                                    <tr style="border-top: 0px solid #c0c0c0;">
                                        <td align="center" valign="top" style="font-size: 16px; font-weight: 100; color: #565656; padding-top: 0px;">
                                            <table width="100%">
                                                <tr style="border-bottom: 1px solid #f0f0f0; font-size: 16px; font-weight: 100; color: #404040;">
                                                    <td width="150px" style="padding: 5px; font-size: 16px; font-weight: 100; color: #404040;"></td>
                                                    <td width="150px" align="right" style="padding: 5px; font-size: 16px; font-weight: 100; color: #404040;">
                                                        <asp:Localize runat="server" meta:resourcekey="str_sze">Size</asp:Localize></td>
                                                    <td style="padding: 5px; font-size: 16px; font-weight: 100; color: #404040;" align="right">
                                                        <asp:Localize runat="server" meta:resourcekey="str_lstMdfTme">Last Modify Time</asp:Localize></td>
                                                </tr>

                                                <tr>
                                                    <td height="10px">&nbsp;</td>
                                                </tr>
                                                <tr style="border-bottom: 1px solid #f8f8f8; padding-top: 15px;">
                                                    <td style="padding: 5px; font-size: 16px; font-weight: 100; color: #404040;">
                                                        <asp:Localize meta:resourcekey="str_cldVrs" runat="server">Cloud Version</asp:Localize></td>
                                                    <td id="cloudsize" style="padding: 5px;" align="right"></td>
                                                    <td id="cloudtime" style="padding: 5px;" align="right"></td>
                                                </tr>
                                                <tr>
                                                    <td height="10px">&nbsp;</td>
                                                </tr>
                                                <tr style="border-bottom: 1px solid #f8f8f8; padding-top: 15px;">
                                                    <td style="padding: 5px; font-size: 16px; font-weight: 100; color: #404040;">
                                                        <asp:Localize meta:resourcekey="str_lclVrs" runat="server">Local Version</asp:Localize></td>
                                                    <td id="localsize" style="padding: 5px;" align="right"></td>
                                                    <td id="localtime" style="padding: 5px;" align="right"></td>
                                                </tr>

                                            </table>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                            <div class="modal-footer" style="border-top: 1px solid #e0e0e0; padding: 5px;">
                                <button type="button" class="btn btn-success" id="syncdownbtn" onclick="syncop('down');"><span class="glyphicon glyphicon-arrow-down"></span>&nbsp;Sync Down</button>
                                <button type="button" class="btn btn-success" id="syncuptn" onclick="syncop('up');"><span class="glyphicon glyphicon-arrow-up"></span>&nbsp;Sync Up</button>
                                <button type="button" class="btn btn-default" data-dismiss="modal">
                                    <asp:Localize meta:resourcekey="str_cls" runat="server">Close</asp:Localize></button>
                            </div>
                        </div>

                    </div>
                </div>
                <div id="progressModelEx" class="modal fade" role="dialog">
                    <div class="modal-dialog modal-vertical-centered " style="width: 600px;">

                        <!-- Modal content-->
                        <div class="modal-content">
                            <div class="modal-header" style="display: none;">

                                <h4 class="modal-title" style="color: #808080" id="WaitTitle"></h4>
                            </div>
                            <div class="modal-body" style="height: 260px;">

                                <table width="100%">
                                    <tr>
                                        <td height="60px">&nbsp;</td>
                                    </tr>
                                    <tr style="border-top: 0px solid #c0c0c0;">
                                        <td align="center" valign="top" style="font-size: 16px; font-weight: 100; color: #565656; padding-top: 0px;" id="SyncTaskTd"></td>
                                    </tr>
                                </table>
                            </div>
                            <div class="modal-footer" style="border-top: 1px solid #e0e0e0; padding: 5px; display: none;">
                                <button type="button" class="btn btn-default" data-dismiss="modal">
                                    <asp:Localize meta:resourcekey="str_cls" runat="server">Close</asp:Localize></button>
                            </div>
                        </div>

                    </div>
                </div>
                <div id="SettingModel" class="modal fade" role="dialog">
                    <div class="modal-dialog">

                        <!-- Modal content-->
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="modal-title">
                                    <asp:Localize meta:resourcekey="str_scnStg" runat="server">Scan Settings</asp:Localize></h4>
                                <button type="button" class="close" data-dismiss="modal">&times;</button>

                            </div>
                            <div class="modal-body">
                                <asp:CheckBox ID="MissingOnly" runat="server" Text="Only scan for missing files" meta:resourcekey="str_onlScnMisFil" Checked="True" />
                                <asp:CheckBox ID="StrictCheck" runat="server" Text="Check timestamp strictly" meta:resourcekey="str_chkTimStp" />
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">
                                    <asp:Localize meta:resourcekey="str_cls" runat="server">Close</asp:Localize></button>
                            </div>
                        </div>

                    </div>
                </div>
            </td>
        </tr>
    </table>
    <asp:HiddenField ID="DeviceId" runat="server" />
    <div style="display: none;">
        <asp:Button ID="WipeDevice" runat="server" OnClick="WipeDevice_Click" meta:resourcekey="WipeDeviceResource1" />
    </div>

    <asp:HiddenField ID="HiddenInstanceId" runat="server" />
    <asp:HiddenField ID="HiddenDeviceName" runat="server" />
    <asp:HiddenField ID="backtotarget" runat="server" />
    <asp:HiddenField ID="RelPath" runat="server" />


    <script type="text/javascript">
        var res;
        function ShowDetail(arg) {
            var t = document.getElementById("WaitTitle");
            var cs = document.getElementById("cloudsize");
            var ct = document.getElementById("cloudtime");
            var ls = document.getElementById("localsize");
            var lt = document.getElementById("localtime");

            res = arg.split('|');
            

            t.innerHTML = res[0];
            cs.innerHTML = res[3];
            ct.innerHTML = res[4];
            ls.innerHTML = res[5];
            lt.innerHTML = res[6];

            var ng = document.getElementById("ctl00_MainContent_RelPath");
            ng.Value = res[0];

            var db = document.getElementById("syncdownbtn");
            var ub = document.getElementById("syncuptn");

            db.style.display = "";
            ub.style.display = "";

            if (res[1] == "cloudonly")
                ub.style.display = "none";
            if (res[1] == "localonly")
                db.style.display = "none";

            $('#detailModel').modal({ backdrop: 'static', keyboard: false });
        }

        function stringStartsWith(s,p) {
            return (s.indexOf(p) == 0);
        }

        function OnSyncRes(m) {
            var e = document.getElementById("pollres");
            if (stringStartsWith(m,"bad^")) {
                alert("failed:" + m.substring(4));

            } else {

               
            }
            
        }
        function syncop(op) {
            
            $('#detailModel').modal('hide');
            Wait('please wait');
            Ext.Ajax.request({
                url: '/management/DeviceSyncScan.aspx?id=<%=HiddenInstanceId.Value %>&name=<%=HiddenDeviceName.Value%>&op=' + op + "&f=" + res[2] + "&r=" + gEncodeUri(res[0]) + GetFilterValue(),
                success: function (response) {
                    closeWait();
                    OnSyncRes(response.responseText);
                },
                failure: function () {
                    closeWait();
                    alert("failed to send command");
                },
                method: 'GET'
            });
        
            
        }

        function OnPollRes(m) {
            
            if (stringStartsWith(m, "bad^")) {
                <% if (NoReturn)
        { %>
                window.location = '/management/DeviceSyncScan.aspx?nr=1&id=<%= HiddenInstanceId.Value %>&name=<%= HiddenDeviceName.Value %>'+ GetFilterValue();
                <% }
        else
        { %>
                window.location = '/management/DeviceSyncScan.aspx?id=<%= HiddenInstanceId.Value %>&name=<%= HiddenDeviceName.Value %>' + GetFilterValue();
                <%}%>
                return;
            } else {
                var parts = m.split(';');
                
                if (parts[0] != "scanning") {
                    var r = document.getElementById("ScanStatus");

                 <% if (NoReturn)
        { %>
                    window.location = '/management/DeviceSyncScan.aspx?nr=1&id=<%= HiddenInstanceId.Value %>&name=<%= HiddenDeviceName.Value %>' + GetFilterValue();
                <% }
        else
        { %>
                    window.location = '/management/DeviceSyncScan.aspx?id=<%= HiddenInstanceId.Value %>&name=<%= HiddenDeviceName.Value %>' + GetFilterValue();
                <%}%>
                    return;                    
                } else {

                    try {                                            
                        var e = document.getElementById("ScanTime");
                        var p = document.getElementById("FileCount");
                        var f = document.getElementById("FolderCount");
                        var o = document.getElementById("OutSyncCount");
                        var r = document.getElementById("ScanStatus");  
                        var t = document.getElementById("ElapsedTime");
                          
                        t.innerHTML = parts[1];
                        p.innerHTML = parts[2];
                        f.innerHTML = parts[3];
                        o.innerHTML = parts[4];
                        r.innerHTML = GetShortString(parts[5],32);
                        e.innerHTML = parts[6];
                    } catch (e) {

                    }
                }
            }
            setTimeout("Poll()", 1000);
        }


        function Poll() {
            Ext.Ajax.request({
                url: '/management/DeviceSyncScan.aspx?id=<%=HiddenInstanceId.Value %>&name=<%=HiddenDeviceName.Value%>&op=poll' + GetFilterValue(),
                success: function (response) {
                    OnPollRes(response.responseText);
                },
                failure: function () {
                
                    OnPollRes('bad^unknown');
                },
                method: 'GET'
            });
        
            
        }

        var grid;
      
        function AdjustGridTable () {
           
            var h = 400;
          
            try {

           
                h = document.body.offsetHeight-120;
                if (grid) {
                    grid.setWidth(document.documentElement.clientWidth - 20);
                    grid.setHeight(h-20);
                    grid.doComponentLayout();
                }
                var e = document.getElementById("grid-example");
                e.style.height = (h-40) + "px";
                e = document.getElementById("lisview");
                e.style.height = (h-40) + "px";
              
            } catch (err) {
            }


        }

        Ext.require([
            'Ext.grid.*',
            'Ext.data.*',
            'Ext.util.*',
            'Ext.state.*'
        ]);
        Ext.onReady(function () {

            Ext.QuickTips.init();

          <% if (ScanRunning)
        { %>
          setTimeout("Poll()", 500);
          <% }%>

          <%   if (ScanDoneWithResult)
        { %>
          var store = Ext.create('Ext.data.TreeStore', {
              root: {
                  text: "<%= DeviceName.Text %>",
                  expanded: true,
                  children: [
                      <%= mTreeContent %>
                  ]
              }
          });

          grid= Ext.create('Ext.tree.Panel', {
              width: '100%',
              store: store,
              border: false,
              bodyStyle: {border:0},
              rootVisible:true,
              useArrows: true,
              renderTo: "grid-example"
          });
          <% }%>
          AdjustGridTable ();
             
          Ext.EventManager.onWindowResize(AdjustGridTable);   

         <asp:Literal ID="ltlScripts" runat="server" />
          
      });
    </script>
    <asp:Localize meta:resourcekey="str_daysgao" ID="StrDaysAgo" runat="server"
        Visible="False" Text=" Days ago"></asp:Localize>
    <asp:Localize meta:resourcekey="str_hoursago" ID="StrHoursAgo" runat="server"
        Visible="False" Text=" Hours ago"></asp:Localize>
    <asp:Localize meta:resourcekey="str_minsago" ID="StrMinsAgo" runat="server"
        Visible="False" Text=" Minutes ago"></asp:Localize>
    <asp:Localize meta:resourcekey="str_lessmin" ID="StrLessMin" runat="server"
        Visible="False" Text="Less than 1 minute ago"></asp:Localize>
</asp:Content>
