﻿<%@ Page Title="Gladinet Cloud - User Manager" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="DeviceSubTasks.aspx.cs" Inherits="GladinetPayFlow.DeviceSubTasks"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        .smallbtn {
            padding-left: 3px !important;
            padding-right: 3px !important;
        }
    </style>
    <script type="text/javascript">
        function getScrollXY() {
            var scrOfX = 0, scrOfY = 0;
            if (typeof (window.pageYOffset) == 'number') {
                //Netscape compliant
                scrOfY = window.pageYOffset;
                scrOfX = window.pageXOffset;
            } else if (document.body && (document.body.scrollLeft || document.body.scrollTop)) {
                //DOM compliant
                scrOfY = document.body.scrollTop;
                scrOfX = document.body.scrollLeft;
            } else if (document.documentElement && (document.documentElement.scrollLeft || document.documentElement.scrollTop)) {
                //IE6 standards compliant mode
                scrOfY = document.documentElement.scrollTop;
                scrOfX = document.documentElement.scrollLeft;
            }
            //return [scrOfX, scrOfY];
            return scrOfY;
        }




        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //parent.setActivePanel("UserMgr");

        function onDelUser(id, name) {
            var h = "/management/GuestUserMgrPage.aspx?op=delete&id=" + id;

            if (confirm("Do you really want to delete (" + unescape(name) + ")?")) {
                Wait('Deleting');
                window.location = h;
            }

        }
        function SelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].name.indexOf("uu_") == -1)
                    continue;
                if (Users[i].style.display == 'none') {
                    continue;
                }
                if (Users[i].type == "checkbox") {
                    Users[i].checked = true;
                }
            }
        }

        function DeSelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].name.indexOf("uu_") == -1)
                    continue;
                if (Users[i].style.display == 'none')
                    continue;

                if (Users[i].type == "checkbox") {
                    Users[i].checked = false;
                }
            }
        }

        function ReSelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox") {
                    if (Users[i].name.indexOf("uu_") == -1)
                        continue;
                    if (Users[i].style.display == 'none')
                        continue;
                    Users[i].checked = !Users[i].checked;
                }
            }
        }

        function DelSubTask(sindex) {
            
        }
        function OpenHtmlWindowShort(id, title, Html, w, h) {

            activewin = new Ext.Window({
                id: id,
                title: title,
                width: w,
                height: maxh(h),
                plain: true,
                modal: true,
                constrain: true,
                maximizable: false,
                maximized: false,
                bodyPadding: 5,
                resizable: false,
                shadow: 'drop',
                iconCls: 'publish',
                bodyStyle: 'background:#dfe8f6;border:0px; ',
                shadowOffset: 10,
                html: Html,
                defaults: {
                    border: false
                }
            });
            activewin.show();

        }


        function closeCancelActiveWin() {
            activewin.close();
        }

        function closeActiveWin() {
            window.location = "/management/AttachedFolders.aspx";
        }

        function OnWipeDevice(id, name) {
            var ng = document.getElementById("ctl00_MainContent_DeviceId");
            var btn = document.getElementById("ctl00_MainContent_WipeDevice");

            if (confirm("<asp:Localize meta:resourcekey="js_string11" runat="server">Confirm detaching the folder (</asp:Localize>" + unescape(id) + ")?")) {

                Wait("<asp:Localize meta:resourcekey="js_string12" runat="server">Detaching...</asp:Localize>");
                ng.value = id;
                btn.click();
            }
        }

        function OnAttachFolder() {
            window.location = "/management/AddAttachedFolder.aspx?id=<%=HiddenInstanceId.Value%>&name=<%=HiddenDeviceName.Value %>";
        }
        function OnDeviceList() {
            window.location = "<%=PageReturnUrl %>";
        }

        function DelSubTask(ind) {
            var ng = document.getElementById("ctl00_MainContent_HiddenSubId");
            var btn = document.getElementById("ctl00_MainContent_DeleteSubTask");
            gConfirm("Confirm delete the sub task?", "", function(btn1) {

                if (btn1 != 'ok')
                    return;
                Wait("Deleting");
                ng.value = ind;
                btn.click();
            });
        }

        function DelSelectedSubTask() {
            var ng = document.getElementById("ctl00_MainContent_HiddenSubId");
            var btn = document.getElementById("ctl00_MainContent_DeleteSelSubTask");
            var str = "";

            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox") {
                    if (Users[i].name.indexOf("uu_") == -1)
                        continue;
                    if (Users[i].style.display == 'none')
                        continue;
                    if (Users[i].checked)
                        str += Users[i].name + ";";
                }
            }

            if (str == "") {
                alert("no selected task");
                return;
            }

            gConfirm("Confirm delete the selected sub task?", "", function (btn1) {

                if (btn1 != 'ok')
                    return;
                Wait("Deleting");
                ng.value = str;
                btn.click();
            });
        }
        function GetSubTaskTrace(ind) {
            Wait("Loading");
            window.location = "/management/DeviceTaskTrace.aspx?id=<%=HiddenInstanceId.Value%>&tid=<%=HiddenTaskId.Value%>&p=" + ind;


        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    
<asp:Localize ID="LocFai" meta:resourcekey="str_fai" runat="server" Visible="False">Failed:</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToLoa" meta:resourcekey="str_faiToLoa" Visible="false">Failed to load</asp:Localize>
    <nav class="navbar navbar-default" role="navigation">
               <div class="container-fluid">
                   
                   <button type="button" class="btn btn-default navbar-btn navbar-left " title="<%=STRDevList.Text %>" onclick="OnDeviceList()" style="display: none;"> 
                <span class="fa fa-menu-left"></span>  
                       <asp:Localize meta:resourcekey="str_devlist" ID="STRDevList" runat="server" 
                           Text="Return"></asp:Localize>
             </button>

                   <p class="navbar-text dark">
                        <asp:Label ID="UserCount" runat="server" meta:resourcekey="UserCountResource1"></asp:Label>
                            <asp:Label ID="GuestQuota" runat="server" Visible="False" Text="0 available guest user quota"
                                meta:resourcekey="GuestQuotaResource1"></asp:Label>
                   </p>
                   <div id="errmsgdiv" class="navbar-text">
                       <b>
                          <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                   </div>
                   
                      <% if (HiddenTaskType.Value == "2"){ %>
                    <asp:LinkButton ID="PurgeFailed"  runat="server" CssClass="btn btn-primary gladbtn navbar-btn navbar-right dark smallbtn" 
                           OnClick="PurgeFailed_Click"  OnClientClick="Wait('one minute'); return true;"><span class="fa fa-trash" aria-hidden="true" title="<%=str_purgefailed.Text %>"></span> </asp:LinkButton>
                   <% } %>
                   
                   
                       
                       <asp:LinkButton ID="RefreshBtn"  runat="server" CssClass="btn btn-primary gladbtn navbar-btn navbar-right dark smallbtn" 
                           OnClick="LinkButton2_Click"  OnClientClick="Wait('one minute'); return true;"><span class="fa fa-refresh" aria-hidden="true" title="<%=str_ref.Text %>"></span> </asp:LinkButton>
                       <asp:Label ID="DeviceName" Visible="False" runat="server" Text="Label" meta:resourcekey="DeviceNameResource1"></asp:Label>
                   <asp:Localize meta:resourcekey="str_ref" runat="server" id="str_ref" Visible="False">Refresh</asp:Localize>
                   <asp:Localize meta:resourcekey="str_purgefailed" ID="str_purgefailed" runat="server">Purge Failed Tasks</asp:Localize>
                   
               </div>
           </nav>
    <table id="grid-table" width="95%" align="center" style="background-color: transparent;
        margin-top: -18px;" cellspacing="0" cellpadding="0">
        <tr>
            <td id="grid-example" valign="top" style="background-color: transparent; padding: 10px; padding-top: 30px;">
                <table width="100%" class="table-striped">
                    <tr style="background-color: white; padding-bottom: 10px;">
                        <td colspan="5" style="padding-bottom: 20px;">
                            <table >
                                                    <tr>
                                                        <td>
                                                            <a href="javascript:;" onclick="SelectAll();return false;" style="padding-left: 10px; padding-right: 10px;
                                                                color: #008000">
                                                                <asp:Localize ID="Localize2" meta:resourcekey="str_selall" runat="server">Select All</asp:Localize>
                                                            </a>
                                                        </td>
                                                        <td>
                                                            <a href="javascript:;" onclick="DeSelectAll();return false;" style="padding-right: 10px; color: #008000">
                                                                <asp:Localize ID="Localize3" meta:resourcekey="str_desel" runat="server">Deselect All</asp:Localize>
                                                            </a>
                                                        </td>
                                                        <td>
                                                            <a href="javascript:;" onclick="ReSelectAll();return false;" style="padding-right: 10px; color: #008000">
                                                                <asp:Localize ID="Localize4" meta:resourcekey="str_undosel" runat="server">Reverse Selection</asp:Localize>
                                                            </a>
                                                        </td>
                                                        <td>
                                                            <a href="javascript:;" onclick="DelSelectedSubTask();return false;" style="padding-right: 10px; color: #008000"><asp:Localize meta:resourcekey="str_delSelTas" runat="server">Delete Selected Tasks</asp:Localize></a>
                                                        </td>
                                                    </tr>
                                                </table>
                        </td>
                    </tr>
                    <tr>
                        <td width="32px"></td>
                        <td width="160px" style="font-size: 16px; font-weight: 100;" nowrap="nowrap"><asp:Localize runat="server" meta:resourcekey="str_tskNme">Task Name</asp:Localize></td>
                        <td style="font-size: 16px; font-weight: 100;"><asp:Localize runat="server" meta:resourcekey="str_prm1">Parameter1</asp:Localize></td>
                        <% if (HiddenTaskType.Value == "2"){ %>
                        <td width="120px" style="font-size: 16px; font-weight: 100;"><asp:Localize runat="server" meta:resourcekey="str_lstErr">Last Error</asp:Localize></td>
                        <% } %>
                        <td width="40px;"></td>
                    </tr>
                    <asp:Repeater ID="UsersRepeater" runat="server" OnItemCommand="UsersRepeater_ItemCommand"
                        OnItemDataBound="OnUserItemBound">
                        <ItemTemplate>
                            <tr style="padding: 5px; border-bottom: 0px solid #f0f0f0; padding-top: 10px;" onmouseover="this.style.borderBottom='2px solid #008000';"
                                onmouseout="this.style.borderBottom='0px solid #00ff00';">
                                <td style="padding: 5px; ">
                                    <input type="checkbox" name="uu_<%#DataBinder.Eval(Container.DataItem,"TaskId") %>"/>
                                </td>
                                <td style="padding: 5px; ">
                                    <span  class="btn-success btnsmall"><%#DataBinder.Eval(Container.DataItem,"TaskName") %></span>
                                </td>
                                <td style="font-size: 12px; font-weight: 100;">
                                    <%#DataBinder.Eval(Container.DataItem,"TaskPara1") %>
                                </td>
                               <% if (HiddenTaskType.Value == "2"){ %>
                                <td style="font-size: 12px; font-weight: 100; color: #800000;" nowrap="nowrap"><%#DataBinder.Eval(Container.DataItem,"LastError") %></td>
                                <% } %>

                                <td>
                                    <span class="fa fa-remove" style="color: #404040; font-size: 18px; cursor: pointer; " onclick="DelSubTask('<%#DataBinder.Eval(Container.DataItem,"TaskId") %>');"></span>
                                    <span class="fa fa-zoom-in" style="color: #404040; font-size: 18px; cursor: pointer; " onclick="GetSubTaskTrace('<%#DataBinder.Eval(Container.DataItem,"TaskPara1") %>');"></span>
                                </td>
                            </tr>
                        </ItemTemplate>
                    </asp:Repeater>
                    
                </table>
                
            </td>
        </tr>
                                                                    <tr style="display: none;">
                                                                <td>
                                                                    <asp:Button ID="Resume" runat="server" Text="Resume" CssClass="btn btn-primary gladbtn" 
                                                                        onclick="Resume_Click"/>
                                                                    <asp:Button ID="Pause" runat="server" Text="Pause" CssClass="btn btn-primary gladbtn" 
                                                                        onclick="Pause_Click"/>
                                                                    <asp:Button ID="Start" runat="server" Text="Start" CssClass="btn btn-primary gladbtn" 
                                                                        onclick="Start_Click"/>

                                                                </td>
                                                            </tr>

    </table>
    <asp:HiddenField ID="DeviceId" runat="server" />
    <asp:HiddenField ID="HiddenTaskId" runat="server" />
    <asp:HiddenField ID="HiddenTaskType" runat="server" />
    <asp:HiddenField ID="HiddenSubId" runat="server" />
    
    <div style="display: none;">
    <asp:Button ID="DeleteSubTask" runat="server" Text="Button" OnClick="DeleteSubTask_Click" />    
        <asp:Button ID="DeleteSelSubTask" runat="server" Text="Button" OnClick="DeleteSelSubTask_Click" />    
        
        
        <asp:Button ID="WipeDevice" runat="server" OnClick="WipeDevice_Click" meta:resourcekey="WipeDeviceResource1" />
    </div>
    <script type="text/javascript">
        var grid;
        function AdjustGridTable() {
            

            var e = document.getElementById("grid-example");
            e.style.height = (document.documentElement.offsetHeight - 80) + "px";
        }

        Ext.onReady(function () {
            Ext.EventManager.onWindowResize(AdjustGridTable);
            AdjustGridTable();
        });

        function ResumeTask(tid) {
            var b = document.getElementById("ctl00_MainContent_Resume");
            var t = document.getElementById("ctl00_MainContent_HiddenTaskId");

            t.value = tid;
            Wait('One Minute');
            b.click();
        }

        function PauseTask(tid) {
            var b = document.getElementById("ctl00_MainContent_Pause");
            var t = document.getElementById("ctl00_MainContent_HiddenTaskId");

            t.value = tid;
            Wait('One Minute');
            b.click();

        }

        function StartTask(tid) {
            var b = document.getElementById("ctl00_MainContent_Start");
            var t = document.getElementById("ctl00_MainContent_HiddenTaskId");

            t.value = tid;
            Wait('One Minute');
            b.click();

            

        }


    </script>
    <asp:HiddenField ID="HiddenInstanceId" runat="server" />
    <asp:HiddenField ID="HiddenDeviceName" runat="server" />
    <asp:HiddenField ID="backtotarget" runat="server" />
</asp:Content>
