﻿<%@ Page Title="Gladinet Cloud - User Manager" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="DeviceLocalLockMgr.aspx.cs" Inherits="GladinetPayFlow.DeviceLocalLockMgr" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">

    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        .dark {
            color: #565656 !important;
        }
        </style>
    <script type="text/javascript">
        function getScrollXY() {
            var scrOfX = 0, scrOfY = 0;
            if (typeof (window.pageYOffset) == 'number') {
                //Netscape compliant
                scrOfY = window.pageYOffset;
                scrOfX = window.pageXOffset;
            } else if (document.body && (document.body.scrollLeft || document.body.scrollTop)) {
                //DOM compliant
                scrOfY = document.body.scrollTop;
                scrOfX = document.body.scrollLeft;
            } else if (document.documentElement && (document.documentElement.scrollLeft || document.documentElement.scrollTop)) {
                //IE6 standards compliant mode
                scrOfY = document.documentElement.scrollTop;
                scrOfX = document.documentElement.scrollLeft;
            }
            //return [scrOfX, scrOfY];
            return scrOfY;
        }



       
        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //parent.setActivePanel("UserMgr");

        function onDelUser(id, name) {
            var h = "/management/GuestUserMgrPage.aspx?op=delete&id=" + id;

            if (confirm("Do you really want to delete (" + unescape(name) + ")?")) {
                Wait('Deleting');
                window.location = h;
            }

        }

        function OpenHtmlWindowShort(id, title, Html, w, h) {

            activewin = new Ext.Window({
                id: id,
                title: title,
                width: w,
                height: maxh(h),
                plain: true,
                modal: true,
                constrain: true,
                maximizable: false,
                maximized: false,
                bodyPadding: 5,
                resizable: false,
                shadow: 'drop',
                iconCls: 'publish',
                bodyStyle: 'background:#dfe8f6;border:0px; ',
                shadowOffset: 10,
                html: Html,
                defaults: {
                    border: false
                }
            });
            activewin.show();

        }

          function OnDeleteOfflineFolder( name) {

              var ng = document.getElementById("ctl00_MainContent_FolderName");
              var btn = document.getElementById("ctl00_MainContent_DetachFolder");

            if (confirm("Do you want to unlock the file (" + unescape(name) + ")?")) {
                Wait("Please wait");
                ng.value = name;
                btn.click();
            }
        }

        function OnGetSyncStatus(id, name) {
            Wait("Please wait");
            window.location = "/management/DeviceSyncStatus.aspx?f=c&id=" + id + "&name=" + name;
            
        }

        function closeCancelActiveWin()
        {
            activewin.close();
        }

        function closeActiveWin() {
            window.location =  "/management/AttachedFolders.aspx";
        }


        function OnWipeDevice(id, name) {



        }

        function MigrateShare(sharename, shareloc) {
            
            var ng = document.getElementById("ctl00_MainContent_HiddenShare");
            var np = document.getElementById("ctl00_MainContent_HiddenPath");
            var btn = document.getElementById("ctl00_MainContent_MigrateShare");

            ng.value = sharename;
            np.value = shareloc;
            btn.click();

        }
        
        function OnForceSyncDown() {
            var btn = document.getElementById("ctl00_MainContent_ForceSyncDown");
            btn.click();

        }

        function OnAttachFolder() {

            
    }
    function OnDeviceList() {
        window.location = "<%=PageReturnUrl %>";
    }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocFaiToDelOffFol" meta:resourcekey="str_faiToDelOffFol" Visible="false">Failed to delete offlined folder</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToForSynAttFol" meta:resourcekey="str_faiToForSynAttFol" Visible="false">Failed to force sync attached folder</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToLoaLocFilLoc" meta:resourcekey="str_faiToLoaLocFilLoc" Visible="false">Failed to load local file locks</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToLoaDevInf" meta:resourcekey="str_faiToLoaDevInf" Visible="false">Failed to load device info</asp:Localize>
<asp:Localize runat="server" ID="LocLclLkdFilFnd" meta:resourcekey="str_lclLkdFilFnd" Visible="false">local locked files found</asp:Localize>
<asp:Localize runat="server" ID="LocThsDvc" meta:resourcekey="str_thsDvc" Visible="false">This device</asp:Localize>
    
        <div class="navbar navbar-default meubardrop" role="navigation">
               <div class="container-fluid">
                   
                   <button type="button" class="btn btn-default navbar-btn navbar-left " onclick="OnDeviceList()" style="display: none;"> 
                <span class="fa fa-menu-left" style="color:#565656;"></span> <asp:Localize meta:resourcekey="str_devdash" runat="server">Device Dashboard</asp:Localize>
             </button>

                   <p class="navbar-text">
                        <asp:Label ID="UserCount" runat="server" Text="0 User" meta:resourcekey="UserCountResource1"></asp:Label>
                            <asp:Label ID="GuestQuota" runat="server" Visible="False" Text="0 local locked files"
                                meta:resourcekey="GuestQuotaResource1"></asp:Label>
                   </p>
                   <div id="errmsgdiv" class="navbar-text">
                       <b>
                          <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                   </div>

                   <div  class="btn btn-primary gladbtn navbar-btn navbar-right dark" style="margin-right: 8px; padding-left: 5px; padding-right: 5px;">
                       <asp:LinkButton ID="RefreshBtn"  runat="server" OnClick="LinkButton2_Click"  OnClientClick="Wait('one minute'); return true;">
                       <span class="fa fa-refresh sectextcolor" aria-hidden="true" title="<%=str_refresh.Text %>"></span><asp:Localize meta:resourcekey="str_refresh" runat="server" id="str_refresh" Visible="False">Refresh</asp:Localize>
                       
                           
                       </asp:LinkButton>
                       <asp:Label ID="DeviceName" Visible="False" runat="server" Text="Label" meta:resourcekey="DeviceNameResource1"></asp:Label>
                   </div>
                   
               
                   
               </div>
           </div>
           

   <table id="grid-table" width="100%" align="center" style="background-color: white; padding: 2px; margin-top: 18px;" cellspacing="0"
        cellpadding="0">
        <tr>
            <td colspan="3" id="grid-example" valign="top">
            </td>
        </tr>
    </table>

  <asp:HiddenField ID="DeviceId" runat="server" />
  <asp:HiddenField ID="FolderName" runat="server" />
  
  <div style="display:none;">
    <asp:Button ID="WipeDevice" runat="server" 
        onclick="WipeDevice_Click" meta:resourcekey="WipeDeviceResource1" />
        

        <asp:Button ID="DetachFolder" runat="server" onclick="DetachFolder_Click"  />
       
      <asp:Button ID="ForceSyncDown" runat="server" onclick="ForceSyncDown_Click"  />
        </div>
        

  <script type="text/javascript">
  
  var myData = [
 <asp:Repeater ID="UsersRepeater" runat="server" OnItemCommand="UsersRepeater_ItemCommand"
        OnItemDataBound="OnUserItemBound">
        <ItemTemplate>         
        <%#(Container.ItemIndex == 0)? "": "," %>     
         ['<%#(((RepeaterItem)Container).ItemIndex+1) %>',        
           '<%#DataBinder.Eval(Container.DataItem,"Name").ToString().Replace("\\", "\\\\") %>'     
           ] 
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
  <script type="text/javascript">
      var grid;
      function AdjustGridTable() {
          isMobileBrowserOrNarrow();
          var h = 400;

          try {

              var myTable = Ext.get('grid-table');
              var tableY = myTable.getY();

              //var mySetting = Ext.get('farm-setting');
              var settingH = 0; // mySetting.getHeight();

              h = document.body.offsetHeight - tableY - 8 - settingH;
              //var ee = document.getElementById('tinfo');
              //ee.style.height = h + "px";
              if (h < 108) {
                  h = 108;
              }

          } catch (err) {
          }
          //alert(h);
          //alert(tableY);
          //alert(document.body.offsetHeight);
          grid.setWidth(document.documentElement.clientWidth - 4);
          grid.setHeight(h);
          grid.doComponentLayout();
      }
      Ext.require([
          'Ext.grid.*',
          'Ext.data.*',
          'Ext.util.*',
          'Ext.state.*'
      ]);
      Ext.onReady(function () {

          Ext.QuickTips.init();

          var store = Ext.create('Ext.data.ArrayStore', {
              fields: [
                  { name: 'index' },
                  { name: 'name' }
              ],
              data: myData
          });



          grid = Ext.create('Ext.grid.Panel', {
              store: store,
              stripeRows: true,
              columnLines: false,
       
              border: true,
              columns: [
                  {
                      text: '',
                      width: 50,
                      sortable: false,
                      hideable: false,
                      dataIndex: 'index',
                      getClass: function (v, meta, rec) {
                          return 'x-col-hdide';
                      }
                  },
                  {
                      text: 'Name',
                      flex: 1,
                      sortable: true,
                      dataIndex: 'name',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<span style='color:#565656; font-weight:100'>" + unescape(value) + "</span>";
                      }

                  }, {
                      xtype: 'actioncolumn',
                      width: 80,
                      hideable: false,
                      items:
                      [
                          {
                              icon: 'images/trash.png', // Use a URL in the icon config
                              tooltip: "Delete",
                              width: 30,
                              handler: function(grid, rowIndex, colIndex) {
                                  var rec = grid.getStore().getAt(rowIndex);
                                  var d = rec.data;

                                  OnDeleteOfflineFolder(d.name);
                              },
                              getClass: function(v, meta, rec) {


                              }
                          }
                      ]
                  }
              ],
              renderTo: 'grid-example'
          });

          Ext.EventManager.onWindowResize(AdjustGridTable);
          AdjustGridTable();
      });
  </script>
    <asp:HiddenField ID="HiddenInstanceId" runat="server" />
    <asp:HiddenField ID="HiddenDeviceName" runat="server" />
    <asp:HiddenField ID="backtotarget" runat="server" />
    <asp:HiddenField ID="HiddenShare" runat="server" />
    <asp:HiddenField ID="HiddenPath" runat="server" />
</asp:Content>
