﻿<%@ Page Title="CIFS Shares" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="DeviceCIFSShares.aspx.cs" Inherits="GladinetPayFlow.DeviceCIFSShares" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">

    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        .dark {
            color: #565656 !important;
        }
        </style>
    <script type="text/javascript">
        function getScrollXY() {
            var scrOfX = 0, scrOfY = 0;
            if (typeof (window.pageYOffset) == 'number') {
                //Netscape compliant
                scrOfY = window.pageYOffset;
                scrOfX = window.pageXOffset;
            } else if (document.body && (document.body.scrollLeft || document.body.scrollTop)) {
                //DOM compliant
                scrOfY = document.body.scrollTop;
                scrOfX = document.body.scrollLeft;
            } else if (document.documentElement && (document.documentElement.scrollLeft || document.documentElement.scrollTop)) {
                //IE6 standards compliant mode
                scrOfY = document.documentElement.scrollTop;
                scrOfX = document.documentElement.scrollLeft;
            }
            //return [scrOfX, scrOfY];
            return scrOfY;
        }

        function OnGetSyncStatus(id, name) {
            Wait("Please wait");
            window.location = "/management/DeviceSyncScan.aspx?f=c&id=" + id + "&name=" + name;
            
        }


       
        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //parent.setActivePanel("UserMgr");

        function onDelUser(id, name) {
            var h = "/management/GuestUserMgrPage.aspx?op=delete&id=" + id;

            if (confirm("Do you really want to delete (" + unescape(name) + ")?")) {
                Wait('Deleting');
                window.location = h;
            }

        }

        function OpenHtmlWindowShort(id, title, Html, w, h) {

            activewin = new Ext.Window({
                id: id,
                title: title,
                width: w,
                height: maxh(h),
                plain: true,
                modal: true,
                constrain: true,
                maximizable: false,
                maximized: false,
                bodyPadding: 5,
                resizable: false,
                shadow: 'drop',
                iconCls: 'publish',
                bodyStyle: 'background:#dfe8f6;border:0px; ',
                shadowOffset: 10,
                html: Html,
                defaults: {
                    border: false
                }
            });
            activewin.show();

        }

          function OnDeleteAttachedFolder(id, name) {

              var ng = document.getElementById("ctl00_MainContent_FolderName");
              var btn = document.getElementById("ctl00_MainContent_DetachFolder");

            if (confirm("Do you want to detach the folder (" + unescape(name) + ")?")) {
                Wait("Please wait");
                ng.value = name;
                btn.click();
            }
        }


        function closeCancelActiveWin()
        {
            activewin.close();
        }

        function closeActiveWin() {
            window.location =  "/management/AttachedFolders.aspx";
        }


        function OnWipeDevice(id, name) {



        }

        function MigrateShare(sharename, shareloc) {
            
            
            var ng = document.getElementById("ctl00_MainContent_HiddenShare");
            var np = document.getElementById("ctl00_MainContent_HiddenPath");
            var btn = document.getElementById("ctl00_MainContent_MigrateShare");

            ng.value = sharename;
            np.value = shareloc;
            btn.click();

        }

    function OnAttachFolder() {        
        window.location = "/management/AddAttachedFolder.aspx?id=<%=HiddenInstanceId.Value%>&name=<%=HiddenDeviceName.Value %>";
    }
    function OnDeviceList() {
        window.location = "<%=PageReturnUrl %>";
    }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Localize ID="LocThiDev" meta:resourcekey="str_thiDev" Visible="false" runat="server">This device</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToDetFol" meta:resourcekey="str_faiToDetFol" Visible="false">Failed to detach folder</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToLoaSha" meta:resourcekey="str_faiToLoaSha" Visible="false">Failed to load shares</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToLoaDevInf" meta:resourcekey="str_faiToLoaDevInf" Visible="false">Failed to load device info</asp:Localize>
<asp:Localize runat="server" ID="LocCfsShsFnd" meta:resourcekey="str_cfsShsFnd" Visible="false">CIFS Share(s) Found</asp:Localize>
    
        <div class="meubardrop navbar navbar-default navbar-fixed-top" role="navigation" style="padding-left:0px!important; border-bottom: 1px solid #c0c0c0; <% if (IsChildUi){ %>box-shadow: 0px 0px white!important; <% } %>">
               <div class="container-fluid">
                   
                   <button type="button" class="btn btn-default navbar-btn navbar-left " onclick="OnDeviceList()" style="display: none;"> 
                <span class="fa fa-menu-left" style="color:#565656;"></span> <asp:Localize meta:resourcekey="str_devdash" runat="server">Device Dashboard</asp:Localize>
             </button>

                   <p class="navbar-text" style="font-weight:400;">
                        <asp:Label ID="UserCount" runat="server" Text="0 Users" meta:resourcekey="UserCountResource1"></asp:Label>
                            <asp:Label ID="GuestQuota" runat="server" Visible="False" Text="0 available guest user quota"
                                meta:resourcekey="GuestQuotaResource1"></asp:Label>
                   </p>
                   <div id="errmsgdiv" class="navbar-text">
                       <b>
                          <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                   </div>
                   <div  class="btn btn-primary gladbtn navbar-btn navbar-right dark" style="margin-right: 8px;">
                       <span class="fa fa-refresh" aria-hidden="true"></span>
                       <asp:LinkButton ID="RefreshBtn"  runat="server" OnClick="LinkButton2_Click" CssClass="gladbtn"><asp:Localize meta:resourcekey="str_rfs" runat="server">Refresh</asp:Localize> <asp:Label ID="DeviceName" Visible="False" runat="server" Text="Label" meta:resourcekey="DeviceNameResource1"></asp:Label></asp:LinkButton>
                   </div>
                   <%if(m_DeviceVer >= 3){ %>
                   <div  class="btn btn-primary gladbtn navbar-btn navbar-right dark" style="margin-right: 8px; display: none;">
                       <span class="fa fa-plus" aria-hidden="true"></span>
                       <asp:LinkButton ID="AttachBtn"  runat="server" OnClick="Attach_Click" cssclass="gladbtn">Attach</asp:LinkButton>
                   </div>
                   <%} %>
               </div>
           </div>
           

   <table id="grid-table" width="100%" align="center" style="background-color: white; padding: 2px; margin-top: 18px;" cellspacing="0"
        cellpadding="0">
        <tr>
            <td colspan="3" id="grid-example" valign="top">
            </td>
        </tr>
    </table>

  <asp:HiddenField ID="DeviceId" runat="server" />
  <asp:HiddenField ID="FolderName" runat="server" />
  
  <div style="display:none;">
    <asp:Button ID="WipeDevice" runat="server" 
        onclick="WipeDevice_Click" meta:resourcekey="WipeDeviceResource1" />
        

        <asp:Button ID="DetachFolder" runat="server" onclick="DetachFolder_Click"  />
        <asp:Button ID="MigrateShare" runat="server" onclick="MigrateShare_Click"   />

        </div>
        

  <script type="text/javascript">
  
  var myData = [
 <asp:Repeater ID="UsersRepeater" runat="server" OnItemCommand="UsersRepeater_ItemCommand"
        OnItemDataBound="OnUserItemBound">
        <ItemTemplate>         
        <%#(Container.ItemIndex == 0)? "": "," %>     
         ['<%#(((RepeaterItem)Container).ItemIndex+1) %>',        
           '<%#DataBinder.Eval(Container.DataItem,"Name").ToString().Replace("'","%27") %>',
           '<%#DataBinder.Eval(Container.DataItem,"Path").ToString().Replace("'","%27").Replace("\\","%5c") %>',
           '<%#DataBinder.Eval(Container.DataItem,"Migrated") %>' ,
           '<%#DataBinder.Eval(Container.DataItem,"CloudName").ToString().Replace("'","%27") %>'     
           ] 
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
  <script type="text/javascript">
      var grid;
      function AdjustGridTable() {
          isMobileBrowserOrNarrow();
          var h = 400;

          try {

              var myTable = Ext.get('grid-table');
              var tableY = myTable.getY();

              //var mySetting = Ext.get('farm-setting');
              var settingH = 0; // mySetting.getHeight();

              h = document.body.offsetHeight - tableY - 18 - settingH;
              //var ee = document.getElementById('tinfo');
              //ee.style.height = h + "px";
              if (h < 108) {
                  h = 108;
              }

          } catch (err) {
          }
          //alert(h);
          //alert(tableY);
          //alert(document.body.offsetHeight);
          grid.setWidth(document.documentElement.clientWidth - 4);
          grid.setHeight(h);
          grid.doComponentLayout();
      }
      Ext.require([
          'Ext.grid.*',
          'Ext.data.*',
          'Ext.util.*',
          'Ext.state.*'
      ]);
      Ext.onReady(function () {

          Ext.QuickTips.init();

          var store = Ext.create('Ext.data.ArrayStore', {
              fields: [
                  { name: 'index' },
                  { name: 'name' },
                  { name: 'loc' },
                  { name: 'mig' },
                  { name: 'cname' }
              ],
              data: myData
          });



          grid = Ext.create('Ext.grid.Panel', {
              store: store,
              stripeRows: true,
              columnLines: true,
       
              border: true,
              columns: [
                  {
                      text: '',
                      width: 50,
                      sortable: false,
                      hideable: false,
                      dataIndex: 'index',
                      getClass: function (v, meta, rec) {
                          return 'x-col-hdide';
                      }
                  },
                  {
                      text: "<asp:Localize meta:resourcekey="str_nme" runat="server">Name</asp:Localize>:",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'name',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<b>" + unescape(value) + "</b>";
                      }

                  },{
                      text: "<asp:Localize meta:resourcekey="str_lclFld" runat="server">Local Folders</asp:Localize>:",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'loc',
                      renderer: function (value, metaData, record, rowIndex) {
                          return unescape(value);
                      }

                      }
      
                     <% if (!m_DisableClientAttach) { %>
                    , {
                      text: '',
                      width:100,
                      sortable: true,
                      align: 'center',
                      dataIndex: 'mig',
                      renderer: function (value, metaData, record, rowIndex) {
                          var d = record.data;
                          if (value == 'True') {
                              return "<span class='gladinet-icons md-24 md-dark hand center toolbtn' style='color:#565656;' title=\"<asp:Localize meta:resourcekey="str_shwNotSnc" runat="server">Show items not synced</asp:Localize>\" onclick='OnGetSyncStatus(\"<%=HiddenInstanceId.Value %>\",\"" +d.cname +"\"); return false;'>&#xBF;</span>"
                          }


                         
                          var s1 = d.loc.replace("%5c", "\\\\");
                          while (s1.indexOf("%5c") != -1) {
                              s1 = s1.replace("%5c", "\\\\");
                          }
                          var s = "<a href='javascript:;' class='sectextcolor' onclick=\"MigrateShare('" + d.name + "','" + unescape(s1) + "');return false;\" ><asp:Localize meta:resourcekey="str_mgt" runat="server">Migrate</asp:Localize></a>";
                          
                          return s;
                      }

                    }
                    <% } %>
              ],
              renderTo: 'grid-example'
          });

          Ext.EventManager.onWindowResize(AdjustGridTable);
          AdjustGridTable();
      });
  </script>
    <asp:HiddenField ID="HiddenInstanceId" runat="server" />
    <asp:HiddenField ID="HiddenDeviceName" runat="server" />
    <asp:HiddenField ID="backtotarget" runat="server" />
    <asp:HiddenField ID="HiddenShare" runat="server" />
    <asp:HiddenField ID="HiddenPath" runat="server" />
</asp:Content>
