﻿<%@ Page Title="Assisted Installation" Language="C#" MasterPageFile="WebAppPanel.master" AutoEventWireup="true"
    CodeBehind="ConsultSvc.aspx.cs" Inherits="GladinetPayFlow.ConsultSvc" Culture="auto" meta:resourcekey="PageResource1"
    UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    
    <style type="text/css">
        td
        {
            font-size: 15px;
            
            font-weight: 100;
        }
        
        b
        {
            font-weight: 500;
        }
        
        .badgefont
        {
            font-size: 15px;
            
        }
    </style>
    <style type="text/css">
     .modal-ku {
  width: 1000px;
  margin-left: 10px;
  
}
    </style>
    <script type="text/javascript">

        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 8000);

        function OpenSvcPanel()
        {
            var e = document.getElementById("SvcList");
            var e1 = document.getElementById("scheduledlist");

            e.style.display = "";
            e1.style.display = "none";
        }

        function CloseSvcPanel() {
            var e = document.getElementById("SvcList");
            var e1 = document.getElementById("scheduledlist");

            e.style.display = "none";
            e1.style.display = "";
        }

        function CanSchedule()
        {
            if (confirm("Please confirm the service scheduling, our support team will contact you to schedule a time with you or your technician.   "))
                return true;
            return false;
        }

        function onCancelService(id) {
            if (!confirm("<asp:Localize meta:resourcekey="str_pleConCanOfTheSchSerIt" runat="server">Please confirm cancellation of the scheduled service, it may take up to 2 business days to process.</asp:Localize>"))
                return;

            var b = document.getElementById('ctl00_MainContent_CaneclSvc');
            var i = document.getElementById('ctl00_MainContent_SvcID');

            i.value = id;
            b.click();
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
      <asp:Localize ID="LocFaiToVal" meta:resourcekey="str_faiToVal" runat="server" Visible="False">Failed to validate:</asp:Localize>
<asp:Localize ID="LocNotFou" meta:resourcekey="str_notFou" runat="server" Visible="False">Not found</asp:Localize>
<asp:Localize ID="LocIntErr" meta:resourcekey="str_intErr" runat="server" Visible="False">Internal error</asp:Localize>
    <%if (!string.IsNullOrEmpty(ErrorMsg.Text)){ %>
  <div class="alert alert-warning alert-dismissible fade show"" role="alert" id="ErrDiv">
   <asp:Label ID="ErrorMsg" runat="server" Text=""></asp:Label> 
      <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
    <%} %>
      <div id="howitmodal" class="modal fade" role="dialog">
  <div class="modal-dialog modal-ku" >

    <!-- Modal content-->
    <div class="modal-content" style="width:1000px!important;margin:auto!important;">
      <div class="modal-header">
           <h4 class="modal-title"><asp:Localize meta:resourcekey="str_howItWor" runat="server">How it works</asp:Localize></h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
       
      </div>
      <div class="modal-body">
        <ul style="list-style-type: decimal;">
                            <li><asp:Localize meta:resourcekey="str_theBilHouRatIsUsd150PerHou" runat="server">The billable hour rate is USD $150 per Hour</asp:Localize></li>
                            <li><asp:Localize meta:resourcekey="str_theBasCosCovTheComCasForUs" runat="server">The base cost covers the common cases for us to conduct each service. If case gets complicated and extra hours are required, the extra hours will be billed additionally, and we will let you know before we continue with additional hours for the service. </asp:Localize></li>
                            <li><asp:Localize meta:resourcekey="str_oncTheBasCosForASerIsPai" runat="server">Once the base cost for a service is paid, the service will be scheduled</asp:Localize></li>
                            <li><asp:Localize meta:resourcekey="str_ourSupTeaWilConYouToSchA" runat="server">Our support team will contact you to schedule a time with you or your technician for the service.  </asp:Localize></li>
                          
                            <li><asp:Localize meta:resourcekey="str_youCanCanAnyTimBefSerIsPro" runat="server">You can cancel any time before service is provided with a 10% cancellation charge, no contract, no obligation. </asp:Localize></li>
                            <li><asp:Localize meta:resourcekey="str_bySchASerAppYouAgrToOur" runat="server">By Scheduling a service appointment, you agree to our service agreement </asp:Localize></li>
                        </ul>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
      </div>
    </div>

  </div>
</div>
    <div id="SvcList" style="background-color:white; width:100%; display:none;">
        <table width="100%">
            <tr>
                <td>
                    <span class="btn btn-primary gladbtn" data-toggle="modal" data-target="#howitmodal"><asp:Localize meta:resourcekey="str_howItWor" runat="server">How it works</asp:Localize></span>
                  
                </td>
                <td align="right">
                    <span class="btn btn-primary gladbtn" onclick="CloseSvcPanel();" style="font-size:18px!important;">&times;</span>
                </td>
            </tr>
        </table>
        <div class="row " style="width: 100%; align-content: center; margin: 0; padding-top:40px;" align="center">
            <div class="col-xs-12 col-sm-12 col-lg-6  topbuffer" style="padding-bottom: 10px;">
                <div class=" viewcard" style="width: 100%;">
                    <div class="panel-body text-left mblue500" style="height: 220px; padding: 10px; border-width: 0px!important; color: white;">
                        <h2 class="h2light sectextcolor" style="font-weight: 100;"><asp:Localize meta:resourcekey="str_assIns" runat="server">Assisted Installation</asp:Localize></h2>
                        <h3 style="font-weight: 100; display: inline-block; padding-top: 2px;"><asp:Localize meta:resourcekey="str_letUsHelYouInsConAndGetEve" runat="server">Let us help you install, configure and get everything setup and ready!</asp:Localize></h3>
                        <p class="text-muted" style="padding-top: 12px; font-size: 12px; color: #808080;"><asp:Localize meta:resourcekey="str_youTecIsBusAndHisTimIsPre" runat="server">
                            Your technician is busy and his time is precious. Instead of learning and configuring a new product on his own, we’d love
                        to save him some time by walking through the configuration process with him and providing some quick start training.

                                            The product will be up and running quickly, saving time and money. Everybody is a winner!</asp:Localize></p>

                        <div class="modal" id="AIModal">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">

                                    <!-- Modal Header -->
                                    <div class="modal-header">

                                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                                    </div>


                                    <!-- Modal body -->
                                    <div class="modal-body">
                                        <div class="alert alert-primary" role="alert"><asp:Localize meta:resourcekey="str_prerequisites" runat="server">Prerequisites</asp:Localize></div>
                                        <ul>

                                            <li><asp:Localize meta:resourcekey="str_whiInGenTheAreNotManSpePre" runat="server">While in general there are not many special prerequisites, 
           certain deployment types may require that you have a static IP address for your CentreStack Web Server and have a valid SSL certificate for example. 
           When you book an Assisted Installation session one of our technicians will contact you to get all the details we need and 
           provide you with a list of prerequisites that is required in order to quickly and properly complete the work for you.</asp:Localize></li>
                                        </ul>

                                        <div class="alert alert-success" role="alert"><asp:Localize meta:resourcekey="str_conSerInc" runat="server">Consulting Service Includes</asp:Localize></div>
                                        <ul>
                                            <li><asp:Localize meta:resourcekey="str_upToTwoHouOfRemAssInsAnd" runat="server">Up to two hours of remote “Assisted Installation and Configuration” assistance from a CentreStack specialist</asp:Localize></li>


                                        </ul>
                                    </div>

                                    <!-- Modal footer -->
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="panel-body mblue800" style="height: 42px; font-size: 18px; font-weight: 100; padding-top: 3px; border-top: 1px solid #f0f0f0; background-color: white!important; vertical-align: middle; align: right; text-align: right; padding-right: 10px;">
                        <table width="100%">
                            <tr>
                                <td style="font-weight: 100; color: #404040;" align="left">Base Cost: US $<%=m_AICost %> (<%=m_AIHour %> hours)
                                </td>
                                <td align="right">
                                    <button type="button" class="btn btn-primary gladbtn" data-toggle="modal" data-target="#AIModal">More Info</button>
                                    <asp:Button ID="SchAssInstall" runat="server" OnClick="SchAssInstall_Click" CssClass="btn btn-primary gladbtn" OnClientClick="return CanSchedule();" ForeColor="White" meta:resourcekey="str_schNow" Text="Schedule Now"></asp:Button>
                                </td>
                            </tr>
                        </table>

                    </div>
                </div>
            </div>

            <div class="col-xs-12 col-sm-12 col-lg-6  topbuffer" style="padding-bottom: 10px;">
                <div class=" viewcard" style="width: 100%;">
                    <div class="panel-body text-left mblue500" style="height: 220px; padding: 10px; border-width: 0px!important; color: white;">
                        <h2 class="h2light sectextcolor" style="font-weight: 100;"><asp:Localize meta:resourcekey="str_conSamSinSigOnWitAzuAd" runat="server">Configure SAML single sign on with Azure AD</asp:Localize></h2>
                        <h3 style="font-weight: 100; display: inline-block; padding-top: 2px;"><asp:Localize meta:resourcekey="str_letUsHelYouConSsoIntWitYou" runat="server">Let us help you configure SSO integration with your Azure AD</asp:Localize></h3>
                        <p class="text-muted" style="padding-top: 12px; font-size: 12px; color: #808080;">
                            <asp:Localize meta:resourcekey="str_conSAMIntWitAzuADCanBe" runat="server">Configuring SAML integration with Azure AD can be time consuming and error prone. Consult with our experts to help you get SAML SSO configured quickly and correctly.</asp:Localize><br />

                            <!-- The Modal -->
                            <div class="modal" id="SAMLModal">
                                <div class="modal-dialog modal-lg">
                                    <div class="modal-content">

                                        <!-- Modal Header -->
                                        <div class="modal-header">

                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                        </div>

                                        <!-- Modal body -->
                                        <div class="modal-body">
                                             <div class="alert alert-primary" role="alert"><asp:Localize meta:resourcekey="str_prerequisites" runat="server">Prerequisites</asp:Localize></div>
                                            <ul>

                                                <li><asp:Localize meta:resourcekey="str_anAzuAdTenWitExiUseAccFor" runat="server">An Azure AD tenant with existing user accounts (for example Microsoft 365).</asp:Localize></li>

                                                <li><asp:Localize meta:resourcekey="str_gloAdmAccToTheAzuAdTen" runat="server">Global administrator access to the Azure AD tenant</asp:Localize></li>

                                                <li><asp:Localize meta:resourcekey="str_tenAdmAccToEit" runat="server">Tenant admin access to either:</asp:Localize></li>

                                                <li><asp:Localize meta:resourcekey="str_SynHosTen" runat="server">- Sync4share.com hosted tenant</asp:Localize></li>

                                                <li><asp:Localize meta:resourcekey="str_SelCenCluWitAPubAccFqd" runat="server">- Self-hosted CentreStack cluster with a publicly accessible FQDN and server certificate.</asp:Localize></li>

                                                <li><asp:Localize meta:resourcekey="str_theAbiToShaYouScrViaGotOr" runat="server">The ability to share your screen via GoToMeeting or Microsoft Teams</asp:Localize></li>
                                            </ul>

                                            <div class="alert alert-success" role="alert"><asp:Localize meta:resourcekey="str_conSerInc" runat="server">Consulting Service Includes</asp:Localize></div>
                                            <ul>
                                                <li><asp:Localize meta:resourcekey="str_upToTwoHouOfRemAssWitA" runat="server">Up to two hours of remote assistance with a CentreStack Consultant</asp:Localize></li>

                                                <li><asp:Localize meta:resourcekey="str_conAzuAdAppRegToSupSam" runat="server">Configuring Azure AD app registration to support SAML</asp:Localize></li>

                                                <li><asp:Localize meta:resourcekey="str_conCenTenToSupAzuAdSam" runat="server">Configuring CentreStack tenant to support Azure AD SAML</asp:Localize></li>

                                                <li><asp:Localize meta:resourcekey="str_troOfSamRedAsNec" runat="server">Troubleshooting of SAML redirects, as necessary.</asp:Localize></li>
                                            </ul>
                                        </div>

                                        <!-- Modal footer -->
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-primary" data-dismiss="modal">
<asp:Localize meta:resourcekey="str_clo" runat="server">Close</asp:Localize></button>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </p>

                    </div>
                    <div class="panel-body mblue800" style="height: 42px; font-size: 18px; font-weight: 100; padding-top: 3px; border-top: 1px solid #f0f0f0; background-color: white!important; vertical-align: middle; align: right; text-align: right; padding-right: 10px;">
                        <table width="100%">
                            <tr>
                                <td style="font-weight: 100; color: #404040;" align="left">Base Cost: US $<%=m_SAMLCost %> (<%=m_SAMLHour %> hours)
                                </td>
                                <td align="right">
                                    <button type="button" class="btn btn-primary gladbtn" data-toggle="modal" data-target="#SAMLModal"><asp:Localize meta:resourcekey="str_morInf" runat="server">More Info</asp:Localize></button>

                                    <asp:Button ID="LinkButton1" runat="server" OnClick="SchAzureSSO_Click" ForeColor="White" meta:resourcekey="str_schNow" Text="Schedule Now" CssClass="btn btn-primary gladbtn" OnClientClick="return CanSchedule();"></asp:Button>
                                </td>
                            </tr>
                        </table>

                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-lg-6  topbuffer" style="padding-bottom: 10px;">
                <div class=" viewcard" style="width: 100%;">
                    <div class="panel-body text-left mblue500" style="height: 220px; padding: 10px; border-width: 0px!important; color: white;">
                        <h2 class="h2light sectextcolor" style="font-weight: 100;"><asp:Localize meta:resourcekey="str_migDat" runat="server">Migrate Database</asp:Localize></h2>
                        <h3 style="font-weight: 100; display: inline-block; padding-top: 2px;"><asp:Localize meta:resourcekey="str_letUsHelYouMigDatToLocOr" runat="server">Let us help you migrate database to local or to the cloud.</asp:Localize></h3>
                        <p class="text-muted" style="padding-top: 12px; font-size: 12px; color: #808080;"><asp:Localize meta:resourcekey="str_mosIniCenSelDepUseTheSoCal" runat="server">Most initial CentreStack self-hosted deployments use the so called "all-in-one" database deployment where the Database Management System (DBMS) is installed locally on the CentreStack web server. The "all-in-one" database is convenient to deploy, but isn't the "best practice" for maintenance, performance, scalability and potentially high availability. Our Consultants can help you to migrate from the "all-in-one" database to an external DBMS.</asp:Localize></p>
                        <div class="modal" id="MigDBModal">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">

                                    <!-- Modal Header -->
                                    <div class="modal-header">

                                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                                    </div>

                                    <!-- Modal body -->
                                    <div class="modal-body">
                                       <div class="alert alert-success" role="alert"><asp:Localize meta:resourcekey="str_conSerInc" runat="server">Consulting Service Includes</asp:Localize></div>
                                        <ul>

                                            <li><asp:Localize meta:resourcekey="str_upTo2HouOfRemAssFroA" runat="server">Up to 2 hours of remote assistance from a Gladinet CentreStack Consultant.</asp:Localize></li>

                                            <li><asp:Localize meta:resourcekey="str_assWitTheInsOfMicSqlManStu" runat="server">Assistance with the installation of Microsoft SQL Management Studio and/or MySQL Workbench.</asp:Localize></li>

                                            <li><asp:Localize meta:resourcekey="str_bacUpTheCurCenDat" runat="server">Back up the current CentreStack database.</asp:Localize></li>

                                            <li><asp:Localize meta:resourcekey="str_anaOfTheCurDatEgAreTheTab" runat="server">Analysis of the current database, (e.g. are there tables with millions of rows?)</asp:Localize></li>

                                            <li><asp:Localize meta:resourcekey="str_creOfNewDatWitThePriOfLea" runat="server">Creation of new database with the "principle of least privilege" (e.g. CentreStack should not require root or sa account to access database).</asp:Localize></li>

                                            <li><asp:Localize meta:resourcekey="str_migOfCurDatToNewDat" runat="server">Migration of current database to new database.</asp:Localize></li>

                                            <li><asp:Localize meta:resourcekey="str_verOfNewDatDatUsiSqlManStu" runat="server">Verification of new database data using SQL Management Studio or MySQL Workbench.</asp:Localize></li>

                                            <li><asp:Localize meta:resourcekey="str_disAboMaiBesPraGoiForEgDai" runat="server">Discussion about maintenance best practices going forward (e.g. daily backups)</asp:Localize></li>
                                        </ul>
                                    </div>

                                    <!-- Modal footer -->
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="panel-body mblue800" style="height: 42px; font-size: 18px; font-weight: 100; padding-top: 3px; border-top: 1px solid #f0f0f0; background-color: white!important; vertical-align: middle; align: right; text-align: right; padding-right: 10px;">


                        <table width="100%">
                            <tr>
                                <td style="font-weight: 100; color: #404040;" align="left">Base Cost: US $<%=m_MigDBCost %> (<%=m_MigDBHour %> hours)
                                </td>
                                <td align="right">
                                    <button type="button" class="btn btn-primary gladbtn" data-toggle="modal" data-target="#MigDBModal">More Info</button>
                                    <asp:Button ID="SchMigDB" runat="server" OnClick="SchMigDB_Click" CssClass="btn btn-primary gladbtn" OnClientClick="return CanSchedule();" meta:resourcekey="str_schNow" Text="Schedule Now"></asp:Button>
                                </td>
                            </tr>
                        </table>

                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-lg-6  topbuffer" style="padding-bottom: 10px;">
                <div class=" viewcard" style="width: 100%;">
                    <div class="panel-body text-left mblue500" style="height: 220px; padding: 10px; border-width: 0px!important; color: white;">
                        <h2 class="h2light sectextcolor" style="font-weight: 100;"><asp:Localize meta:resourcekey="str_migCluSto" runat="server">Migrate Cluster/Tenant Storage</asp:Localize></h2>
                        <h3 style="font-weight: 100; display: inline-block; padding-top: 2px;"><asp:Localize meta:resourcekey="str_letUsHelYouMovYouStoToA" runat="server">Let us help you move your storage to a new place,  local or cloud.</asp:Localize></h3>
                        <p class="text-muted" style="padding-top: 12px; font-size: 12px; color: #808080;"><asp:Localize meta:resourcekey="str_byDefTheSelCenWebSerWilUse" runat="server">By default, the self-hosted CentreStack web server will use the local C:\CentreStack directory for "back end storage". 
                                    The best practice is to offload the back storage to an external file server or cloud storage such as AWS S3 or Azure Blob storage services. 
                                    Our consultants can guide you with migrating from local storage to external or cloud storage, quickly and securely.</asp:Localize></p>
                        <div class="modal" id="MigStorageModal">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">

                                    <!-- Modal Header -->
                                    <div class="modal-header">

                                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                                    </div>

                                    <!-- Modal body -->
                                    <div class="modal-body">
                                        <div class="alert alert-success" role="alert"><asp:Localize meta:resourcekey="str_conSerInc" runat="server">Consulting Service Includes</asp:Localize></div>
                                        <ul>

                                            <li><asp:Localize meta:resourcekey="str_upTo2HouOfRemAssFroA" runat="server">Up to 2 hours of remote assistance from a CentreStack Consultant.</asp:Localize></li>

                                            <li><asp:Localize meta:resourcekey="str_guiWitSelTheBesStoSolForYou" runat="server">Guidance with selecting the best storage solution for your use case.</asp:Localize></li>

                                            <li><asp:Localize meta:resourcekey="str_setOfStoUsiThePriOfLeaPri" runat="server">Setup of storage using the "principle of least privilege".</asp:Localize></li>

                                            <li><asp:Localize meta:resourcekey="str_iniMigOfStoFroCurLocToNew" runat="server">Initial migration of storage from current location to new location.</asp:Localize></li>


                                        </ul>
                                    </div>

                                    <!-- Modal footer -->
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="panel-body mblue800" style="height: 42px; font-size: 18px; font-weight: 100; padding-top: 3px; border-top: 1px solid #f0f0f0; background-color: white!important; vertical-align: middle; align: right; text-align: right; padding-right: 10px;">
                        <table width="100%">
                            <tr>
                                <td style="font-weight: 100; color: #404040;" align="left">Base Cost: US $<%=m_MigStorageCost %> (<%=m_MigStorageHour %> hours)
                                </td>
                                <td align="right">
                                    <button type="button" class="btn btn-primary gladbtn" data-toggle="modal" data-target="#MigStorageModal"><asp:Localize meta:resourcekey="str_morInf" runat="server">More Info</asp:Localize></button>
                                    <asp:Button ID="SchMigStorage" runat="server" OnClick="SchMigStorage_Click" CssClass="btn btn-primary gladbtn" OnClientClick="return CanSchedule();" meta:resourcekey="str_schNow" Text="Schedule Now"></asp:Button>
                                </td>
                            </tr>
                        </table>

                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-lg-6  topbuffer" style="padding-bottom: 10px;">
                <div class=" viewcard" style="width: 100%;">
                    <div class="panel-body text-left mblue500" style="height: 220px; padding: 10px; border-width: 0px!important; color: white;">
                        <h2 class="h2light sectextcolor" style="font-weight: 100;"><asp:Localize meta:resourcekey="str_higAvaSetCon" runat="server">High Availability Setup Consulting</asp:Localize></h2>
                        <h3 style="font-weight: 100; display: inline-block; padding-top: 2px;"><asp:Localize meta:resourcekey="str_letUsHelYouExpYouCurSerFar" runat="server">Let us help you expand your current server farm.</asp:Localize></h3>
                        <p class="text-muted" style="padding-top: 12px; font-size: 12px; color: #808080;"><asp:Localize meta:resourcekey="str_ifYouHavMulTenInYouSelCen" runat="server">If you have multiple tenants in your self-hosted CentreStack deployment, you can't afford any down time. Speak to one of our experts about how Gladinet deployed our sync4share.com SaaS solution in a high availability deployment.</asp:Localize></p>
                        <div class="modal" id="HAModal">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">

                                    <!-- Modal Header -->
                                    <div class="modal-header">

                                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                                    </div>

                                    <!-- Modal body -->
                                    <div class="modal-body">
                                        <div class="alert alert-success" role="alert"><asp:Localize meta:resourcekey="str_conSerInc" runat="server">Consulting Service Includes</asp:Localize></div>
                                        <ul>

                                            <li><asp:Localize meta:resourcekey="str_upTo1HouOfRemAssWitA" runat="server">Up to 1 hour of remote assistance with a Gladinet Consultant.</asp:Localize></li>

                                            <li><asp:Localize meta:resourcekey="str_disTheDetOfHowCenSynWasDep" runat="server">Discuss the details of how CentreStack sync4share.com was deployed in AWS for high availability.</asp:Localize></li>

                                            <li><asp:Localize meta:resourcekey="str_recForAHigAvaSolAppForYou" runat="server">Recommendations for a high availability solution appropriate for your CentreStack deployment whether it is on-premises, at AWS or Azure</asp:Localize></li>




                                        </ul>
                                    </div>

                                    <!-- Modal footer -->
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-primary" data-dismiss="modal"><asp:Localize meta:resourcekey="str_clo" runat="server">Close</asp:Localize></button>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="panel-body mblue800" style="height: 42px; font-size: 18px; font-weight: 100; padding-top: 3px; border-top: 1px solid #f0f0f0; background-color: white!important; vertical-align: middle; align: right; text-align: right; padding-right: 10px;">
                        <table width="100%">
                            <tr>
                                <td style="font-weight: 100; color: #404040;" align="left"><asp:Localize meta:resourcekey="str_basCosUS" runat="server">Base Cost: US$</asp:Localize><%=m_HACost %> (<%=m_HAHour %> hour)
                                </td>
                                <td align="right">
                                    <button type="button" class="btn btn-primary gladbtn" data-toggle="modal" data-target="#HAModal"><asp:Localize meta:resourcekey="str_morInf" runat="server">More Info</asp:Localize></button>
                                    <asp:Button ID="SchHADesign" runat="server" OnClick="SchHADesign_Click" CssClass="btn btn-primary gladbtn" OnClientClick="return CanSchedule();" meta:resourcekey="str_schNow" Text="Schedule Now"></asp:Button>
                                </td>
                            </tr>
                        </table>

                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-lg-6  topbuffer" style="padding-bottom: 10px;">
                <div class=" viewcard" style="width: 100%;">
                    <div class="panel-body text-left mblue500" style="height: 220px; padding: 10px; border-width: 0px!important; color: white;">
                        <h2 class="h2light sectextcolor" style="font-weight: 100;"><asp:Localize meta:resourcekey="str_intToCenQuiTraSes" runat="server">Intro to CentreStack QuickStart Training Session</asp:Localize></h2>
                        <h3 style="font-weight: 100; display: inline-block; padding-top: 2px;"><asp:Localize meta:resourcekey="str_quiAndOnbSesCovTheBasOfCen" runat="server">QuickStart and on-boarding session covering the basics of CentreStack.</asp:Localize></h3>
                        <p class="text-muted" style="padding-top: 12px; font-size: 12px; color: #808080;"><asp:Localize meta:resourcekey="str_wheYouAreAnEndOrTasWitDay" runat="server">Whether you are an end-user or tasked with day-to-day Administration this QuickStart session aims to provide you with the fundamental knowledge and 
                                    clear understanding needed in order to quickly and confidently get started with managing, supporting and working with CentreStack.</asp:Localize></p>
                        <div class="modal" id="TrainModal">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">

                                    <!-- Modal Header -->
                                    <div class="modal-header">

                                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                                    </div>

                                    <!-- Modal body -->
                                    <div class="modal-body">
                                         <div class="alert alert-success" role="alert"><asp:Localize meta:resourcekey="str_conSerInc" runat="server">Consulting Service Includes</asp:Localize></div>
                                        <ul>

                                            <li><asp:Localize meta:resourcekey="str_depArc" runat="server">Deployment Architectures.</asp:Localize></li>

                                            <li><asp:Localize meta:resourcekey="str_admScoCluAdmVsTenAdm" runat="server">Administrative Scopes (Cluster Admin vs Tenant Admin).</asp:Localize></li>

                                            <li><asp:Localize meta:resourcekey="str_datStoOveLocDisLocNasAzuAma" runat="server">Data Storage Overview (Local Disk, Local NAS/SAN, Azure, Amazon, Google Cloud)</asp:Localize></li>

                                            <li><asp:Localize meta:resourcekey="str_secOveEncSecDlp" runat="server">Security Overview (Encryption, Security, DLP)</asp:Localize></li>

                                            <li><asp:Localize meta:resourcekey="str_whiLabBraOve" runat="server">White Label Branding Overview</asp:Localize></li>

                                            <li><asp:Localize meta:resourcekey="str_folTypAndAdm" runat="server">Folder Types and Administration</asp:Localize></li>

                                            <li><asp:Localize meta:resourcekey="str_useManNatLocAdRemAd" runat="server">User Management (Native, Local AD, Remote AD)</asp:Localize></li>

                                            <li><asp:Localize meta:resourcekey="str_remSerAgeWinSerAgeOve" runat="server">Remote Server Agent (Windows Server Agent Overview)</asp:Localize></li>

                                            <li><asp:Localize meta:resourcekey="str_accMetNatCliWebBroFilMan" runat="server">Access methods (Native Clients, Web Browser File Manager)</asp:Localize></li>

                                            <li><asp:Localize meta:resourcekey="str_endCliExWinNatMapDri" runat="server">Endpoint Clients (ex: Windows Native Mapped Drive)</asp:Localize></li>

                                            <li><asp:Localize meta:resourcekey="str_endExpFilShaFilLocFilVerCon" runat="server">End-User Experience (File sharing, File Locking, File Version Control)</asp:Localize></li>


                                        </ul>
                                    </div>

                                    <!-- Modal footer -->
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-primary" data-dismiss="modal"><asp:Localize meta:resourcekey="str_clo" runat="server">Close</asp:Localize></button>
                                    </div>

                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="panel-body mblue800" style="height: 42px; font-size: 18px; font-weight: 100; padding-top: 3px; border-top: 1px solid #f0f0f0; background-color: white!important; vertical-align: middle; align: right; text-align: right; padding-right: 10px;">
                        <table width="100%">
                            <tr>
                                <td style="font-weight: 100; color: #404040;" align="left"><asp:Localize meta:resourcekey="str_basCosUS" runat="server">Base Cost: US$</asp:Localize><%=m_TrainCost %> (<%=m_TrainHour %> hour)
                                </td>
                                <td align="right">
                                    <button type="button" class="btn btn-primary gladbtn" data-toggle="modal" data-target="#TrainModal"><asp:Localize meta:resourcekey="str_morInf" runat="server">More Info</asp:Localize></button>
                                    <asp:Button ID="SchTrain" runat="server" OnClick="SchTrain_Click" CssClass="btn btn-primary gladbtn" OnClientClick="return CanSchedule();" meta:resourcekey="str_schNow" Text="Schedule Now"></asp:Button>
                                </td>
                            </tr>
                        </table>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <div id="scheduledlist" style="background-color:white; width:100%">
          <div style="width:100%; height:48px; box-shadow: 0px 3px 3px #cccccc ">
        <table width="100%"> 
        <tr>
            <td></td>
            <td></td>
            <td align="right">
                <table>
                    <tr>
                        <td style="padding-right:10px;">
                            <span class="btn btn-primary gladbtn" onclick="OpenSvcPanel();"><asp:Localize meta:resourcekey="str_schASer" runat="server">Schedule a Service</asp:Localize></span>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
                </div>
        <asp:Panel ID="NoResult" runat="server">
            <div style="padding:50px; font-size:24px; font-weight:100; color:#565656;"><asp:Localize meta:resourcekey="str_noPurSerFou" runat="server">No purchased service found.</asp:Localize></div>
        </asp:Panel>
        <%if (!NoResult.Visible){ %>
        <table width="100%">

        <tr>
            <td><asp:Localize meta:resourcekey="str_name" runat="server">Name</asp:Localize></td>
            <td><asp:Localize meta:resourcekey="str_price" runat="server">Price</asp:Localize></td>
            <td><asp:Localize meta:resourcekey="str_reqTim" runat="server">Request Time</asp:Localize></td>
            <td><asp:Localize meta:resourcekey="str_status" runat="server">Status</asp:Localize></td>
            <td><asp:Localize meta:resourcekey="str_schTim" runat="server">Schedule Time</asp:Localize></td>
            <td><asp:Localize meta:resourcekey="str_comTim" runat="server">Complete Time</asp:Localize></td>
            <td width="32px"></td>
        </tr>
        <asp:Repeater ID="SvcRepeater" runat="server">
                    <ItemTemplate>
                        <tr style="border-top: 1px solid #f0f0f0; padding: 5px 5px 5px 5px; font-weight: 100;">
                          
                            <td style="padding: 5px; border-bottom: 1px solid #e0e0e0;">
                                <%#DataBinder.Eval(Container.DataItem, "Name")%>
                                
                            </td>
                            <td style="padding: 5px; border-bottom: 1px solid #e0e0e0;">
                               <%#DataBinder.Eval(Container.DataItem, "Price")%>
                            </td>
                            <td style="padding: 5px; border-bottom: 1px solid #e0e0e0;">
                               <%#DataBinder.Eval(Container.DataItem, "CreateTime")%>
                            </td>
                            <td style="padding: 5px; border-bottom: 1px solid #e0e0e0;">
                               <%#DataBinder.Eval(Container.DataItem, "State")%>
                            </td>
                            <td style="padding: 5px; border-bottom: 1px solid #e0e0e0;">
                               <%#DataBinder.Eval(Container.DataItem, "ScheduledTime")%>
                            </td>
                            <td style="padding: 5px; border-bottom: 1px solid #e0e0e0;">
                               <%#DataBinder.Eval(Container.DataItem, "DoneTime")%>
                            </td>
                            <td style="padding: 5px; border-bottom: 1px solid #e0e0e0;">
                                <i class="gladinet-icons md-24 md-dark hand" onclick="onCancelService('<%#DataBinder.Eval(Container.DataItem, "Id")%>');" style="font-size:16px!important">n</i>
                            </td>
                            </tr>
                        </ItemTemplate>
                            </asp:Repeater>
        </table>
                
        <%} %>
    </div>
   

    <div style="display:none;">
        <asp:Button ID="CaneclSvc" runat="server" Text="CancelBtuu" ForeColor="red" OnClick="CaneclSvc_Click" /><asp:HiddenField ID="SvcID" runat="server" />
    </div>
    <script type="text/javascript">
        <%if (NoResult.Visible){ %>
        OpenSvcPanel();
        <%}%>
</script>
</asp:Content>
