﻿<%@ Page Title="System Diagnostic Report" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="ClusterSysInfo.aspx.cs" Inherits="GladinetPayFlow.ClusterSysInfo" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        .badDevListLink {font-size:16px; font-weight:100; color:#565656;}
        </style>
    <script type="text/javascript">


       
        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //parent.setActivePanel("UserMgr");

         function ReturnLast() {
        window.location = "<%=PageReturnUrl %>";
         }

        function Refresh() {
            var e = document.getElementById("ctl00_MainContent_InitailScan");
            if (e) {
                e.click();
            } else {
                e = document.getElementById("ctl00_MainContent_ResultsScan");
                if (e) {
                    e.click();
                }
            }
        }
        function TrySetLastBreadCrum(str) {
            try {
                parent.parent.SetSubSubTitle(str);
            } catch (ex) {
                console.log("parent.parent.SetSubSubTitle is not defined. ex: " + ex);
            }
        }
        function OnPerfMon() {
            try {
                //legacy UI use case
                parent.OnPerfMon();
            } catch (ex1) {
                TrySetLastBreadCrum("Peformance Monitor");
                try {
                    location.href = "PerfCounterMonitor.aspx";
                } catch (ex2) {
                    console.log("OnPerfmon is not defined. ex2: " + ex2);
                }
            }
        }
        function BadDevList(intShowOnlyServerAgent) {
            if (intShowOnlyServerAgent === 1) {
                window.location = "/management/BadDevicesPage.aspx?saonly=1";
            } else {
                window.location = "/management/BadDevicesPage.aspx";
            }
            return false;
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    
    <asp:Localize id="LocFldToScnMsg" meta:resourcekey="str_fldToScnMsg" runat="server" Visible="false">Failed to scan</asp:Localize>
    <asp:Localize id="LocAppPol" meta:resourcekey="str_appPol" runat="server" Visible="false">Application Pool</asp:Localize>
    <asp:Localize id="LocWrkNde" meta:resourcekey="str_wrkNde" runat="server" Visible="false">Worker Node</asp:Localize>
    <asp:Localize id="LocDb" meta:resourcekey="str_db" runat="server" Visible="false">Database</asp:Localize>
    <asp:Localize id="LocLsg" meta:resourcekey="str_lsg" runat="server" Visible="false">Licensing</asp:Localize>
    <asp:Localize id="LocDvcSncSts" meta:resourcekey="str_dvcSncSts" runat="server" Visible="false">Device Sync Status</asp:Localize>
    <asp:Localize id="LocSvrAgtSts" meta:resourcekey="str_svrAgtSts" runat="server" Visible="false">Server Agent Status</asp:Localize>
    <asp:Localize id="LocSvrBld" meta:resourcekey="str_svrBld" runat="server" Visible="false">Server (Worker Node) Build</asp:Localize>
    <asp:Localize id="LocEmlSvc" meta:resourcekey="str_emlSvc" runat="server" Visible="false">Email Service</asp:Localize>   
    <asp:Localize id="LocTntStg" meta:resourcekey="str_tntStg" runat="server" Visible="false">Tenant Storage</asp:Localize>
    <asp:Localize id="LocDevLis" meta:resourcekey="str_devLis" runat="server" Visible="false">Devices List</asp:Localize>


           <div class="meubardrop navbar navbar-default " role="navigation" style=" ">
               <div style="background-color: white;text-align:right;width:100%;">
               <span class="navbar-right sectextcolor" style="width:40px; font-size:32px;  font-weight:100; cursor:pointer;display:none;" onclick="ReturnLast();">&times;</span>
                   
                   <div id="errmsgdiv" class="navbar-text">
                       
                           <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label>
                   </div>
                   <button type="button" class="btn btn-primary gladbtn navbar-btn navbar-right" onclick="OnPerfMon();" title="<asp:Localize meta:resourcekey="str_pfmMtr" runat="server">Performance Monitor</asp:Localize>">
                       <i class="gladinet-icons md-32 md-dark hand" style="display:table-cell;" >&#xBF;</i>
                    
               
                    </button>
                   <button type="button" class="btn btn-primary gladbtn navbar-btn navbar-right" onclick="Refresh();"  title="<asp:Localize meta:resourcekey="RefreshBtnResource1" runat="server">Refresh</asp:Localize>">
                       <i class="gladinet-icons md-32 md-dark hand" style="display:table-cell;" >µ</i>
                    
               
                    </button>
                   
                   </div>
           </div>
           <div style="display:none;vertical-align:top;padding-left:5px;"><asp:LinkButton ID="RefreshBtn" ForeColor="#565656" runat="server" OnClick="RefreshBtn_Click" OnClientClick="Wait('...')" meta:resourcekey="RefreshBtnResource1">Refresh</asp:LinkButton></div>
       
    <table id="grid-table" width="98%" align="center" style="background-color: white; padding: 2px; margin-top: 20px;" cellspacing="0"
        cellpadding="0">
        <tr>
            <td colspan="3" id="grid-example" valign="top" align="center">
                <asp:Panel ID="InitialScanPanel" runat="server">

                    <div style="padding:50px; font-size:20px; font-weight:100">
                        <asp:LinkButton CssClass="btn btn-primary gladbtn" ID="InitailScan" runat="server" OnClick="InitailScan_Click" OnClientClick="Wait('...')" meta:resourcekey="str_strScnMsg">Start System Scan to Generate Report</asp:LinkButton>
                        <p style="font-size:14px; font-weight:100; color:#808080;">
                            <asp:Localize meta:resourcekey="str_genSysDgtRpt" runat="server">Click the link above to go through a series of system self-diagnostic steps and generate system diagnostic report.</asp:Localize>
                        </p>

                    </div>
                </asp:Panel>
                <asp:Panel ID="ResultPanel" runat="server" Visible="false">
                    <div style="display:none;">
                        <asp:LinkButton ID="ResultsScan" runat="server" OnClick="InitailScan_Click" OnClientClick="Wait('...')"></asp:LinkButton>
                    </div>    
                    <table class="table-striped" width="80%">
                        <tr>
                            <td colspan="3"></td>
                        </tr>
                        <tr>
                            <td style="padding:5px; width:40%"></td>
                            <td style="padding:5px; width:40px;"></td>
                            <td style="padding:5px; "></td>

                        </tr>
                        <asp:Repeater ID="NodeList" runat="server">
                            <ItemTemplate>
                                <tr onmouseover="this.style.borderBottom='1px solid #008000';this.style.borderTop='1px solid #008000';" onmouseout="this.style.borderBottom='0px solid #008000';this.style.borderTop='0px solid #008000';">
                                    <td style="padding:5px; font-size:18px; font-weight:100; color:#565656;">
                                        <%#DataBinder.Eval(Container.DataItem, "DisplayName")%>
                                    </td>
                                    <td style=" width:60px;">
                                        
                                        <span class="fa fa-<%#DataBinder.Eval(Container.DataItem, "StatusIcon")%>" style="font-size:16px; color:<%#DataBinder.Eval(Container.DataItem, "StatusColor")%>!important;"></span>
                                    </td>
                                    <td style="padding:5px; font-size:16px; font-weight:100; color:#565656;">
                                        <%#DataBinder.Eval(Container.DataItem, "Reason")%>
                                    </td>

                                </tr>
                            </ItemTemplate>
                               </asp:Repeater>
                    </table>
                </asp:Panel>
            </td>
        </tr>
    </table>
    
  
  <script type="text/javascript">
        
        function AdjustGridTable() {
           
        }
      Ext.onReady(function () {



          //Ext.EventManager.onWindowResize(grid.doLayout, grid);
          Ext.EventManager.onWindowResize(AdjustGridTable);
          AdjustGridTable();
      });
  </script>
    
</asp:Content>
