﻿<%@ Page Title="Gladinet Cloud - Cluster Settings" Language="C#" MasterPageFile="~/WebAppPanel.master" validateRequest="false" 
    AutoEventWireup="true" CodeBehind="ClusterSecSSO.aspx.cs" Inherits="GladinetPayFlow.ClusterSecSSO"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    

    <style type="text/css">
        td {
            font-size: 15px;
            
            font-weight: 100;
        }
        
        b {
            font-weight: 500;
        }
        
        .badgefont {
            font-size: 15px;
            
        }

    </style>
    <script type="text/javascript">

     

        function OnSaveChanges() {
            Wait("Please wait...");
            var btn = document.getElementById('ctl00_MainContent_ApplyBtn');
            btn.click();

        }

        function ReturnLast() {
                    
            <%if (IsServo) { %>
            parent.CloseLeftMain();
            return;
            <%}%>

        window.location = "<%=PageReturnUrl %>";
    }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Localize ID="LocCon" meta:resourcekey="str_con" Visible="false" runat="server">Configured</asp:Localize>
    <asp:Localize id="LocSSO" meta:resourcekey="str_sso" runat="server" Visible="false"></asp:Localize>
<asp:Localize runat="server" ID="LocOth" meta:resourcekey="str_oth" Visible="false">Other</asp:Localize>
<asp:Localize runat="server" ID="LocDirNotEmt" meta:resourcekey="str_dirNotEmt" Visible="false">Directory ID is empty</asp:Localize>
<asp:Localize runat="server" ID="LocFldLodMtaDta" meta:resourcekey="str_fldLodMtaDta" Visible="false">Failed to load IdP Meta Data (Federation Metadata Document)</asp:Localize>
<asp:Localize runat="server" ID="LocFlyQfdDmnNmeEmt" meta:resourcekey="str_flyQfdDmnNmeEmt" Visible="false">Fully Qualified Domain Name is empty</asp:Localize>
<asp:Localize runat="server" ID="LocFldLodIdpMtaDta" meta:resourcekey="str_fldLodIdpMtaDta" Visible="false">Failed to load IdP Meta Data (Federation Metadata Document)</asp:Localize>
<asp:Localize runat="server" ID="LocMsgIdpMtaDta" meta:resourcekey="str_msgIdpMtaDta" Visible="false">Missing IdP Metadata</asp:Localize>
<asp:Localize runat="server" ID="LocFldPrsIdpMtaDta" meta:resourcekey="str_fldPrsIdpMtaDta" Visible="false">Failed to parse IdP Metadata</asp:Localize>
    <nav class="navbar navbar-default navbar-fixed-top" role="navigation" style="display: none;">
        <div class="navbar-left">
            <asp:Label ID="ErrorMsg" runat="server" ForeColor="Red" meta:resourcekey="ErrorMsgResource1"></asp:Label>
        </div>
            <div class="container-fluid" style="padding-right: 30px;">
                <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize> 
                <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize> 
                        <asp:Button ID="EditBtn" runat="server" 
                            CausesValidation="False" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" 
                            Text="Edit" onclick="EditBtn_Click" 
                     meta:resourcekey="EditBtnResource1" ></asp:Button>  
                        <asp:Button ID="CancelBtn" runat="server" Visible="False"
                            CausesValidation="False" 
                            CssClass="btn  navbar-btn navbar-right btndlg" 
                            Text="Cancel" onclick="CancelBtn_Click" Width="108px" 
                     meta:resourcekey="CancelBtnResource1"></asp:Button>    
                            &nbsp;&nbsp;&nbsp;&nbsp; 
                        <asp:Button ID="ApplyBtn" runat="server" Visible="False"
                            CausesValidation="False" OnClick="ApplylNow_Click" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" meta:resourcekey="ApplylNowResource1" 
                            Text="Apply" Width="108px"></asp:Button>       
                            &nbsp;&nbsp;&nbsp;&nbsp;   
                <%
                    EditBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                    CancelBtn.OnClientClick = String.Format("Wait('{0}')", LocPlsWat.Text);
                    ApplyBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                %>
            </div>
            </nav>
    <%if (!IsChildUi){ %>
      <div style="width:100%; padding:5px;  " class="meubardrop">
            <table style="width:100%">
                <tr>
                    <td>
                        <button class="btn btn-primary gladbtn" style="font-weight:400!important; font-size:20px!important;"><asp:Localize runat="server" meta:resourcekey="str_SinSigOn">Single sign on</asp:Localize></button>
                    </td>
                    <td style="padding-right:10px;">
                    <div style="float:right; font-size:32px;  font-weight:100; cursor:pointer;" class="sectextcolor" onclick="ReturnLast();">&times;</div>
                </td>
                </tr>
            </table>
        </div>
    <%} %>
    <div class="wrapper" style="background-color: white; width:100%;margin-top: 30px;font-size: 18px;">
     <table width="100%"  style="max-width:1400px;" align="center">
         <tr>
             <td width="500px" style="padding: 15px;">
                 <asp:Label ID="Label1" runat="server" Text="Enable SAML Authentication" meta:resourcekey="str_eblSMLAth"></asp:Label>
                 <p class="text-muted"  style="font-size: smaller">
                     <asp:Localize meta:resourcekey="str_ssolink" runat="server">Access single sign on functionality using the following link:</asp:Localize><br/>
                     <span style="color:black"><asp:Label ID="LoginPageUrl" runat="server" Text="" ></asp:Label></span>  
                     <br/>
                     <asp:Localize meta:resourcekey="str_spmeta" runat="server">Access service provider meta data using the following link:</asp:Localize><br/>
                     <span style="color:black"><asp:Label ID="MetaDataUrl" runat="server" Text="" ></asp:Label></span>  
                 </p>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox ID="SAMLAuthentication" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>
         
         <tr>
             <td style="padding: 15px;">
                 <asp:Label ID="Label2" runat="server" Text="Add SSO link to login page" meta:resourcekey="str_addSsoLnkLgnPag"></asp:Label>
                                    <p class="text-muted" style="font-size: smaller">
                                        <asp:Localize meta:resourcekey="str_llink" runat="server">if this setting is unchecked, the login page will be redirected to the IdP login page directly</asp:Localize>
                                    </p>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox ID="AddSSOLink" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>
         <tr style="display: none;">
             <td style="padding: 15px;">
                 <asp:Label ID="Label3" runat="server" Text="Create User when User Doesn't Exist" meta:resourcekey="asp_crtUsrWhnDntExt"></asp:Label>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox ID="SAMLAutoCreateUser" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>
         <tr>
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="str_ssotext" runat="server">Display text for SSO link</asp:Localize>

                </td>
                <td style="padding: 15px;">
                    <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="SSOName" runat="server" Text="" CssClass="form-control"></asp:TextBox>
                     <asp:Label ID="LSSOName" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
                </td>
            </tr>

         <tr>
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="str_samlprovider" runat="server">SSO Provider</asp:Localize>

                </td>
                <td style="padding: 15px;">
                    <asp:DropDownList ID="SSOProviderList" runat="server" CssClass="browser-default custom-select secsubbordercolor" OnSelectedIndexChanged="SSOProviderList_SelectedIndexChanged" AutoPostBack="true"></asp:DropDownList>
                </td>
             
            </tr>

         <%if (SSOProviderList.SelectedIndex == 0) { %>
         <tr>
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="azuretenantid" runat="server">Azure AD Directory ID</asp:Localize>

                </td>
                <td style="padding: 15px;">
                     <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="AzureTenantID" runat="server" Text="" CssClass="form-control"></asp:TextBox>
                </td>
             
            </tr>
         <%}else if (SSOProviderList.SelectedIndex == 1) { %>
          <tr>
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="str_fqdn" runat="server">Fully Qualified Domain Name</asp:Localize>

                </td>
                <td style="padding: 15px;">
                     <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="ADFSFQDN" runat="server" Text="" CssClass="form-control"></asp:TextBox>
                </td>
             
            </tr>
         <%}else if (SSOProviderList.SelectedIndex == 2) { %>
         <tr>
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="str_idpurl" runat="server">IdP End Point URL</asp:Localize>
                    <p class="text-muted" style="font-size: smaller">
                        <asp:Localize meta:resourcekey="str_idpurlh" runat="server">URL of the Identity Provider that the Service Provider must contact.</asp:Localize>
                    </p>

                </td>
                <td style="padding: 15px;">
                    <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="SAMLUrl" runat="server" Text="" CssClass="form-control"></asp:TextBox>
                     <asp:Label ID="LSAMLUrl" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
                </td>
            </tr>
            
            <tr>
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="str_idpemail" runat="server">IdP Email Parameter</asp:Localize>
                    <p class="text-muted" style="font-size: smaller">
                        <asp:Localize meta:resourcekey="str_idpemailh" runat="server">Email Parameter Name in Identity Provider</asp:Localize>
                    </p>

                </td>
                <td style="padding: 15px;">
                    <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="SAMLEmail" runat="server" Text="" CssClass="form-control" ></asp:TextBox>
                     <asp:Label ID="LSAMLEmail" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
                </td>
            </tr>
            <tr>
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="str_idpfname" runat="server">IdP Given Name Parameter</asp:Localize>
                    <p class="text-muted" style="font-size: smaller">
                        <asp:Localize meta:resourcekey="str_idpfnameh" runat="server">Given Name Parameter Name in Identity Provider</asp:Localize>
                    </p>

                </td>
                <td style="padding: 15px;">
                    <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="SAMLFirstName" runat="server" Text="" CssClass="form-control"></asp:TextBox>
                     <asp:Label ID="LSAMLFirstName" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
                </td>
            </tr>
                <tr>
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="str_idpsname" runat="server">IdP Surname Parameter</asp:Localize>
                    <p class="text-muted" style="font-size: smaller">
                        <asp:Localize meta:resourcekey="str_idpsnameh" runat="server">SurName Parameter Name in Identity Provider</asp:Localize>
                    </p>

                </td>
                <td style="padding: 15px;">
                    <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="SAMLLastName" runat="server" Text="" CssClass="form-control" ></asp:TextBox>
                     <asp:Label ID="LSAMLLastName" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
                </td>
            </tr>            
            <tr>
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="str_idpm" runat="server">IdP Meta Data</asp:Localize>
                    <p class="text-muted" style="font-size: smaller">
                        <asp:Localize meta:resourcekey="str_idtPrvMetXml" runat="server">Identity Provider Metadata in XML Format</asp:Localize>
                    </p>

                </td>
                <td style="padding: 15px;">
                    <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="SAMLIDPMeta" runat="server" Text="" TextMode="MultiLine"  Height="300px" CssClass="form-control"></asp:TextBox>
                     <asp:Label ID="LSAMLIDPMeta" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
                </td>
            </tr>
            <%}%>
        
        </table>
    </div>
    <asp:Localize ID="NOTConfig"  meta:resourcekey="str_notconfiged" runat="server" Visible="False">Not Configured</asp:Localize>
    <div style="display: none;">
        <asp:CheckBox onclick="ShowSavePanel();" ID="ShowSecurityOption" runat="server" Text="Show 'Security' Option."
                                    meta:resourcekey="ShowSecurityOption" /><br />
                                <p style="font-size: 12px; color: #808080; margin-left: 16px;">
                                    <asp:Localize ID="Localize2" meta:resourcekey="asp_string6_1" runat="server" Text="When this setting is checked, you will be able to grant normal user permissions to manage certain parts of the tenant"></asp:Localize></p>
    </div>
    <asp:Localize meta:resourcekey="str_failedapply" ID="FailedApply" runat="server" Visible="False">Failed to apply changes</asp:Localize>
     <% if (!string.IsNullOrEmpty(ErrorMsg.Text)){ %>
        <script type="text/javascript">
            Ext.onReady(function () {
                            gWMsgBox("<%=ErrorMsg.Text%>");
            ShowSavePanel();

            });
        </script>
    <% } %>
</asp:Content>
