﻿<%@ Page Title="Gladinet Cloud Cluster" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="ClusterCfg.aspx.cs" Inherits="GladinetPayFlow.ClusterCfg"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .pricetable {
            border: 1px solid #cccccc;
        }

        .plain9BlackOnNone {
            border-bottom: 1px solid #cccccc;
            border-right: 1px solid #cccccc;
        }

        .offer_flex {
            background: #FFFFE0 url('images/giftbox.png') no-repeat 8px center;
            border: 1px solid #E6DB55;
            border-radius: 4px 4px 4px 4px;
            color: #000000;
            height: 54px;
            line-height: 18px;
            padding: 2px;
            padding-left: 16px;
            width: 868px;
            vertical-align: middle;
            text-align: center;
            margin: auto;
            margin-bottom: 16px;
        }

        li {
            padding-right: 10px;
        }

        .offertitle {
            line-height: 24px;
        }

        .offertext {
            line-height: 20px;
        }

        .offer_flex1 {
            border: 1px solid #E6DB55;
            border-radius: 4px 4px 4px 4px;
            margin: auto;
        }

        .whitehead {
            background-color: white !important;
        }
    </style>
    <script type="text/javascript">



        function SetPage(p) {
            var e = document.getElementById("page_1");
            e.className = "gladtab_lg_inactive";

            e = document.getElementById("page_2");
            e.className = "gladtab_lg_inactive";

            e = document.getElementById("page_3");
            e.className = "gladtab_lg_inactive";

            e = document.getElementById("page_4");
            if(e)
                e.className = "gladtab_lg_inactive";

            e = document.getElementById("page_5");
            e.className = "gladtab_lg_inactive";

            e = document.getElementById("page_6");
            if(e)
                e.className = "gladtab_lg_inactive";

            e = document.getElementById("page_7");
            e.className = "gladtab_lg_inactive";


            e = document.getElementById("page_1_div");
            e.style.display = "none";

            e = document.getElementById("page_2_div");
            e.style.display = "none";

            e = document.getElementById("page_3_div");
            e.style.display = "none";

            e = document.getElementById("page_4_div");
            e.style.display = "none";

            e = document.getElementById("page_5_div");
            e.style.display = "none";

            e = document.getElementById("page_6_div");
            e.style.display = "none";

            e = document.getElementById("page_7_div");
            e.style.display = "none";

            e = document.getElementById("page_" + p);
            e.className = "gladtab_lg_active";


            e = document.getElementById("page_" + p + "_div");
            e.style.display = "";
            if (p == 5) {
                LockDBConn();
                LockDBConnRO();                                                              
            }

        }

        function OnSaveChanges() {
            Wait("Please wait...");
            var btn = document.getElementById('ctl00_MainContent_SaveSettingsNow');
            btn.click();

        }
        function hideObj(id) {
            document.getElementById(id).style.display = "none";
        }
        function showObj(id, optDspVal) {
            document.getElementById(id).style.display = "block";
            if (optDspVal!="skip") {
                document.getElementById(id).value = $('<div>').html(optDspVal).text();
            }
        }
        function EditDBConn() {
            hideObj("LogginDBConnStringDisplay");
            showObj("<%=LogginDBConnString.ClientID%>","skip");
            FocusAtTheEndOfString("<%=LogginDBConnString.ClientID%>");
        }
        function LockDBConn() {
            hideObj("<%=LogginDBConnString.ClientID%>");
            showObj("LogginDBConnStringDisplay", GenerateDummyTextFromField("<%=LogginDBConnString.ClientID%>"));
        }
        function EditDBConnRO() {
            hideObj("LogginDBConnROStringDisplay");
            showObj("<%=ReadOnlyLogginDBConnString.ClientID%>","skip");
            FocusAtTheEndOfString("<%=ReadOnlyLogginDBConnString.ClientID%>");
        }
        function LockDBConnRO() {
            hideObj("<%=ReadOnlyLogginDBConnString.ClientID%>");
            showObj("LogginDBConnROStringDisplay", GenerateDummyTextFromField("<%=ReadOnlyLogginDBConnString.ClientID%>"));
        }
        function FocusAtTheEndOfString(id){
            var obj = document.getElementById(id);
            obj.focus();
            try{
                obj.selectionStart = obj.selectionEnd = obj.value.length;
            }catch(ex){}
        }
        function GenerateDummyTextFromField(id) {
            var str = document.getElementById(id).value;
            var dummy = "";
            for (var i = 0; i < str.length; i++) {
                dummy += "&bull;";
            }
            return dummy;
        }
        function ConfirmModal(){
            top.location.reload(true);
        }
        function CancelConfirmModal(){
            $('#myConfirmModel').modal('hide');
        }  
        function ShowTenantMgrOption() {
            if ($('#<%=MultiTenant.ClientID %>').is(":checked")) {
                $('#trShowTenantMgrFirst').show();
            } else {
                $('#<%=ShowTenantMgrFirst.ClientID %>').prop('checked', false);  
                $('#trShowTenantMgrFirst').hide();
            }
        }
    </script>

</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Localize ID="LocNoDft" meta:resourcekey="str_noDft" runat="server" Visible="false">No default</asp:Localize>
    <asp:Localize ID="LocChgSvdScs" meta:resourcekey="str_chgSvdScs" runat="server" Visible="false">Changes saved successfully</asp:Localize>
    <asp:Localize ID="LocMsgBrdId" meta:resourcekey="str_msgBrdId" runat="server" Visible="false">Missing branding ID</asp:Localize>


    <div width="100%" style="background-color: white; border: 0px; padding-bottom: 0px; align-content: right; border-bottom: 0px solid #c0c0c0;">
        <table width="100%" style="border-collapse: collapse;" cellpadding="0" cellspacing="0">
            <tr>

                <td style="width: 10px; border-bottom: 1px solid #cccccc;">&nbsp;</td>
                <td align="left" style="padding: 0px; width: 100px;">
                    <table style="border-collapse: collapse;" cellpadding="0" cellspacing="0">
                        <tr>
                            <td style="padding-top: 10px;" valign="bottom">
                                <div class="gladtab_lg_active" id="page_1" onclick="SetPage(1);return false;">
                                    <asp:Localize ID="Localize1" meta:resourcekey="asp_string1" runat="server">Cluster Settings</asp:Localize>
                                </div>
                            </td>
                            <td style="padding-top: 10px;" valign="bottom">
                                <div class="gladtab_lg_inactive" id="page_2" onclick="SetPage(2);return false;">
                                    <asp:Localize runat="server" meta:resourcekey="str_pfmAndThg">Performance and Throttling</asp:Localize>
                                </div>
                            </td>
                            <td style="padding-top: 10px;" valign="bottom">
                                <div class="gladtab_lg_inactive" id="page_7" onclick="SetPage(7);return false;">
                                    <asp:Localize runat="server" meta:resourcekey="str_timeouts">Timeouts and Limits</asp:Localize>
                                </div>
                            </td>

                            <td style="padding-top: 10px;" valign="bottom">
                                <div class="gladtab_lg_inactive" id="page_3" onclick="SetPage(3);return false;">
                                    <asp:Localize meta:resourcekey="str_langs" runat="server">Languages</asp:Localize>
                                </div>
                            </td>
                            <%if (!IsServo){ %>
                            <td style="padding-top: 10px;" valign="bottom">
                                <div class="gladtab_lg_inactive" id="page_4" onclick="SetPage(4);return false;">
                                    <asp:Localize meta:resourcekey="str_branding" runat="server">Branding</asp:Localize>
                                </div>
                            </td>
                            <%} %>
                            <td style="padding-top: 10px;" valign="bottom">
                                <div class="gladtab_lg_inactive" id="page_5" onclick="SetPage(5);return false;">
                                    <asp:Localize meta:resourcekey="str_changelog" runat="server">Change Log</asp:Localize>
                                </div>
                            </td>
                             <%if (!IsServo){ %>
                            <td style="padding-top: 10px;" valign="bottom">
                                <div class="gladtab_lg_inactive" id="page_6" onclick="SetPage(6);return false;">
                                    <asp:Localize runat="server" meta:resourcekey="str_licStr">License String</asp:Localize>
                                </div>
                            </td>
                            <%} %>
                        </tr>
                    </table>
                </td>
                <td style="border-bottom: 1px solid #cccccc;">
                    &nbsp;
                </td>
            </tr>
        </table>
    </div>
    <div style="overflow: auto" id="maincontenttable">
        <table width="100%" style="margin: 0px; padding: 8px;" align="center"
            valign="top">
            <tr>
                <td valign="top" style="background-color: white; padding: 10px; padding-top: 30px;">
                    <table width="100%" style="height: 98%; padding: 8px;" cellspacing="0" cellpadding="0">
                        <tr>
                            <td valign="top">

                                <%if (!string.IsNullOrEmpty(ErrorMsg.Text))
                                    { %>
                                <div>
                                    <asp:Label ID="ErrorMsg" runat="server" CssClass="errmsg" meta:resourcekey="ErrorMsgResource1" ForeColor="red"></asp:Label>
                                </div>
                                <%} %>
                                <div id="page_1_div">
                                    <table width="100%">
                                        <tr>
                                            <td style="padding: 5px">
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="HideLoginErrorMsg" runat="server" Text="Hide login failure message details"
                                                    ForeColor="#009000" meta:resourcekey="HideLoginErrorMsgResource1" />
                                            </td>
                                        </tr>
                                         <tr>
                                            <td style="padding: 5px">
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="HideBuildNumber" runat="server" Text="Hide build number from login page" meta:resourcekey="asp_hidBldNum" ForeColor="#009000" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px">
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="HideSupportButton" runat="server" Text="Hide support button"
                                                    ForeColor="#009000" meta:resourcekey="HideSupportBtnRes" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px">
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="HideFogetPwd" runat="server" Text="Hide 'Forgot your password' link on login page"
                                                    ForeColor="#009000" meta:resourcekey="HideFogetPwdResource1" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px">
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="NoRetryLogin" runat="server" Text="Don't retry when login failed"
                                                    ForeColor="#009000" meta:resourcekey="NoRetryLoginResource1" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px">
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="AlwaysShowCAPTCHA" runat="server" meta:resourcekey="str_alwShwCha" Text="Always display CAPTCHA on the web portal login page" ForeColor="#009000" />
                                            </td>
                                        </tr>
                                        <%if(!IsCSBizEx && !IsServo){ %>
                                        <tr>
                                            <td style="padding: 5px">
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="UseClassicUI" runat="server" Text="Show Classic UI" meta:resourcekey="str_shoClaUI"
                                                    ForeColor="#009000" />
                                            </td>
                                        </tr>
                                        
                                        
                                        <tr>
                                            <td style="padding: 5px">
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="ShowNodeHostName" runat="server" Text="Show the host name of the current node on the login page" meta:resourcekey="str_shwNdeHstNme" ForeColor="#009000" />
                                            </td>
                                        </tr>
                                       

                                        <tr style="display:none;">
                                            <td style="padding: 5px">
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="EnablePolicy" runat="server" Text="Enable Content Management Policies"
                                                    ForeColor="#009000" meta:resourcekey="EnablePolicyResource1" />
                                            </td>
                                        </tr>
                                        

                                        
                                        <tr>
                                            <td style="padding: 5px">
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="MultiDomain" runat="server" Text="Enable Multiple AD Domain Support"
                                                    ForeColor="#009000" meta:resourcekey="MultiDomainResource1" />
                                            </td>
                                        </tr>

                                        <tr>
                                            <td style="padding: 5px">
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="TwoFactor" runat="server" Text="Turn on 2-step Verification" ForeColor="#009000" Checked="true"
                                                    meta:resourcekey="TwoFactorResource1" />
                                            </td>
                                        </tr>
                                         <tr>
                                            <td style="padding: 5px">
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="ShowIconView" runat="server" Text="Use IconView as default web file browser view" meta:resourcekey="asp_useIcnViwDft" Checked="True" ForeColor="#009000" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px">
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="UseLinkToAttach" Checked="true" runat="server" meta:resourcekey="str_athLclFldUsnIpcVrsFld" Text="Attach local folder using in-place versioned folder" ForeColor="#009000" />
                                            </td>
                                        </tr>
                                         <tr>
                                            <td style="padding: 5px">
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="ShowClusterNetworkShare" runat="server" meta:resourcekey="str_shwIptNwkShrCtrDsh" Text="Show 'Import Network Share' on cluster dashboard" ForeColor="#009000" />
                                            </td>
                                        </tr>

                                        <%} %>
                                        <%if(!IsServo && !UseClassicUI.Checked){ %>
                                        <tr>
                                            <td style="padding: 5px">
                                                <asp:CheckBox onclick="ShowTenantMgrOption();ShowSavePanel();" ID="MultiTenant" Checked="true" runat="server" Text="Allow multi-tenancy"  meta:resourcekey="str_allMulTen"
                                                    ForeColor="#009000" />
                                            </td>
                                        </tr>
                                        <tr id="trShowTenantMgrFirst">
                                            <td style="padding:5px 5px 5px 30px">
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="ShowTenantMgrFirst" Checked="true" runat="server" meta:resourcekey="str_shoTenManScrAftLogIn" Text="Show tenant management screen after logging in"
                                                    ForeColor="#009000" />
                                            </td>
                                        </tr>
                                        <%} %>
                                        <tr>
                                            <td style="padding: 5px">
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="ShowDelUserStorage" runat="server" Text="Show 'purge storage option' when delete user"
                                                    ForeColor="#009000" meta:resourcekey="ShowDelUserStorageResource1" />
                                            </td>
                                        </tr>
                                        
                                        
                                        <tr>
                                            <td style="padding: 5px">
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="NoPurgeTrashNotification" runat="server" Text="Don't send email notification to user when purge deleted content" meta:resourcekey="asp_dntSndEmlToUsr" ForeColor="#009000" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px">
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="NoPurgeTrashNotificationAdmin" runat="server" Text="Don't send email notification to admin when purge deleted content" meta:resourcekey="asp_dntSndEmlToAdm" ForeColor="#009000" />
                                            </td>
                                        </tr>

                                       
                                        <tr style="display:none;">
                                            <td style="padding: 5px">
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="UseGhostScript" runat="server" Text="Use Ghost Script to generate PDF preview" meta:resourcekey="asp_useGhost" ForeColor="#009000" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px; display:none;">
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="DisablePreviewOptimization" runat="server" Text="Disable preview optimization" meta:resourcekey="asp_disablePreviewOpt"  ForeColor="#009000" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px;display:none;">
                                                <asp:CheckBox onclick="ShowSavePanel();"  checked="true" ID="UseBrowserPDF" runat="server" Text="Preview pdf files with browser builtin viewer" meta:resourcekey="asp_useBrowserPDF" ForeColor="#009000" />
                                            </td>
                                        </tr>

                                        <tr>
                                            <td style="padding: 5px">
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="ThirdPartyAvarta" runat="server" Text="Retrieve avatar from third party service (ie. Google)" meta:resourcekey="asp_rtvAvt" ForeColor="#009000" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px">
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="HideFileExt" runat="server" Text="Hide file extension in web file browser" meta:resourcekey="asp_hidFilExt" ForeColor="#009000" />
                                            </td>
                                        </tr>

                                        <tr>
                                            <td style="padding: 5px">
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="DisableWinAutoLogon" runat="server" Text="Disable Windows Client Auto-Logon" meta:resourcekey="asp_disWinCltLgn" ForeColor="#009000" />
                                            </td>
                                        </tr>
                                        <tr style="display:none;">
                                            <td style="padding: 5px">
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="UserShortUrl" Checked="True" runat="server" Text="User short url" meta:resourcekey="asp_useShortUrl" ForeColor="#009000" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px;">
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="PersonalTag" runat="server" meta:resourcekey="str_alwPrsDtaTgn" Text="Allow personal data tagging" ForeColor="#009000" />
                                            </td>
                                        </tr>
                                        
                                        <tr>
                                            <td style="padding: 5px">
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="LocalPerfCounterOnly" runat="server" meta:resourcekey="str_olyAlwAcsPrfInfFrmLclHst" Text="Only allow access performance information from local host" ForeColor="#009000" />
                                            </td>
                                        </tr>      
                                        <% if (!IsServo) { %>
                                        <tr>
                                            <td style="padding: 5px">
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="AllowTenantAdminTeamFolderBackups" runat="server" Checked="true" meta:resourcekey="str_allTenAdmEnaTeaFolBac" Text="Allow tenant administrators to enable Team Folder backups" ForeColor="#009000" />
                                            </td>
                                        </tr>
                                        <% } %>
                                        

                                        <asp:Panel ID="EnhancedTicket" runat="server" meta:resourcekey="EnhancedTicketResource1">
                                            <tr>
                                                <td style="padding: 5px; padding-top: 20px">
                                                    <asp:CheckBox onclick="ShowSavePanel();" ID="UseEnahancedTicket" runat="server" Text="Use Enhanced Ticket" ForeColor="#009000"
                                                        meta:resourcekey="UseEnahancedTicketResource1" />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td style="padding: 35px" class='idea_flex'>
                                                    <p>
                                                        <asp:Localize runat="server" meta:resourcekey="str_ecdTktPar1">Enhanced-Ticket is more secure with stronger encryption. However, it is not compatible with old access ticket.</asp:Localize>
                                                    </p>
                                                    <p>
                                                        <asp:Localize runat="server" meta:resourcekey="str_ecdTktPar2">To use the new ticket, you will need to restart each worker node and web node to take the new setting after switching to the enhanced-ticket mode. All existing session user needs to log off and log back in from web portal, desktop and mobile clients.</asp:Localize>

                                                    </p>
                                                </td>
                                            </tr>
                                        </asp:Panel>
                                    </table>
                                </div>
                                <div id="page_7_div" style="display: none;">
                                    <table width="100%">
                                        <tr>
                                            <td style="padding: 5px">
                                                <table>
                                                    <tr>
                                                        <td>
                                                            <label>
                                                                <asp:Localize runat="server" meta:resourcekey="str_webBrsSesTmt">Web Browser Session Timeout (minutes, 0 - never timeout):</asp:Localize></label>
                                                        </td>
                                                        <td>
                                                            <asp:TextBox onkeypress="ShowSavePanel();" onchange="ShowSavePanel();" ID="WebSessionTimeOut" runat="server" Width="100px" CssClass="form-control"
                                                                Text="120"></asp:TextBox>

                                                        </td>
                                                    </tr>
                                                </table>

                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px">
                                                <table>
                                                    <tr>
                                                        <td>
                                                            <label>
                                                                <asp:Localize runat="server" meta:resourcekey="str_ntvCltTknTmt">Native Client Token Timeout (days, 0 - never timeout):</asp:Localize></label>
                                                        </td>
                                                        <td>
                                                            <asp:TextBox onkeypress="ShowSavePanel();" onchange="ShowSavePanel();" ID="TokenTimeOut" runat="server" Width="100px" CssClass="form-control"
                                                                Text="15"></asp:TextBox>

                                                        </td>
                                                    </tr>
                                                </table>

                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px">
                                                <table>
                                                    <tr>
                                                        <td>
                                                            <label>
                                                                <asp:Localize runat="server" meta:resourcekey="str_ntvMobTknTmt">Mobile Client Token Timeout (days, 0 - never timeout):</asp:Localize></label>
                                                        </td>
                                                        <td>
                                                            <asp:TextBox onkeypress="ShowSavePanel();" onchange="ShowSavePanel();" ID="MobTokenTimeOut" runat="server" Width="100px" CssClass="form-control"
                                                                Text="15"></asp:TextBox>

                                                        </td>
                                                    </tr>
                                                </table>

                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px">
                                                <table>
                                                    <tr>
                                                        <td>
                                                            <label>
                                                                <asp:Localize runat="server" meta:resourcekey="str_dsbLckIdlTmt">Distributed Lock Idle Timeout (minutes, 0 - never timeout):</asp:Localize></label>
                                                        </td>
                                                        <td>
                                                            <asp:TextBox onkeypress="ShowSavePanel();" onchange="ShowSavePanel();" ID="LockTimeOut" runat="server" Width="100px" CssClass="form-control"
                                                                Text="15"></asp:TextBox>

                                                        </td>
                                                    </tr>
                                                </table>

                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px">
                                                <table>
                                                    <tr>
                                                        <td>
                                                            <label>
                                                                <asp:Localize meta:resourcekey="str_sharenmin" runat="server">Send shared file change notification every n minutes(0 - send immediately)</asp:Localize></label>
                                                        </td>
                                                        <td>
                                                            <asp:TextBox onkeypress="ShowSavePanel();" onchange="ShowSavePanel();" ID="ShareChangeInterval" runat="server" Width="100px" CssClass="form-control"
                                                                Text="5"></asp:TextBox>

                                                        </td>
                                                    </tr>
                                                </table>

                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px">
                                                <table>
                                                    <tr>
                                                        <td>
                                                            <label>
                                                                <asp:Localize runat="server" meta:resourcekey="str_opnTrdPtyApp">Open third party web application in new window when the height of the web browser is less than</asp:Localize></label>
                                                        </td>
                                                        <td>
                                                            <asp:TextBox onkeypress="ShowSavePanel();" onchange="ShowSavePanel();" ID="NewWindowThreshold" runat="server" Width="100px" CssClass="form-control"
                                                                Text="0"></asp:TextBox>

                                                        </td>
                                                    </tr>
                                                </table>

                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px">
                                                <table>
                                                    <tr>
                                                        <td>
                                                            <label>
                                                                <asp:Localize runat="server" meta:resourcekey="str_maxDvcCnt">Maximum Device Count (Concurrent Device Count) for Each User (0-Unlimited):</asp:Localize></label>
                                                        </td>
                                                        <td>
                                                            <asp:TextBox onkeypress="ShowSavePanel();" onchange="ShowSavePanel();" ID="MaxTokenCount" runat="server" Width="100px" CssClass="form-control" meta:resourcekey="asp_maxTknCnt" Text="0"></asp:TextBox>

                                                        </td>
                                                    </tr>
                                                </table>

                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px">
                                                <table>
                                                    <tr>
                                                        <td>
                                                            <label>
                                                                <asp:Localize runat="server" meta:resourcekey="str_purgeStaleDevice">Purge Device Entry n Days After Device Disconnected  (0 - let system decides):</asp:Localize>

                                                            </label>
                                                        </td>
                                                        <td>
                                                            <asp:TextBox onkeypress="ShowSavePanel();" onchange="ShowSavePanel();" ID="StaleDevicePurgeDays" runat="server" Width="100px" CssClass="form-control" meta:resourcekey="asp_maxTknCnt" Text="0"></asp:TextBox>

                                                        </td>
                                                    </tr>
                                                </table>

                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px">
                                                <table>
                                                    <tr>
                                                        <td>
                                                            <label>
                                                                <asp:Localize runat="server" meta:resourcekey="str_maxFilSrcRes">Maximum file search results:</asp:Localize>

                                                            </label>
                                                        </td>
                                                        <td>
                                                            <asp:TextBox onkeypress="ShowSavePanel();" onchange="ShowSavePanel();" ID="MaxSearchResults" runat="server" Width="100px" CssClass="form-control" Text="25"></asp:TextBox>

                                                        </td>
                                                    </tr>
                                                </table>

                                            </td>
                                        </tr>
                                    </table>
                                </div>
                                <div id="page_2_div" style="display: none;">
                                    <table width="100%">
                                        <tr>
                                            <td style="padding: 5px; font-size: 16px; font-weight: 100; color: #565656;">
                                                <asp:Localize runat="server" meta:resourcekey="str_dntShwFilIcn">Don't show file icon preview if file size is larger than (KB, 0-No icon preview)</asp:Localize>
                                                <asp:TextBox onkeypress="ShowSavePanel();" onchange="ShowSavePanel();" ID="PreviewThreshold" runat="server" Width="100px" CssClass="form-control"
                                                    Text="5000" meta:resourcekey="WebSessionTimeOutResource1"></asp:TextBox>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px; font-size: 16px; font-weight: 100; color: #565656;">
                                                <asp:Localize runat="server" meta:resourcekey="str_cltWidUplLim">Cluster Wide Upload Bandwidth Limit (Per Worker Node, KB/Sec, 0-No Limit)</asp:Localize>
                                                <asp:TextBox onkeypress="ShowSavePanel();" onchange="ShowSavePanel();" ID="ClusterUploadKB" runat="server" Width="100px" CssClass="form-control"
                                                    Text="0" meta:resourcekey="WebSessionTimeOutResource1"></asp:TextBox>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px; font-size: 16px; font-weight: 100; color: #565656;">
                                                <asp:Localize runat="server" meta:resourcekey="str_cltWidDldLim">Cluster Wide Download Bandwidth Limit (Per Worker Node, KB/Sec)</asp:Localize>
                                                <asp:TextBox onkeypress="ShowSavePanel();" onchange="ShowSavePanel();" ID="ClusterDownloadKB" runat="server" Width="100px" CssClass="form-control"
                                                    Text="0" meta:resourcekey="WebSessionTimeOutResource1"></asp:TextBox>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px; font-size: 16px; font-weight: 100; color: #565656;">
                                                <asp:Localize meta:resourcekey="str_ziplimit" runat="server">Size limit for folder download (MB, 0-no limit)</asp:Localize>
                                                <asp:TextBox onkeypress="ShowSavePanel();" onchange="ShowSavePanel();" ID="ZipDownloadSize" runat="server" Width="100px" CssClass="form-control"
                                                    Text="1500"></asp:TextBox>
                                            </td>
                                        </tr>


                                    </table>
                                </div>
                                <div id="page_3_div" style="display: none;">
                                    <table>
                                        <tr>
                                            <td>
                                                <asp:Localize runat="server" meta:resourcekey="str_aldLng">Allowed Languages:</asp:Localize>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="zhCN" runat="server" Text="(Beta) Chinese (Simplified) - 简体中文" meta:resourcekey="zhCNResource1" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="zhTW" runat="server" Text="(Beta) Chinese (Traditional) - 繁体中文"
                                                    meta:resourcekey="zhTWResource1" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="deCH" runat="server" Text="(Beta) German (Switzerland) - Deutsch (Schweiz)"
                                                    meta:resourcekey="deCHResource1" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="de" runat="server" Text="(Beta) German - Deutsch" meta:resourcekey="deResource1" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="fr" runat="server" Text="(Beta) French - français" meta:resourcekey="frResource1" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="frCH" runat="server" Text="(Beta) French (Switzerland) - français (Suisse)"
                                                    meta:resourcekey="frCHResource1" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="it" runat="server" Text="(Beta) Italian - italiano" meta:resourcekey="itResource1" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="itCH" runat="server" Text="(Beta) Itanlian (Switzerland) - italiano (Svizzera)"
                                                    meta:resourcekey="itCHResource1" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="nl" runat="server" Text="(Beta) Dutch - Nederland" meta:resourcekey="nlResource1" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="nlNL" runat="server" Text="(Beta) Dutch (Netherlands) - Nederlands (Nederland)"
                                                    meta:resourcekey="nlNLResource1" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding-top: 20px;">
                                                <asp:Localize runat="server" meta:resourcekey="str_ctrWidDefLng">Cluster Wide Default Languages:</asp:Localize>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:DropDownList ID="LanguageSelect" runat="server" onchange="ShowSavePanel();" AutoPostBack="false" Width="200px" CssClass="browser-default custom-select secsubbordercolor">
                                                </asp:DropDownList>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                                <div id="page_4_div" style="display: none;">
                                    <table width="100%">
                                        <tr>
                                            <td style="padding: 5px">
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="NoTVideo" runat="server" Text="Don't Show Tutorial Videos" meta:resourcekey="asp_dntShwTutVid" ForeColor="#009000" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px" style="display: none;">
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="EnableTenantBranding" runat="server" Text="Enable Tenant Branding" Checked
                                                    ForeColor="#009000" meta:resourcekey="EnableTenantBrandingResource1" />
                                            </td>
                                        </tr>
                                        <tr style="display: none;">
                                            <td style="padding: 5px">
                                                <asp:CheckBox onclick="ShowSavePanel();" ID="OnlyAllowBrandedClient" runat="server" Text="Only allow branded client to access"
                                                    ForeColor="#009000" meta:resourcekey="OnlyAllowBrandedClientResource1" />
                                            </td>
                                        </tr>
                                        <tr style="display: none;">
                                            <td style="padding: 5px; font-size: 16px; font-weight: 100; color: #565656;">
                                                <asp:Localize runat="server" meta:resourcekey="str_brdId">Branding Id:</asp:Localize><br />
                                                <asp:TextBox onkeypress="ShowSavePanel();" onchange="ShowSavePanel();" ID="BrandingClientId" runat="server" Width="90%" CssClass="form-control"
                                                    meta:resourcekey="BrandingClientIdResource1"></asp:TextBox>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                                <div id="page_5_div" style="display: none;">
                                    <table width="100%">
                                        <tr>
                                            <td style="padding: 5px; font-size: 16px; font-weight: 100; color: #565656;">
                                                <asp:Localize runat="server" meta:resourcekey="str_kepFilChgLog">Keep file change log for n days.</asp:Localize>
                                                <asp:TextBox onkeypress="ShowSavePanel();" onchange="ShowSavePanel();" ID="FileChangeLogDays" runat="server" Width="100px" CssClass="form-control"
                                                    Text="15"></asp:TextBox>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px"></td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px; font-size: 16px; font-weight: 100; color: #565656;">
                                                <asp:Localize runat="server" meta:resourcekey="str_emlAdr">Email Address to Receive Cloud Monitor Messages:</asp:Localize><br />
                                                <asp:TextBox onkeypress="ShowSavePanel();" onchange="ShowSavePanel();" ID="CloudMonEmail" runat="server" Width="90%" CssClass="form-control"
                                                    meta:resourcekey="CloudMonEmailResource1"></asp:TextBox>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px; font-size: 16px; font-weight: 100; color: #565656;">
                                                <asp:Localize runat="server" meta:resourcekey="str_logDbCon">Logging DB Connection String:</asp:Localize><br />
                                                <asp:TextBox onkeypress="ShowSavePanel();" onchange="ShowSavePanel();" ID="LogginDBConnString" runat="server" Width="90%" CssClass="form-control"
                                                    meta:resourcekey="LogginDBConnStringResource1" style="display:none;" onblur="LockDBConn();"></asp:TextBox>

                                                <input id="LogginDBConnStringDisplay" type="text" class="form-control" onfocus="EditDBConn();" style="width:90%;" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px; font-size: 16px; font-weight: 100; color: #565656;">
                                                <asp:Localize runat="server" meta:resourcekey="str_logDbConRedOlyRpc">Logging DB Connection String (Read-only Replica):</asp:Localize><br />
                                                <asp:TextBox onkeypress="ShowSavePanel();" onchange="ShowSavePanel();" ID="ReadOnlyLogginDBConnString" runat="server" Width="90%" CssClass="form-control"
                                                    meta:resourcekey="LogginDBConnStringResource1" onblur="LockDBConnRO();"></asp:TextBox>

                                                <input id="LogginDBConnROStringDisplay" type="text" class="form-control" onfocus="EditDBConnRO();" style="width:90%;" />
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                                <div id="page_6_div" style="display: none;">
                                    <table width="100%">
                                        <tr>
                                            <td style="padding: 5px; font-size: 18px; font-weight: 100; color: #565656;">
                                                <asp:Localize runat="server" meta:resourcekey="str_licStr2">License String:</asp:Localize><br />
                                                <asp:TextBox onkeypress="ShowSavePanel();" onchange="ShowSavePanel();" ID="LicenseString" runat="server" Width="90%" CssClass="form-control"
                                                    meta:resourcekey="LicenseStringResource1"></asp:TextBox>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="font-size:18px; color:#565656; font-weight:100;">
                                                <asp:Localize runat="server" meta:resourcekey="str_licUserCount">User Count:</asp:Localize>
                                                <span class="badge btn-success">
                                                 <asp:Label ID="LicUserCount" runat="server" Text=""></asp:Label></span>
                                                &nbsp;&nbsp;<asp:Localize runat="server" meta:resourcekey="str_licExpiration">License Expiration:</asp:Localize>
                                                <span class="badge btn-success">
                                                    <asp:Label ID="LicExpiration" runat="server" Text=""></asp:Label></span>
                                                            &nbsp;&nbsp;<asp:Localize runat="server" meta:resourcekey="str_licTo">Licensed To:</asp:Localize>
                                                <span class="badge btn-success">
                                                    <asp:Label ID="LicTo" runat="server" Text=""></asp:Label></span>

                                            </td>
                                        </tr>
                                    </table>
                                </div>


                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr style="display: none;">
                <td>
                    <nav class="navbar navbar-default navbar-fixed-top" role="navigation" style="display: none;">
                        <div class="container-fluid" style="padding-right: 30px;">
                            <asp:Button ID="SaveSettingsNow" runat="server" Text="Apply"
                                OnClick="OnContinueClick" OnClientClick="showLoader(this.parentNode)" CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg"
                                meta:resourcekey="LinkButton3Resource1"></asp:Button>
                        </div>
                    </nav>
                </td>
            </tr>
        </table>
    </div>


    <div id="myConfirmModel" class="modal fade" role="dialog">
        <div class="modal-dialog modal-vertical-centered" style="max-width: 400px;">

            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header" style="display: none;">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <span style="color: #808080; font-size: 24px;" class="fa fa-exclamation-sign"></span>
                </div>
                <div class="modal-body" style="overflow: auto; align-content: center;">
                    <table width="100%">
                        <tr>
                            <td align="center" style="overflow: auto; padding-bottom: 5px; padding-top: 10px; " valign="middle">
                                <span style="color: #565656; font-size: 16px; font-weight: 100;" id='ConfirmTitle'>
                                    <asp:Localize runat="server" meta:resourcekey="str_rldReq">Reload Required</asp:Localize>
                                </span>
                                <br />
                                <span id="ConfirmBody" style="font-weight: 100; padding-top: 30px; font-size: 14px; color: #808080;" align="center" valign="middle">
                                    <asp:Localize runat="server" meta:resourcekey="str_rldReqHlp">A page reload is required in order for you to see the new changes.</asp:Localize>
                                </span>
                            </td>
                        </tr>
                    </table>
                </div>
                <div class="modal-footer" style="border-top: 0px solid #d0d0d0;">
                    <table width="100%">
                        <tr style="border-top: 0px solid #d0d0d0;">
                            <td  height="3px">&nbsp;</td>
                        </tr>
                        <tr>
                            <td  style="border-right: 0px solid #d0d0d0; padding-right:10px;" align="right">
                                <button id="myConfirmPrcBtn" type="button" class="btn btn-link sectextcolor" onclick="ConfirmModal();" style=" font-weight: 400; font-size: 16px;"><asp:Localize runat="server" meta:resourcekey="str_prc">Proceed</asp:Localize></button>
                                <button id="myConfirmCnlBtn" type="button" class="btn btn-link" style=" font-weight: 400; font-size: 16px;" onclick="CancelConfirmModal();"><asp:Localize runat="server" meta:resourcekey="str_cnl">Cancel</asp:Localize></button>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>


    <script type="text/javascript">


        function AdjustSize() {

            var f = document.getElementById('maincontenttable');
            f.style.height = (document.documentElement.clientHeight - 160) + "px";
            f.style.marginTop = "8px";
        }


        Ext.onReady(function () {
            AdjustSize();
 <% if (!string.IsNullOrEmpty(ErrorMsg.Text))
        { %>
            gWMsgBox("<%=ErrorMsg.Text%>");
            //ShowSavePanel();

            <% } %>
            
            <asp:Literal ID="ltlRedirScrp" runat="server" />
        });

        Ext.EventManager.onWindowResize(function () {
            AdjustSize();
        });




    </script>
</asp:Content>
