﻿<%@ Page Title="Backup Manager" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="ClusterBackupMgr.aspx.cs" Inherits="GladinetPayFlow.ClusterBackupMgr" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .style1
        {
            width: 388px;
        }
        
        .style2
        {
            min-width: 16px;
            text-align: center;
        }
        
        .pricetable
        {
            border: 1px solid #cccccc;
        }
        
        .plain9BlackOnNone
        {
            border-bottom: 1px solid #cccccc;
            border-right: 1px solid #cccccc;
        }
        .style3
        {
            border-bottom: 1px solid #cccccc;
            border-right: 1px solid #cccccc;
            width: 121px;
        }
        
        .main1 {
            background-image: url("images/cloudbackupbg2.jpg");
            background-repeat: no-repeat;
            background-size: cover;
        }
       
    </style>
</asp:Content>

<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Localize runat="server" ID="LocPlsChkTrm" meta:resourcekey="str_plsChkTrm" Visible="false">Please check the terms of service agreement checkbox to continue</asp:Localize>
    <asp:Localize runat="server" ID="LocFldEnlBkpCtr" meta:resourcekey="str_fldEnlBkpCtr" Visible="false">Failed to enable backup on the cluster</asp:Localize>

    <div id="defaultcontent" style="width:100%; ">
    <%if (m_BackupEnabled){ %>
          
    <div width="100%" style=" border: 0px solid red; padding-bottom:0px; align-content: right; " >
        <table width="100%" style="border-collapse: collapse;" cellpadding="0" cellspacing="0">
            <tr>

                <td style="width: 10px; border-bottom: 0px solid #cccccc;">&nbsp;</td>

                
                <td align="left" style="padding: 0px; width: 100px; display:none;">
                    <table style="border-collapse: collapse;" cellpadding="0" cellspacing="0">
                        <tr>
                            <td style="padding-top: 10px;" valign="bottom">
                                <div class="gladtab_active" id="page_4" onclick="SetPage(4);return false;">
                                    <asp:Localize ID="Localize3" runat="server" meta:resourcekey="str_summary">Summary</asp:Localize>
                                </div>
                                <td style="padding-top: 10px;" valign="bottom">
                                    <div class="gladtab_inactive " id="page_1" onclick="SetPage(1);return false;">
                                        <asp:Localize ID="Localize1" meta:resourcekey="str_buteamfolder" runat="server">Team Folders</asp:Localize>
                                    </div>
                                </td>
                            <td style="padding-top: 10px;" valign="bottom">
                                <div class="gladtab_inactive" id="page_2" onclick="SetPage(2);return false;">
                                    <asp:Localize ID="Localize2" meta:resourcekey="str_budevices" runat="server">Devices</asp:Localize>
                                </div>
                            </td>

                            <td style="padding-top: 10px;" valign="bottom">
                                <div class="gladtab_inactive" id="page_3" onclick="SetPage(3);return false;">
                                    <asp:Localize ID="str_actUsr" runat="server" meta:resourcekey="str_busettings">Settings</asp:Localize>
                                </div>
                            </td>

                            <td style="padding-top: 10px;" valign="bottom">
                                <div class="gladtab_inactive" id="page_5" onclick="SetPage(5);return false;"><asp:Localize runat="server" meta:resourcekey="str_DevBacPro">Device Backup Profiles</asp:Localize></div>
                            </td>
                            <td style="padding-top: 10px;" valign="bottom">
                                <div class="gladtab_inactive" id="page_6" onclick="SetPage(6);return false;"><asp:Localize runat="server" meta:resourcekey="str_BacTas">Backup Task</asp:Localize></div>
                            </td>
                            <td style="padding-top: 10px;" valign="bottom">
                                <div class="gladtab_inactive" id="page_7" onclick="SetPage(7);return false;"><asp:Localize runat="server" meta:resourcekey="str_BacLog">Backup Log</asp:Localize></div>
                            </td>
                        </tr>
                    </table>
                </td>
                <td style="border-bottom: 0px solid #cccccc; padding-right: 10px; height:48px;">
                    
                    <div style="float: right; font-size: 48px; font-weight: 100; cursor: pointer;" class="sectextcolor" onclick="ReturnLast();">&times;</div>
                    <div style="float: right; margin-top:5px; font-size: 32px; font-weight: 100; cursor: pointer; padding-right:10px;" class="sectextcolor gladinet-icons" onclick="Refresh();">&#0181;</div>
                </td>
            </tr>
        </table>
    </div>
   
   
<iframe width="100%" src="<%=m_SummaryPage %>" frameborder="0" 
                    border="1" height="100%" id="main_body"></iframe>
        </div>
    <%}else{ %>
      
    <table width="100%">
       
        <tr>
            <td align="center" style="padding-top: 40px">
                <table style="width:100%; max-width:1100px" border="0">
                    <tr>
                        <td width="300px">
                            <img src="images/backupbg.jpg" width="300px" />
                        </td>
                        <td>
                <table style="width: 100%; max-width: 888px">
                    <%if (!string.IsNullOrEmpty(ErrorMsg.Text))
                        {  %>
                    <tr>
                        <td>
                            <div class="alert alert-warning" role="alert">


                                <asp:Label ID="ErrorMsg" runat="server" Text=""></asp:Label>
                            </div>
                        </td>
                    </tr>
                    <%} %>
                    <tr>
                        <td style="font-size: 48px; color: #4e85d7; font-weight: 600;" align="center">
                            <asp:Localize runat="server" meta:resourcekey="str_bstBsnCtn">Boost Business Continuity</asp:Localize> <br />
                            <asp:Localize runat="server" meta:resourcekey="str_wthOneClk">with 1-Click!</asp:Localize> 
                        </td>
                    </tr>
                    <tr>
                        <td style="font-size: 18px; color: #565656; font-weight: 100; padding-top: 20px; padding-left: 20px; text-align: justify;">
                            <asp:Localize runat="server" ID="LocWhtIsCldBkp" meta:resourcekey="str_whtIsCldBkp" Visible="false">Cloud Backup is an add-on feature of $ProductName$. Once it is turned on, it will add continuous cloud backup features to $ProductName$. You can pick team folders and/or devices connected to $ProductName$ to be backed-up to the Cloud and you can access the backups from the Cloud once the files and folders are synced. $ProductName$ Cloud Backup different from other conventional backup solutions in the following ways:</asp:Localize>
                            <%=LocWhtIsCldBkp.Text.Replace("$ProductName$",GetProductName())%>
                        </td>
                    </tr>
                    <tr>
                        <td style="font-size: 16px; color: #565656; font-weight: 100; padding-top: 20px;">

                            <ul>
                                <li class="list-group-item1" style="font-size: 16px!important; color: #202020!important; font-weight: 100;">✓ <asp:Localize runat="server" meta:resourcekey="str_splPrc">Simple and attractive pricing model</asp:Localize> (<button type="button" style="padding:3px!important" class="btn btn-default" data-toggle="modal" data-target="#pricingModal">
  <asp:Localize runat="server" meta:resourcekey="str_prc">Pricing</asp:Localize>
</button>)</li>
                                <li class="list-group-item1" style="font-size: 16px!important; color: #202020; font-weight: 100;">✓ <asp:Localize runat="server" meta:resourcekey="str_uldDvcBkp">Unlimited Device Backup</asp:Localize></li>
                                <li class="list-group-item1" style="font-size: 16px!important; color: #202020; font-weight: 100;">✓ <asp:Localize runat="server" meta:resourcekey="str_sptRmtAndLclDvc">Support Remote and Local Devices</asp:Localize></li>
                                <li class="list-group-item1" style="font-size: 16px!important; color: #202020; font-weight: 100;">✓ <asp:Localize runat="server" meta:resourcekey="str_noSfwReq">No need to install additional software on file servers that are already connected to the cloud</asp:Localize></li>
                                <li class="list-group-item1" style="font-size: 16px!important; color: #202020; font-weight: 100;">✓ <asp:Localize runat="server" meta:resourcekey="str_sptSnpOrCnt">Support for snapshots or continuous backups</asp:Localize></li>
                                <li class="list-group-item1" style="font-size: 16px!important; color: #202020; font-weight: 100;">✓ <asp:Localize runat="server" meta:resourcekey="str_mngYurOwnStg">Optional: Manage your own storage with your existing Azure or Amazon accounts!</asp:Localize></li>
                       
                            </ul>
                        </td>
                    </tr>
                    <tr>
                       <td style="font-size: 18px; color: #565656; font-weight: 100; padding-top: 20px; padding-left: 20px; text-align: justify;">
                           <asp:Localize runat="server" ID="LocEblAddOnMsg" meta:resourcekey="str_eblAddOnMsg" Visible="false">You will be able to manage your backups from your existing $ProductName$ installation. This add-on backup solution will also give you access to separate hosted backup cloud. Hosted access and integrated backup management tools are a powerful one-two punch to boost business continuity for your customers. Click the "Enable" button below to see the power!</asp:Localize>
                            <%=LocEblAddOnMsg.Text.Replace("$ProductName$",GetProductName())%>  
                        </td>
                    </tr>
                    <tr>
                        <td align="right" style="padding-left:20px;">
                            <table border="0">
                                <tr>
                                    <td valign="middle">
                                        <asp:CheckBox CssClass="  thintext" ID="CheckBoxTerm" runat="server" Text="By enabling you agree to the " meta:resourcekey="str_byEnlYouAgr" />&nbsp;
                                    </td>
                                    <td valign="middle">
                                        <a href="http://www.gladinet.com/p/terms.htm" target="_blank">
                                            <asp:Localize meta:resourcekey="str_trmSvc" runat="server">TERMS OF SERVICE</asp:Localize></a>
                                    </td>
                                    <td>
                                        
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>

                    <tr>
                        <td align="right" style="padding-top: 20px; padding-right: 10px; ">
                            <asp:LinkButton ID="EnableCloudBackup" runat="server" width=268 CssClass="btn btn-primary btn-lg btn-block" OnClientClick="Wait('...');return true;" OnClick="EnableCloudBackup_Click" meta:resourcekey="str_enlBldBkp">Enable Cloud Backup!</asp:LinkButton>
                        </td>
                    </tr>
                </table>
                            </td>
                        </tr>
                    </table>

            </td>
        </tr>

    </table>
    
    <div class="modal fade" id="pricingModal" tabindex="-1" role="dialog" aria-labelledby="pricingModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document" style="width:600px;">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="pricingModalLabel"><asp:Localize runat="server" meta:resourcekey="str_prc">Pricing</asp:Localize></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
          <asp:Localize runat="server" meta:resourcekey="str_splLcgMdl">We use a simple licensing model. The cost of the cloud backup consists of two parts:</asp:Localize>
        <br />
          <asp:Localize runat="server" meta:resourcekey="str_cstOne">1. Per-user license: for each cluster, we charge 15% of the current user licensing costs. You can back up an unlimited number of devices and file servers.</asp:Localize>
          
          <table class="table-striped" width="100%" cellspacing="0" cellpadding="0">
                                                        <tr>
                                                            <td width="118" height="24"></td>
                                                            <td style="font-family: Verdana,Arial,Helvetica,sans-serif; padding: 0px; line-height: 1.6em; font-size: 12px; color: #404041;">
                                                                <asp:Localize runat="server" meta:resourcekey="str_prcPerUsrPerMth">Price/User/Month</asp:Localize>
                                                            </td>
                                                        </tr>
                                                       
                                                        <tr>
                                                            <td width="218" height="24">
                                                                <asp:Localize runat="server" meta:resourcekey="str_fstOneHdr">First 100 users (1-100)</asp:Localize>
                                                            </td>
                                                            <td style="font-family: Verdana,Arial,Helvetica,sans-serif; padding: 0px; line-height: 1.6em; font-size: 12px; color: #404041;">$<%=user.CSSelfHostedPrice.Tier100 *0.15 %> <asp:Localize runat="server" meta:resourcekey="str_perUsrPerMth">/user/month</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td width="218" height="24"><asp:Localize runat="server" meta:resourcekey="str_nxtFurHdr">Next 400 users (101-500)</asp:Localize>
                                                            </td>
                                                            <td style="font-family: Verdana,Arial,Helvetica,sans-serif; padding: 0px; line-height: 1.6em; font-size: 12px; color: #404041;">$<%=user.CSSelfHostedPrice.Tier500*0.15 %> <asp:Localize runat="server" meta:resourcekey="str_perUsrPerMth">/user/month</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td width="218" height="24"><asp:Localize runat="server" meta:resourcekey="str_nxtFveHdr">Next 500 users (501-1000)</asp:Localize>
                                                            </td>
                                                            <td style="font-family: Verdana,Arial,Helvetica,sans-serif; padding: 0px; line-height: 1.6em; font-size: 12px; color: #404041;">$<%=user.CSSelfHostedPrice.Tier1000*0.15 %> <asp:Localize runat="server" meta:resourcekey="str_perUsrPerMth">/user/month</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td height="24"><asp:Localize runat="server" meta:resourcekey="str_nxtTer">Next Tier (> 1000 users)</asp:Localize>
                                                            </td>
                                                            <td style="font-family: Verdana,Arial,Helvetica,sans-serif; padding: 0px; line-height: 1.6em; font-size: 12px; color: #404041;">$<%=user.CSSelfHostedPrice.TierTop *0.15%> <asp:Localize runat="server" meta:resourcekey="str_perUsrPerMth">/user/month</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td style="height: 24px"><asp:Localize runat="server" meta:resourcekey="str_nxtTwoThd">> 2000 users</asp:Localize>
                                                            </td>
                                                            <td style="font-family: Verdana,Arial,Helvetica,sans-serif; padding: 0px; line-height: 1.6em; font-size: 12px; color: #404041; height: 24px;">
                                                                <asp:Localize runat="server" meta:resourcekey="str_ctcUsForPrc">Please contact Gladinet (support@gladinet.com) for pricing.</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr>

                                                            <td colspan="2" style="font-family: Verdana,Arial,Helvetica,sans-serif; padding: 0px; line-height: 1.6em; padding-top: 10px; font-size: 12px; color: #404041; height: 24px;">
                                                                <asp:Localize runat="server" meta:resourcekey="str_ctcUsForSbs">Please contact Gladinet (support@gladinet.com) for yearly subscription or alternative payment methods.</asp:Localize>
                                                            </td>
                                                        </tr>
                                                        
                                                    </table>

          <br />
           <asp:Localize runat="server" meta:resourcekey="str_stgCst">2. Storage Costs:</asp:Localize>
          <div style="font-family: Verdana,Arial,Helvetica,sans-serif; padding: 0px; line-height: 1.6em; padding-top: 10px; font-size: 12px; color: #404041;">

              a. <b><asp:Localize runat="server" meta:resourcekey="str_bkpYurOwnStg">Backup to your own storage</asp:Localize></b>: <b><asp:Localize runat="server" meta:resourcekey="str_fre">free</asp:Localize></b> <asp:Localize runat="server" meta:resourcekey="str_ownStgCst">(You may be billed separately by your storage provider for storage cost)</asp:Localize><br /><br />
              b. <b><asp:Localize runat="server" meta:resourcekey="str_bkpCtkStg">Backup to CentreStack Data Store</asp:Localize></b>: <asp:Localize runat="server" meta:resourcekey="str_avgStgUsg">average storage usage</asp:Localize>, <b>US$0.03/GB/<asp:Localize runat="server" meta:resourcekey="str_mth">Month</asp:Localize></b>
              </div>

      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal"><asp:Localize runat="server" meta:resourcekey="str_cls">Close</asp:Localize></button>
        
      </div>
    </div>
  </div>
</div>
    <%} %>
    <div id="ShortWindowModal" class="modal fade" role="dialog" >
            <div class="modal-dialog " style="max-width:850px!important; width: 850px!important; padding:0px!important;">

                <!-- Modal content-->
                <div class="modal-content" style="padding:0px!important;">
                    <div class="modal-header" >
                        
                        <button type="button" class="close" onclick="CloseQuickWindow();">&times;</button>
                        <h4 class="modal-title" style="color: #808080; " id="ShortTitle"></h4>
                    </div>
                    <div class="modal-body" style="height: 600px;padding-top:0px;padding:0px!important;" id="ShortBody">
                         <iframe id='ShortWindow' width="100%"  style="padding:0px;" src="/portal/WaitWin.htm"
        frameborder="0" border="0" height="100%"></iframe>
                    </div>
                </div>

            </div>
        </div>
    <div id="childwnd" style="width:100%; display:none; background-color:white;">
    <div width="100%" style="background-color: white;  border: 0px; padding-bottom:0px; align-content: right; border-bottom: 0px solid #f0f0f0; " >
        <table width="100%" style="border-collapse:collapse;" cellpadding="0" cellspacing="0" >
            <tr>
                <td>
                    <table>
                        <tr>
                <td style="padding:5px; font-size:24px; cursor:pointer;" class="sectextcolor toolnavbtn" onclick="CloseChildWnd();"><asp:Localize runat="server" meta:resourcekey="str_bkpMgr">Backup Manager</asp:Localize></td>
                                
                <td  style="padding:5px; font-size:24px;" class="sectextcolor ">></td>
                <td align="left" style="padding:5px;border-bottom: 0px solid #cccccc;padding-right:10px; height:48px;font-weight:100;color:#404040; font-size:24px;" id="child_title" >
                </td>

                        </tr>
                    </table>
                </td>
                    
                <td style="border-bottom: 0px solid #cccccc;padding-right:10px;">
                    <div style="float:right; font-size:32px;  font-weight:100; cursor:pointer;" class="sectextcolor" onclick="CloseChildWnd();">&times;</div>
                </td>
                </tr>
            </table>
        </div>
   
   
<iframe width="100%" src="/portal/WaitWin.htm" frameborder="0" style="margin-top:-20px;"
                    border="0" height="100%" id="child_body"></iframe>
        </div>

<script type="text/javascript">
             function ReturnLast() {
                window.location = "<%=PageReturnUrl %>";
             }
    function CloseChildWnd()
    {
        var f = document.getElementById('defaultcontent');
        f.style.display = "";
        

        f = document.getElementById('child_body');
        f.src = "/portal/WaitWin.htm";        

        f = document.getElementById('childwnd');        
        f.style.display = "none";
        
        f = document.getElementById('main_body');
        
        f.contentWindow.location = f.contentWindow.location;

    }

    function Refresh()
    {
        Wait("...");
        var f = document.getElementById('main_body');

        f.contentWindow.location = f.contentWindow.location;
    }
    function OpenChildWnd(t, s) {
        var f = document.getElementById('defaultcontent');
        f.style.display = "none";


        f = document.getElementById('child_body');
        f.src = s;

        f = document.getElementById('childwnd');
        f.style.display = "";

        f = document.getElementById('child_title');
        f.innerHTML = t;

    }

    function OpenTeamFolderBackMgr() {
        OpenChildWnd("<asp:Localize runat="server" meta:resourcekey="str_temFldBkp">Team Folder Backups</asp:Localize>", "ClusterBackupTeamFolders.aspx");
    }

    function OpenDeviceBackMgr() {
        OpenChildWnd("<asp:Localize runat="server" meta:resourcekey="str_dvcBkp">Device Backups</asp:Localize>", "ClusterBackupDevices.aspx");
    }
    function OpenBackupStatus() {
        OpenChildWnd("<asp:Localize runat="server" meta:resourcekey="str_tskSts">Task Status</asp:Localize>", "ClusterBackupTask.aspx");
    }
    function OpenBackupLog() {
        OpenChildWnd("<asp:Localize runat="server" meta:resourcekey="str_bkpLog">Backup Log</asp:Localize>", "ClusterBackupTaskLog.aspx");
    }

    function OpenDeviceProfile() {
        OpenChildWnd("<asp:Localize runat="server" meta:resourcekey="str_dvcBkpPfl">Device Backup Profile</asp:Localize>", "ClusterBackupProfileMgr.aspx");
    }

    function OpenBackupSettings() {
        OpenChildWnd("<asp:Localize runat="server" meta:resourcekey="str_bkpStg">Backup Settings</asp:Localize>", "ClusterBackupSettings.aspx");
    }

    function OpenQuickWindow(u, t) {
        var e = document.getElementById("ShortTitle");
        e.innerHTML = "&nbsp;&nbsp;";
        e = document.getElementById("ShortBody");
        if (document.documentElement.clientHeight < 750)
            e.style.height = "500px"
        else
            e.style.height = "600px"

        e = document.getElementById("ShortWindow");
        e.src = u;
        $('#ShortWindowModal').modal({ backdrop: 'static', keyboard: false });

    }
    function CloseQuickWindow(u, t) {
        try {
            var e = document.getElementById("ShortWindow");
            e.src = "/portal/WaitWin.htm";

        } catch (ee) {

        }
        try {
            $('#ShortWindowModal').modal('hide');

        } catch (e) {

        }

    }
    function AddTeamFolder() {
        
        OpenQuickWindow("ClusterBackupAddTeamFolder.aspx", "<asp:Localize runat="server" meta:resourcekey="str_addTemFldBkp">Add Team Folder to Backup</asp:Localize>");
    }
    function AddDevice() {
        OpenQuickWindow("ClusterBackupAddDevice.aspx", "<asp:Localize runat="server" meta:resourcekey="str_addDvcBkp">Add Device to Backup</asp:Localize>");
    }

    function RestoreTeamFolder() {
        OpenChildWnd( "<asp:Localize runat="server" meta:resourcekey="str_rstTemFld">Restore Team Folder</asp:Localize>", "ClusterBackupRestoreTeamFolder.aspx");
    }

    function RestoreDevice() {
        OpenChildWnd("<asp:Localize runat="server" meta:resourcekey="str_rstDvc">Restore Device</asp:Localize>", "ClusterBackupRestoreDevice.aspx");
    }


    function AdjustSize() {

        var f = document.getElementById('main_body');
        if (f) {
            f.style.height = "110vh";
            f.style.overflow = "hidden";
            
        }

        f = document.getElementById('child_body');
        if (f) {
            f.style.height = "calc(100vh - 59px)";
            f.style.marginTop = "0px";
        }


        //document.body.style.backgroundColor = "#f8f8f8";
       
    }

        function SetPage(p) {
            var e = document.getElementById("page_1");            
            e.className = "gladtab_inactive";

            e = document.getElementById("page_2");
            e.className = "gladtab_inactive";

            e = document.getElementById("page_3");
            e.className = "gladtab_inactive";

            e = document.getElementById("page_4");
            e.className = "gladtab_inactive";

            e = document.getElementById("page_5");
            e.className = "gladtab_inactive";

            e = document.getElementById("page_6");
            e.className = "gladtab_inactive";

            e = document.getElementById("page_7");
            e.className = "gladtab_inactive";

            e = document.getElementById("page_" + p);
            e.className = "gladtab_active";

            e = document.getElementById("main_body");
            if (p == 1) {
                e.src = "ClusterBackupTeamFolders.aspx";
                
            }else if (p == 2) {
                e.src = "ClusterBackupDevices.aspx";
                
            } else if (p == 3) {
                e.src = "ClusterBackupSettings.aspx";
                
            } else if (p == 4) {
                e.src = "ClusterBackupSummary.aspx";

            } else if (p == 5) {
                e.src = "ClusterBackupProfileMgr.aspx";

            } else if (p == 6) {
                e.src = "ClusterBackupTask.aspx";

            } else if (p == 7) {
                e.src = "ClusterBackupTaskLog.aspx";

            }

            
        }

        function closeActiveWin() {
            
            CloseQuickWindow();
            CloseChildWnd();
            var e = document.getElementById("main_body");
            e.src = e.src;
        }

        function closeCancelActiveWin() {
            CloseQuickWindow();
            CloseChildWnd();
        }
    
        function onProcessLog()
        {
            SetPage(7);
        }

        Ext.onReady(function () {
            AdjustSize();
        });

        Ext.EventManager.onWindowResize(function () {
            AdjustSize();
        });
   

 

</script>
    
</asp:Content>
