﻿<%@ Page Title="Servers" Language="C#" MasterPageFile="../WebAppPanel.master" EnableSessionState="false"
    AutoEventWireup="true" CodeBehind="CSBizTenantInfo.aspx.cs" Inherits="GladinetPayFlow.CSBizTenantInfo" Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <script src="/management/bootstrap4/js/Chart.bundle.min.js"></script>
    <style>
        .infocard {
            border-radius: 3px;
            background-color: white;
            border: 1px solid #f0f0f0;
        }

        .infocardex {
            border-radius: 5px;
            background-color: white;
            border: 1px solid #dddddd;
        }

        .nopadding {
            padding: 0px !important;
        }

        .dashChart {
            margin-top: 10px;
        }

        #chart1.dashChart.col-12, #chart1.dashChart.col-6, #chart2.dashChart.col-6 {
            margin-top: 0px;
        }

        .circle {
            width: 20px;
            height: 20px;
            -webkit-border-radius: 10px;
            -moz-border-radius: 10px;
            border-radius: 10px;
            align-content: center;
            vertical-align: middle;
            cursor: default;
        }
    </style>
    <script type="text/javascript">
        if (parent) {
            var parLoc = parent.location.href.toLowerCase();
            //csbiz/csbiztenantinfo.aspx should not have /csbiztenantdashboard.aspx as the immediate parent
            if (parLoc.indexOf("/management/clustermgrconsole") > -1 || parLoc.indexOf("/management/clustermgr.aspx") > -1) {
                try {
                    top.EditTenant("<%=CurrentAdminId%>","<%=TxtNewOrgName.Text%>");
                } catch (ex) {
                    location.href = "/management/CSBiz/CSBizTenantDashboard.aspx?id=<%=SessionUserId%>";
                }
            } else if (parLoc.indexOf("/management/tenantconsole") > -1 || parLoc.indexOf("/management/webapppage.aspx") > -1) {
                try {
                    top.onDashboard();
                } catch (ex) {
                    location.href = "/management/CSBiz/CSBizTenantDashboard.aspx?id=<%=SessionUserId%>";
                }
            }
        }
        function copyToClipboard(text) {
            try {
                if (window.clipboardData && window.clipboardData.setData) {
                    // IE specific code path to prevent textarea being shown while dialog is visible.
                    clipboardData.setData("Text", text);
                    showAlertMessge("Link copied to clipboard");

                } else if (document.queryCommandSupported && document.queryCommandSupported("copy")) {
                    var textarea = document.createElement("textarea");
                    textarea.textContent = text;
                    textarea.style.position = "fixed"; // Prevent scrolling to bottom of page in MS Edge.
                    document.body.appendChild(textarea);
                    textarea.select();
                    try {
                        document.execCommand("copy"); // Security exception may be thrown by some browsers.
                        showAlertMessge("Link copied to clipboard");
                    } catch (ex) {
                        console.warn("Copy to clipboard failed.", ex);
                        return false;
                    } finally {
                        document.body.removeChild(textarea);
                    }
                }
            } catch (e) {

            }
        }

        function OnPublishShare()
        {
            parent.OnPublishShare();
        }       

        function OnManageShares() {
            parent.OnPublishedShares();
        }
        function FormatFileSize(size) {
            try{
                if (size < 1024) { //pow(2,10)
                    return size + " <asp:Localize meta:resourcekey="str_bts" runat="server" >Bytes</asp:Localize>";
                } else if (size < 1048576) { //pow(2,20)
                    return (Math.round(((size * 10) / 1024)) / 10) + " KB";
                } else if (size < 1073741824) { //pow(2,30)
                    return (Math.round(((size * 10) / 1048576)) / 10) + " MB";
                } else if (size < 1099511627776) { //pow(2,40)
                    return (Math.round(((size * 100) / 1073741824)) / 100) + " GB";
                } else if (size < 1125899906842624) { //pow(2,50)
                    return (Math.round(((size * 100) / 1099511627776)) / 100) + " TB";
                } else { //pow(2,60)
                    return (Math.round(((size * 100) / 1125899906842624)) / 100) + " PB";
                }
            }catch(e){
                alert(e);
            }

            return size;

        }
        function ConfigCurrentWorkerNode() {


            var name = "<%=CurrentHost.Value %>";
            parent.OnEditWorkerNode(name);
        }
        function ManageGuestUsers() {
        <%if (mAllowGuestUsers){ %>            
            parent.OnGuestUserMgr();
        <% } %>     
        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">              
<asp:Localize ID="LocInf" meta:resourcekey="str_inf" runat="server" Visible="false">Info</asp:Localize>                                   
<asp:Localize ID="LocSavSuc" meta:resourcekey="str_savSuc" runat="server" Visible="false">Saved successfully</asp:Localize>
<asp:Localize ID="LocRelPag" meta:resourcekey="str_relPag" runat="server" Visible="false">Reload Page</asp:Localize>
<asp:Localize runat="server" ID="LocTheDnsNamIsNotAva" meta:resourcekey="str_theDnsNamIsNotAva" Visible="false">the dns name is not available</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToCreTun" meta:resourcekey="str_faiToCreTun" Visible="false">failed to create tunel</asp:Localize>
<asp:Localize runat="server" ID="LocTunNamHasInvCha" meta:resourcekey="str_tunNamHasInvCha" Visible="false">tunnel name has invalid chars</asp:Localize>
<asp:Localize runat="server" ID="LocTunNamIsMis" meta:resourcekey="str_tunNamIsMis" Visible="false">tunnel name is missing</asp:Localize>

    <div class="wrapper" id="DashboardView" style="width: 100%; padding: 0px;">
        <table style="width: 100%;">
            <tr>
                <td align="center" style="padding-top: 40px;">
                    <div class="row " style="width: 100%; max-width: 1200px;">
                        <%if (CanViewReports) { %>
                        <div class="col-8" style="">
                        <% } else { %>
                        <div class="col-12" style="">
                        <% } %>
                            <div class="row " style="width: 100%;">
                                <%if (CanViewTeamFolders) { %>
                                <div class="col-12" style="padding-bottom: 20px;">
                                    <table style="width: 100%">
                                        <tr style="border-bottom: 1px solid #cccccc;">
                                            <td style="font-size: 18px; color: #202020; padding: 5px;"><asp:Localize runat="server" meta:resourcekey="str_teaFolShaWor">Team Folders (Shared WorkSpaces)</asp:Localize></td>
                                            <td style="width: 48px; padding: 5px;" align="center">
                                                <i class="gladinet-icons md-24 md-dark hand center toolbtnb toolbtn" style="font-size: 16px;" onclick="OnManageShares(); return false;">c</i>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="font-size: 16px; color: #202020; font-weight: 100; padding-top: 15px; padding-bottom: 5px;" colspan="2">
                                                <%if (mPublishedShareCount == 0)
                                                    { %>
													<asp:Localize runat="server" meta:resourcekey="str_youDonHavAnyTea">You don't have any team folders yet.</asp:Localize>
                                                     
                                                    <p style="font-size: 12px; font-weight: 100; color: #565656">
													<asp:Localize runat="server" meta:resourcekey="str_youCanSetTeaFol">You can set up team folders and assign users to it with permissions. Users can access the team folder via a web browser and mobile clients in addition to native PC clients. A team folder can be created from an existing network share that is directly accessible in your local area network, a share on a remote file server that is connected indirectly via the Server Agent software, or a storage location from a cloud storage service provider.</asp:Localize></p>

                                                <%}
                                                    else
                                                    { %>
													<asp:Localize runat="server" meta:resourcekey="str_youHav">You have</asp:Localize>
                                                    
                                                    <asp:LinkButton ID="LinkButton3" runat="server" OnClientClick="OnManageShares(); return false;"><%=mPublishedShareCount %></asp:LinkButton>
                                                <asp:Localize runat="server" meta:resourcekey="str_teaFol">team folders.</asp:Localize>                                          
                                                    <%} %>
                                                <asp:LinkButton ID="LinkButton1" runat="server" OnClientClick="OnPublishShare(); return false;" meta:resourcekey="str_addTeaFol">Add a team folder.</asp:LinkButton>

                                            </td>
                                        </tr>

                                    </table>
                                </div>
                                <% } %>
                                <%if (CanViewUserManager) { %>
                                <div class="col-12" style="padding-bottom: 20px;">
                                    <table style="width: 100%">
                                        <tr style="border-bottom: 1px solid #cccccc;">
                                            <td style="font-size: 18px; color: #202020; padding: 5px;"><asp:Localize runat="server" meta:resourcekey="str_use">Users</asp:Localize></td>
                                            <td style="width: 48px; padding: 5px;" align="center">
                                                <i class="gladinet-icons md-24 md-dark hand center toolbtnb toolbtn" style="font-size: 16px;" onclick="parent.OnUserManager(); return false;">c</i>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="font-size: 16px; color: #202020; font-weight: 100; padding-top: 15px; padding-bottom: 5px;" colspan="2">
                                              <asp:Localize runat="server" meta:resourcekey="str_youHav">You have</asp:Localize>
                                                    
                                                    <asp:LinkButton ID="LinkButton4" runat="server" OnClientClick="parent.OnUserManager(); return false;"><%=UserCount.Text %></asp:LinkButton>
                                                <asp:Localize runat="server" meta:resourcekey="str_use">users.</asp:Localize>                                          
                                              
                                                  <asp:LinkButton ID="LinkButton5" runat="server" OnClientClick="parent.OnAddUser(location); return false;" meta:resourcekey="str_addUse">Add a user.</asp:LinkButton>

                                            </td>
                                        </tr>


                                    </table>
                                </div>
                                <% } %>
                                <%if (CanViewADSettings) { %>
                                <div class="col-12" style="padding-bottom: 20px;">
                                    <table style="width: 100%;<% if (!m_CanEditLDAP || !m_CanViewEditGroupPolicy) { %>display:none;"<% } %>">
                                        <tr style="border-bottom: 1px solid #cccccc;">
                                            <td style="font-size: 18px; color: #202020; padding: 5px;"><asp:Localize runat="server" meta:resourcekey="str_actDir">Active Directory</asp:Localize></td>
                                            <td style="width: 48px; padding: 5px;" align="center">
                                                <i class="gladinet-icons md-24 md-dark hand center toolbtnb toolbtn" style="font-size: 16px;" onclick="parent.OnLDAP();">c</i>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="font-size: 16px; color: #202020; font-weight: 100; padding-top: 15px; padding-bottom: 5px;" colspan="2">
                                                <% if (!NoAdPanel.Visible)
                                                { %>
                                                <div style="font-size: 10px; color: #565656; font-weight: 100">
                                                    <asp:Label ID="LDAPSvr" runat="server" Text=""></asp:Label>
                                                    /
                                                                                <asp:Label ID="FDomainName" runat="server"></asp:Label>
                                                    /
                                                                                    <asp:Label ID="LDAPUser" runat="server"></asp:Label>
                                                </div>
                                                <% }
                                                else
                                                { %> 
                                                 <asp:Localize runat="server" meta:resourcekey="str_noActDirIntConYet">No Active Directory integration is configured yet.</asp:Localize>
                                                <asp:LinkButton ID="LinkButton2" runat="server" OnClientClick="parent.OnLDAP(); return false;" meta:resourcekey="str_conNow">Configure Now.</asp:LinkButton>
                                                <% } %> 
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                                <% } %>
                                <div class="col-12" style="padding-bottom: 20px;">
                                    <table style="width: 100%">
                                        <tr style="border-bottom: 1px solid #cccccc;">
                                            <td style="font-size: 18px; color: #202020; padding: 5px;">
                                                <% if (TxtNewOrgName.Text!="") { %>
                                                   <%=TxtNewOrgName.Text %> <%=LocInf.Text %>
                                                <% } else { %>
                                                   <asp:Localize runat="server" meta:resourcekey="str_tenInf">Tenant Info</asp:Localize>
                                                <% } %> 
                                            </td>
                                            <td style="width: 48px; padding: 5px;" align="center">
                                                <% if (CanViewSettings) { %>
                                                <i class="gladinet-icons md-24 md-dark hand center toolbtnb toolbtn" style="font-size: 16px;" data-toggle="modal" data-target="#EditOrgInfo">c</i>
                                                <% } %>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="font-size: 16px; color: #202020; font-weight: 100; padding-top: 15px; padding-bottom: 5px;" align="center" colspan="2">
                                                <table width="100%">
                                                    <tr>
                                                        <td width="50%" style="border-right: 1px solid #f0f0f0; padding: 10px;" valign="top">
                                                            <table width="100%" >
                                                                <tr style="border-bottom: 1px solid #f0f0f0; display:none;" class="filerow" onclick="parent.OnUserManager();return false;">

                                                                    <td style="padding: 5px; font-size: 16px;width:140px;"><asp:Localize runat="server" meta:resourcekey="str_norUse">Normal Users</asp:Localize></td>
                                                                    <td >
                                                                        <span class="hollowbadge badge" style="font-size: 16px; margin-left: 10px;">
                                                                            <asp:Label ID="UserCount" runat="server" Text=""></asp:Label>
                                                                        </span>
                                                                    </td>
                                                                    <td width="30px">
                                                                                    <i class="gladinet-icons md-24  hand center" onclick="On2FA();return false;" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                                                </td>
                                                                </tr>
                                                                <% if(CanViewGuestUsers) { %>
                                                                <tr style="border-bottom: 1px solid #f0f0f0;" 
                                                                    <%if (mAllowGuestUsers){ %>  
                                                                    class="filerow" 
                                                                    <% } %> 
                                                                    onclick="ManageGuestUsers();return false;">

                                                                    <td style="padding: 5px; font-size: 16px;width:140px;"><asp:Localize runat="server" meta:resourcekey="str_gueUse">Guest Users</asp:Localize></td>
                                                                    <td>
                                                                        <span class="hollowbadge badge" style="font-size: 16px; margin-left: 10px;">
                                                                            <asp:Label ID="GuestUserCount" runat="server" Text=""></asp:Label>
                                                                        </span>
                                                                    </td>
                                                                    <td width="30px">
                                                                        <%if (mAllowGuestUsers){ %>            
                                                                            <i class="gladinet-icons md-24  hand center" onclick="On2FA();return false;" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                                        <% } %>   
                                                                    </td>
                                                                </tr>
                                                                <% } %>  
                                                                <% if(CanViewGroupManager) { %>
                                                                <tr style="border-bottom: 1px solid #f0f0f0;" class="filerow" onclick="parent.OnGroupMgr();return false;">

                                                                    <td style="padding: 5px; font-size: 16px"><asp:Localize runat="server" meta:resourcekey="str_gro">Groups</asp:Localize></td>
                                                                    <td>
                                                                        <span class="hollowbadge badge" style="font-size: 16px; margin-left: 10px;">
                                                                            <asp:Label ID="GroupCount" runat="server" Text=""></asp:Label>
                                                                        </span>
                                                                    </td>
                                                                    <td width="30px">
                                                                                    <i class="gladinet-icons md-24  hand center" onclick="On2FA();return false;" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                                                </td>
                                                                </tr>
                                                                <% } %> 
                                                                <% if(CanViewSettings) { %>
                                                                <tr style="border-bottom: 1px solid #f0f0f0; display:;" class="filerow" onclick="parent.OnRoleMgr();return false;">

                                                                    <td style="padding: 5px; font-size: 16px"><asp:Localize runat="server" meta:resourcekey="str_rol">Roles</asp:Localize></td>
                                                                    <td>
                                                                        <span class="hollowbadge badge" style="font-size: 16px; margin-left: 10px;">
                                                                            <asp:Label ID="RoleCount" runat="server" Text=""></asp:Label>
                                                                        </span>
                                                                    </td>
                                                                     <td width="30px">
                                                                                    <i class="gladinet-icons md-24  hand center" onclick="On2FA();return false;" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                                                </td>
                                                                </tr>
                                                                <% } %>
                                                            </table>
                                                        </td>
                                                        <td style="padding: 10px;" valign="top">
                                                            <table width="100%">
                                                                <tr style="border-bottom: 1px solid #f0f0f0;" <%if (SessionIsClusterAdmin)
                                                                    { %>class="filerow" onclick="parent.OnTenantPlan();return false;" <% } %>>

                                                                    <td style="padding: 5px; font-size: 16px; width:180px;"><asp:Localize runat="server" meta:resourcekey="str_assLic">License/Storage Quota</asp:Localize></span>

                                                                    </td>
                                                                    <td>
                                                                        <span class="hollowbadge badge" style="font-size: 16px; margin-left: 10px;">
                                                                            <asp:Label ID="LicenseCount" runat="server" Text=""></asp:Label>
                                                                        </span>
                                                                    </td>
                                                                    <td width="30px">
                                                                                     <%if (SessionIsClusterAdmin)
                                                                                                                                  { %>
                                                                        <i class="gladinet-icons md-24  hand center" onclick="parent.OnTenantPlan();return false;" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                                        <% } %>
                                                                                </td>
                                                                </tr>
                                                                <%if (CanViewDeviceManager) { %>
                                                                <tr style="border-bottom: 1px solid #f0f0f0;" class="filerow" onclick="parent.OnDeviceMgr();return false;">

                                                                    <td style="padding: 5px; font-size: 16px"><asp:Localize runat="server" meta:resourcekey="str_dev">Devices</asp:Localize></td>
                                                                    <td>
                                                                        <span class="hollowbadge badge" style="font-size: 16px; margin-left: 10px;">
                                                                            <asp:Label ID="DeviceCount" runat="server" Text=""></asp:Label>
                                                                        </span>
                                                                    </td>
                                                                    <td width="30px">
                                                                                    <i class="gladinet-icons md-24  hand center" onclick="On2FA();return false;" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                                                </td>
                                                                </tr>
                                                                <% } %>
                                                                <tr style="border-bottom: 1px solid #f0f0f0;" class="filerow" onclick="<% if (CanViewSettings) { %>parent.OnStoragePanel();<% } %>return false;">

                                                                    <td style="padding: 5px; font-size: 16px"><asp:Localize runat="server" meta:resourcekey="str_sto">Storage Used</asp:Localize></td>
                                                                    <td>
                                                                        <span class="hollowbadge badge" style="font-size: 16px; margin-left: 10px;">
                                                                            <asp:Label ID="StorageUsed" runat="server" Text="100MB"></asp:Label>
                                                                        </span>
                                                                    </td>
                                                                    <td width="30px">
                                                                                    <i class="gladinet-icons md-24  hand center" onclick="On2FA();return false;" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                                                </td>
                                                                </tr>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                </table>


                                            </td>
                                        </tr>
                                    </table>
                                </div>
                                
                                <div class="col-12" style="padding-bottom: 3px; margin-bottom: 10px;">
                                    <table style="width: 100%">
                                        <tr style="border-bottom: 0px solid #cccccc;">
                                            <td style="font-size: 18px; color: #202020; padding: 5px;">&nbsp;</td>
                                        </tr>
                                    </table>
                                </div>
                                <div class="col-6 " id="chart1" style="padding-bottom: 0px;display:none;">

                                    <div class=" staticviewcarddark" style="padding: 10px; padding-left: 10px;">
                                        <div style="padding: 10px; border-bottom: 1px solid #f0f0f0; display: none;" class="boxbordercolor secsubcolor">
                                            <asp:Localize runat="server" ID="str_filUpdInLstMns" meta:resourcekey="str_filUpdInLstMns">File uploads in last 60 minutes</asp:Localize>
                                        </div>
                                        <div class="panel-body" style="height: 180px!important; width: 100%" id="upload60div">
                                            <canvas id="upload60"></canvas>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-6 " id="chart2" style="padding-bottom: 0px; display:none;">

                                    <div class=" staticviewcarddark" style="padding: 10px;">
                                        <div style="padding: 10px; border-bottom: 1px solid #f0f0f0; display: none;" class="boxbordercolor secsubcolor">
                                            <asp:Localize runat="server" ID="str_filUpdInLstHrs" meta:resourcekey="str_filUpdInLstHrs">File uploads in last 24 hours</asp:Localize>
                                        </div>
                                        <div class="panel-body" style="height: 180px; width: 100%" id="upload24div">
                                            <canvas id="upload24"></canvas>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <%if (CanViewReports) { %>
                        <div class="col-4" style="">
                            <%if (SessionIsClusterAdmin)
                                                 { %>
                            <div class="col-12 dashChart" id="FilePortal" style="padding-bottom: 10px;min-width:200px;">
                                <div class=" staticviewcarddark" style="padding: 0px;">
                                    <div style="border-bottom: 1px solid #f0f0f0; padding: 10px; font-size: 14px; font-weight: 100;" class="boxbordercolor ">
                                        <asp:Localize runat="server" meta:resourcekey="str_filPor">File Portal</asp:Localize> 
                                        <%if (EditExtDNS)
                                                 { %>
                                        <i class="gladinet-icons md-24 md-dark hand center toolbtnb toolbtn" style="font-size: 16px; float: right; margin-top: 5px;" data-toggle="modal" data-target="#myModal">c</i>
                                        <% } %>
                                    </div>
                                    <div class="panel-body" style="height: 120px; font-size: 14px; font-weight: 100; width: 100%; padding-top: 20px;" id="Fileportaldiv">
                                        <asp:Localize runat="server" meta:resourcekey="str_youAndYouUseCan">You and your users can access files from the following web site URL:</asp:Localize> 
                                               
                                            <div style="padding-top:5px;white-space:nowrap;overflow-x:hidden;">
                                                <span style="font-size: 12px; padding-right:5px; font-weight: 100;" class="sectextcolor"><%=mExtDns%>/portal/files</span>
                                                <i class="gladinet-icons  md-dark hand center toolbtn" style="display: inline-block; font-size: 18px; margin-top: -3px; padding-left:0px;" title="" onclick='copyToClipboard("<%=mExtDns %>/portal/files")'>&#0192;</i>
                                            </div>
                           
                                    </div>
                                </div>

                            </div>
                            <% } %>
                            <div class="col-12 dashChart" id="RansomeWare" style="padding-bottom: 10px;min-width:200px;">
                                <div class=" staticviewcarddark" style="padding: 0px;">
                                    <div style="border-bottom: 1px solid #f0f0f0; padding: 10px; font-size: 16px; font-weight: 100;" class="boxbordercolor ">
                                        <asp:Localize runat="server" meta:resourcekey="str_ranProAle">Ransomware Protection Alerts</asp:Localize> <i class="gladinet-icons md-24 md-dark hand center toolbtnb toolbtn" style="font-size: 16px; float: right; margin-top: 5px;" onclick="parent.OnRansomwarePanel()">c</i>
                                    </div>
                                    <div class="panel-body" style="height: 180px; width: 100%;" id="RansomeWarediv">
                                        <%if (RanRepeater.Items.Count != 0)
                                                 { %>
                                        <div style="font-size: 16px; font-weight: 100; color: #565656; padding-top: 40px;overflow:auto;height:178px;">
                                        <table width="100%">
                                                          
                                            <asp:Repeater ID="RanRepeater" runat="server">
                                                <ItemTemplate>
                                                    <tr style="border-bottom: 1px solid #f0f0f0">
                                                        <td width="20px" style="padding: 2px;">
                                                            <div class="circle" title="<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "UserEmail").ToString())%>"
                                                                style="background-color: white; border: 1px solid <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "AbbrevColor").ToString())%>; color: <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "AbbrevColor").ToString())%>; font-size: 12px; padding-top: 0px; margin-top: -3px;"
                                                                align="center" valign="middle">

                                                                <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "AbbrevName").ToString())%>
                                                            </div>
                                                        </td>
                                                        <td style="font-size: 12px; text-align: left; padding-left: 13px; font-weight: 100; color: #565656;overflow-wrap:break-word;overflow-wrap:anywhere;" title=" <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "TraceLocalTime").ToString())%>">
                                                            <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "Action").ToString())%>
                                                        </td>
                                                        <td style="font-size: 12px; text-align: left; padding-left: 5px; font-weight: 100; color: #565656;overflow-wrap:break-word;overflow-wrap:anywhere;" title="<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "Trace").ToString())%>">
                                                            <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "DisplayTrace").ToString())%>
                                                        </td>


                                                    </tr>
                                                </ItemTemplate>
                                            </asp:Repeater>
                                        </table>
                                        </div>
                                        <%}
                                                 else
                                                 { %>
                                        <table align="center" cellspacing="0" cellpadding="0" style="background-color: white;">
                                            <tr>
                                                <td align="center">
                                                    <div style="font-size: 16px; font-weight: 100; color: #565656; padding-top: 40px"><asp:Localize runat="server" meta:resourcekey="str_noRanProRelAle">No ransomware protection related alerts in last 7 days.</asp:Localize></div>


                                                </td>
                                            </tr>
                                        </table>

                                        <%} %>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 dashChart" id="DLP" style="padding-bottom: 10px;min-width:200px;">
                                <div class=" staticviewcarddark" style="padding: 0px;">
                                    <div style="border-bottom: 1px solid #f0f0f0; padding: 10px; font-size: 16px; font-weight: 100;" class="boxbordercolor ">
                                        <asp:Localize runat="server" meta:resourcekey="str_datLeaProAle">Data Leak Protection Alerts</asp:Localize> <i class="gladinet-icons md-24 md-dark hand center toolbtnb toolbtn" style="font-size: 16px; float: right; margin-top: 5px;" onclick="parent.OnDLPPanel()">c</i>
                                    </div>
                                    <div class="panel-body" style="height: 180px; width: 100%; overflow-y: auto; padding-top: 5px; overflow-x: hidden;" id="DLPdiv">


                                        <%if (DLPRepeater.Items.Count != 0)
                                                 { %>
                                        <table width="100%">


                                            <asp:Repeater ID="DLPRepeater" runat="server">
                                                <ItemTemplate>
                                                    <tr style="border-bottom: 1px solid #f0f0f0">
                                                        <td width="20px" style="padding: 2px;">
                                                            <div class="circle" title="<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "UserEmail").ToString())%>"
                                                                style="background-color: white; border: 1px solid <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "AbbrevColor").ToString())%>; color: <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "AbbrevColor").ToString())%>; font-size: 12px; padding-top: 0px; margin-top: -3px;"
                                                                align="center" valign="middle">

                                                                <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "AbbrevName").ToString())%>
                                                            </div>
                                                        </td>
                                                        <td style="font-size: 12px; text-align: left; padding-left: 13px; font-weight: 100; color: #565656;overflow-wrap:break-word;overflow-wrap:anywhere;" title=" <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "TraceLocalTime").ToString())%>">
                                                            <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "Action").ToString())%>
                                                        </td>
                                                        <td style="font-size: 12px; text-align: left; padding-left: 5px; font-weight: 100; color: #565656;overflow-wrap:break-word;overflow-wrap:anywhere;" title="<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "Trace").ToString())%>">
                                                            <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "DisplayTrace").ToString())%>
                                                        </td>


                                                    </tr>
                                                </ItemTemplate>
                                            </asp:Repeater>
                                        </table>
                                        <%}
                                                 else
                                                 { %>
                                        <table align="center" cellspacing="0" cellpadding="0" style="background-color: white;">
                                            <tr>
                                                <td align="center">
                                                    <div style="font-size: 16px; font-weight: 100; color: #565656; padding-top: 40px"><asp:Localize runat="server" meta:resourcekey="str_noDatLeaProRel">No data leak protection related alerts in last 7 days.</asp:Localize></div>


                                                </td>
                                            </tr>
                                        </table>

                                        <%} %>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <% } %>
                    </div>

                </td>
            </tr>
        </table>
    </div>

    <div class="modal fade" id="EditOrgInfo" tabindex="-1" role="dialog" aria-labelledby="modalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                                            
                    <button type="button" id="orgNameClose1" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <asp:Localize meta:resourcekey="str_orgNam" runat="server">Organization Name</asp:Localize>    
                    <asp:TextBox ID="TxtNewOrgName" runat="server" CssClass="form-control"></asp:TextBox>
                    <asp:Literal ID="LtlOldOrgName" runat="server" Visible="false"></asp:Literal>
                </div>
                <div class="modal-footer">
                    <asp:Label ID="LblOrgInfoErr" runat="server" Visible="false"></asp:Label>
                    <asp:LinkButton ID="SaveOrgInfo" runat="server" CausesValidation="false" OnClick="SaveOrgInfo_Click" CssClass="btn btn-primary gladbtn"><asp:Localize meta:resourcekey="str_applyorg"  runat="server" >Apply</asp:Localize></asp:LinkButton>
                    <button type="button" id="orgNameClose2" class="btn btn-secondary" data-dismiss="modal"><asp:Localize meta:resourcekey="str_cls" runat="server">Close</asp:Localize></button>
                </div>
            </div>
        </div>
    </div>

    <div id="myModal" class="modal fade" role="dialog">

        <div class="modal-dialog">

            <div class="modal-content" style="width: 600px;">
                <div class="modal-header" style="display: none;">


                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <table width="100%">
                        <tr>
                            <td style="font-size: 16px; font-weight: 100; color: #202020;">
                                <asp:Localize meta:resourcekey="asp_string2" runat="server">External URL</asp:Localize>
                                (https://mydomain.com)
                    <p style="font-size: 12px; color: #565656; font-weight: 100;"><asp:Localize runat="server" meta:resourcekey="str_thiExtAddThaWil">This is the external address that will be used for offsite access. Please consult your IT administrator if you are not sure what it should be.</asp:Localize></p>
                        </tr>
                        <tr>
                            <td>
                                <table style="width: 100%;">
                                    <tr>
                                        <td>
                                            <asp:RadioButton GroupName="extdnsgroup" ID="UseTunel" runat="server" Text="Use default tunneled DNS" meta:resourcekey="str_useDefTunDNS" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <table>
                                                <tr>
                                                    <td style="font-size: 16px; font-weight: 100; color: #202020;">https://</td>
                                                    <td>
                                                        <asp:TextBox ID="TunelDnsName" runat="server" Text="mydns" CssClass="form-control"></asp:TextBox>
                                                    </td>
                                                    <td style="font-size: 16px; font-weight: 100; color: #202020;">
                                                        <asp:Label ID="DnsZoneName" runat="server" Text=".triofox.io"></asp:Label>
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>

                                    </tr>
                                </table>

                            </td>
                        </tr>

                        <tr>
                            <td style="padding-top: 20px;">
                                <table style="width: 100%;">
                                    <tr>
                                        <td>
                                            <asp:RadioButton GroupName="extdnsgroup" ID="UseOwnExt" runat="server" Text="Use my own public DNS" meta:resourcekey="str_useOwnPubDns" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <asp:TextBox ID="ExternalDNS" runat="server" Text="http://localhost"
                                                CssClass="form-control"></asp:TextBox>
                                        </td>

                                    </tr>
                                </table>
                            </td>
                        </tr>

                    </table>

                </div>
                <div class="modal-footer">
                    <asp:Button ID="ApplyExtDns" runat="server" meta:resourcekey="str_app" Text="Apply" CssClass="btn btn-primary gladbtn"
                        OnClick="ApplyExtDns_Click" OnClientClick="CloseAndWait();" />

                    <button type="button" class="btn btn-default" data-dismiss="modal"><asp:Localize runat="server" meta:resourcekey="str_can">Cancel</asp:Localize></button>
                </div>
            </div>
        </div>
    </div>

    <div style="display: none">
        <asp:Panel ID="NoAdPanel" runat="server"></asp:Panel>
        <asp:Label ID="ErrorMsg" runat="server" CssClass="errmsg"
            meta:resourcekey="ErrorMsgResource1"></asp:Label>

        <asp:Label ID="ClusterId" runat="server" CssClass="badge"></asp:Label>
        <asp:Localize ID="LocFilUpd" runat="server" meta:resourcekey="str_filUpd" Visible="false">Files Uploaded</asp:Localize>
        <asp:Localize ID="LocTme" runat="server" meta:resourcekey="str_tme" Visible="false">Time</asp:Localize>
        <asp:Localize ID="LocFil" runat="server" meta:resourcekey="str_fil" Visible="false">Files</asp:Localize>
        <asp:Localize meta:resourcekey="str_impNtkFilShr" runat="server" Visible="false">Imported Network File Shares</asp:Localize>
        <span id="sectextcolor" class="sectextcolor"></span>
        <span id="lighttextcolor" class="lighttextcolor"></span>
        <asp:Localize runat="server" ID="LocUlt" meta:resourcekey="str_ult" Visible="false">Unlimited</asp:Localize>
        <asp:Localize meta:resourcekey="str_daysgao" ID="StrDaysAgo" runat="server" Visible="False"> Days ago</asp:Localize>
        <asp:Localize meta:resourcekey="str_hoursago" ID="StrHoursAgo" runat="server" Visible="False"> Hours ago</asp:Localize>
        <asp:Localize meta:resourcekey="str_minsago" ID="StrMinsAgo" runat="server" Visible="False"> Minutes ago</asp:Localize>
        <asp:Localize meta:resourcekey="str_lessmin" ID="StrLessMin" runat="server" Visible="False">Less than 1 minute ago</asp:Localize>

        <asp:HiddenField ID="CurrentHost" runat="server" />
    </div>
    <script type="text/javascript">
        
        function CloseAndWait(){
            $('#myModal').modal('hide');
            Wait('Uploading');
        }
        function DisplayError() {

            var d = document.getElementById("ctl00_MainContent_ErrorMsg");
            if (d) {
                if (d.innerHTML != "") {
                    
                    alert( d.innerHTML);
                    
                }
            }

            var d = document.getElementById("ctl00_MainContent_LblOrgInfoErr");
            if (d) {
                if (d.innerHTML != "") {
                    //if there is a success or error message, open the modal popup for Organization Name
                    $('#EditOrgInfo').modal({ backdrop: 'static', keyboard: false });
                    if(d.className=="text-success"){
                        try{                                                                             
                            var breadcrums = top.document.querySelectorAll("#PageTitle .mainnavbtn")
                            if(breadcrums.length>1){   
                                //if multi-tenancy is enabled, reload page without prompting for resubmission
                                //this will update the breadcrums. Tenant admins don't have the second breadcrum and don't need this case
                                var reloadTopPage = function(){    
                                    try{                                 
                                        if(top.EditTenant) {
                                            top.EditTenant("<%=CurrentAdminId%>","<%=TxtNewOrgName.Text%>");
                                        }
                                    }catch(ex){  
                                        var topUrl = top.location.href;
                                        top.location.href = topUrl;   
                                    }                             
                                };
                                //hide the X button and re-label the Close button to Reload Page  
                                document.getElementById("ctl00_MainContent_SaveOrgInfo").style.display = "none";   
                                document.getElementById("orgNameClose1").style.display = "none";   
                                document.getElementById("orgNameClose2").innerHTML = "<%=LocRelPag.Text%>";//Reload Page
                                document.getElementById("orgNameClose2").onclick = reloadTopPage;
                            }
                        }catch(ex){}
                    }   
                    setTimeout(function(){
                        //hide the server message after 5 seconds
                        d.style.display = "none";
                    },5000);
                }
            }

        }
        
        var Upload60Data = [
        <asp:Repeater ID="Upload60DataRep" runat="server" >
          <ItemTemplate>         
          <%#(Container.ItemIndex == 0)? "": "," %>      
            {        
                date:'<%#DataBinder.Eval(Container.DataItem,"Name") %>',
                Files:<%#DataBinder.Eval(Container.DataItem,"Value") %>
                }
            </ItemTemplate>
        </asp:Repeater>      
        ];

        var Upload24Data = [
            <asp:Repeater ID="Upload24DataRep" runat="server" >
              <ItemTemplate>         
              <%#(Container.ItemIndex == 0)? "": "," %>      
            {        
                date:'<%#DataBinder.Eval(Container.DataItem,"Name") %>',
                Files:<%#DataBinder.Eval(Container.DataItem,"Value") %>
                }
            </ItemTemplate>
        </asp:Repeater>      
        ];

      
        function newDraewChart(rid, fields, data,  xtitle, ytitle, xfield, yfield, charttype)
        {
            
            var xs = [];
            var ys = [];
            for(var i=0; i<data.length;++i){
                xs[i] = data[i].date;
                ys[i] = data[i].Files;
            }
            var ctx = document.getElementById(rid).getContext('2d');
            var myChart = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: xs,
                    datasets: [{
                        label: xtitle,
                        backgroundColor:  $("#lighttextcolor").css("color"),
                        borderColor: $("#sectextcolor").css("color"),
                        data: ys,
                        borderWidth: 1
                    }]
                },
                options: {
                    scales: {
                        yAxes: [{
                            ticks: {
                                beginAtZero:false
                            }
                        }]
                    }
                }
            });
        }

        function newDraewChartBytes(rid, fields, data,  xtitle, ytitle, xfield, yfield, charttype)
        {
            
            var xs = [];
            var ys = [];
            for(var i=0; i<data.length;++i){
                xs[i] = data[i].date;
                ys[i] = data[i].Files;
            }
            var ctx = document.getElementById(rid).getContext('2d');
            var myChart = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: xs,
                    datasets: [{
                        label: xtitle,
                        backgroundColor:  $("#lighttextcolor").css("color"),
                        borderColor: $("#sectextcolor").css("color"),
                        data: ys,
                        borderWidth: 1
                    }]
                },
                options: {
                    scales: {
                        yAxes: [{
                            ticks: {
                                beginAtZero:false,
                                callback: function(value, index, values) {
                                    return  FormatFileSize(value);
                                }
                            }
                        }]
                    }
                }
            });
        }
        function DrawChartF()
        {
            
            newDraewChart('upload60', ['date', 'Files'], Upload60Data, '<%=str_filUpdInLstMns.Text %>', '<%=LocFilUpd.Text %>', 'date', '<%=LocFil.Text %>','column');
            
            newDraewChart('upload24', ['date', 'Files'], Upload24Data, '<%=str_filUpdInLstHrs.Text %>', '<%=LocFilUpd.Text %>', 'date', '<%=LocFil.Text %>','line');

        }
        
        function adjust() {
        
            var e = document.getElementById("upload60div");
            var h = Math.floor(e.offsetWidth*0.5)
            if(e.offsetHeight <  h)
                e.style.height = h+"px";

            
            e = document.getElementById("upload24div");
            if(e.offsetHeight <  h)
                e.style.height = h+"px";
              
              
        }
        function SetPortalURLOnParent(){
            try{
                top._tenantPortalUrl = "<%=mExtDns%>/portal/files";
            }catch(ex){}
        }
        Ext.onReady(function () {
             <%if(!string.IsNullOrEmpty(mRedirUrl)){%>
            top.location.replace("<%=mRedirUrl%>");
            return;
            <%}%>
            adjust();
        
              
            DrawChartF();
            DisplayError();
            SetPortalURLOnParent();

            try{
                if (parent.ClearRelativePageTitle) {   
                    parent.ClearRelativePageTitle();
                } else if (parent.parent.ClearRelativePageTitle) {   
                    parent.parent.ClearRelativePageTitle();
                }
            }catch(ex){
                console.log("ClearRelativePageTitle does not exist");
            }

        });
        
        
    </script>
</asp:Content>
