﻿<%@ Page Title="Servers" Language="C#" MasterPageFile="../WebAppPanel.master" EnableSessionState="false"
    AutoEventWireup="true" CodeBehind="CSBizClusterDashboard.aspx.cs" Inherits="GladinetPayFlow.CSBizClusterDashboard" Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <script src="/management/bootstrap4/js/Chart.bundle.min.js"></script>
    <style>
        .infocard {
            border-radius: 3px;
            background-color: white;
            border: 1px solid #f0f0f0;
        }

        .infocardex {
            border-radius: 5px;
            background-color: white;
            border: 1px solid #dddddd;
        }

        .nopadding {
            padding: 0px !important;
        }

        .dashChart {
            margin-top: 10px;
        }

        #chart1.dashChart.col-12, #chart1.dashChart.col-6, #chart2.dashChart.col-6 {
            margin-top: 0px;
        }

        .circle {
            width: 20px;
            height: 20px;
            -webkit-border-radius: 10px;
            -moz-border-radius: 10px;
            border-radius: 10px;
            align-content: center;
            vertical-align: middle;
            cursor: default;
        }
    </style>
    <script type="text/javascript">
        function copyToClipboard(text) {
            try {
                if (window.clipboardData && window.clipboardData.setData) {
                    // IE specific code path to prevent textarea being shown while dialog is visible.
                    clipboardData.setData("Text", text);
                    showAlertMessge("Link copied to clipboard");

                } else if (document.queryCommandSupported && document.queryCommandSupported("copy")) {
                    var textarea = document.createElement("textarea");
                    textarea.textContent = text;
                    textarea.style.position = "fixed"; // Prevent scrolling to bottom of page in MS Edge.
                    document.body.appendChild(textarea);
                    textarea.select();
                    try {
                        document.execCommand("copy"); // Security exception may be thrown by some browsers.
                        showAlertMessge("Link copied to clipboard");
                    } catch (ex) {
                        console.warn("Copy to clipboard failed.", ex);
                        return false;
                    } finally {
                        document.body.removeChild(textarea);
                    }
                }
            } catch (e) {

            }
        }

        function OnPublishShare()
        {
            parent.OnPublishShare();
        }

        function OnManageShares() {
            parent.OnPublishedShares();
        }
        function FormatFileSize(size) {
            try{
                if (size < 1024) { //pow(2,10)
                    return size + " <asp:Localize meta:resourcekey="str_bts" runat="server" >Bytes</asp:Localize>";
                } else if (size < 1048576) { //pow(2,20)
                    return (Math.round(((size * 10) / 1024)) / 10) + " KB";
                } else if (size < 1073741824) { //pow(2,30)
                    return (Math.round(((size * 10) / 1048576)) / 10) + " MB";
                } else if (size < 1099511627776) { //pow(2,40)
                    return (Math.round(((size * 100) / 1073741824)) / 100) + " GB";
                } else if (size < 1125899906842624) { //pow(2,50)
                    return (Math.round(((size * 100) / 1099511627776)) / 100) + " TB";
                } else { //pow(2,60)
                    return (Math.round(((size * 100) / 1125899906842624)) / 100) + " PB";
                }
            }catch(e){
                alert(e);
            }

            return size;

        }

        var SubMainUri = "";
        var SubMainTitle = "";
        function SetSecondMenuView(url, fqdn) {
             
           
            Wait();
             
            SubMainUri = url;
            SubMainTitle = fqdn;
            window.location = url;

            parent.SetSubMainMenu(fqdn);

        }
        function OnClickMainView() {
            
            SetSecondMenuView(SubMainUri, SubMainTitle);
        }

        function ConfigCurrentWorkerNode() {


            var name = "<%=CurrentHost.Value %>";
            parent.OnEditWorkerNode(name);
        }
        function ClusterBranding() {
            
            SetSecondMenuView( "/management/BrandingMgrPage.aspx?mode=cluster","<asp:Localize meta:resourcekey="str_branding" runat="server">Branding</asp:Localize>");
        }

        function ClusterLicInfo() {
            <%if (IsServo) { %>
            SetSecondMenuView( "/management/servo/ServoLicense.aspx","<asp:Localize meta:resourcekey="str_licensing" runat="server">Licensing</asp:Localize>");
            <%}else { %>
            SetSecondMenuView( "/management/ClusterLicenseInfo.aspx","<asp:Localize meta:resourcekey="str_licensing" runat="server">Licensing</asp:Localize>");
            <%}%>
            
        }

        function ClusterStorageReport() {

            SetSecondMenuView( "/management/StorageStat.aspx","<asp:Localize meta:resourcekey="str_stoSta" runat="server">Storage Statistics</asp:Localize>");
        }

        function OnEmailSvc() {

            SetSecondMenuView( "/management/SMTPCfg.aspx","<asp:Localize meta:resourcekey="str_emaSer" runat="server">Email Service</asp:Localize>");
        }
        function OnAdminDN() {

            <%if (CanRunCritical){ %>
            SetSecondMenuView( "/management/AdminDatabase.aspx","<asp:Localize meta:resourcekey="str_database" runat="server">Database</asp:Localize>");
            <%}%>
        }

        function OnServerFarm() {

            SetSecondMenuView( "/management/ClusterFarm.aspx","<asp:Localize meta:resourcekey="str_serFar" runat="server">Server Farm</asp:Localize>");
        }

        function OnClientVersions(tab){
            SetSecondMenuView( "/management/ClientVersion.aspx?t=" + tab,"<asp:Localize meta:resourcekey="str_cliVerMan" runat="server">Client Version Manager</asp:Localize>");

        }
        function OnClusterAdmins(){
            SetSecondMenuView( "/management/ClusterEditUserInfo.aspx?cluster=1","<asp:Localize meta:resourcekey="str_cluAdm" runat="server">Cluster Admins</asp:Localize>");

        }

        function OnClusterGroupPolicy(){
            SetSecondMenuView( "/management/GroupPolicyMgrPage.aspx?vdid=2CD45C43-114F-406C-998C-C6B477148FC3","<asp:Localize meta:resourcekey="str_defGroPol" runat="server">Default Group Policy</asp:Localize>");

        }
        function OnServoAdmins(){
            SetSecondMenuView(  "/management/ClusterEditUserInfo.aspx?cluster=1","<asp:Localize meta:resourcekey="str_administrators" runat="server">Administrators</asp:Localize>");

        }


        

        function OnClusterSettings(){
            SetSecondMenuView( "/management/ClusterCfg.aspx","<asp:Localize meta:resourcekey="str_cluSet" runat="server">Cluster Settings</asp:Localize>");

        }

        function OnApplicationMgr()
        {
            SetSecondMenuView( "/management/ApplicationMgr.aspx","<asp:Localize runat="server" meta:resourcekey="str_appMgr">Application Manager</asp:Localize>");
        }
        function OnClusterAV(){
            SetSecondMenuView( "/management/AntiVirus.aspx","<asp:Localize meta:resourcekey="str_antVir" runat="server">Anti Virus</asp:Localize>");

        }

        function OnClusterLang(){
            SetSecondMenuView( "/management/localize/Default.aspx","<asp:Localize meta:resourcekey="str_languages" runat="server">Languages</asp:Localize>");

        }

        function OnClusterReports(){
            SetSecondMenuView( "/management/ClusterReports.aspx","<asp:Localize meta:resourcekey="str_reports" runat="server">Reports</asp:Localize>");

        }
        function OnClusterPerf(){
            SetSecondMenuView( "/management/PerfCounterMonitor.aspx","<asp:Localize meta:resourcekey="str_perCou" runat="server">Performance Counters</asp:Localize>");

        }
        function OnClusterBandwidth(){
            SetSecondMenuView( "/management/BandwidthStat.aspx","<asp:Localize meta:resourcekey="str_banUsa" runat="server">Bandwidth Usage</asp:Localize>");

        }
        function OnClusterUpload(){
            SetSecondMenuView( "/management/UploadStat.aspx","<asp:Localize meta:resourcekey="str_uplRep" runat="server">Upload Report</asp:Localize>");

        }
        function OnClusterDownload(){
            SetSecondMenuView( "/management/DownloadStat.aspx","<asp:Localize meta:resourcekey="str_dwdRep" runat="server">Download Report</asp:Localize>");

        }
        function EnableMultiTenancy(){
           $("#<%=LnkBtnEnableMultiTenancy.ClientID%>")[0].click();
        }         
        function DisableMultiTenancy(){
           $("#<%=LnkBtnDisableMultiTenancy.ClientID%>")[0].click();
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Localize ID="LocEdi" meta:resourcekey="str_edi" Visible="false" runat="server">Edition</asp:Localize>
    <asp:Localize ID="LocQUALic" meta:resourcekey="str_qUALic" Visible="false" runat="server">[$QUANT] Licenses</asp:Localize>
    <asp:Localize ID="LocExpInQUADay" meta:resourcekey="str_expInQUADay" Visible="false" runat="server">Expiring in [$QUANT] days</asp:Localize>
    <asp:Localize ID="LocTriEndInQUADay" meta:resourcekey="str_triEndInQUADay" Visible="false" runat="server">Trial ends in [$QUANT] days</asp:Localize>
    <asp:Localize ID="LocUnl" meta:resourcekey="str_unl" Visible="false" runat="server">Unlicensed</asp:Localize>
    <asp:Localize ID="LocDef" meta:resourcekey="str_def" Visible="false" runat="server">Default</asp:Localize>
    <asp:Localize ID="LocInTri" meta:resourcekey="str_inTri" Visible="false" runat="server">In Trial</asp:Localize>
<asp:Localize runat="server" ID="LocTheDnsNamIsNotAva" meta:resourcekey="str_theDnsNamIsNotAva" Visible="false">the dns name is not available</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToCreTun" meta:resourcekey="str_faiToCreTun" Visible="false">Failed to create tunnel</asp:Localize>
<asp:Localize runat="server" ID="LocTunNamHasInvCha" meta:resourcekey="str_tunNamHasInvCha" Visible="false">tunnel name has invalid chars</asp:Localize>
<asp:Localize runat="server" ID="LocTunNamIsMis" meta:resourcekey="str_tunNamIsMis" Visible="false">tunnel name is missing</asp:Localize>

    <div class="wrapper" id="DashboardView" style="width: 100%; padding: 0px;">
        <table style="width: 100%;">
            <tr>
                <td align="center" style="padding-top: 40px;">
                    <div class="row " style="width: 100%; max-width: 1200px;">
                        <div class="col-8" style="">
                            <div class="row " style="width: 100%;">
                                <div class="col-12 dashChart" id="ClusterInfo" style="padding-bottom: 10px;">
                                    <div class=" viewcard" style="padding: 0px;">
                                       
                                        <div style="border-bottom: 1px solid #f0f0f0; padding: 10px; height:40px; font-size: 16px; font-weight: 100; border-radius:3px 3px 0px 0px;" class="mainbgcolor ">
                                            <span style="float:left; color:white;"><asp:Localize runat="server" meta:resourcekey="str_cluInf">Cluster Info</asp:Localize></span>
                                        </div>
                                        <div class="panel-body" style="padding:10px; font-size: 14px; font-weight: 100; width: 100%; padding-top: 20px;" id="ClusterInfodiv">
                                            <table width="100%">
                                                <tr style="border-bottom: 1px solid #f0f0f0;" class="filerow" onclick="ClusterBranding();return false;" title="Branding">

                                                    <td style="padding: 5px; font-size: 16px" width="180px"><asp:Localize runat="server" meta:resourcekey="str_proNam">Product Name</asp:Localize></td>
                                                    <td >
                                                        <span class="sectextcolor" style="font-size: 16px; margin-left: 10px;">
                                                            <%=ProductName %>
                                                        </span>
                                                    </td>
                                                    <td style="width: 40px">
                                                        <span style="width: 40px; padding-left: 10px;" valign="middle">
                                                            <i class="gladinet-icons md-24  hand center" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                        </span>

                                                    </td>

                                                </tr>
                                               
                                                <tr style="border-bottom: 1px solid #f0f0f0;" class="filerow" onclick="ClusterLicInfo();return false;">

                                                    <td style="padding: 5px; font-size: 16px" ><asp:Localize runat="server" meta:resourcekey="str_assLicCou">Assigned License Count</asp:Localize></td>
                                                    <td >
                                                        <span class="sectextcolor" style="font-size: 16px; margin-left: 10px;">
                                                            <asp:Label ID="LicenseText" runat="server"></asp:Label>
                                                        </span>
                                                    </td>
                                                    <td style="width: 40px">
                                                        <span style="width: 40px; padding-left: 10px;" valign="middle">
                                                            <i class="gladinet-icons md-24  hand center" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                        </span>

                                                    </td>

                                                </tr>
                                                 <%if(!IsServo) { %>
                                                <tr style="border-bottom: 1px solid #f0f0f0;" class="filerow" onclick="ClusterStorageReport();return false;" title="Storage Statistics ">

                                                    <td style="padding: 5px; font-size: 16px" ><asp:Localize runat="server" meta:resourcekey="str_stoUse">Storage Used</asp:Localize></td>
                                                    <td >
                                                        <span class="sectextcolor" style="font-size: 16px; margin-left: 10px;">
                                                            <asp:Label ID="FileSize" runat="server"></asp:Label> GB
                                                        </span>
                                                    </td>
                                                    <td style="width: 40px">
                                                        <span style="width: 40px; padding-left: 10px;" valign="middle">
                                                            <i class="gladinet-icons md-24  hand center" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                        </span>

                                                    </td>

                                                </tr>
                                                 <%if(m_MultiTenant) { %>
                                                <tr style="border-bottom: 0px solid #f0f0f0;" class="filerow" onclick="parent.OnBizTenantMgr();return false;" title="Tenant Manager">

                                                    <td style="padding: 5px; font-size: 16px" ><asp:Localize runat="server" meta:resourcekey="str_tenCou">Tenants Count</asp:Localize></td>
                                                    <td >
                                                        <span class="sectextcolor" style="font-size: 16px; margin-left: 10px;">
                                                            <asp:Label ID="TenantCount" runat="server"></asp:Label>
                                                        </span>
                                                    </td>
                                                    <td style="width: 40px">
                                                        <span style="width: 40px; padding-left: 10px;" valign="middle">
                                                            <i class="gladinet-icons md-24  hand center" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                        </span>

                                                    </td>

                                                </tr>
                                                 <%}%>
                                                <%}else {%>
                                                <tr style="border-bottom: 0px solid #f0f0f0;" class="filerow"  title="Cluster ID">

                                                    <td style="padding: 5px; font-size: 16px" ><asp:Localize runat="server" meta:resourcekey="str_clu">Cluster ID</asp:Localize></td>
                                                    <td >
                                                        <span class="sectextcolor" style="font-size: 12px; margin-left: 10px;">
                                                            <asp:Label ID="ClusterId" runat="server" ></asp:Label>
                                                            <i class="gladinet-icons  md-dark hand center toolbtn" style="display: inline-block; font-size: 18px; margin-top: -3px; padding-left: 10px;" title="" onclick='copyToClipboard("<%=ClusterId.Text %>")'>&#0192;</i>
                                                        </span>
                                                    </td>
                                                    <td style="width: 40px">
                                                        <span style="width: 40px; padding-left: 10px;" valign="middle"></span>

                                                    </td>

                                                </tr>
                                                <%}%>
                                            </table>
                                        </div>
                                    </div>

                                </div>

                                <div class="col-12 dashChart" id="FarmInfo" style="padding-bottom: 10px;">
                                    <div class=" viewcard" style="padding: 0px;">
                                        <div style="border-bottom: 1px solid #f0f0f0; padding: 10px; height:40px; font-size: 16px; font-weight: 100; border-radius:3px 3px 0px 0px;" class="mainbgcolor ">
                                            <span style="float:left; color:white;"><asp:Localize runat="server" meta:resourcekey="str_serFar">Server Farm</asp:Localize></span>
                                        </div>
                                        <div class="panel-body" style=" padding:10px; font-size: 14px; font-weight: 100; width: 100%; padding-top: 20px;" id="FarmInfodiv">
                                            <table width="100%">
                                                <tr style="border-bottom: 1px solid #f0f0f0;" class="filerow" >

                                                    <td style="padding: 5px; font-size: 16px" width="180px"><asp:Localize runat="server" meta:resourcekey="str_extDns">External DNS</asp:Localize></td>
                                                    <td >
                                                        <table>
                                                        <tr>

                                                            <td style="padding: 5px;">
                                                                <span style="font-size: 16px; padding-right: 10px; font-weight: 100;" class="sectextcolor"><%=mExtDns%></span>
                                                                <i class="gladinet-icons  md-dark hand center toolbtn" style="display: inline-block; font-size: 18px; margin-top: -3px; padding-left: 10px;" title="" onclick='copyToClipboard("<%=mExtDns %>/portal/files")'>&#0192;</i>
                                                                <i class="gladinet-icons  md-dark hand center toolbtn" style="display: inline-block; font-size: 18px; margin-top: -3px; padding-left: 10px;" title="" )' data-toggle="modal" data-target="#myModal">c</i>
                                                            </td>
                                                        </tr>

                                                    </table>
                                                    </td>
                                                    <td style="width: 40px"  >
                                                        <span style="width: 40px; padding-left: 10px;" valign="middle"></span>

                                                    </td>

                                                </tr>
                                                <tr style="border-bottom: 1px solid #f0f0f0;" class="filerow" onclick="OnEmailSvc();return false;" title="Email Service">

                                                    <td style="padding: 5px; font-size: 16px" ><asp:Localize runat="server" meta:resourcekey="str_emaSer">Email Service</asp:Localize></td>
                                                    <td >
                                                        <span style="font-size: 16px; margin-left: 10px;" class="sectextcolor">
                                                            <asp:Label ID="EmailSvc" runat="server"></asp:Label>
                                                        </span>
                                                    </td>
                                                    <td style="width: 40px">
                                                        <span style="width: 40px; padding-left: 10px;" valign="middle">
                                                            <i class="gladinet-icons md-24  hand center" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                        </span>

                                                    </td>

                                                </tr>
                                                <tr style="border-bottom: 1px solid #f0f0f0;" class="filerow" onclick="OnAdminDN();return false;" title="Configure Database">

                                                    <td style="padding: 5px; font-size: 16px" ><asp:Localize runat="server" meta:resourcekey="str_datInf">Database Info</asp:Localize></td>
                                                    <td >
                                                        <span style="font-size: 16px; margin-left: 10px;" class="sectextcolor">
                                                             <asp:Literal ID="ltlDBInfo" runat="server" /> 
                                                        </span>
                                                    </td>
                                                    <td style="width: 40px">
                                                        <%if (CanRunCritical){ %>
                                                        <span style="width: 40px; padding-left: 10px;" valign="middle">
                                                            <i class="gladinet-icons md-24  hand center" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                        </span>
                                                        <%} %>
                                                    </td>

                                                </tr>
                                                <tr style="border-bottom: 0px solid #f0f0f0;" class="filerow" onclick="OnServerFarm();return false;">

                                                    <td style="padding: 5px; font-size: 16px" ><asp:Localize runat="server" meta:resourcekey="str_worNodCou">Worker Node Count</asp:Localize></td>
                                                    <td >
                                                        <span  style="font-size: 16px; margin-left: 10px;" class="sectextcolor">
                                                            <asp:Literal ID="WorkerNodeCount" runat="server" /> 
                                                        </span>
                                                    </td>
                                                    <td style="width: 40px">
                                                        <span style="width: 40px; padding-left: 10px;" valign="middle">
                                                            <i class="gladinet-icons md-24  hand center" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                        </span>

                                                    </td>

                                                </tr>
                                            </table>
                                        </div>
                                    </div>

                                </div>

                                <div class="col-12 dashChart" id="ClientVerInfo" style="padding-bottom: 10px;">
                                    <div class=" viewcard" style="padding: 0px;">
                                        <div style="border-bottom: 1px solid #f0f0f0; padding: 10px; height:40px; font-size: 16px; font-weight: 100; border-radius:3px 3px 0px 0px;" class="mainbgcolor ">
                                            <span style="float:left; color:white;"><asp:Localize runat="server" meta:resourcekey="str_cliVer">Client Versions</asp:Localize></span>
                                        </div>
                                        <div class="panel-body" style=" padding:10px; font-size: 14px; font-weight: 100; width: 100%; padding-top: 20px;" id="ClientVerInfodiv">
                                            <table width="100%">
                                                
                                                <tr style="border-bottom: 1px solid #f0f0f0; " class="filerow" onclick="OnClientVersions(1);return false;" title="Client Version Manager">

                                                    <td style="padding: 5px; font-size: 16px;width:180px;" ><asp:Localize runat="server" meta:resourcekey="str_winCli">Windows Client</asp:Localize></td>
                                                    <td >
                                                        <span style="font-size: 16px; margin-left: 10px;" class="sectextcolor">
                                                            <asp:Label ID="CurrentPublishedWC" runat="server"   />/<asp:Label ID="WCVerson" runat="server" />
                                                        </span>
                                                    </td>
                                                    <td style="width: 40px">
                                                        <span style="width: 40px; padding-left: 10px;" valign="middle">
                                                            <i class="gladinet-icons md-24  hand center" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                        </span>

                                                    </td>

                                                </tr>
                                                <tr style="border-bottom: 1px solid #f0f0f0;" class="filerow" onclick="OnClientVersions(2);return false;">

                                                    <td style="padding: 5px; font-size: 16px" ><asp:Localize runat="server" meta:resourcekey="str_serAge">Server Agent</asp:Localize></td>
                                                    <td >
                                                        <span  style="font-size: 16px; margin-left: 10px;" class="sectextcolor">
                                                            <asp:Label ID="CurrentPublishedSA" runat="server"   />/<asp:Label ID="SAVersion" runat="server" />
                                                        </span>
                                                    </td>
                                                    <td style="width: 40px">
                                                        <span style="width: 40px; padding-left: 10px;" valign="middle">
                                                            <i class="gladinet-icons md-24  hand center" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                        </span>

                                                    </td>

                                                </tr>
                                                <tr style="border-bottom: 0px solid #f0f0f0;" class="filerow" onclick="OnClientVersions(3);return false;"  title="Client Version Manager">

                                                    <td style="padding: 5px; font-size: 16px" ><asp:Localize runat="server" meta:resourcekey="str_macCli">Mac Client</asp:Localize></td>
                                                    <td >
                                                        <span  style="font-size: 16px; margin-left: 10px;" class="sectextcolor">
                                                            <asp:Label ID="CurrentPublishedMac6" runat="server"   />/<asp:Label ID="MacVersion6" runat="server" />
                                                        </span>
                                                    </td>
                                                    <td style="width: 40px">
                                                        <span style="width: 40px; padding-left: 10px;" valign="middle">
                                                            <i class="gladinet-icons md-24  hand center" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                        </span>

                                                    </td>

                                                </tr>
                                            </table>
                                        </div>
                                    </div>

                                </div>
                               
                            </div>
                        </div>


                        <div class="col-4" style="">

                            <div class="col-12 dashChart" id="FilePortal" style="padding-bottom: 10px;">
                                <div class=" staticviewcarddark" style="padding: 0px;">
                                    
                                    <div class="panel-body" style=" font-size: 14px; font-weight: 100; width: 100%; padding: 15px;" id="Fileportaldiv">
                                        <table width="100%">
                                            <%if(!IsServo) { %>
                                                <tr style="border-bottom: 1px solid #f0f0f0; " class="filerow" onclick="OnClusterAdmins();return false;">

                                                    <td style="padding: 5px; font-size: 16px;width:40px;" >
                                                        <i 
															 class="gladinet-icons md32 iconviewitemcolor hand center ">M</i>
                                                    </td>
                                                    <td >
                                                        <span style="font-size: 16px; margin-left: 10px;" class="sectextcolor"><asp:Localize runat="server" meta:resourcekey="str_cluAdm">Cluster Admins</asp:Localize></span>
                                                    </td>
                                                    <td style="width: 40px">
                                                        <span style="width: 40px; padding-left: 10px;" valign="middle">
                                                            <i class="gladinet-icons md-24  hand center" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                        </span>

                                                    </td>

                                                </tr>
                                                <tr style="border-bottom: 1px solid #f0f0f0; " class="filerow" onclick="OnClusterGroupPolicy();return false;">

                                                    <td style="padding: 5px; font-size: 16px;width:40px;" >
                                                        <i 
															 class="gladinet-icons md32 iconviewitemcolor hand center ">S</i>
                                                    </td>
                                                    <td >
                                                        <span style="font-size: 16px; margin-left: 10px;" class="sectextcolor"><asp:Localize runat="server" meta:resourcekey="str_defGroPol">Default Group Policy</asp:Localize></span>
                                                    </td>
                                                    <td style="width: 40px">
                                                        <span style="width: 40px; padding-left: 10px;" valign="middle">
                                                            <i class="gladinet-icons md-24  hand center" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                        </span>

                                                    </td>

                                                </tr>
                                            <%}else {%>
                                            <tr style="border-bottom: 1px solid #f0f0f0; " class="filerow" onclick="OnServoAdmins();return false;">

                                                    <td style="padding: 5px; font-size: 16px;width:40px;" >
                                                        <i 
															 class="gladinet-icons md32 iconviewitemcolor hand center ">M</i>
                                                    </td>
                                                    <td >
                                                        <span style="font-size: 16px; margin-left: 10px;" class="sectextcolor"><asp:Localize runat="server" meta:resourcekey="str_adm">Administrators</asp:Localize></span>
                                                    </td>
                                                    <td style="width: 40px">
                                                        <span style="width: 40px; padding-left: 10px;" valign="middle">
                                                            <i class="gladinet-icons md-24  hand center" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                        </span>

                                                    </td>

                                                </tr>
                                             <%}%>
                                            <tr style="border-bottom: 1px solid #f0f0f0; " class="filerow" onclick="ClusterBranding();return false;">

                                                    <td style="padding: 5px; font-size: 16px;width:40px;" >
                                                        <i 
															 class="gladinet-icons md32 iconviewitemcolor hand center ">B</i>
                                                    </td>
                                                    <td >
                                                        <span style="font-size: 16px; margin-left: 10px;" class="sectextcolor"><asp:Localize runat="server" meta:resourcekey="str_cluBra">Cluster Branding</asp:Localize></span>
                                                    </td>
                                                    <td style="width: 40px">
                                                        <span style="width: 40px; padding-left: 10px;" valign="middle">
                                                            <i class="gladinet-icons md-24  hand center" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                        </span>

                                                    </td>

                                                </tr>
                                            <tr style="border-bottom: 1px solid #f0f0f0; " class="filerow" onclick="OnClusterSettings();return false;">

                                                    <td style="padding: 5px; font-size: 16px;width:40px;" >
                                                        <i 
															 class="gladinet-icons md32 iconviewitemcolor hand center ">g</i>
                                                    </td>
                                                    <td >
                                                        <span style="font-size: 16px; margin-left: 10px;" class="sectextcolor"><asp:Localize runat="server" meta:resourcekey="str_cluSet">Cluster Settings</asp:Localize></span>
                                                    </td>
                                                    <td style="width: 40px">
                                                        <span style="width: 40px; padding-left: 10px;" valign="middle">
                                                            <i class="gladinet-icons md-24  hand center" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                        </span>

                                                    </td>

                                                </tr>
                                            <tr style="border-bottom: 1px solid #f0f0f0; " class="filerow" onclick="OnApplicationMgr();return false;">

                                                    <td style="padding: 5px; font-size: 16px;width:40px;" >
                                                        <i 
															 class="gladinet-icons md32 iconviewitemcolor hand center ">P</i>
                                                    </td>
                                                    <td >
                                                        <span style="font-size: 16px; margin-left: 10px;" class="sectextcolor"><asp:Localize runat="server" meta:resourcekey="str_appMgr">Application Manager</asp:Localize></span>
                                                    </td>
                                                    <td style="width: 40px">
                                                        <span style="width: 40px; padding-left: 10px;" valign="middle">
                                                            <i class="gladinet-icons md-24  hand center" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                        </span>

                                                    </td>

                                                </tr>
                                            <tr style="border-bottom: 1px solid #f0f0f0; " class="filerow" onclick="OnClusterLang();return false;">

                                                    <td style="padding: 5px; font-size: 16px;width:40px;" >
                                                        <i 
															 class="gladinet-icons md32 iconviewitemcolor hand center ">9</i>
                                                    </td>
                                                    <td >
                                                        <span style="font-size: 16px; margin-left: 10px;" class="sectextcolor"><asp:Localize runat="server" meta:resourcekey="str_lan">Languages</asp:Localize></span>
                                                    </td>
                                                    <td style="width: 40px">
                                                        <span style="width: 40px; padding-left: 10px;" valign="middle">
                                                            <i class="gladinet-icons md-24  hand center" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                        </span>

                                                    </td>

                                                </tr>
                                            <tr style="border-bottom: 1px solid #f0f0f0; " class="filerow" onclick="OnClusterAV();return false;">

                                                    <td style="padding: 5px; font-size: 16px;width:40px;" >
                                                        <i 
															 class="gladinet-icons md32 iconviewitemcolor hand center ">5</i>
                                                    </td>
                                                    <td >
                                                        <span style="font-size: 16px; margin-left: 10px;" class="sectextcolor">
                                                            <asp:Localize runat="server" meta:resourcekey="str_ant">Anti-virus</asp:Localize></span>
                                                    </td>
                                                    <td style="width: 40px">
                                                        <span style="width: 40px; padding-left: 10px;" valign="middle">
                                                            <i class="gladinet-icons md-24  hand center" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                        </span>

                                                    </td>

                                                </tr>
                                            
                                            <% if (m_CanViewReports) { %>  
                                            <tr style="border-bottom: 0px solid #f0f0f0; " class="filerow" onclick="OnClusterReports();return false;">

                                                    <td style="padding: 5px; font-size: 16px;width:40px;" >
                                                        <i 
															 class="gladinet-icons md32 iconviewitemcolor hand center ">R</i>
                                                    </td>
                                                    <td >
                                                        <span style="font-size: 16px; margin-left: 10px;" class="sectextcolor"><asp:Localize runat="server" meta:resourcekey="str_rep">Reports</asp:Localize></span>
                                                    </td>
                                                    <td style="width: 40px">
                                                        <span style="width: 40px; padding-left: 10px;" valign="middle">
                                                            <i class="gladinet-icons md-24  hand center" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                        </span>

                                                    </td>

                                                </tr>
                                               <% } %>  
                                                
                                                <% if (!IsServo) {%>
                                                <tr style="border-bottom: 0px solid #f0f0f0; " class="filerow">

                                                    <td style="padding: 5px; font-size: 16px;width:40px;">
                                                        <i class="gladinet-icons md32 iconviewitemcolor hand center " style="font-size:30px;">T</i>
                                                    </td>
                                                    <td>
                                                        <span style="font-size: 16px; margin-left: 10px;" class="sectextcolor"><asp:Localize runat="server" meta:resourcekey="str_mulTen">Multi-Tenancy</asp:Localize></span>
                                                    </td>
                                                    <td style="width: 40px">     
                                                        <div style="display:none;">
                                                            <asp:LinkButton ID="LnkBtnEnableMultiTenancy" runat="server" OnClick="LnkBtnEnableMultiTenancy_Click"></asp:LinkButton> 
                                                            <asp:LinkButton ID="LnkBtnDisableMultiTenancy" runat="server" OnClick="LnkBtnDisableMultiTenancy_Click"></asp:LinkButton>
                                                        </div>
                                                        <% if (m_MultiTenant) {%>
                                                           <i class="gladinet-icons md32 iconviewitemcolor hand center" style="font-size:40px;" onclick="DisableMultiTenancy();" title="<asp:Localize runat="server" meta:resourcekey="str_ebl">Enabled</asp:Localize>">&#x015a;</i>
                                                        <% } else { %>
                                                           <i class="gladinet-icons md32 iconviewitemcolor hand center" style="font-size:40px;" onclick="EnableMultiTenancy();" title="<asp:Localize runat="server" meta:resourcekey="str_dbl">Disabled</asp:Localize>">&#x015b;</i>
                                                        <% } %>
                                                    </td>

                                                </tr>        
                                                <% } %>
                                                
                                                
                                                
                                            </table>
                                                    
                                    </div>
                                </div>

                            </div>

                            <div class="col-12 dashChart"  style="padding-bottom: 10px;"> 
                                <% if (m_CanViewReports) { %>
                                <div class=" staticviewcarddark" style="padding: 0px;">
                                    <div class="panel-body" style=" width: 100%;padding: 15px;" id="RansomeWarediv">
                                        
                                        <table width="100%" style="font-weight:100; color: #565656;">
                                                <tr style="border-bottom: 1px solid #f0f0f0; " class="filerow" onclick="OnClusterPerf();return false;">

                                                    <td style="padding: 5px; font-size: 16px;width:180px;" >
                                                        <asp:Localize runat="server" meta:resourcekey="str_reqTot">Requests (Total)</asp:Localize></td>
                                                    <td >
                                                        <span class="hollowbadge badge" style="font-size: 16px; margin-left: 10px;" id="request_t">--</span>
                                                    </td>
                                                    <td style="width: 40px">
                                                        <span style="width: 40px; padding-left: 10px;" valign="middle">
                                                            <i class="gladinet-icons md-24  hand center" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                        </span>

                                                    </td>

                                                </tr>
                                                <tr style="border-bottom: 1px solid #f0f0f0; " class="filerow" onclick="OnClusterPerf();return false;">

                                                    <td style="padding: 5px; font-size: 16px;width:180px;" >
                                                        <asp:Localize runat="server" meta:resourcekey="str_reqAct">Requests (Active)</asp:Localize></td>
                                                    <td >
                                                        <span class="hollowbadge badge" style="font-size: 16px; margin-left: 10px;" id="request_a">--</span>
                                                    </td>
                                                    <td style="width: 40px">
                                                        <span style="width: 40px; padding-left: 10px;" valign="middle">
                                                            <i class="gladinet-icons md-24  hand center" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                        </span>

                                                    </td>

                                                </tr>
                                            <tr style="border-bottom: 1px solid #f0f0f0; " class="filerow" onclick="OnClusterPerf();return false;" >

                                                    <td style="padding: 5px; font-size: 16px;width:180px;" ><asp:Localize runat="server" meta:resourcekey="str_resTim">Response Time</asp:Localize></td>
                                                    <td >
                                                        <span class="hollowbadge badge" style="font-size: 16px; margin-left: 10px;" id="request_tt">--</span>
                                                    </td>
                                                    <td style="width: 40px">
                                                        <span style="width: 40px; padding-left: 10px;" valign="middle">
                                                            <i class="gladinet-icons md-24  hand center" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                        </span>

                                                    </td>

                                                </tr>
                                            <tr style="border-bottom: 1px solid #f0f0f0; " class="filerow" onclick="OnClusterUpload();return false;">

                                                    <td style="padding: 5px; font-size: 16px;" ><asp:Localize runat="server" meta:resourcekey="str_actUpl">Active Upload</asp:Localize></td>
                                                    <td >
                                                        <span class="hollowbadge badge" style="font-size: 16px; margin-left: 10px;" id="request_u">--</span>
                                                    </td>
                                                    <td style="width: 40px">
                                                        <span style="width: 40px; padding-left: 10px;" valign="middle">
                                                            <i class="gladinet-icons md-24  hand center" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                        </span>

                                                    </td>

                                                </tr>
                                            <tr style="border-bottom: 1px solid #f0f0f0; " class="filerow" onclick="OnClusterDownload();return false;">

                                                    <td style="padding: 5px; font-size: 16px;" ><asp:Localize runat="server" meta:resourcekey="str_actDow">Active Download</asp:Localize></td>
                                                    <td >
                                                        <span class="hollowbadge badge" style="font-size: 16px; margin-left: 10px;" id="request_d">--</span>
                                                    </td>
                                                    <td style="width: 40px">
                                                        <span style="width: 40px; padding-left: 10px;" valign="middle">
                                                            <i class="gladinet-icons md-24  hand center" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                        </span>

                                                    </td>

                                                </tr>
                                            <tr style="border-bottom: 1px solid #f0f0f0; " class="filerow" onclick="OnClusterBandwidth();return false;">

                                                    <td style="padding: 5px; font-size: 16px;" ><asp:Localize runat="server" meta:resourcekey="str_upl">Upload</asp:Localize></td>
                                                    <td >
                                                        <span class="hollowbadge badge" style="font-size: 16px; margin-left: 10px;" id="bu">--</span>
                                                    </td>
                                                    <td style="width: 40px">
                                                        <span style="width: 40px; padding-left: 10px;" valign="middle">
                                                            <i class="gladinet-icons md-24  hand center" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                        </span>

                                                    </td>

                                                </tr>
                                            <tr style="border-bottom: 1px solid #f0f0f0; " class="filerow" onclick="OnClusterBandwidth();return false;">

                                                    <td style="padding: 5px; font-size: 16px;" ><asp:Localize runat="server" meta:resourcekey="str_dow">Download</asp:Localize></td>
                                                    <td >
                                                        <span class="hollowbadge badge" style="font-size: 16px; margin-left: 10px;" id="bd">--</span>
                                                    </td>
                                                    <td style="width: 40px">
                                                        <span style="width: 40px; padding-left: 10px;" valign="middle">
                                                            <i class="gladinet-icons md-24  hand center" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                        </span>

                                                    </td>

                                                </tr>
                                            </table>  
                                    </div>
                                </div>   
                                <% } %>
                            </div>
                            

                        </div>
                    </div>

                </td>
            </tr>
        </table>
    </div>


    <div id="myModal" class="modal fade" role="dialog">

        <div class="modal-dialog">

            <div class="modal-content" style="width: 600px;">
                <div class="modal-header" style="display: none;">


                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <table width="100%">
                        <tr>
                            <td style="font-size: 16px; font-weight: 100; color: #202020;">
                                <asp:Localize meta:resourcekey="asp_string2" runat="server">External URL</asp:Localize>
                                (https://mydomain.com)
                    <p style="font-size: 12px; color: #565656; font-weight: 100;"><asp:Localize runat="server" meta:resourcekey="str_thiExtAddThaWil">This is the external address that will be used for offsite access. Please consult your IT administrator if you are not sure what it should be.</asp:Localize></p>
                        </tr>
                        <tr>
                            <td>
                                <table style="width: 100%;">
                                    <tr>
                                        <td>
                                            <asp:RadioButton GroupName="extdnsgroup" ID="UseTunel" runat="server" Text="Use default tunneled DNS" meta:resourcekey="str_useDefTunDNS" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <table>
                                                <tr>
                                                    <td style="font-size: 16px; font-weight: 100; color: #202020;"><asp:Localize runat="server" meta:resourcekey="str_Htt">https://</asp:Localize></td>
                                                    <td>
                                                        <asp:TextBox ID="TunelDnsName" runat="server" Text="mydns" CssClass="form-control"></asp:TextBox>
                                                    </td>
                                                    <td style="font-size: 16px; font-weight: 100; color: #202020;">
                                                        <asp:Label ID="DnsZoneName" runat="server" Text=".triofox.net"></asp:Label>
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>

                                    </tr>
                                </table>

                            </td>
                        </tr>

                        <tr>
                            <td style="padding-top: 20px;">
                                <table style="width: 100%;">
                                    <tr>
                                        <td>
                                            <asp:RadioButton GroupName="extdnsgroup" ID="UseOwnExt" runat="server" Text="Use my own public DNS" meta:resourcekey="str_useOwnPubDNS" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <asp:TextBox ID="ExternalDNS" runat="server" Text="http://localhost"
                                                CssClass="form-control"></asp:TextBox>
                                        </td>

                                    </tr>
                                </table>
                            </td>
                        </tr>

                    </table>

                </div>
                <div class="modal-footer">
                    <asp:Button ID="ApplyExtDns" runat="server" meta:resourcekey="str_app" Text="Apply" CssClass="btn btn-primary gladbtn"
                        OnClick="ApplyExtDns_Click" OnClientClick="CloseAndWait();" />

                    <button type="button" class="btn btn-default" data-dismiss="modal">
                        <asp:Localize runat="server" meta:resourcekey="str_can">Cancel</asp:Localize></button>
                </div>
            </div>
        </div>
    </div>

    <div style="display: none">
        <asp:Panel ID="NoAdPanel" runat="server"></asp:Panel>
        <asp:Label ID="ErrorMsg" runat="server" CssClass="errmsg"
            meta:resourcekey="ErrorMsgResource1"></asp:Label>

        
        <asp:Localize ID="LocFilUpd" runat="server" meta:resourcekey="str_filUpd" Visible="false">Files Uploaded</asp:Localize>
        <asp:Localize ID="LocTme" runat="server" meta:resourcekey="str_tme" Visible="false">Time</asp:Localize>
        <asp:Localize ID="LocFil" runat="server" meta:resourcekey="str_fil" Visible="false">Files</asp:Localize>
        <asp:Localize meta:resourcekey="str_impNtkFilShr" runat="server" Visible="false">Imported Network File Shares</asp:Localize>
        <span id="sectextcolor" class="sectextcolor"></span>
        <span id="lighttextcolor" class="lighttextcolor"></span>
        <asp:Localize runat="server" ID="LocUlt" meta:resourcekey="str_ult" Visible="false">Unlimited</asp:Localize>
        <asp:Localize meta:resourcekey="str_daysgao" ID="StrDaysAgo" runat="server" Visible="False"> Days ago</asp:Localize>
        <asp:Localize meta:resourcekey="str_hoursago" ID="StrHoursAgo" runat="server" Visible="False"> Hours ago</asp:Localize>
        <asp:Localize meta:resourcekey="str_minsago" ID="StrMinsAgo" runat="server" Visible="False"> Minutes ago</asp:Localize>
        <asp:Localize meta:resourcekey="str_lessmin" ID="StrLessMin" runat="server" Visible="False">Less than 1 minute ago</asp:Localize>

        <asp:HiddenField ID="CurrentHost" runat="server" />
    </div>
    <script type="text/javascript">
        
        function CloseAndWait(){
            $('#myModal').modal('hide');
            Wait('Uploading');
        }
        function DisplayError() {

            var d = document.getElementById("ctl00_MainContent_ErrorMsg");
            if (d) {
                if (d.innerHTML != "") {
                    
                    alert( d.innerHTML);
                    
                }
            }
        }
        
        
        function DrawChartF()
        {
        
        }
        
        function adjust() {
        
            
              
              
        }

        function stringStartsWith(s, p) {
            return (s.indexOf(p) == 0);
        }
        var ra;
        var rt;
        var rtt;
        var ru;
        var rd;
        var bu;
        var bd;

        function OnPollRes(m) {
            try {
                if (stringStartsWith(m, "bad^")) {                
                    ra.innerHTML = "--";
                    rt.innerHTML = "--";
                    setTimeout("Poll()", 3000);               
                    return;
                }

                var res = m.split("|");
                ra.innerHTML = res[0];
                rt.innerHTML = res[1];
                rtt.innerHTML = res[2];
                rd.innerHTML = res[3];
                ru.innerHTML = res[4];
                bu.innerHTML = res[5];
                bd.innerHTML = res[6];

            } catch (ee) {

            }
            setTimeout("Poll()", 1000);
        }
        function Poll() {


            try {
                Ext.Ajax.request({
                    url: '/management/csbiz/CSBizClusterDashboard.aspx?vdid=<%=SessionDomainId%>&poll=1',
                    success: function (response) {

                        OnPollRes(response.responseText);
                    },
                    failure: function () {                        
                        OnPollRes('bad^unknown');
                    },
                    method: 'GET'
                });

            } catch (e) {
                alert(e);
            }


        }
        try {
            
            if(parent.SwitchToSecondPageTitle)
                parent.SwitchToSecondPageTitle('');
           
        } catch (e) {
            
        }
        Ext.onReady(function () {
           
            <%if(!string.IsNullOrEmpty(mRedirUrl)){%>
            top.location.replace("<%=mRedirUrl%>");
            return;
            <%}%>
            
            ra = document.getElementById("request_a");
            rt = document.getElementById("request_t");
            rtt = document.getElementById("request_tt");
            ru = document.getElementById("request_u");
            rd = document.getElementById("request_d");
            bu = document.getElementById("bu");
            bd = document.getElementById("bd");
            setTimeout("Poll()", 1000);

            adjust();
        
              
            DrawChartF();
            DisplayError();

            try {
                parent._m_MultiTenant = "<%=m_MultiTenant%>";
            } catch (ex) {}
        
        });
        
        
    </script>
</asp:Content>
