﻿<%@ Page Title="Office Web Apps" Language="C#" MasterPageFile="SpreadsheetMaster.master"
    AutoEventWireup="true" CodeBehind="Spreadsheet.aspx.cs" Inherits="Gladinet.BuiltInWebApps.Spreadsheet" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
     <meta  name = "viewport" content = "initial-scale = 1.0, maximum-scale = 1.0, user-scalable = no" />
    <script src="/management/BuiltInApps/SpreadSheet/editor/codebase/webix/webix.js?v=6.4.3" type="text/javascript"></script>
    <script src="/management/BuiltInApps/SpreadSheet/editor/codebase/spreadsheet.js?v=6.4.3" type="text/javascript"></script>

    <link rel="stylesheet" type="text/css" href="/management/BuiltInApps/SpreadSheet/editor/codebase/webix/webix.css?v=6.4.3"/>
    <link rel="stylesheet" type="text/css" href="/management/BuiltInApps/SpreadSheet/editor/codebase/spreadsheet.css?v=6.4.3"/>

    <link rel="stylesheet" href="/portal/gladtheme.aspx?<%Response.Write("");%><%=ThemeVer%>"  type="text/css"  />
    <link rel="stylesheet" href="/management/bootstrap4/css/bootstrap-material-design.min.css" />
    <style type="text/css">
        @import url("<%=this.ExtCSS%>");
    </style>
   <style type="text/css">
        body {
            margin: 0;
            padding: 0;
            overflow:hidden!important;
            -ms-content-zooming: none;
        }
       <% if (!m_ShowSaveButtonInDocEditor) { %>
       #countdownwindow{display:none;}
       <% } %>
        
    </style>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">    
    <asp:Localize ID="LocFaiToLoaFilInf" meta:resourcekey="str_faiToLoaFilInf" Visible="false" runat="server">Failed to load file information</asp:Localize>
     <div style="position:absolute; top:110px; right:10px; width:400px; z-index:20000; height:70px;" id="countdownwindow">
                    
                        <table width="100%"  style="margin-top:-20px;">
                            
                            <tr>
                                <td valign="middle" align="center"><button class="btn btn-primary gladbtn" onclick="saveFile();return false;"><asp:Localize runat="server" meta:resourcekey="str_SavNow">Save Now</asp:Localize></button></td>
                            </tr>
                            <tr>
                                <td id="counttime" style="font-size:12px; font-weight:100; color:#404040;" valign="middle" align="center"></td>
                            </tr>
                        </table>

                </div>
         <div style="position:absolute; top:110px; right:10px; width:400px; display:none; " id="progresswindow">
                    <table width="100%"  >
                            <tr>
                                <td  style="color: #404040; font-size: 14px; font-weight: 100;" align="center" valign="middle" id="progress">
                                    
                                </td>
                            </tr>
                            <tr >
                                <td height="40px" align="center" valign="top" >
                                    <div class="progress">
                                        <div class="progress-bar  active" role="progressbar" id="probar"
                                            aria-valuenow="40" aria-valuemin="0" aria-valuemax="100" style="width: 0%">
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        </table>
                        

                </div>
    <%if (!IsChildUi){ %>
    <div   style="width:100%; "  class="topnavcolor" >
    <table width="100%">
        
        <tr >
            <td style="width:40px;padding-left:10px;">
                <span class="gladinet-icons  center" style="font-size:40px;line-height:40px;margin-right:7px; color:white;">&#x127;</span>
            </td>
            <td style="padding:3px; height:72px; font-size:24px; padding-left:10px; color:white; font-weight:300;" valign="middle">
                <asp:Label ID="FileName" runat="server" Text=""></asp:Label>
            </td>
            <td>
                <div id="errmsgdiv" >
                <b>
                    <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
            </div>
            </td>
            <td id="errortd" style="color:red;"></td>
            <td style="padding-top:20px;">
                
               
            </td>
            <td  style="padding:3px; color:white; font-weight:300;padding-right:10px;" align="right">
                <asp:Label ID="ProductName" runat="server" Text=""></asp:Label><br />
                <asp:Label ID="UserName" runat="server" Text=""></asp:Label>
            </td>
        </tr>
        
        <tr style="display:none;">
            <td>
                <button class="btn btn-primary gladbtn" onclick="saveFile();return false;"><asp:Localize runat="server" meta:resourcekey="str_Sav">Save</asp:Localize></button>
            </td>
        </tr>
    </table>
       
        </div>
    
    <%} %>
    
    <script type="text/javascript" src="/management/bootstrap4/extern/jquery.slim.min.js"></script>
    <script type="text/javascript" src="/management/bootstrap4/extern/popper.js"></script>
    <script type="text/javascript" src="/management/bootstrap4/js/bootstrap-material-design.js"></script>
    <asp:Label ID="Msg" runat="server" visible="false" Text="Label"></asp:Label>
  <script type="text/javascript">

      var saveTime = null;
      var SaveSeconds = 30;

      function saveFile() {
      <% if (m_ShowSaveButtonInDocEditor) { %>
          if (saveTime)
              clearTimeout(saveTime);
          saveTime = null;
          var e = document.getElementById("countdownwindow");
          e.style.display = "none";
          
          
          webix.toExcel($$("data"), { download: false }).then(function (b) {
              var e = document.getElementById("progresswindow");
              e.style.display = "";
              
              UploadFile(b);
          });
      <% } %>
      }

      function onChangeTimer() {
          
          --SaveSeconds;
          if (SaveSeconds == 0) {
              saveFile();
              return;
          }

          e = document.getElementById("counttime");
          e.innerHTML = "Auto save in " + SaveSeconds + " seconds";
          saveTime = setTimeout("onChangeTimer();", 1000);
      }
      function onFileChanged()
      {
          <% if (m_ReadOnly) { %>
          return;
          <% } %>
          <% if (m_ShowSaveButtonInDocEditor) { %>
          if (saveTime)
              return;

          var e = document.getElementById("countdownwindow");
          e.style.display = "";
          SaveSeconds = 30;
          saveTime = setTimeout("onChangeTimer();", 1000);
          <% } %>
      }

      function FormatFileSize(size) {
          if (size < 1024) { //pow(2,10)
              return size + " bytes";
          } else if (size < 1048576) { //pow(2,20)
              return (Math.round(((size * 10) / 1024)) / 10) + " KB";
          } else if (size < 1073741824) { //pow(2,30)
              return (Math.round(((size * 10) / 1048576)) / 10) + " MB";
          } else if (size < 1099511627776) { //pow(2,40)
              return (Math.round(((size * 100) / 1073741824)) / 100) + " GB";
          } else if (size < 1125899906842624) { //pow(2,50)
              return (Math.round(((size * 100) / 1099511627776)) / 100) + " TB";
          } else { //pow(2,60)
              return (Math.round(((size * 100) / 1125899906842624)) / 100) + " PB";
          }
      }


      function OnTaskStatusChange(Completed, Total) {
          try {
              if (Total != 0) {
                  //TaskItem[0].updateProgress(Completed * 1.0 / Total, "");


                  var ee = document.getElementById("progress");
                  ee.innerHTML = FormatFileSize(Completed) + "/" + FormatFileSize(Total);

                  ee = document.getElementById("probar");
                  ee.style.width = Math.round(Completed * 100 / Total) + "%";
              }
          } catch (e) {

          }

      }
      function OnTaskFailed(reason) {
          var ee = document.getElementById("errortd");
          ee.innerHTML = reason;
          
      }

      function OnTaskCompleted() {
          
          var e = document.getElementById("progresswindow");
          e.style.display = "none";
      }

      function OnTaskAborted() {
          var ee = document.getElementById("errortd");
          ee.innerHTML = "Aborthed by user";
          
      }

       var OutstandingReq;
      function UploadFile(file) {

          
            //new FileReader(); use file reader later
            OnTaskStatusChange( 0, file.size);

            var xhr = new XMLHttpRequest();
            OutstandingReq = xhr;
            

            xhr.onloadend = function (e) {

                if (xhr.status > 300) {
                    var Reason;

                    if (xhr.status == 403)
                        Reason = "No permission to upload" ;
                    else if (xhr.status == 422)
                        Reason = " virus detected" ;
                    else
                        Reason = "Unable to upload" ;
                    OnTaskFailed( Reason);
                    return;
                }

                OnTaskCompleted();

            };

            try {
                xhr.upload.onprogress = function (oEvent) {
                    try {
                        var total = oEvent.totalSize || oEvent.total;
                        var done = oEvent.position || oEvent.loaded;
                        if (oEvent !== undefined && oEvent !== null && total > 0) {
                            OnTaskStatusChange( done, total);
                        }
                    } catch (eeee) {

                    }


                };

                xhr.onerror = function (e) {
                    OnTaskFailed( "Failed");
                    return;

                };
                xhr.onabort = function (e) {
                    OnTaskAborted();
                    return;
                };
                xhr.onload = function (e) {
                    return;
                };


            } catch (e) {

            }

            xhr.open('PUT', "<%=m_UploadUrl%>", true);
            //xhr.setRequestHeader("Content-Length", "" + Total);

            

            xhr.setRequestHeader("Content-Type", "application/octet-stream");
            
            
            
            



            xhr.send(file);
            return;

        }
      function adjustSize() {

          try {
              
              
          } catch (ee) {
              alert(ee);
          }
      }
      function getToolBar() {
        <% if (m_ReadOnly) { %>
          return false;
        <% } else { %>
          return "full";
        <% } %>
      }

      webix.ready(function () {

          webix.ui({
              toolbar: getToolBar(),
              view: "spreadsheet",
              id: "data",
              url: "binary-><%=m_DownloadUrl%>",
              datatype: "excel",
              bottombar:true,
              on: {
                  onChange: function (mode, name, oldName) {
                      
                      setTimeout("onFileChanged();", 100);
                  }
              }
          });



          var e = document.getElementsByClassName("webix_toolbar");
          try{
              e = document.getElementsByClassName("ssi-excel-import");
              e[0].parentNode.parentNode.parentNode.parentNode.style.display = "none";
          } catch (E) {

          }
          <%if (IsChildUi){ %>
          
          try{
              e = document.getElementById("aspnetForm");              
              e.style.display = "none";

          } catch (ee) {

          }
          <%} %>
          window.onresize = function (event) {
             
              adjustSize();
          };
      });

  </script>
</asp:Content>
