﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="DocEditor.aspx.cs" Inherits="OnlineEditorsExample.DocEditor" Title="OnlyOffice Web Editor" %>

<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="OnlineEditorsExample" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <link rel="icon" href="~/favicon.ico" type="image/x-icon" />
    <title>ONLYOFFICE™</title>

    <style>
        html {
            height: 100%;
            width: 100%;
        }

        body {
            background: #fff;
            color: #333;
            font-family: Arial, Tahoma,sans-serif;
            font-size: 12px;
            font-weight: normal;
            height: 100%;
            margin: 0;
            overflow-y: hidden;
            padding: 0;
            text-decoration: none;
        }

        form {
            height: 100%;
        }

        div {
            margin: 0;
            padding: 0;
        }
    </style>
    <script type="text/javascript" src="/webui/ext42/bootstrap.js"></script>
    <script language="javascript" type="text/javascript" src="<%= DocServiceApiUri %>"></script>

    <script type="text/javascript" language="javascript">

        
        var docEditor;
        var fileName = "<%= FileName %>";
        var fileType = "<%= Path.GetExtension(FileName).Trim('.') %>";

        var innerAlert = function (message) {
            if (console && console.log)
                console.log(message);
            ;
        };

        var onReady = function () {
            innerAlert("Document editor ready");
        };

        var onBack = function () {           
        };

        var onDocumentStateChange = function (event) {
            
            var title = document.title.replace(/\*$/g, "");
            document.title = title + (event.data ? "*" : "");
        };

        var onRequestEditRights = function () {
            
            if (typeof DocsAPI.DocEditor.version == "function") {
                var version = DocsAPI.DocEditor.version();
                if ((parseFloat(version) || 0) >= 3) {
                    location.href = location.href.replace(RegExp("action=view\&?", "i"), "");
                    return;
                }
            }
            docEditor.applyEditRights(true);
        };

        var onDocumentSave = function (event) {
            
            SaveFileRequest(fileName, fileType, event.data);
        };

        var onError = function (event) {
            if (console && console.log && event)
                console.log(event.data);
        };



        var сonnectEditor = function () {

            docEditor = new DocsAPI.DocEditor("iframeEditor",
            {
                width: "100%",
                height: "100%",

                type: 'desktop',
                documentType: "<%= DocumentType %>",
                document: {
                    title: fileName,
                    url: "<%= mFileUri %>",
                    fileType: fileType,
                    key: "<%= mFileKey %>",
                    info: {
                        author: "<%=mUserName %>",
                        created: "<%= mLastModified %>"
                    },

                    permissions: {
                        edit: true,
                        download: true
                    }
                },
                editorConfig: {
                    mode: 'edit',
                    lang: "en",
                    user: {
                        id: "<%= mUserId %>",
                        name: "<%=mUserName %>"
                    },
                    customization: {
                        
                        goback: {
                            visible: false,
                            text: 'Go to Documents'
                        },
                        about: false,
                        chat: false,
                        spellCheck: false

                    },
                        embedded: {
                            saveUrl: "<%= mFileUri %>",
                            embedUrl: "<%= mFileUri %>",
                            shareUrl: "<%= mFileUri %>",
                            toolbarDocked: "top"
                        }
                    },
                    
                    events: {
                        'onReady': onReady,
                        'onBack':  "undefined",
                        'onDocumentStateChange': onDocumentStateChange,
                        'onRequestEditRights': onRequestEditRights,
                        'onSave': onDocumentSave,
                        'onError': onError
                    }
                });
        };

        <%if(mHasValidSession){ %>
        if (window.addEventListener) {
            window.addEventListener("load", сonnectEditor);
        } else if (window.attachEvent) {
            window.attachEvent("load", сonnectEditor);
        }
        <%} %>

        function getXmlHttp() {
            var xmlhttp;
            try {
                xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
            } catch (e) {
                try {
                    xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
                } catch (ex) {
                    xmlhttp = false;
                }
            }
            if (!xmlhttp && typeof XMLHttpRequest != 'undefined') {
                xmlhttp = new XMLHttpRequest();
            }
            return xmlhttp;
        }

       
        function SaveFile(Url) {
            

        }

        function SaveFileRequest(fileName, fileType, fileUri) {
            SaveFile(fileUri);


           
        }

    </script>
</head>
<body>
    <asp:Localize runat="server" ID="LocFaiToRetSesInf" meta:resourcekey="str_faiToRetSesInf" Visible="false">Failed to retrieve session info</asp:Localize>
    <asp:Localize runat="server" ID="LocFaiToGenFilDowLin" meta:resourcekey="str_faiToGenFilDowLin" Visible="false">Failed to generate file download link</asp:Localize>
    <asp:Localize runat="server" ID="LocMisAppSesId" meta:resourcekey="str_misAppSesId" Visible="false">Missing Application Session Id</asp:Localize>
    <form id="form1" runat="server">
        <div id="iframeEditor">
        </div>
        <%if(!mHasValidSession){ %>
            <asp:Label ID="ErrorMsg" runat="server" Text="Label"></asp:Label>
        <%} %>
    </form>
</body>
</html>
