﻿<%@ Page Title="Open with Web Application" Language="C#" MasterPageFile="../WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="ClusterApplicationMgr.aspx.cs" Inherits="GladinetPayFlow.ClusterApplicationMgr" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <script type="text/javascript">
        function OpenApplication(appid) {

            var ng = document.getElementById("ctl00_MainContent_ApplicationId");
            var btn = document.getElementById("ctl00_MainContent_OpenNow");
            ng.value = appid;
            btn.click();

        }

        var activewin;
        function ConfigApplication(appid) {

            activewin = new Ext.Window({
                id: 'quota_win',
                title: "<asp:Localize meta:resourcekey="str_cfgApl" runat="server">Configure Application</asp:Localize>",
                width: 580,
                height: 360,
                plain: true,
                modal: true,
                maximizable: false,
                maximized: false,
                layout: 'fit',
                bodyPadding: 3,
                html: "<iframe id='openwin' src='"+appid+"' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>",
                defaults: {
                    border: false
                }
            });
            activewin.show();

        }

        function closeCancelActiveWin() {
            activewin.close();
        }

        function closeActiveWin() {
            window.location = "/management/ApplicationMgr.aspx";
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocNoAppFou" meta:resourcekey="str_noAppFou" Visible="false">No application found</asp:Localize>
    <div style="height: 80px">
        &nbsp;</div>
    <table width="968" align="center" border="0" cellspacing="0" cellpadding="0" id="main_content"
        class="checkout3" style="background-color:White;">
        <tr>
            <td id="main_content">
                <table align="center" width="100%">
                    <tr>
                        <td style="height: 20px; color: #008000; border-bottom: 1px solid #e0e0e0" colspan="3">
                            <h2>
                                <asp:Localize meta:resourcekey="asp_string1" runat="server">Available Applications:</asp:Localize></h2>
                            <div id="errmsgdiv">
                                <b>
                                    <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" 
                                    meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                            </div>
                        </td>
                    </tr>
                    <asp:Repeater ID="ApplicationRepeater" runat="server">
                        <ItemTemplate>
                            <tr style="padding-top: 25px;">
                                <td width="140px" rowspan="2" style="padding-top: 0px; padding-top: 10px; border-bottom: 1px solid #e0e0e0">
                                    <img src='<%# DataBinder.Eval(Container.DataItem, "IconUri") %>' width="120px" />
                                </td>
                                <td style="font-size: 14px; padding-top: 10px;">
                                    <input type="checkbox" 
                                        onclick='OpenApplication(&#039;<%# DataBinder.Eval(Container.DataItem, "ApplicationId") %>&#039;);' 
                                        <%# DataBinder.Eval(Container.DataItem, "EnableCheck") %> >
                                    <a href="javascript:;" style="font-size: 14px; color: #008000" onclick="return false;"><b>
                                        <%#DataBinder.Eval(Container.DataItem, "ApplicationName")%></b> </a>
                                </td>
                                <td>
                                <a href="javascript:;" 
                                        style='display:<%# DataBinder.Eval(Container.DataItem, "ConfigDisplayMode") %>; border-bottom: 1px solid #e0e0e0' 
                                        onclick='ConfigApplication(&#039;<%# DataBinder.Eval(Container.DataItem, "ConfigUri") %>&#039;);return false;'><asp:Localize meta:resourcekey="asp_string2" runat="server">Configure</asp:Localize></a>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2" style="padding-bottom: 30px; border-bottom: 1px solid #e0e0e0">
                                    <%#DataBinder.Eval(Container.DataItem, "Description")%>
                                </td>
                            </tr>
                        </ItemTemplate>
                    </asp:Repeater>
                    <tr>
                        <td colspan="2">
                            &nbsp;
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
    <asp:HiddenField ID="FileLoc" runat="server" />
    <div style="display: none;">
        <asp:Button ID="OpenNow" runat="server" Text="Button" OnClick="OpenNow_Click" 
            meta:resourcekey="OpenNowResource1" />
        <asp:HiddenField ID="ApplicationId" runat="server" />
    </div>
</asp:Content>
