﻿<%@ Page Title="Gladinet Cloud Cluster" Language="C#" MasterPageFile="~/WebAppPanel.master" 
    AutoEventWireup="true" CodeBehind="BrandingEmail.aspx.cs" Inherits="GladinetPayFlow.BrandingEmail"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        
          td {
            font-size: 15px;
            
            font-weight: 100;
        }
        .gladsmallbtn {
            font-size: 12px;
            font-weight: 100;
        }        
        b {
            font-weight: 500;
        }
         #brandc
         {
             background-image: url('images/branding.jpg');
             background-repeat: no-repeat;
             background-position: right bottom;
             border-style: solid;
             border-width: 1px;
             border-color: #cccccc;
         }
        .main
        {
            position: relative;
            min-height: 100%;
            padding: 0px;
        }
        .wrapper
        {
            padding: 0px;
      
            padding-bottom: 68px;
        }
        .footer, .push
        {
            height: 68px; /* .push must be the same height as .footer */
        }
        
        .footer
        {
            position: absolute;
            width: 100%;
            bottom: 0;
            left: 0;
        }
        
        *
        {
            margin: 0px;
            padding: 0px;
        }
        
        .panel-title{
            color:#565656!important;
            font-weight:100!important;
            font-size:16px!important;
        }
     
        
                .whitehead {
            background-color: white !important;
        }

    </style>
    <style type="text/css">
        .pricetable
        {
            border: 1px solid #cccccc;
        }
        
        .plain9BlackOnNone
        {
            border-bottom: 1px solid #cccccc;
            border-right: 1px solid #cccccc;
        }
        .offer_flex
        {
            background: #FFFFE0 url('images/giftbox.png') no-repeat 8px center;
            border: 1px solid #E6DB55;
            border-radius: 4px 4px 4px 4px;
            color: #000000;
            height: 54px;
            line-height: 18px;
            padding: 2px;
            padding-left: 16px;
            width: 868px;
            vertical-align: middle;
            text-align: center;
            margin: auto;
            margin-bottom: 16px;
        }
        
        .offertitle
        {
            line-height: 24px;
        }
        .offertext
        {
            line-height: 20px;
        }
        
        .offer_flex1
        {
            border: 1px solid #E6DB55;
            border-radius: 4px 4px 4px 4px;
            margin: auto;
        }
   

    </style>
    
    <script type="text/javascript" src="/webui/tinymce/tinymce.min.js"></script>

    <script type="text/javascript">
        function ReloadWithoutPostback(editMode) {
            var url = location.href;
            if(url.indexOf("&edit=")){
                url = url.replace(/&edit=[1|0]/g,"");
            }
            var edtMde = "&edit=1";
            if(!editMode){
                edtMde = "&edit=0";
            }
            if(url.indexOf("?")){
                url = url + edtMde;
            }else{
                url = url + "?" + edtMde;
            }
            var expanded = document.getElementById("<%=hidExpandedSectionID.ClientID %>");
            if(expanded){
                if(expanded.value != ""){
                    url = url + "&exp=" + expanded.value;
                }
            }
            location.href = url;
        }
        function replaceHTMLDelimiters(str) {
            str = str.replace(/</g, "[[");
            str = str.replace(/>/g, "]]");
            return str;
        }
        function replaceHTMLSafeDelimiters(str) {
            str = str.replace(/\[\[/g, "<");
            str = str.replace(/\]\]/g, ">");
            return str;
        }
        function SendEmailAjaxSuccessHandler(jObj){
            if (jObj.Success) {
                alert("<%=LocSenSuc.Text %>");//Sent successfully
            } else {
                alert("<%=LocFaiSenEma.Text %>");//Failed to send email
            }
        }
        function SendEmailAjax(subj,msg){
            var fetchNotSupported = (typeof window.fetch === "undefined");
            var postBackUrl = "BrandingEmail.aspx?sndeml=1";
            var headersObj = {'Content-Type': 'application/json'};
            var bodyObj = new Object();
            bodyObj.brandingObjectID = $("#<%=BrandingObjectId.ClientID %>").val();
            bodyObj.subject  = subj;
            bodyObj.message = msg;
            if(fetchNotSupported){
                Ext.Ajax.request({
                    method: 'POST',
                    url: postBackUrl,
                    headers: headersObj,
                    params: JSON.stringify(bodyObj),
                    success: function (response) {
                        var resp = JSON.parse(response.responseText);
                        SendEmailAjaxSuccessHandler(resp);
                    },
                    scope: this,
                    failure: function () {
                        alert("<%=LocFaiSenEma.Text %>");//Failed to send email
                    }
                });
            }
            else
            {
                fetch(postBackUrl, {
                    method: 'POST',
                    headers: headersObj,
                    body: JSON.stringify(bodyObj)
                }).then(function (response) {
                        if (response.status !== 200) {
                            alert("<%=LocFaiSenEma.Text %>. Error " + response.status);//Failed to send email
                            return;
                        }
                    response.json().then(function (x) {
                        SendEmailAjaxSuccessHandler(x);
                        });
                    }).catch(function (err) {
                    alert("<%=LocFaiSenEma.Text %>. Error " + err);//Failed to send email
                });
            }
        }
        function SanitizeAndSendEmailAjax(subClientID, msgClientID) {
            KillTinyMCE();
            var subject = "";
            if(subClientID!=""){
                subject = replaceHTMLDelimiters($("#"+subClientID).val());
            }
            var message = replaceHTMLDelimiters($("#"+msgClientID).val());
            iniTinyMce();
            SendEmailAjax(subject,message);
        }
        function KillTinyMCE(){
            var elemsRef = document.forms[0].elements;
            //hide all tinymce so the sanitation replacements don't become visible
            $(".panel-collapse.show").removeClass("show");
            for (var i = 0; i < elemsRef.length; i++) {
                if (elemsRef[i].tagName == "TEXTAREA" || (elemsRef[i].tagName == "INPUT" && elemsRef[i].type == "text")) {
                    try{
                        //remove the tinymce editor from the field to prevent value reversion
                        tinymce.get(document.forms[0].elements[i].id).remove();
                    } catch (ex) {
                        console.log("tinymce was not found for " + document.forms[0].elements[i].id)
                    }
                }
            }
        }
        function Sanitize() {
            KillTinyMCE();
            var elemsRef = document.forms[0].elements;
            for (var i = 0; i < elemsRef.length; i++) {
                if (elemsRef[i].tagName == "TEXTAREA" || (elemsRef[i].tagName == "INPUT" && elemsRef[i].type == "text")) {
                    //sanitize the values before sending them to the server
                    var htm = replaceHTMLDelimiters(elemsRef[i].value);
                    document.forms[0].elements[i].value = htm;
                    if (elemsRef[i].tagName == "TEXTAREA") {
                        document.forms[0].elements[i].innerHTML = htm;
                    }
                }
            }
        }
        function SanitizeAndApply() {
            Sanitize();
            setTimeout(function () {
                document.getElementById("<%=ApplyBtn.ClientID%>").click();
            },500);
        }
        function expandedSection(id){
            try{
                var hidObj = document.getElementById("<%=hidExpandedSectionID.ClientID %>");
                hidObj.value = "";
                hidObj.value = id;
            }catch(ex){
                console.log("failed to set expandedSection. " + ex);
            }
        }
    </script>

</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Localize ID="LocIfYouThiSomElsKnoOrHas" meta:resourcekey="str_ifYouThiSomElsKnoOrHas" Visible="false" runat="server">If you think someone else knows or has changed your password, please reset your password from login page</asp:Localize>
    <input type="hidden" id="hidExpandedSectionID" runat="server" />
    <asp:Localize ID="LocFaiSenEma" meta:resourcekey="str_faiSenEma" runat="server" Visible="false">Failed to send email</asp:Localize>
    <asp:Localize ID="LocSenSuc" meta:resourcekey="str_senSuc" runat="server" Visible="false">Sent successfully</asp:Localize>
    <asp:Localize ID="LocShrFil" meta:resourcekey="str_shrFil" runat="server" Visible="false">Shared File</asp:Localize>
    <asp:Localize ID="LocIsBngUld" meta:resourcekey="str_isBngUld" runat="server" Visible="false">is being uploaded</asp:Localize>
    <asp:Localize ID="LocShrFilAreBngUpdBy" meta:resourcekey="str_shrFilAreBngUpdBy" runat="server" Visible="false">Shared files are being uploaded by</asp:Localize>
    <asp:Localize ID="LocHi" meta:resourcekey="str_hi" runat="server" Visible="false">Hi,</asp:Localize>
    <asp:Localize ID="LocFwgShrFilAreBngUpd" meta:resourcekey="str_fwgShrFilAreBngUpd" runat="server" Visible="false">The following shared files are being uploaded：</asp:Localize>
        <div style="width: 100%; padding:5px; <% if (IsServo){ %>border-bottom:1px solid #cccccc;<% } %> " <% if (!IsServo){ %>class="meubardrop"<% } %>  >
            
            <table width="100%">
                <tr>
                    <td></td>
                    <td align="right">
                        <% if (m_CanEdit)
                    { %>
                <div class="navbar-right">
                    <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize> 
                    <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize> 
                       <% if (EditBtn.Visible) { %>
                       <input type="button" onclick="ReloadWithoutPostback(true)" class="btn btn-primary gladbtn navbar-btn navbar-right btndlg" value="<%=EditBtn.Text %>" />
                       <% } %>
                        <div style="display:none">
                            <asp:Button ID="EditBtn" runat="server" 
                            CausesValidation="False" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" 
                            Text="Edit" onclick="EditBtn_Click" meta:resourcekey="asp_edt"></asp:Button>
                           <asp:Button ID="CancelBtn" runat="server" Visible="False"
                            CausesValidation="False" 
                            CssClass="btn  navbar-btn navbar-right btndlg" 
                            Text="Cancel" onclick="CancelBtn_Click" Width="108" meta:resourcekey="asp_cnl"></asp:Button>   

                            <asp:Button ID="ApplyBtn" runat="server" Visible="false"
                            CausesValidation="False" OnClick="OnContinueClick" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" meta:resourcekey="LinkButton3Resource1" 
                            Text="Apply" Width="108"></asp:Button>  
                        </div>

                       <% if (ApplyBtn.Visible) { %>
                       <input type="button" onclick="SanitizeAndApply()" class="btn btn-primary gladbtn navbar-btn navbar-right btndlg" value="<%=ApplyBtn.Text %>" />
                       <% } %>
                            
                       <% if (CancelBtn.Visible) { %>
                        <input type="button" onclick="ReloadWithoutPostback(false)" class="btn  navbar-btn navbar-right btndlg" value="<%=CancelBtn.Text %>" /> 
                       <% } %>
                    </div>
                    <%
                        EditBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                        CancelBtn.OnClientClick = String.Format("Wait('{0}')", LocPlsWat.Text);
                        ApplyBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                    %>
                <% } %>
            
                    </td>
                </tr>
            </table>
                
            </div>

     
    
                <div class="wrapper" style="margin-top:18px; background-color: white;overflow:auto;" id="maindiv">
                    <div>
                        <% if (!string.IsNullOrEmpty(ErrorMsg.Text))
                           { %>
                        <br />
                        <asp:Label ID="ErrorMsg" runat="server" CssClass="errmsg" meta:resourcekey="ErrorMsgResource1"></asp:Label>
                        <% } %>
                    </div>
                    <asp:Panel ID="BrandingPanel" runat="server">
                        <table width="100%"  align="center" style="padding: 12px; margin-top: 8px;" cellspacing="0">
                            <asp:Panel ID="ResellerEmail" runat="server" meta:resourcekey="TenantEmailResource1">
                                <%if(GetPartnerRole().mAgentAdd){ %>
                                <tr>
                                    <td valign="top" height="60px" colspan="4" style="border-bottom: 0px dashed #d0d0d0;padding: 10px;" class="tabpanel">
                                    <div class="panel-group">
                                            <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                <div class="panel-heading whitehead">
                                                    <h4 class="panel-title" >
                                                        <a onclick="expandedSection('collapse1')" data-toggle="collapse" href="#collapse1"><span class="fa fa-plus-square"
                                                            style=""></span>&nbsp;&nbsp;<asp:Localize ID="LocWelcomeReseller" meta:resourcekey="str_wlmEmlNewRsr" runat="server">Welcome Email for New Reseller</asp:Localize>
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="collapse1" class="panel-collapse collapse">
                                                    <div class="panel-body">
                                        <table width="100%">
                                           
                                            <tr>
                                                <td>
                                                    <asp:TextBox ID="WelcomeReseller" runat="server" TextMode="MultiLine" Width="100%" Height="300px"  encoding="xml"
                                                        meta:resourcekey="WelcomeAdminResource1"></asp:TextBox>
                                                        <% if (ApplyBtn.Visible) { %>                      
                                                        <div><div style="display:none;">
                                                            <asp:Button ID="BtnWelcomeReseller" runat="server" Text="Send Test Email to Admin" meta:resourcekey="str_sndTstEmlToAdm" />
                                                        </div>
                                                        <input type="button" onclick="SanitizeAndSendEmailAjax('<%=LocWelcomeReseller.ClientID %>','<%=WelcomeReseller.ClientID %>')" class="btn btn-primary sectextcolor gladsmallbtn" value="<%=BtnWelcomeReseller.Text %>" />
                                                        </div>                    
                                                        <% } %>
                                                </td>
                                            </tr>
                                        </table>
                                        </div>
                                                </div>
                                            </div>
                                    </div>
                                    </td>
                                </tr>
                                <%} %>
                                <%if(GetPartnerRole().mCustAdd|GetPartnerRole().mMyCustAdd){ %>
                                <tr>
                                    <td valign="top" height="60px" colspan="4" style="border-bottom: 0px dashed #d0d0d0;padding: 10px;" class="tabpanel">
                                        <div class="panel-group">
                                            <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                <div class="panel-heading whitehead">
                                                    <h4 class="panel-title">
                                                        <a onclick="expandedSection('collapse2')" data-toggle="collapse" href="#collapse2"><span class="fa fa-plus-square"
                                                            style=""></span>&nbsp;&nbsp;<asp:Localize ID="LocWelcomeCustomer" meta:resourcekey="str_wlcEmlNewCtr" runat="server">Welcome Email for New Customer</asp:Localize>
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="collapse2" class="panel-collapse collapse">
                                                    <div class="panel-body">
                                        <table width="100%">
                                          
                                            
                                            <tr>
                                                <td>
                                                    <asp:TextBox ID="WelcomeCustomer" runat="server" TextMode="MultiLine" Width="100%" Height="300px"  encoding="xml"
                                                        meta:resourcekey="WelcomeAdminResource1"></asp:TextBox>
                                                        <% if (ApplyBtn.Visible) { %>
                                                        <div><div style="display:none;">
                                                                <asp:Button ID="BtnWelcomeCustomer" runat="server" Text="Send Test Email to Admin" meta:resourcekey="str_sndTstEmlToAdm" />
                                                            </div>
                                                            <input type="button" onclick="SanitizeAndSendEmailAjax('<%=LocWelcomeCustomer.ClientID %>','<%=WelcomeCustomer.ClientID %>')" class="btn btn-primary sectextcolor gladsmallbtn" value="<%=BtnWelcomeCustomer.Text %>" />
                                                        </div>                      
                                                        <% } %>
                                                </td>
                                            </tr>
                                        </table>
                                        </div>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                <%} %>
                                <% if (GetPartnerRole().mUserMgr)
                                   { %>
                                <tr>
                                    <td valign="top" height="60px" colspan="4" style="border-bottom: 0px dashed #d0d0d0;padding: 10px;" class="tabpanel">
                                         <div class="panel-group">
                                            <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                <div class="panel-heading whitehead">
                                                    <h4 class="panel-title">
                                                        <a onclick="expandedSection('collapse3')" data-toggle="collapse" href="#collapse3"><span class="fa fa-plus-square"
                                                            style=""></span>&nbsp;&nbsp;<asp:Localize ID="LocWelcomePUser" meta:resourcekey="str_wlcEmlNewUsr" runat="server">Welcome Email for New User</asp:Localize>
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="collapse3" class="panel-collapse collapse">
                                        <table width="100%">
                                            
                                            
                                            <tr>
                                                <td>
                                                    <asp:TextBox ID="WelcomePUser" runat="server" TextMode="MultiLine" Width="100%" Height="300px"  encoding="xml"
                                                        meta:resourcekey="WelcomeAdminResource1"></asp:TextBox>
                                                        <% if (ApplyBtn.Visible) { %>
                                                        <div><div style="display:none;">
                                                                <asp:Button ID="BtnWelcomePUser" runat="server" Text="Send Test Email to Admin" meta:resourcekey="str_sndTstEmlToAdm" />
                                                            </div>
                                                            <input type="button" onclick="SanitizeAndSendEmailAjax('<%=LocWelcomeCustomer.ClientID %>','<%=WelcomePUser.ClientID %>')" class="btn btn-primary sectextcolor gladsmallbtn" value="<%=BtnWelcomePUser.Text %>" />
                                                        </div>                      
                                                        <% } %>
                                                </td>
                                            </tr>
                                        </table>
                                        </div>
                                            </div>
                                            </div>

                                    </td>
                                </tr>
                                <% } %>
                            </asp:Panel>
                            <asp:Panel ID="TenantEmail" runat="server" meta:resourcekey="TenantEmailResource1">
                                <tr>
                                    <td valign="top" height="60px" colspan="4" style="border-bottom: 0px dashed #d0d0d0;padding: 10px;" class="tabpanel">
                                        <div class="panel-group">
                                            <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                <div class="panel-heading whitehead">
                                                    <h4 class="panel-title" >
                                                        <a onclick="expandedSection('collapse4')" data-toggle="collapse" href="#collapse4"><span class="fa fa-plus-square"
                                                            style=""></span>&nbsp;&nbsp;<asp:Localize ID="Localize6" meta:resourcekey="asp_string1" runat="server">Welcome Email for New Tenant</asp:Localize>
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="collapse4" class="panel-collapse collapse">
                                                    <table width="100%">
                                            
                                            <tr>
                                                <td align="left" style="padding: 10px;">
                                                    <table width="100%">
                                                        <tr>
                                                            <td width="80px">
                                                                <asp:Localize meta:resourcekey="asp_string2" runat="server">Subject</asp:Localize>:&nbsp;
                                                            </td>
                                                            <td>
                                                                <asp:TextBox ID="WelcomeAdminSub" runat="server" Text="{0}, Welcome to Gladinet Cloud!"
                                                                    Width="100%" CssClass="form-control" meta:resourcekey="WelcomeAdminSubResource1"></asp:TextBox>
                                                                    <asp:Label ID="LWelcomeAdminSub" runat="server" meta:resourcekey="str_nobrb"  CssClass="badge"></asp:Label>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <asp:TextBox ID="WelcomeAdmin" runat="server" TextMode="MultiLine" Width="100%" Height="300px"  encoding="xml"
                                                        meta:resourcekey="WelcomeAdminResource1"></asp:TextBox>
                                                        <% if (ApplyBtn.Visible) { %>
                                                            <div><div style="display:none;">
                                                                <asp:Button ID="BtnWelcomeAdmin" runat="server" Text="Send Test Email to Admin" meta:resourcekey="str_sndTstEmlToAdm" />
                                                            </div>
                                                            <input type="button" onclick="SanitizeAndSendEmailAjax('<%=WelcomeAdminSub.ClientID %>','<%=WelcomeAdmin.ClientID %>')" class="btn btn-primary sectextcolor gladsmallbtn" value="<%=BtnWelcomeAdmin.Text %>" />
                                                        </div>                      
                                                        <% } %>
                                                </td>
                                            </tr>
                                        </table>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            </asp:Panel>
                            <tr>
                                <td valign="top" height="60px" style="border-bottom: 0px dashed #d0d0d0; padding: 10px;"
                                    class="tabpanel">
                                    <div class="panel-group">
                                            <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                <div class="panel-heading whitehead">
                                                    <h4 class="panel-title">
                                                        <a onclick="expandedSection('collapse5')" data-toggle="collapse" href="#collapse5"><span class="fa fa-plus-square"
                                                            style=""></span>&nbsp;&nbsp;<asp:Localize ID="Localize7" meta:resourcekey="asp_string3" runat="server">Welcome Email for New Team User</asp:Localize>
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="collapse5" class="panel-collapse collapse">
                                                    <table width="100%">
                                       
                                        <tr>
                                            <td align="left" style="padding: 10px;">
                                                <table width="100%">
                                                    <tr>
                                                        <td width="80px">
                                                            <asp:Localize meta:resourcekey="asp_string4" runat="server">Subject</asp:Localize>:&nbsp;
                                                        </td>
                                                        <td>
                                                            <asp:TextBox ID="WelcomeSubUserSub" Text="Welcome to Gladinet Cloud!" runat="server"
                                                                Width="100%" CssClass="form-control" meta:resourcekey="WelcomeSubUserSubResource1"></asp:TextBox>
                                                                <asp:Label ID="LWelcomeSubUserSub" runat="server" meta:resourcekey="str_nobrb"  CssClass="badge"></asp:Label>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                                                                                <tr>
                                            <td align="left" style="padding: 10px;">
                                                <table width="100%">
                                                    <tr>
                                                        <td width="180px">
                                                            <asp:Localize meta:resourcekey="str_adhint" runat="server">Password Hint for AD User</asp:Localize>&nbsp;
                                                        </td>
                                                        <td>
                                                            <asp:TextBox ID="AdPwdHint" Text="[Your Existing AD Password]" runat="server"
                                                                Width="100%" CssClass="form-control" meta:resourcekey="WelcomeSubUserSubResource1"></asp:TextBox>
                                                                <asp:Label ID="LAdPwdHint" runat="server" meta:resourcekey="str_nobrb"  CssClass="badge"></asp:Label>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>

                                        <tr>
                                            <td>
                                                <asp:TextBox ID="WelcomeSubUser" runat="server" TextMode="MultiLine" Width="100%"  encoding="xml"
                                                    Height="300px" meta:resourcekey="WelcomeSubUserResource1"></asp:TextBox>
                                                        <% if (ApplyBtn.Visible) { %>
                                                        <div><div style="display:none;">
                                                            <asp:Button ID="BtnWelcomeSubUser" runat="server" Text="Send Test Email to Admin" meta:resourcekey="str_sndTstEmlToAdm" />
                                                        </div>
                                                        <input type="button" onclick="SanitizeAndSendEmailAjax('<%=WelcomeSubUserSub.ClientID %>','<%=WelcomeSubUser.ClientID %>')" class="btn btn-primary sectextcolor gladsmallbtn" value="<%=BtnWelcomeSubUser.Text %>" />
                                                        </div>                      
                                                        <% } %>

                                            </td>
                                        </tr>
                                    </table>
                                                </div>
                                            </div>
                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <td valign="top" height="60px" style="border-bottom: 0px dashed #d0d0d0; padding: 10px;"
                                    class="tabpanel">
                                    <div class="panel-group">
                                            <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                <div class="panel-heading whitehead">
                                                    <h4 class="panel-title">
                                                        <a onclick="expandedSection('collapse6')" data-toggle="collapse" href="#collapse6"><span class="fa fa-plus-square"
                                                            style=""></span>&nbsp;&nbsp;<asp:Localize ID="Localize8" meta:resourcekey="asp_string5" runat="server">Welcome Email for New Guest User</asp:Localize>
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="collapse6" class="panel-collapse collapse">
                                                    <table width="100%">
                                        
                                        <tr>
                                            <td align="left" style="padding: 10px;">
                                                <table width="100%">
                                                    <tr>
                                                        <td width="80px">
                                                            <asp:Localize meta:resourcekey="asp_string7" runat="server">Subject</asp:Localize>:&nbsp;
                                                        </td>
                                                        <td>
                                                            <asp:TextBox ID="WelcomeGuestUserSub" Text="Welcome to Gladinet Cloud!" runat="server"
                                                                Width="100%" CssClass="form-control" meta:resourcekey="WelcomeGuestUserSubResource1"></asp:TextBox>
                                                                <asp:Label ID="LWelcomeGuestUserSub" runat="server" meta:resourcekey="str_nobrb"  CssClass="badge"></asp:Label>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:TextBox ID="WelcomeGuestUser" runat="server" TextMode="MultiLine" Width="100%"  encoding="xml"
                                                    Height="300px" meta:resourcekey="WelcomeGuestUserResource1"></asp:TextBox>
                                                        <% if (ApplyBtn.Visible) { %>
                                                        <div><div style="display:none;">
                                                            <asp:Button ID="BtnWelcomeGuestUser" runat="server" Text="Send Test Email to Admin" meta:resourcekey="str_sndTstEmlToAdm" />
                                                        </div>
                                                        <input type="button" onclick="SanitizeAndSendEmailAjax('<%=WelcomeGuestUserSub.ClientID %>','<%=WelcomeGuestUser.ClientID %>')" class="btn btn-primary sectextcolor gladsmallbtn" value="<%=BtnWelcomeGuestUser.Text %>" />
                                                        </div>                      
                                                        <% } %>

                                            </td>
                                        </tr>
                                    </table>
                                                </div>
                                            </div>
                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <td valign="top" height="60px" style="border-bottom: 0px dashed #d0d0d0; padding: 10px;"
                                    class="tabpanel">
                                    <div class="panel-group">
                                            <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                <div class="panel-heading whitehead">
                                                    <h4 class="panel-title">
                                                        <a onclick="expandedSection('collapse7')" data-toggle="collapse" href="#collapse7"><span class="fa fa-plus-square"
                                                            style=""></span>&nbsp;&nbsp;<asp:Localize ID="Localize9" meta:resourcekey="asp_string6" runat="server">Email for File/Folder Share</asp:Localize>
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="collapse7" class="panel-collapse collapse">
                                    <table width="100%">
                                        
                                        <tr>
                                            <td align="left" style="padding: 10px;">
                                                <table width="100%">
                                                    <tr>
                                                        <td width="80px">
                                                            <asp:Localize meta:resourcekey="asp_string7" runat="server">Subject</asp:Localize>:&nbsp;
                                                        </td>
                                                        <td>
                                                            <asp:TextBox ID="WelcomeShareSub" runat="server" Text="Gladinet Cloud shared {0} invitation - from {1}"
                                                                Width="100%" CssClass="form-control" meta:resourcekey="WelcomeShareSubResource1"></asp:TextBox>
                                                                <asp:Label ID="LWelcomeShareSub" runat="server" meta:resourcekey="str_nobrb"  CssClass="badge"></asp:Label>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:TextBox ID="WelcomeShare" runat="server" TextMode="MultiLine" Width="100%" Height="300px"  encoding="xml"
                                                    meta:resourcekey="WelcomeShareResource1"></asp:TextBox>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <table>
                                                    <tr><td colspan="2"><asp:Localize meta:resourcekey="str_locVcb" runat="server">Localized Vocabulary (to be used inside other variables, such as {ExpirationTime})</asp:Localize>:</td></tr>
                                                    <tr><td><asp:Localize ID="LocDys" meta:resourcekey="str_dys" runat="server">Day(s)</asp:Localize></td>
                                                        <td><asp:TextBox ID="TxtDys" runat="server" Width="100px" CssClass="form-control" Text=""></asp:TextBox>
                                                            <asp:Label ID="LblDys" runat="server" Text=""></asp:Label>
                                                        </td></tr>
                                                    <tr><td><asp:Localize ID="LocHrs" meta:resourcekey="str_hrs" runat="server">Hour(s)</asp:Localize></td>
                                                        <td><asp:TextBox ID="TxtHrs" runat="server" Width="100px" CssClass="form-control" Text=""></asp:TextBox>
                                                            <asp:Label ID="LblHrs" runat="server" Text=""></asp:Label>
                                                        </td></tr>
                                                    <tr><td><asp:Localize ID="LocMns" meta:resourcekey="str_mns" runat="server">Min(s)</asp:Localize></td>
                                                        <td><asp:TextBox ID="TxtMns" runat="server" Width="100px" CssClass="form-control" Text=""></asp:TextBox>
                                                            <asp:Label ID="LblMns" runat="server" Text=""></asp:Label>
                                                        </td></tr>
                                                    <tr><td><asp:Localize ID="LocNA" meta:resourcekey="str_na" runat="server">N/A</asp:Localize></td>
                                                        <td><asp:TextBox ID="TxtNA" runat="server" Width="100px" CssClass="form-control" Text=""></asp:TextBox>
                                                            <asp:Label ID="LblNA" runat="server" Text=""></asp:Label>
                                                        </td></tr>
                                                    <tr><td><asp:Localize ID="LocExp" meta:resourcekey="str_exp" runat="server">Expired</asp:Localize></td>
                                                        <td><asp:TextBox ID="TxtExp" runat="server" Width="100px" CssClass="form-control" Text=""></asp:TextBox>
                                                            <asp:Label ID="LblExp" runat="server" Text=""></asp:Label>
                                                        </td></tr>
                                                    <tr><td><asp:Localize ID="LocNvr" meta:resourcekey="str_nvr" runat="server">Never</asp:Localize></td>
                                                        <td><asp:TextBox ID="TxtNvr" runat="server" Width="100px" CssClass="form-control" Text=""></asp:TextBox>
                                                            <asp:Label ID="LblNvr" runat="server" Text=""></asp:Label>
                                                        </td></tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <div>
                                                    <div style="display:none;">
                                                        <asp:Button ID="BtnWelcomeShare" runat="server" Text="Send Test Email to Admin" meta:resourcekey="str_sndTstEmlToAdm" />
                                                    </div>
                                                    <input type="button" onclick="SanitizeAndSendEmailAjax('<%=WelcomeShareSub.ClientID %>','<%=WelcomeShare.ClientID %>')" class="btn btn-primary sectextcolor gladsmallbtn" value="<%=BtnWelcomeShare.Text %>" />
                                                </div>
                                            </td>
                                        </tr>
                                    </table>
                                    </div>
                                    </div>
                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <td valign="top" height="60px" style="border-bottom: 0px dashed #d0d0d0; padding: 10px;"
                                    class="tabpanel">
                                    <div class="panel-group">
                                            <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                <div class="panel-heading whitehead">
                                                    <h4 class="panel-title">
                                                        <a onclick="expandedSection('collapse8')" data-toggle="collapse" href="#collapse8"><span class="fa fa-plus-square"
                                                            style=""></span>&nbsp;&nbsp; <asp:Localize ID="Localize10" meta:resourcekey="str_reqfile" runat="server">Request a File</asp:Localize>
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="collapse8" class="panel-collapse collapse">
                                    <table width="100%">
                                         
                                     
                                        <tr>
                                            <td align="left" style="padding: 10px;">
                                                <table width="100%">
                                                    <tr>
                                                        <td width="80px">
                                                            <asp:Localize ID="Localize1" meta:resourcekey="asp_string7" runat="server">Subject</asp:Localize>:&nbsp;
                                                        </td>
                                                        <td>
                                                            <asp:TextBox ID="ReqFileFileSub" runat="server" Text="Gladinet Cloud shared {0} invitation - from {1}"
                                                                Width="100%" CssClass="form-control" meta:resourcekey="WelcomeShareSubResource1"></asp:TextBox>
                                                                <asp:Label ID="LReqFileFileSub" runat="server" meta:resourcekey="str_nobrb"  CssClass="badge"></asp:Label>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:TextBox ID="ReqFile" runat="server" TextMode="MultiLine" Width="100%"  encoding="xml"
                                                    Height="300px" meta:resourcekey="WelcomeGuestUserResource1"></asp:TextBox>
                                                        <% if (ApplyBtn.Visible) { %>
                                                        <div><div style="display:none;">
                                                            <asp:Button ID="BtnReqFile" runat="server" Text="Send Test Email to Admin" meta:resourcekey="str_sndTstEmlToAdm" />
                                                        </div>
                                                        <input type="button" onclick="SanitizeAndSendEmailAjax('<%=ReqFileFileSub.ClientID %>','<%=ReqFile.ClientID %>')" class="btn btn-primary sectextcolor gladsmallbtn" value="<%=BtnReqFile.Text %>" />
                                                        </div>                      
                                                        <% } %>

                                            </td>
                                        </tr>
                                    </table>
                                    </div>
                                    </div>
                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <td valign="top" height="60px" style="border-bottom: 0px dashed #d0d0d0; padding: 10px;"
                                    class="tabpanel">
                                    <div class="panel-group">
                                            <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                <div class="panel-heading whitehead">
                                                    <h4 class="panel-title">
                                                        <a onclick="expandedSection('collapse9')" data-toggle="collapse" href="#collapse9"><span class="fa fa-plus-square"
                                                            style=""></span>&nbsp;&nbsp; <asp:Localize ID="Localize11" meta:resourcekey="str_noupload" runat="server">Notify external user that shared file changed</asp:Localize>
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="collapse9" class="panel-collapse collapse">
                                    <table width="100%">
                                         
                                     
                                        <tr>
                                            <td align="left" style="padding: 10px;">
                                                <table width="100%">
                                                    <tr>
                                                        <td width="80px">
                                                            <asp:Localize ID="Localize3" meta:resourcekey="asp_string7" runat="server">Subject</asp:Localize>:&nbsp;
                                                        </td>
                                                        <td>
                                                            <asp:TextBox ID="NotifyUploadSub" runat="server" Text="{ProductName} Share Change Notification"
                                                                Width="100%" CssClass="form-control" meta:resourcekey="WelcomeShareSubResource1"></asp:TextBox>
                                                                <asp:Label ID="LNotifyUploadSub" runat="server" meta:resourcekey="str_nobrb"  CssClass="badge"></asp:Label>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:TextBox ID="NotifyUpload" runat="server" TextMode="MultiLine" Width="100%"  encoding="xml"
                                                    Height="300px" meta:resourcekey="WelcomeGuestUserResource1"></asp:TextBox>
                                                        <% if (ApplyBtn.Visible) { %>
                                                        <div><div style="display:none;">
                                                            <asp:Button ID="BtnNotifyUpload" runat="server" Text="Send Test Email to Admin" meta:resourcekey="str_sndTstEmlToAdm" />
                                                        </div>
                                                        <input type="button" onclick="SanitizeAndSendEmailAjax('<%=NotifyUploadSub.ClientID %>','<%=NotifyUpload.ClientID %>')" class="btn btn-primary sectextcolor gladsmallbtn" value="<%=BtnNotifyUpload.Text %>" />
                                                        </div>                      
                                                        <% } %>

                                            </td>
                                        </tr>
                                    </table>
                                    </div>
                                    </div>
                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <td valign="top" height="60px" style="border-bottom: 0px dashed #d0d0d0; padding: 10px;"
                                    class="tabpanel">
                                    <div class="panel-group">
                                            <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                <div class="panel-heading whitehead">
                                                    <h4 class="panel-title">
                                                        <a onclick="expandedSection('collapse9b1')" data-toggle="collapse" href="#collapse9b1"><span class="fa fa-plus-square"
                                                            style=""></span>&nbsp;&nbsp; <asp:Localize ID="Localize5" meta:resourcekey="str_fcsub" runat="server">Folder change subscription</asp:Localize>
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="collapse9b1" class="panel-collapse collapse">
                                    <table width="100%">
                                         
                                     
                                        <tr>
                                            <td align="left" style="padding: 10px;">
                                                <table width="100%">
                                                    <tr>
                                                        <td width="80px">
                                                            <asp:Localize ID="Localize15" meta:resourcekey="asp_string7" runat="server">Subject</asp:Localize>:&nbsp;
                                                        </td>
                                                        <td>
                                                            <asp:TextBox ID="FCSuject" runat="server" Text="{ProductName} Folder Change Notification"
                                                                Width="100%" CssClass="form-control" ></asp:TextBox>
                                                                <asp:Label ID="LFCSuject" runat="server" meta:resourcekey="str_nobrb"  CssClass="badge"></asp:Label>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:TextBox ID="FCBody" runat="server" TextMode="MultiLine" Width="100%"  encoding="xml"
                                                    Height="300px" ></asp:TextBox>
                                                        <% if (ApplyBtn.Visible) { %>
                                                        <div><div style="display:none;">
                                                            <asp:Button ID="FCBodyTest" runat="server" Text="Send Test Email to Admin" meta:resourcekey="str_sndTstEmlToAdm" />
                                                        </div>
                                                        <input type="button" onclick="SanitizeAndSendEmailAjax('<%=FCSuject.ClientID %>','<%=FCBody.ClientID %>')" class="btn btn-primary sectextcolor gladsmallbtn" value="<%=FCBodyTest.Text %>" />
                                                        </div>                      
                                                        <% } %>

                                            </td>
                                        </tr>
                                    </table>
                                    </div>
                                    </div>
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td valign="top" height="60px" style="border-bottom: 0px dashed #d0d0d0; padding: 10px;"
                                    class="tabpanel">
                                    <div class="panel-group">
                                            <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                <div class="panel-heading whitehead">
                                                    <h4 class="panel-title">
                                                        <a onclick="expandedSection('collapse9d1')" data-toggle="collapse" href="#collapse9d1"><span class="fa fa-plus-square"
                                                            style=""></span>&nbsp;&nbsp; <asp:Localize ID="Localize4" meta:resourcekey="str_syncsub" runat="server">Sync Task Failed/Paused</asp:Localize>
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="collapse9d1" class="panel-collapse collapse">
                                    <table width="100%">
                                         
                                     
                                        <tr>
                                            <td align="left" style="padding: 10px;">
                                                <table width="100%">
                                                    <tr>
                                                        <td width="80px">
                                                            <asp:Localize ID="Localize16" meta:resourcekey="asp_string7" runat="server">Subject</asp:Localize>:&nbsp;
                                                        </td>
                                                        <td>
                                                            <asp:TextBox ID="SyncTaskSubject" runat="server" Text="Sync task {Status} on device: {Device} owned by {OwnerEmail}"
                                                                Width="100%" CssClass="form-control" ></asp:TextBox>
                                                                <asp:Label ID="LSyncTaskSubject" runat="server" meta:resourcekey="str_nobrb"  CssClass="badge"></asp:Label>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:TextBox ID="SyncTaskBody" runat="server" TextMode="MultiLine" Width="100%"  encoding="xml"
                                                    Height="300px" ></asp:TextBox>
                                                        <% if (ApplyBtn.Visible) { %>
                                                        <div><div style="display:none;">
                                                            <asp:Button ID="Button1" runat="server" Text="Send Test Email to Admin" meta:resourcekey="str_sndTstEmlToAdm" />
                                                        </div>
                                                        <input type="button" onclick="SanitizeAndSendEmailAjax('<%=SyncTaskSubject.ClientID %>','<%=SyncTaskBody.ClientID %>')" class="btn btn-primary sectextcolor gladsmallbtn" value="<%=Button1.Text %>" />
                                                        </div>                      
                                                        <% } %>

                                            </td>
                                        </tr>
                                    </table>
                                    </div>
                                    </div>
                                    </div>
                                </td>
                            </tr>

                             <tr>
                                <td valign="top" height="60px" style="border-bottom: 0px dashed #d0d0d0; padding: 10px;"
                                    class="tabpanel">
                                    <div class="panel-group">
                                            <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                <div class="panel-heading whitehead">
                                                    <h4 class="panel-title">
                                                        <a onclick="expandedSection('collapse9d2')" data-toggle="collapse" href="#collapse9d2"><span class="fa fa-plus-square"
                                                            style=""></span>&nbsp;&nbsp; <asp:Localize ID="Localize19" meta:resourcekey="str_fastwritesub" runat="server">Fast update protection</asp:Localize>
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="collapse9d2" class="panel-collapse collapse">
                                    <table width="100%">
                                         
                                     
                                        <tr>
                                            <td align="left" style="padding: 10px;">
                                                <table width="100%">
                                                    <tr>
                                                        <td width="80px">
                                                            <asp:Localize ID="Localize20" meta:resourcekey="asp_string7" runat="server">Subject</asp:Localize>:&nbsp;
                                                        </td>
                                                        <td>
                                                            <asp:TextBox ID="FastSub" runat="server" Text="{ProductName} Folder Change Notification"
                                                                Width="100%" CssClass="form-control" ></asp:TextBox>
                                                                <asp:Label ID="LFastSub" runat="server" meta:resourcekey="str_nobrb"  CssClass="badge"></asp:Label>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:TextBox ID="FastBody" runat="server" TextMode="MultiLine" Width="100%"  encoding="xml"
                                                    Height="300px" ></asp:TextBox>
                                                        <% if (ApplyBtn.Visible) { %> 
                                                        <div><div style="display:none;">
                                                            <asp:Button ID="Button3" runat="server" Text="Send Test Email to Admin" meta:resourcekey="str_sndTstEmlToAdm" />
                                                        </div>
                                                        <input type="button" onclick="SanitizeAndSendEmailAjax('<%=FastSub.ClientID %>','<%=FastBody.ClientID %>')" class="btn btn-primary sectextcolor gladsmallbtn" value="<%=Button3.Text %>" />
                                                        </div>                     
                                                        <% } %>

                                            </td>
                                        </tr>
                                    </table>
                                    </div>
                                    </div>
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td valign="top" height="60px" style="border-bottom: 0px dashed #d0d0d0; padding: 10px;"
                                    class="tabpanel">
                                    <div class="panel-group">
                                            <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                <div class="panel-heading whitehead">
                                                    <h4 class="panel-title">
                                                        <a onclick="expandedSection('collapse9e1')" data-toggle="collapse" href="#collapse9e1"><span class="fa fa-plus-square"
                                                            style=""></span>&nbsp;&nbsp; <asp:Localize ID="Localize23" meta:resourcekey="str_shareexpiring" runat="server">Share Expiring Notification</asp:Localize>
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="collapse9e1" class="panel-collapse collapse">
                                    <table width="100%">
                                         
                                     
                                        <tr>
                                            <td align="left" style="padding: 10px;">
                                                <table width="100%">
                                                    <tr>
                                                        <td width="80px">
                                                            <asp:Localize ID="Localize24" meta:resourcekey="asp_string7" runat="server">Subject</asp:Localize>:&nbsp;
                                                        </td>
                                                        <td>
                                                            <asp:TextBox ID="ShareExpirSub" runat="server" Text="Share {ShareName} expiring in {Expiredays} days"
                                                                Width="100%" CssClass="form-control" ></asp:TextBox>
                                                                <asp:Label ID="LShareExpirSub" runat="server" meta:resourcekey="str_nobrb"  CssClass="badge"></asp:Label>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:TextBox ID="ShareExpirBody" runat="server" TextMode="MultiLine" Width="100%"  encoding="xml"
                                                    Height="300px" ></asp:TextBox>
                                                        <% if (ApplyBtn.Visible) { %>
                                                        <div><div style="display:none;">
                                                            <asp:Button ID="Button5" runat="server" Text="Send Test Email to Admin" meta:resourcekey="str_sndTstEmlToAdm" />
                                                        </div>
                                                        <input type="button" onclick="SanitizeAndSendEmailAjax('<%=ShareExpirSub.ClientID %>','<%=ShareExpirBody.ClientID %>')" class="btn btn-primary sectextcolor gladsmallbtn" value="<%=Button5.Text %>" />
                                                        </div>                      
                                                        <% } %>

                                            </td>
                                        </tr>
                                    </table>
                                    </div>
                                    </div>
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td valign="top" height="60px" style="border-bottom: 0px dashed #d0d0d0; padding: 10px;"
                                    class="tabpanel">
                                    <div class="panel-group">
                                            <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                <div class="panel-heading whitehead">
                                                    <h4 class="panel-title">
                                                        <a onclick="expandedSection('collapse9e2')" data-toggle="collapse" href="#collapse9e2"><span class="fa fa-plus-square"
                                                            style=""></span>&nbsp;&nbsp; <asp:Localize ID="Localize25" meta:resourcekey="str_folderpurge" runat="server">Folder Purge Notification</asp:Localize>
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="collapse9e2" class="panel-collapse collapse">
                                    <table width="100%">
                                         
                                     
                                        <tr>
                                            <td align="left" style="padding: 10px;">
                                                <table width="100%">
                                                    <tr>
                                                        <td width="80px">
                                                            <asp:Localize ID="Localize26" meta:resourcekey="asp_string7" runat="server">Subject</asp:Localize>:&nbsp;
                                                        </td>
                                                        <td>
                                                            <asp:TextBox ID="FolderPurgeSub" runat="server" Text="Folder <{FolderName}> to be purged"
                                                                Width="100%" CssClass="form-control" ></asp:TextBox>
                                                                <asp:Label ID="LFolderPurgeSub" runat="server" meta:resourcekey="str_nobrb"  CssClass="badge"></asp:Label>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:TextBox ID="FolderPurgeBody" runat="server" TextMode="MultiLine" Width="100%"  encoding="xml"
                                                    Height="300px" ></asp:TextBox>
                                                        <% if (ApplyBtn.Visible) { %>
                                                        <div><div style="display:none;">
                                                            <asp:Button ID="Button6" runat="server" Text="Send Test Email to Admin" meta:resourcekey="str_sndTstEmlToAdm" />
                                                        </div>
                                                        <input type="button" onclick="SanitizeAndSendEmailAjax('<%=FolderPurgeSub.ClientID %>','<%=FolderPurgeBody.ClientID %>')" class="btn btn-primary sectextcolor gladsmallbtn" value="<%=Button6.Text %>" />
                                                        </div>                      
                                                        <% } %>

                                            </td>
                                        </tr>
                                    </table>
                                    </div>
                                    </div>
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td valign="top" height="60px" style="border-bottom: 0px dashed #d0d0d0; padding: 10px;"
                                    class="tabpanel">
                                    <div class="panel-group">
                                            <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                <div class="panel-heading whitehead">
                                                    <h4 class="panel-title">
                                                        <a onclick="expandedSection('collapse9e3')" data-toggle="collapse" href="#collapse9e3"><span class="fa fa-plus-square"
                                                            style=""></span>&nbsp;&nbsp; <asp:Localize ID="Localize27" meta:resourcekey="str_receivefile" runat="server">Folder Purge Notification</asp:Localize>
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="collapse9e3" class="panel-collapse collapse">
                                    <table width="100%">
                                         
                                     
                                        <tr>
                                            <td align="left" style="padding: 10px;">
                                                <table width="100%">
                                                    <tr>
                                                        <td width="80px">
                                                            <asp:Localize ID="Localize28" meta:resourcekey="asp_string7" runat="server">Subject</asp:Localize>:&nbsp;
                                                        </td>
                                                        <td>
                                                            <asp:TextBox ID="ReceiveFileSub" runat="server" Text="Received Requested File from:{UserEmail}"
                                                                Width="100%" CssClass="form-control" ></asp:TextBox>
                                                                <asp:Label ID="LReceiveFileSub" runat="server" meta:resourcekey="str_nobrb"  CssClass="badge"></asp:Label>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:TextBox ID="ReceiveFileBody" runat="server" TextMode="MultiLine" Width="100%"  encoding="xml"
                                                    Height="300px" ></asp:TextBox>
                                                        <% if (ApplyBtn.Visible) { %>
                                                        <div><div style="display:none;">
                                                            <asp:Button ID="Button7" runat="server" Text="Send Test Email to Admin" meta:resourcekey="str_sndTstEmlToAdm" />
                                                        </div>
                                                        <input type="button" onclick="SanitizeAndSendEmailAjax('<%=ReceiveFileSub.ClientID %>','<%=ReceiveFileBody.ClientID %>')" class="btn btn-primary sectextcolor gladsmallbtn" value="<%=Button7.Text %>" />
                                                        </div>                      
                                                        <% } %>

                                            </td>
                                        </tr>
                                    </table>
                                    </div>
                                    </div>
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td valign="top" height="60px" style="border-bottom: 0px dashed #d0d0d0; padding: 10px;"
                                    class="tabpanel">
                                    <div class="panel-group">
                                            <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                <div class="panel-heading whitehead">
                                                    <h4 class="panel-title">
                                                        <a onclick="expandedSection('collapse9d4')" data-toggle="collapse" href="#collapse9d4"><span class="fa fa-plus-square"
                                                            style=""></span>&nbsp;&nbsp; <asp:Localize ID="Localize21" meta:resourcekey="str_newdevice" runat="server">New Device Login</asp:Localize>
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="collapse9d4" class="panel-collapse collapse">
                                    <table width="100%">
                                         
                                     
                                        <tr>
                                            <td align="left" style="padding: 10px;">
                                                <table width="100%">
                                                    <tr>
                                                        <td width="80px">
                                                            <asp:Localize ID="Localize22" meta:resourcekey="asp_string7" runat="server">Subject</asp:Localize>:&nbsp;
                                                        </td>
                                                        <td>
                                                            <asp:TextBox ID="NewDeviceSub" runat="server" Text="New Device Login:{OwnerEmail}"
                                                                Width="100%" CssClass="form-control" ></asp:TextBox>
                                                                <asp:Label ID="LNewDeviceSub" runat="server" meta:resourcekey="str_nobrb"  CssClass="badge"></asp:Label>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:TextBox ID="NewDeviceBody" runat="server" TextMode="MultiLine" Width="100%"  encoding="xml"
                                                    Height="300px" ></asp:TextBox>
                                                        <% if (ApplyBtn.Visible) { %>
                                                        <div><div style="display:none;">
                                                            <asp:Button ID="Button4" runat="server" Text="Send Test Email to Admin" meta:resourcekey="str_sndTstEmlToAdm" />
                                                        </div>
                                                        <input type="button" onclick="SanitizeAndSendEmailAjax('<%=NewDeviceSub.ClientID %>','<%=NewDeviceBody.ClientID %>')" class="btn btn-primary sectextcolor gladsmallbtn" value="<%=Button4.Text %>" />
                                                        </div>                      
                                                        <% } %>

                                            </td>
                                        </tr>
                                    </table>
                                    </div>
                                    </div>
                                    </div>
                                </td>
                            </tr>
                           
                            <tr>
                                <td valign="top" height="60px" style="border-bottom: 0px dashed #d0d0d0; padding: 10px;"
                                    class="tabpanel">
                                    <div class="panel-group">
                                            <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                <div class="panel-heading whitehead">
                                                    <h4 class="panel-title">
                                                        <a onclick="expandedSection('collapse9c1')" data-toggle="collapse" href="#collapse9c1"><span class="fa fa-plus-square"
                                                            style=""></span>&nbsp;&nbsp; <asp:Localize ID="Localize17" meta:resourcekey="str_spsub" runat="server">Share access password</asp:Localize>
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="collapse9c1" class="panel-collapse collapse">
                                    <table width="100%">
                                         
                                     
                                        <tr>
                                            <td align="left" style="padding: 10px;">
                                                <table width="100%">
                                                    <tr>
                                                        <td width="80px">
                                                            <asp:Localize ID="Localize18" meta:resourcekey="asp_string7" runat="server">Subject</asp:Localize>:&nbsp;
                                                        </td>
                                                        <td>
                                                            <asp:TextBox ID="SharePWDSub" runat="server" Text="{ProductName} Password for share {ShareName}"
                                                                Width="100%" CssClass="form-control" ></asp:TextBox>
                                                                <asp:Label ID="LSharePWDSub" runat="server" meta:resourcekey="str_nobrb"  CssClass="badge"></asp:Label>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:TextBox ID="SharePWDBody" runat="server" TextMode="MultiLine" Width="100%"  encoding="xml"
                                                    Height="300px" ></asp:TextBox>
                                                        <% if (ApplyBtn.Visible) { %>
                                                        <div><div style="display:none;">
                                                            <asp:Button ID="Button2" runat="server" Text="Send Test Email to Admin" meta:resourcekey="str_sndTstEmlToAdm" />
                                                        </div>
                                                        <input type="button" onclick="SanitizeAndSendEmailAjax('<%=SharePWDSub.ClientID %>','<%=SharePWDBody.ClientID %>')" class="btn btn-primary sectextcolor gladsmallbtn" value="<%=Button2.Text %>" />
                                                        </div>                      
                                                        <% } %>

                                            </td>
                                        </tr>
                                    </table>
                                    </div>
                                    </div>
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td valign="top" height="60px" style="border-bottom: 0px dashed #d0d0d0; padding: 10px;"
                                    class="tabpanel">
                                    <div class="panel-group">
                                            <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                <div class="panel-heading whitehead">
                                                    <h4 class="panel-title">
                                                        <a onclick="expandedSection('collapse10B')" data-toggle="collapse" href="#collapse10B"><span class="fa fa-plus-square"
                                                            style=""></span>&nbsp;&nbsp; <asp:Localize ID="LocAdmRstUsrEml" meta:resourcekey="str_admRstUsrEml" runat="server">Admin Reset User Email</asp:Localize>
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="collapse10B" class="panel-collapse collapse">
                                    <table width="100%">
                                        
                                        <tr>
                                            <td align="left" style="padding: 10px;">
                                                <table width="100%">
                                                    <tr>
                                                        <td width="80px">
                                                            <asp:Localize meta:resourcekey="asp_string9" runat="server">Subject</asp:Localize>:&nbsp;
                                                        </td>
                                                        <td>
                                                            <asp:TextBox ID="AdminResetEmlSub" Text="Your {ProductName} Email Address has been updated"
                                                                runat="server" Width="100%" CssClass="form-control" meta:resourcekey="AdminResetEmlSubResource1"></asp:TextBox>
                                                                <asp:Label ID="LAdminResetEmlSub" runat="server" meta:resourcekey="str_nobrb"  CssClass="badge"></asp:Label>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:TextBox ID="AdminResetEml" runat="server" TextMode="MultiLine" Width="100%"  encoding="xml"
                                                    Height="300px"></asp:TextBox>
                                                        <% if (ApplyBtn.Visible) { %>
                                                        <div><div style="display:none;">
                                                            <asp:Button ID="BtnAdminResetEml" runat="server" Text="Send Test Email to Admin" meta:resourcekey="str_sndTstEmlToAdm" />
                                                        </div>
                                                        <input type="button" onclick="SanitizeAndSendEmailAjax('<%=AdminResetEmlSub.ClientID %>','<%=AdminResetEml.ClientID %>')" class="btn btn-primary sectextcolor gladsmallbtn" value="<%=BtnAdminResetEml.Text %>" />
                                                        </div>                      
                                                        <% } %>

                                            </td>
                                        </tr>
                                    </table>
                                    </div>
                                    </div>
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td valign="top" height="60px" style="border-bottom: 0px dashed #d0d0d0; padding: 10px;"
                                    class="tabpanel">
                                    <div class="panel-group">
                                            <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                <div class="panel-heading whitehead">
                                                    <h4 class="panel-title">
                                                        <a onclick="expandedSection('collapse10')" data-toggle="collapse" href="#collapse10"><span class="fa fa-plus-square"
                                                            style=""></span>&nbsp;&nbsp; <asp:Localize ID="Localize12" meta:resourcekey="asp_string8" runat="server">Admin Reset User Password Email</asp:Localize>
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="collapse10" class="panel-collapse collapse">
                                    <table width="100%">
                                        
                                        <tr>
                                            <td align="left" style="padding: 10px;">
                                                <table width="100%">
                                                    <tr>
                                                        <td width="80px">
                                                            <asp:Localize meta:resourcekey="asp_string9" runat="server">Subject</asp:Localize>:&nbsp;
                                                        </td>
                                                        <td>
                                                            <asp:TextBox ID="AdminResetPwdSub" Text="Gladinet Cloud Password Assistance - Password Changed by Administrator."
                                                                runat="server" Width="100%" CssClass="form-control" meta:resourcekey="AdminResetPwdSubResource1"></asp:TextBox>
                                                                <asp:Label ID="LAdminResetPwdSub" runat="server" meta:resourcekey="str_nobrb"  CssClass="badge"></asp:Label>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:TextBox ID="AdminResetPwd" runat="server" TextMode="MultiLine" Width="100%"  encoding="xml"
                                                    Height="300px" meta:resourcekey="AdminResetPwdResource1"></asp:TextBox>
                                                        <% if (ApplyBtn.Visible) { %>
                                                        <div><div style="display:none;">
                                                            <asp:Button ID="BtnAdminResetPwd" runat="server" Text="Send Test Email to Admin" meta:resourcekey="str_sndTstEmlToAdm" />
                                                        </div>
                                                        <input type="button" onclick="SanitizeAndSendEmailAjax('<%=AdminResetPwdSub.ClientID %>','<%=AdminResetPwd.ClientID %>')" class="btn btn-primary sectextcolor gladsmallbtn" value="<%=BtnAdminResetPwd.Text %>" />
                                                        </div>                      
                                                        <% } %>

                                            </td>
                                        </tr>
                                    </table>
                                    </div>
                                    </div>
                                    </div>
                                </td>
                            </tr>
                            <%if (SessionIsInstalledApp)
                              {%>
                            <tr>
                                <td valign="top" height="60px" style="border: 0px solid #d0d0d0; padding: 10px; border-top: 0px solid #C0C0C0;"
                                    class="tabpanel">
                                    <div class="panel-group">
                                            <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                <div class="panel-heading whitehead">
                                                    <h4 class="panel-title">
                                                        <a onclick="expandedSection('collapse11')" data-toggle="collapse" href="#collapse11"><span class="fa fa-plus-square"
                                                            style=""></span>&nbsp;&nbsp; <asp:Localize ID="Localize13" meta:resourcekey="asp_string10" runat="server">User Reset Password Email</asp:Localize>
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="collapse11" class="panel-collapse collapse">
                                    <table width="100%">
                                        
                                        <tr>
                                            <td align="left" style="padding: 10px;">
                                                <table width="100%">
                                                    <tr>
                                                        <td width="80px">
                                                            <asp:Localize meta:resourcekey="asp_string11" runat="server">Subject</asp:Localize>:&nbsp;
                                                        </td>
                                                        <td>
                                                            <asp:TextBox ID="UserResetPwdSub" Text="Gladinet Cloud  Password Assistance - Action required."
                                                                runat="server" Width="100%" CssClass="form-control" meta:resourcekey="UserResetPwdSubResource1"></asp:TextBox>
                                                                <asp:Label ID="LUserResetPwdSub" runat="server" meta:resourcekey="str_nobrb"  CssClass="badge"></asp:Label>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:TextBox ID="UserResetPwd" runat="server" TextMode="MultiLine" Width="100%" Height="300px"  encoding="xml"
                                                    meta:resourcekey="UserResetPwdResource1"></asp:TextBox>
                                                        <% if (ApplyBtn.Visible) { %>
                                                        <div><div style="display:none;">
                                                            <asp:Button ID="BtnUserResetPwd" runat="server" Text="Send Test Email to Admin" meta:resourcekey="str_sndTstEmlToAdm" />
                                                        </div>
                                                        <input type="button" onclick="SanitizeAndSendEmailAjax('<%=UserResetPwdSub.ClientID %>','<%=UserResetPwd.ClientID %>')" class="btn btn-primary sectextcolor gladsmallbtn" value="<%=BtnUserResetPwd.Text %>" />
                                                        </div>                      
                                                        <% } %>

                                            </td>
                                        </tr>
                                    </table>
                                    </div>
                                    </div>
                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <td valign="top" height="60px" style="border: 0px solid #d0d0d0; padding: 10px; border-top: 0px solid #C0C0C0;"
                                    class="tabpanel">
                                    <div class="panel-group">
                                            <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                <div class="panel-heading whitehead">
                                                    <h4 class="panel-title">
                                                        <a onclick="expandedSection('collapse12')" data-toggle="collapse" href="#collapse12"><span class="fa fa-plus-square"
                                                            style=""></span>&nbsp;&nbsp; <asp:Localize ID="Localize14" meta:resourcekey="str_newsignin" runat="server">New Sign-in Action Email</asp:Localize>
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="collapse12" class="panel-collapse collapse">
                                    <table width="100%">
                                        
                                        <tr>
                                            <td align="left" style="padding: 10px;">
                                               <table width="100%">
                                                    <tr>
                                                        <td width="80px">
                                                            <asp:Localize meta:resourcekey="asp_string11" runat="server">Subject</asp:Localize>:&nbsp;
                                                        </td>
                                                        <td>
                                                            <asp:TextBox ID="NewSigninSubject" Text="New sign-in from {IP} on {Device}"
                                                                runat="server" Width="100%" CssClass="form-control" meta:resourcekey="NewSignInEmailSub"></asp:TextBox>
                                                                <asp:Label ID="LNewSigninSubject" runat="server" meta:resourcekey="str_nobrb"  CssClass="badge"></asp:Label>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:TextBox ID="NewSignIn" runat="server" TextMode="MultiLine" Width="100%" Height="300px"  encoding="xml"
                                                    meta:resourcekey="UserResetPwdResource1"></asp:TextBox>
                                                        <% if (ApplyBtn.Visible) { %>
                                                        <div><div style="display:none;">
                                                            <asp:Button ID="BtnNewSignIn" runat="server" Text="Send Test Email to Admin" meta:resourcekey="str_sndTstEmlToAdm" />
                                                        </div>
                                                        <input type="button" onclick="SanitizeAndSendEmailAjax('<%=NewSigninSubject.ClientID %>','<%=NewSignIn.ClientID %>')" class="btn btn-primary sectextcolor gladsmallbtn" value="<%=BtnNewSignIn.Text %>" />
                                                        </div>                      
                                                        <% } %>

                                            </td>
                                        </tr>
                                    </table>
                                    </div>
                                    </div>
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td valign="top" height="60px" style="border: 0px solid #d0d0d0; padding: 10px; border-top: 0px solid #C0C0C0;"
                                    class="tabpanel">
                                    <div class="panel-group">
                                            <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                <div class="panel-heading whitehead">
                                                    <h4 class="panel-title">
                                                        <a onclick="expandedSection('collapse12a')" data-toggle="collapse" href="#collapse12a"><span class="fa fa-plus-square"
                                                            style=""></span>&nbsp;&nbsp; <asp:Localize ID="Localize2" meta:resourcekey="str_pwdchanged" runat="server">Password Changed Email</asp:Localize>
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="collapse12a" class="panel-collapse collapse">
                                    <table width="100%">
                                        
                                        <tr>
                                            <td align="left" style="padding: 10px;">
                                               <table width="100%">
                                                    <tr>
                                                        <td width="80px">
                                                            <asp:Localize meta:resourcekey="asp_string11" runat="server">Subject</asp:Localize>:&nbsp;
                                                        </td>
                                                        <td>
                                                            <asp:TextBox ID="PwdChangedSub" Text="Someone changed your {ProductName} password."
                                                                runat="server" Width="100%" CssClass="form-control" meta:resourcekey="PwdChangedSub"></asp:TextBox>
                                                                <asp:Label ID="LPwdChangedSub" runat="server" meta:resourcekey="str_nobrb"  CssClass="badge"></asp:Label>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:TextBox ID="PwdChanged" runat="server" TextMode="MultiLine" Width="100%" Height="300px"  encoding="xml"
                                                    meta:resourcekey="UserResetPwdResource1"></asp:TextBox>
                                                        <% if (ApplyBtn.Visible) { %> 
                                                        <div><div style="display:none;">
                                                            <asp:Button ID="BtnPwdChanged" runat="server" Text="Send Test Email to Admin" meta:resourcekey="str_sndTstEmlToAdm" />
                                                        </div>
                                                        <input type="button" onclick="SanitizeAndSendEmailAjax('<%=PwdChangedSub.ClientID %>','<%=PwdChanged.ClientID %>')" class="btn btn-primary sectextcolor gladsmallbtn" value="<%=BtnPwdChanged.Text %>" />
                                                        </div>                     
                                                        <% } %>

                                            </td>
                                        </tr>
                                    </table>
                                    </div>
                                    </div>
                                    </div>
                                </td>
                            </tr>
                                

                            
                            <tr>
                                <td valign="top" height="60px" style="border: 0px solid #d0d0d0; padding: 10px; border-top: 0px solid #C0C0C0;"
                                    class="tabpanel">
                                    <div class="panel-group">
                                            <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                <div class="panel-heading whitehead">
                                                    <h4 class="panel-title">
                                                        <a onclick="expandedSection('collapse12a2')" data-toggle="collapse" href="#collapse12a2"><span class="fa fa-plus-square"
                                                            style=""></span>&nbsp;&nbsp; <asp:Localize ID="LocTwoFACdeEml" meta:resourcekey="str_twoFACdeEml" runat="server">Two-Factor Authentication Code Email</asp:Localize>
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="collapse12a2" class="panel-collapse collapse">
                                    <table width="100%">
                                        
                                        <tr>
                                            <td align="left" style="padding: 10px;">
                                               <table width="100%">
                                                    <tr>
                                                        <td width="80px">
                                                            <asp:Localize meta:resourcekey="asp_string11" runat="server">Subject</asp:Localize>:&nbsp;
                                                        </td>
                                                        <td>
                                                            <asp:TextBox ID="TxtTwoFACodeSub" Text="{ProductName} Authentication Code"
                                                                runat="server" Width="100%" CssClass="form-control" meta:resourcekey="twoFACodeSub"></asp:TextBox>
                                                                <asp:Label ID="LTxtTwoFACodeSub" runat="server" meta:resourcekey="str_nobrb"  CssClass="badge"></asp:Label>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:TextBox ID="txtTwoFACodeBody" runat="server" TextMode="MultiLine" Width="100%" Height="300px"  encoding="xml"
                                                    meta:resourcekey="str_twoFACodeBody"></asp:TextBox>
                                                        <% if (ApplyBtn.Visible) { %>
                                                        <div><div style="display:none;">
                                                            <asp:Button ID="BtnTwoFACCodeTest" runat="server" Text="Send Test Email to Admin" meta:resourcekey="str_sndTstEmlToAdm" />
                                                        </div>
                                                        <input type="button" onclick="SanitizeAndSendEmailAjax('<%=TxtTwoFACodeSub.ClientID %>','<%=txtTwoFACodeBody.ClientID %>')" class="btn btn-primary sectextcolor gladsmallbtn" value="<%=BtnTwoFACCodeTest.Text %>" />
                                                        </div>                      
                                                        <% } %>

                                            </td>
                                        </tr>
                                    </table>
                                    </div>
                                    </div>
                                    </div>
                                </td>
                            </tr>
                            
                            <tr>
                                <td valign="top" height="60px" style="border: 0px solid #d0d0d0; padding: 10px; border-top: 0px solid #C0C0C0;"
                                    class="tabpanel">
                                    <div class="panel-group">
                                            <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                <div class="panel-heading whitehead">
                                                    <h4 class="panel-title">
                                                        <a onclick="expandedSection('collapse12a2b')" data-toggle="collapse" href="#collapse12a2b"><span class="fa fa-plus-square"
                                                            style=""></span>&nbsp;&nbsp; <asp:Localize meta:resourcekey="str_dlyAdmNtfEml" runat="server">Daily Admin Notification Email</asp:Localize>
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="collapse12a2b" class="panel-collapse collapse">
                                    <table width="100%">
                                        
                                        <tr>
                                            <td align="left" style="padding: 10px;">
                                               <table width="100%">
                                                    <tr>
                                                        <td width="80px">
                                                            <asp:Localize meta:resourcekey="asp_string11" runat="server">Subject</asp:Localize>:&nbsp;
                                                        </td>
                                                        <td>
                                                            <asp:TextBox ID="TxtDailyAdminEmailSub" Text="Daily Notification ({ProductName}):{BrandedHost}"
                                                                runat="server" Width="100%" CssClass="form-control"></asp:TextBox>
                                                                <asp:Label ID="LTxtDailyAdminEmailSub" runat="server" meta:resourcekey="str_nobrb"  CssClass="badge"></asp:Label>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <% if (ApplyBtn.Visible) { %> 
                                               <div>
                                                    <div style="display:none;">
                                                        <asp:Button ID="BtnDailyAdminEmailTest" runat="server" Text="Send Test Email to Admin" meta:resourcekey="str_sndTstEmlToAdm" />
                                                    </div>
                                                    <input type="button" onclick="SanitizeAndSendEmailAjax('<%=TxtDailyAdminEmailSub.ClientID %>','<%=TxtDailyAdminEmailSub.ClientID %>')" class="btn btn-primary sectextcolor gladsmallbtn" value="<%=BtnDailyAdminEmailTest.Text %>" />
                                                </div>                     
                                                <% } %>

                                            </td>
                                        </tr>
                                    </table>
                                    </div>
                                    </div>
                                    </div>
                                </td>
                            </tr>


                            <tr>
                                <td valign="top" height="60px" style="border: 0px solid #d0d0d0; padding: 10px; border-top: 0px solid #C0C0C0;"
                                    class="tabpanel">
                                    <div class="panel-group">
                                            <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                <div class="panel-heading whitehead">
                                                    <h4 class="panel-title">
                                                        <a onclick="expandedSection('collapse13')" data-toggle="collapse" href="#collapse13"><span class="fa fa-plus-square"
                                                            style=""></span>&nbsp;&nbsp; <asp:Localize meta:resourcekey="str_stgApcQtaNtf" runat="server">Storage Approaching Quota Notification</asp:Localize>
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="collapse13" class="panel-collapse collapse">
                                    <table width="100%">
                                        
                                        <tr>
                                            <td align="left" style="padding: 10px;">
                                               <table width="100%">
                                                    <tr>
                                                        <td width="80px">
                                                            <asp:Localize meta:resourcekey="asp_string11" runat="server">Subject</asp:Localize>:&nbsp;
                                                        </td>
                                                        <td>
                                                            <asp:TextBox ID="TxtApproachingQuotaSub" Text="{UserEmail}: Storage Approaching Quota"
                                                                runat="server" Width="100%" CssClass="form-control"></asp:TextBox>
                                                                <asp:Label ID="LblTxtApproachingQuotaSub" runat="server" meta:resourcekey="str_nobrb"  CssClass="badge"></asp:Label>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:TextBox ID="TxtApproachingQuotaBody" runat="server" TextMode="MultiLine" Width="100%" Height="300px"  encoding="xml"></asp:TextBox>
                                                <% if (ApplyBtn.Visible) { %> 
                                               <div>
                                                    <div style="display:none;">
                                                        <asp:Button ID="BtnApproachingQuotaTest" runat="server" Text="Send Test Email to Admin" meta:resourcekey="str_sndTstEmlToAdm" />
                                                    </div>
                                                    <input type="button" onclick="SanitizeAndSendEmailAjax('<%=TxtApproachingQuotaSub.ClientID %>','<%=TxtApproachingQuotaBody.ClientID %>')" class="btn btn-primary sectextcolor gladsmallbtn" value="<%=BtnApproachingQuotaTest.Text %>" />
                                                </div>                     
                                                <% } %>

                                            </td>
                                        </tr>
                                    </table>
                                    </div>
                                    </div>
                                    </div>
                                </td>
                            </tr>



                        <tr>
                                    <td style="padding: 5px; text-align: left;border: 0px solid #d0d0d0; padding: 10px; border-top: 0px solid #C0C0C0;">
                                        <div class="panel-group">
                                            <div class="panel panel-default" style="background-color: white; box-shadow: 0px 0px 1px #a0a0a0!important">
                                                <div class="panel-heading whitehead">
                                                    <h4 class="panel-title">
                                                        <a onclick="expandedSection('collapse13')" data-toggle="collapse" href="#collapse13"><span class="fa fa-plus-square"
                                                            style=""></span>&nbsp;&nbsp; <asp:Localize meta:resourcekey="str_misc" runat="server">Settings</asp:Localize>
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="collapse13" class="panel-collapse collapse" style="padding: 5px;">
                                                    <asp:Localize meta:resourcekey="str_rpyToFld" runat="server">'Reply to' Field (Email, leave it blank if you want to use the default - not all email services support this feature):</asp:Localize>
                                        <br />
                                        <asp:TextBox ID="SMTPFromUser" runat="server" Width="40%" CssClass="form-control"
                                            meta:resourcekey="SMTPFromUserResource1"></asp:TextBox>
                                            <asp:Label ID="LSMTPFromUser" runat="server" meta:resourcekey="str_nobrb"  CssClass="badge"></asp:Label>
                                            </div>
                                            </div>
                                            </div>
                                    </td>
                                </tr>
                            <%} %>
                        </table>
                    </asp:Panel>
                    <br />
                </div>
        
    <asp:Localize ID="Not_Branded" meta:resourcekey="str_nobrb" Visible="False" runat="server">Not Branded</asp:Localize>
    <asp:HiddenField ID="BrandingObjectId" runat="server" />
    <asp:HiddenField ID="BrandingCluster" runat="server" />
    <script type="text/javascript">
        function adjust() {

            var e = document.getElementById("maindiv");
            e.style.height = (document.documentElement.offsetHeight - 100) + "px";
        }

        adjust();
        function iniTinyMce(){
        <% if (ApplyBtn.Visible){  %>
        
        tinymce.init({
            selector: "#ctl00_MainContent_WelcomeReseller",           
             menubar: true,
            statusbar: true,
            resize: "both",
             toolbar:   "styleselect | undo redo | removeformat | bold italic underline |  aligncenter alignjustify  | bullist numlist outdent indent | link | print | fontselect fontsizeselect| charmap | forecolor backcolor | code",
            plugins: ["image", "link", "textcolor", "code","charmap"]
        });

        tinymce.init({
            selector: "#ctl00_MainContent_WelcomeCustomer",           
             menubar: true,
            statusbar: true,
            resize: "both",
             toolbar:   "styleselect | undo redo | removeformat | bold italic underline |  aligncenter alignjustify  | bullist numlist outdent indent | link | print | fontselect fontsizeselect| charmap | forecolor backcolor | code",
            plugins: ["image", "link", "textcolor", "code","charmap"]
        });
        tinymce.init({
            selector: "#ctl00_MainContent_WelcomePUser",           
             menubar: true,
            statusbar: true,
            resize: "both",
             toolbar:   "styleselect | undo redo | removeformat | bold italic underline |  aligncenter alignjustify  | bullist numlist outdent indent | link | print | fontselect fontsizeselect| charmap | forecolor backcolor | code",
            plugins: ["image", "link", "textcolor", "code","charmap"]
        });

        tinymce.init({
            selector: "#ctl00_MainContent_WelcomeSubUser",           
            menubar: true,
            statusbar: true,
            resize: "both",
             toolbar:   "styleselect | undo redo | removeformat | bold italic underline |  aligncenter alignjustify  | bullist numlist outdent indent | link | print | fontselect fontsizeselect| charmap | forecolor backcolor | code",
            plugins: ["image", "link", "textcolor", "code","charmap"]
        });

        tinymce.init({
            selector: "#ctl00_MainContent_WelcomeGuestUser",           
             menubar: true,
            statusbar: true,
            resize: "both",
             toolbar:   "styleselect | undo redo | removeformat | bold italic underline |  aligncenter alignjustify  | bullist numlist outdent indent | link | print | fontselect fontsizeselect| charmap | forecolor backcolor | code",
            plugins: ["image", "link", "textcolor", "code","charmap"]
        });

        

        tinymce.init({
            selector: "#ctl00_MainContent_ReqFile",           
             menubar: true,
            statusbar: true,
            resize: "both",
             toolbar:   "styleselect | undo redo | removeformat | bold italic underline |  aligncenter alignjustify  | bullist numlist outdent indent | link | print | fontselect fontsizeselect| charmap | forecolor backcolor | code",
            plugins: ["image", "link", "textcolor", "code","charmap"]
        });

        tinymce.init({
            selector: "#ctl00_MainContent_NotifyUpload",           
             menubar: true,
            statusbar: true,
            resize: "both",
             toolbar:   "styleselect | undo redo | removeformat | bold italic underline |  aligncenter alignjustify  | bullist numlist outdent indent | link | print | fontselect fontsizeselect| charmap | forecolor backcolor | code",
            plugins: ["image", "link", "textcolor", "code","charmap"]
        });
        
        tinymce.init({
            selector: "#ctl00_MainContent_FastBody",
            menubar: true,
            statusbar: true,
            resize: "both",
            toolbar: "styleselect | undo redo | removeformat | bold italic underline |  aligncenter alignjustify  | bullist numlist outdent indent | link | print | fontselect fontsizeselect| charmap | forecolor backcolor | code",
            plugins: ["image", "link", "textcolor", "code", "charmap"]
        });
        tinymce.init({
            selector: "#ctl00_MainContent_AdminResetEml",
            menubar: true,
            statusbar: true,
            resize: "both",
            toolbar: "styleselect | undo redo | removeformat | bold italic underline |  aligncenter alignjustify  | bullist numlist outdent indent | link | print | fontselect fontsizeselect| charmap | forecolor backcolor | code",
            plugins: ["image", "link", "textcolor", "code", "charmap"]
        });

        tinymce.init({
            selector: "#ctl00_MainContent_FolderPurgeBody",
            menubar: true,
            statusbar: true,
            resize: "both",
            toolbar: "styleselect | undo redo | removeformat | bold italic underline |  aligncenter alignjustify  | bullist numlist outdent indent | link | print | fontselect fontsizeselect| charmap | forecolor backcolor | code",
            plugins: ["image", "link", "textcolor", "code", "charmap"]
        });

        
        tinymce.init({
            selector: "#ctl00_MainContent_NewDeviceBody",
            menubar: true,
            statusbar: true,
            resize: "both",
            toolbar: "styleselect | undo redo | removeformat | bold italic underline |  aligncenter alignjustify  | bullist numlist outdent indent | link | print | fontselect fontsizeselect| charmap | forecolor backcolor | code",
            plugins: ["image", "link", "textcolor", "code", "charmap"]
        });

       tinymce.init({
            selector: "#ctl00_MainContent_FCBody",
            menubar: true,
            statusbar: true,
            resize: "both",
            toolbar: "styleselect | undo redo | removeformat | bold italic underline |  aligncenter alignjustify  | bullist numlist outdent indent | link | print | fontselect fontsizeselect| charmap | forecolor backcolor | code",
            plugins: ["image", "link", "textcolor", "code", "charmap"]
        });


       tinymce.init({
           selector: "#ctl00_MainContent_SyncTaskBody",
           menubar: true,
           statusbar: true,
           resize: "both",
           toolbar: "styleselect | undo redo | removeformat | bold italic underline |  aligncenter alignjustify  | bullist numlist outdent indent | link | print | fontselect fontsizeselect| charmap | forecolor backcolor | code",
           plugins: ["image", "link", "textcolor", "code", "charmap"]
       });
       tinymce.init({
           selector: "#ctl00_MainContent_ShareExpirBody",
           menubar: true,
           statusbar: true,
           resize: "both",
           toolbar: "styleselect | undo redo | removeformat | bold italic underline |  aligncenter alignjustify  | bullist numlist outdent indent | link | print | fontselect fontsizeselect| charmap | forecolor backcolor | code",
           plugins: ["image", "link", "textcolor", "code", "charmap"]
       });

       
       tinymce.init({
           selector: "#ctl00_MainContent_ReceiveFileBody",
           menubar: true,
           statusbar: true,
           resize: "both",
           toolbar: "styleselect | undo redo | removeformat | bold italic underline |  aligncenter alignjustify  | bullist numlist outdent indent | link | print | fontselect fontsizeselect| charmap | forecolor backcolor | code",
           plugins: ["image", "link", "textcolor", "code", "charmap"]
       });

       

        tinymce.init({
            selector: "#ctl00_MainContent_WelcomeShare",           
             menubar: true,
            statusbar: true,
            resize: "both",
             toolbar:   "styleselect | undo redo | removeformat | bold italic underline |  aligncenter alignjustify  | bullist numlist outdent indent | link | print | fontselect fontsizeselect| charmap | forecolor backcolor | code",
            plugins: ["image", "link", "textcolor", "code","charmap"]
        });

        tinymce.init({
            selector: "#ctl00_MainContent_WelcomeAdmin",
             menubar: true,
            statusbar: true,
            resize: "both",
             toolbar:   "styleselect | undo redo | removeformat | bold italic underline |  aligncenter alignjustify  | bullist numlist outdent indent | link | print | fontselect fontsizeselect| charmap | forecolor backcolor | code",
            plugins: ["image", "link", "textcolor", "code","charmap"]
        });

        
        tinymce.init({
            selector: "#ctl00_MainContent_SharePWDBody",

            menubar: true,
            statusbar: true,
            resize: "both",
            toolbar: "styleselect | undo redo | removeformat | bold italic underline |  aligncenter alignjustify  | bullist numlist outdent indent | link | print | fontselect fontsizeselect| charmap | forecolor backcolor | code",
            plugins: ["image", "link", "textcolor", "code", "charmap"]
        });


        tinymce.init({
            selector: "#ctl00_MainContent_UserResetPwd",
            
             menubar: true,
            statusbar: true,
            resize: "both",
             toolbar:   "styleselect | undo redo | removeformat | bold italic underline |  aligncenter alignjustify  | bullist numlist outdent indent | link | print | fontselect fontsizeselect| charmap | forecolor backcolor | code",
            plugins: ["image", "link", "textcolor", "code","charmap"]
        });

        tinymce.init({
            selector: "#ctl00_MainContent_PwdChanged",

            menubar: true,
            statusbar: true,
            resize: "both",
            toolbar: "styleselect | undo redo | removeformat | bold italic underline |  aligncenter alignjustify  | bullist numlist outdent indent | link | print | fontselect fontsizeselect| charmap | forecolor backcolor | code",
            plugins: ["image", "link", "textcolor", "code", "charmap"]
        });
        tinymce.init({
            selector: "#ctl00_MainContent_txtTwoFACodeBody",

            menubar: true,
            statusbar: true,
            resize: "both",
            toolbar: "styleselect | undo redo | removeformat | bold italic underline |  aligncenter alignjustify  | bullist numlist outdent indent | link | print | fontselect fontsizeselect| charmap | forecolor backcolor | code",
            plugins: ["image", "link", "textcolor", "code", "charmap"]
        });
            
        tinymce.init({
            selector: "#ctl00_MainContent_TxtApproachingQuotaBody",
            menubar: true,
            statusbar: true,
            resize: "both",
            toolbar: "styleselect | undo redo | removeformat | bold italic underline |  aligncenter alignjustify  | bullist numlist outdent indent | link | print | fontselect fontsizeselect| charmap | forecolor backcolor | code",
            plugins: ["image", "link", "textcolor", "code", "charmap"]
        });
        
        tinymce.init({
            selector: "#ctl00_MainContent_NewSignIn",
            
             menubar: true,
            statusbar: true,
            resize: "both",
             toolbar:   "styleselect | undo redo | removeformat | bold italic underline |  aligncenter alignjustify  | bullist numlist outdent indent | link | print | fontselect fontsizeselect| charmap | forecolor backcolor | code",
            plugins: ["image", "link", "textcolor", "code","charmap"]
        });

        tinymce.init({
            selector: "#ctl00_MainContent_AdminResetPwd",
            
             menubar: true,
            statusbar: true,
            resize: "both",
             toolbar:   "styleselect | undo redo | removeformat | bold italic underline |  aligncenter alignjustify  | bullist numlist outdent indent | link | print | fontselect fontsizeselect| charmap | forecolor backcolor | code",
            plugins: ["image", "link", "textcolor", "code","charmap"]
        });

        <% }else{%>
        
        tinymce.init({
            selector: "#ctl00_MainContent_WelcomeReseller",           
            menubar: false,
            statusbar: true,
            resize: "both",
            readonly : 1,
            toolbar:false,
            statusbar: false,
            plugins: ["image", "link"]
        });

        tinymce.init({
            selector: "#ctl00_MainContent_WelcomeCustomer",           
            menubar: false,
            statusbar: true,
            resize: "both",
            readonly : 1,
            toolbar:false,
            statusbar: false,
            plugins: ["image", "link"]
        });
        
        tinymce.init({
            selector: "#ctl00_MainContent_WelcomePUser",           
            menubar: false,
            statusbar: true,
            resize: "both",
            readonly : 1,
            toolbar:false,
            statusbar: false,
            plugins: ["image", "link"]
        });

        tinymce.init({
            selector: "#ctl00_MainContent_WelcomeSubUser",           
            menubar: false,
            statusbar: true,
            resize: "both",
            readonly : 1,
            toolbar:false,
            statusbar: false,
            plugins: ["image", "link"]
        });
        tinymce.init({
            selector: "#ctl00_MainContent_FCBody",
            menubar: false,
            statusbar: true,
            resize: "both",
            readonly: 1,
            toolbar: false,
            statusbar: false,
            plugins: ["image", "link"]
        });

        tinymce.init({
            selector: "#ctl00_MainContent_NewDeviceBody",
            menubar: false,
            statusbar: true,
            resize: "both",
            readonly: 1,
            toolbar: false,
            statusbar: false,
            plugins: ["image", "link"]
        });

        tinymce.init({
            selector: "#ctl00_MainContent_AdminResetEml",
            menubar: false,
            statusbar: true,
            resize: "both",
            readonly: 1,
            toolbar: false,
            statusbar: false,
            plugins: ["image", "link"]
        });
        

        tinymce.init({
            selector: "#ctl00_MainContent_FastBody",
            menubar: false,
            statusbar: true,
            resize: "both",
            readonly: 1,
            toolbar: false,
            statusbar: false,
            plugins: ["image", "link"]
        });
        
        tinymce.init({
            selector: "#ctl00_MainContent_FolderPurgeBody",
            menubar: false,
            statusbar: true,
            resize: "both",
            readonly: 1,
            toolbar: false,
            statusbar: false,
            plugins: ["image", "link"]
        });
        tinymce.init({
            selector: "#ctl00_MainContent_SyncTaskBody",
            menubar: false,
            statusbar: true,
            resize: "both",
            readonly: 1,
            toolbar: false,
            statusbar: false,
            plugins: ["image", "link"]
        });
        
        tinymce.init({
            selector: "#ctl00_MainContent_ShareExpirBody",
            menubar: false,
            statusbar: true,
            resize: "both",
            readonly: 1,
            toolbar: false,
            statusbar: false,
            plugins: ["image", "link"]
        });

        
        tinymce.init({
            selector: "#ctl00_MainContent_ReceiveFileBody",
            menubar: false,
            statusbar: true,
            resize: "both",
            readonly: 1,
            toolbar: false,
            statusbar: false,
            plugins: ["image", "link"]
        });

        tinymce.init({
            selector: "#ctl00_MainContent_WelcomeGuestUser",           
            menubar: false,
            resize: "both",
            readonly : 1,
            toolbar:false,
            statusbar: false,
            plugins: ["image", "link"]
        });
        
        tinymce.init({
            selector: "#ctl00_MainContent_ReqFile",           
            menubar: false,
            resize: "both",       
            toolbar:false,
            statusbar: false,                
            readonly : 1,
            plugins: ["image", "link"]
        });

        tinymce.init({
            selector: "#ctl00_MainContent_NotifyUpload",           
            menubar: false,
            resize: "both",       
            toolbar:false,
            statusbar: false,                
            readonly : 1,
            plugins: ["image", "link"]
        });

        tinymce.init({
            selector: "#ctl00_MainContent_WelcomeShare",           
            menubar: false,
            resize: "both",       
            toolbar:false,
            statusbar: false,                
            readonly : 1,
            plugins: ["image", "link"]
        });

        tinymce.init({
            selector: "#ctl00_MainContent_WelcomeAdmin",
            menubar: false,  
            toolbar:false,
            statusbar: false,                                              
            resize: "both",
            readonly : 1,
            plugins: ["image","link"]
        });
        
        tinymce.init({
            selector: "#ctl00_MainContent_SharePWDBody",
            toolbar: false,
            statusbar: false,
            menubar: false,
            readonly: 1,
            resize: "both",
            plugins: ["image", "link"]
        });
        tinymce.init({
            selector: "#ctl00_MainContent_UserResetPwd",
            toolbar:false,
            statusbar: false,            
            menubar: false,
            readonly : 1,
            resize: "both",
            plugins: ["image", "link"]
        });
        tinymce.init({
            selector: "#ctl00_MainContent_AdminResetPwd",
            toolbar:false,
            statusbar: false,
            menubar: false,
            readonly : 1,
            resize: "both",
            plugins: ["image", "link"]
        });
        tinymce.init({
            selector: "#ctl00_MainContent_NewSignIn",
            toolbar:false,
            statusbar: false,
            menubar: false,
            readonly : 1,
            resize: "both",
            plugins: ["image", "link"]
        });
        tinymce.init({
            selector: "#ctl00_MainContent_PwdChanged",
            toolbar: false,
            statusbar: false,
            menubar: false,
            readonly: 1,
            resize: "both",
            plugins: ["image", "link"]
        });
        tinymce.init({
            selector: "#ctl00_MainContent_txtTwoFACodeBody",
            toolbar: false,
            statusbar: false,
            menubar: false,
            readonly: 1,
            resize: "both",
            plugins: ["image", "link"]
        });
        tinymce.init({
            selector: "#ctl00_MainContent_TxtApproachingQuotaBody",
            toolbar: false,
            statusbar: false,
            menubar: false,
            readonly: 1,
            resize: "both",
            plugins: ["image", "link"]
        });
        
            <%} %>


            //expand the last expanded section on load
            try{
                var expanded = document.getElementById("<%=hidExpandedSectionID.ClientID %>").value;
                
                document.getElementById(expanded).classList = "collapse show";
                
            }catch(ex){
            console.log("failed to expand section. " + ex)
            }
        }

        iniTinyMce();

        function NowSubmit() {
            Wait("<%=LocApyChg.Text %>");;
            return;
            /*
            alert(tinymce.get('ctl00_MainContent_WelcomeAdmin').getContent());
            var e = document.getElementById("ctl00_MainContent_WelcomeAdmin");
            alert(e.value);
            return false;
            */
        }


        
    </script>
</asp:Content>
