﻿<%@ Page Title="Gladinet Cloud - Publish Folder" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="BandwidthStat.aspx.cs" Inherits="GladinetPayFlow.BandwidthStat"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    
    <script src="bootstrap4/js/Chart.bundle.min.js"></script>
    <style type="text/css">
        .pheader{
            height:48px; 
            padding-top:12px;
            font-size: 18px;
        }
         td {
            font-size: 15px;
            
            font-weight: 100;
        }
        
        b {
            font-weight: 500;
        }
        
        
        

         .titlecol
         {
             background-color: #f0f0f0;
             font-size: 14px;
         }
        
        .style1
        {
            width: 153px;
        }
        
        .newusericon
        {
            background-image: url(images/upgradeuser.png);
        }
        
           .active {
           background-color: #565656;
       }
       
       li {
           background-color: transparent;
       }
    </style>
    <script type="text/javascript">





        var activewin;
        function closeCancelActiveWin() {
            activewin.close();
        }

        function closeActiveWin() {
            window.location = window.location;
        }

        function OnCancelPub() {
            parent.closeActiveWin();
        }

        function OnRefresh() {
            var rowURL = window.location.href;
            var e = document.getElementById("ImgContainer");

            if (rowURL.indexOf("id=") == -1)
                window.location.href = window.location.href + "?id=" + (new Date()).toString();
            else
                window.location.href = window.location.href + "&id=" + (new Date()).toString();
        }
      
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocFaiToLoaInf" meta:resourcekey="str_faiToLoaInf" Visible="false">Failed to load info</asp:Localize>
<asp:Localize ID="LocBts" meta:resourcekey="str_bts" runat="server" Visible="false">Bytes</asp:Localize>
<asp:Localize ID="LocBwtUsg24HrsUpd" meta:resourcekey="str_bwtUsg24HrsUpd" runat="server" Visible="false">Bandwidth usage in last 24 hours (Upload)</asp:Localize>
<asp:Localize ID="LocBwtUsg24HrsDld" meta:resourcekey="str_bwtUsg24HrsDld" runat="server" Visible="false">Bandwidth usage in last 24 hours (Download)</asp:Localize>
<asp:Localize ID="LocBwtUsg7DysUpd" meta:resourcekey="str_bwtUsg7DysUpd" runat="server" Visible="false">Bandwidth usage in last 7 days (Upload)</asp:Localize>
<asp:Localize ID="LocBwtUsg7DysDld" meta:resourcekey="str_bwtUsg7DysDld" runat="server" Visible="false">Bandwidth usage in last 7 days (Download)</asp:Localize>
<asp:Localize ID="LocBwtUsg30DysUpd" meta:resourcekey="str_bwtUsg30DysUpd" runat="server" Visible="false">Bandwidth usage in last 30 days (Upload)</asp:Localize>
<asp:Localize ID="LocBwtUsg30DysDld" meta:resourcekey="str_bwtUsg30DysDld" runat="server" Visible="false">Bandwidth usage in last 30 days (Download)</asp:Localize>
<asp:Localize ID="LocBwtUsg60MinUpd" meta:resourcekey="str_bwtUsg60MinUpd" runat="server" Visible="false">Bandwidth usage in last 60 minutes (Upload)</asp:Localize>
<asp:Localize ID="LocBwtUsg60MinDld" meta:resourcekey="str_bwtUsg60MinDld" runat="server" Visible="false">Bandwidth usage in last 60 minutes (Download)</asp:Localize>
<div class="meubardrop navbar navbar-default" role="navigation" >
        <div class="container-fluid">
            
            
            <div id="errmsgdiv" class="navbar-text">
                <b>
                    <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
            </div>
            
            
            
                <table class="navbar-right" style="margin-top: 10px;" >
                    <tr>
                        <td style="color: #565656; padding-right: 5px;font-weight: 100;"><asp:Localize runat="server" meta:resourcekey="str_RepPer">Reporting period:</asp:Localize></td>
                        
                        <td>
                            <asp:Localize ID="Loc1Hr" meta:resourcekey="ddl_1Hr" runat="server" Visible="false">Last 1 hour</asp:Localize>
                            <asp:Localize ID="Loc24Hr" meta:resourcekey="ddl_24Hr" runat="server" Visible="false">Last 24 hours</asp:Localize>
                            <asp:Localize ID="Loc7Dys" meta:resourcekey="ddl_7Dys" runat="server" Visible="false">Last 7 days</asp:Localize>
                            <asp:Localize ID="Loc30Dys" meta:resourcekey="ddl_30Dys" runat="server" Visible="false">Last 30 days</asp:Localize>

                            <asp:DropDownList ID="ReportPeriodList" runat="server" CssClass="browser-default custom-select secsubbordercolor" OnSelectedIndexChanged="ReportPeriodList_SelectedIndexChanged" AutoPostBack="True"></asp:DropDownList></td>
                        <td>
                            <div class="btn btn-primary gladbtn navbar-btn navbar-right" style="margin-right: 8px;" title="<%=LinkButton2.Text %>">
                <i class="gladinet-icons md-32 md-dark hand" style="display:table-cell;" onclick="__doPostBack('LinkButton2', '');">µ</i>
                <div style="display:table-cell;vertical-align:top;padding-left:5px;display:none;"><asp:LinkButton ID="LinkButton2" runat="server" Text="Refresh" OnClick="ReportPeriodList_SelectedIndexChanged"  ForeColor="#565656"></asp:LinkButton></div>  
            </div>
                        </td>
                    </tr>
                </table>
            
        </div>
    </div>
     <div style="width:100%; overflow:auto" id="rowcontainer">
        <div class="row " style="width:100%;align-content: center; margin-top:20px; padding:10px;" align="center">
        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 text-center topbuffer" style="padding-bottom:10px;">
                <div class=" panel panel-default viewcard" >
                                <div class="panel-heading panelhead pheader" >
                                     <%=UploadTitle.Value %>
                                </div>
                                <div class="panel-body" style=" width: 100%" >
                                    <canvas id="upload30d" ></canvas>
                                </div>
                            </div>            
        </div>
        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 text-center topbuffer" style="padding-bottom:10px;">
            
            <div class=" panel panel-default viewcard" >
                                <div class="panel-heading panelhead pheader">
                                     <%=DownloadTitle.Value %>
                                </div>
                                <div class="panel-body" style=" width: 100%" >
                                    <canvas id="upload7" ></canvas>
                                </div>
                            </div>     
        </div>
        
        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 text-center topbuffer" style="padding-bottom:10px;">
                <div class=" panel panel-default viewcard" >
                                <div class="panel-heading panelhead pheader"><asp:Localize runat="server" meta:resourcekey="str_Top10TenWitBanUsa">top 10 tenants with bandwidth usage</asp:Localize></div>
                                <div class="panel-body" style="height: 420px; width: 100%" id="upload24">
                                    <table width="100%" class="table-striped">
                                        <tr>
                                            <td style="padding: 3px; color: #404040; font-weight: 100; font-size: 16px" align="left"><asp:Localize meta:resourcekey="str_nme" runat="server">Name</asp:Localize></td>
                                            <td style="padding: 3px; color: #404040; font-weight: 100; font-size: 16px; width: 100px;" align="right"><asp:Localize meta:resourcekey="str_upd" runat="server">Upload</asp:Localize></td>
                                            <td style="padding: 3px; color: #404040; font-weight: 100; font-size: 16px;width: 100px;" align="right"><asp:Localize meta:resourcekey="str_dld" runat="server">Download</asp:Localize> </td>
                                        </tr>
                                        <asp:Repeater ID="TopTenantRep" runat="server" >
                                        <ItemTemplate>        
                                            <tr>
                                            <td style="padding: 3px; color: #565656; font-weight: 100; font-size: 14px" align="left"><%#DataBinder.Eval(Container.DataItem,"Name") %></td>
                                            <td style="padding: 3px; color: #565656; font-weight: 100; font-size: 14px; " align="right"><%#DataBinder.Eval(Container.DataItem,"UploadDesc") %></td>
                                            <td style="padding: 3px; color: #565656; font-weight: 100; font-size: 14px;" align="right"><%#DataBinder.Eval(Container.DataItem,"DownloadDesc") %> </td>
                                        </tr>
                                        </ItemTemplate>        
                                        </asp:Repeater>
                                    </table>
                                </div>
                            </div>            
        </div>
        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 text-center topbuffer" style="padding-bottom:10px;">
            
            <div class=" panel panel-default viewcard" >
                                <div class="panel-heading panelhead pheader"><asp:Localize runat="server" meta:resourcekey="str_Top10UseWitBanUsa">top 10 users with bandwidth usage</asp:Localize></div>
                                <div class="panel-body" style="height: 420px; width: 100%" id="upload60">
                                                                        <table width="100%" class="table-striped">
                                        <tr>
                                            <td style="padding: 3px; color: #404040; font-weight: 100; font-size: 16px"  align="left"><asp:Localize meta:resourcekey="str_nme" runat="server">Name</asp:Localize></td>
                                            <td style="padding: 3px; color: #404040; font-weight: 100; font-size: 16px; width: 100px;"  align="right"><asp:Localize meta:resourcekey="str_upd" runat="server">Upload</asp:Localize></td>
                                            <td style="padding: 3px; color: #404040; font-weight: 100; font-size: 16px; width: 100px;"  align="right"><asp:Localize meta:resourcekey="str_dld" runat="server">Download</asp:Localize> </td>
                                        </tr>
                                                          <asp:Repeater ID="TopUserRep" runat="server" >
                                        <ItemTemplate>        
                                            <tr>
                                            <td style="padding: 3px; color: #565656; font-weight: 100; font-size: 14px" align="left"><%#DataBinder.Eval(Container.DataItem,"Name") %></td>
                                            <td style="padding: 3px; color: #565656; font-weight: 100; font-size: 14px; " align="right"><%#DataBinder.Eval(Container.DataItem,"UploadDesc") %></td>
                                            <td style="padding: 3px; color: #565656; font-weight: 100; font-size: 14px;" align="right"><%#DataBinder.Eval(Container.DataItem,"DownloadDesc") %> </td>
                                        </tr>
                                        </ItemTemplate>        
                                        </asp:Repeater>
                                    </table>

                                </div>
                            </div>     
        </div>
            
        </div>
          <div style="display:none;">
            <span id="sectextcolor" class="sectextcolor"></span>
        <span id="lighttextcolor" class="lighttextcolor"></span>
        </div>
    </div>
    <asp:HiddenField ID="UploadTitle" runat="server" />
    <asp:HiddenField ID="DownloadTitle" runat="server" />
        <script type="text/javascript">

       


        

        var Upload24Data = [
          <asp:Repeater ID="Upload24DataRep" runat="server" >
            <ItemTemplate>         
            <%#(Container.ItemIndex == 0)? "": "," %>      
            {        
            date:'<%#DataBinder.Eval(Container.DataItem,"Name") %>',
                Bytes:<%#DataBinder.Eval(Container.DataItem,"Value") %>
            }
            </ItemTemplate>
        </asp:Repeater>      
            ];


        var Upload30Data = [
          <asp:Repeater ID="Upload30DataRep" runat="server" >
            <ItemTemplate>         
            <%#(Container.ItemIndex == 0)? "": "," %>      
            {        
            date:'<%#DataBinder.Eval(Container.DataItem,"Name") %>',
                Bytes:<%#DataBinder.Eval(Container.DataItem,"Value") %>
            }
            </ItemTemplate>
        </asp:Repeater>      
            ];

       
        var Upload7Data = [
          <asp:Repeater ID="Upload7DataRep" runat="server" >
            <ItemTemplate>         
            <%#(Container.ItemIndex == 0)? "": "," %>      
            {        
            date:'<%#DataBinder.Eval(Container.DataItem,"Name") %>',
                Bytes:<%#DataBinder.Eval(Container.DataItem,"Value") %>
            }
            </ItemTemplate>
        </asp:Repeater>      
            ];

        var Upload60Data = [
          <asp:Repeater ID="Upload60DataRep" runat="server" >
            <ItemTemplate>         
            <%#(Container.ItemIndex == 0)? "": "," %>      
            {        
            date:'<%#DataBinder.Eval(Container.DataItem,"Name") %>',
                Bytes:<%#DataBinder.Eval(Container.DataItem,"Value") %>
            }
            </ItemTemplate>
        </asp:Repeater>      
            ];
            
             

            function adjust(){
                
                var e = document.getElementById("rowcontainer");
                e.style.height = (document.documentElement.offsetHeight -72)+"px";
                
            }
            
            function FormatFileSize(size) {
                try{
                    if (size < 1024) { //pow(2,10)
                        return size + " bytes";
                    } else if (size < 1048576) { //pow(2,20)
                        return (Math.round(((size * 10) / 1024)) / 10) + " KB";
                    } else if (size < 1073741824) { //pow(2,30)
                        return (Math.round(((size * 10) / 1048576)) / 10) + " MB";
                    } else if (size < 1099511627776) { //pow(2,40)
                        return (Math.round(((size * 100) / 1073741824)) / 100) + " GB";
                    } else if (size < 1125899906842624) { //pow(2,50)
                        return (Math.round(((size * 100) / 1099511627776)) / 100) + " TB";
                    } else { //pow(2,60)
                        return (Math.round(((size * 100) / 1125899906842624)) / 100) + " PB";
                    }
                }catch(e){
                    alert(e);
                }

                return size;

            }
            function newDraewChart(rid, fields, data,  xtitle, ytitle, xfield, yfield, charttype)
            {
            
                var xs = [];
                var ys = [];
                for(var i=0; i<data.length;++i){
                    xs[i] = data[i].date;
                    ys[i] = data[i].Bytes;
                }
                var ctx = document.getElementById(rid).getContext('2d');
                var myChart = new Chart(ctx, {
                    type: 'line',
                    data: {
                        labels: xs,
                        datasets: [{
                            label: xtitle,
                            backgroundColor:  $("#lighttextcolor").css("color"),
                            borderColor: $("#sectextcolor").css("color"),
                            data: ys,
                            borderWidth: 1
                        }]
                    },
                    options: {
                        scales: {
                            yAxes: [{
                                ticks: {
                                    beginAtZero:false,
                                    callback: function(value, index, values) {
                                        return  FormatFileSize(value);
                                    }
                                }
                            }]
                        }
                    }
                });
            }

        
         Ext.onReady(function () {
            adjust();
            // DrawChart('upload24', ['date', 'Bytes'], Upload24Data, 'Time', 'Bandwidth Usage', 'date', 'Bytes','column');
            newDraewChart('upload30d', ['date', 'Bytes'], Upload30Data, "<asp:Localize meta:resourcekey="str_tme" runat="server">Time</asp:Localize>", "<asp:Localize meta:resourcekey="str_bdwUsg" runat="server">Bandwidth Usage</asp:Localize>", 'date', "<asp:Localize meta:resourcekey="str_bts" runat="server" >Bytes</asp:Localize>",'column');             
            newDraewChart('upload7', ['date', 'Bytes'],  Upload7Data, "<asp:Localize meta:resourcekey="str_tme" runat="server">Time</asp:Localize>", "<asp:Localize meta:resourcekey="str_bdwUsg" runat="server">Bandwidth Usage</asp:Localize>", 'date', "<asp:Localize meta:resourcekey="str_bts" runat="server" >Bytes</asp:Localize>",'column');
             //DrawChart('upload60', ['date', 'Bytes'], Upload60Data, 'Time', 'Bandwidth Usage', 'date', 'Bytes','column');
         });
      
      </script>

</asp:Content>
