﻿<%@ Page Title="Device Info" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="DeviceBackupSnapshots.aspx.cs" Inherits="GladinetPayFlow.DeviceBackupSnapshots"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" EnableViewState="False" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
       
           
    </style>
    <script type="text/javascript">
        function GetShortString(src, MaxLen) {
            if (src.length <= MaxLen)
                return src;
           
            var len = (MaxLen - 3) / 2;
            var p1 = src.substring(0, len);
            var p2 = src.substring(src.length - len);
            return p1 + "..." + p2;

        }
        function OnBrowseSnapshot(n,snapshotid) {
            parent.OpenNextMenu("&#x139;", GetShortString(n, 32), "/management/BackupMgr/UI/DeviceBackupSetSnapshotBrowser.aspx?child=1&tid=<%=DeviceId.Value%>&bsid=<%=BackupSetId.Value%>&snid=" + snapshotid);
        }
        function OnRefresh() {
            var e = document.getElementById("ctl00_MainContent_RefreshBtn");


            Wait("...");
            e.click();

        }  
        function OnBack() {
            location.href = "/management/backupmgr/ui/DeviceBackupDashboard.aspx" + location.search;
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize ID="LocSnaIsBeiCreOnTheDevPle" meta:resourcekey="str_snaIsBeiCreOnTheDevPle" Visible="false" runat="server">Snapshot is being created on the device, please refresh the page later</asp:Localize>
<asp:Localize ID="LocFaiToCreNewSna" meta:resourcekey="str_faiToCreNewSna" Visible="false" runat="server">Failed to create new snapshot</asp:Localize>
<asp:Localize ID="LocSnaNamCanCon" meta:resourcekey="str_snaNamCanCon" Visible="false" runat="server">Snapshot name cannot contain</asp:Localize>
<asp:Localize ID="LocSnaNamExc64Cha" meta:resourcekey="str_snaNamExc64Cha" Visible="false" runat="server">Snapshot name exceeding 64 chars</asp:Localize>
<asp:Localize ID="LocSnaNamCanBeEmp" meta:resourcekey="str_snaNamCanBeEmp" Visible="false" runat="server">Snapshot name cannot be empty</asp:Localize>
<asp:Localize ID="LocFaiToLoaSna" meta:resourcekey="str_faiToLoaSna" Visible="false" runat="server">Failed to load snapshots</asp:Localize>
<asp:Localize ID="LocBacSetNotFou" meta:resourcekey="str_bacSetNotFou" Visible="false" runat="server">Backup set not found</asp:Localize>
<asp:Localize ID="LocSnaCreBy" meta:resourcekey="str_snaCreBy" Visible="false" runat="server">Snapshot created by</asp:Localize>
<asp:Localize ID="LocMisPar" meta:resourcekey="str_misPar" runat="server" Visible="False">Missing parameter</asp:Localize>

    <div id="defaultcontent">
        <div style="width: 100%; padding: 5px; <% if (IsChildUi){ %>border-bottom: 1px solid #eeeeee; <% } %>" <% if (!IsChildUi)
            { %>class="meubardrop"
            <% } %>>
            <table width="100%">
                <tr>
                    <td style="padding-left:20px;"><i class="gladinet-icons md-24 iconviewitemcolor center" style="margin-top:-5px">&#x150;</i><span style="padding-left:5px; color: #565656; font-weight: 100;"><asp:Localize meta:resourcekey="str_snapshots" runat="server">Snapshots</asp:Localize></span></td>
                    <td style="font-size: 16px; color: #565656; font-weight: 100; padding:10px; padding-left: 14px;">
                        <asp:Label ID="SnapshotsCountLable" runat="server" Text=""></asp:Label>
                    </td>
                    <td></td>
                    <td>
                        <asp:Label ID="ErrorMsg" runat="server" Text="" ForeColor="Red"></asp:Label>
                    </td>
                    <td align="right" style="padding:10px;">
                        <i class="gladinet-icons md-22 md-dark hand center toolbtn" style="line-height:22px;display: inline-block; margin-top: -3px; padding-right:10px;" title="<asp:Localize meta:resourcekey="str_bac" runat="server">Back</asp:Localize>"  onclick="OnBack();return false;">&#x00a6;</i>
                        <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="line-height:24px;display: inline-block; margin-top: -3px; padding-right:10px;" title="<asp:Localize meta:resourcekey="str_ref" runat="server">Refresh</asp:Localize>"  onclick="OnRefresh();return false;">&#xB5;</i>
                        <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="line-height:24px;display: inline-block; margin-top: -3px;" data-toggle="modal" data-target="#NewSnapshotModal"  title="<asp:Localize meta:resourcekey="str_addNewSna" runat="server">Add New Snapshot</asp:Localize>">&#xc9;</i>
                    </td>
                </tr>


            </table>
        </div>
        <div style="width: 100%; overflow:auto;" id="contentpanel">
            <asp:Repeater ID="SnapshotsRepeater" runat="server">
                <ItemTemplate>
                    <div style="border-bottom-width: 1px; border-bottom-style: solid; border-color: #f0f0f0; font-weight: 100; padding: 10px;">
                        <table width="100%">
                            <tr>
                                <td style="width: 48px;" align="center" valign="middle">
                                    <i class="gladinet-icons md-24  hand center sectextcolor " style="display: inline-block; margin-top: -3px;" title="Snapshot">&#x139;</i>
                                </td>
                                <td valign="middle" style="font-size: 16px; color: #202020;">
                                    <%# DataBinder.Eval(Container.DataItem, "DisplayName")%>
                                </td>
                                
                            </tr>
                            <tr>
                                <td colspan="2" style="padding: 10px;padding-bottom:3px;font-size: 12px; color: #565656;">
                                    <span><asp:Localize meta:resourcekey="str_creTim" runat="server">Creation Time:</asp:Localize></span><span style="padding-left:3px; padding-right:10px;"><%#DataBinder.Eval(Container.DataItem, "CreateTimeDisplay")%></span>
                                    <span style="display:none;"><asp:Localize meta:resourcekey="str_folders" runat="server">Folders:</asp:Localize></span><span style="padding-left:3px;padding-right:10px;" ><%#DataBinder.Eval(Container.DataItem, "DirCount")%></span>
                                    <span style="display:none;"><asp:Localize meta:resourcekey="str_files" runat="server">Files:</asp:Localize></span><span style="padding-left:3px;padding-right:10px;" ><%#DataBinder.Eval(Container.DataItem, "FileCount")%></span>
                                    <a href="javascript:;" onclick='OnBrowseSnapshot("<%#DataBinder.Eval(Container.DataItem, "DisplayName")%>","<%#DataBinder.Eval(Container.DataItem, "SnapshotId")%>"); return false;'>Browse</a>
                                </td>
                            </tr>
                            
                        </table>

                    </div>
                </ItemTemplate>
            </asp:Repeater>
        </div>
    </div>
    <div id="childwnd" style="width: 100%; display: none;">
        <div width="100%" style="background-color: white; border: 0px; padding-bottom: 0px; align-content: right; border-bottom: 1px solid #f0f0f0;">
            <table width="100%" style="border-collapse: collapse;" cellpadding="0" cellspacing="0">
                <tr>
                    <td>
                        <table>
                            <tr>
                                <td style="padding: 5px; font-size: 18px; cursor: pointer; font-weight: 100;" class="sectextcolor toolnavbtn" onclick="CloseChildWnd();">
                                    <asp:Localize runat="server" meta:resourcekey="str_shts">Snapshots</asp:Localize></td>

                                <td style="padding: 5px; font-size: 18px;" class="sectextcolor ">></td>
                                <td align="left" style="padding: 5px; border-bottom: 0px solid #cccccc; padding-right: 10px; height: 48px; font-size: 18px; font-weight: 100;" id="child_title"></td>

                            </tr>
                        </table>
                    </td>

                    <td style="border-bottom: 0px solid #cccccc; padding-right: 10px;">
                        <div style="float: right; font-size: 32px; font-weight: 100; cursor: pointer;" class="sectextcolor" onclick="CloseChildWnd();">&times;</div>
                    </td>
                </tr>
            </table>
        </div>


        <iframe width="100%" src="/portal/WaitWin.htm" frameborder="0" style="margin-top: 5px;"
            border="0" height="100%" id="child_body"></iframe>
    </div>
    <div id="NewSnapshotModal" class="modal fade" role="dialog">
                        
                        <div class="modal-dialog">
                            <!-- Modal content-->
                            <div class="modal-content" style="width: 400px;">
                                <div class="modal-header">


                                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                                </div>
                                <div class="modal-body">
                                    <table>
                                        <tr>
                                            <td align="left" valign="middle" style="padding: 10px;padding-top:0px;padding-bottom:0px;" class="glabel2">
                                                <asp:Localize runat="server" meta:resourcekey="str_shtNme">Snapshot Name</asp:Localize>
                                            </td>
                                            </tr>
                                        <tr>
                                            <td align="right" valign="middle" style="padding: 10px;padding-top:0px;padding-bottom:0px; width: 100px;">

                                                <asp:TextBox ID="SnapshotName" runat="server" CssClass="form-control" Width="300px"></asp:TextBox>

                                            </td>

                                        </tr>
                                        <tr>
                                            <td  align="left" valign="middle" style="padding: 10px;" class="glabel2">
                                                <table>
                                                    <tr>
                                                        <td>
                                                            <asp:CheckBox ID="FullSnapshot" runat="server" />
                                                        </td>
                                                        <td><asp:Localize meta:resourcekey="str_fulSna" runat="server">Full snapshot</asp:Localize></td>
                                                    </tr>
                                                </table>
                                                
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                                <div class="modal-footer">
                                    <asp:Button ID="AddNewSnapShot" runat="server" meta:resourcekey="str_tkeSht" Text="Take a snapshot" CssClass="btn btn-primary gladbtn"
                                        OnClick="AddNewSnapShot_Click" OnClientClick="OnAddSnapshotClick();return true;" />

                                    <button type="button" class="btn btn-default" data-dismiss="modal">
                                       Cancel</button>
                                </div>
                            </div>
                        </div>
                    </div>
    <div style="display: none">
        <asp:LinkButton ID="RefreshBtn" runat="server" OnClick="RefreshBtn_Click">Refresh btn</asp:LinkButton>
        <asp:HiddenField ID="DeviceId" runat="server" />
        <asp:HiddenField ID="BackupSetId" runat="server" />
    </div>

    <script type="text/javascript">
        function OnAddSnapshotClick() {
            Wait('');
            $('#NewSnapshotModal').modal('hide');
        }
        function CloseChildWnd() {
            var f = document.getElementById('defaultcontent');
            f.style.display = "";


            f = document.getElementById('child_body');
            f.src = "/portal/WaitWin.htm";

            f = document.getElementById('childwnd');
            f.style.display = "none";

        }
        function OpenChildWnd(t, s) {
            var f = document.getElementById('defaultcontent');
            f.style.display = "none";


            f = document.getElementById('child_body');
            f.src = s;

            f = document.getElementById('childwnd');
            f.style.display = "";

            f = document.getElementById('child_title');
            f.innerHTML = t;

        }
        function closeCancelActiveWin() {
            CloseChildWnd();
        }

        function GetShortString(src, MaxLen) {
            if (src.length <= MaxLen)
                return src;
            src = src.replace('[BuiltInGroup]', '');
            if (src.length <= MaxLen)
                return src;
            var len = (MaxLen - 3) / 2;
            var p1 = src.substring(0, len);
            var p2 = src.substring(src.length - len);
            return p1 + "..." + p2;

        }

        function FormatFileSize(size) {
            var s = 0 + size;
            if (isNaN(s))
                return "0";
            if (size < 1024) { //pow(2,10)
                return size + " B";
            } else if (size < 1048576) { //pow(2,20)
                return (Math.round(((size * 10) / 1024)) / 10) + " KB";
            } else if (size < 1073741824) { //pow(2,30)
                return (Math.round(((size * 10) / 1048576)) / 10) + " MB";
            } else if (size < 1099511627776) { //pow(2,40)
                return (Math.round(((size * 100) / 1073741824)) / 100) + " GB";
            } else if (size < 1125899906842624) { //pow(2,50)
                return (Math.round(((size * 100) / 1099511627776)) / 100) + " TB";
            } else { //pow(2,60)
                return (Math.round(((size * 100) / 1125899906842624)) / 100) + " PB";
            }
        }
        function adjust() {
            var e = document.getElementById("contentpanel");
            e.style.height = (window.innerHeight - 60) + "px";
        }
        adjust();
    </script>
</asp:Content>
