﻿<%@ Page Title="Device Info" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="DeviceBackupSetTargetFolders.aspx.cs" Inherits="GladinetPayFlow.DeviceBackupSetTargetFolders"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" EnableViewState="False" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <script src="/management/bootstrap4/js/Chart.bundle.min.js"></script>
    <style type="text/css">
       
           
    </style>
    <script type="text/javascript">   
        function OnAddTargetFolder() {
            OpenChildWnd("Add New Target Folder", "AddTargetFolder.aspx?child=1&id=<%=DeviceId.Value%>&sid=<%=BackupSetId.Value%>");
        }

        function OnEditTargetFolder(n, fhash)
        {
            OpenChildWnd(GetShortString(n,32), "EditTargetFolder.aspx?child=1&id=<%=DeviceId.Value%>&sid=<%=BackupSetId.Value%>&fid=" + fhash);
        }

        function OnDeleteBackupSet(tfname, fhash) {
            gConfirm('Confirm you want to delete target folder: "' + tfname + '"?', "", function (btn1) {

                if (btn1 != 'ok')
                    return;

                var hsid = document.getElementById("ctl00_MainContent_FolderHash");
                var btn = document.getElementById("ctl00_MainContent_DeleteTargetFolder");

                hsid.value = fhash;

                Wait('Applying');
                btn.click();
            });
        }
        function adjust() {

        }
        function OnRefresh() {
            var e = document.getElementById("ctl00_MainContent_RefreshBtn");


            Wait("...");
            e.click();

        }
        function OnBack() {
            location.href = "/management/backupmgr/ui/DeviceBackupDashboard.aspx" + location.search;
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize ID="LocNUMFol" meta:resourcekey="str_nUMFol" Visible="false" runat="server">[$NUM] Folder(s)</asp:Localize>
<asp:Localize ID="LocNotFou" meta:resourcekey="str_notFou" Visible="false" runat="server">not found</asp:Localize>
<asp:Localize ID="LocFaiToDelTarFol" meta:resourcekey="str_faiToDelTarFol" Visible="false" runat="server">Failed to delete target folder</asp:Localize>
<asp:Localize ID="LocMisPar" meta:resourcekey="str_misPar" runat="server" Visible="False">Missing parameter</asp:Localize>
    <div id="defaultcontent">
        <div style="width: 100%; padding: 5px; <% if (IsChildUi){ %>border-bottom: 1px solid #eeeeee; <% } %>" <% if (!IsChildUi)
            { %>class="meubardrop"
            <% } %>>
            <table style="width: 100%;">
                <tr>         
                    <td style="font-size: 16px; color: #565656; font-weight: 100; padding-left: 14px; padding:10px;">
                        <i class="gladinet-icons md-22 iconviewitemcolor hand center" style="margin-top:-4px;">&#x118;</i>
                        <asp:Label ID="FolderCounLable" runat="server" Text=""></asp:Label>
                    </td>
                    <td>
                        <asp:Label ID="ErrorMsg" runat="server" Text="" ForeColor="Red"></asp:Label>
                        
                    </td>
                    <td align="right" style="padding: 5px;">
                        <i class="gladinet-icons md-22 md-dark hand center toolbtn" style="line-height:22px;display: inline-block; margin-top: -3px; padding-right:10px;" title="<asp:Localize meta:resourcekey="str_bac" runat="server">Back</asp:Localize>"  onclick="OnBack();return false;">&#x00a6;</i>

                        <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="line-height:24px;display: inline-block; margin-top: -3px; padding-right:10px;" 
                            onclick="OnRefresh();"
                            title="Refresh">&#xB5;</i>

                        <i class="gladinet-icons md-dark hand center toolbtn" style="line-height:24px;padding: 3px; font-size: 24px!important; font-weight: 100!important; display: inline-block; margin-top: -3px;" 
                           onclick="OnAddTargetFolder();" title="Add Folder">&#xc8;</i>
                    </td>
                </tr>
            </table>
        </div>

        <div style="width: 100%; " id="page_3_div">
            <table style="width: 100%">
                <tr>
                    <td align="center" style="padding-top: 0px;">
                        <table style="width: 100%; ">
                            <tr>
                                <td colspan="2" style="padding-top: 0px;">
                                    <asp:Repeater ID="FoldersRepeater" runat="server">
                                        <ItemTemplate>
                                            <div style="border-bottom-width: 1px; border-bottom-style: solid; border-color: #f8f8f8; font-weight: 100; padding: 10px;" class="filerow">
                                                <table width="100%">
                                                    <tr>
                                                        <td style="width: 48px;" align="center" valign="middle">
                                                            <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: -3px;" title="Target Folder">#</i>
                                                        </td>
                                                        <td valign="middle" style="font-size: 16px; color: #202020;">
                                                            <%#DataBinder.Eval(Container.DataItem, "DisplayName")%> 
                                                        </td>
                                                        <td align="right" valign="middle">

                                                            <i class="gladinet-icons md-dark hand center toolbtn" style="padding: 3px; font-size: 16px!important; font-weight: 100!important; display: inline-block; margin-top: -3px;" title="Edit"
                                                                onclick='OnEditTargetFolder("<%#DataBinder.Eval(Container.DataItem, "DisplayName")%>", "<%#DataBinder.Eval(Container.DataItem, "FolderHash")%>");return false;'>c</i>
                                                            <i class="gladinet-icons md-dark hand center toolbtn" 
                                                                onclick='OnDeleteBackupSet("<%#DataBinder.Eval(Container.DataItem, "DisplayName")%>", "<%#DataBinder.Eval(Container.DataItem, "FolderHash")%>");return false;'
                                                                style="padding: 3px; font-size: 16px!important; font-weight: 100!important; display: inline-block; margin-top: -3px;" title="Delete">n</i>
                                                        </td>
                                                    </tr>
                                                    <td colspan="3" style="padding: 10px; padding-top: 0px;">

                                                        <a class="iconviewitemcolor" data-toggle="collapse" style="font-style: italic; font-size: 10px;" href="#Excluded-<%#DataBinder.Eval(Container.DataItem, "TargetId")%>" role="button" aria-expanded="false"><asp:Localize meta:resourcekey="str_excFol" runat="server">Excluded Folders</asp:Localize></a>


                                                        <div class="collapse" id="Excluded-<%#DataBinder.Eval(Container.DataItem, "TargetId")%>">
                                                            <table>
                                                                <asp:Repeater ID="ExclduedFoldersRepeater" runat="server" DataSource='<%# Eval("ExcludedFolderList") %>'>
                                                                    <ItemTemplate>
                                                                        <tr>
                                                                            <td width="48px" align="center" valign="middle">
                                                                                <i class="gladinet-icons " style="display: inline-block; margin-top: -3px; font-size: 16px; color: #565656;" title="Excluded Folder">#</i>
                                                                            </td>
                                                                            <td valign="middle" style="font-size: 12px; color: #565656;">
                                                                                <%#DataBinder.Eval(Container.DataItem, "FolderName")%>
                                                                            </td>
                                                                        </tr>
                                                                    </ItemTemplate>
                                                                </asp:Repeater>
                                                            </table>

                                                        </div>
                                                    </td>

                                                </table>
                                            </div>
                                        </ItemTemplate>
                                    </asp:Repeater>
                                </td>
                            </tr>
                        </table>
                        </td>
                </tr>
            </table>
        </div>

    </div>
    <div id="ShortWindowModal" class="modal fade" role="dialog" >
            <div class="modal-dialog " style="max-width:650px!important; width: 650px!important; padding:0px!important;">

                <!-- Modal content-->
                <div class="modal-content" style="padding:0px!important;">
                    <div class="modal-header" >
                        <h4 class="modal-title" style="color: #808080; " id="ShortTitle"></h4>
                        <button type="button" class="close" onclick="CloseChildWnd();">&times;</button>
                        
                    </div>
                    <div class="modal-body" style="height: 600px;padding-top:0px;padding:0px!important;" id="ShortBody">
                         <iframe id='ShortWindow' width="100%"  style="padding:0px;" src="/portal/WaitWin.htm"
        frameborder="0" border="0" height="100%"></iframe>
                    </div>
                </div>

            </div>
        </div>
    <div style="display: none">
        <asp:HiddenField ID="DeviceId" runat="server" />
        <asp:HiddenField ID="BackupSetId" runat="server" />
        <asp:HiddenField ID="FolderHash" runat="server" />
        <asp:LinkButton ID="RefreshBtn" runat="server" OnClick="RefreshBtn_Click">Refresh btn</asp:LinkButton>
        <asp:Panel ID="DailyPanel" runat="server"></asp:Panel>
        <asp:Panel ID="WeeklyPanel" runat="server"></asp:Panel>
        <asp:Panel ID="MonthlyPanel" runat="server"></asp:Panel>
        <asp:Panel ID="ConinuePanel" runat="server"></asp:Panel>
        <asp:LinkButton ID="DeleteTargetFolder" runat="server" OnClick="DeleteTargetFolder_Click">Delete Target Folder</asp:LinkButton>
        <asp:Localize runat="server" ID="LocEvrDay" meta:resourcekey="str_evrDay" Visible="false">Every Day</asp:Localize>
        <asp:Localize runat="server" ID="LocEvrWek" meta:resourcekey="str_evrWek" Visible="false">Every Week</asp:Localize>
        <asp:Localize runat="server" ID="LocEvrMth" meta:resourcekey="str_evrMth" Visible="false">Every Month</asp:Localize>
        <asp:Localize runat="server" ID="LocCty" meta:resourcekey="str_cty" Visible="false">Continuously</asp:Localize>
        <asp:Localize runat="server" ID="LocStd" meta:resourcekey="str_std" Visible="false">Saturday</asp:Localize>
        <asp:Localize runat="server" ID="LocSnd" meta:resourcekey="str_snd" Visible="false">Sunday</asp:Localize>
        <asp:Localize runat="server" ID="LocMnd" meta:resourcekey="str_mnd" Visible="false">Monday</asp:Localize>
        <asp:Localize runat="server" ID="LocTsd" meta:resourcekey="str_tsd" Visible="false">Tuesday</asp:Localize>
        <asp:Localize runat="server" ID="LocWnd" meta:resourcekey="str_wnd" Visible="false">Wednesday</asp:Localize>
        <asp:Localize runat="server" ID="LocTrd" meta:resourcekey="str_trd" Visible="false">Thursday</asp:Localize>
        <asp:Localize runat="server" ID="LocFrd" meta:resourcekey="str_frd" Visible="false">Friday</asp:Localize>
        <asp:Localize runat="server" ID="LocMts" meta:resourcekey="str_mts" Visible="false">Minutes</asp:Localize>
        <asp:Localize runat="server" ID="LocHrs" meta:resourcekey="str_hrs" Visible="false">Hours</asp:Localize>
    </div>

    <script type="text/javascript">
        function CloseChildWnd() {
            try {
                e = document.getElementById("ShortWindow");
                e.src = "/portal/WaitWin.htm";

                $('#ShortWindowModal').modal('hide');

            } catch (e) {

            }


        }

        function closeActiveWin() {
            OnRefresh();
        }

        function OpenChildWnd(t, s) {
            
            var e = document.getElementById("ShortTitle");
            e.innerHTML = t;
            e = document.getElementById("ShortBody");
            if (document.documentElement.clientHeight < 750)
                e.style.height = "400px"
            else
                e.style.height = "500px"
            
            e = document.getElementById("ShortWindow");
            e.src = s;
            $('#ShortWindowModal').modal({ backdrop: 'static', keyboard: false });

        }
        function closeCancelActiveWin() {
            CloseChildWnd();
        }

        function GetShortString(src, MaxLen) {
            if (src.length <= MaxLen)
                return src;
            src = src.replace('[BuiltInGroup]', '');
            if (src.length <= MaxLen)
                return src;
            var len = (MaxLen - 3) / 2;
            var p1 = src.substring(0, len);
            var p2 = src.substring(src.length - len);
            return p1 + "..." + p2;

        }

        function FormatFileSize(size) {
            var s = 0 + size;
            if (isNaN(s))
                return "0";
            if (size < 1024) { //pow(2,10)
                return size + " B";
            } else if (size < 1048576) { //pow(2,20)
                return (Math.round(((size * 10) / 1024)) / 10) + " KB";
            } else if (size < 1073741824) { //pow(2,30)
                return (Math.round(((size * 10) / 1048576)) / 10) + " MB";
            } else if (size < 1099511627776) { //pow(2,40)
                return (Math.round(((size * 100) / 1073741824)) / 100) + " GB";
            } else if (size < 1125899906842624) { //pow(2,50)
                return (Math.round(((size * 100) / 1099511627776)) / 100) + " TB";
            } else { //pow(2,60)
                return (Math.round(((size * 100) / 1125899906842624)) / 100) + " PB";
            }
        }
    </script>
</asp:Content>
